% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/resample(generic).R
\docType{methods}
\name{resample}
\alias{resample}
\alias{resample,data.frame-method}
\alias{resample,list-method}
\title{Resample your time series or ncdf files.}
\usage{
resample(data, method)

\S4method{resample}{data.frame}(data, method)

\S4method{resample}{list}(data, method)
}
\arguments{
\item{data}{a hyfo grid data or a time series, with first column date, and second column value. The date column should
follow the format in \code{as.Date}, i.e. seperate with "-" or "/". Check details for more information.}

\item{method}{A string showing whether you want to change a daily data to monthly data or monthly
data to daily data.e.g. "mon2day" and "day2mon".}
}
\value{
converted time series.
}
\description{
Resameple your time series or ncdf files, more info pleae see details.
}
\details{
Note, when you want to change daily data to monthly data, a new date column will be generated,
usually the date column will be the middle date of each month, 15th, or 16th. However, if your
time series doesn't start from the beginning of a month or ends to the end of a month, e.g.
from 1999-3-14 to 2008-2-2, the first and last generated date could be wrong. Not only the date, but also the data, because you are
not calculating based on a intact month.

It is a generic function, if in your case you need to debug, please see \code{?debug()}
for how to debug S4 method.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: 

\item \code{list}: 
}}
\examples{
# Daily to monthly
data(testdl)
TS <- testdl[[2]] # Get daily data
str(TS)
TS_new <- resample(TS, method = 'day2mon')

# Monthly to daily
TS <- data.frame(Date = seq(as.Date('1999-9-15'), length = 30, by = '1 month'),
runif(30, 3, 10))
TS_new <- resample(TS, method = 'mon2day')

#' # First load ncdf file.
filePath <- system.file("extdata", "tnc.nc", package = "hyfo")
varname <- getNcdfVar(filePath)
nc <- loadNcdf(filePath, varname)

nc_new <- resample(nc, 'day2mon')


# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}
\references{
\itemize{
\item R Core Team (2015). R: A language and environment for statistical computing. R Foundation for
Statistical Computing, Vienna, Austria. URL http://www.R-project.org/.
}
}

