% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getSpatialMap.R
\name{getSpatialMap}
\alias{getSpatialMap}
\title{Get spatial map of the input dataset.}
\usage{
getSpatialMap(dataset, method = NULL, member = "mean", ...)
}
\arguments{
\item{dataset}{A list containing different information, should be the result of reading netcdf file using
\code{loadNcdf}.}

\item{method}{A string showing different calculating method for the map. More information please refer to
details.}

\item{member}{A number showing which member is selected to get, if the dataset has a "member" dimension. Default
is NULL, if no member assigned, and there is a "member" in dimensions, the mean value of the members will be
taken.}

\item{...}{several arguments including x, y, title, catchment, point, output, name, info, scale, color,
type in \code{?getSpatialMap_mat} for details.}
}
\value{
A matrix representing the raster map is returned, and the map is plotted.
}
\description{
Get spatial map of the input dataset.
}
\details{
There are following methods to be selected,
"meanAnnual": annual rainfall of each year is plotted.
"winter", "spring", "autumn", "summer": MEAN seasonal rainfall of each year is plotted.
Month(number 1 to 12): MEAN month rainfall of each year is plotted, e.g. MEAN march rainfall of each year.
"mean", "max", "min": mean daily, maximum daily, minimum daily precipitation.
}
\examples{
\dontrun{
#gridData provided in the package is the result of \\code {loadNcdf}
data(tgridData)
getSpatialMap(tgridData, method = 'meanAnnual')
getSpatialMap(tgridData, method = 'winter')


getSpatialMap(tgridData, method = 'winter', catchment = testCat)

file <- system.file("extdata", "point.txt", package = "hyfo")
point <- read.table(file, header = TRUE, sep = ',' )
getSpatialMap(tgridData, method = 'winter', catchment = testCat, point = point)
}


# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}

