% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_levelpaths.R
\name{add_levelpaths}
\alias{add_levelpaths}
\alias{add_levelpaths.data.frame}
\alias{add_levelpaths.hy}
\title{Add Level Paths}
\usage{
add_levelpaths(
  x,
  name_attribute,
  weight_attribute,
  override_factor = NULL,
  status = FALSE
)

\method{add_levelpaths}{data.frame}(
  x,
  name_attribute,
  weight_attribute,
  override_factor = NULL,
  status = FALSE
)

\method{add_levelpaths}{hy}(
  x,
  name_attribute,
  weight_attribute,
  override_factor = NULL,
  status = FALSE
)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{name_attribute}{character attribute to be used as name identifiers.}

\item{weight_attribute}{character attribute to be used as weight.}

\item{override_factor}{numeric multiplier to use to override \code{name_attribute}.
See details.}

\item{status}{boolean if status updates should be printed.}
}
\value{
data.frame with id, levelpath_outlet_id, topo_sort, and levelpath columns.
See details for more info.
}
\description{
Assigns level paths using the stream-leveling approach of
NHD and NHDPlus. If arbolate sum is provided in the weight column, this
will match the behavior of NHDPlus. Any numeric value can be
included in this column and the largest value will be followed when
no nameid is available.
}
\details{
The levelpath algorithm defines upstream mainstem paths through a network.
At a given junction with two or more upstream flowpaths, the main path is
either 1) the path with the same name, 2) the path with any name, 3) or the
path with the larger weight. If the \code{weight_attribute} is \code{override_factor}
times larger on a path, it will be followed regardless of the name_attribute
indication.
}
\examples{
g <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

test_flowline <- add_toids(g)

# use NHDPlus attributes directly
add_levelpaths(test_flowline,
               name_attribute = "GNIS_ID",
               weight_attribute = "ArbolateSu")

# use hy attributes where they can be mapped
add_levelpaths(hy(test_flowline),
               name_attribute = "GNIS_ID",
               weight_attribute = "arbolate_sum")

}
