% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_path_helpers.R
\name{set_local_path}
\alias{set_local_path}
\title{Set local files path}
\usage{
set_local_path(path = NULL)
}
\arguments{
\item{path}{character path to new local files path. If null, path will be
reset to default user data directory location.}
}
\description{
Set location of local data file cache. If the directory does not exist, it
will be created recursively. If no custom path is set, the
default user data directory for the package will be used. See
\code{\link[rappdirs]{user_data_dir}} for details.
}
\examples{
\dontrun{
  #set a different cache path
  set_cache_path('z:/big_datasets/hydrolinks')

}

}
\seealso{
\code{\link{local_path}}
}
