% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darcy_weisbach.R
\name{darcyweisbach}
\alias{darcyweisbach}
\title{Solves the Darcy-Weisbach Equation for the either head loss (hf),
flow rate (Q), diameter (D), or roughness height (ks).}
\usage{
darcyweisbach(
  Q = NULL,
  D = NULL,
  hf = NULL,
  L = NULL,
  ks = NULL,
  nu = NULL,
  units = c("SI", "Eng"),
  ret_units = FALSE
)
}
\arguments{
\item{Q}{numeric vector that contains the flow rate [\eqn{m^3 s^{-1}}{m^3/s} or \eqn{ft^3 s^{-1}}{ft^3/s}]}

\item{D}{numeric vector that contains the pipe diameter [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{hf}{numeric vector that contains the head loss through the pipe section [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{L}{numeric vector that contains the pipe length [\eqn{m}{m} or \eqn{ft}{ft}],}

\item{ks}{numeric vector that contains the equivalent sand roughness height.
Units should be consistent with other input [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{nu}{numeric vector that contains the kinematic viscosity of water,
[\eqn{m^2 s^{-1}}{m^2/s} or \eqn{ft^2 s^{-1}}{ft^2/s}].}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package}

\item{ret_units}{If set to TRUE the value(s) returned are of class \code{units} with
units attached to the value. [Default is FALSE]}
}
\value{
Returns a list including the missing parameter (hf, Q, D, or ks):
\itemize{
  \item Q - flow rate.
  \item V - flow velocity.
  \item L - pipe length.
  \item hf - head loss due to friction
  \item f - Darcy-Weisbach friction factor
  \item ks - roughness height
  \item Re - Reynolds number
}
}
\description{
This function solves the Darcy-Weisbach friction loss equation
for with water in circular pipes. the function solves for
either head loss (hf), flow rate (Q), diameter (D),or roughness height,
(ks) whichever is missing (not included as an argument).
}
\details{
The Darcy-Weisbach equation was developed to estimate the head loss, \eqn{h_f}, due to friction over 
a length of pipe. For circular pipes it is expressed as: 
\deqn{h_f = \frac{fL}{D}\frac{V^2}{2g} = \frac{8fL}{\pi^{2}gD^{5}}Q^{2}}
where \eqn{f} is the friction factor (calculated with the \code{colebrook} function and \eqn{g}
is the gravitational acceleration (\eqn{9.81\frac{m}{s^2}} or \eqn{32.2\frac{ft}{s^2}}).
}
\examples{

#Type 2 (solving for flow rate, Q): SI Units
D <- .5
L <- 10
hf <- 0.006*L
T <- 20
ks <- 0.000046
darcyweisbach(D = D, hf = hf, L = L, ks = ks, nu = kvisc(T=T, units='SI'), units = c('SI'))

#Type 3 (solving for diameter, D): Eng (US) units
Q <- 37.5     #flow in ft^3/s
L <- 8000     #pipe length in ft
hf <- 215     #head loss due to friction, in ft
T <- 68       #water temperature, F
ks <- 0.0008  #pipe roughness, ft
darcyweisbach(Q = Q, hf = hf, L = L, ks = ks, nu = kvisc(T=T, units='Eng'), units = c('Eng'))

}
\seealso{
\code{\link{colebrook}} for friction factor calculation
}
