/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Hunspell, based on MySpell.
 *
 * The Initial Developers of the Original Code are
 * Kevin Hendricks (MySpell) and Németh László (Hunspell).
 * Portions created by the Initial Developers are Copyright (C) 2002-2005
 * the Initial Developers. All Rights Reserved.
 *
 * Contributor(s): David Einstein, Davide Prina, Giuseppe Modugno,
 * Gianluca Turconi, Simon Brouwer, Noll János, Bíró Árpád,
 * Goldman Eleonóra, Sarlós Tamás, Bencsáth Boldizsár, Halácsy Péter,
 * Dvornik László, Gefferth András, Nagy Viktor, Varga Dániel, Chris Halls,
 * Rene Engelhard, Bram Moolenaar, Dafydd Jones, Harri Pitkänen
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "csutil.hxx"
/* fields: Unicode letter, toupper, tolower */
static struct unicode_info utf_lst[] = {
    {0x0041, 0x0041, 0x0061}, {0x0042, 0x0042, 0x0062},
    {0x0043, 0x0043, 0x0063}, {0x0044, 0x0044, 0x0064},
    {0x0045, 0x0045, 0x0065}, {0x0046, 0x0046, 0x0066},
    {0x0047, 0x0047, 0x0067}, {0x0048, 0x0048, 0x0068},
    {0x0049, 0x0049, 0x0069}, {0x004A, 0x004A, 0x006A},
    {0x004B, 0x004B, 0x006B}, {0x004C, 0x004C, 0x006C},
    {0x004D, 0x004D, 0x006D}, {0x004E, 0x004E, 0x006E},
    {0x004F, 0x004F, 0x006F}, {0x0050, 0x0050, 0x0070},
    {0x0051, 0x0051, 0x0071}, {0x0052, 0x0052, 0x0072},
    {0x0053, 0x0053, 0x0073}, {0x0054, 0x0054, 0x0074},
    {0x0055, 0x0055, 0x0075}, {0x0056, 0x0056, 0x0076},
    {0x0057, 0x0057, 0x0077}, {0x0058, 0x0058, 0x0078},
    {0x0059, 0x0059, 0x0079}, {0x005A, 0x005A, 0x007A},
    {0x0061, 0x0041, 0x0061}, {0x0062, 0x0042, 0x0062},
    {0x0063, 0x0043, 0x0063}, {0x0064, 0x0044, 0x0064},
    {0x0065, 0x0045, 0x0065}, {0x0066, 0x0046, 0x0066},
    {0x0067, 0x0047, 0x0067}, {0x0068, 0x0048, 0x0068},
    {0x0069, 0x0049, 0x0069}, {0x006A, 0x004A, 0x006A},
    {0x006B, 0x004B, 0x006B}, {0x006C, 0x004C, 0x006C},
    {0x006D, 0x004D, 0x006D}, {0x006E, 0x004E, 0x006E},
    {0x006F, 0x004F, 0x006F}, {0x0070, 0x0050, 0x0070},
    {0x0071, 0x0051, 0x0071}, {0x0072, 0x0052, 0x0072},
    {0x0073, 0x0053, 0x0073}, {0x0074, 0x0054, 0x0074},
    {0x0075, 0x0055, 0x0075}, {0x0076, 0x0056, 0x0076},
    {0x0077, 0x0057, 0x0077}, {0x0078, 0x0058, 0x0078},
    {0x0079, 0x0059, 0x0079}, {0x007A, 0x005A, 0x007A},
    {0x00AA, 0x00AA, 0x00AA}, {0x00B5, 0x039C, 0x00B5},
    {0x00BA, 0x00BA, 0x00BA}, {0x00C0, 0x00C0, 0x00E0},
    {0x00C1, 0x00C1, 0x00E1}, {0x00C2, 0x00C2, 0x00E2},
    {0x00C3, 0x00C3, 0x00E3}, {0x00C4, 0x00C4, 0x00E4},
    {0x00C5, 0x00C5, 0x00E5}, {0x00C6, 0x00C6, 0x00E6},
    {0x00C7, 0x00C7, 0x00E7}, {0x00C8, 0x00C8, 0x00E8},
    {0x00C9, 0x00C9, 0x00E9}, {0x00CA, 0x00CA, 0x00EA},
    {0x00CB, 0x00CB, 0x00EB}, {0x00CC, 0x00CC, 0x00EC},
    {0x00CD, 0x00CD, 0x00ED}, {0x00CE, 0x00CE, 0x00EE},
    {0x00CF, 0x00CF, 0x00EF}, {0x00D0, 0x00D0, 0x00F0},
    {0x00D1, 0x00D1, 0x00F1}, {0x00D2, 0x00D2, 0x00F2},
    {0x00D3, 0x00D3, 0x00F3}, {0x00D4, 0x00D4, 0x00F4},
    {0x00D5, 0x00D5, 0x00F5}, {0x00D6, 0x00D6, 0x00F6},
    {0x00D8, 0x00D8, 0x00F8}, {0x00D9, 0x00D9, 0x00F9},
    {0x00DA, 0x00DA, 0x00FA}, {0x00DB, 0x00DB, 0x00FB},
    {0x00DC, 0x00DC, 0x00FC}, {0x00DD, 0x00DD, 0x00FD},
    {0x00DE, 0x00DE, 0x00FE}, {0x00DF, 0x00DF, 0x00DF},
    {0x00E0, 0x00C0, 0x00E0}, {0x00E1, 0x00C1, 0x00E1},
    {0x00E2, 0x00C2, 0x00E2}, {0x00E3, 0x00C3, 0x00E3},
    {0x00E4, 0x00C4, 0x00E4}, {0x00E5, 0x00C5, 0x00E5},
    {0x00E6, 0x00C6, 0x00E6}, {0x00E7, 0x00C7, 0x00E7},
    {0x00E8, 0x00C8, 0x00E8}, {0x00E9, 0x00C9, 0x00E9},
    {0x00EA, 0x00CA, 0x00EA}, {0x00EB, 0x00CB, 0x00EB},
    {0x00EC, 0x00CC, 0x00EC}, {0x00ED, 0x00CD, 0x00ED},
    {0x00EE, 0x00CE, 0x00EE}, {0x00EF, 0x00CF, 0x00EF},
    {0x00F0, 0x00D0, 0x00F0}, {0x00F1, 0x00D1, 0x00F1},
    {0x00F2, 0x00D2, 0x00F2}, {0x00F3, 0x00D3, 0x00F3},
    {0x00F4, 0x00D4, 0x00F4}, {0x00F5, 0x00D5, 0x00F5},
    {0x00F6, 0x00D6, 0x00F6}, {0x00F8, 0x00D8, 0x00F8},
    {0x00F9, 0x00D9, 0x00F9}, {0x00FA, 0x00DA, 0x00FA},
    {0x00FB, 0x00DB, 0x00FB}, {0x00FC, 0x00DC, 0x00FC},
    {0x00FD, 0x00DD, 0x00FD}, {0x00FE, 0x00DE, 0x00FE},
    {0x00FF, 0x0178, 0x00FF}, {0x0100, 0x0100, 0x0101},
    {0x0101, 0x0100, 0x0101}, {0x0102, 0x0102, 0x0103},
    {0x0103, 0x0102, 0x0103}, {0x0104, 0x0104, 0x0105},
    {0x0105, 0x0104, 0x0105}, {0x0106, 0x0106, 0x0107},
    {0x0107, 0x0106, 0x0107}, {0x0108, 0x0108, 0x0109},
    {0x0109, 0x0108, 0x0109}, {0x010A, 0x010A, 0x010B},
    {0x010B, 0x010A, 0x010B}, {0x010C, 0x010C, 0x010D},
    {0x010D, 0x010C, 0x010D}, {0x010E, 0x010E, 0x010F},
    {0x010F, 0x010E, 0x010F}, {0x0110, 0x0110, 0x0111},
    {0x0111, 0x0110, 0x0111}, {0x0112, 0x0112, 0x0113},
    {0x0113, 0x0112, 0x0113}, {0x0114, 0x0114, 0x0115},
    {0x0115, 0x0114, 0x0115}, {0x0116, 0x0116, 0x0117},
    {0x0117, 0x0116, 0x0117}, {0x0118, 0x0118, 0x0119},
    {0x0119, 0x0118, 0x0119}, {0x011A, 0x011A, 0x011B},
    {0x011B, 0x011A, 0x011B}, {0x011C, 0x011C, 0x011D},
    {0x011D, 0x011C, 0x011D}, {0x011E, 0x011E, 0x011F},
    {0x011F, 0x011E, 0x011F}, {0x0120, 0x0120, 0x0121},
    {0x0121, 0x0120, 0x0121}, {0x0122, 0x0122, 0x0123},
    {0x0123, 0x0122, 0x0123}, {0x0124, 0x0124, 0x0125},
    {0x0125, 0x0124, 0x0125}, {0x0126, 0x0126, 0x0127},
    {0x0127, 0x0126, 0x0127}, {0x0128, 0x0128, 0x0129},
    {0x0129, 0x0128, 0x0129}, {0x012A, 0x012A, 0x012B},
    {0x012B, 0x012A, 0x012B}, {0x012C, 0x012C, 0x012D},
    {0x012D, 0x012C, 0x012D}, {0x012E, 0x012E, 0x012F},
    {0x012F, 0x012E, 0x012F}, {0x0130, 0x0130, 0x0069},
    {0x0131, 0x0049, 0x0131}, {0x0132, 0x0132, 0x0133},
    {0x0133, 0x0132, 0x0133}, {0x0134, 0x0134, 0x0135},
    {0x0135, 0x0134, 0x0135}, {0x0136, 0x0136, 0x0137},
    {0x0137, 0x0136, 0x0137}, {0x0138, 0x0138, 0x0138},
    {0x0139, 0x0139, 0x013A}, {0x013A, 0x0139, 0x013A},
    {0x013B, 0x013B, 0x013C}, {0x013C, 0x013B, 0x013C},
    {0x013D, 0x013D, 0x013E}, {0x013E, 0x013D, 0x013E},
    {0x013F, 0x013F, 0x0140}, {0x0140, 0x013F, 0x0140},
    {0x0141, 0x0141, 0x0142}, {0x0142, 0x0141, 0x0142},
    {0x0143, 0x0143, 0x0144}, {0x0144, 0x0143, 0x0144},
    {0x0145, 0x0145, 0x0146}, {0x0146, 0x0145, 0x0146},
    {0x0147, 0x0147, 0x0148}, {0x0148, 0x0147, 0x0148},
    {0x0149, 0x0149, 0x0149}, {0x014A, 0x014A, 0x014B},
    {0x014B, 0x014A, 0x014B}, {0x014C, 0x014C, 0x014D},
    {0x014D, 0x014C, 0x014D}, {0x014E, 0x014E, 0x014F},
    {0x014F, 0x014E, 0x014F}, {0x0150, 0x0150, 0x0151},
    {0x0151, 0x0150, 0x0151}, {0x0152, 0x0152, 0x0153},
    {0x0153, 0x0152, 0x0153}, {0x0154, 0x0154, 0x0155},
    {0x0155, 0x0154, 0x0155}, {0x0156, 0x0156, 0x0157},
    {0x0157, 0x0156, 0x0157}, {0x0158, 0x0158, 0x0159},
    {0x0159, 0x0158, 0x0159}, {0x015A, 0x015A, 0x015B},
    {0x015B, 0x015A, 0x015B}, {0x015C, 0x015C, 0x015D},
    {0x015D, 0x015C, 0x015D}, {0x015E, 0x015E, 0x015F},
    {0x015F, 0x015E, 0x015F}, {0x0160, 0x0160, 0x0161},
    {0x0161, 0x0160, 0x0161}, {0x0162, 0x0162, 0x0163},
    {0x0163, 0x0162, 0x0163}, {0x0164, 0x0164, 0x0165},
    {0x0165, 0x0164, 0x0165}, {0x0166, 0x0166, 0x0167},
    {0x0167, 0x0166, 0x0167}, {0x0168, 0x0168, 0x0169},
    {0x0169, 0x0168, 0x0169}, {0x016A, 0x016A, 0x016B},
    {0x016B, 0x016A, 0x016B}, {0x016C, 0x016C, 0x016D},
    {0x016D, 0x016C, 0x016D}, {0x016E, 0x016E, 0x016F},
    {0x016F, 0x016E, 0x016F}, {0x0170, 0x0170, 0x0171},
    {0x0171, 0x0170, 0x0171}, {0x0172, 0x0172, 0x0173},
    {0x0173, 0x0172, 0x0173}, {0x0174, 0x0174, 0x0175},
    {0x0175, 0x0174, 0x0175}, {0x0176, 0x0176, 0x0177},
    {0x0177, 0x0176, 0x0177}, {0x0178, 0x0178, 0x00FF},
    {0x0179, 0x0179, 0x017A}, {0x017A, 0x0179, 0x017A},
    {0x017B, 0x017B, 0x017C}, {0x017C, 0x017B, 0x017C},
    {0x017D, 0x017D, 0x017E}, {0x017E, 0x017D, 0x017E},
    {0x017F, 0x0053, 0x017F}, {0x0180, 0x0180, 0x0180},
    {0x0181, 0x0181, 0x0253}, {0x0182, 0x0182, 0x0183},
    {0x0183, 0x0182, 0x0183}, {0x0184, 0x0184, 0x0185},
    {0x0185, 0x0184, 0x0185}, {0x0186, 0x0186, 0x0254},
    {0x0187, 0x0187, 0x0188}, {0x0188, 0x0187, 0x0188},
    {0x0189, 0x0189, 0x0256}, {0x018A, 0x018A, 0x0257},
    {0x018B, 0x018B, 0x018C}, {0x018C, 0x018B, 0x018C},
    {0x018D, 0x018D, 0x018D}, {0x018E, 0x018E, 0x01DD},
    {0x018F, 0x018F, 0x0259}, {0x0190, 0x0190, 0x025B},
    {0x0191, 0x0191, 0x0192}, {0x0192, 0x0191, 0x0192},
    {0x0193, 0x0193, 0x0260}, {0x0194, 0x0194, 0x0263},
    {0x0195, 0x01F6, 0x0195}, {0x0196, 0x0196, 0x0269},
    {0x0197, 0x0197, 0x0268}, {0x0198, 0x0198, 0x0199},
    {0x0199, 0x0198, 0x0199}, {0x019A, 0x023D, 0x019A},
    {0x019B, 0x019B, 0x019B}, {0x019C, 0x019C, 0x026F},
    {0x019D, 0x019D, 0x0272}, {0x019E, 0x0220, 0x019E},
    {0x019F, 0x019F, 0x0275}, {0x01A0, 0x01A0, 0x01A1},
    {0x01A1, 0x01A0, 0x01A1}, {0x01A2, 0x01A2, 0x01A3},
    {0x01A3, 0x01A2, 0x01A3}, {0x01A4, 0x01A4, 0x01A5},
    {0x01A5, 0x01A4, 0x01A5}, {0x01A6, 0x01A6, 0x0280},
    {0x01A7, 0x01A7, 0x01A8}, {0x01A8, 0x01A7, 0x01A8},
    {0x01A9, 0x01A9, 0x0283}, {0x01AA, 0x01AA, 0x01AA},
    {0x01AB, 0x01AB, 0x01AB}, {0x01AC, 0x01AC, 0x01AD},
    {0x01AD, 0x01AC, 0x01AD}, {0x01AE, 0x01AE, 0x0288},
    {0x01AF, 0x01AF, 0x01B0}, {0x01B0, 0x01AF, 0x01B0},
    {0x01B1, 0x01B1, 0x028A}, {0x01B2, 0x01B2, 0x028B},
    {0x01B3, 0x01B3, 0x01B4}, {0x01B4, 0x01B3, 0x01B4},
    {0x01B5, 0x01B5, 0x01B6}, {0x01B6, 0x01B5, 0x01B6},
    {0x01B7, 0x01B7, 0x0292}, {0x01B8, 0x01B8, 0x01B9},
    {0x01B9, 0x01B8, 0x01B9}, {0x01BA, 0x01BA, 0x01BA},
    {0x01BB, 0x01BB, 0x01BB}, {0x01BC, 0x01BC, 0x01BD},
    {0x01BD, 0x01BC, 0x01BD}, {0x01BE, 0x01BE, 0x01BE},
    {0x01BF, 0x01F7, 0x01BF}, {0x01C0, 0x01C0, 0x01C0},
    {0x01C1, 0x01C1, 0x01C1}, {0x01C2, 0x01C2, 0x01C2},
    {0x01C3, 0x01C3, 0x01C3}, {0x01C4, 0x01C4, 0x01C6},
    {0x01C5, 0x01C4, 0x01C6}, {0x01C6, 0x01C4, 0x01C6},
    {0x01C7, 0x01C7, 0x01C9}, {0x01C8, 0x01C7, 0x01C9},
    {0x01C9, 0x01C7, 0x01C9}, {0x01CA, 0x01CA, 0x01CC},
    {0x01CB, 0x01CA, 0x01CC}, {0x01CC, 0x01CA, 0x01CC},
    {0x01CD, 0x01CD, 0x01CE}, {0x01CE, 0x01CD, 0x01CE},
    {0x01CF, 0x01CF, 0x01D0}, {0x01D0, 0x01CF, 0x01D0},
    {0x01D1, 0x01D1, 0x01D2}, {0x01D2, 0x01D1, 0x01D2},
    {0x01D3, 0x01D3, 0x01D4}, {0x01D4, 0x01D3, 0x01D4},
    {0x01D5, 0x01D5, 0x01D6}, {0x01D6, 0x01D5, 0x01D6},
    {0x01D7, 0x01D7, 0x01D8}, {0x01D8, 0x01D7, 0x01D8},
    {0x01D9, 0x01D9, 0x01DA}, {0x01DA, 0x01D9, 0x01DA},
    {0x01DB, 0x01DB, 0x01DC}, {0x01DC, 0x01DB, 0x01DC},
    {0x01DD, 0x018E, 0x01DD}, {0x01DE, 0x01DE, 0x01DF},
    {0x01DF, 0x01DE, 0x01DF}, {0x01E0, 0x01E0, 0x01E1},
    {0x01E1, 0x01E0, 0x01E1}, {0x01E2, 0x01E2, 0x01E3},
    {0x01E3, 0x01E2, 0x01E3}, {0x01E4, 0x01E4, 0x01E5},
    {0x01E5, 0x01E4, 0x01E5}, {0x01E6, 0x01E6, 0x01E7},
    {0x01E7, 0x01E6, 0x01E7}, {0x01E8, 0x01E8, 0x01E9},
    {0x01E9, 0x01E8, 0x01E9}, {0x01EA, 0x01EA, 0x01EB},
    {0x01EB, 0x01EA, 0x01EB}, {0x01EC, 0x01EC, 0x01ED},
    {0x01ED, 0x01EC, 0x01ED}, {0x01EE, 0x01EE, 0x01EF},
    {0x01EF, 0x01EE, 0x01EF}, {0x01F0, 0x01F0, 0x01F0},
    {0x01F1, 0x01F1, 0x01F3}, {0x01F2, 0x01F1, 0x01F3},
    {0x01F3, 0x01F1, 0x01F3}, {0x01F4, 0x01F4, 0x01F5},
    {0x01F5, 0x01F4, 0x01F5}, {0x01F6, 0x01F6, 0x0195},
    {0x01F7, 0x01F7, 0x01BF}, {0x01F8, 0x01F8, 0x01F9},
    {0x01F9, 0x01F8, 0x01F9}, {0x01FA, 0x01FA, 0x01FB},
    {0x01FB, 0x01FA, 0x01FB}, {0x01FC, 0x01FC, 0x01FD},
    {0x01FD, 0x01FC, 0x01FD}, {0x01FE, 0x01FE, 0x01FF},
    {0x01FF, 0x01FE, 0x01FF}, {0x0200, 0x0200, 0x0201},
    {0x0201, 0x0200, 0x0201}, {0x0202, 0x0202, 0x0203},
    {0x0203, 0x0202, 0x0203}, {0x0204, 0x0204, 0x0205},
    {0x0205, 0x0204, 0x0205}, {0x0206, 0x0206, 0x0207},
    {0x0207, 0x0206, 0x0207}, {0x0208, 0x0208, 0x0209},
    {0x0209, 0x0208, 0x0209}, {0x020A, 0x020A, 0x020B},
    {0x020B, 0x020A, 0x020B}, {0x020C, 0x020C, 0x020D},
    {0x020D, 0x020C, 0x020D}, {0x020E, 0x020E, 0x020F},
    {0x020F, 0x020E, 0x020F}, {0x0210, 0x0210, 0x0211},
    {0x0211, 0x0210, 0x0211}, {0x0212, 0x0212, 0x0213},
    {0x0213, 0x0212, 0x0213}, {0x0214, 0x0214, 0x0215},
    {0x0215, 0x0214, 0x0215}, {0x0216, 0x0216, 0x0217},
    {0x0217, 0x0216, 0x0217}, {0x0218, 0x0218, 0x0219},
    {0x0219, 0x0218, 0x0219}, {0x021A, 0x021A, 0x021B},
    {0x021B, 0x021A, 0x021B}, {0x021C, 0x021C, 0x021D},
    {0x021D, 0x021C, 0x021D}, {0x021E, 0x021E, 0x021F},
    {0x021F, 0x021E, 0x021F}, {0x0220, 0x0220, 0x019E},
    {0x0221, 0x0221, 0x0221}, {0x0222, 0x0222, 0x0223},
    {0x0223, 0x0222, 0x0223}, {0x0224, 0x0224, 0x0225},
    {0x0225, 0x0224, 0x0225}, {0x0226, 0x0226, 0x0227},
    {0x0227, 0x0226, 0x0227}, {0x0228, 0x0228, 0x0229},
    {0x0229, 0x0228, 0x0229}, {0x022A, 0x022A, 0x022B},
    {0x022B, 0x022A, 0x022B}, {0x022C, 0x022C, 0x022D},
    {0x022D, 0x022C, 0x022D}, {0x022E, 0x022E, 0x022F},
    {0x022F, 0x022E, 0x022F}, {0x0230, 0x0230, 0x0231},
    {0x0231, 0x0230, 0x0231}, {0x0232, 0x0232, 0x0233},
    {0x0233, 0x0232, 0x0233}, {0x0234, 0x0234, 0x0234},
    {0x0235, 0x0235, 0x0235}, {0x0236, 0x0236, 0x0236},
    {0x0237, 0x0237, 0x0237}, {0x0238, 0x0238, 0x0238},
    {0x0239, 0x0239, 0x0239}, {0x023A, 0x023A, 0x023A},
    {0x023B, 0x023B, 0x023C}, {0x023C, 0x023B, 0x023C},
    {0x023D, 0x023D, 0x019A}, {0x023E, 0x023E, 0x023E},
    {0x023F, 0x023F, 0x023F}, {0x0240, 0x0240, 0x0240},
    {0x0241, 0x0241, 0x0294}, {0x0250, 0x0250, 0x0250},
    {0x0251, 0x0251, 0x0251}, {0x0252, 0x0252, 0x0252},
    {0x0253, 0x0181, 0x0253}, {0x0254, 0x0186, 0x0254},
    {0x0255, 0x0255, 0x0255}, {0x0256, 0x0189, 0x0256},
    {0x0257, 0x018A, 0x0257}, {0x0258, 0x0258, 0x0258},
    {0x0259, 0x018F, 0x0259}, {0x025A, 0x025A, 0x025A},
    {0x025B, 0x0190, 0x025B}, {0x025C, 0x025C, 0x025C},
    {0x025D, 0x025D, 0x025D}, {0x025E, 0x025E, 0x025E},
    {0x025F, 0x025F, 0x025F}, {0x0260, 0x0193, 0x0260},
    {0x0261, 0x0261, 0x0261}, {0x0262, 0x0262, 0x0262},
    {0x0263, 0x0194, 0x0263}, {0x0264, 0x0264, 0x0264},
    {0x0265, 0x0265, 0x0265}, {0x0266, 0x0266, 0x0266},
    {0x0267, 0x0267, 0x0267}, {0x0268, 0x0197, 0x0268},
    {0x0269, 0x0196, 0x0269}, {0x026A, 0x026A, 0x026A},
    {0x026B, 0x026B, 0x026B}, {0x026C, 0x026C, 0x026C},
    {0x026D, 0x026D, 0x026D}, {0x026E, 0x026E, 0x026E},
    {0x026F, 0x019C, 0x026F}, {0x0270, 0x0270, 0x0270},
    {0x0271, 0x0271, 0x0271}, {0x0272, 0x019D, 0x0272},
    {0x0273, 0x0273, 0x0273}, {0x0274, 0x0274, 0x0274},
    {0x0275, 0x019F, 0x0275}, {0x0276, 0x0276, 0x0276},
    {0x0277, 0x0277, 0x0277}, {0x0278, 0x0278, 0x0278},
    {0x0279, 0x0279, 0x0279}, {0x027A, 0x027A, 0x027A},
    {0x027B, 0x027B, 0x027B}, {0x027C, 0x027C, 0x027C},
    {0x027D, 0x027D, 0x027D}, {0x027E, 0x027E, 0x027E},
    {0x027F, 0x027F, 0x027F}, {0x0280, 0x01A6, 0x0280},
    {0x0281, 0x0281, 0x0281}, {0x0282, 0x0282, 0x0282},
    {0x0283, 0x01A9, 0x0283}, {0x0284, 0x0284, 0x0284},
    {0x0285, 0x0285, 0x0285}, {0x0286, 0x0286, 0x0286},
    {0x0287, 0x0287, 0x0287}, {0x0288, 0x01AE, 0x0288},
    {0x0289, 0x0289, 0x0289}, {0x028A, 0x01B1, 0x028A},
    {0x028B, 0x01B2, 0x028B}, {0x028C, 0x028C, 0x028C},
    {0x028D, 0x028D, 0x028D}, {0x028E, 0x028E, 0x028E},
    {0x028F, 0x028F, 0x028F}, {0x0290, 0x0290, 0x0290},
    {0x0291, 0x0291, 0x0291}, {0x0292, 0x01B7, 0x0292},
    {0x0293, 0x0293, 0x0293}, {0x0294, 0x0241, 0x0294},
    {0x0295, 0x0295, 0x0295}, {0x0296, 0x0296, 0x0296},
    {0x0297, 0x0297, 0x0297}, {0x0298, 0x0298, 0x0298},
    {0x0299, 0x0299, 0x0299}, {0x029A, 0x029A, 0x029A},
    {0x029B, 0x029B, 0x029B}, {0x029C, 0x029C, 0x029C},
    {0x029D, 0x029D, 0x029D}, {0x029E, 0x029E, 0x029E},
    {0x029F, 0x029F, 0x029F}, {0x02A0, 0x02A0, 0x02A0},
    {0x02A1, 0x02A1, 0x02A1}, {0x02A2, 0x02A2, 0x02A2},
    {0x02A3, 0x02A3, 0x02A3}, {0x02A4, 0x02A4, 0x02A4},
    {0x02A5, 0x02A5, 0x02A5}, {0x02A6, 0x02A6, 0x02A6},
    {0x02A7, 0x02A7, 0x02A7}, {0x02A8, 0x02A8, 0x02A8},
    {0x02A9, 0x02A9, 0x02A9}, {0x02AA, 0x02AA, 0x02AA},
    {0x02AB, 0x02AB, 0x02AB}, {0x02AC, 0x02AC, 0x02AC},
    {0x02AD, 0x02AD, 0x02AD}, {0x02AE, 0x02AE, 0x02AE},
    {0x02AF, 0x02AF, 0x02AF}, {0x02B0, 0x02B0, 0x02B0},
    {0x02B1, 0x02B1, 0x02B1}, {0x02B2, 0x02B2, 0x02B2},
    {0x02B3, 0x02B3, 0x02B3}, {0x02B4, 0x02B4, 0x02B4},
    {0x02B5, 0x02B5, 0x02B5}, {0x02B6, 0x02B6, 0x02B6},
    {0x02B7, 0x02B7, 0x02B7}, {0x02B8, 0x02B8, 0x02B8},
    {0x02B9, 0x02B9, 0x02B9}, {0x02BA, 0x02BA, 0x02BA},
    {0x02BB, 0x02BB, 0x02BB}, {0x02BC, 0x02BC, 0x02BC},
    {0x02BD, 0x02BD, 0x02BD}, {0x02BE, 0x02BE, 0x02BE},
    {0x02BF, 0x02BF, 0x02BF}, {0x02C0, 0x02C0, 0x02C0},
    {0x02C1, 0x02C1, 0x02C1}, {0x02C6, 0x02C6, 0x02C6},
    {0x02C7, 0x02C7, 0x02C7}, {0x02C8, 0x02C8, 0x02C8},
    {0x02C9, 0x02C9, 0x02C9}, {0x02CA, 0x02CA, 0x02CA},
    {0x02CB, 0x02CB, 0x02CB}, {0x02CC, 0x02CC, 0x02CC},
    {0x02CD, 0x02CD, 0x02CD}, {0x02CE, 0x02CE, 0x02CE},
    {0x02CF, 0x02CF, 0x02CF}, {0x02D0, 0x02D0, 0x02D0},
    {0x02D1, 0x02D1, 0x02D1}, {0x02E0, 0x02E0, 0x02E0},
    {0x02E1, 0x02E1, 0x02E1}, {0x02E2, 0x02E2, 0x02E2},
    {0x02E3, 0x02E3, 0x02E3}, {0x02E4, 0x02E4, 0x02E4},
    {0x02EE, 0x02EE, 0x02EE}, {0x0300, 0x0300, 0x0300},
    {0x0301, 0x0301, 0x0301}, {0x0302, 0x0302, 0x0302},
    {0x0303, 0x0303, 0x0303}, {0x0304, 0x0304, 0x0304},
    {0x0305, 0x0305, 0x0305}, {0x0306, 0x0306, 0x0306},
    {0x0307, 0x0307, 0x0307}, {0x0308, 0x0308, 0x0308},
    {0x0309, 0x0309, 0x0309}, {0x030A, 0x030A, 0x030A},
    {0x030B, 0x030B, 0x030B}, {0x030C, 0x030C, 0x030C},
    {0x030D, 0x030D, 0x030D}, {0x030E, 0x030E, 0x030E},
    {0x030F, 0x030F, 0x030F}, {0x0310, 0x0310, 0x0310},
    {0x0311, 0x0311, 0x0311}, {0x0312, 0x0312, 0x0312},
    {0x0313, 0x0313, 0x0313}, {0x0314, 0x0314, 0x0314},
    {0x0315, 0x0315, 0x0315}, {0x0316, 0x0316, 0x0316},
    {0x0317, 0x0317, 0x0317}, {0x0318, 0x0318, 0x0318},
    {0x0319, 0x0319, 0x0319}, {0x031A, 0x031A, 0x031A},
    {0x031B, 0x031B, 0x031B}, {0x031C, 0x031C, 0x031C},
    {0x031D, 0x031D, 0x031D}, {0x031E, 0x031E, 0x031E},
    {0x031F, 0x031F, 0x031F}, {0x0320, 0x0320, 0x0320},
    {0x0321, 0x0321, 0x0321}, {0x0322, 0x0322, 0x0322},
    {0x0323, 0x0323, 0x0323}, {0x0324, 0x0324, 0x0324},
    {0x0325, 0x0325, 0x0325}, {0x0326, 0x0326, 0x0326},
    {0x0327, 0x0327, 0x0327}, {0x0328, 0x0328, 0x0328},
    {0x0329, 0x0329, 0x0329}, {0x032A, 0x032A, 0x032A},
    {0x032B, 0x032B, 0x032B}, {0x032C, 0x032C, 0x032C},
    {0x032D, 0x032D, 0x032D}, {0x032E, 0x032E, 0x032E},
    {0x032F, 0x032F, 0x032F}, {0x0330, 0x0330, 0x0330},
    {0x0331, 0x0331, 0x0331}, {0x0332, 0x0332, 0x0332},
    {0x0333, 0x0333, 0x0333}, {0x0334, 0x0334, 0x0334},
    {0x0335, 0x0335, 0x0335}, {0x0336, 0x0336, 0x0336},
    {0x0337, 0x0337, 0x0337}, {0x0338, 0x0338, 0x0338},
    {0x0339, 0x0339, 0x0339}, {0x033A, 0x033A, 0x033A},
    {0x033B, 0x033B, 0x033B}, {0x033C, 0x033C, 0x033C},
    {0x033D, 0x033D, 0x033D}, {0x033E, 0x033E, 0x033E},
    {0x033F, 0x033F, 0x033F}, {0x0340, 0x0340, 0x0340},
    {0x0341, 0x0341, 0x0341}, {0x0342, 0x0342, 0x0342},
    {0x0343, 0x0343, 0x0343}, {0x0344, 0x0344, 0x0344},
    {0x0345, 0x0399, 0x0345}, {0x0346, 0x0346, 0x0346},
    {0x0347, 0x0347, 0x0347}, {0x0348, 0x0348, 0x0348},
    {0x0349, 0x0349, 0x0349}, {0x034A, 0x034A, 0x034A},
    {0x034B, 0x034B, 0x034B}, {0x034C, 0x034C, 0x034C},
    {0x034D, 0x034D, 0x034D}, {0x034E, 0x034E, 0x034E},
    {0x034F, 0x034F, 0x034F}, {0x0350, 0x0350, 0x0350},
    {0x0351, 0x0351, 0x0351}, {0x0352, 0x0352, 0x0352},
    {0x0353, 0x0353, 0x0353}, {0x0354, 0x0354, 0x0354},
    {0x0355, 0x0355, 0x0355}, {0x0356, 0x0356, 0x0356},
    {0x0357, 0x0357, 0x0357}, {0x0358, 0x0358, 0x0358},
    {0x0359, 0x0359, 0x0359}, {0x035A, 0x035A, 0x035A},
    {0x035B, 0x035B, 0x035B}, {0x035C, 0x035C, 0x035C},
    {0x035D, 0x035D, 0x035D}, {0x035E, 0x035E, 0x035E},
    {0x035F, 0x035F, 0x035F}, {0x0360, 0x0360, 0x0360},
    {0x0361, 0x0361, 0x0361}, {0x0362, 0x0362, 0x0362},
    {0x0363, 0x0363, 0x0363}, {0x0364, 0x0364, 0x0364},
    {0x0365, 0x0365, 0x0365}, {0x0366, 0x0366, 0x0366},
    {0x0367, 0x0367, 0x0367}, {0x0368, 0x0368, 0x0368},
    {0x0369, 0x0369, 0x0369}, {0x036A, 0x036A, 0x036A},
    {0x036B, 0x036B, 0x036B}, {0x036C, 0x036C, 0x036C},
    {0x036D, 0x036D, 0x036D}, {0x036E, 0x036E, 0x036E},
    {0x036F, 0x036F, 0x036F}, {0x037A, 0x037A, 0x037A},
    {0x0386, 0x0386, 0x03AC}, {0x0388, 0x0388, 0x03AD},
    {0x0389, 0x0389, 0x03AE}, {0x038A, 0x038A, 0x03AF},
    {0x038C, 0x038C, 0x03CC}, {0x038E, 0x038E, 0x03CD},
    {0x038F, 0x038F, 0x03CE}, {0x0390, 0x0390, 0x0390},
    {0x0391, 0x0391, 0x03B1}, {0x0392, 0x0392, 0x03B2},
    {0x0393, 0x0393, 0x03B3}, {0x0394, 0x0394, 0x03B4},
    {0x0395, 0x0395, 0x03B5}, {0x0396, 0x0396, 0x03B6},
    {0x0397, 0x0397, 0x03B7}, {0x0398, 0x0398, 0x03B8},
    {0x0399, 0x0399, 0x03B9}, {0x039A, 0x039A, 0x03BA},
    {0x039B, 0x039B, 0x03BB}, {0x039C, 0x039C, 0x03BC},
    {0x039D, 0x039D, 0x03BD}, {0x039E, 0x039E, 0x03BE},
    {0x039F, 0x039F, 0x03BF}, {0x03A0, 0x03A0, 0x03C0},
    {0x03A1, 0x03A1, 0x03C1}, {0x03A3, 0x03A3, 0x03C3},
    {0x03A4, 0x03A4, 0x03C4}, {0x03A5, 0x03A5, 0x03C5},
    {0x03A6, 0x03A6, 0x03C6}, {0x03A7, 0x03A7, 0x03C7},
    {0x03A8, 0x03A8, 0x03C8}, {0x03A9, 0x03A9, 0x03C9},
    {0x03AA, 0x03AA, 0x03CA}, {0x03AB, 0x03AB, 0x03CB},
    {0x03AC, 0x0386, 0x03AC}, {0x03AD, 0x0388, 0x03AD},
    {0x03AE, 0x0389, 0x03AE}, {0x03AF, 0x038A, 0x03AF},
    {0x03B0, 0x03B0, 0x03B0}, {0x03B1, 0x0391, 0x03B1},
    {0x03B2, 0x0392, 0x03B2}, {0x03B3, 0x0393, 0x03B3},
    {0x03B4, 0x0394, 0x03B4}, {0x03B5, 0x0395, 0x03B5},
    {0x03B6, 0x0396, 0x03B6}, {0x03B7, 0x0397, 0x03B7},
    {0x03B8, 0x0398, 0x03B8}, {0x03B9, 0x0399, 0x03B9},
    {0x03BA, 0x039A, 0x03BA}, {0x03BB, 0x039B, 0x03BB},
    {0x03BC, 0x039C, 0x03BC}, {0x03BD, 0x039D, 0x03BD},
    {0x03BE, 0x039E, 0x03BE}, {0x03BF, 0x039F, 0x03BF},
    {0x03C0, 0x03A0, 0x03C0}, {0x03C1, 0x03A1, 0x03C1},
    {0x03C2, 0x03A3, 0x03C2}, {0x03C3, 0x03A3, 0x03C3},
    {0x03C4, 0x03A4, 0x03C4}, {0x03C5, 0x03A5, 0x03C5},
    {0x03C6, 0x03A6, 0x03C6}, {0x03C7, 0x03A7, 0x03C7},
    {0x03C8, 0x03A8, 0x03C8}, {0x03C9, 0x03A9, 0x03C9},
    {0x03CA, 0x03AA, 0x03CA}, {0x03CB, 0x03AB, 0x03CB},
    {0x03CC, 0x038C, 0x03CC}, {0x03CD, 0x038E, 0x03CD},
    {0x03CE, 0x038F, 0x03CE}, {0x03D0, 0x0392, 0x03D0},
    {0x03D1, 0x0398, 0x03D1}, {0x03D2, 0x03D2, 0x03D2},
    {0x03D3, 0x03D3, 0x03D3}, {0x03D4, 0x03D4, 0x03D4},
    {0x03D5, 0x03A6, 0x03D5}, {0x03D6, 0x03A0, 0x03D6},
    {0x03D7, 0x03D7, 0x03D7}, {0x03D8, 0x03D8, 0x03D9},
    {0x03D9, 0x03D8, 0x03D9}, {0x03DA, 0x03DA, 0x03DB},
    {0x03DB, 0x03DA, 0x03DB}, {0x03DC, 0x03DC, 0x03DD},
    {0x03DD, 0x03DC, 0x03DD}, {0x03DE, 0x03DE, 0x03DF},
    {0x03DF, 0x03DE, 0x03DF}, {0x03E0, 0x03E0, 0x03E1},
    {0x03E1, 0x03E0, 0x03E1}, {0x03E2, 0x03E2, 0x03E3},
    {0x03E3, 0x03E2, 0x03E3}, {0x03E4, 0x03E4, 0x03E5},
    {0x03E5, 0x03E4, 0x03E5}, {0x03E6, 0x03E6, 0x03E7},
    {0x03E7, 0x03E6, 0x03E7}, {0x03E8, 0x03E8, 0x03E9},
    {0x03E9, 0x03E8, 0x03E9}, {0x03EA, 0x03EA, 0x03EB},
    {0x03EB, 0x03EA, 0x03EB}, {0x03EC, 0x03EC, 0x03ED},
    {0x03ED, 0x03EC, 0x03ED}, {0x03EE, 0x03EE, 0x03EF},
    {0x03EF, 0x03EE, 0x03EF}, {0x03F0, 0x039A, 0x03F0},
    {0x03F1, 0x03A1, 0x03F1}, {0x03F2, 0x03F9, 0x03F2},
    {0x03F3, 0x03F3, 0x03F3}, {0x03F4, 0x03F4, 0x03B8},
    {0x03F5, 0x0395, 0x03F5}, {0x03F7, 0x03F7, 0x03F8},
    {0x03F8, 0x03F7, 0x03F8}, {0x03F9, 0x03F9, 0x03F2},
    {0x03FA, 0x03FA, 0x03FB}, {0x03FB, 0x03FA, 0x03FB},
    {0x03FC, 0x03FC, 0x03FC}, {0x03FD, 0x03FD, 0x03FD},
    {0x03FE, 0x03FE, 0x03FE}, {0x03FF, 0x03FF, 0x03FF},
    {0x0400, 0x0400, 0x0450}, {0x0401, 0x0401, 0x0451},
    {0x0402, 0x0402, 0x0452}, {0x0403, 0x0403, 0x0453},
    {0x0404, 0x0404, 0x0454}, {0x0405, 0x0405, 0x0455},
    {0x0406, 0x0406, 0x0456}, {0x0407, 0x0407, 0x0457},
    {0x0408, 0x0408, 0x0458}, {0x0409, 0x0409, 0x0459},
    {0x040A, 0x040A, 0x045A}, {0x040B, 0x040B, 0x045B},
    {0x040C, 0x040C, 0x045C}, {0x040D, 0x040D, 0x045D},
    {0x040E, 0x040E, 0x045E}, {0x040F, 0x040F, 0x045F},
    {0x0410, 0x0410, 0x0430}, {0x0411, 0x0411, 0x0431},
    {0x0412, 0x0412, 0x0432}, {0x0413, 0x0413, 0x0433},
    {0x0414, 0x0414, 0x0434}, {0x0415, 0x0415, 0x0435},
    {0x0416, 0x0416, 0x0436}, {0x0417, 0x0417, 0x0437},
    {0x0418, 0x0418, 0x0438}, {0x0419, 0x0419, 0x0439},
    {0x041A, 0x041A, 0x043A}, {0x041B, 0x041B, 0x043B},
    {0x041C, 0x041C, 0x043C}, {0x041D, 0x041D, 0x043D},
    {0x041E, 0x041E, 0x043E}, {0x041F, 0x041F, 0x043F},
    {0x0420, 0x0420, 0x0440}, {0x0421, 0x0421, 0x0441},
    {0x0422, 0x0422, 0x0442}, {0x0423, 0x0423, 0x0443},
    {0x0424, 0x0424, 0x0444}, {0x0425, 0x0425, 0x0445},
    {0x0426, 0x0426, 0x0446}, {0x0427, 0x0427, 0x0447},
    {0x0428, 0x0428, 0x0448}, {0x0429, 0x0429, 0x0449},
    {0x042A, 0x042A, 0x044A}, {0x042B, 0x042B, 0x044B},
    {0x042C, 0x042C, 0x044C}, {0x042D, 0x042D, 0x044D},
    {0x042E, 0x042E, 0x044E}, {0x042F, 0x042F, 0x044F},
    {0x0430, 0x0410, 0x0430}, {0x0431, 0x0411, 0x0431},
    {0x0432, 0x0412, 0x0432}, {0x0433, 0x0413, 0x0433},
    {0x0434, 0x0414, 0x0434}, {0x0435, 0x0415, 0x0435},
    {0x0436, 0x0416, 0x0436}, {0x0437, 0x0417, 0x0437},
    {0x0438, 0x0418, 0x0438}, {0x0439, 0x0419, 0x0439},
    {0x043A, 0x041A, 0x043A}, {0x043B, 0x041B, 0x043B},
    {0x043C, 0x041C, 0x043C}, {0x043D, 0x041D, 0x043D},
    {0x043E, 0x041E, 0x043E}, {0x043F, 0x041F, 0x043F},
    {0x0440, 0x0420, 0x0440}, {0x0441, 0x0421, 0x0441},
    {0x0442, 0x0422, 0x0442}, {0x0443, 0x0423, 0x0443},
    {0x0444, 0x0424, 0x0444}, {0x0445, 0x0425, 0x0445},
    {0x0446, 0x0426, 0x0446}, {0x0447, 0x0427, 0x0447},
    {0x0448, 0x0428, 0x0448}, {0x0449, 0x0429, 0x0449},
    {0x044A, 0x042A, 0x044A}, {0x044B, 0x042B, 0x044B},
    {0x044C, 0x042C, 0x044C}, {0x044D, 0x042D, 0x044D},
    {0x044E, 0x042E, 0x044E}, {0x044F, 0x042F, 0x044F},
    {0x0450, 0x0400, 0x0450}, {0x0451, 0x0401, 0x0451},
    {0x0452, 0x0402, 0x0452}, {0x0453, 0x0403, 0x0453},
    {0x0454, 0x0404, 0x0454}, {0x0455, 0x0405, 0x0455},
    {0x0456, 0x0406, 0x0456}, {0x0457, 0x0407, 0x0457},
    {0x0458, 0x0408, 0x0458}, {0x0459, 0x0409, 0x0459},
    {0x045A, 0x040A, 0x045A}, {0x045B, 0x040B, 0x045B},
    {0x045C, 0x040C, 0x045C}, {0x045D, 0x040D, 0x045D},
    {0x045E, 0x040E, 0x045E}, {0x045F, 0x040F, 0x045F},
    {0x0460, 0x0460, 0x0461}, {0x0461, 0x0460, 0x0461},
    {0x0462, 0x0462, 0x0463}, {0x0463, 0x0462, 0x0463},
    {0x0464, 0x0464, 0x0465}, {0x0465, 0x0464, 0x0465},
    {0x0466, 0x0466, 0x0467}, {0x0467, 0x0466, 0x0467},
    {0x0468, 0x0468, 0x0469}, {0x0469, 0x0468, 0x0469},
    {0x046A, 0x046A, 0x046B}, {0x046B, 0x046A, 0x046B},
    {0x046C, 0x046C, 0x046D}, {0x046D, 0x046C, 0x046D},
    {0x046E, 0x046E, 0x046F}, {0x046F, 0x046E, 0x046F},
    {0x0470, 0x0470, 0x0471}, {0x0471, 0x0470, 0x0471},
    {0x0472, 0x0472, 0x0473}, {0x0473, 0x0472, 0x0473},
    {0x0474, 0x0474, 0x0475}, {0x0475, 0x0474, 0x0475},
    {0x0476, 0x0476, 0x0477}, {0x0477, 0x0476, 0x0477},
    {0x0478, 0x0478, 0x0479}, {0x0479, 0x0478, 0x0479},
    {0x047A, 0x047A, 0x047B}, {0x047B, 0x047A, 0x047B},
    {0x047C, 0x047C, 0x047D}, {0x047D, 0x047C, 0x047D},
    {0x047E, 0x047E, 0x047F}, {0x047F, 0x047E, 0x047F},
    {0x0480, 0x0480, 0x0481}, {0x0481, 0x0480, 0x0481},
    {0x0483, 0x0483, 0x0483}, {0x0484, 0x0484, 0x0484},
    {0x0485, 0x0485, 0x0485}, {0x0486, 0x0486, 0x0486},
    {0x048A, 0x048A, 0x048B}, {0x048B, 0x048A, 0x048B},
    {0x048C, 0x048C, 0x048D}, {0x048D, 0x048C, 0x048D},
    {0x048E, 0x048E, 0x048F}, {0x048F, 0x048E, 0x048F},
    {0x0490, 0x0490, 0x0491}, {0x0491, 0x0490, 0x0491},
    {0x0492, 0x0492, 0x0493}, {0x0493, 0x0492, 0x0493},
    {0x0494, 0x0494, 0x0495}, {0x0495, 0x0494, 0x0495},
    {0x0496, 0x0496, 0x0497}, {0x0497, 0x0496, 0x0497},
    {0x0498, 0x0498, 0x0499}, {0x0499, 0x0498, 0x0499},
    {0x049A, 0x049A, 0x049B}, {0x049B, 0x049A, 0x049B},
    {0x049C, 0x049C, 0x049D}, {0x049D, 0x049C, 0x049D},
    {0x049E, 0x049E, 0x049F}, {0x049F, 0x049E, 0x049F},
    {0x04A0, 0x04A0, 0x04A1}, {0x04A1, 0x04A0, 0x04A1},
    {0x04A2, 0x04A2, 0x04A3}, {0x04A3, 0x04A2, 0x04A3},
    {0x04A4, 0x04A4, 0x04A5}, {0x04A5, 0x04A4, 0x04A5},
    {0x04A6, 0x04A6, 0x04A7}, {0x04A7, 0x04A6, 0x04A7},
    {0x04A8, 0x04A8, 0x04A9}, {0x04A9, 0x04A8, 0x04A9},
    {0x04AA, 0x04AA, 0x04AB}, {0x04AB, 0x04AA, 0x04AB},
    {0x04AC, 0x04AC, 0x04AD}, {0x04AD, 0x04AC, 0x04AD},
    {0x04AE, 0x04AE, 0x04AF}, {0x04AF, 0x04AE, 0x04AF},
    {0x04B0, 0x04B0, 0x04B1}, {0x04B1, 0x04B0, 0x04B1},
    {0x04B2, 0x04B2, 0x04B3}, {0x04B3, 0x04B2, 0x04B3},
    {0x04B4, 0x04B4, 0x04B5}, {0x04B5, 0x04B4, 0x04B5},
    {0x04B6, 0x04B6, 0x04B7}, {0x04B7, 0x04B6, 0x04B7},
    {0x04B8, 0x04B8, 0x04B9}, {0x04B9, 0x04B8, 0x04B9},
    {0x04BA, 0x04BA, 0x04BB}, {0x04BB, 0x04BA, 0x04BB},
    {0x04BC, 0x04BC, 0x04BD}, {0x04BD, 0x04BC, 0x04BD},
    {0x04BE, 0x04BE, 0x04BF}, {0x04BF, 0x04BE, 0x04BF},
    {0x04C0, 0x04C0, 0x04C0}, {0x04C1, 0x04C1, 0x04C2},
    {0x04C2, 0x04C1, 0x04C2}, {0x04C3, 0x04C3, 0x04C4},
    {0x04C4, 0x04C3, 0x04C4}, {0x04C5, 0x04C5, 0x04C6},
    {0x04C6, 0x04C5, 0x04C6}, {0x04C7, 0x04C7, 0x04C8},
    {0x04C8, 0x04C7, 0x04C8}, {0x04C9, 0x04C9, 0x04CA},
    {0x04CA, 0x04C9, 0x04CA}, {0x04CB, 0x04CB, 0x04CC},
    {0x04CC, 0x04CB, 0x04CC}, {0x04CD, 0x04CD, 0x04CE},
    {0x04CE, 0x04CD, 0x04CE}, {0x04D0, 0x04D0, 0x04D1},
    {0x04D1, 0x04D0, 0x04D1}, {0x04D2, 0x04D2, 0x04D3},
    {0x04D3, 0x04D2, 0x04D3}, {0x04D4, 0x04D4, 0x04D5},
    {0x04D5, 0x04D4, 0x04D5}, {0x04D6, 0x04D6, 0x04D7},
    {0x04D7, 0x04D6, 0x04D7}, {0x04D8, 0x04D8, 0x04D9},
    {0x04D9, 0x04D8, 0x04D9}, {0x04DA, 0x04DA, 0x04DB},
    {0x04DB, 0x04DA, 0x04DB}, {0x04DC, 0x04DC, 0x04DD},
    {0x04DD, 0x04DC, 0x04DD}, {0x04DE, 0x04DE, 0x04DF},
    {0x04DF, 0x04DE, 0x04DF}, {0x04E0, 0x04E0, 0x04E1},
    {0x04E1, 0x04E0, 0x04E1}, {0x04E2, 0x04E2, 0x04E3},
    {0x04E3, 0x04E2, 0x04E3}, {0x04E4, 0x04E4, 0x04E5},
    {0x04E5, 0x04E4, 0x04E5}, {0x04E6, 0x04E6, 0x04E7},
    {0x04E7, 0x04E6, 0x04E7}, {0x04E8, 0x04E8, 0x04E9},
    {0x04E9, 0x04E8, 0x04E9}, {0x04EA, 0x04EA, 0x04EB},
    {0x04EB, 0x04EA, 0x04EB}, {0x04EC, 0x04EC, 0x04ED},
    {0x04ED, 0x04EC, 0x04ED}, {0x04EE, 0x04EE, 0x04EF},
    {0x04EF, 0x04EE, 0x04EF}, {0x04F0, 0x04F0, 0x04F1},
    {0x04F1, 0x04F0, 0x04F1}, {0x04F2, 0x04F2, 0x04F3},
    {0x04F3, 0x04F2, 0x04F3}, {0x04F4, 0x04F4, 0x04F5},
    {0x04F5, 0x04F4, 0x04F5}, {0x04F6, 0x04F6, 0x04F7},
    {0x04F7, 0x04F6, 0x04F7}, {0x04F8, 0x04F8, 0x04F9},
    {0x04F9, 0x04F8, 0x04F9}, {0x0500, 0x0500, 0x0501},
    {0x0501, 0x0500, 0x0501}, {0x0502, 0x0502, 0x0503},
    {0x0503, 0x0502, 0x0503}, {0x0504, 0x0504, 0x0505},
    {0x0505, 0x0504, 0x0505}, {0x0506, 0x0506, 0x0507},
    {0x0507, 0x0506, 0x0507}, {0x0508, 0x0508, 0x0509},
    {0x0509, 0x0508, 0x0509}, {0x050A, 0x050A, 0x050B},
    {0x050B, 0x050A, 0x050B}, {0x050C, 0x050C, 0x050D},
    {0x050D, 0x050C, 0x050D}, {0x050E, 0x050E, 0x050F},
    {0x050F, 0x050E, 0x050F}, {0x0531, 0x0531, 0x0561},
    {0x0532, 0x0532, 0x0562}, {0x0533, 0x0533, 0x0563},
    {0x0534, 0x0534, 0x0564}, {0x0535, 0x0535, 0x0565},
    {0x0536, 0x0536, 0x0566}, {0x0537, 0x0537, 0x0567},
    {0x0538, 0x0538, 0x0568}, {0x0539, 0x0539, 0x0569},
    {0x053A, 0x053A, 0x056A}, {0x053B, 0x053B, 0x056B},
    {0x053C, 0x053C, 0x056C}, {0x053D, 0x053D, 0x056D},
    {0x053E, 0x053E, 0x056E}, {0x053F, 0x053F, 0x056F},
    {0x0540, 0x0540, 0x0570}, {0x0541, 0x0541, 0x0571},
    {0x0542, 0x0542, 0x0572}, {0x0543, 0x0543, 0x0573},
    {0x0544, 0x0544, 0x0574}, {0x0545, 0x0545, 0x0575},
    {0x0546, 0x0546, 0x0576}, {0x0547, 0x0547, 0x0577},
    {0x0548, 0x0548, 0x0578}, {0x0549, 0x0549, 0x0579},
    {0x054A, 0x054A, 0x057A}, {0x054B, 0x054B, 0x057B},
    {0x054C, 0x054C, 0x057C}, {0x054D, 0x054D, 0x057D},
    {0x054E, 0x054E, 0x057E}, {0x054F, 0x054F, 0x057F},
    {0x0550, 0x0550, 0x0580}, {0x0551, 0x0551, 0x0581},
    {0x0552, 0x0552, 0x0582}, {0x0553, 0x0553, 0x0583},
    {0x0554, 0x0554, 0x0584}, {0x0555, 0x0555, 0x0585},
    {0x0556, 0x0556, 0x0586}, {0x0559, 0x0559, 0x0559},
    {0x0561, 0x0531, 0x0561}, {0x0562, 0x0532, 0x0562},
    {0x0563, 0x0533, 0x0563}, {0x0564, 0x0534, 0x0564},
    {0x0565, 0x0535, 0x0565}, {0x0566, 0x0536, 0x0566},
    {0x0567, 0x0537, 0x0567}, {0x0568, 0x0538, 0x0568},
    {0x0569, 0x0539, 0x0569}, {0x056A, 0x053A, 0x056A},
    {0x056B, 0x053B, 0x056B}, {0x056C, 0x053C, 0x056C},
    {0x056D, 0x053D, 0x056D}, {0x056E, 0x053E, 0x056E},
    {0x056F, 0x053F, 0x056F}, {0x0570, 0x0540, 0x0570},
    {0x0571, 0x0541, 0x0571}, {0x0572, 0x0542, 0x0572},
    {0x0573, 0x0543, 0x0573}, {0x0574, 0x0544, 0x0574},
    {0x0575, 0x0545, 0x0575}, {0x0576, 0x0546, 0x0576},
    {0x0577, 0x0547, 0x0577}, {0x0578, 0x0548, 0x0578},
    {0x0579, 0x0549, 0x0579}, {0x057A, 0x054A, 0x057A},
    {0x057B, 0x054B, 0x057B}, {0x057C, 0x054C, 0x057C},
    {0x057D, 0x054D, 0x057D}, {0x057E, 0x054E, 0x057E},
    {0x057F, 0x054F, 0x057F}, {0x0580, 0x0550, 0x0580},
    {0x0581, 0x0551, 0x0581}, {0x0582, 0x0552, 0x0582},
    {0x0583, 0x0553, 0x0583}, {0x0584, 0x0554, 0x0584},
    {0x0585, 0x0555, 0x0585}, {0x0586, 0x0556, 0x0586},
    {0x0587, 0x0587, 0x0587}, {0x0591, 0x0591, 0x0591},
    {0x0592, 0x0592, 0x0592}, {0x0593, 0x0593, 0x0593},
    {0x0594, 0x0594, 0x0594}, {0x0595, 0x0595, 0x0595},
    {0x0596, 0x0596, 0x0596}, {0x0597, 0x0597, 0x0597},
    {0x0598, 0x0598, 0x0598}, {0x0599, 0x0599, 0x0599},
    {0x059A, 0x059A, 0x059A}, {0x059B, 0x059B, 0x059B},
    {0x059C, 0x059C, 0x059C}, {0x059D, 0x059D, 0x059D},
    {0x059E, 0x059E, 0x059E}, {0x059F, 0x059F, 0x059F},
    {0x05A0, 0x05A0, 0x05A0}, {0x05A1, 0x05A1, 0x05A1},
    {0x05A2, 0x05A2, 0x05A2}, {0x05A3, 0x05A3, 0x05A3},
    {0x05A4, 0x05A4, 0x05A4}, {0x05A5, 0x05A5, 0x05A5},
    {0x05A6, 0x05A6, 0x05A6}, {0x05A7, 0x05A7, 0x05A7},
    {0x05A8, 0x05A8, 0x05A8}, {0x05A9, 0x05A9, 0x05A9},
    {0x05AA, 0x05AA, 0x05AA}, {0x05AB, 0x05AB, 0x05AB},
    {0x05AC, 0x05AC, 0x05AC}, {0x05AD, 0x05AD, 0x05AD},
    {0x05AE, 0x05AE, 0x05AE}, {0x05AF, 0x05AF, 0x05AF},
    {0x05B0, 0x05B0, 0x05B0}, {0x05B1, 0x05B1, 0x05B1},
    {0x05B2, 0x05B2, 0x05B2}, {0x05B3, 0x05B3, 0x05B3},
    {0x05B4, 0x05B4, 0x05B4}, {0x05B5, 0x05B5, 0x05B5},
    {0x05B6, 0x05B6, 0x05B6}, {0x05B7, 0x05B7, 0x05B7},
    {0x05B8, 0x05B8, 0x05B8}, {0x05B9, 0x05B9, 0x05B9},
    {0x05BB, 0x05BB, 0x05BB}, {0x05BC, 0x05BC, 0x05BC},
    {0x05BD, 0x05BD, 0x05BD}, {0x05BF, 0x05BF, 0x05BF},
    {0x05C1, 0x05C1, 0x05C1}, {0x05C2, 0x05C2, 0x05C2},
    {0x05C4, 0x05C4, 0x05C4}, {0x05C5, 0x05C5, 0x05C5},
    {0x05C7, 0x05C7, 0x05C7}, {0x05D0, 0x05D0, 0x05D0},
    {0x05D1, 0x05D1, 0x05D1}, {0x05D2, 0x05D2, 0x05D2},
    {0x05D3, 0x05D3, 0x05D3}, {0x05D4, 0x05D4, 0x05D4},
    {0x05D5, 0x05D5, 0x05D5}, {0x05D6, 0x05D6, 0x05D6},
    {0x05D7, 0x05D7, 0x05D7}, {0x05D8, 0x05D8, 0x05D8},
    {0x05D9, 0x05D9, 0x05D9}, {0x05DA, 0x05DA, 0x05DA},
    {0x05DB, 0x05DB, 0x05DB}, {0x05DC, 0x05DC, 0x05DC},
    {0x05DD, 0x05DD, 0x05DD}, {0x05DE, 0x05DE, 0x05DE},
    {0x05DF, 0x05DF, 0x05DF}, {0x05E0, 0x05E0, 0x05E0},
    {0x05E1, 0x05E1, 0x05E1}, {0x05E2, 0x05E2, 0x05E2},
    {0x05E3, 0x05E3, 0x05E3}, {0x05E4, 0x05E4, 0x05E4},
    {0x05E5, 0x05E5, 0x05E5}, {0x05E6, 0x05E6, 0x05E6},
    {0x05E7, 0x05E7, 0x05E7}, {0x05E8, 0x05E8, 0x05E8},
    {0x05E9, 0x05E9, 0x05E9}, {0x05EA, 0x05EA, 0x05EA},
    {0x05F0, 0x05F0, 0x05F0}, {0x05F1, 0x05F1, 0x05F1},
    {0x05F2, 0x05F2, 0x05F2}, {0x0610, 0x0610, 0x0610},
    {0x0611, 0x0611, 0x0611}, {0x0612, 0x0612, 0x0612},
    {0x0613, 0x0613, 0x0613}, {0x0614, 0x0614, 0x0614},
    {0x0615, 0x0615, 0x0615}, {0x0621, 0x0621, 0x0621},
    {0x0622, 0x0622, 0x0622}, {0x0623, 0x0623, 0x0623},
    {0x0624, 0x0624, 0x0624}, {0x0625, 0x0625, 0x0625},
    {0x0626, 0x0626, 0x0626}, {0x0627, 0x0627, 0x0627},
    {0x0628, 0x0628, 0x0628}, {0x0629, 0x0629, 0x0629},
    {0x062A, 0x062A, 0x062A}, {0x062B, 0x062B, 0x062B},
    {0x062C, 0x062C, 0x062C}, {0x062D, 0x062D, 0x062D},
    {0x062E, 0x062E, 0x062E}, {0x062F, 0x062F, 0x062F},
    {0x0630, 0x0630, 0x0630}, {0x0631, 0x0631, 0x0631},
    {0x0632, 0x0632, 0x0632}, {0x0633, 0x0633, 0x0633},
    {0x0634, 0x0634, 0x0634}, {0x0635, 0x0635, 0x0635},
    {0x0636, 0x0636, 0x0636}, {0x0637, 0x0637, 0x0637},
    {0x0638, 0x0638, 0x0638}, {0x0639, 0x0639, 0x0639},
    {0x063A, 0x063A, 0x063A}, {0x0640, 0x0640, 0x0640},
    {0x0641, 0x0641, 0x0641}, {0x0642, 0x0642, 0x0642},
    {0x0643, 0x0643, 0x0643}, {0x0644, 0x0644, 0x0644},
    {0x0645, 0x0645, 0x0645}, {0x0646, 0x0646, 0x0646},
    {0x0647, 0x0647, 0x0647}, {0x0648, 0x0648, 0x0648},
    {0x0649, 0x0649, 0x0649}, {0x064A, 0x064A, 0x064A},
    {0x064B, 0x064B, 0x064B}, {0x064C, 0x064C, 0x064C},
    {0x064D, 0x064D, 0x064D}, {0x064E, 0x064E, 0x064E},
    {0x064F, 0x064F, 0x064F}, {0x0650, 0x0650, 0x0650},
    {0x0651, 0x0651, 0x0651}, {0x0652, 0x0652, 0x0652},
    {0x0653, 0x0653, 0x0653}, {0x0654, 0x0654, 0x0654},
    {0x0655, 0x0655, 0x0655}, {0x0656, 0x0656, 0x0656},
    {0x0657, 0x0657, 0x0657}, {0x0658, 0x0658, 0x0658},
    {0x0659, 0x0659, 0x0659}, {0x065A, 0x065A, 0x065A},
    {0x065B, 0x065B, 0x065B}, {0x065C, 0x065C, 0x065C},
    {0x065D, 0x065D, 0x065D}, {0x065E, 0x065E, 0x065E},
    {0x066E, 0x066E, 0x066E}, {0x066F, 0x066F, 0x066F},
    {0x0670, 0x0670, 0x0670}, {0x0671, 0x0671, 0x0671},
    {0x0672, 0x0672, 0x0672}, {0x0673, 0x0673, 0x0673},
    {0x0674, 0x0674, 0x0674}, {0x0675, 0x0675, 0x0675},
    {0x0676, 0x0676, 0x0676}, {0x0677, 0x0677, 0x0677},
    {0x0678, 0x0678, 0x0678}, {0x0679, 0x0679, 0x0679},
    {0x067A, 0x067A, 0x067A}, {0x067B, 0x067B, 0x067B},
    {0x067C, 0x067C, 0x067C}, {0x067D, 0x067D, 0x067D},
    {0x067E, 0x067E, 0x067E}, {0x067F, 0x067F, 0x067F},
    {0x0680, 0x0680, 0x0680}, {0x0681, 0x0681, 0x0681},
    {0x0682, 0x0682, 0x0682}, {0x0683, 0x0683, 0x0683},
    {0x0684, 0x0684, 0x0684}, {0x0685, 0x0685, 0x0685},
    {0x0686, 0x0686, 0x0686}, {0x0687, 0x0687, 0x0687},
    {0x0688, 0x0688, 0x0688}, {0x0689, 0x0689, 0x0689},
    {0x068A, 0x068A, 0x068A}, {0x068B, 0x068B, 0x068B},
    {0x068C, 0x068C, 0x068C}, {0x068D, 0x068D, 0x068D},
    {0x068E, 0x068E, 0x068E}, {0x068F, 0x068F, 0x068F},
    {0x0690, 0x0690, 0x0690}, {0x0691, 0x0691, 0x0691},
    {0x0692, 0x0692, 0x0692}, {0x0693, 0x0693, 0x0693},
    {0x0694, 0x0694, 0x0694}, {0x0695, 0x0695, 0x0695},
    {0x0696, 0x0696, 0x0696}, {0x0697, 0x0697, 0x0697},
    {0x0698, 0x0698, 0x0698}, {0x0699, 0x0699, 0x0699},
    {0x069A, 0x069A, 0x069A}, {0x069B, 0x069B, 0x069B},
    {0x069C, 0x069C, 0x069C}, {0x069D, 0x069D, 0x069D},
    {0x069E, 0x069E, 0x069E}, {0x069F, 0x069F, 0x069F},
    {0x06A0, 0x06A0, 0x06A0}, {0x06A1, 0x06A1, 0x06A1},
    {0x06A2, 0x06A2, 0x06A2}, {0x06A3, 0x06A3, 0x06A3},
    {0x06A4, 0x06A4, 0x06A4}, {0x06A5, 0x06A5, 0x06A5},
    {0x06A6, 0x06A6, 0x06A6}, {0x06A7, 0x06A7, 0x06A7},
    {0x06A8, 0x06A8, 0x06A8}, {0x06A9, 0x06A9, 0x06A9},
    {0x06AA, 0x06AA, 0x06AA}, {0x06AB, 0x06AB, 0x06AB},
    {0x06AC, 0x06AC, 0x06AC}, {0x06AD, 0x06AD, 0x06AD},
    {0x06AE, 0x06AE, 0x06AE}, {0x06AF, 0x06AF, 0x06AF},
    {0x06B0, 0x06B0, 0x06B0}, {0x06B1, 0x06B1, 0x06B1},
    {0x06B2, 0x06B2, 0x06B2}, {0x06B3, 0x06B3, 0x06B3},
    {0x06B4, 0x06B4, 0x06B4}, {0x06B5, 0x06B5, 0x06B5},
    {0x06B6, 0x06B6, 0x06B6}, {0x06B7, 0x06B7, 0x06B7},
    {0x06B8, 0x06B8, 0x06B8}, {0x06B9, 0x06B9, 0x06B9},
    {0x06BA, 0x06BA, 0x06BA}, {0x06BB, 0x06BB, 0x06BB},
    {0x06BC, 0x06BC, 0x06BC}, {0x06BD, 0x06BD, 0x06BD},
    {0x06BE, 0x06BE, 0x06BE}, {0x06BF, 0x06BF, 0x06BF},
    {0x06C0, 0x06C0, 0x06C0}, {0x06C1, 0x06C1, 0x06C1},
    {0x06C2, 0x06C2, 0x06C2}, {0x06C3, 0x06C3, 0x06C3},
    {0x06C4, 0x06C4, 0x06C4}, {0x06C5, 0x06C5, 0x06C5},
    {0x06C6, 0x06C6, 0x06C6}, {0x06C7, 0x06C7, 0x06C7},
    {0x06C8, 0x06C8, 0x06C8}, {0x06C9, 0x06C9, 0x06C9},
    {0x06CA, 0x06CA, 0x06CA}, {0x06CB, 0x06CB, 0x06CB},
    {0x06CC, 0x06CC, 0x06CC}, {0x06CD, 0x06CD, 0x06CD},
    {0x06CE, 0x06CE, 0x06CE}, {0x06CF, 0x06CF, 0x06CF},
    {0x06D0, 0x06D0, 0x06D0}, {0x06D1, 0x06D1, 0x06D1},
    {0x06D2, 0x06D2, 0x06D2}, {0x06D3, 0x06D3, 0x06D3},
    {0x06D5, 0x06D5, 0x06D5}, {0x06D6, 0x06D6, 0x06D6},
    {0x06D7, 0x06D7, 0x06D7}, {0x06D8, 0x06D8, 0x06D8},
    {0x06D9, 0x06D9, 0x06D9}, {0x06DA, 0x06DA, 0x06DA},
    {0x06DB, 0x06DB, 0x06DB}, {0x06DC, 0x06DC, 0x06DC},
    {0x06DF, 0x06DF, 0x06DF}, {0x06E0, 0x06E0, 0x06E0},
    {0x06E1, 0x06E1, 0x06E1}, {0x06E2, 0x06E2, 0x06E2},
    {0x06E3, 0x06E3, 0x06E3}, {0x06E4, 0x06E4, 0x06E4},
    {0x06E5, 0x06E5, 0x06E5}, {0x06E6, 0x06E6, 0x06E6},
    {0x06E7, 0x06E7, 0x06E7}, {0x06E8, 0x06E8, 0x06E8},
    {0x06EA, 0x06EA, 0x06EA}, {0x06EB, 0x06EB, 0x06EB},
    {0x06EC, 0x06EC, 0x06EC}, {0x06ED, 0x06ED, 0x06ED},
    {0x06EE, 0x06EE, 0x06EE}, {0x06EF, 0x06EF, 0x06EF},
    {0x06FA, 0x06FA, 0x06FA}, {0x06FB, 0x06FB, 0x06FB},
    {0x06FC, 0x06FC, 0x06FC}, {0x06FF, 0x06FF, 0x06FF},
    {0x0710, 0x0710, 0x0710}, {0x0711, 0x0711, 0x0711},
    {0x0712, 0x0712, 0x0712}, {0x0713, 0x0713, 0x0713},
    {0x0714, 0x0714, 0x0714}, {0x0715, 0x0715, 0x0715},
    {0x0716, 0x0716, 0x0716}, {0x0717, 0x0717, 0x0717},
    {0x0718, 0x0718, 0x0718}, {0x0719, 0x0719, 0x0719},
    {0x071A, 0x071A, 0x071A}, {0x071B, 0x071B, 0x071B},
    {0x071C, 0x071C, 0x071C}, {0x071D, 0x071D, 0x071D},
    {0x071E, 0x071E, 0x071E}, {0x071F, 0x071F, 0x071F},
    {0x0720, 0x0720, 0x0720}, {0x0721, 0x0721, 0x0721},
    {0x0722, 0x0722, 0x0722}, {0x0723, 0x0723, 0x0723},
    {0x0724, 0x0724, 0x0724}, {0x0725, 0x0725, 0x0725},
    {0x0726, 0x0726, 0x0726}, {0x0727, 0x0727, 0x0727},
    {0x0728, 0x0728, 0x0728}, {0x0729, 0x0729, 0x0729},
    {0x072A, 0x072A, 0x072A}, {0x072B, 0x072B, 0x072B},
    {0x072C, 0x072C, 0x072C}, {0x072D, 0x072D, 0x072D},
    {0x072E, 0x072E, 0x072E}, {0x072F, 0x072F, 0x072F},
    {0x0730, 0x0730, 0x0730}, {0x0731, 0x0731, 0x0731},
    {0x0732, 0x0732, 0x0732}, {0x0733, 0x0733, 0x0733},
    {0x0734, 0x0734, 0x0734}, {0x0735, 0x0735, 0x0735},
    {0x0736, 0x0736, 0x0736}, {0x0737, 0x0737, 0x0737},
    {0x0738, 0x0738, 0x0738}, {0x0739, 0x0739, 0x0739},
    {0x073A, 0x073A, 0x073A}, {0x073B, 0x073B, 0x073B},
    {0x073C, 0x073C, 0x073C}, {0x073D, 0x073D, 0x073D},
    {0x073E, 0x073E, 0x073E}, {0x073F, 0x073F, 0x073F},
    {0x0740, 0x0740, 0x0740}, {0x0741, 0x0741, 0x0741},
    {0x0742, 0x0742, 0x0742}, {0x0743, 0x0743, 0x0743},
    {0x0744, 0x0744, 0x0744}, {0x0745, 0x0745, 0x0745},
    {0x0746, 0x0746, 0x0746}, {0x0747, 0x0747, 0x0747},
    {0x0748, 0x0748, 0x0748}, {0x0749, 0x0749, 0x0749},
    {0x074A, 0x074A, 0x074A}, {0x074D, 0x074D, 0x074D},
    {0x074E, 0x074E, 0x074E}, {0x074F, 0x074F, 0x074F},
    {0x0750, 0x0750, 0x0750}, {0x0751, 0x0751, 0x0751},
    {0x0752, 0x0752, 0x0752}, {0x0753, 0x0753, 0x0753},
    {0x0754, 0x0754, 0x0754}, {0x0755, 0x0755, 0x0755},
    {0x0756, 0x0756, 0x0756}, {0x0757, 0x0757, 0x0757},
    {0x0758, 0x0758, 0x0758}, {0x0759, 0x0759, 0x0759},
    {0x075A, 0x075A, 0x075A}, {0x075B, 0x075B, 0x075B},
    {0x075C, 0x075C, 0x075C}, {0x075D, 0x075D, 0x075D},
    {0x075E, 0x075E, 0x075E}, {0x075F, 0x075F, 0x075F},
    {0x0760, 0x0760, 0x0760}, {0x0761, 0x0761, 0x0761},
    {0x0762, 0x0762, 0x0762}, {0x0763, 0x0763, 0x0763},
    {0x0764, 0x0764, 0x0764}, {0x0765, 0x0765, 0x0765},
    {0x0766, 0x0766, 0x0766}, {0x0767, 0x0767, 0x0767},
    {0x0768, 0x0768, 0x0768}, {0x0769, 0x0769, 0x0769},
    {0x076A, 0x076A, 0x076A}, {0x076B, 0x076B, 0x076B},
    {0x076C, 0x076C, 0x076C}, {0x076D, 0x076D, 0x076D},
    {0x0780, 0x0780, 0x0780}, {0x0781, 0x0781, 0x0781},
    {0x0782, 0x0782, 0x0782}, {0x0783, 0x0783, 0x0783},
    {0x0784, 0x0784, 0x0784}, {0x0785, 0x0785, 0x0785},
    {0x0786, 0x0786, 0x0786}, {0x0787, 0x0787, 0x0787},
    {0x0788, 0x0788, 0x0788}, {0x0789, 0x0789, 0x0789},
    {0x078A, 0x078A, 0x078A}, {0x078B, 0x078B, 0x078B},
    {0x078C, 0x078C, 0x078C}, {0x078D, 0x078D, 0x078D},
    {0x078E, 0x078E, 0x078E}, {0x078F, 0x078F, 0x078F},
    {0x0790, 0x0790, 0x0790}, {0x0791, 0x0791, 0x0791},
    {0x0792, 0x0792, 0x0792}, {0x0793, 0x0793, 0x0793},
    {0x0794, 0x0794, 0x0794}, {0x0795, 0x0795, 0x0795},
    {0x0796, 0x0796, 0x0796}, {0x0797, 0x0797, 0x0797},
    {0x0798, 0x0798, 0x0798}, {0x0799, 0x0799, 0x0799},
    {0x079A, 0x079A, 0x079A}, {0x079B, 0x079B, 0x079B},
    {0x079C, 0x079C, 0x079C}, {0x079D, 0x079D, 0x079D},
    {0x079E, 0x079E, 0x079E}, {0x079F, 0x079F, 0x079F},
    {0x07A0, 0x07A0, 0x07A0}, {0x07A1, 0x07A1, 0x07A1},
    {0x07A2, 0x07A2, 0x07A2}, {0x07A3, 0x07A3, 0x07A3},
    {0x07A4, 0x07A4, 0x07A4}, {0x07A5, 0x07A5, 0x07A5},
    {0x07A6, 0x07A6, 0x07A6}, {0x07A7, 0x07A7, 0x07A7},
    {0x07A8, 0x07A8, 0x07A8}, {0x07A9, 0x07A9, 0x07A9},
    {0x07AA, 0x07AA, 0x07AA}, {0x07AB, 0x07AB, 0x07AB},
    {0x07AC, 0x07AC, 0x07AC}, {0x07AD, 0x07AD, 0x07AD},
    {0x07AE, 0x07AE, 0x07AE}, {0x07AF, 0x07AF, 0x07AF},
    {0x07B0, 0x07B0, 0x07B0}, {0x07B1, 0x07B1, 0x07B1},
    {0x0901, 0x0901, 0x0901}, {0x0902, 0x0902, 0x0902},
    {0x0904, 0x0904, 0x0904}, {0x0905, 0x0905, 0x0905},
    {0x0906, 0x0906, 0x0906}, {0x0907, 0x0907, 0x0907},
    {0x0908, 0x0908, 0x0908}, {0x0909, 0x0909, 0x0909},
    {0x090A, 0x090A, 0x090A}, {0x090B, 0x090B, 0x090B},
    {0x090C, 0x090C, 0x090C}, {0x090D, 0x090D, 0x090D},
    {0x090E, 0x090E, 0x090E}, {0x090F, 0x090F, 0x090F},
    {0x0910, 0x0910, 0x0910}, {0x0911, 0x0911, 0x0911},
    {0x0912, 0x0912, 0x0912}, {0x0913, 0x0913, 0x0913},
    {0x0914, 0x0914, 0x0914}, {0x0915, 0x0915, 0x0915},
    {0x0916, 0x0916, 0x0916}, {0x0917, 0x0917, 0x0917},
    {0x0918, 0x0918, 0x0918}, {0x0919, 0x0919, 0x0919},
    {0x091A, 0x091A, 0x091A}, {0x091B, 0x091B, 0x091B},
    {0x091C, 0x091C, 0x091C}, {0x091D, 0x091D, 0x091D},
    {0x091E, 0x091E, 0x091E}, {0x091F, 0x091F, 0x091F},
    {0x0920, 0x0920, 0x0920}, {0x0921, 0x0921, 0x0921},
    {0x0922, 0x0922, 0x0922}, {0x0923, 0x0923, 0x0923},
    {0x0924, 0x0924, 0x0924}, {0x0925, 0x0925, 0x0925},
    {0x0926, 0x0926, 0x0926}, {0x0927, 0x0927, 0x0927},
    {0x0928, 0x0928, 0x0928}, {0x0929, 0x0929, 0x0929},
    {0x092A, 0x092A, 0x092A}, {0x092B, 0x092B, 0x092B},
    {0x092C, 0x092C, 0x092C}, {0x092D, 0x092D, 0x092D},
    {0x092E, 0x092E, 0x092E}, {0x092F, 0x092F, 0x092F},
    {0x0930, 0x0930, 0x0930}, {0x0931, 0x0931, 0x0931},
    {0x0932, 0x0932, 0x0932}, {0x0933, 0x0933, 0x0933},
    {0x0934, 0x0934, 0x0934}, {0x0935, 0x0935, 0x0935},
    {0x0936, 0x0936, 0x0936}, {0x0937, 0x0937, 0x0937},
    {0x0938, 0x0938, 0x0938}, {0x0939, 0x0939, 0x0939},
    {0x093C, 0x093C, 0x093C}, {0x093D, 0x093D, 0x093D},
    {0x0941, 0x0941, 0x0941}, {0x0942, 0x0942, 0x0942},
    {0x0943, 0x0943, 0x0943}, {0x0944, 0x0944, 0x0944},
    {0x0945, 0x0945, 0x0945}, {0x0946, 0x0946, 0x0946},
    {0x0947, 0x0947, 0x0947}, {0x0948, 0x0948, 0x0948},
    {0x094D, 0x094D, 0x094D}, {0x0950, 0x0950, 0x0950},
    {0x0951, 0x0951, 0x0951}, {0x0952, 0x0952, 0x0952},
    {0x0953, 0x0953, 0x0953}, {0x0954, 0x0954, 0x0954},
    {0x0958, 0x0958, 0x0958}, {0x0959, 0x0959, 0x0959},
    {0x095A, 0x095A, 0x095A}, {0x095B, 0x095B, 0x095B},
    {0x095C, 0x095C, 0x095C}, {0x095D, 0x095D, 0x095D},
    {0x095E, 0x095E, 0x095E}, {0x095F, 0x095F, 0x095F},
    {0x0960, 0x0960, 0x0960}, {0x0961, 0x0961, 0x0961},
    {0x0962, 0x0962, 0x0962}, {0x0963, 0x0963, 0x0963},
    {0x097D, 0x097D, 0x097D}, {0x0981, 0x0981, 0x0981},
    {0x0985, 0x0985, 0x0985}, {0x0986, 0x0986, 0x0986},
    {0x0987, 0x0987, 0x0987}, {0x0988, 0x0988, 0x0988},
    {0x0989, 0x0989, 0x0989}, {0x098A, 0x098A, 0x098A},
    {0x098B, 0x098B, 0x098B}, {0x098C, 0x098C, 0x098C},
    {0x098F, 0x098F, 0x098F}, {0x0990, 0x0990, 0x0990},
    {0x0993, 0x0993, 0x0993}, {0x0994, 0x0994, 0x0994},
    {0x0995, 0x0995, 0x0995}, {0x0996, 0x0996, 0x0996},
    {0x0997, 0x0997, 0x0997}, {0x0998, 0x0998, 0x0998},
    {0x0999, 0x0999, 0x0999}, {0x099A, 0x099A, 0x099A},
    {0x099B, 0x099B, 0x099B}, {0x099C, 0x099C, 0x099C},
    {0x099D, 0x099D, 0x099D}, {0x099E, 0x099E, 0x099E},
    {0x099F, 0x099F, 0x099F}, {0x09A0, 0x09A0, 0x09A0},
    {0x09A1, 0x09A1, 0x09A1}, {0x09A2, 0x09A2, 0x09A2},
    {0x09A3, 0x09A3, 0x09A3}, {0x09A4, 0x09A4, 0x09A4},
    {0x09A5, 0x09A5, 0x09A5}, {0x09A6, 0x09A6, 0x09A6},
    {0x09A7, 0x09A7, 0x09A7}, {0x09A8, 0x09A8, 0x09A8},
    {0x09AA, 0x09AA, 0x09AA}, {0x09AB, 0x09AB, 0x09AB},
    {0x09AC, 0x09AC, 0x09AC}, {0x09AD, 0x09AD, 0x09AD},
    {0x09AE, 0x09AE, 0x09AE}, {0x09AF, 0x09AF, 0x09AF},
    {0x09B0, 0x09B0, 0x09B0}, {0x09B2, 0x09B2, 0x09B2},
    {0x09B6, 0x09B6, 0x09B6}, {0x09B7, 0x09B7, 0x09B7},
    {0x09B8, 0x09B8, 0x09B8}, {0x09B9, 0x09B9, 0x09B9},
    {0x09BC, 0x09BC, 0x09BC}, {0x09BD, 0x09BD, 0x09BD},
    {0x09C1, 0x09C1, 0x09C1}, {0x09C2, 0x09C2, 0x09C2},
    {0x09C3, 0x09C3, 0x09C3}, {0x09C4, 0x09C4, 0x09C4},
    {0x09CD, 0x09CD, 0x09CD}, {0x09CE, 0x09CE, 0x09CE},
    {0x09DC, 0x09DC, 0x09DC}, {0x09DD, 0x09DD, 0x09DD},
    {0x09DF, 0x09DF, 0x09DF}, {0x09E0, 0x09E0, 0x09E0},
    {0x09E1, 0x09E1, 0x09E1}, {0x09E2, 0x09E2, 0x09E2},
    {0x09E3, 0x09E3, 0x09E3}, {0x09F0, 0x09F0, 0x09F0},
    {0x09F1, 0x09F1, 0x09F1}, {0x0A01, 0x0A01, 0x0A01},
    {0x0A02, 0x0A02, 0x0A02}, {0x0A05, 0x0A05, 0x0A05},
    {0x0A06, 0x0A06, 0x0A06}, {0x0A07, 0x0A07, 0x0A07},
    {0x0A08, 0x0A08, 0x0A08}, {0x0A09, 0x0A09, 0x0A09},
    {0x0A0A, 0x0A0A, 0x0A0A}, {0x0A0F, 0x0A0F, 0x0A0F},
    {0x0A10, 0x0A10, 0x0A10}, {0x0A13, 0x0A13, 0x0A13},
    {0x0A14, 0x0A14, 0x0A14}, {0x0A15, 0x0A15, 0x0A15},
    {0x0A16, 0x0A16, 0x0A16}, {0x0A17, 0x0A17, 0x0A17},
    {0x0A18, 0x0A18, 0x0A18}, {0x0A19, 0x0A19, 0x0A19},
    {0x0A1A, 0x0A1A, 0x0A1A}, {0x0A1B, 0x0A1B, 0x0A1B},
    {0x0A1C, 0x0A1C, 0x0A1C}, {0x0A1D, 0x0A1D, 0x0A1D},
    {0x0A1E, 0x0A1E, 0x0A1E}, {0x0A1F, 0x0A1F, 0x0A1F},
    {0x0A20, 0x0A20, 0x0A20}, {0x0A21, 0x0A21, 0x0A21},
    {0x0A22, 0x0A22, 0x0A22}, {0x0A23, 0x0A23, 0x0A23},
    {0x0A24, 0x0A24, 0x0A24}, {0x0A25, 0x0A25, 0x0A25},
    {0x0A26, 0x0A26, 0x0A26}, {0x0A27, 0x0A27, 0x0A27},
    {0x0A28, 0x0A28, 0x0A28}, {0x0A2A, 0x0A2A, 0x0A2A},
    {0x0A2B, 0x0A2B, 0x0A2B}, {0x0A2C, 0x0A2C, 0x0A2C},
    {0x0A2D, 0x0A2D, 0x0A2D}, {0x0A2E, 0x0A2E, 0x0A2E},
    {0x0A2F, 0x0A2F, 0x0A2F}, {0x0A30, 0x0A30, 0x0A30},
    {0x0A32, 0x0A32, 0x0A32}, {0x0A33, 0x0A33, 0x0A33},
    {0x0A35, 0x0A35, 0x0A35}, {0x0A36, 0x0A36, 0x0A36},
    {0x0A38, 0x0A38, 0x0A38}, {0x0A39, 0x0A39, 0x0A39},
    {0x0A3C, 0x0A3C, 0x0A3C}, {0x0A41, 0x0A41, 0x0A41},
    {0x0A42, 0x0A42, 0x0A42}, {0x0A47, 0x0A47, 0x0A47},
    {0x0A48, 0x0A48, 0x0A48}, {0x0A4B, 0x0A4B, 0x0A4B},
    {0x0A4C, 0x0A4C, 0x0A4C}, {0x0A4D, 0x0A4D, 0x0A4D},
    {0x0A59, 0x0A59, 0x0A59}, {0x0A5A, 0x0A5A, 0x0A5A},
    {0x0A5B, 0x0A5B, 0x0A5B}, {0x0A5C, 0x0A5C, 0x0A5C},
    {0x0A5E, 0x0A5E, 0x0A5E}, {0x0A70, 0x0A70, 0x0A70},
    {0x0A71, 0x0A71, 0x0A71}, {0x0A72, 0x0A72, 0x0A72},
    {0x0A73, 0x0A73, 0x0A73}, {0x0A74, 0x0A74, 0x0A74},
    {0x0A81, 0x0A81, 0x0A81}, {0x0A82, 0x0A82, 0x0A82},
    {0x0A85, 0x0A85, 0x0A85}, {0x0A86, 0x0A86, 0x0A86},
    {0x0A87, 0x0A87, 0x0A87}, {0x0A88, 0x0A88, 0x0A88},
    {0x0A89, 0x0A89, 0x0A89}, {0x0A8A, 0x0A8A, 0x0A8A},
    {0x0A8B, 0x0A8B, 0x0A8B}, {0x0A8C, 0x0A8C, 0x0A8C},
    {0x0A8D, 0x0A8D, 0x0A8D}, {0x0A8F, 0x0A8F, 0x0A8F},
    {0x0A90, 0x0A90, 0x0A90}, {0x0A91, 0x0A91, 0x0A91},
    {0x0A93, 0x0A93, 0x0A93}, {0x0A94, 0x0A94, 0x0A94},
    {0x0A95, 0x0A95, 0x0A95}, {0x0A96, 0x0A96, 0x0A96},
    {0x0A97, 0x0A97, 0x0A97}, {0x0A98, 0x0A98, 0x0A98},
    {0x0A99, 0x0A99, 0x0A99}, {0x0A9A, 0x0A9A, 0x0A9A},
    {0x0A9B, 0x0A9B, 0x0A9B}, {0x0A9C, 0x0A9C, 0x0A9C},
    {0x0A9D, 0x0A9D, 0x0A9D}, {0x0A9E, 0x0A9E, 0x0A9E},
    {0x0A9F, 0x0A9F, 0x0A9F}, {0x0AA0, 0x0AA0, 0x0AA0},
    {0x0AA1, 0x0AA1, 0x0AA1}, {0x0AA2, 0x0AA2, 0x0AA2},
    {0x0AA3, 0x0AA3, 0x0AA3}, {0x0AA4, 0x0AA4, 0x0AA4},
    {0x0AA5, 0x0AA5, 0x0AA5}, {0x0AA6, 0x0AA6, 0x0AA6},
    {0x0AA7, 0x0AA7, 0x0AA7}, {0x0AA8, 0x0AA8, 0x0AA8},
    {0x0AAA, 0x0AAA, 0x0AAA}, {0x0AAB, 0x0AAB, 0x0AAB},
    {0x0AAC, 0x0AAC, 0x0AAC}, {0x0AAD, 0x0AAD, 0x0AAD},
    {0x0AAE, 0x0AAE, 0x0AAE}, {0x0AAF, 0x0AAF, 0x0AAF},
    {0x0AB0, 0x0AB0, 0x0AB0}, {0x0AB2, 0x0AB2, 0x0AB2},
    {0x0AB3, 0x0AB3, 0x0AB3}, {0x0AB5, 0x0AB5, 0x0AB5},
    {0x0AB6, 0x0AB6, 0x0AB6}, {0x0AB7, 0x0AB7, 0x0AB7},
    {0x0AB8, 0x0AB8, 0x0AB8}, {0x0AB9, 0x0AB9, 0x0AB9},
    {0x0ABC, 0x0ABC, 0x0ABC}, {0x0ABD, 0x0ABD, 0x0ABD},
    {0x0AC1, 0x0AC1, 0x0AC1}, {0x0AC2, 0x0AC2, 0x0AC2},
    {0x0AC3, 0x0AC3, 0x0AC3}, {0x0AC4, 0x0AC4, 0x0AC4},
    {0x0AC5, 0x0AC5, 0x0AC5}, {0x0AC7, 0x0AC7, 0x0AC7},
    {0x0AC8, 0x0AC8, 0x0AC8}, {0x0ACD, 0x0ACD, 0x0ACD},
    {0x0AD0, 0x0AD0, 0x0AD0}, {0x0AE0, 0x0AE0, 0x0AE0},
    {0x0AE1, 0x0AE1, 0x0AE1}, {0x0AE2, 0x0AE2, 0x0AE2},
    {0x0AE3, 0x0AE3, 0x0AE3}, {0x0B01, 0x0B01, 0x0B01},
    {0x0B05, 0x0B05, 0x0B05}, {0x0B06, 0x0B06, 0x0B06},
    {0x0B07, 0x0B07, 0x0B07}, {0x0B08, 0x0B08, 0x0B08},
    {0x0B09, 0x0B09, 0x0B09}, {0x0B0A, 0x0B0A, 0x0B0A},
    {0x0B0B, 0x0B0B, 0x0B0B}, {0x0B0C, 0x0B0C, 0x0B0C},
    {0x0B0F, 0x0B0F, 0x0B0F}, {0x0B10, 0x0B10, 0x0B10},
    {0x0B13, 0x0B13, 0x0B13}, {0x0B14, 0x0B14, 0x0B14},
    {0x0B15, 0x0B15, 0x0B15}, {0x0B16, 0x0B16, 0x0B16},
    {0x0B17, 0x0B17, 0x0B17}, {0x0B18, 0x0B18, 0x0B18},
    {0x0B19, 0x0B19, 0x0B19}, {0x0B1A, 0x0B1A, 0x0B1A},
    {0x0B1B, 0x0B1B, 0x0B1B}, {0x0B1C, 0x0B1C, 0x0B1C},
    {0x0B1D, 0x0B1D, 0x0B1D}, {0x0B1E, 0x0B1E, 0x0B1E},
    {0x0B1F, 0x0B1F, 0x0B1F}, {0x0B20, 0x0B20, 0x0B20},
    {0x0B21, 0x0B21, 0x0B21}, {0x0B22, 0x0B22, 0x0B22},
    {0x0B23, 0x0B23, 0x0B23}, {0x0B24, 0x0B24, 0x0B24},
    {0x0B25, 0x0B25, 0x0B25}, {0x0B26, 0x0B26, 0x0B26},
    {0x0B27, 0x0B27, 0x0B27}, {0x0B28, 0x0B28, 0x0B28},
    {0x0B2A, 0x0B2A, 0x0B2A}, {0x0B2B, 0x0B2B, 0x0B2B},
    {0x0B2C, 0x0B2C, 0x0B2C}, {0x0B2D, 0x0B2D, 0x0B2D},
    {0x0B2E, 0x0B2E, 0x0B2E}, {0x0B2F, 0x0B2F, 0x0B2F},
    {0x0B30, 0x0B30, 0x0B30}, {0x0B32, 0x0B32, 0x0B32},
    {0x0B33, 0x0B33, 0x0B33}, {0x0B35, 0x0B35, 0x0B35},
    {0x0B36, 0x0B36, 0x0B36}, {0x0B37, 0x0B37, 0x0B37},
    {0x0B38, 0x0B38, 0x0B38}, {0x0B39, 0x0B39, 0x0B39},
    {0x0B3C, 0x0B3C, 0x0B3C}, {0x0B3D, 0x0B3D, 0x0B3D},
    {0x0B3F, 0x0B3F, 0x0B3F}, {0x0B41, 0x0B41, 0x0B41},
    {0x0B42, 0x0B42, 0x0B42}, {0x0B43, 0x0B43, 0x0B43},
    {0x0B4D, 0x0B4D, 0x0B4D}, {0x0B56, 0x0B56, 0x0B56},
    {0x0B5C, 0x0B5C, 0x0B5C}, {0x0B5D, 0x0B5D, 0x0B5D},
    {0x0B5F, 0x0B5F, 0x0B5F}, {0x0B60, 0x0B60, 0x0B60},
    {0x0B61, 0x0B61, 0x0B61}, {0x0B71, 0x0B71, 0x0B71},
    {0x0B82, 0x0B82, 0x0B82}, {0x0B83, 0x0B83, 0x0B83},
    {0x0B85, 0x0B85, 0x0B85}, {0x0B86, 0x0B86, 0x0B86},
    {0x0B87, 0x0B87, 0x0B87}, {0x0B88, 0x0B88, 0x0B88},
    {0x0B89, 0x0B89, 0x0B89}, {0x0B8A, 0x0B8A, 0x0B8A},
    {0x0B8E, 0x0B8E, 0x0B8E}, {0x0B8F, 0x0B8F, 0x0B8F},
    {0x0B90, 0x0B90, 0x0B90}, {0x0B92, 0x0B92, 0x0B92},
    {0x0B93, 0x0B93, 0x0B93}, {0x0B94, 0x0B94, 0x0B94},
    {0x0B95, 0x0B95, 0x0B95}, {0x0B99, 0x0B99, 0x0B99},
    {0x0B9A, 0x0B9A, 0x0B9A}, {0x0B9C, 0x0B9C, 0x0B9C},
    {0x0B9E, 0x0B9E, 0x0B9E}, {0x0B9F, 0x0B9F, 0x0B9F},
    {0x0BA3, 0x0BA3, 0x0BA3}, {0x0BA4, 0x0BA4, 0x0BA4},
    {0x0BA8, 0x0BA8, 0x0BA8}, {0x0BA9, 0x0BA9, 0x0BA9},
    {0x0BAA, 0x0BAA, 0x0BAA}, {0x0BAE, 0x0BAE, 0x0BAE},
    {0x0BAF, 0x0BAF, 0x0BAF}, {0x0BB0, 0x0BB0, 0x0BB0},
    {0x0BB1, 0x0BB1, 0x0BB1}, {0x0BB2, 0x0BB2, 0x0BB2},
    {0x0BB3, 0x0BB3, 0x0BB3}, {0x0BB4, 0x0BB4, 0x0BB4},
    {0x0BB5, 0x0BB5, 0x0BB5}, {0x0BB6, 0x0BB6, 0x0BB6},
    {0x0BB7, 0x0BB7, 0x0BB7}, {0x0BB8, 0x0BB8, 0x0BB8},
    {0x0BB9, 0x0BB9, 0x0BB9}, {0x0BC0, 0x0BC0, 0x0BC0},
    {0x0BCD, 0x0BCD, 0x0BCD}, {0x0C05, 0x0C05, 0x0C05},
    {0x0C06, 0x0C06, 0x0C06}, {0x0C07, 0x0C07, 0x0C07},
    {0x0C08, 0x0C08, 0x0C08}, {0x0C09, 0x0C09, 0x0C09},
    {0x0C0A, 0x0C0A, 0x0C0A}, {0x0C0B, 0x0C0B, 0x0C0B},
    {0x0C0C, 0x0C0C, 0x0C0C}, {0x0C0E, 0x0C0E, 0x0C0E},
    {0x0C0F, 0x0C0F, 0x0C0F}, {0x0C10, 0x0C10, 0x0C10},
    {0x0C12, 0x0C12, 0x0C12}, {0x0C13, 0x0C13, 0x0C13},
    {0x0C14, 0x0C14, 0x0C14}, {0x0C15, 0x0C15, 0x0C15},
    {0x0C16, 0x0C16, 0x0C16}, {0x0C17, 0x0C17, 0x0C17},
    {0x0C18, 0x0C18, 0x0C18}, {0x0C19, 0x0C19, 0x0C19},
    {0x0C1A, 0x0C1A, 0x0C1A}, {0x0C1B, 0x0C1B, 0x0C1B},
    {0x0C1C, 0x0C1C, 0x0C1C}, {0x0C1D, 0x0C1D, 0x0C1D},
    {0x0C1E, 0x0C1E, 0x0C1E}, {0x0C1F, 0x0C1F, 0x0C1F},
    {0x0C20, 0x0C20, 0x0C20}, {0x0C21, 0x0C21, 0x0C21},
    {0x0C22, 0x0C22, 0x0C22}, {0x0C23, 0x0C23, 0x0C23},
    {0x0C24, 0x0C24, 0x0C24}, {0x0C25, 0x0C25, 0x0C25},
    {0x0C26, 0x0C26, 0x0C26}, {0x0C27, 0x0C27, 0x0C27},
    {0x0C28, 0x0C28, 0x0C28}, {0x0C2A, 0x0C2A, 0x0C2A},
    {0x0C2B, 0x0C2B, 0x0C2B}, {0x0C2C, 0x0C2C, 0x0C2C},
    {0x0C2D, 0x0C2D, 0x0C2D}, {0x0C2E, 0x0C2E, 0x0C2E},
    {0x0C2F, 0x0C2F, 0x0C2F}, {0x0C30, 0x0C30, 0x0C30},
    {0x0C31, 0x0C31, 0x0C31}, {0x0C32, 0x0C32, 0x0C32},
    {0x0C33, 0x0C33, 0x0C33}, {0x0C35, 0x0C35, 0x0C35},
    {0x0C36, 0x0C36, 0x0C36}, {0x0C37, 0x0C37, 0x0C37},
    {0x0C38, 0x0C38, 0x0C38}, {0x0C39, 0x0C39, 0x0C39},
    {0x0C3E, 0x0C3E, 0x0C3E}, {0x0C3F, 0x0C3F, 0x0C3F},
    {0x0C40, 0x0C40, 0x0C40}, {0x0C46, 0x0C46, 0x0C46},
    {0x0C47, 0x0C47, 0x0C47}, {0x0C48, 0x0C48, 0x0C48},
    {0x0C4A, 0x0C4A, 0x0C4A}, {0x0C4B, 0x0C4B, 0x0C4B},
    {0x0C4C, 0x0C4C, 0x0C4C}, {0x0C4D, 0x0C4D, 0x0C4D},
    {0x0C55, 0x0C55, 0x0C55}, {0x0C56, 0x0C56, 0x0C56},
    {0x0C60, 0x0C60, 0x0C60}, {0x0C61, 0x0C61, 0x0C61},
    {0x0C85, 0x0C85, 0x0C85}, {0x0C86, 0x0C86, 0x0C86},
    {0x0C87, 0x0C87, 0x0C87}, {0x0C88, 0x0C88, 0x0C88},
    {0x0C89, 0x0C89, 0x0C89}, {0x0C8A, 0x0C8A, 0x0C8A},
    {0x0C8B, 0x0C8B, 0x0C8B}, {0x0C8C, 0x0C8C, 0x0C8C},
    {0x0C8E, 0x0C8E, 0x0C8E}, {0x0C8F, 0x0C8F, 0x0C8F},
    {0x0C90, 0x0C90, 0x0C90}, {0x0C92, 0x0C92, 0x0C92},
    {0x0C93, 0x0C93, 0x0C93}, {0x0C94, 0x0C94, 0x0C94},
    {0x0C95, 0x0C95, 0x0C95}, {0x0C96, 0x0C96, 0x0C96},
    {0x0C97, 0x0C97, 0x0C97}, {0x0C98, 0x0C98, 0x0C98},
    {0x0C99, 0x0C99, 0x0C99}, {0x0C9A, 0x0C9A, 0x0C9A},
    {0x0C9B, 0x0C9B, 0x0C9B}, {0x0C9C, 0x0C9C, 0x0C9C},
    {0x0C9D, 0x0C9D, 0x0C9D}, {0x0C9E, 0x0C9E, 0x0C9E},
    {0x0C9F, 0x0C9F, 0x0C9F}, {0x0CA0, 0x0CA0, 0x0CA0},
    {0x0CA1, 0x0CA1, 0x0CA1}, {0x0CA2, 0x0CA2, 0x0CA2},
    {0x0CA3, 0x0CA3, 0x0CA3}, {0x0CA4, 0x0CA4, 0x0CA4},
    {0x0CA5, 0x0CA5, 0x0CA5}, {0x0CA6, 0x0CA6, 0x0CA6},
    {0x0CA7, 0x0CA7, 0x0CA7}, {0x0CA8, 0x0CA8, 0x0CA8},
    {0x0CAA, 0x0CAA, 0x0CAA}, {0x0CAB, 0x0CAB, 0x0CAB},
    {0x0CAC, 0x0CAC, 0x0CAC}, {0x0CAD, 0x0CAD, 0x0CAD},
    {0x0CAE, 0x0CAE, 0x0CAE}, {0x0CAF, 0x0CAF, 0x0CAF},
    {0x0CB0, 0x0CB0, 0x0CB0}, {0x0CB1, 0x0CB1, 0x0CB1},
    {0x0CB2, 0x0CB2, 0x0CB2}, {0x0CB3, 0x0CB3, 0x0CB3},
    {0x0CB5, 0x0CB5, 0x0CB5}, {0x0CB6, 0x0CB6, 0x0CB6},
    {0x0CB7, 0x0CB7, 0x0CB7}, {0x0CB8, 0x0CB8, 0x0CB8},
    {0x0CB9, 0x0CB9, 0x0CB9}, {0x0CBC, 0x0CBC, 0x0CBC},
    {0x0CBD, 0x0CBD, 0x0CBD}, {0x0CBF, 0x0CBF, 0x0CBF},
    {0x0CC6, 0x0CC6, 0x0CC6}, {0x0CCC, 0x0CCC, 0x0CCC},
    {0x0CCD, 0x0CCD, 0x0CCD}, {0x0CDE, 0x0CDE, 0x0CDE},
    {0x0CE0, 0x0CE0, 0x0CE0}, {0x0CE1, 0x0CE1, 0x0CE1},
    {0x0D05, 0x0D05, 0x0D05}, {0x0D06, 0x0D06, 0x0D06},
    {0x0D07, 0x0D07, 0x0D07}, {0x0D08, 0x0D08, 0x0D08},
    {0x0D09, 0x0D09, 0x0D09}, {0x0D0A, 0x0D0A, 0x0D0A},
    {0x0D0B, 0x0D0B, 0x0D0B}, {0x0D0C, 0x0D0C, 0x0D0C},
    {0x0D0E, 0x0D0E, 0x0D0E}, {0x0D0F, 0x0D0F, 0x0D0F},
    {0x0D10, 0x0D10, 0x0D10}, {0x0D12, 0x0D12, 0x0D12},
    {0x0D13, 0x0D13, 0x0D13}, {0x0D14, 0x0D14, 0x0D14},
    {0x0D15, 0x0D15, 0x0D15}, {0x0D16, 0x0D16, 0x0D16},
    {0x0D17, 0x0D17, 0x0D17}, {0x0D18, 0x0D18, 0x0D18},
    {0x0D19, 0x0D19, 0x0D19}, {0x0D1A, 0x0D1A, 0x0D1A},
    {0x0D1B, 0x0D1B, 0x0D1B}, {0x0D1C, 0x0D1C, 0x0D1C},
    {0x0D1D, 0x0D1D, 0x0D1D}, {0x0D1E, 0x0D1E, 0x0D1E},
    {0x0D1F, 0x0D1F, 0x0D1F}, {0x0D20, 0x0D20, 0x0D20},
    {0x0D21, 0x0D21, 0x0D21}, {0x0D22, 0x0D22, 0x0D22},
    {0x0D23, 0x0D23, 0x0D23}, {0x0D24, 0x0D24, 0x0D24},
    {0x0D25, 0x0D25, 0x0D25}, {0x0D26, 0x0D26, 0x0D26},
    {0x0D27, 0x0D27, 0x0D27}, {0x0D28, 0x0D28, 0x0D28},
    {0x0D2A, 0x0D2A, 0x0D2A}, {0x0D2B, 0x0D2B, 0x0D2B},
    {0x0D2C, 0x0D2C, 0x0D2C}, {0x0D2D, 0x0D2D, 0x0D2D},
    {0x0D2E, 0x0D2E, 0x0D2E}, {0x0D2F, 0x0D2F, 0x0D2F},
    {0x0D30, 0x0D30, 0x0D30}, {0x0D31, 0x0D31, 0x0D31},
    {0x0D32, 0x0D32, 0x0D32}, {0x0D33, 0x0D33, 0x0D33},
    {0x0D34, 0x0D34, 0x0D34}, {0x0D35, 0x0D35, 0x0D35},
    {0x0D36, 0x0D36, 0x0D36}, {0x0D37, 0x0D37, 0x0D37},
    {0x0D38, 0x0D38, 0x0D38}, {0x0D39, 0x0D39, 0x0D39},
    {0x0D41, 0x0D41, 0x0D41}, {0x0D42, 0x0D42, 0x0D42},
    {0x0D43, 0x0D43, 0x0D43}, {0x0D4D, 0x0D4D, 0x0D4D},
    {0x0D60, 0x0D60, 0x0D60}, {0x0D61, 0x0D61, 0x0D61},
    {0x0D85, 0x0D85, 0x0D85}, {0x0D86, 0x0D86, 0x0D86},
    {0x0D87, 0x0D87, 0x0D87}, {0x0D88, 0x0D88, 0x0D88},
    {0x0D89, 0x0D89, 0x0D89}, {0x0D8A, 0x0D8A, 0x0D8A},
    {0x0D8B, 0x0D8B, 0x0D8B}, {0x0D8C, 0x0D8C, 0x0D8C},
    {0x0D8D, 0x0D8D, 0x0D8D}, {0x0D8E, 0x0D8E, 0x0D8E},
    {0x0D8F, 0x0D8F, 0x0D8F}, {0x0D90, 0x0D90, 0x0D90},
    {0x0D91, 0x0D91, 0x0D91}, {0x0D92, 0x0D92, 0x0D92},
    {0x0D93, 0x0D93, 0x0D93}, {0x0D94, 0x0D94, 0x0D94},
    {0x0D95, 0x0D95, 0x0D95}, {0x0D96, 0x0D96, 0x0D96},
    {0x0D9A, 0x0D9A, 0x0D9A}, {0x0D9B, 0x0D9B, 0x0D9B},
    {0x0D9C, 0x0D9C, 0x0D9C}, {0x0D9D, 0x0D9D, 0x0D9D},
    {0x0D9E, 0x0D9E, 0x0D9E}, {0x0D9F, 0x0D9F, 0x0D9F},
    {0x0DA0, 0x0DA0, 0x0DA0}, {0x0DA1, 0x0DA1, 0x0DA1},
    {0x0DA2, 0x0DA2, 0x0DA2}, {0x0DA3, 0x0DA3, 0x0DA3},
    {0x0DA4, 0x0DA4, 0x0DA4}, {0x0DA5, 0x0DA5, 0x0DA5},
    {0x0DA6, 0x0DA6, 0x0DA6}, {0x0DA7, 0x0DA7, 0x0DA7},
    {0x0DA8, 0x0DA8, 0x0DA8}, {0x0DA9, 0x0DA9, 0x0DA9},
    {0x0DAA, 0x0DAA, 0x0DAA}, {0x0DAB, 0x0DAB, 0x0DAB},
    {0x0DAC, 0x0DAC, 0x0DAC}, {0x0DAD, 0x0DAD, 0x0DAD},
    {0x0DAE, 0x0DAE, 0x0DAE}, {0x0DAF, 0x0DAF, 0x0DAF},
    {0x0DB0, 0x0DB0, 0x0DB0}, {0x0DB1, 0x0DB1, 0x0DB1},
    {0x0DB3, 0x0DB3, 0x0DB3}, {0x0DB4, 0x0DB4, 0x0DB4},
    {0x0DB5, 0x0DB5, 0x0DB5}, {0x0DB6, 0x0DB6, 0x0DB6},
    {0x0DB7, 0x0DB7, 0x0DB7}, {0x0DB8, 0x0DB8, 0x0DB8},
    {0x0DB9, 0x0DB9, 0x0DB9}, {0x0DBA, 0x0DBA, 0x0DBA},
    {0x0DBB, 0x0DBB, 0x0DBB}, {0x0DBD, 0x0DBD, 0x0DBD},
    {0x0DC0, 0x0DC0, 0x0DC0}, {0x0DC1, 0x0DC1, 0x0DC1},
    {0x0DC2, 0x0DC2, 0x0DC2}, {0x0DC3, 0x0DC3, 0x0DC3},
    {0x0DC4, 0x0DC4, 0x0DC4}, {0x0DC5, 0x0DC5, 0x0DC5},
    {0x0DC6, 0x0DC6, 0x0DC6}, {0x0DCA, 0x0DCA, 0x0DCA},
    {0x0DD2, 0x0DD2, 0x0DD2}, {0x0DD3, 0x0DD3, 0x0DD3},
    {0x0DD4, 0x0DD4, 0x0DD4}, {0x0DD6, 0x0DD6, 0x0DD6},
    {0x0E01, 0x0E01, 0x0E01}, {0x0E02, 0x0E02, 0x0E02},
    {0x0E03, 0x0E03, 0x0E03}, {0x0E04, 0x0E04, 0x0E04},
    {0x0E05, 0x0E05, 0x0E05}, {0x0E06, 0x0E06, 0x0E06},
    {0x0E07, 0x0E07, 0x0E07}, {0x0E08, 0x0E08, 0x0E08},
    {0x0E09, 0x0E09, 0x0E09}, {0x0E0A, 0x0E0A, 0x0E0A},
    {0x0E0B, 0x0E0B, 0x0E0B}, {0x0E0C, 0x0E0C, 0x0E0C},
    {0x0E0D, 0x0E0D, 0x0E0D}, {0x0E0E, 0x0E0E, 0x0E0E},
    {0x0E0F, 0x0E0F, 0x0E0F}, {0x0E10, 0x0E10, 0x0E10},
    {0x0E11, 0x0E11, 0x0E11}, {0x0E12, 0x0E12, 0x0E12},
    {0x0E13, 0x0E13, 0x0E13}, {0x0E14, 0x0E14, 0x0E14},
    {0x0E15, 0x0E15, 0x0E15}, {0x0E16, 0x0E16, 0x0E16},
    {0x0E17, 0x0E17, 0x0E17}, {0x0E18, 0x0E18, 0x0E18},
    {0x0E19, 0x0E19, 0x0E19}, {0x0E1A, 0x0E1A, 0x0E1A},
    {0x0E1B, 0x0E1B, 0x0E1B}, {0x0E1C, 0x0E1C, 0x0E1C},
    {0x0E1D, 0x0E1D, 0x0E1D}, {0x0E1E, 0x0E1E, 0x0E1E},
    {0x0E1F, 0x0E1F, 0x0E1F}, {0x0E20, 0x0E20, 0x0E20},
    {0x0E21, 0x0E21, 0x0E21}, {0x0E22, 0x0E22, 0x0E22},
    {0x0E23, 0x0E23, 0x0E23}, {0x0E24, 0x0E24, 0x0E24},
    {0x0E25, 0x0E25, 0x0E25}, {0x0E26, 0x0E26, 0x0E26},
    {0x0E27, 0x0E27, 0x0E27}, {0x0E28, 0x0E28, 0x0E28},
    {0x0E29, 0x0E29, 0x0E29}, {0x0E2A, 0x0E2A, 0x0E2A},
    {0x0E2B, 0x0E2B, 0x0E2B}, {0x0E2C, 0x0E2C, 0x0E2C},
    {0x0E2D, 0x0E2D, 0x0E2D}, {0x0E2E, 0x0E2E, 0x0E2E},
    {0x0E2F, 0x0E2F, 0x0E2F}, {0x0E30, 0x0E30, 0x0E30},
    {0x0E31, 0x0E31, 0x0E31}, {0x0E32, 0x0E32, 0x0E32},
    {0x0E33, 0x0E33, 0x0E33}, {0x0E34, 0x0E34, 0x0E34},
    {0x0E35, 0x0E35, 0x0E35}, {0x0E36, 0x0E36, 0x0E36},
    {0x0E37, 0x0E37, 0x0E37}, {0x0E38, 0x0E38, 0x0E38},
    {0x0E39, 0x0E39, 0x0E39}, {0x0E3A, 0x0E3A, 0x0E3A},
    {0x0E40, 0x0E40, 0x0E40}, {0x0E41, 0x0E41, 0x0E41},
    {0x0E42, 0x0E42, 0x0E42}, {0x0E43, 0x0E43, 0x0E43},
    {0x0E44, 0x0E44, 0x0E44}, {0x0E45, 0x0E45, 0x0E45},
    {0x0E46, 0x0E46, 0x0E46}, {0x0E47, 0x0E47, 0x0E47},
    {0x0E48, 0x0E48, 0x0E48}, {0x0E49, 0x0E49, 0x0E49},
    {0x0E4A, 0x0E4A, 0x0E4A}, {0x0E4B, 0x0E4B, 0x0E4B},
    {0x0E4C, 0x0E4C, 0x0E4C}, {0x0E4D, 0x0E4D, 0x0E4D},
    {0x0E4E, 0x0E4E, 0x0E4E}, {0x0E81, 0x0E81, 0x0E81},
    {0x0E82, 0x0E82, 0x0E82}, {0x0E84, 0x0E84, 0x0E84},
    {0x0E87, 0x0E87, 0x0E87}, {0x0E88, 0x0E88, 0x0E88},
    {0x0E8A, 0x0E8A, 0x0E8A}, {0x0E8D, 0x0E8D, 0x0E8D},
    {0x0E94, 0x0E94, 0x0E94}, {0x0E95, 0x0E95, 0x0E95},
    {0x0E96, 0x0E96, 0x0E96}, {0x0E97, 0x0E97, 0x0E97},
    {0x0E99, 0x0E99, 0x0E99}, {0x0E9A, 0x0E9A, 0x0E9A},
    {0x0E9B, 0x0E9B, 0x0E9B}, {0x0E9C, 0x0E9C, 0x0E9C},
    {0x0E9D, 0x0E9D, 0x0E9D}, {0x0E9E, 0x0E9E, 0x0E9E},
    {0x0E9F, 0x0E9F, 0x0E9F}, {0x0EA1, 0x0EA1, 0x0EA1},
    {0x0EA2, 0x0EA2, 0x0EA2}, {0x0EA3, 0x0EA3, 0x0EA3},
    {0x0EA5, 0x0EA5, 0x0EA5}, {0x0EA7, 0x0EA7, 0x0EA7},
    {0x0EAA, 0x0EAA, 0x0EAA}, {0x0EAB, 0x0EAB, 0x0EAB},
    {0x0EAD, 0x0EAD, 0x0EAD}, {0x0EAE, 0x0EAE, 0x0EAE},
    {0x0EAF, 0x0EAF, 0x0EAF}, {0x0EB0, 0x0EB0, 0x0EB0},
    {0x0EB1, 0x0EB1, 0x0EB1}, {0x0EB2, 0x0EB2, 0x0EB2},
    {0x0EB3, 0x0EB3, 0x0EB3}, {0x0EB4, 0x0EB4, 0x0EB4},
    {0x0EB5, 0x0EB5, 0x0EB5}, {0x0EB6, 0x0EB6, 0x0EB6},
    {0x0EB7, 0x0EB7, 0x0EB7}, {0x0EB8, 0x0EB8, 0x0EB8},
    {0x0EB9, 0x0EB9, 0x0EB9}, {0x0EBB, 0x0EBB, 0x0EBB},
    {0x0EBC, 0x0EBC, 0x0EBC}, {0x0EBD, 0x0EBD, 0x0EBD},
    {0x0EC0, 0x0EC0, 0x0EC0}, {0x0EC1, 0x0EC1, 0x0EC1},
    {0x0EC2, 0x0EC2, 0x0EC2}, {0x0EC3, 0x0EC3, 0x0EC3},
    {0x0EC4, 0x0EC4, 0x0EC4}, {0x0EC6, 0x0EC6, 0x0EC6},
    {0x0EC8, 0x0EC8, 0x0EC8}, {0x0EC9, 0x0EC9, 0x0EC9},
    {0x0ECA, 0x0ECA, 0x0ECA}, {0x0ECB, 0x0ECB, 0x0ECB},
    {0x0ECC, 0x0ECC, 0x0ECC}, {0x0ECD, 0x0ECD, 0x0ECD},
    {0x0EDC, 0x0EDC, 0x0EDC}, {0x0EDD, 0x0EDD, 0x0EDD},
    {0x0F00, 0x0F00, 0x0F00}, {0x0F18, 0x0F18, 0x0F18},
    {0x0F19, 0x0F19, 0x0F19}, {0x0F35, 0x0F35, 0x0F35},
    {0x0F37, 0x0F37, 0x0F37}, {0x0F39, 0x0F39, 0x0F39},
    {0x0F40, 0x0F40, 0x0F40}, {0x0F41, 0x0F41, 0x0F41},
    {0x0F42, 0x0F42, 0x0F42}, {0x0F43, 0x0F43, 0x0F43},
    {0x0F44, 0x0F44, 0x0F44}, {0x0F45, 0x0F45, 0x0F45},
    {0x0F46, 0x0F46, 0x0F46}, {0x0F47, 0x0F47, 0x0F47},
    {0x0F49, 0x0F49, 0x0F49}, {0x0F4A, 0x0F4A, 0x0F4A},
    {0x0F4B, 0x0F4B, 0x0F4B}, {0x0F4C, 0x0F4C, 0x0F4C},
    {0x0F4D, 0x0F4D, 0x0F4D}, {0x0F4E, 0x0F4E, 0x0F4E},
    {0x0F4F, 0x0F4F, 0x0F4F}, {0x0F50, 0x0F50, 0x0F50},
    {0x0F51, 0x0F51, 0x0F51}, {0x0F52, 0x0F52, 0x0F52},
    {0x0F53, 0x0F53, 0x0F53}, {0x0F54, 0x0F54, 0x0F54},
    {0x0F55, 0x0F55, 0x0F55}, {0x0F56, 0x0F56, 0x0F56},
    {0x0F57, 0x0F57, 0x0F57}, {0x0F58, 0x0F58, 0x0F58},
    {0x0F59, 0x0F59, 0x0F59}, {0x0F5A, 0x0F5A, 0x0F5A},
    {0x0F5B, 0x0F5B, 0x0F5B}, {0x0F5C, 0x0F5C, 0x0F5C},
    {0x0F5D, 0x0F5D, 0x0F5D}, {0x0F5E, 0x0F5E, 0x0F5E},
    {0x0F5F, 0x0F5F, 0x0F5F}, {0x0F60, 0x0F60, 0x0F60},
    {0x0F61, 0x0F61, 0x0F61}, {0x0F62, 0x0F62, 0x0F62},
    {0x0F63, 0x0F63, 0x0F63}, {0x0F64, 0x0F64, 0x0F64},
    {0x0F65, 0x0F65, 0x0F65}, {0x0F66, 0x0F66, 0x0F66},
    {0x0F67, 0x0F67, 0x0F67}, {0x0F68, 0x0F68, 0x0F68},
    {0x0F69, 0x0F69, 0x0F69}, {0x0F6A, 0x0F6A, 0x0F6A},
    {0x0F71, 0x0F71, 0x0F71}, {0x0F72, 0x0F72, 0x0F72},
    {0x0F73, 0x0F73, 0x0F73}, {0x0F74, 0x0F74, 0x0F74},
    {0x0F75, 0x0F75, 0x0F75}, {0x0F76, 0x0F76, 0x0F76},
    {0x0F77, 0x0F77, 0x0F77}, {0x0F78, 0x0F78, 0x0F78},
    {0x0F79, 0x0F79, 0x0F79}, {0x0F7A, 0x0F7A, 0x0F7A},
    {0x0F7B, 0x0F7B, 0x0F7B}, {0x0F7C, 0x0F7C, 0x0F7C},
    {0x0F7D, 0x0F7D, 0x0F7D}, {0x0F7E, 0x0F7E, 0x0F7E},
    {0x0F80, 0x0F80, 0x0F80}, {0x0F81, 0x0F81, 0x0F81},
    {0x0F82, 0x0F82, 0x0F82}, {0x0F83, 0x0F83, 0x0F83},
    {0x0F84, 0x0F84, 0x0F84}, {0x0F86, 0x0F86, 0x0F86},
    {0x0F87, 0x0F87, 0x0F87}, {0x0F88, 0x0F88, 0x0F88},
    {0x0F89, 0x0F89, 0x0F89}, {0x0F8A, 0x0F8A, 0x0F8A},
    {0x0F8B, 0x0F8B, 0x0F8B}, {0x0F90, 0x0F90, 0x0F90},
    {0x0F91, 0x0F91, 0x0F91}, {0x0F92, 0x0F92, 0x0F92},
    {0x0F93, 0x0F93, 0x0F93}, {0x0F94, 0x0F94, 0x0F94},
    {0x0F95, 0x0F95, 0x0F95}, {0x0F96, 0x0F96, 0x0F96},
    {0x0F97, 0x0F97, 0x0F97}, {0x0F99, 0x0F99, 0x0F99},
    {0x0F9A, 0x0F9A, 0x0F9A}, {0x0F9B, 0x0F9B, 0x0F9B},
    {0x0F9C, 0x0F9C, 0x0F9C}, {0x0F9D, 0x0F9D, 0x0F9D},
    {0x0F9E, 0x0F9E, 0x0F9E}, {0x0F9F, 0x0F9F, 0x0F9F},
    {0x0FA0, 0x0FA0, 0x0FA0}, {0x0FA1, 0x0FA1, 0x0FA1},
    {0x0FA2, 0x0FA2, 0x0FA2}, {0x0FA3, 0x0FA3, 0x0FA3},
    {0x0FA4, 0x0FA4, 0x0FA4}, {0x0FA5, 0x0FA5, 0x0FA5},
    {0x0FA6, 0x0FA6, 0x0FA6}, {0x0FA7, 0x0FA7, 0x0FA7},
    {0x0FA8, 0x0FA8, 0x0FA8}, {0x0FA9, 0x0FA9, 0x0FA9},
    {0x0FAA, 0x0FAA, 0x0FAA}, {0x0FAB, 0x0FAB, 0x0FAB},
    {0x0FAC, 0x0FAC, 0x0FAC}, {0x0FAD, 0x0FAD, 0x0FAD},
    {0x0FAE, 0x0FAE, 0x0FAE}, {0x0FAF, 0x0FAF, 0x0FAF},
    {0x0FB0, 0x0FB0, 0x0FB0}, {0x0FB1, 0x0FB1, 0x0FB1},
    {0x0FB2, 0x0FB2, 0x0FB2}, {0x0FB3, 0x0FB3, 0x0FB3},
    {0x0FB4, 0x0FB4, 0x0FB4}, {0x0FB5, 0x0FB5, 0x0FB5},
    {0x0FB6, 0x0FB6, 0x0FB6}, {0x0FB7, 0x0FB7, 0x0FB7},
    {0x0FB8, 0x0FB8, 0x0FB8}, {0x0FB9, 0x0FB9, 0x0FB9},
    {0x0FBA, 0x0FBA, 0x0FBA}, {0x0FBB, 0x0FBB, 0x0FBB},
    {0x0FBC, 0x0FBC, 0x0FBC}, {0x0FC6, 0x0FC6, 0x0FC6},
    {0x1000, 0x1000, 0x1000}, {0x1001, 0x1001, 0x1001},
    {0x1002, 0x1002, 0x1002}, {0x1003, 0x1003, 0x1003},
    {0x1004, 0x1004, 0x1004}, {0x1005, 0x1005, 0x1005},
    {0x1006, 0x1006, 0x1006}, {0x1007, 0x1007, 0x1007},
    {0x1008, 0x1008, 0x1008}, {0x1009, 0x1009, 0x1009},
    {0x100A, 0x100A, 0x100A}, {0x100B, 0x100B, 0x100B},
    {0x100C, 0x100C, 0x100C}, {0x100D, 0x100D, 0x100D},
    {0x100E, 0x100E, 0x100E}, {0x100F, 0x100F, 0x100F},
    {0x1010, 0x1010, 0x1010}, {0x1011, 0x1011, 0x1011},
    {0x1012, 0x1012, 0x1012}, {0x1013, 0x1013, 0x1013},
    {0x1014, 0x1014, 0x1014}, {0x1015, 0x1015, 0x1015},
    {0x1016, 0x1016, 0x1016}, {0x1017, 0x1017, 0x1017},
    {0x1018, 0x1018, 0x1018}, {0x1019, 0x1019, 0x1019},
    {0x101A, 0x101A, 0x101A}, {0x101B, 0x101B, 0x101B},
    {0x101C, 0x101C, 0x101C}, {0x101D, 0x101D, 0x101D},
    {0x101E, 0x101E, 0x101E}, {0x101F, 0x101F, 0x101F},
    {0x1020, 0x1020, 0x1020}, {0x1021, 0x1021, 0x1021},
    {0x1023, 0x1023, 0x1023}, {0x1024, 0x1024, 0x1024},
    {0x1025, 0x1025, 0x1025}, {0x1026, 0x1026, 0x1026},
    {0x1027, 0x1027, 0x1027}, {0x1029, 0x1029, 0x1029},
    {0x102A, 0x102A, 0x102A}, {0x102D, 0x102D, 0x102D},
    {0x102E, 0x102E, 0x102E}, {0x102F, 0x102F, 0x102F},
    {0x1030, 0x1030, 0x1030}, {0x1032, 0x1032, 0x1032},
    {0x1036, 0x1036, 0x1036}, {0x1037, 0x1037, 0x1037},
    {0x1039, 0x1039, 0x1039}, {0x1050, 0x1050, 0x1050},
    {0x1051, 0x1051, 0x1051}, {0x1052, 0x1052, 0x1052},
    {0x1053, 0x1053, 0x1053}, {0x1054, 0x1054, 0x1054},
    {0x1055, 0x1055, 0x1055}, {0x1058, 0x1058, 0x1058},
    {0x1059, 0x1059, 0x1059}, {0x10A0, 0x10A0, 0x2D00},
    {0x10A1, 0x10A1, 0x2D01}, {0x10A2, 0x10A2, 0x2D02},
    {0x10A3, 0x10A3, 0x2D03}, {0x10A4, 0x10A4, 0x2D04},
    {0x10A5, 0x10A5, 0x2D05}, {0x10A6, 0x10A6, 0x2D06},
    {0x10A7, 0x10A7, 0x2D07}, {0x10A8, 0x10A8, 0x2D08},
    {0x10A9, 0x10A9, 0x2D09}, {0x10AA, 0x10AA, 0x2D0A},
    {0x10AB, 0x10AB, 0x2D0B}, {0x10AC, 0x10AC, 0x2D0C},
    {0x10AD, 0x10AD, 0x2D0D}, {0x10AE, 0x10AE, 0x2D0E},
    {0x10AF, 0x10AF, 0x2D0F}, {0x10B0, 0x10B0, 0x2D10},
    {0x10B1, 0x10B1, 0x2D11}, {0x10B2, 0x10B2, 0x2D12},
    {0x10B3, 0x10B3, 0x2D13}, {0x10B4, 0x10B4, 0x2D14},
    {0x10B5, 0x10B5, 0x2D15}, {0x10B6, 0x10B6, 0x2D16},
    {0x10B7, 0x10B7, 0x2D17}, {0x10B8, 0x10B8, 0x2D18},
    {0x10B9, 0x10B9, 0x2D19}, {0x10BA, 0x10BA, 0x2D1A},
    {0x10BB, 0x10BB, 0x2D1B}, {0x10BC, 0x10BC, 0x2D1C},
    {0x10BD, 0x10BD, 0x2D1D}, {0x10BE, 0x10BE, 0x2D1E},
    {0x10BF, 0x10BF, 0x2D1F}, {0x10C0, 0x10C0, 0x2D20},
    {0x10C1, 0x10C1, 0x2D21}, {0x10C2, 0x10C2, 0x2D22},
    {0x10C3, 0x10C3, 0x2D23}, {0x10C4, 0x10C4, 0x2D24},
    {0x10C5, 0x10C5, 0x2D25}, {0x10D0, 0x10D0, 0x10D0},
    {0x10D1, 0x10D1, 0x10D1}, {0x10D2, 0x10D2, 0x10D2},
    {0x10D3, 0x10D3, 0x10D3}, {0x10D4, 0x10D4, 0x10D4},
    {0x10D5, 0x10D5, 0x10D5}, {0x10D6, 0x10D6, 0x10D6},
    {0x10D7, 0x10D7, 0x10D7}, {0x10D8, 0x10D8, 0x10D8},
    {0x10D9, 0x10D9, 0x10D9}, {0x10DA, 0x10DA, 0x10DA},
    {0x10DB, 0x10DB, 0x10DB}, {0x10DC, 0x10DC, 0x10DC},
    {0x10DD, 0x10DD, 0x10DD}, {0x10DE, 0x10DE, 0x10DE},
    {0x10DF, 0x10DF, 0x10DF}, {0x10E0, 0x10E0, 0x10E0},
    {0x10E1, 0x10E1, 0x10E1}, {0x10E2, 0x10E2, 0x10E2},
    {0x10E3, 0x10E3, 0x10E3}, {0x10E4, 0x10E4, 0x10E4},
    {0x10E5, 0x10E5, 0x10E5}, {0x10E6, 0x10E6, 0x10E6},
    {0x10E7, 0x10E7, 0x10E7}, {0x10E8, 0x10E8, 0x10E8},
    {0x10E9, 0x10E9, 0x10E9}, {0x10EA, 0x10EA, 0x10EA},
    {0x10EB, 0x10EB, 0x10EB}, {0x10EC, 0x10EC, 0x10EC},
    {0x10ED, 0x10ED, 0x10ED}, {0x10EE, 0x10EE, 0x10EE},
    {0x10EF, 0x10EF, 0x10EF}, {0x10F0, 0x10F0, 0x10F0},
    {0x10F1, 0x10F1, 0x10F1}, {0x10F2, 0x10F2, 0x10F2},
    {0x10F3, 0x10F3, 0x10F3}, {0x10F4, 0x10F4, 0x10F4},
    {0x10F5, 0x10F5, 0x10F5}, {0x10F6, 0x10F6, 0x10F6},
    {0x10F7, 0x10F7, 0x10F7}, {0x10F8, 0x10F8, 0x10F8},
    {0x10F9, 0x10F9, 0x10F9}, {0x10FA, 0x10FA, 0x10FA},
    {0x10FC, 0x10FC, 0x10FC}, {0x1100, 0x1100, 0x1100},
    {0x1101, 0x1101, 0x1101}, {0x1102, 0x1102, 0x1102},
    {0x1103, 0x1103, 0x1103}, {0x1104, 0x1104, 0x1104},
    {0x1105, 0x1105, 0x1105}, {0x1106, 0x1106, 0x1106},
    {0x1107, 0x1107, 0x1107}, {0x1108, 0x1108, 0x1108},
    {0x1109, 0x1109, 0x1109}, {0x110A, 0x110A, 0x110A},
    {0x110B, 0x110B, 0x110B}, {0x110C, 0x110C, 0x110C},
    {0x110D, 0x110D, 0x110D}, {0x110E, 0x110E, 0x110E},
    {0x110F, 0x110F, 0x110F}, {0x1110, 0x1110, 0x1110},
    {0x1111, 0x1111, 0x1111}, {0x1112, 0x1112, 0x1112},
    {0x1113, 0x1113, 0x1113}, {0x1114, 0x1114, 0x1114},
    {0x1115, 0x1115, 0x1115}, {0x1116, 0x1116, 0x1116},
    {0x1117, 0x1117, 0x1117}, {0x1118, 0x1118, 0x1118},
    {0x1119, 0x1119, 0x1119}, {0x111A, 0x111A, 0x111A},
    {0x111B, 0x111B, 0x111B}, {0x111C, 0x111C, 0x111C},
    {0x111D, 0x111D, 0x111D}, {0x111E, 0x111E, 0x111E},
    {0x111F, 0x111F, 0x111F}, {0x1120, 0x1120, 0x1120},
    {0x1121, 0x1121, 0x1121}, {0x1122, 0x1122, 0x1122},
    {0x1123, 0x1123, 0x1123}, {0x1124, 0x1124, 0x1124},
    {0x1125, 0x1125, 0x1125}, {0x1126, 0x1126, 0x1126},
    {0x1127, 0x1127, 0x1127}, {0x1128, 0x1128, 0x1128},
    {0x1129, 0x1129, 0x1129}, {0x112A, 0x112A, 0x112A},
    {0x112B, 0x112B, 0x112B}, {0x112C, 0x112C, 0x112C},
    {0x112D, 0x112D, 0x112D}, {0x112E, 0x112E, 0x112E},
    {0x112F, 0x112F, 0x112F}, {0x1130, 0x1130, 0x1130},
    {0x1131, 0x1131, 0x1131}, {0x1132, 0x1132, 0x1132},
    {0x1133, 0x1133, 0x1133}, {0x1134, 0x1134, 0x1134},
    {0x1135, 0x1135, 0x1135}, {0x1136, 0x1136, 0x1136},
    {0x1137, 0x1137, 0x1137}, {0x1138, 0x1138, 0x1138},
    {0x1139, 0x1139, 0x1139}, {0x113A, 0x113A, 0x113A},
    {0x113B, 0x113B, 0x113B}, {0x113C, 0x113C, 0x113C},
    {0x113D, 0x113D, 0x113D}, {0x113E, 0x113E, 0x113E},
    {0x113F, 0x113F, 0x113F}, {0x1140, 0x1140, 0x1140},
    {0x1141, 0x1141, 0x1141}, {0x1142, 0x1142, 0x1142},
    {0x1143, 0x1143, 0x1143}, {0x1144, 0x1144, 0x1144},
    {0x1145, 0x1145, 0x1145}, {0x1146, 0x1146, 0x1146},
    {0x1147, 0x1147, 0x1147}, {0x1148, 0x1148, 0x1148},
    {0x1149, 0x1149, 0x1149}, {0x114A, 0x114A, 0x114A},
    {0x114B, 0x114B, 0x114B}, {0x114C, 0x114C, 0x114C},
    {0x114D, 0x114D, 0x114D}, {0x114E, 0x114E, 0x114E},
    {0x114F, 0x114F, 0x114F}, {0x1150, 0x1150, 0x1150},
    {0x1151, 0x1151, 0x1151}, {0x1152, 0x1152, 0x1152},
    {0x1153, 0x1153, 0x1153}, {0x1154, 0x1154, 0x1154},
    {0x1155, 0x1155, 0x1155}, {0x1156, 0x1156, 0x1156},
    {0x1157, 0x1157, 0x1157}, {0x1158, 0x1158, 0x1158},
    {0x1159, 0x1159, 0x1159}, {0x115F, 0x115F, 0x115F},
    {0x1160, 0x1160, 0x1160}, {0x1161, 0x1161, 0x1161},
    {0x1162, 0x1162, 0x1162}, {0x1163, 0x1163, 0x1163},
    {0x1164, 0x1164, 0x1164}, {0x1165, 0x1165, 0x1165},
    {0x1166, 0x1166, 0x1166}, {0x1167, 0x1167, 0x1167},
    {0x1168, 0x1168, 0x1168}, {0x1169, 0x1169, 0x1169},
    {0x116A, 0x116A, 0x116A}, {0x116B, 0x116B, 0x116B},
    {0x116C, 0x116C, 0x116C}, {0x116D, 0x116D, 0x116D},
    {0x116E, 0x116E, 0x116E}, {0x116F, 0x116F, 0x116F},
    {0x1170, 0x1170, 0x1170}, {0x1171, 0x1171, 0x1171},
    {0x1172, 0x1172, 0x1172}, {0x1173, 0x1173, 0x1173},
    {0x1174, 0x1174, 0x1174}, {0x1175, 0x1175, 0x1175},
    {0x1176, 0x1176, 0x1176}, {0x1177, 0x1177, 0x1177},
    {0x1178, 0x1178, 0x1178}, {0x1179, 0x1179, 0x1179},
    {0x117A, 0x117A, 0x117A}, {0x117B, 0x117B, 0x117B},
    {0x117C, 0x117C, 0x117C}, {0x117D, 0x117D, 0x117D},
    {0x117E, 0x117E, 0x117E}, {0x117F, 0x117F, 0x117F},
    {0x1180, 0x1180, 0x1180}, {0x1181, 0x1181, 0x1181},
    {0x1182, 0x1182, 0x1182}, {0x1183, 0x1183, 0x1183},
    {0x1184, 0x1184, 0x1184}, {0x1185, 0x1185, 0x1185},
    {0x1186, 0x1186, 0x1186}, {0x1187, 0x1187, 0x1187},
    {0x1188, 0x1188, 0x1188}, {0x1189, 0x1189, 0x1189},
    {0x118A, 0x118A, 0x118A}, {0x118B, 0x118B, 0x118B},
    {0x118C, 0x118C, 0x118C}, {0x118D, 0x118D, 0x118D},
    {0x118E, 0x118E, 0x118E}, {0x118F, 0x118F, 0x118F},
    {0x1190, 0x1190, 0x1190}, {0x1191, 0x1191, 0x1191},
    {0x1192, 0x1192, 0x1192}, {0x1193, 0x1193, 0x1193},
    {0x1194, 0x1194, 0x1194}, {0x1195, 0x1195, 0x1195},
    {0x1196, 0x1196, 0x1196}, {0x1197, 0x1197, 0x1197},
    {0x1198, 0x1198, 0x1198}, {0x1199, 0x1199, 0x1199},
    {0x119A, 0x119A, 0x119A}, {0x119B, 0x119B, 0x119B},
    {0x119C, 0x119C, 0x119C}, {0x119D, 0x119D, 0x119D},
    {0x119E, 0x119E, 0x119E}, {0x119F, 0x119F, 0x119F},
    {0x11A0, 0x11A0, 0x11A0}, {0x11A1, 0x11A1, 0x11A1},
    {0x11A2, 0x11A2, 0x11A2}, {0x11A8, 0x11A8, 0x11A8},
    {0x11A9, 0x11A9, 0x11A9}, {0x11AA, 0x11AA, 0x11AA},
    {0x11AB, 0x11AB, 0x11AB}, {0x11AC, 0x11AC, 0x11AC},
    {0x11AD, 0x11AD, 0x11AD}, {0x11AE, 0x11AE, 0x11AE},
    {0x11AF, 0x11AF, 0x11AF}, {0x11B0, 0x11B0, 0x11B0},
    {0x11B1, 0x11B1, 0x11B1}, {0x11B2, 0x11B2, 0x11B2},
    {0x11B3, 0x11B3, 0x11B3}, {0x11B4, 0x11B4, 0x11B4},
    {0x11B5, 0x11B5, 0x11B5}, {0x11B6, 0x11B6, 0x11B6},
    {0x11B7, 0x11B7, 0x11B7}, {0x11B8, 0x11B8, 0x11B8},
    {0x11B9, 0x11B9, 0x11B9}, {0x11BA, 0x11BA, 0x11BA},
    {0x11BB, 0x11BB, 0x11BB}, {0x11BC, 0x11BC, 0x11BC},
    {0x11BD, 0x11BD, 0x11BD}, {0x11BE, 0x11BE, 0x11BE},
    {0x11BF, 0x11BF, 0x11BF}, {0x11C0, 0x11C0, 0x11C0},
    {0x11C1, 0x11C1, 0x11C1}, {0x11C2, 0x11C2, 0x11C2},
    {0x11C3, 0x11C3, 0x11C3}, {0x11C4, 0x11C4, 0x11C4},
    {0x11C5, 0x11C5, 0x11C5}, {0x11C6, 0x11C6, 0x11C6},
    {0x11C7, 0x11C7, 0x11C7}, {0x11C8, 0x11C8, 0x11C8},
    {0x11C9, 0x11C9, 0x11C9}, {0x11CA, 0x11CA, 0x11CA},
    {0x11CB, 0x11CB, 0x11CB}, {0x11CC, 0x11CC, 0x11CC},
    {0x11CD, 0x11CD, 0x11CD}, {0x11CE, 0x11CE, 0x11CE},
    {0x11CF, 0x11CF, 0x11CF}, {0x11D0, 0x11D0, 0x11D0},
    {0x11D1, 0x11D1, 0x11D1}, {0x11D2, 0x11D2, 0x11D2},
    {0x11D3, 0x11D3, 0x11D3}, {0x11D4, 0x11D4, 0x11D4},
    {0x11D5, 0x11D5, 0x11D5}, {0x11D6, 0x11D6, 0x11D6},
    {0x11D7, 0x11D7, 0x11D7}, {0x11D8, 0x11D8, 0x11D8},
    {0x11D9, 0x11D9, 0x11D9}, {0x11DA, 0x11DA, 0x11DA},
    {0x11DB, 0x11DB, 0x11DB}, {0x11DC, 0x11DC, 0x11DC},
    {0x11DD, 0x11DD, 0x11DD}, {0x11DE, 0x11DE, 0x11DE},
    {0x11DF, 0x11DF, 0x11DF}, {0x11E0, 0x11E0, 0x11E0},
    {0x11E1, 0x11E1, 0x11E1}, {0x11E2, 0x11E2, 0x11E2},
    {0x11E3, 0x11E3, 0x11E3}, {0x11E4, 0x11E4, 0x11E4},
    {0x11E5, 0x11E5, 0x11E5}, {0x11E6, 0x11E6, 0x11E6},
    {0x11E7, 0x11E7, 0x11E7}, {0x11E8, 0x11E8, 0x11E8},
    {0x11E9, 0x11E9, 0x11E9}, {0x11EA, 0x11EA, 0x11EA},
    {0x11EB, 0x11EB, 0x11EB}, {0x11EC, 0x11EC, 0x11EC},
    {0x11ED, 0x11ED, 0x11ED}, {0x11EE, 0x11EE, 0x11EE},
    {0x11EF, 0x11EF, 0x11EF}, {0x11F0, 0x11F0, 0x11F0},
    {0x11F1, 0x11F1, 0x11F1}, {0x11F2, 0x11F2, 0x11F2},
    {0x11F3, 0x11F3, 0x11F3}, {0x11F4, 0x11F4, 0x11F4},
    {0x11F5, 0x11F5, 0x11F5}, {0x11F6, 0x11F6, 0x11F6},
    {0x11F7, 0x11F7, 0x11F7}, {0x11F8, 0x11F8, 0x11F8},
    {0x11F9, 0x11F9, 0x11F9}, {0x1200, 0x1200, 0x1200},
    {0x1201, 0x1201, 0x1201}, {0x1202, 0x1202, 0x1202},
    {0x1203, 0x1203, 0x1203}, {0x1204, 0x1204, 0x1204},
    {0x1205, 0x1205, 0x1205}, {0x1206, 0x1206, 0x1206},
    {0x1207, 0x1207, 0x1207}, {0x1208, 0x1208, 0x1208},
    {0x1209, 0x1209, 0x1209}, {0x120A, 0x120A, 0x120A},
    {0x120B, 0x120B, 0x120B}, {0x120C, 0x120C, 0x120C},
    {0x120D, 0x120D, 0x120D}, {0x120E, 0x120E, 0x120E},
    {0x120F, 0x120F, 0x120F}, {0x1210, 0x1210, 0x1210},
    {0x1211, 0x1211, 0x1211}, {0x1212, 0x1212, 0x1212},
    {0x1213, 0x1213, 0x1213}, {0x1214, 0x1214, 0x1214},
    {0x1215, 0x1215, 0x1215}, {0x1216, 0x1216, 0x1216},
    {0x1217, 0x1217, 0x1217}, {0x1218, 0x1218, 0x1218},
    {0x1219, 0x1219, 0x1219}, {0x121A, 0x121A, 0x121A},
    {0x121B, 0x121B, 0x121B}, {0x121C, 0x121C, 0x121C},
    {0x121D, 0x121D, 0x121D}, {0x121E, 0x121E, 0x121E},
    {0x121F, 0x121F, 0x121F}, {0x1220, 0x1220, 0x1220},
    {0x1221, 0x1221, 0x1221}, {0x1222, 0x1222, 0x1222},
    {0x1223, 0x1223, 0x1223}, {0x1224, 0x1224, 0x1224},
    {0x1225, 0x1225, 0x1225}, {0x1226, 0x1226, 0x1226},
    {0x1227, 0x1227, 0x1227}, {0x1228, 0x1228, 0x1228},
    {0x1229, 0x1229, 0x1229}, {0x122A, 0x122A, 0x122A},
    {0x122B, 0x122B, 0x122B}, {0x122C, 0x122C, 0x122C},
    {0x122D, 0x122D, 0x122D}, {0x122E, 0x122E, 0x122E},
    {0x122F, 0x122F, 0x122F}, {0x1230, 0x1230, 0x1230},
    {0x1231, 0x1231, 0x1231}, {0x1232, 0x1232, 0x1232},
    {0x1233, 0x1233, 0x1233}, {0x1234, 0x1234, 0x1234},
    {0x1235, 0x1235, 0x1235}, {0x1236, 0x1236, 0x1236},
    {0x1237, 0x1237, 0x1237}, {0x1238, 0x1238, 0x1238},
    {0x1239, 0x1239, 0x1239}, {0x123A, 0x123A, 0x123A},
    {0x123B, 0x123B, 0x123B}, {0x123C, 0x123C, 0x123C},
    {0x123D, 0x123D, 0x123D}, {0x123E, 0x123E, 0x123E},
    {0x123F, 0x123F, 0x123F}, {0x1240, 0x1240, 0x1240},
    {0x1241, 0x1241, 0x1241}, {0x1242, 0x1242, 0x1242},
    {0x1243, 0x1243, 0x1243}, {0x1244, 0x1244, 0x1244},
    {0x1245, 0x1245, 0x1245}, {0x1246, 0x1246, 0x1246},
    {0x1247, 0x1247, 0x1247}, {0x1248, 0x1248, 0x1248},
    {0x124A, 0x124A, 0x124A}, {0x124B, 0x124B, 0x124B},
    {0x124C, 0x124C, 0x124C}, {0x124D, 0x124D, 0x124D},
    {0x1250, 0x1250, 0x1250}, {0x1251, 0x1251, 0x1251},
    {0x1252, 0x1252, 0x1252}, {0x1253, 0x1253, 0x1253},
    {0x1254, 0x1254, 0x1254}, {0x1255, 0x1255, 0x1255},
    {0x1256, 0x1256, 0x1256}, {0x1258, 0x1258, 0x1258},
    {0x125A, 0x125A, 0x125A}, {0x125B, 0x125B, 0x125B},
    {0x125C, 0x125C, 0x125C}, {0x125D, 0x125D, 0x125D},
    {0x1260, 0x1260, 0x1260}, {0x1261, 0x1261, 0x1261},
    {0x1262, 0x1262, 0x1262}, {0x1263, 0x1263, 0x1263},
    {0x1264, 0x1264, 0x1264}, {0x1265, 0x1265, 0x1265},
    {0x1266, 0x1266, 0x1266}, {0x1267, 0x1267, 0x1267},
    {0x1268, 0x1268, 0x1268}, {0x1269, 0x1269, 0x1269},
    {0x126A, 0x126A, 0x126A}, {0x126B, 0x126B, 0x126B},
    {0x126C, 0x126C, 0x126C}, {0x126D, 0x126D, 0x126D},
    {0x126E, 0x126E, 0x126E}, {0x126F, 0x126F, 0x126F},
    {0x1270, 0x1270, 0x1270}, {0x1271, 0x1271, 0x1271},
    {0x1272, 0x1272, 0x1272}, {0x1273, 0x1273, 0x1273},
    {0x1274, 0x1274, 0x1274}, {0x1275, 0x1275, 0x1275},
    {0x1276, 0x1276, 0x1276}, {0x1277, 0x1277, 0x1277},
    {0x1278, 0x1278, 0x1278}, {0x1279, 0x1279, 0x1279},
    {0x127A, 0x127A, 0x127A}, {0x127B, 0x127B, 0x127B},
    {0x127C, 0x127C, 0x127C}, {0x127D, 0x127D, 0x127D},
    {0x127E, 0x127E, 0x127E}, {0x127F, 0x127F, 0x127F},
    {0x1280, 0x1280, 0x1280}, {0x1281, 0x1281, 0x1281},
    {0x1282, 0x1282, 0x1282}, {0x1283, 0x1283, 0x1283},
    {0x1284, 0x1284, 0x1284}, {0x1285, 0x1285, 0x1285},
    {0x1286, 0x1286, 0x1286}, {0x1287, 0x1287, 0x1287},
    {0x1288, 0x1288, 0x1288}, {0x128A, 0x128A, 0x128A},
    {0x128B, 0x128B, 0x128B}, {0x128C, 0x128C, 0x128C},
    {0x128D, 0x128D, 0x128D}, {0x1290, 0x1290, 0x1290},
    {0x1291, 0x1291, 0x1291}, {0x1292, 0x1292, 0x1292},
    {0x1293, 0x1293, 0x1293}, {0x1294, 0x1294, 0x1294},
    {0x1295, 0x1295, 0x1295}, {0x1296, 0x1296, 0x1296},
    {0x1297, 0x1297, 0x1297}, {0x1298, 0x1298, 0x1298},
    {0x1299, 0x1299, 0x1299}, {0x129A, 0x129A, 0x129A},
    {0x129B, 0x129B, 0x129B}, {0x129C, 0x129C, 0x129C},
    {0x129D, 0x129D, 0x129D}, {0x129E, 0x129E, 0x129E},
    {0x129F, 0x129F, 0x129F}, {0x12A0, 0x12A0, 0x12A0},
    {0x12A1, 0x12A1, 0x12A1}, {0x12A2, 0x12A2, 0x12A2},
    {0x12A3, 0x12A3, 0x12A3}, {0x12A4, 0x12A4, 0x12A4},
    {0x12A5, 0x12A5, 0x12A5}, {0x12A6, 0x12A6, 0x12A6},
    {0x12A7, 0x12A7, 0x12A7}, {0x12A8, 0x12A8, 0x12A8},
    {0x12A9, 0x12A9, 0x12A9}, {0x12AA, 0x12AA, 0x12AA},
    {0x12AB, 0x12AB, 0x12AB}, {0x12AC, 0x12AC, 0x12AC},
    {0x12AD, 0x12AD, 0x12AD}, {0x12AE, 0x12AE, 0x12AE},
    {0x12AF, 0x12AF, 0x12AF}, {0x12B0, 0x12B0, 0x12B0},
    {0x12B2, 0x12B2, 0x12B2}, {0x12B3, 0x12B3, 0x12B3},
    {0x12B4, 0x12B4, 0x12B4}, {0x12B5, 0x12B5, 0x12B5},
    {0x12B8, 0x12B8, 0x12B8}, {0x12B9, 0x12B9, 0x12B9},
    {0x12BA, 0x12BA, 0x12BA}, {0x12BB, 0x12BB, 0x12BB},
    {0x12BC, 0x12BC, 0x12BC}, {0x12BD, 0x12BD, 0x12BD},
    {0x12BE, 0x12BE, 0x12BE}, {0x12C0, 0x12C0, 0x12C0},
    {0x12C2, 0x12C2, 0x12C2}, {0x12C3, 0x12C3, 0x12C3},
    {0x12C4, 0x12C4, 0x12C4}, {0x12C5, 0x12C5, 0x12C5},
    {0x12C8, 0x12C8, 0x12C8}, {0x12C9, 0x12C9, 0x12C9},
    {0x12CA, 0x12CA, 0x12CA}, {0x12CB, 0x12CB, 0x12CB},
    {0x12CC, 0x12CC, 0x12CC}, {0x12CD, 0x12CD, 0x12CD},
    {0x12CE, 0x12CE, 0x12CE}, {0x12CF, 0x12CF, 0x12CF},
    {0x12D0, 0x12D0, 0x12D0}, {0x12D1, 0x12D1, 0x12D1},
    {0x12D2, 0x12D2, 0x12D2}, {0x12D3, 0x12D3, 0x12D3},
    {0x12D4, 0x12D4, 0x12D4}, {0x12D5, 0x12D5, 0x12D5},
    {0x12D6, 0x12D6, 0x12D6}, {0x12D8, 0x12D8, 0x12D8},
    {0x12D9, 0x12D9, 0x12D9}, {0x12DA, 0x12DA, 0x12DA},
    {0x12DB, 0x12DB, 0x12DB}, {0x12DC, 0x12DC, 0x12DC},
    {0x12DD, 0x12DD, 0x12DD}, {0x12DE, 0x12DE, 0x12DE},
    {0x12DF, 0x12DF, 0x12DF}, {0x12E0, 0x12E0, 0x12E0},
    {0x12E1, 0x12E1, 0x12E1}, {0x12E2, 0x12E2, 0x12E2},
    {0x12E3, 0x12E3, 0x12E3}, {0x12E4, 0x12E4, 0x12E4},
    {0x12E5, 0x12E5, 0x12E5}, {0x12E6, 0x12E6, 0x12E6},
    {0x12E7, 0x12E7, 0x12E7}, {0x12E8, 0x12E8, 0x12E8},
    {0x12E9, 0x12E9, 0x12E9}, {0x12EA, 0x12EA, 0x12EA},
    {0x12EB, 0x12EB, 0x12EB}, {0x12EC, 0x12EC, 0x12EC},
    {0x12ED, 0x12ED, 0x12ED}, {0x12EE, 0x12EE, 0x12EE},
    {0x12EF, 0x12EF, 0x12EF}, {0x12F0, 0x12F0, 0x12F0},
    {0x12F1, 0x12F1, 0x12F1}, {0x12F2, 0x12F2, 0x12F2},
    {0x12F3, 0x12F3, 0x12F3}, {0x12F4, 0x12F4, 0x12F4},
    {0x12F5, 0x12F5, 0x12F5}, {0x12F6, 0x12F6, 0x12F6},
    {0x12F7, 0x12F7, 0x12F7}, {0x12F8, 0x12F8, 0x12F8},
    {0x12F9, 0x12F9, 0x12F9}, {0x12FA, 0x12FA, 0x12FA},
    {0x12FB, 0x12FB, 0x12FB}, {0x12FC, 0x12FC, 0x12FC},
    {0x12FD, 0x12FD, 0x12FD}, {0x12FE, 0x12FE, 0x12FE},
    {0x12FF, 0x12FF, 0x12FF}, {0x1300, 0x1300, 0x1300},
    {0x1301, 0x1301, 0x1301}, {0x1302, 0x1302, 0x1302},
    {0x1303, 0x1303, 0x1303}, {0x1304, 0x1304, 0x1304},
    {0x1305, 0x1305, 0x1305}, {0x1306, 0x1306, 0x1306},
    {0x1307, 0x1307, 0x1307}, {0x1308, 0x1308, 0x1308},
    {0x1309, 0x1309, 0x1309}, {0x130A, 0x130A, 0x130A},
    {0x130B, 0x130B, 0x130B}, {0x130C, 0x130C, 0x130C},
    {0x130D, 0x130D, 0x130D}, {0x130E, 0x130E, 0x130E},
    {0x130F, 0x130F, 0x130F}, {0x1310, 0x1310, 0x1310},
    {0x1312, 0x1312, 0x1312}, {0x1313, 0x1313, 0x1313},
    {0x1314, 0x1314, 0x1314}, {0x1315, 0x1315, 0x1315},
    {0x1318, 0x1318, 0x1318}, {0x1319, 0x1319, 0x1319},
    {0x131A, 0x131A, 0x131A}, {0x131B, 0x131B, 0x131B},
    {0x131C, 0x131C, 0x131C}, {0x131D, 0x131D, 0x131D},
    {0x131E, 0x131E, 0x131E}, {0x131F, 0x131F, 0x131F},
    {0x1320, 0x1320, 0x1320}, {0x1321, 0x1321, 0x1321},
    {0x1322, 0x1322, 0x1322}, {0x1323, 0x1323, 0x1323},
    {0x1324, 0x1324, 0x1324}, {0x1325, 0x1325, 0x1325},
    {0x1326, 0x1326, 0x1326}, {0x1327, 0x1327, 0x1327},
    {0x1328, 0x1328, 0x1328}, {0x1329, 0x1329, 0x1329},
    {0x132A, 0x132A, 0x132A}, {0x132B, 0x132B, 0x132B},
    {0x132C, 0x132C, 0x132C}, {0x132D, 0x132D, 0x132D},
    {0x132E, 0x132E, 0x132E}, {0x132F, 0x132F, 0x132F},
    {0x1330, 0x1330, 0x1330}, {0x1331, 0x1331, 0x1331},
    {0x1332, 0x1332, 0x1332}, {0x1333, 0x1333, 0x1333},
    {0x1334, 0x1334, 0x1334}, {0x1335, 0x1335, 0x1335},
    {0x1336, 0x1336, 0x1336}, {0x1337, 0x1337, 0x1337},
    {0x1338, 0x1338, 0x1338}, {0x1339, 0x1339, 0x1339},
    {0x133A, 0x133A, 0x133A}, {0x133B, 0x133B, 0x133B},
    {0x133C, 0x133C, 0x133C}, {0x133D, 0x133D, 0x133D},
    {0x133E, 0x133E, 0x133E}, {0x133F, 0x133F, 0x133F},
    {0x1340, 0x1340, 0x1340}, {0x1341, 0x1341, 0x1341},
    {0x1342, 0x1342, 0x1342}, {0x1343, 0x1343, 0x1343},
    {0x1344, 0x1344, 0x1344}, {0x1345, 0x1345, 0x1345},
    {0x1346, 0x1346, 0x1346}, {0x1347, 0x1347, 0x1347},
    {0x1348, 0x1348, 0x1348}, {0x1349, 0x1349, 0x1349},
    {0x134A, 0x134A, 0x134A}, {0x134B, 0x134B, 0x134B},
    {0x134C, 0x134C, 0x134C}, {0x134D, 0x134D, 0x134D},
    {0x134E, 0x134E, 0x134E}, {0x134F, 0x134F, 0x134F},
    {0x1350, 0x1350, 0x1350}, {0x1351, 0x1351, 0x1351},
    {0x1352, 0x1352, 0x1352}, {0x1353, 0x1353, 0x1353},
    {0x1354, 0x1354, 0x1354}, {0x1355, 0x1355, 0x1355},
    {0x1356, 0x1356, 0x1356}, {0x1357, 0x1357, 0x1357},
    {0x1358, 0x1358, 0x1358}, {0x1359, 0x1359, 0x1359},
    {0x135A, 0x135A, 0x135A}, {0x135F, 0x135F, 0x135F},
    {0x1380, 0x1380, 0x1380}, {0x1381, 0x1381, 0x1381},
    {0x1382, 0x1382, 0x1382}, {0x1383, 0x1383, 0x1383},
    {0x1384, 0x1384, 0x1384}, {0x1385, 0x1385, 0x1385},
    {0x1386, 0x1386, 0x1386}, {0x1387, 0x1387, 0x1387},
    {0x1388, 0x1388, 0x1388}, {0x1389, 0x1389, 0x1389},
    {0x138A, 0x138A, 0x138A}, {0x138B, 0x138B, 0x138B},
    {0x138C, 0x138C, 0x138C}, {0x138D, 0x138D, 0x138D},
    {0x138E, 0x138E, 0x138E}, {0x138F, 0x138F, 0x138F},
    {0x13A0, 0x13A0, 0x13A0}, {0x13A1, 0x13A1, 0x13A1},
    {0x13A2, 0x13A2, 0x13A2}, {0x13A3, 0x13A3, 0x13A3},
    {0x13A4, 0x13A4, 0x13A4}, {0x13A5, 0x13A5, 0x13A5},
    {0x13A6, 0x13A6, 0x13A6}, {0x13A7, 0x13A7, 0x13A7},
    {0x13A8, 0x13A8, 0x13A8}, {0x13A9, 0x13A9, 0x13A9},
    {0x13AA, 0x13AA, 0x13AA}, {0x13AB, 0x13AB, 0x13AB},
    {0x13AC, 0x13AC, 0x13AC}, {0x13AD, 0x13AD, 0x13AD},
    {0x13AE, 0x13AE, 0x13AE}, {0x13AF, 0x13AF, 0x13AF},
    {0x13B0, 0x13B0, 0x13B0}, {0x13B1, 0x13B1, 0x13B1},
    {0x13B2, 0x13B2, 0x13B2}, {0x13B3, 0x13B3, 0x13B3},
    {0x13B4, 0x13B4, 0x13B4}, {0x13B5, 0x13B5, 0x13B5},
    {0x13B6, 0x13B6, 0x13B6}, {0x13B7, 0x13B7, 0x13B7},
    {0x13B8, 0x13B8, 0x13B8}, {0x13B9, 0x13B9, 0x13B9},
    {0x13BA, 0x13BA, 0x13BA}, {0x13BB, 0x13BB, 0x13BB},
    {0x13BC, 0x13BC, 0x13BC}, {0x13BD, 0x13BD, 0x13BD},
    {0x13BE, 0x13BE, 0x13BE}, {0x13BF, 0x13BF, 0x13BF},
    {0x13C0, 0x13C0, 0x13C0}, {0x13C1, 0x13C1, 0x13C1},
    {0x13C2, 0x13C2, 0x13C2}, {0x13C3, 0x13C3, 0x13C3},
    {0x13C4, 0x13C4, 0x13C4}, {0x13C5, 0x13C5, 0x13C5},
    {0x13C6, 0x13C6, 0x13C6}, {0x13C7, 0x13C7, 0x13C7},
    {0x13C8, 0x13C8, 0x13C8}, {0x13C9, 0x13C9, 0x13C9},
    {0x13CA, 0x13CA, 0x13CA}, {0x13CB, 0x13CB, 0x13CB},
    {0x13CC, 0x13CC, 0x13CC}, {0x13CD, 0x13CD, 0x13CD},
    {0x13CE, 0x13CE, 0x13CE}, {0x13CF, 0x13CF, 0x13CF},
    {0x13D0, 0x13D0, 0x13D0}, {0x13D1, 0x13D1, 0x13D1},
    {0x13D2, 0x13D2, 0x13D2}, {0x13D3, 0x13D3, 0x13D3},
    {0x13D4, 0x13D4, 0x13D4}, {0x13D5, 0x13D5, 0x13D5},
    {0x13D6, 0x13D6, 0x13D6}, {0x13D7, 0x13D7, 0x13D7},
    {0x13D8, 0x13D8, 0x13D8}, {0x13D9, 0x13D9, 0x13D9},
    {0x13DA, 0x13DA, 0x13DA}, {0x13DB, 0x13DB, 0x13DB},
    {0x13DC, 0x13DC, 0x13DC}, {0x13DD, 0x13DD, 0x13DD},
    {0x13DE, 0x13DE, 0x13DE}, {0x13DF, 0x13DF, 0x13DF},
    {0x13E0, 0x13E0, 0x13E0}, {0x13E1, 0x13E1, 0x13E1},
    {0x13E2, 0x13E2, 0x13E2}, {0x13E3, 0x13E3, 0x13E3},
    {0x13E4, 0x13E4, 0x13E4}, {0x13E5, 0x13E5, 0x13E5},
    {0x13E6, 0x13E6, 0x13E6}, {0x13E7, 0x13E7, 0x13E7},
    {0x13E8, 0x13E8, 0x13E8}, {0x13E9, 0x13E9, 0x13E9},
    {0x13EA, 0x13EA, 0x13EA}, {0x13EB, 0x13EB, 0x13EB},
    {0x13EC, 0x13EC, 0x13EC}, {0x13ED, 0x13ED, 0x13ED},
    {0x13EE, 0x13EE, 0x13EE}, {0x13EF, 0x13EF, 0x13EF},
    {0x13F0, 0x13F0, 0x13F0}, {0x13F1, 0x13F1, 0x13F1},
    {0x13F2, 0x13F2, 0x13F2}, {0x13F3, 0x13F3, 0x13F3},
    {0x13F4, 0x13F4, 0x13F4}, {0x1401, 0x1401, 0x1401},
    {0x1402, 0x1402, 0x1402}, {0x1403, 0x1403, 0x1403},
    {0x1404, 0x1404, 0x1404}, {0x1405, 0x1405, 0x1405},
    {0x1406, 0x1406, 0x1406}, {0x1407, 0x1407, 0x1407},
    {0x1408, 0x1408, 0x1408}, {0x1409, 0x1409, 0x1409},
    {0x140A, 0x140A, 0x140A}, {0x140B, 0x140B, 0x140B},
    {0x140C, 0x140C, 0x140C}, {0x140D, 0x140D, 0x140D},
    {0x140E, 0x140E, 0x140E}, {0x140F, 0x140F, 0x140F},
    {0x1410, 0x1410, 0x1410}, {0x1411, 0x1411, 0x1411},
    {0x1412, 0x1412, 0x1412}, {0x1413, 0x1413, 0x1413},
    {0x1414, 0x1414, 0x1414}, {0x1415, 0x1415, 0x1415},
    {0x1416, 0x1416, 0x1416}, {0x1417, 0x1417, 0x1417},
    {0x1418, 0x1418, 0x1418}, {0x1419, 0x1419, 0x1419},
    {0x141A, 0x141A, 0x141A}, {0x141B, 0x141B, 0x141B},
    {0x141C, 0x141C, 0x141C}, {0x141D, 0x141D, 0x141D},
    {0x141E, 0x141E, 0x141E}, {0x141F, 0x141F, 0x141F},
    {0x1420, 0x1420, 0x1420}, {0x1421, 0x1421, 0x1421},
    {0x1422, 0x1422, 0x1422}, {0x1423, 0x1423, 0x1423},
    {0x1424, 0x1424, 0x1424}, {0x1425, 0x1425, 0x1425},
    {0x1426, 0x1426, 0x1426}, {0x1427, 0x1427, 0x1427},
    {0x1428, 0x1428, 0x1428}, {0x1429, 0x1429, 0x1429},
    {0x142A, 0x142A, 0x142A}, {0x142B, 0x142B, 0x142B},
    {0x142C, 0x142C, 0x142C}, {0x142D, 0x142D, 0x142D},
    {0x142E, 0x142E, 0x142E}, {0x142F, 0x142F, 0x142F},
    {0x1430, 0x1430, 0x1430}, {0x1431, 0x1431, 0x1431},
    {0x1432, 0x1432, 0x1432}, {0x1433, 0x1433, 0x1433},
    {0x1434, 0x1434, 0x1434}, {0x1435, 0x1435, 0x1435},
    {0x1436, 0x1436, 0x1436}, {0x1437, 0x1437, 0x1437},
    {0x1438, 0x1438, 0x1438}, {0x1439, 0x1439, 0x1439},
    {0x143A, 0x143A, 0x143A}, {0x143B, 0x143B, 0x143B},
    {0x143C, 0x143C, 0x143C}, {0x143D, 0x143D, 0x143D},
    {0x143E, 0x143E, 0x143E}, {0x143F, 0x143F, 0x143F},
    {0x1440, 0x1440, 0x1440}, {0x1441, 0x1441, 0x1441},
    {0x1442, 0x1442, 0x1442}, {0x1443, 0x1443, 0x1443},
    {0x1444, 0x1444, 0x1444}, {0x1445, 0x1445, 0x1445},
    {0x1446, 0x1446, 0x1446}, {0x1447, 0x1447, 0x1447},
    {0x1448, 0x1448, 0x1448}, {0x1449, 0x1449, 0x1449},
    {0x144A, 0x144A, 0x144A}, {0x144B, 0x144B, 0x144B},
    {0x144C, 0x144C, 0x144C}, {0x144D, 0x144D, 0x144D},
    {0x144E, 0x144E, 0x144E}, {0x144F, 0x144F, 0x144F},
    {0x1450, 0x1450, 0x1450}, {0x1451, 0x1451, 0x1451},
    {0x1452, 0x1452, 0x1452}, {0x1453, 0x1453, 0x1453},
    {0x1454, 0x1454, 0x1454}, {0x1455, 0x1455, 0x1455},
    {0x1456, 0x1456, 0x1456}, {0x1457, 0x1457, 0x1457},
    {0x1458, 0x1458, 0x1458}, {0x1459, 0x1459, 0x1459},
    {0x145A, 0x145A, 0x145A}, {0x145B, 0x145B, 0x145B},
    {0x145C, 0x145C, 0x145C}, {0x145D, 0x145D, 0x145D},
    {0x145E, 0x145E, 0x145E}, {0x145F, 0x145F, 0x145F},
    {0x1460, 0x1460, 0x1460}, {0x1461, 0x1461, 0x1461},
    {0x1462, 0x1462, 0x1462}, {0x1463, 0x1463, 0x1463},
    {0x1464, 0x1464, 0x1464}, {0x1465, 0x1465, 0x1465},
    {0x1466, 0x1466, 0x1466}, {0x1467, 0x1467, 0x1467},
    {0x1468, 0x1468, 0x1468}, {0x1469, 0x1469, 0x1469},
    {0x146A, 0x146A, 0x146A}, {0x146B, 0x146B, 0x146B},
    {0x146C, 0x146C, 0x146C}, {0x146D, 0x146D, 0x146D},
    {0x146E, 0x146E, 0x146E}, {0x146F, 0x146F, 0x146F},
    {0x1470, 0x1470, 0x1470}, {0x1471, 0x1471, 0x1471},
    {0x1472, 0x1472, 0x1472}, {0x1473, 0x1473, 0x1473},
    {0x1474, 0x1474, 0x1474}, {0x1475, 0x1475, 0x1475},
    {0x1476, 0x1476, 0x1476}, {0x1477, 0x1477, 0x1477},
    {0x1478, 0x1478, 0x1478}, {0x1479, 0x1479, 0x1479},
    {0x147A, 0x147A, 0x147A}, {0x147B, 0x147B, 0x147B},
    {0x147C, 0x147C, 0x147C}, {0x147D, 0x147D, 0x147D},
    {0x147E, 0x147E, 0x147E}, {0x147F, 0x147F, 0x147F},
    {0x1480, 0x1480, 0x1480}, {0x1481, 0x1481, 0x1481},
    {0x1482, 0x1482, 0x1482}, {0x1483, 0x1483, 0x1483},
    {0x1484, 0x1484, 0x1484}, {0x1485, 0x1485, 0x1485},
    {0x1486, 0x1486, 0x1486}, {0x1487, 0x1487, 0x1487},
    {0x1488, 0x1488, 0x1488}, {0x1489, 0x1489, 0x1489},
    {0x148A, 0x148A, 0x148A}, {0x148B, 0x148B, 0x148B},
    {0x148C, 0x148C, 0x148C}, {0x148D, 0x148D, 0x148D},
    {0x148E, 0x148E, 0x148E}, {0x148F, 0x148F, 0x148F},
    {0x1490, 0x1490, 0x1490}, {0x1491, 0x1491, 0x1491},
    {0x1492, 0x1492, 0x1492}, {0x1493, 0x1493, 0x1493},
    {0x1494, 0x1494, 0x1494}, {0x1495, 0x1495, 0x1495},
    {0x1496, 0x1496, 0x1496}, {0x1497, 0x1497, 0x1497},
    {0x1498, 0x1498, 0x1498}, {0x1499, 0x1499, 0x1499},
    {0x149A, 0x149A, 0x149A}, {0x149B, 0x149B, 0x149B},
    {0x149C, 0x149C, 0x149C}, {0x149D, 0x149D, 0x149D},
    {0x149E, 0x149E, 0x149E}, {0x149F, 0x149F, 0x149F},
    {0x14A0, 0x14A0, 0x14A0}, {0x14A1, 0x14A1, 0x14A1},
    {0x14A2, 0x14A2, 0x14A2}, {0x14A3, 0x14A3, 0x14A3},
    {0x14A4, 0x14A4, 0x14A4}, {0x14A5, 0x14A5, 0x14A5},
    {0x14A6, 0x14A6, 0x14A6}, {0x14A7, 0x14A7, 0x14A7},
    {0x14A8, 0x14A8, 0x14A8}, {0x14A9, 0x14A9, 0x14A9},
    {0x14AA, 0x14AA, 0x14AA}, {0x14AB, 0x14AB, 0x14AB},
    {0x14AC, 0x14AC, 0x14AC}, {0x14AD, 0x14AD, 0x14AD},
    {0x14AE, 0x14AE, 0x14AE}, {0x14AF, 0x14AF, 0x14AF},
    {0x14B0, 0x14B0, 0x14B0}, {0x14B1, 0x14B1, 0x14B1},
    {0x14B2, 0x14B2, 0x14B2}, {0x14B3, 0x14B3, 0x14B3},
    {0x14B4, 0x14B4, 0x14B4}, {0x14B5, 0x14B5, 0x14B5},
    {0x14B6, 0x14B6, 0x14B6}, {0x14B7, 0x14B7, 0x14B7},
    {0x14B8, 0x14B8, 0x14B8}, {0x14B9, 0x14B9, 0x14B9},
    {0x14BA, 0x14BA, 0x14BA}, {0x14BB, 0x14BB, 0x14BB},
    {0x14BC, 0x14BC, 0x14BC}, {0x14BD, 0x14BD, 0x14BD},
    {0x14BE, 0x14BE, 0x14BE}, {0x14BF, 0x14BF, 0x14BF},
    {0x14C0, 0x14C0, 0x14C0}, {0x14C1, 0x14C1, 0x14C1},
    {0x14C2, 0x14C2, 0x14C2}, {0x14C3, 0x14C3, 0x14C3},
    {0x14C4, 0x14C4, 0x14C4}, {0x14C5, 0x14C5, 0x14C5},
    {0x14C6, 0x14C6, 0x14C6}, {0x14C7, 0x14C7, 0x14C7},
    {0x14C8, 0x14C8, 0x14C8}, {0x14C9, 0x14C9, 0x14C9},
    {0x14CA, 0x14CA, 0x14CA}, {0x14CB, 0x14CB, 0x14CB},
    {0x14CC, 0x14CC, 0x14CC}, {0x14CD, 0x14CD, 0x14CD},
    {0x14CE, 0x14CE, 0x14CE}, {0x14CF, 0x14CF, 0x14CF},
    {0x14D0, 0x14D0, 0x14D0}, {0x14D1, 0x14D1, 0x14D1},
    {0x14D2, 0x14D2, 0x14D2}, {0x14D3, 0x14D3, 0x14D3},
    {0x14D4, 0x14D4, 0x14D4}, {0x14D5, 0x14D5, 0x14D5},
    {0x14D6, 0x14D6, 0x14D6}, {0x14D7, 0x14D7, 0x14D7},
    {0x14D8, 0x14D8, 0x14D8}, {0x14D9, 0x14D9, 0x14D9},
    {0x14DA, 0x14DA, 0x14DA}, {0x14DB, 0x14DB, 0x14DB},
    {0x14DC, 0x14DC, 0x14DC}, {0x14DD, 0x14DD, 0x14DD},
    {0x14DE, 0x14DE, 0x14DE}, {0x14DF, 0x14DF, 0x14DF},
    {0x14E0, 0x14E0, 0x14E0}, {0x14E1, 0x14E1, 0x14E1},
    {0x14E2, 0x14E2, 0x14E2}, {0x14E3, 0x14E3, 0x14E3},
    {0x14E4, 0x14E4, 0x14E4}, {0x14E5, 0x14E5, 0x14E5},
    {0x14E6, 0x14E6, 0x14E6}, {0x14E7, 0x14E7, 0x14E7},
    {0x14E8, 0x14E8, 0x14E8}, {0x14E9, 0x14E9, 0x14E9},
    {0x14EA, 0x14EA, 0x14EA}, {0x14EB, 0x14EB, 0x14EB},
    {0x14EC, 0x14EC, 0x14EC}, {0x14ED, 0x14ED, 0x14ED},
    {0x14EE, 0x14EE, 0x14EE}, {0x14EF, 0x14EF, 0x14EF},
    {0x14F0, 0x14F0, 0x14F0}, {0x14F1, 0x14F1, 0x14F1},
    {0x14F2, 0x14F2, 0x14F2}, {0x14F3, 0x14F3, 0x14F3},
    {0x14F4, 0x14F4, 0x14F4}, {0x14F5, 0x14F5, 0x14F5},
    {0x14F6, 0x14F6, 0x14F6}, {0x14F7, 0x14F7, 0x14F7},
    {0x14F8, 0x14F8, 0x14F8}, {0x14F9, 0x14F9, 0x14F9},
    {0x14FA, 0x14FA, 0x14FA}, {0x14FB, 0x14FB, 0x14FB},
    {0x14FC, 0x14FC, 0x14FC}, {0x14FD, 0x14FD, 0x14FD},
    {0x14FE, 0x14FE, 0x14FE}, {0x14FF, 0x14FF, 0x14FF},
    {0x1500, 0x1500, 0x1500}, {0x1501, 0x1501, 0x1501},
    {0x1502, 0x1502, 0x1502}, {0x1503, 0x1503, 0x1503},
    {0x1504, 0x1504, 0x1504}, {0x1505, 0x1505, 0x1505},
    {0x1506, 0x1506, 0x1506}, {0x1507, 0x1507, 0x1507},
    {0x1508, 0x1508, 0x1508}, {0x1509, 0x1509, 0x1509},
    {0x150A, 0x150A, 0x150A}, {0x150B, 0x150B, 0x150B},
    {0x150C, 0x150C, 0x150C}, {0x150D, 0x150D, 0x150D},
    {0x150E, 0x150E, 0x150E}, {0x150F, 0x150F, 0x150F},
    {0x1510, 0x1510, 0x1510}, {0x1511, 0x1511, 0x1511},
    {0x1512, 0x1512, 0x1512}, {0x1513, 0x1513, 0x1513},
    {0x1514, 0x1514, 0x1514}, {0x1515, 0x1515, 0x1515},
    {0x1516, 0x1516, 0x1516}, {0x1517, 0x1517, 0x1517},
    {0x1518, 0x1518, 0x1518}, {0x1519, 0x1519, 0x1519},
    {0x151A, 0x151A, 0x151A}, {0x151B, 0x151B, 0x151B},
    {0x151C, 0x151C, 0x151C}, {0x151D, 0x151D, 0x151D},
    {0x151E, 0x151E, 0x151E}, {0x151F, 0x151F, 0x151F},
    {0x1520, 0x1520, 0x1520}, {0x1521, 0x1521, 0x1521},
    {0x1522, 0x1522, 0x1522}, {0x1523, 0x1523, 0x1523},
    {0x1524, 0x1524, 0x1524}, {0x1525, 0x1525, 0x1525},
    {0x1526, 0x1526, 0x1526}, {0x1527, 0x1527, 0x1527},
    {0x1528, 0x1528, 0x1528}, {0x1529, 0x1529, 0x1529},
    {0x152A, 0x152A, 0x152A}, {0x152B, 0x152B, 0x152B},
    {0x152C, 0x152C, 0x152C}, {0x152D, 0x152D, 0x152D},
    {0x152E, 0x152E, 0x152E}, {0x152F, 0x152F, 0x152F},
    {0x1530, 0x1530, 0x1530}, {0x1531, 0x1531, 0x1531},
    {0x1532, 0x1532, 0x1532}, {0x1533, 0x1533, 0x1533},
    {0x1534, 0x1534, 0x1534}, {0x1535, 0x1535, 0x1535},
    {0x1536, 0x1536, 0x1536}, {0x1537, 0x1537, 0x1537},
    {0x1538, 0x1538, 0x1538}, {0x1539, 0x1539, 0x1539},
    {0x153A, 0x153A, 0x153A}, {0x153B, 0x153B, 0x153B},
    {0x153C, 0x153C, 0x153C}, {0x153D, 0x153D, 0x153D},
    {0x153E, 0x153E, 0x153E}, {0x153F, 0x153F, 0x153F},
    {0x1540, 0x1540, 0x1540}, {0x1541, 0x1541, 0x1541},
    {0x1542, 0x1542, 0x1542}, {0x1543, 0x1543, 0x1543},
    {0x1544, 0x1544, 0x1544}, {0x1545, 0x1545, 0x1545},
    {0x1546, 0x1546, 0x1546}, {0x1547, 0x1547, 0x1547},
    {0x1548, 0x1548, 0x1548}, {0x1549, 0x1549, 0x1549},
    {0x154A, 0x154A, 0x154A}, {0x154B, 0x154B, 0x154B},
    {0x154C, 0x154C, 0x154C}, {0x154D, 0x154D, 0x154D},
    {0x154E, 0x154E, 0x154E}, {0x154F, 0x154F, 0x154F},
    {0x1550, 0x1550, 0x1550}, {0x1551, 0x1551, 0x1551},
    {0x1552, 0x1552, 0x1552}, {0x1553, 0x1553, 0x1553},
    {0x1554, 0x1554, 0x1554}, {0x1555, 0x1555, 0x1555},
    {0x1556, 0x1556, 0x1556}, {0x1557, 0x1557, 0x1557},
    {0x1558, 0x1558, 0x1558}, {0x1559, 0x1559, 0x1559},
    {0x155A, 0x155A, 0x155A}, {0x155B, 0x155B, 0x155B},
    {0x155C, 0x155C, 0x155C}, {0x155D, 0x155D, 0x155D},
    {0x155E, 0x155E, 0x155E}, {0x155F, 0x155F, 0x155F},
    {0x1560, 0x1560, 0x1560}, {0x1561, 0x1561, 0x1561},
    {0x1562, 0x1562, 0x1562}, {0x1563, 0x1563, 0x1563},
    {0x1564, 0x1564, 0x1564}, {0x1565, 0x1565, 0x1565},
    {0x1566, 0x1566, 0x1566}, {0x1567, 0x1567, 0x1567},
    {0x1568, 0x1568, 0x1568}, {0x1569, 0x1569, 0x1569},
    {0x156A, 0x156A, 0x156A}, {0x156B, 0x156B, 0x156B},
    {0x156C, 0x156C, 0x156C}, {0x156D, 0x156D, 0x156D},
    {0x156E, 0x156E, 0x156E}, {0x156F, 0x156F, 0x156F},
    {0x1570, 0x1570, 0x1570}, {0x1571, 0x1571, 0x1571},
    {0x1572, 0x1572, 0x1572}, {0x1573, 0x1573, 0x1573},
    {0x1574, 0x1574, 0x1574}, {0x1575, 0x1575, 0x1575},
    {0x1576, 0x1576, 0x1576}, {0x1577, 0x1577, 0x1577},
    {0x1578, 0x1578, 0x1578}, {0x1579, 0x1579, 0x1579},
    {0x157A, 0x157A, 0x157A}, {0x157B, 0x157B, 0x157B},
    {0x157C, 0x157C, 0x157C}, {0x157D, 0x157D, 0x157D},
    {0x157E, 0x157E, 0x157E}, {0x157F, 0x157F, 0x157F},
    {0x1580, 0x1580, 0x1580}, {0x1581, 0x1581, 0x1581},
    {0x1582, 0x1582, 0x1582}, {0x1583, 0x1583, 0x1583},
    {0x1584, 0x1584, 0x1584}, {0x1585, 0x1585, 0x1585},
    {0x1586, 0x1586, 0x1586}, {0x1587, 0x1587, 0x1587},
    {0x1588, 0x1588, 0x1588}, {0x1589, 0x1589, 0x1589},
    {0x158A, 0x158A, 0x158A}, {0x158B, 0x158B, 0x158B},
    {0x158C, 0x158C, 0x158C}, {0x158D, 0x158D, 0x158D},
    {0x158E, 0x158E, 0x158E}, {0x158F, 0x158F, 0x158F},
    {0x1590, 0x1590, 0x1590}, {0x1591, 0x1591, 0x1591},
    {0x1592, 0x1592, 0x1592}, {0x1593, 0x1593, 0x1593},
    {0x1594, 0x1594, 0x1594}, {0x1595, 0x1595, 0x1595},
    {0x1596, 0x1596, 0x1596}, {0x1597, 0x1597, 0x1597},
    {0x1598, 0x1598, 0x1598}, {0x1599, 0x1599, 0x1599},
    {0x159A, 0x159A, 0x159A}, {0x159B, 0x159B, 0x159B},
    {0x159C, 0x159C, 0x159C}, {0x159D, 0x159D, 0x159D},
    {0x159E, 0x159E, 0x159E}, {0x159F, 0x159F, 0x159F},
    {0x15A0, 0x15A0, 0x15A0}, {0x15A1, 0x15A1, 0x15A1},
    {0x15A2, 0x15A2, 0x15A2}, {0x15A3, 0x15A3, 0x15A3},
    {0x15A4, 0x15A4, 0x15A4}, {0x15A5, 0x15A5, 0x15A5},
    {0x15A6, 0x15A6, 0x15A6}, {0x15A7, 0x15A7, 0x15A7},
    {0x15A8, 0x15A8, 0x15A8}, {0x15A9, 0x15A9, 0x15A9},
    {0x15AA, 0x15AA, 0x15AA}, {0x15AB, 0x15AB, 0x15AB},
    {0x15AC, 0x15AC, 0x15AC}, {0x15AD, 0x15AD, 0x15AD},
    {0x15AE, 0x15AE, 0x15AE}, {0x15AF, 0x15AF, 0x15AF},
    {0x15B0, 0x15B0, 0x15B0}, {0x15B1, 0x15B1, 0x15B1},
    {0x15B2, 0x15B2, 0x15B2}, {0x15B3, 0x15B3, 0x15B3},
    {0x15B4, 0x15B4, 0x15B4}, {0x15B5, 0x15B5, 0x15B5},
    {0x15B6, 0x15B6, 0x15B6}, {0x15B7, 0x15B7, 0x15B7},
    {0x15B8, 0x15B8, 0x15B8}, {0x15B9, 0x15B9, 0x15B9},
    {0x15BA, 0x15BA, 0x15BA}, {0x15BB, 0x15BB, 0x15BB},
    {0x15BC, 0x15BC, 0x15BC}, {0x15BD, 0x15BD, 0x15BD},
    {0x15BE, 0x15BE, 0x15BE}, {0x15BF, 0x15BF, 0x15BF},
    {0x15C0, 0x15C0, 0x15C0}, {0x15C1, 0x15C1, 0x15C1},
    {0x15C2, 0x15C2, 0x15C2}, {0x15C3, 0x15C3, 0x15C3},
    {0x15C4, 0x15C4, 0x15C4}, {0x15C5, 0x15C5, 0x15C5},
    {0x15C6, 0x15C6, 0x15C6}, {0x15C7, 0x15C7, 0x15C7},
    {0x15C8, 0x15C8, 0x15C8}, {0x15C9, 0x15C9, 0x15C9},
    {0x15CA, 0x15CA, 0x15CA}, {0x15CB, 0x15CB, 0x15CB},
    {0x15CC, 0x15CC, 0x15CC}, {0x15CD, 0x15CD, 0x15CD},
    {0x15CE, 0x15CE, 0x15CE}, {0x15CF, 0x15CF, 0x15CF},
    {0x15D0, 0x15D0, 0x15D0}, {0x15D1, 0x15D1, 0x15D1},
    {0x15D2, 0x15D2, 0x15D2}, {0x15D3, 0x15D3, 0x15D3},
    {0x15D4, 0x15D4, 0x15D4}, {0x15D5, 0x15D5, 0x15D5},
    {0x15D6, 0x15D6, 0x15D6}, {0x15D7, 0x15D7, 0x15D7},
    {0x15D8, 0x15D8, 0x15D8}, {0x15D9, 0x15D9, 0x15D9},
    {0x15DA, 0x15DA, 0x15DA}, {0x15DB, 0x15DB, 0x15DB},
    {0x15DC, 0x15DC, 0x15DC}, {0x15DD, 0x15DD, 0x15DD},
    {0x15DE, 0x15DE, 0x15DE}, {0x15DF, 0x15DF, 0x15DF},
    {0x15E0, 0x15E0, 0x15E0}, {0x15E1, 0x15E1, 0x15E1},
    {0x15E2, 0x15E2, 0x15E2}, {0x15E3, 0x15E3, 0x15E3},
    {0x15E4, 0x15E4, 0x15E4}, {0x15E5, 0x15E5, 0x15E5},
    {0x15E6, 0x15E6, 0x15E6}, {0x15E7, 0x15E7, 0x15E7},
    {0x15E8, 0x15E8, 0x15E8}, {0x15E9, 0x15E9, 0x15E9},
    {0x15EA, 0x15EA, 0x15EA}, {0x15EB, 0x15EB, 0x15EB},
    {0x15EC, 0x15EC, 0x15EC}, {0x15ED, 0x15ED, 0x15ED},
    {0x15EE, 0x15EE, 0x15EE}, {0x15EF, 0x15EF, 0x15EF},
    {0x15F0, 0x15F0, 0x15F0}, {0x15F1, 0x15F1, 0x15F1},
    {0x15F2, 0x15F2, 0x15F2}, {0x15F3, 0x15F3, 0x15F3},
    {0x15F4, 0x15F4, 0x15F4}, {0x15F5, 0x15F5, 0x15F5},
    {0x15F6, 0x15F6, 0x15F6}, {0x15F7, 0x15F7, 0x15F7},
    {0x15F8, 0x15F8, 0x15F8}, {0x15F9, 0x15F9, 0x15F9},
    {0x15FA, 0x15FA, 0x15FA}, {0x15FB, 0x15FB, 0x15FB},
    {0x15FC, 0x15FC, 0x15FC}, {0x15FD, 0x15FD, 0x15FD},
    {0x15FE, 0x15FE, 0x15FE}, {0x15FF, 0x15FF, 0x15FF},
    {0x1600, 0x1600, 0x1600}, {0x1601, 0x1601, 0x1601},
    {0x1602, 0x1602, 0x1602}, {0x1603, 0x1603, 0x1603},
    {0x1604, 0x1604, 0x1604}, {0x1605, 0x1605, 0x1605},
    {0x1606, 0x1606, 0x1606}, {0x1607, 0x1607, 0x1607},
    {0x1608, 0x1608, 0x1608}, {0x1609, 0x1609, 0x1609},
    {0x160A, 0x160A, 0x160A}, {0x160B, 0x160B, 0x160B},
    {0x160C, 0x160C, 0x160C}, {0x160D, 0x160D, 0x160D},
    {0x160E, 0x160E, 0x160E}, {0x160F, 0x160F, 0x160F},
    {0x1610, 0x1610, 0x1610}, {0x1611, 0x1611, 0x1611},
    {0x1612, 0x1612, 0x1612}, {0x1613, 0x1613, 0x1613},
    {0x1614, 0x1614, 0x1614}, {0x1615, 0x1615, 0x1615},
    {0x1616, 0x1616, 0x1616}, {0x1617, 0x1617, 0x1617},
    {0x1618, 0x1618, 0x1618}, {0x1619, 0x1619, 0x1619},
    {0x161A, 0x161A, 0x161A}, {0x161B, 0x161B, 0x161B},
    {0x161C, 0x161C, 0x161C}, {0x161D, 0x161D, 0x161D},
    {0x161E, 0x161E, 0x161E}, {0x161F, 0x161F, 0x161F},
    {0x1620, 0x1620, 0x1620}, {0x1621, 0x1621, 0x1621},
    {0x1622, 0x1622, 0x1622}, {0x1623, 0x1623, 0x1623},
    {0x1624, 0x1624, 0x1624}, {0x1625, 0x1625, 0x1625},
    {0x1626, 0x1626, 0x1626}, {0x1627, 0x1627, 0x1627},
    {0x1628, 0x1628, 0x1628}, {0x1629, 0x1629, 0x1629},
    {0x162A, 0x162A, 0x162A}, {0x162B, 0x162B, 0x162B},
    {0x162C, 0x162C, 0x162C}, {0x162D, 0x162D, 0x162D},
    {0x162E, 0x162E, 0x162E}, {0x162F, 0x162F, 0x162F},
    {0x1630, 0x1630, 0x1630}, {0x1631, 0x1631, 0x1631},
    {0x1632, 0x1632, 0x1632}, {0x1633, 0x1633, 0x1633},
    {0x1634, 0x1634, 0x1634}, {0x1635, 0x1635, 0x1635},
    {0x1636, 0x1636, 0x1636}, {0x1637, 0x1637, 0x1637},
    {0x1638, 0x1638, 0x1638}, {0x1639, 0x1639, 0x1639},
    {0x163A, 0x163A, 0x163A}, {0x163B, 0x163B, 0x163B},
    {0x163C, 0x163C, 0x163C}, {0x163D, 0x163D, 0x163D},
    {0x163E, 0x163E, 0x163E}, {0x163F, 0x163F, 0x163F},
    {0x1640, 0x1640, 0x1640}, {0x1641, 0x1641, 0x1641},
    {0x1642, 0x1642, 0x1642}, {0x1643, 0x1643, 0x1643},
    {0x1644, 0x1644, 0x1644}, {0x1645, 0x1645, 0x1645},
    {0x1646, 0x1646, 0x1646}, {0x1647, 0x1647, 0x1647},
    {0x1648, 0x1648, 0x1648}, {0x1649, 0x1649, 0x1649},
    {0x164A, 0x164A, 0x164A}, {0x164B, 0x164B, 0x164B},
    {0x164C, 0x164C, 0x164C}, {0x164D, 0x164D, 0x164D},
    {0x164E, 0x164E, 0x164E}, {0x164F, 0x164F, 0x164F},
    {0x1650, 0x1650, 0x1650}, {0x1651, 0x1651, 0x1651},
    {0x1652, 0x1652, 0x1652}, {0x1653, 0x1653, 0x1653},
    {0x1654, 0x1654, 0x1654}, {0x1655, 0x1655, 0x1655},
    {0x1656, 0x1656, 0x1656}, {0x1657, 0x1657, 0x1657},
    {0x1658, 0x1658, 0x1658}, {0x1659, 0x1659, 0x1659},
    {0x165A, 0x165A, 0x165A}, {0x165B, 0x165B, 0x165B},
    {0x165C, 0x165C, 0x165C}, {0x165D, 0x165D, 0x165D},
    {0x165E, 0x165E, 0x165E}, {0x165F, 0x165F, 0x165F},
    {0x1660, 0x1660, 0x1660}, {0x1661, 0x1661, 0x1661},
    {0x1662, 0x1662, 0x1662}, {0x1663, 0x1663, 0x1663},
    {0x1664, 0x1664, 0x1664}, {0x1665, 0x1665, 0x1665},
    {0x1666, 0x1666, 0x1666}, {0x1667, 0x1667, 0x1667},
    {0x1668, 0x1668, 0x1668}, {0x1669, 0x1669, 0x1669},
    {0x166A, 0x166A, 0x166A}, {0x166B, 0x166B, 0x166B},
    {0x166C, 0x166C, 0x166C}, {0x166F, 0x166F, 0x166F},
    {0x1670, 0x1670, 0x1670}, {0x1671, 0x1671, 0x1671},
    {0x1672, 0x1672, 0x1672}, {0x1673, 0x1673, 0x1673},
    {0x1674, 0x1674, 0x1674}, {0x1675, 0x1675, 0x1675},
    {0x1676, 0x1676, 0x1676}, {0x1681, 0x1681, 0x1681},
    {0x1682, 0x1682, 0x1682}, {0x1683, 0x1683, 0x1683},
    {0x1684, 0x1684, 0x1684}, {0x1685, 0x1685, 0x1685},
    {0x1686, 0x1686, 0x1686}, {0x1687, 0x1687, 0x1687},
    {0x1688, 0x1688, 0x1688}, {0x1689, 0x1689, 0x1689},
    {0x168A, 0x168A, 0x168A}, {0x168B, 0x168B, 0x168B},
    {0x168C, 0x168C, 0x168C}, {0x168D, 0x168D, 0x168D},
    {0x168E, 0x168E, 0x168E}, {0x168F, 0x168F, 0x168F},
    {0x1690, 0x1690, 0x1690}, {0x1691, 0x1691, 0x1691},
    {0x1692, 0x1692, 0x1692}, {0x1693, 0x1693, 0x1693},
    {0x1694, 0x1694, 0x1694}, {0x1695, 0x1695, 0x1695},
    {0x1696, 0x1696, 0x1696}, {0x1697, 0x1697, 0x1697},
    {0x1698, 0x1698, 0x1698}, {0x1699, 0x1699, 0x1699},
    {0x169A, 0x169A, 0x169A}, {0x16A0, 0x16A0, 0x16A0},
    {0x16A1, 0x16A1, 0x16A1}, {0x16A2, 0x16A2, 0x16A2},
    {0x16A3, 0x16A3, 0x16A3}, {0x16A4, 0x16A4, 0x16A4},
    {0x16A5, 0x16A5, 0x16A5}, {0x16A6, 0x16A6, 0x16A6},
    {0x16A7, 0x16A7, 0x16A7}, {0x16A8, 0x16A8, 0x16A8},
    {0x16A9, 0x16A9, 0x16A9}, {0x16AA, 0x16AA, 0x16AA},
    {0x16AB, 0x16AB, 0x16AB}, {0x16AC, 0x16AC, 0x16AC},
    {0x16AD, 0x16AD, 0x16AD}, {0x16AE, 0x16AE, 0x16AE},
    {0x16AF, 0x16AF, 0x16AF}, {0x16B0, 0x16B0, 0x16B0},
    {0x16B1, 0x16B1, 0x16B1}, {0x16B2, 0x16B2, 0x16B2},
    {0x16B3, 0x16B3, 0x16B3}, {0x16B4, 0x16B4, 0x16B4},
    {0x16B5, 0x16B5, 0x16B5}, {0x16B6, 0x16B6, 0x16B6},
    {0x16B7, 0x16B7, 0x16B7}, {0x16B8, 0x16B8, 0x16B8},
    {0x16B9, 0x16B9, 0x16B9}, {0x16BA, 0x16BA, 0x16BA},
    {0x16BB, 0x16BB, 0x16BB}, {0x16BC, 0x16BC, 0x16BC},
    {0x16BD, 0x16BD, 0x16BD}, {0x16BE, 0x16BE, 0x16BE},
    {0x16BF, 0x16BF, 0x16BF}, {0x16C0, 0x16C0, 0x16C0},
    {0x16C1, 0x16C1, 0x16C1}, {0x16C2, 0x16C2, 0x16C2},
    {0x16C3, 0x16C3, 0x16C3}, {0x16C4, 0x16C4, 0x16C4},
    {0x16C5, 0x16C5, 0x16C5}, {0x16C6, 0x16C6, 0x16C6},
    {0x16C7, 0x16C7, 0x16C7}, {0x16C8, 0x16C8, 0x16C8},
    {0x16C9, 0x16C9, 0x16C9}, {0x16CA, 0x16CA, 0x16CA},
    {0x16CB, 0x16CB, 0x16CB}, {0x16CC, 0x16CC, 0x16CC},
    {0x16CD, 0x16CD, 0x16CD}, {0x16CE, 0x16CE, 0x16CE},
    {0x16CF, 0x16CF, 0x16CF}, {0x16D0, 0x16D0, 0x16D0},
    {0x16D1, 0x16D1, 0x16D1}, {0x16D2, 0x16D2, 0x16D2},
    {0x16D3, 0x16D3, 0x16D3}, {0x16D4, 0x16D4, 0x16D4},
    {0x16D5, 0x16D5, 0x16D5}, {0x16D6, 0x16D6, 0x16D6},
    {0x16D7, 0x16D7, 0x16D7}, {0x16D8, 0x16D8, 0x16D8},
    {0x16D9, 0x16D9, 0x16D9}, {0x16DA, 0x16DA, 0x16DA},
    {0x16DB, 0x16DB, 0x16DB}, {0x16DC, 0x16DC, 0x16DC},
    {0x16DD, 0x16DD, 0x16DD}, {0x16DE, 0x16DE, 0x16DE},
    {0x16DF, 0x16DF, 0x16DF}, {0x16E0, 0x16E0, 0x16E0},
    {0x16E1, 0x16E1, 0x16E1}, {0x16E2, 0x16E2, 0x16E2},
    {0x16E3, 0x16E3, 0x16E3}, {0x16E4, 0x16E4, 0x16E4},
    {0x16E5, 0x16E5, 0x16E5}, {0x16E6, 0x16E6, 0x16E6},
    {0x16E7, 0x16E7, 0x16E7}, {0x16E8, 0x16E8, 0x16E8},
    {0x16E9, 0x16E9, 0x16E9}, {0x16EA, 0x16EA, 0x16EA},
    {0x1700, 0x1700, 0x1700}, {0x1701, 0x1701, 0x1701},
    {0x1702, 0x1702, 0x1702}, {0x1703, 0x1703, 0x1703},
    {0x1704, 0x1704, 0x1704}, {0x1705, 0x1705, 0x1705},
    {0x1706, 0x1706, 0x1706}, {0x1707, 0x1707, 0x1707},
    {0x1708, 0x1708, 0x1708}, {0x1709, 0x1709, 0x1709},
    {0x170A, 0x170A, 0x170A}, {0x170B, 0x170B, 0x170B},
    {0x170C, 0x170C, 0x170C}, {0x170E, 0x170E, 0x170E},
    {0x170F, 0x170F, 0x170F}, {0x1710, 0x1710, 0x1710},
    {0x1711, 0x1711, 0x1711}, {0x1712, 0x1712, 0x1712},
    {0x1713, 0x1713, 0x1713}, {0x1714, 0x1714, 0x1714},
    {0x1720, 0x1720, 0x1720}, {0x1721, 0x1721, 0x1721},
    {0x1722, 0x1722, 0x1722}, {0x1723, 0x1723, 0x1723},
    {0x1724, 0x1724, 0x1724}, {0x1725, 0x1725, 0x1725},
    {0x1726, 0x1726, 0x1726}, {0x1727, 0x1727, 0x1727},
    {0x1728, 0x1728, 0x1728}, {0x1729, 0x1729, 0x1729},
    {0x172A, 0x172A, 0x172A}, {0x172B, 0x172B, 0x172B},
    {0x172C, 0x172C, 0x172C}, {0x172D, 0x172D, 0x172D},
    {0x172E, 0x172E, 0x172E}, {0x172F, 0x172F, 0x172F},
    {0x1730, 0x1730, 0x1730}, {0x1731, 0x1731, 0x1731},
    {0x1732, 0x1732, 0x1732}, {0x1733, 0x1733, 0x1733},
    {0x1734, 0x1734, 0x1734}, {0x1740, 0x1740, 0x1740},
    {0x1741, 0x1741, 0x1741}, {0x1742, 0x1742, 0x1742},
    {0x1743, 0x1743, 0x1743}, {0x1744, 0x1744, 0x1744},
    {0x1745, 0x1745, 0x1745}, {0x1746, 0x1746, 0x1746},
    {0x1747, 0x1747, 0x1747}, {0x1748, 0x1748, 0x1748},
    {0x1749, 0x1749, 0x1749}, {0x174A, 0x174A, 0x174A},
    {0x174B, 0x174B, 0x174B}, {0x174C, 0x174C, 0x174C},
    {0x174D, 0x174D, 0x174D}, {0x174E, 0x174E, 0x174E},
    {0x174F, 0x174F, 0x174F}, {0x1750, 0x1750, 0x1750},
    {0x1751, 0x1751, 0x1751}, {0x1752, 0x1752, 0x1752},
    {0x1753, 0x1753, 0x1753}, {0x1760, 0x1760, 0x1760},
    {0x1761, 0x1761, 0x1761}, {0x1762, 0x1762, 0x1762},
    {0x1763, 0x1763, 0x1763}, {0x1764, 0x1764, 0x1764},
    {0x1765, 0x1765, 0x1765}, {0x1766, 0x1766, 0x1766},
    {0x1767, 0x1767, 0x1767}, {0x1768, 0x1768, 0x1768},
    {0x1769, 0x1769, 0x1769}, {0x176A, 0x176A, 0x176A},
    {0x176B, 0x176B, 0x176B}, {0x176C, 0x176C, 0x176C},
    {0x176E, 0x176E, 0x176E}, {0x176F, 0x176F, 0x176F},
    {0x1770, 0x1770, 0x1770}, {0x1772, 0x1772, 0x1772},
    {0x1773, 0x1773, 0x1773}, {0x1780, 0x1780, 0x1780},
    {0x1781, 0x1781, 0x1781}, {0x1782, 0x1782, 0x1782},
    {0x1783, 0x1783, 0x1783}, {0x1784, 0x1784, 0x1784},
    {0x1785, 0x1785, 0x1785}, {0x1786, 0x1786, 0x1786},
    {0x1787, 0x1787, 0x1787}, {0x1788, 0x1788, 0x1788},
    {0x1789, 0x1789, 0x1789}, {0x178A, 0x178A, 0x178A},
    {0x178B, 0x178B, 0x178B}, {0x178C, 0x178C, 0x178C},
    {0x178D, 0x178D, 0x178D}, {0x178E, 0x178E, 0x178E},
    {0x178F, 0x178F, 0x178F}, {0x1790, 0x1790, 0x1790},
    {0x1791, 0x1791, 0x1791}, {0x1792, 0x1792, 0x1792},
    {0x1793, 0x1793, 0x1793}, {0x1794, 0x1794, 0x1794},
    {0x1795, 0x1795, 0x1795}, {0x1796, 0x1796, 0x1796},
    {0x1797, 0x1797, 0x1797}, {0x1798, 0x1798, 0x1798},
    {0x1799, 0x1799, 0x1799}, {0x179A, 0x179A, 0x179A},
    {0x179B, 0x179B, 0x179B}, {0x179C, 0x179C, 0x179C},
    {0x179D, 0x179D, 0x179D}, {0x179E, 0x179E, 0x179E},
    {0x179F, 0x179F, 0x179F}, {0x17A0, 0x17A0, 0x17A0},
    {0x17A1, 0x17A1, 0x17A1}, {0x17A2, 0x17A2, 0x17A2},
    {0x17A3, 0x17A3, 0x17A3}, {0x17A4, 0x17A4, 0x17A4},
    {0x17A5, 0x17A5, 0x17A5}, {0x17A6, 0x17A6, 0x17A6},
    {0x17A7, 0x17A7, 0x17A7}, {0x17A8, 0x17A8, 0x17A8},
    {0x17A9, 0x17A9, 0x17A9}, {0x17AA, 0x17AA, 0x17AA},
    {0x17AB, 0x17AB, 0x17AB}, {0x17AC, 0x17AC, 0x17AC},
    {0x17AD, 0x17AD, 0x17AD}, {0x17AE, 0x17AE, 0x17AE},
    {0x17AF, 0x17AF, 0x17AF}, {0x17B0, 0x17B0, 0x17B0},
    {0x17B1, 0x17B1, 0x17B1}, {0x17B2, 0x17B2, 0x17B2},
    {0x17B3, 0x17B3, 0x17B3}, {0x17B7, 0x17B7, 0x17B7},
    {0x17B8, 0x17B8, 0x17B8}, {0x17B9, 0x17B9, 0x17B9},
    {0x17BA, 0x17BA, 0x17BA}, {0x17BB, 0x17BB, 0x17BB},
    {0x17BC, 0x17BC, 0x17BC}, {0x17BD, 0x17BD, 0x17BD},
    {0x17C6, 0x17C6, 0x17C6}, {0x17C9, 0x17C9, 0x17C9},
    {0x17CA, 0x17CA, 0x17CA}, {0x17CB, 0x17CB, 0x17CB},
    {0x17CC, 0x17CC, 0x17CC}, {0x17CD, 0x17CD, 0x17CD},
    {0x17CE, 0x17CE, 0x17CE}, {0x17CF, 0x17CF, 0x17CF},
    {0x17D0, 0x17D0, 0x17D0}, {0x17D1, 0x17D1, 0x17D1},
    {0x17D2, 0x17D2, 0x17D2}, {0x17D3, 0x17D3, 0x17D3},
    {0x17D7, 0x17D7, 0x17D7}, {0x17DC, 0x17DC, 0x17DC},
    {0x17DD, 0x17DD, 0x17DD}, {0x180B, 0x180B, 0x180B},
    {0x180C, 0x180C, 0x180C}, {0x180D, 0x180D, 0x180D},
    {0x1820, 0x1820, 0x1820}, {0x1821, 0x1821, 0x1821},
    {0x1822, 0x1822, 0x1822}, {0x1823, 0x1823, 0x1823},
    {0x1824, 0x1824, 0x1824}, {0x1825, 0x1825, 0x1825},
    {0x1826, 0x1826, 0x1826}, {0x1827, 0x1827, 0x1827},
    {0x1828, 0x1828, 0x1828}, {0x1829, 0x1829, 0x1829},
    {0x182A, 0x182A, 0x182A}, {0x182B, 0x182B, 0x182B},
    {0x182C, 0x182C, 0x182C}, {0x182D, 0x182D, 0x182D},
    {0x182E, 0x182E, 0x182E}, {0x182F, 0x182F, 0x182F},
    {0x1830, 0x1830, 0x1830}, {0x1831, 0x1831, 0x1831},
    {0x1832, 0x1832, 0x1832}, {0x1833, 0x1833, 0x1833},
    {0x1834, 0x1834, 0x1834}, {0x1835, 0x1835, 0x1835},
    {0x1836, 0x1836, 0x1836}, {0x1837, 0x1837, 0x1837},
    {0x1838, 0x1838, 0x1838}, {0x1839, 0x1839, 0x1839},
    {0x183A, 0x183A, 0x183A}, {0x183B, 0x183B, 0x183B},
    {0x183C, 0x183C, 0x183C}, {0x183D, 0x183D, 0x183D},
    {0x183E, 0x183E, 0x183E}, {0x183F, 0x183F, 0x183F},
    {0x1840, 0x1840, 0x1840}, {0x1841, 0x1841, 0x1841},
    {0x1842, 0x1842, 0x1842}, {0x1843, 0x1843, 0x1843},
    {0x1844, 0x1844, 0x1844}, {0x1845, 0x1845, 0x1845},
    {0x1846, 0x1846, 0x1846}, {0x1847, 0x1847, 0x1847},
    {0x1848, 0x1848, 0x1848}, {0x1849, 0x1849, 0x1849},
    {0x184A, 0x184A, 0x184A}, {0x184B, 0x184B, 0x184B},
    {0x184C, 0x184C, 0x184C}, {0x184D, 0x184D, 0x184D},
    {0x184E, 0x184E, 0x184E}, {0x184F, 0x184F, 0x184F},
    {0x1850, 0x1850, 0x1850}, {0x1851, 0x1851, 0x1851},
    {0x1852, 0x1852, 0x1852}, {0x1853, 0x1853, 0x1853},
    {0x1854, 0x1854, 0x1854}, {0x1855, 0x1855, 0x1855},
    {0x1856, 0x1856, 0x1856}, {0x1857, 0x1857, 0x1857},
    {0x1858, 0x1858, 0x1858}, {0x1859, 0x1859, 0x1859},
    {0x185A, 0x185A, 0x185A}, {0x185B, 0x185B, 0x185B},
    {0x185C, 0x185C, 0x185C}, {0x185D, 0x185D, 0x185D},
    {0x185E, 0x185E, 0x185E}, {0x185F, 0x185F, 0x185F},
    {0x1860, 0x1860, 0x1860}, {0x1861, 0x1861, 0x1861},
    {0x1862, 0x1862, 0x1862}, {0x1863, 0x1863, 0x1863},
    {0x1864, 0x1864, 0x1864}, {0x1865, 0x1865, 0x1865},
    {0x1866, 0x1866, 0x1866}, {0x1867, 0x1867, 0x1867},
    {0x1868, 0x1868, 0x1868}, {0x1869, 0x1869, 0x1869},
    {0x186A, 0x186A, 0x186A}, {0x186B, 0x186B, 0x186B},
    {0x186C, 0x186C, 0x186C}, {0x186D, 0x186D, 0x186D},
    {0x186E, 0x186E, 0x186E}, {0x186F, 0x186F, 0x186F},
    {0x1870, 0x1870, 0x1870}, {0x1871, 0x1871, 0x1871},
    {0x1872, 0x1872, 0x1872}, {0x1873, 0x1873, 0x1873},
    {0x1874, 0x1874, 0x1874}, {0x1875, 0x1875, 0x1875},
    {0x1876, 0x1876, 0x1876}, {0x1877, 0x1877, 0x1877},
    {0x1880, 0x1880, 0x1880}, {0x1881, 0x1881, 0x1881},
    {0x1882, 0x1882, 0x1882}, {0x1883, 0x1883, 0x1883},
    {0x1884, 0x1884, 0x1884}, {0x1885, 0x1885, 0x1885},
    {0x1886, 0x1886, 0x1886}, {0x1887, 0x1887, 0x1887},
    {0x1888, 0x1888, 0x1888}, {0x1889, 0x1889, 0x1889},
    {0x188A, 0x188A, 0x188A}, {0x188B, 0x188B, 0x188B},
    {0x188C, 0x188C, 0x188C}, {0x188D, 0x188D, 0x188D},
    {0x188E, 0x188E, 0x188E}, {0x188F, 0x188F, 0x188F},
    {0x1890, 0x1890, 0x1890}, {0x1891, 0x1891, 0x1891},
    {0x1892, 0x1892, 0x1892}, {0x1893, 0x1893, 0x1893},
    {0x1894, 0x1894, 0x1894}, {0x1895, 0x1895, 0x1895},
    {0x1896, 0x1896, 0x1896}, {0x1897, 0x1897, 0x1897},
    {0x1898, 0x1898, 0x1898}, {0x1899, 0x1899, 0x1899},
    {0x189A, 0x189A, 0x189A}, {0x189B, 0x189B, 0x189B},
    {0x189C, 0x189C, 0x189C}, {0x189D, 0x189D, 0x189D},
    {0x189E, 0x189E, 0x189E}, {0x189F, 0x189F, 0x189F},
    {0x18A0, 0x18A0, 0x18A0}, {0x18A1, 0x18A1, 0x18A1},
    {0x18A2, 0x18A2, 0x18A2}, {0x18A3, 0x18A3, 0x18A3},
    {0x18A4, 0x18A4, 0x18A4}, {0x18A5, 0x18A5, 0x18A5},
    {0x18A6, 0x18A6, 0x18A6}, {0x18A7, 0x18A7, 0x18A7},
    {0x18A8, 0x18A8, 0x18A8}, {0x18A9, 0x18A9, 0x18A9},
    {0x1900, 0x1900, 0x1900}, {0x1901, 0x1901, 0x1901},
    {0x1902, 0x1902, 0x1902}, {0x1903, 0x1903, 0x1903},
    {0x1904, 0x1904, 0x1904}, {0x1905, 0x1905, 0x1905},
    {0x1906, 0x1906, 0x1906}, {0x1907, 0x1907, 0x1907},
    {0x1908, 0x1908, 0x1908}, {0x1909, 0x1909, 0x1909},
    {0x190A, 0x190A, 0x190A}, {0x190B, 0x190B, 0x190B},
    {0x190C, 0x190C, 0x190C}, {0x190D, 0x190D, 0x190D},
    {0x190E, 0x190E, 0x190E}, {0x190F, 0x190F, 0x190F},
    {0x1910, 0x1910, 0x1910}, {0x1911, 0x1911, 0x1911},
    {0x1912, 0x1912, 0x1912}, {0x1913, 0x1913, 0x1913},
    {0x1914, 0x1914, 0x1914}, {0x1915, 0x1915, 0x1915},
    {0x1916, 0x1916, 0x1916}, {0x1917, 0x1917, 0x1917},
    {0x1918, 0x1918, 0x1918}, {0x1919, 0x1919, 0x1919},
    {0x191A, 0x191A, 0x191A}, {0x191B, 0x191B, 0x191B},
    {0x191C, 0x191C, 0x191C}, {0x1920, 0x1920, 0x1920},
    {0x1921, 0x1921, 0x1921}, {0x1922, 0x1922, 0x1922},
    {0x1927, 0x1927, 0x1927}, {0x1928, 0x1928, 0x1928},
    {0x1932, 0x1932, 0x1932}, {0x1939, 0x1939, 0x1939},
    {0x193A, 0x193A, 0x193A}, {0x193B, 0x193B, 0x193B},
    {0x1950, 0x1950, 0x1950}, {0x1951, 0x1951, 0x1951},
    {0x1952, 0x1952, 0x1952}, {0x1953, 0x1953, 0x1953},
    {0x1954, 0x1954, 0x1954}, {0x1955, 0x1955, 0x1955},
    {0x1956, 0x1956, 0x1956}, {0x1957, 0x1957, 0x1957},
    {0x1958, 0x1958, 0x1958}, {0x1959, 0x1959, 0x1959},
    {0x195A, 0x195A, 0x195A}, {0x195B, 0x195B, 0x195B},
    {0x195C, 0x195C, 0x195C}, {0x195D, 0x195D, 0x195D},
    {0x195E, 0x195E, 0x195E}, {0x195F, 0x195F, 0x195F},
    {0x1960, 0x1960, 0x1960}, {0x1961, 0x1961, 0x1961},
    {0x1962, 0x1962, 0x1962}, {0x1963, 0x1963, 0x1963},
    {0x1964, 0x1964, 0x1964}, {0x1965, 0x1965, 0x1965},
    {0x1966, 0x1966, 0x1966}, {0x1967, 0x1967, 0x1967},
    {0x1968, 0x1968, 0x1968}, {0x1969, 0x1969, 0x1969},
    {0x196A, 0x196A, 0x196A}, {0x196B, 0x196B, 0x196B},
    {0x196C, 0x196C, 0x196C}, {0x196D, 0x196D, 0x196D},
    {0x1970, 0x1970, 0x1970}, {0x1971, 0x1971, 0x1971},
    {0x1972, 0x1972, 0x1972}, {0x1973, 0x1973, 0x1973},
    {0x1974, 0x1974, 0x1974}, {0x1980, 0x1980, 0x1980},
    {0x1981, 0x1981, 0x1981}, {0x1982, 0x1982, 0x1982},
    {0x1983, 0x1983, 0x1983}, {0x1984, 0x1984, 0x1984},
    {0x1985, 0x1985, 0x1985}, {0x1986, 0x1986, 0x1986},
    {0x1987, 0x1987, 0x1987}, {0x1988, 0x1988, 0x1988},
    {0x1989, 0x1989, 0x1989}, {0x198A, 0x198A, 0x198A},
    {0x198B, 0x198B, 0x198B}, {0x198C, 0x198C, 0x198C},
    {0x198D, 0x198D, 0x198D}, {0x198E, 0x198E, 0x198E},
    {0x198F, 0x198F, 0x198F}, {0x1990, 0x1990, 0x1990},
    {0x1991, 0x1991, 0x1991}, {0x1992, 0x1992, 0x1992},
    {0x1993, 0x1993, 0x1993}, {0x1994, 0x1994, 0x1994},
    {0x1995, 0x1995, 0x1995}, {0x1996, 0x1996, 0x1996},
    {0x1997, 0x1997, 0x1997}, {0x1998, 0x1998, 0x1998},
    {0x1999, 0x1999, 0x1999}, {0x199A, 0x199A, 0x199A},
    {0x199B, 0x199B, 0x199B}, {0x199C, 0x199C, 0x199C},
    {0x199D, 0x199D, 0x199D}, {0x199E, 0x199E, 0x199E},
    {0x199F, 0x199F, 0x199F}, {0x19A0, 0x19A0, 0x19A0},
    {0x19A1, 0x19A1, 0x19A1}, {0x19A2, 0x19A2, 0x19A2},
    {0x19A3, 0x19A3, 0x19A3}, {0x19A4, 0x19A4, 0x19A4},
    {0x19A5, 0x19A5, 0x19A5}, {0x19A6, 0x19A6, 0x19A6},
    {0x19A7, 0x19A7, 0x19A7}, {0x19A8, 0x19A8, 0x19A8},
    {0x19A9, 0x19A9, 0x19A9}, {0x19C1, 0x19C1, 0x19C1},
    {0x19C2, 0x19C2, 0x19C2}, {0x19C3, 0x19C3, 0x19C3},
    {0x19C4, 0x19C4, 0x19C4}, {0x19C5, 0x19C5, 0x19C5},
    {0x19C6, 0x19C6, 0x19C6}, {0x19C7, 0x19C7, 0x19C7},
    {0x1A00, 0x1A00, 0x1A00}, {0x1A01, 0x1A01, 0x1A01},
    {0x1A02, 0x1A02, 0x1A02}, {0x1A03, 0x1A03, 0x1A03},
    {0x1A04, 0x1A04, 0x1A04}, {0x1A05, 0x1A05, 0x1A05},
    {0x1A06, 0x1A06, 0x1A06}, {0x1A07, 0x1A07, 0x1A07},
    {0x1A08, 0x1A08, 0x1A08}, {0x1A09, 0x1A09, 0x1A09},
    {0x1A0A, 0x1A0A, 0x1A0A}, {0x1A0B, 0x1A0B, 0x1A0B},
    {0x1A0C, 0x1A0C, 0x1A0C}, {0x1A0D, 0x1A0D, 0x1A0D},
    {0x1A0E, 0x1A0E, 0x1A0E}, {0x1A0F, 0x1A0F, 0x1A0F},
    {0x1A10, 0x1A10, 0x1A10}, {0x1A11, 0x1A11, 0x1A11},
    {0x1A12, 0x1A12, 0x1A12}, {0x1A13, 0x1A13, 0x1A13},
    {0x1A14, 0x1A14, 0x1A14}, {0x1A15, 0x1A15, 0x1A15},
    {0x1A16, 0x1A16, 0x1A16}, {0x1A17, 0x1A17, 0x1A17},
    {0x1A18, 0x1A18, 0x1A18}, {0x1D00, 0x1D00, 0x1D00},
    {0x1D01, 0x1D01, 0x1D01}, {0x1D02, 0x1D02, 0x1D02},
    {0x1D03, 0x1D03, 0x1D03}, {0x1D04, 0x1D04, 0x1D04},
    {0x1D05, 0x1D05, 0x1D05}, {0x1D06, 0x1D06, 0x1D06},
    {0x1D07, 0x1D07, 0x1D07}, {0x1D08, 0x1D08, 0x1D08},
    {0x1D09, 0x1D09, 0x1D09}, {0x1D0A, 0x1D0A, 0x1D0A},
    {0x1D0B, 0x1D0B, 0x1D0B}, {0x1D0C, 0x1D0C, 0x1D0C},
    {0x1D0D, 0x1D0D, 0x1D0D}, {0x1D0E, 0x1D0E, 0x1D0E},
    {0x1D0F, 0x1D0F, 0x1D0F}, {0x1D10, 0x1D10, 0x1D10},
    {0x1D11, 0x1D11, 0x1D11}, {0x1D12, 0x1D12, 0x1D12},
    {0x1D13, 0x1D13, 0x1D13}, {0x1D14, 0x1D14, 0x1D14},
    {0x1D15, 0x1D15, 0x1D15}, {0x1D16, 0x1D16, 0x1D16},
    {0x1D17, 0x1D17, 0x1D17}, {0x1D18, 0x1D18, 0x1D18},
    {0x1D19, 0x1D19, 0x1D19}, {0x1D1A, 0x1D1A, 0x1D1A},
    {0x1D1B, 0x1D1B, 0x1D1B}, {0x1D1C, 0x1D1C, 0x1D1C},
    {0x1D1D, 0x1D1D, 0x1D1D}, {0x1D1E, 0x1D1E, 0x1D1E},
    {0x1D1F, 0x1D1F, 0x1D1F}, {0x1D20, 0x1D20, 0x1D20},
    {0x1D21, 0x1D21, 0x1D21}, {0x1D22, 0x1D22, 0x1D22},
    {0x1D23, 0x1D23, 0x1D23}, {0x1D24, 0x1D24, 0x1D24},
    {0x1D25, 0x1D25, 0x1D25}, {0x1D26, 0x1D26, 0x1D26},
    {0x1D27, 0x1D27, 0x1D27}, {0x1D28, 0x1D28, 0x1D28},
    {0x1D29, 0x1D29, 0x1D29}, {0x1D2A, 0x1D2A, 0x1D2A},
    {0x1D2B, 0x1D2B, 0x1D2B}, {0x1D2C, 0x1D2C, 0x1D2C},
    {0x1D2D, 0x1D2D, 0x1D2D}, {0x1D2E, 0x1D2E, 0x1D2E},
    {0x1D2F, 0x1D2F, 0x1D2F}, {0x1D30, 0x1D30, 0x1D30},
    {0x1D31, 0x1D31, 0x1D31}, {0x1D32, 0x1D32, 0x1D32},
    {0x1D33, 0x1D33, 0x1D33}, {0x1D34, 0x1D34, 0x1D34},
    {0x1D35, 0x1D35, 0x1D35}, {0x1D36, 0x1D36, 0x1D36},
    {0x1D37, 0x1D37, 0x1D37}, {0x1D38, 0x1D38, 0x1D38},
    {0x1D39, 0x1D39, 0x1D39}, {0x1D3A, 0x1D3A, 0x1D3A},
    {0x1D3B, 0x1D3B, 0x1D3B}, {0x1D3C, 0x1D3C, 0x1D3C},
    {0x1D3D, 0x1D3D, 0x1D3D}, {0x1D3E, 0x1D3E, 0x1D3E},
    {0x1D3F, 0x1D3F, 0x1D3F}, {0x1D40, 0x1D40, 0x1D40},
    {0x1D41, 0x1D41, 0x1D41}, {0x1D42, 0x1D42, 0x1D42},
    {0x1D43, 0x1D43, 0x1D43}, {0x1D44, 0x1D44, 0x1D44},
    {0x1D45, 0x1D45, 0x1D45}, {0x1D46, 0x1D46, 0x1D46},
    {0x1D47, 0x1D47, 0x1D47}, {0x1D48, 0x1D48, 0x1D48},
    {0x1D49, 0x1D49, 0x1D49}, {0x1D4A, 0x1D4A, 0x1D4A},
    {0x1D4B, 0x1D4B, 0x1D4B}, {0x1D4C, 0x1D4C, 0x1D4C},
    {0x1D4D, 0x1D4D, 0x1D4D}, {0x1D4E, 0x1D4E, 0x1D4E},
    {0x1D4F, 0x1D4F, 0x1D4F}, {0x1D50, 0x1D50, 0x1D50},
    {0x1D51, 0x1D51, 0x1D51}, {0x1D52, 0x1D52, 0x1D52},
    {0x1D53, 0x1D53, 0x1D53}, {0x1D54, 0x1D54, 0x1D54},
    {0x1D55, 0x1D55, 0x1D55}, {0x1D56, 0x1D56, 0x1D56},
    {0x1D57, 0x1D57, 0x1D57}, {0x1D58, 0x1D58, 0x1D58},
    {0x1D59, 0x1D59, 0x1D59}, {0x1D5A, 0x1D5A, 0x1D5A},
    {0x1D5B, 0x1D5B, 0x1D5B}, {0x1D5C, 0x1D5C, 0x1D5C},
    {0x1D5D, 0x1D5D, 0x1D5D}, {0x1D5E, 0x1D5E, 0x1D5E},
    {0x1D5F, 0x1D5F, 0x1D5F}, {0x1D60, 0x1D60, 0x1D60},
    {0x1D61, 0x1D61, 0x1D61}, {0x1D62, 0x1D62, 0x1D62},
    {0x1D63, 0x1D63, 0x1D63}, {0x1D64, 0x1D64, 0x1D64},
    {0x1D65, 0x1D65, 0x1D65}, {0x1D66, 0x1D66, 0x1D66},
    {0x1D67, 0x1D67, 0x1D67}, {0x1D68, 0x1D68, 0x1D68},
    {0x1D69, 0x1D69, 0x1D69}, {0x1D6A, 0x1D6A, 0x1D6A},
    {0x1D6B, 0x1D6B, 0x1D6B}, {0x1D6C, 0x1D6C, 0x1D6C},
    {0x1D6D, 0x1D6D, 0x1D6D}, {0x1D6E, 0x1D6E, 0x1D6E},
    {0x1D6F, 0x1D6F, 0x1D6F}, {0x1D70, 0x1D70, 0x1D70},
    {0x1D71, 0x1D71, 0x1D71}, {0x1D72, 0x1D72, 0x1D72},
    {0x1D73, 0x1D73, 0x1D73}, {0x1D74, 0x1D74, 0x1D74},
    {0x1D75, 0x1D75, 0x1D75}, {0x1D76, 0x1D76, 0x1D76},
    {0x1D77, 0x1D77, 0x1D77}, {0x1D78, 0x1D78, 0x1D78},
    {0x1D79, 0x1D79, 0x1D79}, {0x1D7A, 0x1D7A, 0x1D7A},
    {0x1D7B, 0x1D7B, 0x1D7B}, {0x1D7C, 0x1D7C, 0x1D7C},
    {0x1D7D, 0x1D7D, 0x1D7D}, {0x1D7E, 0x1D7E, 0x1D7E},
    {0x1D7F, 0x1D7F, 0x1D7F}, {0x1D80, 0x1D80, 0x1D80},
    {0x1D81, 0x1D81, 0x1D81}, {0x1D82, 0x1D82, 0x1D82},
    {0x1D83, 0x1D83, 0x1D83}, {0x1D84, 0x1D84, 0x1D84},
    {0x1D85, 0x1D85, 0x1D85}, {0x1D86, 0x1D86, 0x1D86},
    {0x1D87, 0x1D87, 0x1D87}, {0x1D88, 0x1D88, 0x1D88},
    {0x1D89, 0x1D89, 0x1D89}, {0x1D8A, 0x1D8A, 0x1D8A},
    {0x1D8B, 0x1D8B, 0x1D8B}, {0x1D8C, 0x1D8C, 0x1D8C},
    {0x1D8D, 0x1D8D, 0x1D8D}, {0x1D8E, 0x1D8E, 0x1D8E},
    {0x1D8F, 0x1D8F, 0x1D8F}, {0x1D90, 0x1D90, 0x1D90},
    {0x1D91, 0x1D91, 0x1D91}, {0x1D92, 0x1D92, 0x1D92},
    {0x1D93, 0x1D93, 0x1D93}, {0x1D94, 0x1D94, 0x1D94},
    {0x1D95, 0x1D95, 0x1D95}, {0x1D96, 0x1D96, 0x1D96},
    {0x1D97, 0x1D97, 0x1D97}, {0x1D98, 0x1D98, 0x1D98},
    {0x1D99, 0x1D99, 0x1D99}, {0x1D9A, 0x1D9A, 0x1D9A},
    {0x1D9B, 0x1D9B, 0x1D9B}, {0x1D9C, 0x1D9C, 0x1D9C},
    {0x1D9D, 0x1D9D, 0x1D9D}, {0x1D9E, 0x1D9E, 0x1D9E},
    {0x1D9F, 0x1D9F, 0x1D9F}, {0x1DA0, 0x1DA0, 0x1DA0},
    {0x1DA1, 0x1DA1, 0x1DA1}, {0x1DA2, 0x1DA2, 0x1DA2},
    {0x1DA3, 0x1DA3, 0x1DA3}, {0x1DA4, 0x1DA4, 0x1DA4},
    {0x1DA5, 0x1DA5, 0x1DA5}, {0x1DA6, 0x1DA6, 0x1DA6},
    {0x1DA7, 0x1DA7, 0x1DA7}, {0x1DA8, 0x1DA8, 0x1DA8},
    {0x1DA9, 0x1DA9, 0x1DA9}, {0x1DAA, 0x1DAA, 0x1DAA},
    {0x1DAB, 0x1DAB, 0x1DAB}, {0x1DAC, 0x1DAC, 0x1DAC},
    {0x1DAD, 0x1DAD, 0x1DAD}, {0x1DAE, 0x1DAE, 0x1DAE},
    {0x1DAF, 0x1DAF, 0x1DAF}, {0x1DB0, 0x1DB0, 0x1DB0},
    {0x1DB1, 0x1DB1, 0x1DB1}, {0x1DB2, 0x1DB2, 0x1DB2},
    {0x1DB3, 0x1DB3, 0x1DB3}, {0x1DB4, 0x1DB4, 0x1DB4},
    {0x1DB5, 0x1DB5, 0x1DB5}, {0x1DB6, 0x1DB6, 0x1DB6},
    {0x1DB7, 0x1DB7, 0x1DB7}, {0x1DB8, 0x1DB8, 0x1DB8},
    {0x1DB9, 0x1DB9, 0x1DB9}, {0x1DBA, 0x1DBA, 0x1DBA},
    {0x1DBB, 0x1DBB, 0x1DBB}, {0x1DBC, 0x1DBC, 0x1DBC},
    {0x1DBD, 0x1DBD, 0x1DBD}, {0x1DBE, 0x1DBE, 0x1DBE},
    {0x1DBF, 0x1DBF, 0x1DBF}, {0x1DC0, 0x1DC0, 0x1DC0},
    {0x1DC1, 0x1DC1, 0x1DC1}, {0x1DC2, 0x1DC2, 0x1DC2},
    {0x1DC3, 0x1DC3, 0x1DC3}, {0x1E00, 0x1E00, 0x1E01},
    {0x1E01, 0x1E00, 0x1E01}, {0x1E02, 0x1E02, 0x1E03},
    {0x1E03, 0x1E02, 0x1E03}, {0x1E04, 0x1E04, 0x1E05},
    {0x1E05, 0x1E04, 0x1E05}, {0x1E06, 0x1E06, 0x1E07},
    {0x1E07, 0x1E06, 0x1E07}, {0x1E08, 0x1E08, 0x1E09},
    {0x1E09, 0x1E08, 0x1E09}, {0x1E0A, 0x1E0A, 0x1E0B},
    {0x1E0B, 0x1E0A, 0x1E0B}, {0x1E0C, 0x1E0C, 0x1E0D},
    {0x1E0D, 0x1E0C, 0x1E0D}, {0x1E0E, 0x1E0E, 0x1E0F},
    {0x1E0F, 0x1E0E, 0x1E0F}, {0x1E10, 0x1E10, 0x1E11},
    {0x1E11, 0x1E10, 0x1E11}, {0x1E12, 0x1E12, 0x1E13},
    {0x1E13, 0x1E12, 0x1E13}, {0x1E14, 0x1E14, 0x1E15},
    {0x1E15, 0x1E14, 0x1E15}, {0x1E16, 0x1E16, 0x1E17},
    {0x1E17, 0x1E16, 0x1E17}, {0x1E18, 0x1E18, 0x1E19},
    {0x1E19, 0x1E18, 0x1E19}, {0x1E1A, 0x1E1A, 0x1E1B},
    {0x1E1B, 0x1E1A, 0x1E1B}, {0x1E1C, 0x1E1C, 0x1E1D},
    {0x1E1D, 0x1E1C, 0x1E1D}, {0x1E1E, 0x1E1E, 0x1E1F},
    {0x1E1F, 0x1E1E, 0x1E1F}, {0x1E20, 0x1E20, 0x1E21},
    {0x1E21, 0x1E20, 0x1E21}, {0x1E22, 0x1E22, 0x1E23},
    {0x1E23, 0x1E22, 0x1E23}, {0x1E24, 0x1E24, 0x1E25},
    {0x1E25, 0x1E24, 0x1E25}, {0x1E26, 0x1E26, 0x1E27},
    {0x1E27, 0x1E26, 0x1E27}, {0x1E28, 0x1E28, 0x1E29},
    {0x1E29, 0x1E28, 0x1E29}, {0x1E2A, 0x1E2A, 0x1E2B},
    {0x1E2B, 0x1E2A, 0x1E2B}, {0x1E2C, 0x1E2C, 0x1E2D},
    {0x1E2D, 0x1E2C, 0x1E2D}, {0x1E2E, 0x1E2E, 0x1E2F},
    {0x1E2F, 0x1E2E, 0x1E2F}, {0x1E30, 0x1E30, 0x1E31},
    {0x1E31, 0x1E30, 0x1E31}, {0x1E32, 0x1E32, 0x1E33},
    {0x1E33, 0x1E32, 0x1E33}, {0x1E34, 0x1E34, 0x1E35},
    {0x1E35, 0x1E34, 0x1E35}, {0x1E36, 0x1E36, 0x1E37},
    {0x1E37, 0x1E36, 0x1E37}, {0x1E38, 0x1E38, 0x1E39},
    {0x1E39, 0x1E38, 0x1E39}, {0x1E3A, 0x1E3A, 0x1E3B},
    {0x1E3B, 0x1E3A, 0x1E3B}, {0x1E3C, 0x1E3C, 0x1E3D},
    {0x1E3D, 0x1E3C, 0x1E3D}, {0x1E3E, 0x1E3E, 0x1E3F},
    {0x1E3F, 0x1E3E, 0x1E3F}, {0x1E40, 0x1E40, 0x1E41},
    {0x1E41, 0x1E40, 0x1E41}, {0x1E42, 0x1E42, 0x1E43},
    {0x1E43, 0x1E42, 0x1E43}, {0x1E44, 0x1E44, 0x1E45},
    {0x1E45, 0x1E44, 0x1E45}, {0x1E46, 0x1E46, 0x1E47},
    {0x1E47, 0x1E46, 0x1E47}, {0x1E48, 0x1E48, 0x1E49},
    {0x1E49, 0x1E48, 0x1E49}, {0x1E4A, 0x1E4A, 0x1E4B},
    {0x1E4B, 0x1E4A, 0x1E4B}, {0x1E4C, 0x1E4C, 0x1E4D},
    {0x1E4D, 0x1E4C, 0x1E4D}, {0x1E4E, 0x1E4E, 0x1E4F},
    {0x1E4F, 0x1E4E, 0x1E4F}, {0x1E50, 0x1E50, 0x1E51},
    {0x1E51, 0x1E50, 0x1E51}, {0x1E52, 0x1E52, 0x1E53},
    {0x1E53, 0x1E52, 0x1E53}, {0x1E54, 0x1E54, 0x1E55},
    {0x1E55, 0x1E54, 0x1E55}, {0x1E56, 0x1E56, 0x1E57},
    {0x1E57, 0x1E56, 0x1E57}, {0x1E58, 0x1E58, 0x1E59},
    {0x1E59, 0x1E58, 0x1E59}, {0x1E5A, 0x1E5A, 0x1E5B},
    {0x1E5B, 0x1E5A, 0x1E5B}, {0x1E5C, 0x1E5C, 0x1E5D},
    {0x1E5D, 0x1E5C, 0x1E5D}, {0x1E5E, 0x1E5E, 0x1E5F},
    {0x1E5F, 0x1E5E, 0x1E5F}, {0x1E60, 0x1E60, 0x1E61},
    {0x1E61, 0x1E60, 0x1E61}, {0x1E62, 0x1E62, 0x1E63},
    {0x1E63, 0x1E62, 0x1E63}, {0x1E64, 0x1E64, 0x1E65},
    {0x1E65, 0x1E64, 0x1E65}, {0x1E66, 0x1E66, 0x1E67},
    {0x1E67, 0x1E66, 0x1E67}, {0x1E68, 0x1E68, 0x1E69},
    {0x1E69, 0x1E68, 0x1E69}, {0x1E6A, 0x1E6A, 0x1E6B},
    {0x1E6B, 0x1E6A, 0x1E6B}, {0x1E6C, 0x1E6C, 0x1E6D},
    {0x1E6D, 0x1E6C, 0x1E6D}, {0x1E6E, 0x1E6E, 0x1E6F},
    {0x1E6F, 0x1E6E, 0x1E6F}, {0x1E70, 0x1E70, 0x1E71},
    {0x1E71, 0x1E70, 0x1E71}, {0x1E72, 0x1E72, 0x1E73},
    {0x1E73, 0x1E72, 0x1E73}, {0x1E74, 0x1E74, 0x1E75},
    {0x1E75, 0x1E74, 0x1E75}, {0x1E76, 0x1E76, 0x1E77},
    {0x1E77, 0x1E76, 0x1E77}, {0x1E78, 0x1E78, 0x1E79},
    {0x1E79, 0x1E78, 0x1E79}, {0x1E7A, 0x1E7A, 0x1E7B},
    {0x1E7B, 0x1E7A, 0x1E7B}, {0x1E7C, 0x1E7C, 0x1E7D},
    {0x1E7D, 0x1E7C, 0x1E7D}, {0x1E7E, 0x1E7E, 0x1E7F},
    {0x1E7F, 0x1E7E, 0x1E7F}, {0x1E80, 0x1E80, 0x1E81},
    {0x1E81, 0x1E80, 0x1E81}, {0x1E82, 0x1E82, 0x1E83},
    {0x1E83, 0x1E82, 0x1E83}, {0x1E84, 0x1E84, 0x1E85},
    {0x1E85, 0x1E84, 0x1E85}, {0x1E86, 0x1E86, 0x1E87},
    {0x1E87, 0x1E86, 0x1E87}, {0x1E88, 0x1E88, 0x1E89},
    {0x1E89, 0x1E88, 0x1E89}, {0x1E8A, 0x1E8A, 0x1E8B},
    {0x1E8B, 0x1E8A, 0x1E8B}, {0x1E8C, 0x1E8C, 0x1E8D},
    {0x1E8D, 0x1E8C, 0x1E8D}, {0x1E8E, 0x1E8E, 0x1E8F},
    {0x1E8F, 0x1E8E, 0x1E8F}, {0x1E90, 0x1E90, 0x1E91},
    {0x1E91, 0x1E90, 0x1E91}, {0x1E92, 0x1E92, 0x1E93},
    {0x1E93, 0x1E92, 0x1E93}, {0x1E94, 0x1E94, 0x1E95},
    {0x1E95, 0x1E94, 0x1E95}, {0x1E96, 0x1E96, 0x1E96},
    {0x1E97, 0x1E97, 0x1E97}, {0x1E98, 0x1E98, 0x1E98},
    {0x1E99, 0x1E99, 0x1E99}, {0x1E9A, 0x1E9A, 0x1E9A},
    {0x1E9B, 0x1E60, 0x1E9B}, {0x1EA0, 0x1EA0, 0x1EA1},
    {0x1EA1, 0x1EA0, 0x1EA1}, {0x1EA2, 0x1EA2, 0x1EA3},
    {0x1EA3, 0x1EA2, 0x1EA3}, {0x1EA4, 0x1EA4, 0x1EA5},
    {0x1EA5, 0x1EA4, 0x1EA5}, {0x1EA6, 0x1EA6, 0x1EA7},
    {0x1EA7, 0x1EA6, 0x1EA7}, {0x1EA8, 0x1EA8, 0x1EA9},
    {0x1EA9, 0x1EA8, 0x1EA9}, {0x1EAA, 0x1EAA, 0x1EAB},
    {0x1EAB, 0x1EAA, 0x1EAB}, {0x1EAC, 0x1EAC, 0x1EAD},
    {0x1EAD, 0x1EAC, 0x1EAD}, {0x1EAE, 0x1EAE, 0x1EAF},
    {0x1EAF, 0x1EAE, 0x1EAF}, {0x1EB0, 0x1EB0, 0x1EB1},
    {0x1EB1, 0x1EB0, 0x1EB1}, {0x1EB2, 0x1EB2, 0x1EB3},
    {0x1EB3, 0x1EB2, 0x1EB3}, {0x1EB4, 0x1EB4, 0x1EB5},
    {0x1EB5, 0x1EB4, 0x1EB5}, {0x1EB6, 0x1EB6, 0x1EB7},
    {0x1EB7, 0x1EB6, 0x1EB7}, {0x1EB8, 0x1EB8, 0x1EB9},
    {0x1EB9, 0x1EB8, 0x1EB9}, {0x1EBA, 0x1EBA, 0x1EBB},
    {0x1EBB, 0x1EBA, 0x1EBB}, {0x1EBC, 0x1EBC, 0x1EBD},
    {0x1EBD, 0x1EBC, 0x1EBD}, {0x1EBE, 0x1EBE, 0x1EBF},
    {0x1EBF, 0x1EBE, 0x1EBF}, {0x1EC0, 0x1EC0, 0x1EC1},
    {0x1EC1, 0x1EC0, 0x1EC1}, {0x1EC2, 0x1EC2, 0x1EC3},
    {0x1EC3, 0x1EC2, 0x1EC3}, {0x1EC4, 0x1EC4, 0x1EC5},
    {0x1EC5, 0x1EC4, 0x1EC5}, {0x1EC6, 0x1EC6, 0x1EC7},
    {0x1EC7, 0x1EC6, 0x1EC7}, {0x1EC8, 0x1EC8, 0x1EC9},
    {0x1EC9, 0x1EC8, 0x1EC9}, {0x1ECA, 0x1ECA, 0x1ECB},
    {0x1ECB, 0x1ECA, 0x1ECB}, {0x1ECC, 0x1ECC, 0x1ECD},
    {0x1ECD, 0x1ECC, 0x1ECD}, {0x1ECE, 0x1ECE, 0x1ECF},
    {0x1ECF, 0x1ECE, 0x1ECF}, {0x1ED0, 0x1ED0, 0x1ED1},
    {0x1ED1, 0x1ED0, 0x1ED1}, {0x1ED2, 0x1ED2, 0x1ED3},
    {0x1ED3, 0x1ED2, 0x1ED3}, {0x1ED4, 0x1ED4, 0x1ED5},
    {0x1ED5, 0x1ED4, 0x1ED5}, {0x1ED6, 0x1ED6, 0x1ED7},
    {0x1ED7, 0x1ED6, 0x1ED7}, {0x1ED8, 0x1ED8, 0x1ED9},
    {0x1ED9, 0x1ED8, 0x1ED9}, {0x1EDA, 0x1EDA, 0x1EDB},
    {0x1EDB, 0x1EDA, 0x1EDB}, {0x1EDC, 0x1EDC, 0x1EDD},
    {0x1EDD, 0x1EDC, 0x1EDD}, {0x1EDE, 0x1EDE, 0x1EDF},
    {0x1EDF, 0x1EDE, 0x1EDF}, {0x1EE0, 0x1EE0, 0x1EE1},
    {0x1EE1, 0x1EE0, 0x1EE1}, {0x1EE2, 0x1EE2, 0x1EE3},
    {0x1EE3, 0x1EE2, 0x1EE3}, {0x1EE4, 0x1EE4, 0x1EE5},
    {0x1EE5, 0x1EE4, 0x1EE5}, {0x1EE6, 0x1EE6, 0x1EE7},
    {0x1EE7, 0x1EE6, 0x1EE7}, {0x1EE8, 0x1EE8, 0x1EE9},
    {0x1EE9, 0x1EE8, 0x1EE9}, {0x1EEA, 0x1EEA, 0x1EEB},
    {0x1EEB, 0x1EEA, 0x1EEB}, {0x1EEC, 0x1EEC, 0x1EED},
    {0x1EED, 0x1EEC, 0x1EED}, {0x1EEE, 0x1EEE, 0x1EEF},
    {0x1EEF, 0x1EEE, 0x1EEF}, {0x1EF0, 0x1EF0, 0x1EF1},
    {0x1EF1, 0x1EF0, 0x1EF1}, {0x1EF2, 0x1EF2, 0x1EF3},
    {0x1EF3, 0x1EF2, 0x1EF3}, {0x1EF4, 0x1EF4, 0x1EF5},
    {0x1EF5, 0x1EF4, 0x1EF5}, {0x1EF6, 0x1EF6, 0x1EF7},
    {0x1EF7, 0x1EF6, 0x1EF7}, {0x1EF8, 0x1EF8, 0x1EF9},
    {0x1EF9, 0x1EF8, 0x1EF9}, {0x1F00, 0x1F08, 0x1F00},
    {0x1F01, 0x1F09, 0x1F01}, {0x1F02, 0x1F0A, 0x1F02},
    {0x1F03, 0x1F0B, 0x1F03}, {0x1F04, 0x1F0C, 0x1F04},
    {0x1F05, 0x1F0D, 0x1F05}, {0x1F06, 0x1F0E, 0x1F06},
    {0x1F07, 0x1F0F, 0x1F07}, {0x1F08, 0x1F08, 0x1F00},
    {0x1F09, 0x1F09, 0x1F01}, {0x1F0A, 0x1F0A, 0x1F02},
    {0x1F0B, 0x1F0B, 0x1F03}, {0x1F0C, 0x1F0C, 0x1F04},
    {0x1F0D, 0x1F0D, 0x1F05}, {0x1F0E, 0x1F0E, 0x1F06},
    {0x1F0F, 0x1F0F, 0x1F07}, {0x1F10, 0x1F18, 0x1F10},
    {0x1F11, 0x1F19, 0x1F11}, {0x1F12, 0x1F1A, 0x1F12},
    {0x1F13, 0x1F1B, 0x1F13}, {0x1F14, 0x1F1C, 0x1F14},
    {0x1F15, 0x1F1D, 0x1F15}, {0x1F18, 0x1F18, 0x1F10},
    {0x1F19, 0x1F19, 0x1F11}, {0x1F1A, 0x1F1A, 0x1F12},
    {0x1F1B, 0x1F1B, 0x1F13}, {0x1F1C, 0x1F1C, 0x1F14},
    {0x1F1D, 0x1F1D, 0x1F15}, {0x1F20, 0x1F28, 0x1F20},
    {0x1F21, 0x1F29, 0x1F21}, {0x1F22, 0x1F2A, 0x1F22},
    {0x1F23, 0x1F2B, 0x1F23}, {0x1F24, 0x1F2C, 0x1F24},
    {0x1F25, 0x1F2D, 0x1F25}, {0x1F26, 0x1F2E, 0x1F26},
    {0x1F27, 0x1F2F, 0x1F27}, {0x1F28, 0x1F28, 0x1F20},
    {0x1F29, 0x1F29, 0x1F21}, {0x1F2A, 0x1F2A, 0x1F22},
    {0x1F2B, 0x1F2B, 0x1F23}, {0x1F2C, 0x1F2C, 0x1F24},
    {0x1F2D, 0x1F2D, 0x1F25}, {0x1F2E, 0x1F2E, 0x1F26},
    {0x1F2F, 0x1F2F, 0x1F27}, {0x1F30, 0x1F38, 0x1F30},
    {0x1F31, 0x1F39, 0x1F31}, {0x1F32, 0x1F3A, 0x1F32},
    {0x1F33, 0x1F3B, 0x1F33}, {0x1F34, 0x1F3C, 0x1F34},
    {0x1F35, 0x1F3D, 0x1F35}, {0x1F36, 0x1F3E, 0x1F36},
    {0x1F37, 0x1F3F, 0x1F37}, {0x1F38, 0x1F38, 0x1F30},
    {0x1F39, 0x1F39, 0x1F31}, {0x1F3A, 0x1F3A, 0x1F32},
    {0x1F3B, 0x1F3B, 0x1F33}, {0x1F3C, 0x1F3C, 0x1F34},
    {0x1F3D, 0x1F3D, 0x1F35}, {0x1F3E, 0x1F3E, 0x1F36},
    {0x1F3F, 0x1F3F, 0x1F37}, {0x1F40, 0x1F48, 0x1F40},
    {0x1F41, 0x1F49, 0x1F41}, {0x1F42, 0x1F4A, 0x1F42},
    {0x1F43, 0x1F4B, 0x1F43}, {0x1F44, 0x1F4C, 0x1F44},
    {0x1F45, 0x1F4D, 0x1F45}, {0x1F48, 0x1F48, 0x1F40},
    {0x1F49, 0x1F49, 0x1F41}, {0x1F4A, 0x1F4A, 0x1F42},
    {0x1F4B, 0x1F4B, 0x1F43}, {0x1F4C, 0x1F4C, 0x1F44},
    {0x1F4D, 0x1F4D, 0x1F45}, {0x1F50, 0x1F50, 0x1F50},
    {0x1F51, 0x1F59, 0x1F51}, {0x1F52, 0x1F52, 0x1F52},
    {0x1F53, 0x1F5B, 0x1F53}, {0x1F54, 0x1F54, 0x1F54},
    {0x1F55, 0x1F5D, 0x1F55}, {0x1F56, 0x1F56, 0x1F56},
    {0x1F57, 0x1F5F, 0x1F57}, {0x1F59, 0x1F59, 0x1F51},
    {0x1F5B, 0x1F5B, 0x1F53}, {0x1F5D, 0x1F5D, 0x1F55},
    {0x1F5F, 0x1F5F, 0x1F57}, {0x1F60, 0x1F68, 0x1F60},
    {0x1F61, 0x1F69, 0x1F61}, {0x1F62, 0x1F6A, 0x1F62},
    {0x1F63, 0x1F6B, 0x1F63}, {0x1F64, 0x1F6C, 0x1F64},
    {0x1F65, 0x1F6D, 0x1F65}, {0x1F66, 0x1F6E, 0x1F66},
    {0x1F67, 0x1F6F, 0x1F67}, {0x1F68, 0x1F68, 0x1F60},
    {0x1F69, 0x1F69, 0x1F61}, {0x1F6A, 0x1F6A, 0x1F62},
    {0x1F6B, 0x1F6B, 0x1F63}, {0x1F6C, 0x1F6C, 0x1F64},
    {0x1F6D, 0x1F6D, 0x1F65}, {0x1F6E, 0x1F6E, 0x1F66},
    {0x1F6F, 0x1F6F, 0x1F67}, {0x1F70, 0x1FBA, 0x1F70},
    {0x1F71, 0x1FBB, 0x1F71}, {0x1F72, 0x1FC8, 0x1F72},
    {0x1F73, 0x1FC9, 0x1F73}, {0x1F74, 0x1FCA, 0x1F74},
    {0x1F75, 0x1FCB, 0x1F75}, {0x1F76, 0x1FDA, 0x1F76},
    {0x1F77, 0x1FDB, 0x1F77}, {0x1F78, 0x1FF8, 0x1F78},
    {0x1F79, 0x1FF9, 0x1F79}, {0x1F7A, 0x1FEA, 0x1F7A},
    {0x1F7B, 0x1FEB, 0x1F7B}, {0x1F7C, 0x1FFA, 0x1F7C},
    {0x1F7D, 0x1FFB, 0x1F7D}, {0x1F80, 0x1F88, 0x1F80},
    {0x1F81, 0x1F89, 0x1F81}, {0x1F82, 0x1F8A, 0x1F82},
    {0x1F83, 0x1F8B, 0x1F83}, {0x1F84, 0x1F8C, 0x1F84},
    {0x1F85, 0x1F8D, 0x1F85}, {0x1F86, 0x1F8E, 0x1F86},
    {0x1F87, 0x1F8F, 0x1F87}, {0x1F88, 0x1F88, 0x1F80},
    {0x1F89, 0x1F89, 0x1F81}, {0x1F8A, 0x1F8A, 0x1F82},
    {0x1F8B, 0x1F8B, 0x1F83}, {0x1F8C, 0x1F8C, 0x1F84},
    {0x1F8D, 0x1F8D, 0x1F85}, {0x1F8E, 0x1F8E, 0x1F86},
    {0x1F8F, 0x1F8F, 0x1F87}, {0x1F90, 0x1F98, 0x1F90},
    {0x1F91, 0x1F99, 0x1F91}, {0x1F92, 0x1F9A, 0x1F92},
    {0x1F93, 0x1F9B, 0x1F93}, {0x1F94, 0x1F9C, 0x1F94},
    {0x1F95, 0x1F9D, 0x1F95}, {0x1F96, 0x1F9E, 0x1F96},
    {0x1F97, 0x1F9F, 0x1F97}, {0x1F98, 0x1F98, 0x1F90},
    {0x1F99, 0x1F99, 0x1F91}, {0x1F9A, 0x1F9A, 0x1F92},
    {0x1F9B, 0x1F9B, 0x1F93}, {0x1F9C, 0x1F9C, 0x1F94},
    {0x1F9D, 0x1F9D, 0x1F95}, {0x1F9E, 0x1F9E, 0x1F96},
    {0x1F9F, 0x1F9F, 0x1F97}, {0x1FA0, 0x1FA8, 0x1FA0},
    {0x1FA1, 0x1FA9, 0x1FA1}, {0x1FA2, 0x1FAA, 0x1FA2},
    {0x1FA3, 0x1FAB, 0x1FA3}, {0x1FA4, 0x1FAC, 0x1FA4},
    {0x1FA5, 0x1FAD, 0x1FA5}, {0x1FA6, 0x1FAE, 0x1FA6},
    {0x1FA7, 0x1FAF, 0x1FA7}, {0x1FA8, 0x1FA8, 0x1FA0},
    {0x1FA9, 0x1FA9, 0x1FA1}, {0x1FAA, 0x1FAA, 0x1FA2},
    {0x1FAB, 0x1FAB, 0x1FA3}, {0x1FAC, 0x1FAC, 0x1FA4},
    {0x1FAD, 0x1FAD, 0x1FA5}, {0x1FAE, 0x1FAE, 0x1FA6},
    {0x1FAF, 0x1FAF, 0x1FA7}, {0x1FB0, 0x1FB8, 0x1FB0},
    {0x1FB1, 0x1FB9, 0x1FB1}, {0x1FB2, 0x1FB2, 0x1FB2},
    {0x1FB3, 0x1FBC, 0x1FB3}, {0x1FB4, 0x1FB4, 0x1FB4},
    {0x1FB6, 0x1FB6, 0x1FB6}, {0x1FB7, 0x1FB7, 0x1FB7},
    {0x1FB8, 0x1FB8, 0x1FB0}, {0x1FB9, 0x1FB9, 0x1FB1},
    {0x1FBA, 0x1FBA, 0x1F70}, {0x1FBB, 0x1FBB, 0x1F71},
    {0x1FBC, 0x1FBC, 0x1FB3}, {0x1FBE, 0x0399, 0x1FBE},
    {0x1FC2, 0x1FC2, 0x1FC2}, {0x1FC3, 0x1FCC, 0x1FC3},
    {0x1FC4, 0x1FC4, 0x1FC4}, {0x1FC6, 0x1FC6, 0x1FC6},
    {0x1FC7, 0x1FC7, 0x1FC7}, {0x1FC8, 0x1FC8, 0x1F72},
    {0x1FC9, 0x1FC9, 0x1F73}, {0x1FCA, 0x1FCA, 0x1F74},
    {0x1FCB, 0x1FCB, 0x1F75}, {0x1FCC, 0x1FCC, 0x1FC3},
    {0x1FD0, 0x1FD8, 0x1FD0}, {0x1FD1, 0x1FD9, 0x1FD1},
    {0x1FD2, 0x1FD2, 0x1FD2}, {0x1FD3, 0x1FD3, 0x1FD3},
    {0x1FD6, 0x1FD6, 0x1FD6}, {0x1FD7, 0x1FD7, 0x1FD7},
    {0x1FD8, 0x1FD8, 0x1FD0}, {0x1FD9, 0x1FD9, 0x1FD1},
    {0x1FDA, 0x1FDA, 0x1F76}, {0x1FDB, 0x1FDB, 0x1F77},
    {0x1FE0, 0x1FE8, 0x1FE0}, {0x1FE1, 0x1FE9, 0x1FE1},
    {0x1FE2, 0x1FE2, 0x1FE2}, {0x1FE3, 0x1FE3, 0x1FE3},
    {0x1FE4, 0x1FE4, 0x1FE4}, {0x1FE5, 0x1FEC, 0x1FE5},
    {0x1FE6, 0x1FE6, 0x1FE6}, {0x1FE7, 0x1FE7, 0x1FE7},
    {0x1FE8, 0x1FE8, 0x1FE0}, {0x1FE9, 0x1FE9, 0x1FE1},
    {0x1FEA, 0x1FEA, 0x1F7A}, {0x1FEB, 0x1FEB, 0x1F7B},
    {0x1FEC, 0x1FEC, 0x1FE5}, {0x1FF2, 0x1FF2, 0x1FF2},
    {0x1FF3, 0x1FFC, 0x1FF3}, {0x1FF4, 0x1FF4, 0x1FF4},
    {0x1FF6, 0x1FF6, 0x1FF6}, {0x1FF7, 0x1FF7, 0x1FF7},
    {0x1FF8, 0x1FF8, 0x1F78}, {0x1FF9, 0x1FF9, 0x1F79},
    {0x1FFA, 0x1FFA, 0x1F7C}, {0x1FFB, 0x1FFB, 0x1F7D},
    {0x1FFC, 0x1FFC, 0x1FF3}, {0x2071, 0x2071, 0x2071},
    {0x207F, 0x207F, 0x207F}, {0x2090, 0x2090, 0x2090},
    {0x2091, 0x2091, 0x2091}, {0x2092, 0x2092, 0x2092},
    {0x2093, 0x2093, 0x2093}, {0x2094, 0x2094, 0x2094},
    {0x20D0, 0x20D0, 0x20D0}, {0x20D1, 0x20D1, 0x20D1},
    {0x20D2, 0x20D2, 0x20D2}, {0x20D3, 0x20D3, 0x20D3},
    {0x20D4, 0x20D4, 0x20D4}, {0x20D5, 0x20D5, 0x20D5},
    {0x20D6, 0x20D6, 0x20D6}, {0x20D7, 0x20D7, 0x20D7},
    {0x20D8, 0x20D8, 0x20D8}, {0x20D9, 0x20D9, 0x20D9},
    {0x20DA, 0x20DA, 0x20DA}, {0x20DB, 0x20DB, 0x20DB},
    {0x20DC, 0x20DC, 0x20DC}, {0x20E1, 0x20E1, 0x20E1},
    {0x20E5, 0x20E5, 0x20E5}, {0x20E6, 0x20E6, 0x20E6},
    {0x20E7, 0x20E7, 0x20E7}, {0x20E8, 0x20E8, 0x20E8},
    {0x20E9, 0x20E9, 0x20E9}, {0x20EA, 0x20EA, 0x20EA},
    {0x20EB, 0x20EB, 0x20EB}, {0x2102, 0x2102, 0x2102},
    {0x2107, 0x2107, 0x2107}, {0x210A, 0x210A, 0x210A},
    {0x210B, 0x210B, 0x210B}, {0x210C, 0x210C, 0x210C},
    {0x210D, 0x210D, 0x210D}, {0x210E, 0x210E, 0x210E},
    {0x210F, 0x210F, 0x210F}, {0x2110, 0x2110, 0x2110},
    {0x2111, 0x2111, 0x2111}, {0x2112, 0x2112, 0x2112},
    {0x2113, 0x2113, 0x2113}, {0x2115, 0x2115, 0x2115},
    {0x2119, 0x2119, 0x2119}, {0x211A, 0x211A, 0x211A},
    {0x211B, 0x211B, 0x211B}, {0x211C, 0x211C, 0x211C},
    {0x211D, 0x211D, 0x211D}, {0x2124, 0x2124, 0x2124},
    {0x2126, 0x2126, 0x03C9}, {0x2128, 0x2128, 0x2128},
    {0x212A, 0x212A, 0x006B}, {0x212B, 0x212B, 0x00E5},
    {0x212C, 0x212C, 0x212C}, {0x212D, 0x212D, 0x212D},
    {0x212F, 0x212F, 0x212F}, {0x2130, 0x2130, 0x2130},
    {0x2131, 0x2131, 0x2131}, {0x2133, 0x2133, 0x2133},
    {0x2134, 0x2134, 0x2134}, {0x2135, 0x2135, 0x2135},
    {0x2136, 0x2136, 0x2136}, {0x2137, 0x2137, 0x2137},
    {0x2138, 0x2138, 0x2138}, {0x2139, 0x2139, 0x2139},
    {0x213C, 0x213C, 0x213C}, {0x213D, 0x213D, 0x213D},
    {0x213E, 0x213E, 0x213E}, {0x213F, 0x213F, 0x213F},
    {0x2145, 0x2145, 0x2145}, {0x2146, 0x2146, 0x2146},
    {0x2147, 0x2147, 0x2147}, {0x2148, 0x2148, 0x2148},
    {0x2149, 0x2149, 0x2149}, {0x2C00, 0x2C00, 0x2C30},
    {0x2C01, 0x2C01, 0x2C31}, {0x2C02, 0x2C02, 0x2C32},
    {0x2C03, 0x2C03, 0x2C33}, {0x2C04, 0x2C04, 0x2C34},
    {0x2C05, 0x2C05, 0x2C35}, {0x2C06, 0x2C06, 0x2C36},
    {0x2C07, 0x2C07, 0x2C37}, {0x2C08, 0x2C08, 0x2C38},
    {0x2C09, 0x2C09, 0x2C39}, {0x2C0A, 0x2C0A, 0x2C3A},
    {0x2C0B, 0x2C0B, 0x2C3B}, {0x2C0C, 0x2C0C, 0x2C3C},
    {0x2C0D, 0x2C0D, 0x2C3D}, {0x2C0E, 0x2C0E, 0x2C3E},
    {0x2C0F, 0x2C0F, 0x2C3F}, {0x2C10, 0x2C10, 0x2C40},
    {0x2C11, 0x2C11, 0x2C41}, {0x2C12, 0x2C12, 0x2C42},
    {0x2C13, 0x2C13, 0x2C43}, {0x2C14, 0x2C14, 0x2C44},
    {0x2C15, 0x2C15, 0x2C45}, {0x2C16, 0x2C16, 0x2C46},
    {0x2C17, 0x2C17, 0x2C47}, {0x2C18, 0x2C18, 0x2C48},
    {0x2C19, 0x2C19, 0x2C49}, {0x2C1A, 0x2C1A, 0x2C4A},
    {0x2C1B, 0x2C1B, 0x2C4B}, {0x2C1C, 0x2C1C, 0x2C4C},
    {0x2C1D, 0x2C1D, 0x2C4D}, {0x2C1E, 0x2C1E, 0x2C4E},
    {0x2C1F, 0x2C1F, 0x2C4F}, {0x2C20, 0x2C20, 0x2C50},
    {0x2C21, 0x2C21, 0x2C51}, {0x2C22, 0x2C22, 0x2C52},
    {0x2C23, 0x2C23, 0x2C53}, {0x2C24, 0x2C24, 0x2C54},
    {0x2C25, 0x2C25, 0x2C55}, {0x2C26, 0x2C26, 0x2C56},
    {0x2C27, 0x2C27, 0x2C57}, {0x2C28, 0x2C28, 0x2C58},
    {0x2C29, 0x2C29, 0x2C59}, {0x2C2A, 0x2C2A, 0x2C5A},
    {0x2C2B, 0x2C2B, 0x2C5B}, {0x2C2C, 0x2C2C, 0x2C5C},
    {0x2C2D, 0x2C2D, 0x2C5D}, {0x2C2E, 0x2C2E, 0x2C5E},
    {0x2C30, 0x2C00, 0x2C30}, {0x2C31, 0x2C01, 0x2C31},
    {0x2C32, 0x2C02, 0x2C32}, {0x2C33, 0x2C03, 0x2C33},
    {0x2C34, 0x2C04, 0x2C34}, {0x2C35, 0x2C05, 0x2C35},
    {0x2C36, 0x2C06, 0x2C36}, {0x2C37, 0x2C07, 0x2C37},
    {0x2C38, 0x2C08, 0x2C38}, {0x2C39, 0x2C09, 0x2C39},
    {0x2C3A, 0x2C0A, 0x2C3A}, {0x2C3B, 0x2C0B, 0x2C3B},
    {0x2C3C, 0x2C0C, 0x2C3C}, {0x2C3D, 0x2C0D, 0x2C3D},
    {0x2C3E, 0x2C0E, 0x2C3E}, {0x2C3F, 0x2C0F, 0x2C3F},
    {0x2C40, 0x2C10, 0x2C40}, {0x2C41, 0x2C11, 0x2C41},
    {0x2C42, 0x2C12, 0x2C42}, {0x2C43, 0x2C13, 0x2C43},
    {0x2C44, 0x2C14, 0x2C44}, {0x2C45, 0x2C15, 0x2C45},
    {0x2C46, 0x2C16, 0x2C46}, {0x2C47, 0x2C17, 0x2C47},
    {0x2C48, 0x2C18, 0x2C48}, {0x2C49, 0x2C19, 0x2C49},
    {0x2C4A, 0x2C1A, 0x2C4A}, {0x2C4B, 0x2C1B, 0x2C4B},
    {0x2C4C, 0x2C1C, 0x2C4C}, {0x2C4D, 0x2C1D, 0x2C4D},
    {0x2C4E, 0x2C1E, 0x2C4E}, {0x2C4F, 0x2C1F, 0x2C4F},
    {0x2C50, 0x2C20, 0x2C50}, {0x2C51, 0x2C21, 0x2C51},
    {0x2C52, 0x2C22, 0x2C52}, {0x2C53, 0x2C23, 0x2C53},
    {0x2C54, 0x2C24, 0x2C54}, {0x2C55, 0x2C25, 0x2C55},
    {0x2C56, 0x2C26, 0x2C56}, {0x2C57, 0x2C27, 0x2C57},
    {0x2C58, 0x2C28, 0x2C58}, {0x2C59, 0x2C29, 0x2C59},
    {0x2C5A, 0x2C2A, 0x2C5A}, {0x2C5B, 0x2C2B, 0x2C5B},
    {0x2C5C, 0x2C2C, 0x2C5C}, {0x2C5D, 0x2C2D, 0x2C5D},
    {0x2C5E, 0x2C2E, 0x2C5E}, {0x2C80, 0x2C80, 0x2C81},
    {0x2C81, 0x2C80, 0x2C81}, {0x2C82, 0x2C82, 0x2C83},
    {0x2C83, 0x2C82, 0x2C83}, {0x2C84, 0x2C84, 0x2C85},
    {0x2C85, 0x2C84, 0x2C85}, {0x2C86, 0x2C86, 0x2C87},
    {0x2C87, 0x2C86, 0x2C87}, {0x2C88, 0x2C88, 0x2C89},
    {0x2C89, 0x2C88, 0x2C89}, {0x2C8A, 0x2C8A, 0x2C8B},
    {0x2C8B, 0x2C8A, 0x2C8B}, {0x2C8C, 0x2C8C, 0x2C8D},
    {0x2C8D, 0x2C8C, 0x2C8D}, {0x2C8E, 0x2C8E, 0x2C8F},
    {0x2C8F, 0x2C8E, 0x2C8F}, {0x2C90, 0x2C90, 0x2C91},
    {0x2C91, 0x2C90, 0x2C91}, {0x2C92, 0x2C92, 0x2C93},
    {0x2C93, 0x2C92, 0x2C93}, {0x2C94, 0x2C94, 0x2C95},
    {0x2C95, 0x2C94, 0x2C95}, {0x2C96, 0x2C96, 0x2C97},
    {0x2C97, 0x2C96, 0x2C97}, {0x2C98, 0x2C98, 0x2C99},
    {0x2C99, 0x2C98, 0x2C99}, {0x2C9A, 0x2C9A, 0x2C9B},
    {0x2C9B, 0x2C9A, 0x2C9B}, {0x2C9C, 0x2C9C, 0x2C9D},
    {0x2C9D, 0x2C9C, 0x2C9D}, {0x2C9E, 0x2C9E, 0x2C9F},
    {0x2C9F, 0x2C9E, 0x2C9F}, {0x2CA0, 0x2CA0, 0x2CA1},
    {0x2CA1, 0x2CA0, 0x2CA1}, {0x2CA2, 0x2CA2, 0x2CA3},
    {0x2CA3, 0x2CA2, 0x2CA3}, {0x2CA4, 0x2CA4, 0x2CA5},
    {0x2CA5, 0x2CA4, 0x2CA5}, {0x2CA6, 0x2CA6, 0x2CA7},
    {0x2CA7, 0x2CA6, 0x2CA7}, {0x2CA8, 0x2CA8, 0x2CA9},
    {0x2CA9, 0x2CA8, 0x2CA9}, {0x2CAA, 0x2CAA, 0x2CAB},
    {0x2CAB, 0x2CAA, 0x2CAB}, {0x2CAC, 0x2CAC, 0x2CAD},
    {0x2CAD, 0x2CAC, 0x2CAD}, {0x2CAE, 0x2CAE, 0x2CAF},
    {0x2CAF, 0x2CAE, 0x2CAF}, {0x2CB0, 0x2CB0, 0x2CB1},
    {0x2CB1, 0x2CB0, 0x2CB1}, {0x2CB2, 0x2CB2, 0x2CB3},
    {0x2CB3, 0x2CB2, 0x2CB3}, {0x2CB4, 0x2CB4, 0x2CB5},
    {0x2CB5, 0x2CB4, 0x2CB5}, {0x2CB6, 0x2CB6, 0x2CB7},
    {0x2CB7, 0x2CB6, 0x2CB7}, {0x2CB8, 0x2CB8, 0x2CB9},
    {0x2CB9, 0x2CB8, 0x2CB9}, {0x2CBA, 0x2CBA, 0x2CBB},
    {0x2CBB, 0x2CBA, 0x2CBB}, {0x2CBC, 0x2CBC, 0x2CBD},
    {0x2CBD, 0x2CBC, 0x2CBD}, {0x2CBE, 0x2CBE, 0x2CBF},
    {0x2CBF, 0x2CBE, 0x2CBF}, {0x2CC0, 0x2CC0, 0x2CC1},
    {0x2CC1, 0x2CC0, 0x2CC1}, {0x2CC2, 0x2CC2, 0x2CC3},
    {0x2CC3, 0x2CC2, 0x2CC3}, {0x2CC4, 0x2CC4, 0x2CC5},
    {0x2CC5, 0x2CC4, 0x2CC5}, {0x2CC6, 0x2CC6, 0x2CC7},
    {0x2CC7, 0x2CC6, 0x2CC7}, {0x2CC8, 0x2CC8, 0x2CC9},
    {0x2CC9, 0x2CC8, 0x2CC9}, {0x2CCA, 0x2CCA, 0x2CCB},
    {0x2CCB, 0x2CCA, 0x2CCB}, {0x2CCC, 0x2CCC, 0x2CCD},
    {0x2CCD, 0x2CCC, 0x2CCD}, {0x2CCE, 0x2CCE, 0x2CCF},
    {0x2CCF, 0x2CCE, 0x2CCF}, {0x2CD0, 0x2CD0, 0x2CD1},
    {0x2CD1, 0x2CD0, 0x2CD1}, {0x2CD2, 0x2CD2, 0x2CD3},
    {0x2CD3, 0x2CD2, 0x2CD3}, {0x2CD4, 0x2CD4, 0x2CD5},
    {0x2CD5, 0x2CD4, 0x2CD5}, {0x2CD6, 0x2CD6, 0x2CD7},
    {0x2CD7, 0x2CD6, 0x2CD7}, {0x2CD8, 0x2CD8, 0x2CD9},
    {0x2CD9, 0x2CD8, 0x2CD9}, {0x2CDA, 0x2CDA, 0x2CDB},
    {0x2CDB, 0x2CDA, 0x2CDB}, {0x2CDC, 0x2CDC, 0x2CDD},
    {0x2CDD, 0x2CDC, 0x2CDD}, {0x2CDE, 0x2CDE, 0x2CDF},
    {0x2CDF, 0x2CDE, 0x2CDF}, {0x2CE0, 0x2CE0, 0x2CE1},
    {0x2CE1, 0x2CE0, 0x2CE1}, {0x2CE2, 0x2CE2, 0x2CE3},
    {0x2CE3, 0x2CE2, 0x2CE3}, {0x2CE4, 0x2CE4, 0x2CE4},
    {0x2D00, 0x10A0, 0x2D00}, {0x2D01, 0x10A1, 0x2D01},
    {0x2D02, 0x10A2, 0x2D02}, {0x2D03, 0x10A3, 0x2D03},
    {0x2D04, 0x10A4, 0x2D04}, {0x2D05, 0x10A5, 0x2D05},
    {0x2D06, 0x10A6, 0x2D06}, {0x2D07, 0x10A7, 0x2D07},
    {0x2D08, 0x10A8, 0x2D08}, {0x2D09, 0x10A9, 0x2D09},
    {0x2D0A, 0x10AA, 0x2D0A}, {0x2D0B, 0x10AB, 0x2D0B},
    {0x2D0C, 0x10AC, 0x2D0C}, {0x2D0D, 0x10AD, 0x2D0D},
    {0x2D0E, 0x10AE, 0x2D0E}, {0x2D0F, 0x10AF, 0x2D0F},
    {0x2D10, 0x10B0, 0x2D10}, {0x2D11, 0x10B1, 0x2D11},
    {0x2D12, 0x10B2, 0x2D12}, {0x2D13, 0x10B3, 0x2D13},
    {0x2D14, 0x10B4, 0x2D14}, {0x2D15, 0x10B5, 0x2D15},
    {0x2D16, 0x10B6, 0x2D16}, {0x2D17, 0x10B7, 0x2D17},
    {0x2D18, 0x10B8, 0x2D18}, {0x2D19, 0x10B9, 0x2D19},
    {0x2D1A, 0x10BA, 0x2D1A}, {0x2D1B, 0x10BB, 0x2D1B},
    {0x2D1C, 0x10BC, 0x2D1C}, {0x2D1D, 0x10BD, 0x2D1D},
    {0x2D1E, 0x10BE, 0x2D1E}, {0x2D1F, 0x10BF, 0x2D1F},
    {0x2D20, 0x10C0, 0x2D20}, {0x2D21, 0x10C1, 0x2D21},
    {0x2D22, 0x10C2, 0x2D22}, {0x2D23, 0x10C3, 0x2D23},
    {0x2D24, 0x10C4, 0x2D24}, {0x2D25, 0x10C5, 0x2D25},
    {0x2D30, 0x2D30, 0x2D30}, {0x2D31, 0x2D31, 0x2D31},
    {0x2D32, 0x2D32, 0x2D32}, {0x2D33, 0x2D33, 0x2D33},
    {0x2D34, 0x2D34, 0x2D34}, {0x2D35, 0x2D35, 0x2D35},
    {0x2D36, 0x2D36, 0x2D36}, {0x2D37, 0x2D37, 0x2D37},
    {0x2D38, 0x2D38, 0x2D38}, {0x2D39, 0x2D39, 0x2D39},
    {0x2D3A, 0x2D3A, 0x2D3A}, {0x2D3B, 0x2D3B, 0x2D3B},
    {0x2D3C, 0x2D3C, 0x2D3C}, {0x2D3D, 0x2D3D, 0x2D3D},
    {0x2D3E, 0x2D3E, 0x2D3E}, {0x2D3F, 0x2D3F, 0x2D3F},
    {0x2D40, 0x2D40, 0x2D40}, {0x2D41, 0x2D41, 0x2D41},
    {0x2D42, 0x2D42, 0x2D42}, {0x2D43, 0x2D43, 0x2D43},
    {0x2D44, 0x2D44, 0x2D44}, {0x2D45, 0x2D45, 0x2D45},
    {0x2D46, 0x2D46, 0x2D46}, {0x2D47, 0x2D47, 0x2D47},
    {0x2D48, 0x2D48, 0x2D48}, {0x2D49, 0x2D49, 0x2D49},
    {0x2D4A, 0x2D4A, 0x2D4A}, {0x2D4B, 0x2D4B, 0x2D4B},
    {0x2D4C, 0x2D4C, 0x2D4C}, {0x2D4D, 0x2D4D, 0x2D4D},
    {0x2D4E, 0x2D4E, 0x2D4E}, {0x2D4F, 0x2D4F, 0x2D4F},
    {0x2D50, 0x2D50, 0x2D50}, {0x2D51, 0x2D51, 0x2D51},
    {0x2D52, 0x2D52, 0x2D52}, {0x2D53, 0x2D53, 0x2D53},
    {0x2D54, 0x2D54, 0x2D54}, {0x2D55, 0x2D55, 0x2D55},
    {0x2D56, 0x2D56, 0x2D56}, {0x2D57, 0x2D57, 0x2D57},
    {0x2D58, 0x2D58, 0x2D58}, {0x2D59, 0x2D59, 0x2D59},
    {0x2D5A, 0x2D5A, 0x2D5A}, {0x2D5B, 0x2D5B, 0x2D5B},
    {0x2D5C, 0x2D5C, 0x2D5C}, {0x2D5D, 0x2D5D, 0x2D5D},
    {0x2D5E, 0x2D5E, 0x2D5E}, {0x2D5F, 0x2D5F, 0x2D5F},
    {0x2D60, 0x2D60, 0x2D60}, {0x2D61, 0x2D61, 0x2D61},
    {0x2D62, 0x2D62, 0x2D62}, {0x2D63, 0x2D63, 0x2D63},
    {0x2D64, 0x2D64, 0x2D64}, {0x2D65, 0x2D65, 0x2D65},
    {0x2D6F, 0x2D6F, 0x2D6F}, {0x2D80, 0x2D80, 0x2D80},
    {0x2D81, 0x2D81, 0x2D81}, {0x2D82, 0x2D82, 0x2D82},
    {0x2D83, 0x2D83, 0x2D83}, {0x2D84, 0x2D84, 0x2D84},
    {0x2D85, 0x2D85, 0x2D85}, {0x2D86, 0x2D86, 0x2D86},
    {0x2D87, 0x2D87, 0x2D87}, {0x2D88, 0x2D88, 0x2D88},
    {0x2D89, 0x2D89, 0x2D89}, {0x2D8A, 0x2D8A, 0x2D8A},
    {0x2D8B, 0x2D8B, 0x2D8B}, {0x2D8C, 0x2D8C, 0x2D8C},
    {0x2D8D, 0x2D8D, 0x2D8D}, {0x2D8E, 0x2D8E, 0x2D8E},
    {0x2D8F, 0x2D8F, 0x2D8F}, {0x2D90, 0x2D90, 0x2D90},
    {0x2D91, 0x2D91, 0x2D91}, {0x2D92, 0x2D92, 0x2D92},
    {0x2D93, 0x2D93, 0x2D93}, {0x2D94, 0x2D94, 0x2D94},
    {0x2D95, 0x2D95, 0x2D95}, {0x2D96, 0x2D96, 0x2D96},
    {0x2DA0, 0x2DA0, 0x2DA0}, {0x2DA1, 0x2DA1, 0x2DA1},
    {0x2DA2, 0x2DA2, 0x2DA2}, {0x2DA3, 0x2DA3, 0x2DA3},
    {0x2DA4, 0x2DA4, 0x2DA4}, {0x2DA5, 0x2DA5, 0x2DA5},
    {0x2DA6, 0x2DA6, 0x2DA6}, {0x2DA8, 0x2DA8, 0x2DA8},
    {0x2DA9, 0x2DA9, 0x2DA9}, {0x2DAA, 0x2DAA, 0x2DAA},
    {0x2DAB, 0x2DAB, 0x2DAB}, {0x2DAC, 0x2DAC, 0x2DAC},
    {0x2DAD, 0x2DAD, 0x2DAD}, {0x2DAE, 0x2DAE, 0x2DAE},
    {0x2DB0, 0x2DB0, 0x2DB0}, {0x2DB1, 0x2DB1, 0x2DB1},
    {0x2DB2, 0x2DB2, 0x2DB2}, {0x2DB3, 0x2DB3, 0x2DB3},
    {0x2DB4, 0x2DB4, 0x2DB4}, {0x2DB5, 0x2DB5, 0x2DB5},
    {0x2DB6, 0x2DB6, 0x2DB6}, {0x2DB8, 0x2DB8, 0x2DB8},
    {0x2DB9, 0x2DB9, 0x2DB9}, {0x2DBA, 0x2DBA, 0x2DBA},
    {0x2DBB, 0x2DBB, 0x2DBB}, {0x2DBC, 0x2DBC, 0x2DBC},
    {0x2DBD, 0x2DBD, 0x2DBD}, {0x2DBE, 0x2DBE, 0x2DBE},
    {0x2DC0, 0x2DC0, 0x2DC0}, {0x2DC1, 0x2DC1, 0x2DC1},
    {0x2DC2, 0x2DC2, 0x2DC2}, {0x2DC3, 0x2DC3, 0x2DC3},
    {0x2DC4, 0x2DC4, 0x2DC4}, {0x2DC5, 0x2DC5, 0x2DC5},
    {0x2DC6, 0x2DC6, 0x2DC6}, {0x2DC8, 0x2DC8, 0x2DC8},
    {0x2DC9, 0x2DC9, 0x2DC9}, {0x2DCA, 0x2DCA, 0x2DCA},
    {0x2DCB, 0x2DCB, 0x2DCB}, {0x2DCC, 0x2DCC, 0x2DCC},
    {0x2DCD, 0x2DCD, 0x2DCD}, {0x2DCE, 0x2DCE, 0x2DCE},
    {0x2DD0, 0x2DD0, 0x2DD0}, {0x2DD1, 0x2DD1, 0x2DD1},
    {0x2DD2, 0x2DD2, 0x2DD2}, {0x2DD3, 0x2DD3, 0x2DD3},
    {0x2DD4, 0x2DD4, 0x2DD4}, {0x2DD5, 0x2DD5, 0x2DD5},
    {0x2DD6, 0x2DD6, 0x2DD6}, {0x2DD8, 0x2DD8, 0x2DD8},
    {0x2DD9, 0x2DD9, 0x2DD9}, {0x2DDA, 0x2DDA, 0x2DDA},
    {0x2DDB, 0x2DDB, 0x2DDB}, {0x2DDC, 0x2DDC, 0x2DDC},
    {0x2DDD, 0x2DDD, 0x2DDD}, {0x2DDE, 0x2DDE, 0x2DDE},
    {0x3005, 0x3005, 0x3005}, {0x3006, 0x3006, 0x3006},
    {0x302A, 0x302A, 0x302A}, {0x302B, 0x302B, 0x302B},
    {0x302C, 0x302C, 0x302C}, {0x302D, 0x302D, 0x302D},
    {0x302E, 0x302E, 0x302E}, {0x302F, 0x302F, 0x302F},
    {0x3031, 0x3031, 0x3031}, {0x3032, 0x3032, 0x3032},
    {0x3033, 0x3033, 0x3033}, {0x3034, 0x3034, 0x3034},
    {0x3035, 0x3035, 0x3035}, {0x303B, 0x303B, 0x303B},
    {0x303C, 0x303C, 0x303C}, {0x3041, 0x3041, 0x3041},
    {0x3042, 0x3042, 0x3042}, {0x3043, 0x3043, 0x3043},
    {0x3044, 0x3044, 0x3044}, {0x3045, 0x3045, 0x3045},
    {0x3046, 0x3046, 0x3046}, {0x3047, 0x3047, 0x3047},
    {0x3048, 0x3048, 0x3048}, {0x3049, 0x3049, 0x3049},
    {0x304A, 0x304A, 0x304A}, {0x304B, 0x304B, 0x304B},
    {0x304C, 0x304C, 0x304C}, {0x304D, 0x304D, 0x304D},
    {0x304E, 0x304E, 0x304E}, {0x304F, 0x304F, 0x304F},
    {0x3050, 0x3050, 0x3050}, {0x3051, 0x3051, 0x3051},
    {0x3052, 0x3052, 0x3052}, {0x3053, 0x3053, 0x3053},
    {0x3054, 0x3054, 0x3054}, {0x3055, 0x3055, 0x3055},
    {0x3056, 0x3056, 0x3056}, {0x3057, 0x3057, 0x3057},
    {0x3058, 0x3058, 0x3058}, {0x3059, 0x3059, 0x3059},
    {0x305A, 0x305A, 0x305A}, {0x305B, 0x305B, 0x305B},
    {0x305C, 0x305C, 0x305C}, {0x305D, 0x305D, 0x305D},
    {0x305E, 0x305E, 0x305E}, {0x305F, 0x305F, 0x305F},
    {0x3060, 0x3060, 0x3060}, {0x3061, 0x3061, 0x3061},
    {0x3062, 0x3062, 0x3062}, {0x3063, 0x3063, 0x3063},
    {0x3064, 0x3064, 0x3064}, {0x3065, 0x3065, 0x3065},
    {0x3066, 0x3066, 0x3066}, {0x3067, 0x3067, 0x3067},
    {0x3068, 0x3068, 0x3068}, {0x3069, 0x3069, 0x3069},
    {0x306A, 0x306A, 0x306A}, {0x306B, 0x306B, 0x306B},
    {0x306C, 0x306C, 0x306C}, {0x306D, 0x306D, 0x306D},
    {0x306E, 0x306E, 0x306E}, {0x306F, 0x306F, 0x306F},
    {0x3070, 0x3070, 0x3070}, {0x3071, 0x3071, 0x3071},
    {0x3072, 0x3072, 0x3072}, {0x3073, 0x3073, 0x3073},
    {0x3074, 0x3074, 0x3074}, {0x3075, 0x3075, 0x3075},
    {0x3076, 0x3076, 0x3076}, {0x3077, 0x3077, 0x3077},
    {0x3078, 0x3078, 0x3078}, {0x3079, 0x3079, 0x3079},
    {0x307A, 0x307A, 0x307A}, {0x307B, 0x307B, 0x307B},
    {0x307C, 0x307C, 0x307C}, {0x307D, 0x307D, 0x307D},
    {0x307E, 0x307E, 0x307E}, {0x307F, 0x307F, 0x307F},
    {0x3080, 0x3080, 0x3080}, {0x3081, 0x3081, 0x3081},
    {0x3082, 0x3082, 0x3082}, {0x3083, 0x3083, 0x3083},
    {0x3084, 0x3084, 0x3084}, {0x3085, 0x3085, 0x3085},
    {0x3086, 0x3086, 0x3086}, {0x3087, 0x3087, 0x3087},
    {0x3088, 0x3088, 0x3088}, {0x3089, 0x3089, 0x3089},
    {0x308A, 0x308A, 0x308A}, {0x308B, 0x308B, 0x308B},
    {0x308C, 0x308C, 0x308C}, {0x308D, 0x308D, 0x308D},
    {0x308E, 0x308E, 0x308E}, {0x308F, 0x308F, 0x308F},
    {0x3090, 0x3090, 0x3090}, {0x3091, 0x3091, 0x3091},
    {0x3092, 0x3092, 0x3092}, {0x3093, 0x3093, 0x3093},
    {0x3094, 0x3094, 0x3094}, {0x3095, 0x3095, 0x3095},
    {0x3096, 0x3096, 0x3096}, {0x3099, 0x3099, 0x3099},
    {0x309A, 0x309A, 0x309A}, {0x309D, 0x309D, 0x309D},
    {0x309E, 0x309E, 0x309E}, {0x309F, 0x309F, 0x309F},
    {0x30A1, 0x30A1, 0x30A1}, {0x30A2, 0x30A2, 0x30A2},
    {0x30A3, 0x30A3, 0x30A3}, {0x30A4, 0x30A4, 0x30A4},
    {0x30A5, 0x30A5, 0x30A5}, {0x30A6, 0x30A6, 0x30A6},
    {0x30A7, 0x30A7, 0x30A7}, {0x30A8, 0x30A8, 0x30A8},
    {0x30A9, 0x30A9, 0x30A9}, {0x30AA, 0x30AA, 0x30AA},
    {0x30AB, 0x30AB, 0x30AB}, {0x30AC, 0x30AC, 0x30AC},
    {0x30AD, 0x30AD, 0x30AD}, {0x30AE, 0x30AE, 0x30AE},
    {0x30AF, 0x30AF, 0x30AF}, {0x30B0, 0x30B0, 0x30B0},
    {0x30B1, 0x30B1, 0x30B1}, {0x30B2, 0x30B2, 0x30B2},
    {0x30B3, 0x30B3, 0x30B3}, {0x30B4, 0x30B4, 0x30B4},
    {0x30B5, 0x30B5, 0x30B5}, {0x30B6, 0x30B6, 0x30B6},
    {0x30B7, 0x30B7, 0x30B7}, {0x30B8, 0x30B8, 0x30B8},
    {0x30B9, 0x30B9, 0x30B9}, {0x30BA, 0x30BA, 0x30BA},
    {0x30BB, 0x30BB, 0x30BB}, {0x30BC, 0x30BC, 0x30BC},
    {0x30BD, 0x30BD, 0x30BD}, {0x30BE, 0x30BE, 0x30BE},
    {0x30BF, 0x30BF, 0x30BF}, {0x30C0, 0x30C0, 0x30C0},
    {0x30C1, 0x30C1, 0x30C1}, {0x30C2, 0x30C2, 0x30C2},
    {0x30C3, 0x30C3, 0x30C3}, {0x30C4, 0x30C4, 0x30C4},
    {0x30C5, 0x30C5, 0x30C5}, {0x30C6, 0x30C6, 0x30C6},
    {0x30C7, 0x30C7, 0x30C7}, {0x30C8, 0x30C8, 0x30C8},
    {0x30C9, 0x30C9, 0x30C9}, {0x30CA, 0x30CA, 0x30CA},
    {0x30CB, 0x30CB, 0x30CB}, {0x30CC, 0x30CC, 0x30CC},
    {0x30CD, 0x30CD, 0x30CD}, {0x30CE, 0x30CE, 0x30CE},
    {0x30CF, 0x30CF, 0x30CF}, {0x30D0, 0x30D0, 0x30D0},
    {0x30D1, 0x30D1, 0x30D1}, {0x30D2, 0x30D2, 0x30D2},
    {0x30D3, 0x30D3, 0x30D3}, {0x30D4, 0x30D4, 0x30D4},
    {0x30D5, 0x30D5, 0x30D5}, {0x30D6, 0x30D6, 0x30D6},
    {0x30D7, 0x30D7, 0x30D7}, {0x30D8, 0x30D8, 0x30D8},
    {0x30D9, 0x30D9, 0x30D9}, {0x30DA, 0x30DA, 0x30DA},
    {0x30DB, 0x30DB, 0x30DB}, {0x30DC, 0x30DC, 0x30DC},
    {0x30DD, 0x30DD, 0x30DD}, {0x30DE, 0x30DE, 0x30DE},
    {0x30DF, 0x30DF, 0x30DF}, {0x30E0, 0x30E0, 0x30E0},
    {0x30E1, 0x30E1, 0x30E1}, {0x30E2, 0x30E2, 0x30E2},
    {0x30E3, 0x30E3, 0x30E3}, {0x30E4, 0x30E4, 0x30E4},
    {0x30E5, 0x30E5, 0x30E5}, {0x30E6, 0x30E6, 0x30E6},
    {0x30E7, 0x30E7, 0x30E7}, {0x30E8, 0x30E8, 0x30E8},
    {0x30E9, 0x30E9, 0x30E9}, {0x30EA, 0x30EA, 0x30EA},
    {0x30EB, 0x30EB, 0x30EB}, {0x30EC, 0x30EC, 0x30EC},
    {0x30ED, 0x30ED, 0x30ED}, {0x30EE, 0x30EE, 0x30EE},
    {0x30EF, 0x30EF, 0x30EF}, {0x30F0, 0x30F0, 0x30F0},
    {0x30F1, 0x30F1, 0x30F1}, {0x30F2, 0x30F2, 0x30F2},
    {0x30F3, 0x30F3, 0x30F3}, {0x30F4, 0x30F4, 0x30F4},
    {0x30F5, 0x30F5, 0x30F5}, {0x30F6, 0x30F6, 0x30F6},
    {0x30F7, 0x30F7, 0x30F7}, {0x30F8, 0x30F8, 0x30F8},
    {0x30F9, 0x30F9, 0x30F9}, {0x30FA, 0x30FA, 0x30FA},
    {0x30FC, 0x30FC, 0x30FC}, {0x30FD, 0x30FD, 0x30FD},
    {0x30FE, 0x30FE, 0x30FE}, {0x30FF, 0x30FF, 0x30FF},
    {0x3105, 0x3105, 0x3105}, {0x3106, 0x3106, 0x3106},
    {0x3107, 0x3107, 0x3107}, {0x3108, 0x3108, 0x3108},
    {0x3109, 0x3109, 0x3109}, {0x310A, 0x310A, 0x310A},
    {0x310B, 0x310B, 0x310B}, {0x310C, 0x310C, 0x310C},
    {0x310D, 0x310D, 0x310D}, {0x310E, 0x310E, 0x310E},
    {0x310F, 0x310F, 0x310F}, {0x3110, 0x3110, 0x3110},
    {0x3111, 0x3111, 0x3111}, {0x3112, 0x3112, 0x3112},
    {0x3113, 0x3113, 0x3113}, {0x3114, 0x3114, 0x3114},
    {0x3115, 0x3115, 0x3115}, {0x3116, 0x3116, 0x3116},
    {0x3117, 0x3117, 0x3117}, {0x3118, 0x3118, 0x3118},
    {0x3119, 0x3119, 0x3119}, {0x311A, 0x311A, 0x311A},
    {0x311B, 0x311B, 0x311B}, {0x311C, 0x311C, 0x311C},
    {0x311D, 0x311D, 0x311D}, {0x311E, 0x311E, 0x311E},
    {0x311F, 0x311F, 0x311F}, {0x3120, 0x3120, 0x3120},
    {0x3121, 0x3121, 0x3121}, {0x3122, 0x3122, 0x3122},
    {0x3123, 0x3123, 0x3123}, {0x3124, 0x3124, 0x3124},
    {0x3125, 0x3125, 0x3125}, {0x3126, 0x3126, 0x3126},
    {0x3127, 0x3127, 0x3127}, {0x3128, 0x3128, 0x3128},
    {0x3129, 0x3129, 0x3129}, {0x312A, 0x312A, 0x312A},
    {0x312B, 0x312B, 0x312B}, {0x312C, 0x312C, 0x312C},
    {0x3131, 0x3131, 0x3131}, {0x3132, 0x3132, 0x3132},
    {0x3133, 0x3133, 0x3133}, {0x3134, 0x3134, 0x3134},
    {0x3135, 0x3135, 0x3135}, {0x3136, 0x3136, 0x3136},
    {0x3137, 0x3137, 0x3137}, {0x3138, 0x3138, 0x3138},
    {0x3139, 0x3139, 0x3139}, {0x313A, 0x313A, 0x313A},
    {0x313B, 0x313B, 0x313B}, {0x313C, 0x313C, 0x313C},
    {0x313D, 0x313D, 0x313D}, {0x313E, 0x313E, 0x313E},
    {0x313F, 0x313F, 0x313F}, {0x3140, 0x3140, 0x3140},
    {0x3141, 0x3141, 0x3141}, {0x3142, 0x3142, 0x3142},
    {0x3143, 0x3143, 0x3143}, {0x3144, 0x3144, 0x3144},
    {0x3145, 0x3145, 0x3145}, {0x3146, 0x3146, 0x3146},
    {0x3147, 0x3147, 0x3147}, {0x3148, 0x3148, 0x3148},
    {0x3149, 0x3149, 0x3149}, {0x314A, 0x314A, 0x314A},
    {0x314B, 0x314B, 0x314B}, {0x314C, 0x314C, 0x314C},
    {0x314D, 0x314D, 0x314D}, {0x314E, 0x314E, 0x314E},
    {0x314F, 0x314F, 0x314F}, {0x3150, 0x3150, 0x3150},
    {0x3151, 0x3151, 0x3151}, {0x3152, 0x3152, 0x3152},
    {0x3153, 0x3153, 0x3153}, {0x3154, 0x3154, 0x3154},
    {0x3155, 0x3155, 0x3155}, {0x3156, 0x3156, 0x3156},
    {0x3157, 0x3157, 0x3157}, {0x3158, 0x3158, 0x3158},
    {0x3159, 0x3159, 0x3159}, {0x315A, 0x315A, 0x315A},
    {0x315B, 0x315B, 0x315B}, {0x315C, 0x315C, 0x315C},
    {0x315D, 0x315D, 0x315D}, {0x315E, 0x315E, 0x315E},
    {0x315F, 0x315F, 0x315F}, {0x3160, 0x3160, 0x3160},
    {0x3161, 0x3161, 0x3161}, {0x3162, 0x3162, 0x3162},
    {0x3163, 0x3163, 0x3163}, {0x3164, 0x3164, 0x3164},
    {0x3165, 0x3165, 0x3165}, {0x3166, 0x3166, 0x3166},
    {0x3167, 0x3167, 0x3167}, {0x3168, 0x3168, 0x3168},
    {0x3169, 0x3169, 0x3169}, {0x316A, 0x316A, 0x316A},
    {0x316B, 0x316B, 0x316B}, {0x316C, 0x316C, 0x316C},
    {0x316D, 0x316D, 0x316D}, {0x316E, 0x316E, 0x316E},
    {0x316F, 0x316F, 0x316F}, {0x3170, 0x3170, 0x3170},
    {0x3171, 0x3171, 0x3171}, {0x3172, 0x3172, 0x3172},
    {0x3173, 0x3173, 0x3173}, {0x3174, 0x3174, 0x3174},
    {0x3175, 0x3175, 0x3175}, {0x3176, 0x3176, 0x3176},
    {0x3177, 0x3177, 0x3177}, {0x3178, 0x3178, 0x3178},
    {0x3179, 0x3179, 0x3179}, {0x317A, 0x317A, 0x317A},
    {0x317B, 0x317B, 0x317B}, {0x317C, 0x317C, 0x317C},
    {0x317D, 0x317D, 0x317D}, {0x317E, 0x317E, 0x317E},
    {0x317F, 0x317F, 0x317F}, {0x3180, 0x3180, 0x3180},
    {0x3181, 0x3181, 0x3181}, {0x3182, 0x3182, 0x3182},
    {0x3183, 0x3183, 0x3183}, {0x3184, 0x3184, 0x3184},
    {0x3185, 0x3185, 0x3185}, {0x3186, 0x3186, 0x3186},
    {0x3187, 0x3187, 0x3187}, {0x3188, 0x3188, 0x3188},
    {0x3189, 0x3189, 0x3189}, {0x318A, 0x318A, 0x318A},
    {0x318B, 0x318B, 0x318B}, {0x318C, 0x318C, 0x318C},
    {0x318D, 0x318D, 0x318D}, {0x318E, 0x318E, 0x318E},
    {0x31A0, 0x31A0, 0x31A0}, {0x31A1, 0x31A1, 0x31A1},
    {0x31A2, 0x31A2, 0x31A2}, {0x31A3, 0x31A3, 0x31A3},
    {0x31A4, 0x31A4, 0x31A4}, {0x31A5, 0x31A5, 0x31A5},
    {0x31A6, 0x31A6, 0x31A6}, {0x31A7, 0x31A7, 0x31A7},
    {0x31A8, 0x31A8, 0x31A8}, {0x31A9, 0x31A9, 0x31A9},
    {0x31AA, 0x31AA, 0x31AA}, {0x31AB, 0x31AB, 0x31AB},
    {0x31AC, 0x31AC, 0x31AC}, {0x31AD, 0x31AD, 0x31AD},
    {0x31AE, 0x31AE, 0x31AE}, {0x31AF, 0x31AF, 0x31AF},
    {0x31B0, 0x31B0, 0x31B0}, {0x31B1, 0x31B1, 0x31B1},
    {0x31B2, 0x31B2, 0x31B2}, {0x31B3, 0x31B3, 0x31B3},
    {0x31B4, 0x31B4, 0x31B4}, {0x31B5, 0x31B5, 0x31B5},
    {0x31B6, 0x31B6, 0x31B6}, {0x31B7, 0x31B7, 0x31B7},
    {0x31F0, 0x31F0, 0x31F0}, {0x31F1, 0x31F1, 0x31F1},
    {0x31F2, 0x31F2, 0x31F2}, {0x31F3, 0x31F3, 0x31F3},
    {0x31F4, 0x31F4, 0x31F4}, {0x31F5, 0x31F5, 0x31F5},
    {0x31F6, 0x31F6, 0x31F6}, {0x31F7, 0x31F7, 0x31F7},
    {0x31F8, 0x31F8, 0x31F8}, {0x31F9, 0x31F9, 0x31F9},
    {0x31FA, 0x31FA, 0x31FA}, {0x31FB, 0x31FB, 0x31FB},
    {0x31FC, 0x31FC, 0x31FC}, {0x31FD, 0x31FD, 0x31FD},
    {0x31FE, 0x31FE, 0x31FE}, {0x31FF, 0x31FF, 0x31FF},
    {0x3400, 0x3400, 0x3400}, {0x4DB5, 0x4DB5, 0x4DB5},
    {0x4E00, 0x4E00, 0x4E00}, {0x9FBB, 0x9FBB, 0x9FBB},
    {0xA000, 0xA000, 0xA000}, {0xA001, 0xA001, 0xA001},
    {0xA002, 0xA002, 0xA002}, {0xA003, 0xA003, 0xA003},
    {0xA004, 0xA004, 0xA004}, {0xA005, 0xA005, 0xA005},
    {0xA006, 0xA006, 0xA006}, {0xA007, 0xA007, 0xA007},
    {0xA008, 0xA008, 0xA008}, {0xA009, 0xA009, 0xA009},
    {0xA00A, 0xA00A, 0xA00A}, {0xA00B, 0xA00B, 0xA00B},
    {0xA00C, 0xA00C, 0xA00C}, {0xA00D, 0xA00D, 0xA00D},
    {0xA00E, 0xA00E, 0xA00E}, {0xA00F, 0xA00F, 0xA00F},
    {0xA010, 0xA010, 0xA010}, {0xA011, 0xA011, 0xA011},
    {0xA012, 0xA012, 0xA012}, {0xA013, 0xA013, 0xA013},
    {0xA014, 0xA014, 0xA014}, {0xA015, 0xA015, 0xA015},
    {0xA016, 0xA016, 0xA016}, {0xA017, 0xA017, 0xA017},
    {0xA018, 0xA018, 0xA018}, {0xA019, 0xA019, 0xA019},
    {0xA01A, 0xA01A, 0xA01A}, {0xA01B, 0xA01B, 0xA01B},
    {0xA01C, 0xA01C, 0xA01C}, {0xA01D, 0xA01D, 0xA01D},
    {0xA01E, 0xA01E, 0xA01E}, {0xA01F, 0xA01F, 0xA01F},
    {0xA020, 0xA020, 0xA020}, {0xA021, 0xA021, 0xA021},
    {0xA022, 0xA022, 0xA022}, {0xA023, 0xA023, 0xA023},
    {0xA024, 0xA024, 0xA024}, {0xA025, 0xA025, 0xA025},
    {0xA026, 0xA026, 0xA026}, {0xA027, 0xA027, 0xA027},
    {0xA028, 0xA028, 0xA028}, {0xA029, 0xA029, 0xA029},
    {0xA02A, 0xA02A, 0xA02A}, {0xA02B, 0xA02B, 0xA02B},
    {0xA02C, 0xA02C, 0xA02C}, {0xA02D, 0xA02D, 0xA02D},
    {0xA02E, 0xA02E, 0xA02E}, {0xA02F, 0xA02F, 0xA02F},
    {0xA030, 0xA030, 0xA030}, {0xA031, 0xA031, 0xA031},
    {0xA032, 0xA032, 0xA032}, {0xA033, 0xA033, 0xA033},
    {0xA034, 0xA034, 0xA034}, {0xA035, 0xA035, 0xA035},
    {0xA036, 0xA036, 0xA036}, {0xA037, 0xA037, 0xA037},
    {0xA038, 0xA038, 0xA038}, {0xA039, 0xA039, 0xA039},
    {0xA03A, 0xA03A, 0xA03A}, {0xA03B, 0xA03B, 0xA03B},
    {0xA03C, 0xA03C, 0xA03C}, {0xA03D, 0xA03D, 0xA03D},
    {0xA03E, 0xA03E, 0xA03E}, {0xA03F, 0xA03F, 0xA03F},
    {0xA040, 0xA040, 0xA040}, {0xA041, 0xA041, 0xA041},
    {0xA042, 0xA042, 0xA042}, {0xA043, 0xA043, 0xA043},
    {0xA044, 0xA044, 0xA044}, {0xA045, 0xA045, 0xA045},
    {0xA046, 0xA046, 0xA046}, {0xA047, 0xA047, 0xA047},
    {0xA048, 0xA048, 0xA048}, {0xA049, 0xA049, 0xA049},
    {0xA04A, 0xA04A, 0xA04A}, {0xA04B, 0xA04B, 0xA04B},
    {0xA04C, 0xA04C, 0xA04C}, {0xA04D, 0xA04D, 0xA04D},
    {0xA04E, 0xA04E, 0xA04E}, {0xA04F, 0xA04F, 0xA04F},
    {0xA050, 0xA050, 0xA050}, {0xA051, 0xA051, 0xA051},
    {0xA052, 0xA052, 0xA052}, {0xA053, 0xA053, 0xA053},
    {0xA054, 0xA054, 0xA054}, {0xA055, 0xA055, 0xA055},
    {0xA056, 0xA056, 0xA056}, {0xA057, 0xA057, 0xA057},
    {0xA058, 0xA058, 0xA058}, {0xA059, 0xA059, 0xA059},
    {0xA05A, 0xA05A, 0xA05A}, {0xA05B, 0xA05B, 0xA05B},
    {0xA05C, 0xA05C, 0xA05C}, {0xA05D, 0xA05D, 0xA05D},
    {0xA05E, 0xA05E, 0xA05E}, {0xA05F, 0xA05F, 0xA05F},
    {0xA060, 0xA060, 0xA060}, {0xA061, 0xA061, 0xA061},
    {0xA062, 0xA062, 0xA062}, {0xA063, 0xA063, 0xA063},
    {0xA064, 0xA064, 0xA064}, {0xA065, 0xA065, 0xA065},
    {0xA066, 0xA066, 0xA066}, {0xA067, 0xA067, 0xA067},
    {0xA068, 0xA068, 0xA068}, {0xA069, 0xA069, 0xA069},
    {0xA06A, 0xA06A, 0xA06A}, {0xA06B, 0xA06B, 0xA06B},
    {0xA06C, 0xA06C, 0xA06C}, {0xA06D, 0xA06D, 0xA06D},
    {0xA06E, 0xA06E, 0xA06E}, {0xA06F, 0xA06F, 0xA06F},
    {0xA070, 0xA070, 0xA070}, {0xA071, 0xA071, 0xA071},
    {0xA072, 0xA072, 0xA072}, {0xA073, 0xA073, 0xA073},
    {0xA074, 0xA074, 0xA074}, {0xA075, 0xA075, 0xA075},
    {0xA076, 0xA076, 0xA076}, {0xA077, 0xA077, 0xA077},
    {0xA078, 0xA078, 0xA078}, {0xA079, 0xA079, 0xA079},
    {0xA07A, 0xA07A, 0xA07A}, {0xA07B, 0xA07B, 0xA07B},
    {0xA07C, 0xA07C, 0xA07C}, {0xA07D, 0xA07D, 0xA07D},
    {0xA07E, 0xA07E, 0xA07E}, {0xA07F, 0xA07F, 0xA07F},
    {0xA080, 0xA080, 0xA080}, {0xA081, 0xA081, 0xA081},
    {0xA082, 0xA082, 0xA082}, {0xA083, 0xA083, 0xA083},
    {0xA084, 0xA084, 0xA084}, {0xA085, 0xA085, 0xA085},
    {0xA086, 0xA086, 0xA086}, {0xA087, 0xA087, 0xA087},
    {0xA088, 0xA088, 0xA088}, {0xA089, 0xA089, 0xA089},
    {0xA08A, 0xA08A, 0xA08A}, {0xA08B, 0xA08B, 0xA08B},
    {0xA08C, 0xA08C, 0xA08C}, {0xA08D, 0xA08D, 0xA08D},
    {0xA08E, 0xA08E, 0xA08E}, {0xA08F, 0xA08F, 0xA08F},
    {0xA090, 0xA090, 0xA090}, {0xA091, 0xA091, 0xA091},
    {0xA092, 0xA092, 0xA092}, {0xA093, 0xA093, 0xA093},
    {0xA094, 0xA094, 0xA094}, {0xA095, 0xA095, 0xA095},
    {0xA096, 0xA096, 0xA096}, {0xA097, 0xA097, 0xA097},
    {0xA098, 0xA098, 0xA098}, {0xA099, 0xA099, 0xA099},
    {0xA09A, 0xA09A, 0xA09A}, {0xA09B, 0xA09B, 0xA09B},
    {0xA09C, 0xA09C, 0xA09C}, {0xA09D, 0xA09D, 0xA09D},
    {0xA09E, 0xA09E, 0xA09E}, {0xA09F, 0xA09F, 0xA09F},
    {0xA0A0, 0xA0A0, 0xA0A0}, {0xA0A1, 0xA0A1, 0xA0A1},
    {0xA0A2, 0xA0A2, 0xA0A2}, {0xA0A3, 0xA0A3, 0xA0A3},
    {0xA0A4, 0xA0A4, 0xA0A4}, {0xA0A5, 0xA0A5, 0xA0A5},
    {0xA0A6, 0xA0A6, 0xA0A6}, {0xA0A7, 0xA0A7, 0xA0A7},
    {0xA0A8, 0xA0A8, 0xA0A8}, {0xA0A9, 0xA0A9, 0xA0A9},
    {0xA0AA, 0xA0AA, 0xA0AA}, {0xA0AB, 0xA0AB, 0xA0AB},
    {0xA0AC, 0xA0AC, 0xA0AC}, {0xA0AD, 0xA0AD, 0xA0AD},
    {0xA0AE, 0xA0AE, 0xA0AE}, {0xA0AF, 0xA0AF, 0xA0AF},
    {0xA0B0, 0xA0B0, 0xA0B0}, {0xA0B1, 0xA0B1, 0xA0B1},
    {0xA0B2, 0xA0B2, 0xA0B2}, {0xA0B3, 0xA0B3, 0xA0B3},
    {0xA0B4, 0xA0B4, 0xA0B4}, {0xA0B5, 0xA0B5, 0xA0B5},
    {0xA0B6, 0xA0B6, 0xA0B6}, {0xA0B7, 0xA0B7, 0xA0B7},
    {0xA0B8, 0xA0B8, 0xA0B8}, {0xA0B9, 0xA0B9, 0xA0B9},
    {0xA0BA, 0xA0BA, 0xA0BA}, {0xA0BB, 0xA0BB, 0xA0BB},
    {0xA0BC, 0xA0BC, 0xA0BC}, {0xA0BD, 0xA0BD, 0xA0BD},
    {0xA0BE, 0xA0BE, 0xA0BE}, {0xA0BF, 0xA0BF, 0xA0BF},
    {0xA0C0, 0xA0C0, 0xA0C0}, {0xA0C1, 0xA0C1, 0xA0C1},
    {0xA0C2, 0xA0C2, 0xA0C2}, {0xA0C3, 0xA0C3, 0xA0C3},
    {0xA0C4, 0xA0C4, 0xA0C4}, {0xA0C5, 0xA0C5, 0xA0C5},
    {0xA0C6, 0xA0C6, 0xA0C6}, {0xA0C7, 0xA0C7, 0xA0C7},
    {0xA0C8, 0xA0C8, 0xA0C8}, {0xA0C9, 0xA0C9, 0xA0C9},
    {0xA0CA, 0xA0CA, 0xA0CA}, {0xA0CB, 0xA0CB, 0xA0CB},
    {0xA0CC, 0xA0CC, 0xA0CC}, {0xA0CD, 0xA0CD, 0xA0CD},
    {0xA0CE, 0xA0CE, 0xA0CE}, {0xA0CF, 0xA0CF, 0xA0CF},
    {0xA0D0, 0xA0D0, 0xA0D0}, {0xA0D1, 0xA0D1, 0xA0D1},
    {0xA0D2, 0xA0D2, 0xA0D2}, {0xA0D3, 0xA0D3, 0xA0D3},
    {0xA0D4, 0xA0D4, 0xA0D4}, {0xA0D5, 0xA0D5, 0xA0D5},
    {0xA0D6, 0xA0D6, 0xA0D6}, {0xA0D7, 0xA0D7, 0xA0D7},
    {0xA0D8, 0xA0D8, 0xA0D8}, {0xA0D9, 0xA0D9, 0xA0D9},
    {0xA0DA, 0xA0DA, 0xA0DA}, {0xA0DB, 0xA0DB, 0xA0DB},
    {0xA0DC, 0xA0DC, 0xA0DC}, {0xA0DD, 0xA0DD, 0xA0DD},
    {0xA0DE, 0xA0DE, 0xA0DE}, {0xA0DF, 0xA0DF, 0xA0DF},
    {0xA0E0, 0xA0E0, 0xA0E0}, {0xA0E1, 0xA0E1, 0xA0E1},
    {0xA0E2, 0xA0E2, 0xA0E2}, {0xA0E3, 0xA0E3, 0xA0E3},
    {0xA0E4, 0xA0E4, 0xA0E4}, {0xA0E5, 0xA0E5, 0xA0E5},
    {0xA0E6, 0xA0E6, 0xA0E6}, {0xA0E7, 0xA0E7, 0xA0E7},
    {0xA0E8, 0xA0E8, 0xA0E8}, {0xA0E9, 0xA0E9, 0xA0E9},
    {0xA0EA, 0xA0EA, 0xA0EA}, {0xA0EB, 0xA0EB, 0xA0EB},
    {0xA0EC, 0xA0EC, 0xA0EC}, {0xA0ED, 0xA0ED, 0xA0ED},
    {0xA0EE, 0xA0EE, 0xA0EE}, {0xA0EF, 0xA0EF, 0xA0EF},
    {0xA0F0, 0xA0F0, 0xA0F0}, {0xA0F1, 0xA0F1, 0xA0F1},
    {0xA0F2, 0xA0F2, 0xA0F2}, {0xA0F3, 0xA0F3, 0xA0F3},
    {0xA0F4, 0xA0F4, 0xA0F4}, {0xA0F5, 0xA0F5, 0xA0F5},
    {0xA0F6, 0xA0F6, 0xA0F6}, {0xA0F7, 0xA0F7, 0xA0F7},
    {0xA0F8, 0xA0F8, 0xA0F8}, {0xA0F9, 0xA0F9, 0xA0F9},
    {0xA0FA, 0xA0FA, 0xA0FA}, {0xA0FB, 0xA0FB, 0xA0FB},
    {0xA0FC, 0xA0FC, 0xA0FC}, {0xA0FD, 0xA0FD, 0xA0FD},
    {0xA0FE, 0xA0FE, 0xA0FE}, {0xA0FF, 0xA0FF, 0xA0FF},
    {0xA100, 0xA100, 0xA100}, {0xA101, 0xA101, 0xA101},
    {0xA102, 0xA102, 0xA102}, {0xA103, 0xA103, 0xA103},
    {0xA104, 0xA104, 0xA104}, {0xA105, 0xA105, 0xA105},
    {0xA106, 0xA106, 0xA106}, {0xA107, 0xA107, 0xA107},
    {0xA108, 0xA108, 0xA108}, {0xA109, 0xA109, 0xA109},
    {0xA10A, 0xA10A, 0xA10A}, {0xA10B, 0xA10B, 0xA10B},
    {0xA10C, 0xA10C, 0xA10C}, {0xA10D, 0xA10D, 0xA10D},
    {0xA10E, 0xA10E, 0xA10E}, {0xA10F, 0xA10F, 0xA10F},
    {0xA110, 0xA110, 0xA110}, {0xA111, 0xA111, 0xA111},
    {0xA112, 0xA112, 0xA112}, {0xA113, 0xA113, 0xA113},
    {0xA114, 0xA114, 0xA114}, {0xA115, 0xA115, 0xA115},
    {0xA116, 0xA116, 0xA116}, {0xA117, 0xA117, 0xA117},
    {0xA118, 0xA118, 0xA118}, {0xA119, 0xA119, 0xA119},
    {0xA11A, 0xA11A, 0xA11A}, {0xA11B, 0xA11B, 0xA11B},
    {0xA11C, 0xA11C, 0xA11C}, {0xA11D, 0xA11D, 0xA11D},
    {0xA11E, 0xA11E, 0xA11E}, {0xA11F, 0xA11F, 0xA11F},
    {0xA120, 0xA120, 0xA120}, {0xA121, 0xA121, 0xA121},
    {0xA122, 0xA122, 0xA122}, {0xA123, 0xA123, 0xA123},
    {0xA124, 0xA124, 0xA124}, {0xA125, 0xA125, 0xA125},
    {0xA126, 0xA126, 0xA126}, {0xA127, 0xA127, 0xA127},
    {0xA128, 0xA128, 0xA128}, {0xA129, 0xA129, 0xA129},
    {0xA12A, 0xA12A, 0xA12A}, {0xA12B, 0xA12B, 0xA12B},
    {0xA12C, 0xA12C, 0xA12C}, {0xA12D, 0xA12D, 0xA12D},
    {0xA12E, 0xA12E, 0xA12E}, {0xA12F, 0xA12F, 0xA12F},
    {0xA130, 0xA130, 0xA130}, {0xA131, 0xA131, 0xA131},
    {0xA132, 0xA132, 0xA132}, {0xA133, 0xA133, 0xA133},
    {0xA134, 0xA134, 0xA134}, {0xA135, 0xA135, 0xA135},
    {0xA136, 0xA136, 0xA136}, {0xA137, 0xA137, 0xA137},
    {0xA138, 0xA138, 0xA138}, {0xA139, 0xA139, 0xA139},
    {0xA13A, 0xA13A, 0xA13A}, {0xA13B, 0xA13B, 0xA13B},
    {0xA13C, 0xA13C, 0xA13C}, {0xA13D, 0xA13D, 0xA13D},
    {0xA13E, 0xA13E, 0xA13E}, {0xA13F, 0xA13F, 0xA13F},
    {0xA140, 0xA140, 0xA140}, {0xA141, 0xA141, 0xA141},
    {0xA142, 0xA142, 0xA142}, {0xA143, 0xA143, 0xA143},
    {0xA144, 0xA144, 0xA144}, {0xA145, 0xA145, 0xA145},
    {0xA146, 0xA146, 0xA146}, {0xA147, 0xA147, 0xA147},
    {0xA148, 0xA148, 0xA148}, {0xA149, 0xA149, 0xA149},
    {0xA14A, 0xA14A, 0xA14A}, {0xA14B, 0xA14B, 0xA14B},
    {0xA14C, 0xA14C, 0xA14C}, {0xA14D, 0xA14D, 0xA14D},
    {0xA14E, 0xA14E, 0xA14E}, {0xA14F, 0xA14F, 0xA14F},
    {0xA150, 0xA150, 0xA150}, {0xA151, 0xA151, 0xA151},
    {0xA152, 0xA152, 0xA152}, {0xA153, 0xA153, 0xA153},
    {0xA154, 0xA154, 0xA154}, {0xA155, 0xA155, 0xA155},
    {0xA156, 0xA156, 0xA156}, {0xA157, 0xA157, 0xA157},
    {0xA158, 0xA158, 0xA158}, {0xA159, 0xA159, 0xA159},
    {0xA15A, 0xA15A, 0xA15A}, {0xA15B, 0xA15B, 0xA15B},
    {0xA15C, 0xA15C, 0xA15C}, {0xA15D, 0xA15D, 0xA15D},
    {0xA15E, 0xA15E, 0xA15E}, {0xA15F, 0xA15F, 0xA15F},
    {0xA160, 0xA160, 0xA160}, {0xA161, 0xA161, 0xA161},
    {0xA162, 0xA162, 0xA162}, {0xA163, 0xA163, 0xA163},
    {0xA164, 0xA164, 0xA164}, {0xA165, 0xA165, 0xA165},
    {0xA166, 0xA166, 0xA166}, {0xA167, 0xA167, 0xA167},
    {0xA168, 0xA168, 0xA168}, {0xA169, 0xA169, 0xA169},
    {0xA16A, 0xA16A, 0xA16A}, {0xA16B, 0xA16B, 0xA16B},
    {0xA16C, 0xA16C, 0xA16C}, {0xA16D, 0xA16D, 0xA16D},
    {0xA16E, 0xA16E, 0xA16E}, {0xA16F, 0xA16F, 0xA16F},
    {0xA170, 0xA170, 0xA170}, {0xA171, 0xA171, 0xA171},
    {0xA172, 0xA172, 0xA172}, {0xA173, 0xA173, 0xA173},
    {0xA174, 0xA174, 0xA174}, {0xA175, 0xA175, 0xA175},
    {0xA176, 0xA176, 0xA176}, {0xA177, 0xA177, 0xA177},
    {0xA178, 0xA178, 0xA178}, {0xA179, 0xA179, 0xA179},
    {0xA17A, 0xA17A, 0xA17A}, {0xA17B, 0xA17B, 0xA17B},
    {0xA17C, 0xA17C, 0xA17C}, {0xA17D, 0xA17D, 0xA17D},
    {0xA17E, 0xA17E, 0xA17E}, {0xA17F, 0xA17F, 0xA17F},
    {0xA180, 0xA180, 0xA180}, {0xA181, 0xA181, 0xA181},
    {0xA182, 0xA182, 0xA182}, {0xA183, 0xA183, 0xA183},
    {0xA184, 0xA184, 0xA184}, {0xA185, 0xA185, 0xA185},
    {0xA186, 0xA186, 0xA186}, {0xA187, 0xA187, 0xA187},
    {0xA188, 0xA188, 0xA188}, {0xA189, 0xA189, 0xA189},
    {0xA18A, 0xA18A, 0xA18A}, {0xA18B, 0xA18B, 0xA18B},
    {0xA18C, 0xA18C, 0xA18C}, {0xA18D, 0xA18D, 0xA18D},
    {0xA18E, 0xA18E, 0xA18E}, {0xA18F, 0xA18F, 0xA18F},
    {0xA190, 0xA190, 0xA190}, {0xA191, 0xA191, 0xA191},
    {0xA192, 0xA192, 0xA192}, {0xA193, 0xA193, 0xA193},
    {0xA194, 0xA194, 0xA194}, {0xA195, 0xA195, 0xA195},
    {0xA196, 0xA196, 0xA196}, {0xA197, 0xA197, 0xA197},
    {0xA198, 0xA198, 0xA198}, {0xA199, 0xA199, 0xA199},
    {0xA19A, 0xA19A, 0xA19A}, {0xA19B, 0xA19B, 0xA19B},
    {0xA19C, 0xA19C, 0xA19C}, {0xA19D, 0xA19D, 0xA19D},
    {0xA19E, 0xA19E, 0xA19E}, {0xA19F, 0xA19F, 0xA19F},
    {0xA1A0, 0xA1A0, 0xA1A0}, {0xA1A1, 0xA1A1, 0xA1A1},
    {0xA1A2, 0xA1A2, 0xA1A2}, {0xA1A3, 0xA1A3, 0xA1A3},
    {0xA1A4, 0xA1A4, 0xA1A4}, {0xA1A5, 0xA1A5, 0xA1A5},
    {0xA1A6, 0xA1A6, 0xA1A6}, {0xA1A7, 0xA1A7, 0xA1A7},
    {0xA1A8, 0xA1A8, 0xA1A8}, {0xA1A9, 0xA1A9, 0xA1A9},
    {0xA1AA, 0xA1AA, 0xA1AA}, {0xA1AB, 0xA1AB, 0xA1AB},
    {0xA1AC, 0xA1AC, 0xA1AC}, {0xA1AD, 0xA1AD, 0xA1AD},
    {0xA1AE, 0xA1AE, 0xA1AE}, {0xA1AF, 0xA1AF, 0xA1AF},
    {0xA1B0, 0xA1B0, 0xA1B0}, {0xA1B1, 0xA1B1, 0xA1B1},
    {0xA1B2, 0xA1B2, 0xA1B2}, {0xA1B3, 0xA1B3, 0xA1B3},
    {0xA1B4, 0xA1B4, 0xA1B4}, {0xA1B5, 0xA1B5, 0xA1B5},
    {0xA1B6, 0xA1B6, 0xA1B6}, {0xA1B7, 0xA1B7, 0xA1B7},
    {0xA1B8, 0xA1B8, 0xA1B8}, {0xA1B9, 0xA1B9, 0xA1B9},
    {0xA1BA, 0xA1BA, 0xA1BA}, {0xA1BB, 0xA1BB, 0xA1BB},
    {0xA1BC, 0xA1BC, 0xA1BC}, {0xA1BD, 0xA1BD, 0xA1BD},
    {0xA1BE, 0xA1BE, 0xA1BE}, {0xA1BF, 0xA1BF, 0xA1BF},
    {0xA1C0, 0xA1C0, 0xA1C0}, {0xA1C1, 0xA1C1, 0xA1C1},
    {0xA1C2, 0xA1C2, 0xA1C2}, {0xA1C3, 0xA1C3, 0xA1C3},
    {0xA1C4, 0xA1C4, 0xA1C4}, {0xA1C5, 0xA1C5, 0xA1C5},
    {0xA1C6, 0xA1C6, 0xA1C6}, {0xA1C7, 0xA1C7, 0xA1C7},
    {0xA1C8, 0xA1C8, 0xA1C8}, {0xA1C9, 0xA1C9, 0xA1C9},
    {0xA1CA, 0xA1CA, 0xA1CA}, {0xA1CB, 0xA1CB, 0xA1CB},
    {0xA1CC, 0xA1CC, 0xA1CC}, {0xA1CD, 0xA1CD, 0xA1CD},
    {0xA1CE, 0xA1CE, 0xA1CE}, {0xA1CF, 0xA1CF, 0xA1CF},
    {0xA1D0, 0xA1D0, 0xA1D0}, {0xA1D1, 0xA1D1, 0xA1D1},
    {0xA1D2, 0xA1D2, 0xA1D2}, {0xA1D3, 0xA1D3, 0xA1D3},
    {0xA1D4, 0xA1D4, 0xA1D4}, {0xA1D5, 0xA1D5, 0xA1D5},
    {0xA1D6, 0xA1D6, 0xA1D6}, {0xA1D7, 0xA1D7, 0xA1D7},
    {0xA1D8, 0xA1D8, 0xA1D8}, {0xA1D9, 0xA1D9, 0xA1D9},
    {0xA1DA, 0xA1DA, 0xA1DA}, {0xA1DB, 0xA1DB, 0xA1DB},
    {0xA1DC, 0xA1DC, 0xA1DC}, {0xA1DD, 0xA1DD, 0xA1DD},
    {0xA1DE, 0xA1DE, 0xA1DE}, {0xA1DF, 0xA1DF, 0xA1DF},
    {0xA1E0, 0xA1E0, 0xA1E0}, {0xA1E1, 0xA1E1, 0xA1E1},
    {0xA1E2, 0xA1E2, 0xA1E2}, {0xA1E3, 0xA1E3, 0xA1E3},
    {0xA1E4, 0xA1E4, 0xA1E4}, {0xA1E5, 0xA1E5, 0xA1E5},
    {0xA1E6, 0xA1E6, 0xA1E6}, {0xA1E7, 0xA1E7, 0xA1E7},
    {0xA1E8, 0xA1E8, 0xA1E8}, {0xA1E9, 0xA1E9, 0xA1E9},
    {0xA1EA, 0xA1EA, 0xA1EA}, {0xA1EB, 0xA1EB, 0xA1EB},
    {0xA1EC, 0xA1EC, 0xA1EC}, {0xA1ED, 0xA1ED, 0xA1ED},
    {0xA1EE, 0xA1EE, 0xA1EE}, {0xA1EF, 0xA1EF, 0xA1EF},
    {0xA1F0, 0xA1F0, 0xA1F0}, {0xA1F1, 0xA1F1, 0xA1F1},
    {0xA1F2, 0xA1F2, 0xA1F2}, {0xA1F3, 0xA1F3, 0xA1F3},
    {0xA1F4, 0xA1F4, 0xA1F4}, {0xA1F5, 0xA1F5, 0xA1F5},
    {0xA1F6, 0xA1F6, 0xA1F6}, {0xA1F7, 0xA1F7, 0xA1F7},
    {0xA1F8, 0xA1F8, 0xA1F8}, {0xA1F9, 0xA1F9, 0xA1F9},
    {0xA1FA, 0xA1FA, 0xA1FA}, {0xA1FB, 0xA1FB, 0xA1FB},
    {0xA1FC, 0xA1FC, 0xA1FC}, {0xA1FD, 0xA1FD, 0xA1FD},
    {0xA1FE, 0xA1FE, 0xA1FE}, {0xA1FF, 0xA1FF, 0xA1FF},
    {0xA200, 0xA200, 0xA200}, {0xA201, 0xA201, 0xA201},
    {0xA202, 0xA202, 0xA202}, {0xA203, 0xA203, 0xA203},
    {0xA204, 0xA204, 0xA204}, {0xA205, 0xA205, 0xA205},
    {0xA206, 0xA206, 0xA206}, {0xA207, 0xA207, 0xA207},
    {0xA208, 0xA208, 0xA208}, {0xA209, 0xA209, 0xA209},
    {0xA20A, 0xA20A, 0xA20A}, {0xA20B, 0xA20B, 0xA20B},
    {0xA20C, 0xA20C, 0xA20C}, {0xA20D, 0xA20D, 0xA20D},
    {0xA20E, 0xA20E, 0xA20E}, {0xA20F, 0xA20F, 0xA20F},
    {0xA210, 0xA210, 0xA210}, {0xA211, 0xA211, 0xA211},
    {0xA212, 0xA212, 0xA212}, {0xA213, 0xA213, 0xA213},
    {0xA214, 0xA214, 0xA214}, {0xA215, 0xA215, 0xA215},
    {0xA216, 0xA216, 0xA216}, {0xA217, 0xA217, 0xA217},
    {0xA218, 0xA218, 0xA218}, {0xA219, 0xA219, 0xA219},
    {0xA21A, 0xA21A, 0xA21A}, {0xA21B, 0xA21B, 0xA21B},
    {0xA21C, 0xA21C, 0xA21C}, {0xA21D, 0xA21D, 0xA21D},
    {0xA21E, 0xA21E, 0xA21E}, {0xA21F, 0xA21F, 0xA21F},
    {0xA220, 0xA220, 0xA220}, {0xA221, 0xA221, 0xA221},
    {0xA222, 0xA222, 0xA222}, {0xA223, 0xA223, 0xA223},
    {0xA224, 0xA224, 0xA224}, {0xA225, 0xA225, 0xA225},
    {0xA226, 0xA226, 0xA226}, {0xA227, 0xA227, 0xA227},
    {0xA228, 0xA228, 0xA228}, {0xA229, 0xA229, 0xA229},
    {0xA22A, 0xA22A, 0xA22A}, {0xA22B, 0xA22B, 0xA22B},
    {0xA22C, 0xA22C, 0xA22C}, {0xA22D, 0xA22D, 0xA22D},
    {0xA22E, 0xA22E, 0xA22E}, {0xA22F, 0xA22F, 0xA22F},
    {0xA230, 0xA230, 0xA230}, {0xA231, 0xA231, 0xA231},
    {0xA232, 0xA232, 0xA232}, {0xA233, 0xA233, 0xA233},
    {0xA234, 0xA234, 0xA234}, {0xA235, 0xA235, 0xA235},
    {0xA236, 0xA236, 0xA236}, {0xA237, 0xA237, 0xA237},
    {0xA238, 0xA238, 0xA238}, {0xA239, 0xA239, 0xA239},
    {0xA23A, 0xA23A, 0xA23A}, {0xA23B, 0xA23B, 0xA23B},
    {0xA23C, 0xA23C, 0xA23C}, {0xA23D, 0xA23D, 0xA23D},
    {0xA23E, 0xA23E, 0xA23E}, {0xA23F, 0xA23F, 0xA23F},
    {0xA240, 0xA240, 0xA240}, {0xA241, 0xA241, 0xA241},
    {0xA242, 0xA242, 0xA242}, {0xA243, 0xA243, 0xA243},
    {0xA244, 0xA244, 0xA244}, {0xA245, 0xA245, 0xA245},
    {0xA246, 0xA246, 0xA246}, {0xA247, 0xA247, 0xA247},
    {0xA248, 0xA248, 0xA248}, {0xA249, 0xA249, 0xA249},
    {0xA24A, 0xA24A, 0xA24A}, {0xA24B, 0xA24B, 0xA24B},
    {0xA24C, 0xA24C, 0xA24C}, {0xA24D, 0xA24D, 0xA24D},
    {0xA24E, 0xA24E, 0xA24E}, {0xA24F, 0xA24F, 0xA24F},
    {0xA250, 0xA250, 0xA250}, {0xA251, 0xA251, 0xA251},
    {0xA252, 0xA252, 0xA252}, {0xA253, 0xA253, 0xA253},
    {0xA254, 0xA254, 0xA254}, {0xA255, 0xA255, 0xA255},
    {0xA256, 0xA256, 0xA256}, {0xA257, 0xA257, 0xA257},
    {0xA258, 0xA258, 0xA258}, {0xA259, 0xA259, 0xA259},
    {0xA25A, 0xA25A, 0xA25A}, {0xA25B, 0xA25B, 0xA25B},
    {0xA25C, 0xA25C, 0xA25C}, {0xA25D, 0xA25D, 0xA25D},
    {0xA25E, 0xA25E, 0xA25E}, {0xA25F, 0xA25F, 0xA25F},
    {0xA260, 0xA260, 0xA260}, {0xA261, 0xA261, 0xA261},
    {0xA262, 0xA262, 0xA262}, {0xA263, 0xA263, 0xA263},
    {0xA264, 0xA264, 0xA264}, {0xA265, 0xA265, 0xA265},
    {0xA266, 0xA266, 0xA266}, {0xA267, 0xA267, 0xA267},
    {0xA268, 0xA268, 0xA268}, {0xA269, 0xA269, 0xA269},
    {0xA26A, 0xA26A, 0xA26A}, {0xA26B, 0xA26B, 0xA26B},
    {0xA26C, 0xA26C, 0xA26C}, {0xA26D, 0xA26D, 0xA26D},
    {0xA26E, 0xA26E, 0xA26E}, {0xA26F, 0xA26F, 0xA26F},
    {0xA270, 0xA270, 0xA270}, {0xA271, 0xA271, 0xA271},
    {0xA272, 0xA272, 0xA272}, {0xA273, 0xA273, 0xA273},
    {0xA274, 0xA274, 0xA274}, {0xA275, 0xA275, 0xA275},
    {0xA276, 0xA276, 0xA276}, {0xA277, 0xA277, 0xA277},
    {0xA278, 0xA278, 0xA278}, {0xA279, 0xA279, 0xA279},
    {0xA27A, 0xA27A, 0xA27A}, {0xA27B, 0xA27B, 0xA27B},
    {0xA27C, 0xA27C, 0xA27C}, {0xA27D, 0xA27D, 0xA27D},
    {0xA27E, 0xA27E, 0xA27E}, {0xA27F, 0xA27F, 0xA27F},
    {0xA280, 0xA280, 0xA280}, {0xA281, 0xA281, 0xA281},
    {0xA282, 0xA282, 0xA282}, {0xA283, 0xA283, 0xA283},
    {0xA284, 0xA284, 0xA284}, {0xA285, 0xA285, 0xA285},
    {0xA286, 0xA286, 0xA286}, {0xA287, 0xA287, 0xA287},
    {0xA288, 0xA288, 0xA288}, {0xA289, 0xA289, 0xA289},
    {0xA28A, 0xA28A, 0xA28A}, {0xA28B, 0xA28B, 0xA28B},
    {0xA28C, 0xA28C, 0xA28C}, {0xA28D, 0xA28D, 0xA28D},
    {0xA28E, 0xA28E, 0xA28E}, {0xA28F, 0xA28F, 0xA28F},
    {0xA290, 0xA290, 0xA290}, {0xA291, 0xA291, 0xA291},
    {0xA292, 0xA292, 0xA292}, {0xA293, 0xA293, 0xA293},
    {0xA294, 0xA294, 0xA294}, {0xA295, 0xA295, 0xA295},
    {0xA296, 0xA296, 0xA296}, {0xA297, 0xA297, 0xA297},
    {0xA298, 0xA298, 0xA298}, {0xA299, 0xA299, 0xA299},
    {0xA29A, 0xA29A, 0xA29A}, {0xA29B, 0xA29B, 0xA29B},
    {0xA29C, 0xA29C, 0xA29C}, {0xA29D, 0xA29D, 0xA29D},
    {0xA29E, 0xA29E, 0xA29E}, {0xA29F, 0xA29F, 0xA29F},
    {0xA2A0, 0xA2A0, 0xA2A0}, {0xA2A1, 0xA2A1, 0xA2A1},
    {0xA2A2, 0xA2A2, 0xA2A2}, {0xA2A3, 0xA2A3, 0xA2A3},
    {0xA2A4, 0xA2A4, 0xA2A4}, {0xA2A5, 0xA2A5, 0xA2A5},
    {0xA2A6, 0xA2A6, 0xA2A6}, {0xA2A7, 0xA2A7, 0xA2A7},
    {0xA2A8, 0xA2A8, 0xA2A8}, {0xA2A9, 0xA2A9, 0xA2A9},
    {0xA2AA, 0xA2AA, 0xA2AA}, {0xA2AB, 0xA2AB, 0xA2AB},
    {0xA2AC, 0xA2AC, 0xA2AC}, {0xA2AD, 0xA2AD, 0xA2AD},
    {0xA2AE, 0xA2AE, 0xA2AE}, {0xA2AF, 0xA2AF, 0xA2AF},
    {0xA2B0, 0xA2B0, 0xA2B0}, {0xA2B1, 0xA2B1, 0xA2B1},
    {0xA2B2, 0xA2B2, 0xA2B2}, {0xA2B3, 0xA2B3, 0xA2B3},
    {0xA2B4, 0xA2B4, 0xA2B4}, {0xA2B5, 0xA2B5, 0xA2B5},
    {0xA2B6, 0xA2B6, 0xA2B6}, {0xA2B7, 0xA2B7, 0xA2B7},
    {0xA2B8, 0xA2B8, 0xA2B8}, {0xA2B9, 0xA2B9, 0xA2B9},
    {0xA2BA, 0xA2BA, 0xA2BA}, {0xA2BB, 0xA2BB, 0xA2BB},
    {0xA2BC, 0xA2BC, 0xA2BC}, {0xA2BD, 0xA2BD, 0xA2BD},
    {0xA2BE, 0xA2BE, 0xA2BE}, {0xA2BF, 0xA2BF, 0xA2BF},
    {0xA2C0, 0xA2C0, 0xA2C0}, {0xA2C1, 0xA2C1, 0xA2C1},
    {0xA2C2, 0xA2C2, 0xA2C2}, {0xA2C3, 0xA2C3, 0xA2C3},
    {0xA2C4, 0xA2C4, 0xA2C4}, {0xA2C5, 0xA2C5, 0xA2C5},
    {0xA2C6, 0xA2C6, 0xA2C6}, {0xA2C7, 0xA2C7, 0xA2C7},
    {0xA2C8, 0xA2C8, 0xA2C8}, {0xA2C9, 0xA2C9, 0xA2C9},
    {0xA2CA, 0xA2CA, 0xA2CA}, {0xA2CB, 0xA2CB, 0xA2CB},
    {0xA2CC, 0xA2CC, 0xA2CC}, {0xA2CD, 0xA2CD, 0xA2CD},
    {0xA2CE, 0xA2CE, 0xA2CE}, {0xA2CF, 0xA2CF, 0xA2CF},
    {0xA2D0, 0xA2D0, 0xA2D0}, {0xA2D1, 0xA2D1, 0xA2D1},
    {0xA2D2, 0xA2D2, 0xA2D2}, {0xA2D3, 0xA2D3, 0xA2D3},
    {0xA2D4, 0xA2D4, 0xA2D4}, {0xA2D5, 0xA2D5, 0xA2D5},
    {0xA2D6, 0xA2D6, 0xA2D6}, {0xA2D7, 0xA2D7, 0xA2D7},
    {0xA2D8, 0xA2D8, 0xA2D8}, {0xA2D9, 0xA2D9, 0xA2D9},
    {0xA2DA, 0xA2DA, 0xA2DA}, {0xA2DB, 0xA2DB, 0xA2DB},
    {0xA2DC, 0xA2DC, 0xA2DC}, {0xA2DD, 0xA2DD, 0xA2DD},
    {0xA2DE, 0xA2DE, 0xA2DE}, {0xA2DF, 0xA2DF, 0xA2DF},
    {0xA2E0, 0xA2E0, 0xA2E0}, {0xA2E1, 0xA2E1, 0xA2E1},
    {0xA2E2, 0xA2E2, 0xA2E2}, {0xA2E3, 0xA2E3, 0xA2E3},
    {0xA2E4, 0xA2E4, 0xA2E4}, {0xA2E5, 0xA2E5, 0xA2E5},
    {0xA2E6, 0xA2E6, 0xA2E6}, {0xA2E7, 0xA2E7, 0xA2E7},
    {0xA2E8, 0xA2E8, 0xA2E8}, {0xA2E9, 0xA2E9, 0xA2E9},
    {0xA2EA, 0xA2EA, 0xA2EA}, {0xA2EB, 0xA2EB, 0xA2EB},
    {0xA2EC, 0xA2EC, 0xA2EC}, {0xA2ED, 0xA2ED, 0xA2ED},
    {0xA2EE, 0xA2EE, 0xA2EE}, {0xA2EF, 0xA2EF, 0xA2EF},
    {0xA2F0, 0xA2F0, 0xA2F0}, {0xA2F1, 0xA2F1, 0xA2F1},
    {0xA2F2, 0xA2F2, 0xA2F2}, {0xA2F3, 0xA2F3, 0xA2F3},
    {0xA2F4, 0xA2F4, 0xA2F4}, {0xA2F5, 0xA2F5, 0xA2F5},
    {0xA2F6, 0xA2F6, 0xA2F6}, {0xA2F7, 0xA2F7, 0xA2F7},
    {0xA2F8, 0xA2F8, 0xA2F8}, {0xA2F9, 0xA2F9, 0xA2F9},
    {0xA2FA, 0xA2FA, 0xA2FA}, {0xA2FB, 0xA2FB, 0xA2FB},
    {0xA2FC, 0xA2FC, 0xA2FC}, {0xA2FD, 0xA2FD, 0xA2FD},
    {0xA2FE, 0xA2FE, 0xA2FE}, {0xA2FF, 0xA2FF, 0xA2FF},
    {0xA300, 0xA300, 0xA300}, {0xA301, 0xA301, 0xA301},
    {0xA302, 0xA302, 0xA302}, {0xA303, 0xA303, 0xA303},
    {0xA304, 0xA304, 0xA304}, {0xA305, 0xA305, 0xA305},
    {0xA306, 0xA306, 0xA306}, {0xA307, 0xA307, 0xA307},
    {0xA308, 0xA308, 0xA308}, {0xA309, 0xA309, 0xA309},
    {0xA30A, 0xA30A, 0xA30A}, {0xA30B, 0xA30B, 0xA30B},
    {0xA30C, 0xA30C, 0xA30C}, {0xA30D, 0xA30D, 0xA30D},
    {0xA30E, 0xA30E, 0xA30E}, {0xA30F, 0xA30F, 0xA30F},
    {0xA310, 0xA310, 0xA310}, {0xA311, 0xA311, 0xA311},
    {0xA312, 0xA312, 0xA312}, {0xA313, 0xA313, 0xA313},
    {0xA314, 0xA314, 0xA314}, {0xA315, 0xA315, 0xA315},
    {0xA316, 0xA316, 0xA316}, {0xA317, 0xA317, 0xA317},
    {0xA318, 0xA318, 0xA318}, {0xA319, 0xA319, 0xA319},
    {0xA31A, 0xA31A, 0xA31A}, {0xA31B, 0xA31B, 0xA31B},
    {0xA31C, 0xA31C, 0xA31C}, {0xA31D, 0xA31D, 0xA31D},
    {0xA31E, 0xA31E, 0xA31E}, {0xA31F, 0xA31F, 0xA31F},
    {0xA320, 0xA320, 0xA320}, {0xA321, 0xA321, 0xA321},
    {0xA322, 0xA322, 0xA322}, {0xA323, 0xA323, 0xA323},
    {0xA324, 0xA324, 0xA324}, {0xA325, 0xA325, 0xA325},
    {0xA326, 0xA326, 0xA326}, {0xA327, 0xA327, 0xA327},
    {0xA328, 0xA328, 0xA328}, {0xA329, 0xA329, 0xA329},
    {0xA32A, 0xA32A, 0xA32A}, {0xA32B, 0xA32B, 0xA32B},
    {0xA32C, 0xA32C, 0xA32C}, {0xA32D, 0xA32D, 0xA32D},
    {0xA32E, 0xA32E, 0xA32E}, {0xA32F, 0xA32F, 0xA32F},
    {0xA330, 0xA330, 0xA330}, {0xA331, 0xA331, 0xA331},
    {0xA332, 0xA332, 0xA332}, {0xA333, 0xA333, 0xA333},
    {0xA334, 0xA334, 0xA334}, {0xA335, 0xA335, 0xA335},
    {0xA336, 0xA336, 0xA336}, {0xA337, 0xA337, 0xA337},
    {0xA338, 0xA338, 0xA338}, {0xA339, 0xA339, 0xA339},
    {0xA33A, 0xA33A, 0xA33A}, {0xA33B, 0xA33B, 0xA33B},
    {0xA33C, 0xA33C, 0xA33C}, {0xA33D, 0xA33D, 0xA33D},
    {0xA33E, 0xA33E, 0xA33E}, {0xA33F, 0xA33F, 0xA33F},
    {0xA340, 0xA340, 0xA340}, {0xA341, 0xA341, 0xA341},
    {0xA342, 0xA342, 0xA342}, {0xA343, 0xA343, 0xA343},
    {0xA344, 0xA344, 0xA344}, {0xA345, 0xA345, 0xA345},
    {0xA346, 0xA346, 0xA346}, {0xA347, 0xA347, 0xA347},
    {0xA348, 0xA348, 0xA348}, {0xA349, 0xA349, 0xA349},
    {0xA34A, 0xA34A, 0xA34A}, {0xA34B, 0xA34B, 0xA34B},
    {0xA34C, 0xA34C, 0xA34C}, {0xA34D, 0xA34D, 0xA34D},
    {0xA34E, 0xA34E, 0xA34E}, {0xA34F, 0xA34F, 0xA34F},
    {0xA350, 0xA350, 0xA350}, {0xA351, 0xA351, 0xA351},
    {0xA352, 0xA352, 0xA352}, {0xA353, 0xA353, 0xA353},
    {0xA354, 0xA354, 0xA354}, {0xA355, 0xA355, 0xA355},
    {0xA356, 0xA356, 0xA356}, {0xA357, 0xA357, 0xA357},
    {0xA358, 0xA358, 0xA358}, {0xA359, 0xA359, 0xA359},
    {0xA35A, 0xA35A, 0xA35A}, {0xA35B, 0xA35B, 0xA35B},
    {0xA35C, 0xA35C, 0xA35C}, {0xA35D, 0xA35D, 0xA35D},
    {0xA35E, 0xA35E, 0xA35E}, {0xA35F, 0xA35F, 0xA35F},
    {0xA360, 0xA360, 0xA360}, {0xA361, 0xA361, 0xA361},
    {0xA362, 0xA362, 0xA362}, {0xA363, 0xA363, 0xA363},
    {0xA364, 0xA364, 0xA364}, {0xA365, 0xA365, 0xA365},
    {0xA366, 0xA366, 0xA366}, {0xA367, 0xA367, 0xA367},
    {0xA368, 0xA368, 0xA368}, {0xA369, 0xA369, 0xA369},
    {0xA36A, 0xA36A, 0xA36A}, {0xA36B, 0xA36B, 0xA36B},
    {0xA36C, 0xA36C, 0xA36C}, {0xA36D, 0xA36D, 0xA36D},
    {0xA36E, 0xA36E, 0xA36E}, {0xA36F, 0xA36F, 0xA36F},
    {0xA370, 0xA370, 0xA370}, {0xA371, 0xA371, 0xA371},
    {0xA372, 0xA372, 0xA372}, {0xA373, 0xA373, 0xA373},
    {0xA374, 0xA374, 0xA374}, {0xA375, 0xA375, 0xA375},
    {0xA376, 0xA376, 0xA376}, {0xA377, 0xA377, 0xA377},
    {0xA378, 0xA378, 0xA378}, {0xA379, 0xA379, 0xA379},
    {0xA37A, 0xA37A, 0xA37A}, {0xA37B, 0xA37B, 0xA37B},
    {0xA37C, 0xA37C, 0xA37C}, {0xA37D, 0xA37D, 0xA37D},
    {0xA37E, 0xA37E, 0xA37E}, {0xA37F, 0xA37F, 0xA37F},
    {0xA380, 0xA380, 0xA380}, {0xA381, 0xA381, 0xA381},
    {0xA382, 0xA382, 0xA382}, {0xA383, 0xA383, 0xA383},
    {0xA384, 0xA384, 0xA384}, {0xA385, 0xA385, 0xA385},
    {0xA386, 0xA386, 0xA386}, {0xA387, 0xA387, 0xA387},
    {0xA388, 0xA388, 0xA388}, {0xA389, 0xA389, 0xA389},
    {0xA38A, 0xA38A, 0xA38A}, {0xA38B, 0xA38B, 0xA38B},
    {0xA38C, 0xA38C, 0xA38C}, {0xA38D, 0xA38D, 0xA38D},
    {0xA38E, 0xA38E, 0xA38E}, {0xA38F, 0xA38F, 0xA38F},
    {0xA390, 0xA390, 0xA390}, {0xA391, 0xA391, 0xA391},
    {0xA392, 0xA392, 0xA392}, {0xA393, 0xA393, 0xA393},
    {0xA394, 0xA394, 0xA394}, {0xA395, 0xA395, 0xA395},
    {0xA396, 0xA396, 0xA396}, {0xA397, 0xA397, 0xA397},
    {0xA398, 0xA398, 0xA398}, {0xA399, 0xA399, 0xA399},
    {0xA39A, 0xA39A, 0xA39A}, {0xA39B, 0xA39B, 0xA39B},
    {0xA39C, 0xA39C, 0xA39C}, {0xA39D, 0xA39D, 0xA39D},
    {0xA39E, 0xA39E, 0xA39E}, {0xA39F, 0xA39F, 0xA39F},
    {0xA3A0, 0xA3A0, 0xA3A0}, {0xA3A1, 0xA3A1, 0xA3A1},
    {0xA3A2, 0xA3A2, 0xA3A2}, {0xA3A3, 0xA3A3, 0xA3A3},
    {0xA3A4, 0xA3A4, 0xA3A4}, {0xA3A5, 0xA3A5, 0xA3A5},
    {0xA3A6, 0xA3A6, 0xA3A6}, {0xA3A7, 0xA3A7, 0xA3A7},
    {0xA3A8, 0xA3A8, 0xA3A8}, {0xA3A9, 0xA3A9, 0xA3A9},
    {0xA3AA, 0xA3AA, 0xA3AA}, {0xA3AB, 0xA3AB, 0xA3AB},
    {0xA3AC, 0xA3AC, 0xA3AC}, {0xA3AD, 0xA3AD, 0xA3AD},
    {0xA3AE, 0xA3AE, 0xA3AE}, {0xA3AF, 0xA3AF, 0xA3AF},
    {0xA3B0, 0xA3B0, 0xA3B0}, {0xA3B1, 0xA3B1, 0xA3B1},
    {0xA3B2, 0xA3B2, 0xA3B2}, {0xA3B3, 0xA3B3, 0xA3B3},
    {0xA3B4, 0xA3B4, 0xA3B4}, {0xA3B5, 0xA3B5, 0xA3B5},
    {0xA3B6, 0xA3B6, 0xA3B6}, {0xA3B7, 0xA3B7, 0xA3B7},
    {0xA3B8, 0xA3B8, 0xA3B8}, {0xA3B9, 0xA3B9, 0xA3B9},
    {0xA3BA, 0xA3BA, 0xA3BA}, {0xA3BB, 0xA3BB, 0xA3BB},
    {0xA3BC, 0xA3BC, 0xA3BC}, {0xA3BD, 0xA3BD, 0xA3BD},
    {0xA3BE, 0xA3BE, 0xA3BE}, {0xA3BF, 0xA3BF, 0xA3BF},
    {0xA3C0, 0xA3C0, 0xA3C0}, {0xA3C1, 0xA3C1, 0xA3C1},
    {0xA3C2, 0xA3C2, 0xA3C2}, {0xA3C3, 0xA3C3, 0xA3C3},
    {0xA3C4, 0xA3C4, 0xA3C4}, {0xA3C5, 0xA3C5, 0xA3C5},
    {0xA3C6, 0xA3C6, 0xA3C6}, {0xA3C7, 0xA3C7, 0xA3C7},
    {0xA3C8, 0xA3C8, 0xA3C8}, {0xA3C9, 0xA3C9, 0xA3C9},
    {0xA3CA, 0xA3CA, 0xA3CA}, {0xA3CB, 0xA3CB, 0xA3CB},
    {0xA3CC, 0xA3CC, 0xA3CC}, {0xA3CD, 0xA3CD, 0xA3CD},
    {0xA3CE, 0xA3CE, 0xA3CE}, {0xA3CF, 0xA3CF, 0xA3CF},
    {0xA3D0, 0xA3D0, 0xA3D0}, {0xA3D1, 0xA3D1, 0xA3D1},
    {0xA3D2, 0xA3D2, 0xA3D2}, {0xA3D3, 0xA3D3, 0xA3D3},
    {0xA3D4, 0xA3D4, 0xA3D4}, {0xA3D5, 0xA3D5, 0xA3D5},
    {0xA3D6, 0xA3D6, 0xA3D6}, {0xA3D7, 0xA3D7, 0xA3D7},
    {0xA3D8, 0xA3D8, 0xA3D8}, {0xA3D9, 0xA3D9, 0xA3D9},
    {0xA3DA, 0xA3DA, 0xA3DA}, {0xA3DB, 0xA3DB, 0xA3DB},
    {0xA3DC, 0xA3DC, 0xA3DC}, {0xA3DD, 0xA3DD, 0xA3DD},
    {0xA3DE, 0xA3DE, 0xA3DE}, {0xA3DF, 0xA3DF, 0xA3DF},
    {0xA3E0, 0xA3E0, 0xA3E0}, {0xA3E1, 0xA3E1, 0xA3E1},
    {0xA3E2, 0xA3E2, 0xA3E2}, {0xA3E3, 0xA3E3, 0xA3E3},
    {0xA3E4, 0xA3E4, 0xA3E4}, {0xA3E5, 0xA3E5, 0xA3E5},
    {0xA3E6, 0xA3E6, 0xA3E6}, {0xA3E7, 0xA3E7, 0xA3E7},
    {0xA3E8, 0xA3E8, 0xA3E8}, {0xA3E9, 0xA3E9, 0xA3E9},
    {0xA3EA, 0xA3EA, 0xA3EA}, {0xA3EB, 0xA3EB, 0xA3EB},
    {0xA3EC, 0xA3EC, 0xA3EC}, {0xA3ED, 0xA3ED, 0xA3ED},
    {0xA3EE, 0xA3EE, 0xA3EE}, {0xA3EF, 0xA3EF, 0xA3EF},
    {0xA3F0, 0xA3F0, 0xA3F0}, {0xA3F1, 0xA3F1, 0xA3F1},
    {0xA3F2, 0xA3F2, 0xA3F2}, {0xA3F3, 0xA3F3, 0xA3F3},
    {0xA3F4, 0xA3F4, 0xA3F4}, {0xA3F5, 0xA3F5, 0xA3F5},
    {0xA3F6, 0xA3F6, 0xA3F6}, {0xA3F7, 0xA3F7, 0xA3F7},
    {0xA3F8, 0xA3F8, 0xA3F8}, {0xA3F9, 0xA3F9, 0xA3F9},
    {0xA3FA, 0xA3FA, 0xA3FA}, {0xA3FB, 0xA3FB, 0xA3FB},
    {0xA3FC, 0xA3FC, 0xA3FC}, {0xA3FD, 0xA3FD, 0xA3FD},
    {0xA3FE, 0xA3FE, 0xA3FE}, {0xA3FF, 0xA3FF, 0xA3FF},
    {0xA400, 0xA400, 0xA400}, {0xA401, 0xA401, 0xA401},
    {0xA402, 0xA402, 0xA402}, {0xA403, 0xA403, 0xA403},
    {0xA404, 0xA404, 0xA404}, {0xA405, 0xA405, 0xA405},
    {0xA406, 0xA406, 0xA406}, {0xA407, 0xA407, 0xA407},
    {0xA408, 0xA408, 0xA408}, {0xA409, 0xA409, 0xA409},
    {0xA40A, 0xA40A, 0xA40A}, {0xA40B, 0xA40B, 0xA40B},
    {0xA40C, 0xA40C, 0xA40C}, {0xA40D, 0xA40D, 0xA40D},
    {0xA40E, 0xA40E, 0xA40E}, {0xA40F, 0xA40F, 0xA40F},
    {0xA410, 0xA410, 0xA410}, {0xA411, 0xA411, 0xA411},
    {0xA412, 0xA412, 0xA412}, {0xA413, 0xA413, 0xA413},
    {0xA414, 0xA414, 0xA414}, {0xA415, 0xA415, 0xA415},
    {0xA416, 0xA416, 0xA416}, {0xA417, 0xA417, 0xA417},
    {0xA418, 0xA418, 0xA418}, {0xA419, 0xA419, 0xA419},
    {0xA41A, 0xA41A, 0xA41A}, {0xA41B, 0xA41B, 0xA41B},
    {0xA41C, 0xA41C, 0xA41C}, {0xA41D, 0xA41D, 0xA41D},
    {0xA41E, 0xA41E, 0xA41E}, {0xA41F, 0xA41F, 0xA41F},
    {0xA420, 0xA420, 0xA420}, {0xA421, 0xA421, 0xA421},
    {0xA422, 0xA422, 0xA422}, {0xA423, 0xA423, 0xA423},
    {0xA424, 0xA424, 0xA424}, {0xA425, 0xA425, 0xA425},
    {0xA426, 0xA426, 0xA426}, {0xA427, 0xA427, 0xA427},
    {0xA428, 0xA428, 0xA428}, {0xA429, 0xA429, 0xA429},
    {0xA42A, 0xA42A, 0xA42A}, {0xA42B, 0xA42B, 0xA42B},
    {0xA42C, 0xA42C, 0xA42C}, {0xA42D, 0xA42D, 0xA42D},
    {0xA42E, 0xA42E, 0xA42E}, {0xA42F, 0xA42F, 0xA42F},
    {0xA430, 0xA430, 0xA430}, {0xA431, 0xA431, 0xA431},
    {0xA432, 0xA432, 0xA432}, {0xA433, 0xA433, 0xA433},
    {0xA434, 0xA434, 0xA434}, {0xA435, 0xA435, 0xA435},
    {0xA436, 0xA436, 0xA436}, {0xA437, 0xA437, 0xA437},
    {0xA438, 0xA438, 0xA438}, {0xA439, 0xA439, 0xA439},
    {0xA43A, 0xA43A, 0xA43A}, {0xA43B, 0xA43B, 0xA43B},
    {0xA43C, 0xA43C, 0xA43C}, {0xA43D, 0xA43D, 0xA43D},
    {0xA43E, 0xA43E, 0xA43E}, {0xA43F, 0xA43F, 0xA43F},
    {0xA440, 0xA440, 0xA440}, {0xA441, 0xA441, 0xA441},
    {0xA442, 0xA442, 0xA442}, {0xA443, 0xA443, 0xA443},
    {0xA444, 0xA444, 0xA444}, {0xA445, 0xA445, 0xA445},
    {0xA446, 0xA446, 0xA446}, {0xA447, 0xA447, 0xA447},
    {0xA448, 0xA448, 0xA448}, {0xA449, 0xA449, 0xA449},
    {0xA44A, 0xA44A, 0xA44A}, {0xA44B, 0xA44B, 0xA44B},
    {0xA44C, 0xA44C, 0xA44C}, {0xA44D, 0xA44D, 0xA44D},
    {0xA44E, 0xA44E, 0xA44E}, {0xA44F, 0xA44F, 0xA44F},
    {0xA450, 0xA450, 0xA450}, {0xA451, 0xA451, 0xA451},
    {0xA452, 0xA452, 0xA452}, {0xA453, 0xA453, 0xA453},
    {0xA454, 0xA454, 0xA454}, {0xA455, 0xA455, 0xA455},
    {0xA456, 0xA456, 0xA456}, {0xA457, 0xA457, 0xA457},
    {0xA458, 0xA458, 0xA458}, {0xA459, 0xA459, 0xA459},
    {0xA45A, 0xA45A, 0xA45A}, {0xA45B, 0xA45B, 0xA45B},
    {0xA45C, 0xA45C, 0xA45C}, {0xA45D, 0xA45D, 0xA45D},
    {0xA45E, 0xA45E, 0xA45E}, {0xA45F, 0xA45F, 0xA45F},
    {0xA460, 0xA460, 0xA460}, {0xA461, 0xA461, 0xA461},
    {0xA462, 0xA462, 0xA462}, {0xA463, 0xA463, 0xA463},
    {0xA464, 0xA464, 0xA464}, {0xA465, 0xA465, 0xA465},
    {0xA466, 0xA466, 0xA466}, {0xA467, 0xA467, 0xA467},
    {0xA468, 0xA468, 0xA468}, {0xA469, 0xA469, 0xA469},
    {0xA46A, 0xA46A, 0xA46A}, {0xA46B, 0xA46B, 0xA46B},
    {0xA46C, 0xA46C, 0xA46C}, {0xA46D, 0xA46D, 0xA46D},
    {0xA46E, 0xA46E, 0xA46E}, {0xA46F, 0xA46F, 0xA46F},
    {0xA470, 0xA470, 0xA470}, {0xA471, 0xA471, 0xA471},
    {0xA472, 0xA472, 0xA472}, {0xA473, 0xA473, 0xA473},
    {0xA474, 0xA474, 0xA474}, {0xA475, 0xA475, 0xA475},
    {0xA476, 0xA476, 0xA476}, {0xA477, 0xA477, 0xA477},
    {0xA478, 0xA478, 0xA478}, {0xA479, 0xA479, 0xA479},
    {0xA47A, 0xA47A, 0xA47A}, {0xA47B, 0xA47B, 0xA47B},
    {0xA47C, 0xA47C, 0xA47C}, {0xA47D, 0xA47D, 0xA47D},
    {0xA47E, 0xA47E, 0xA47E}, {0xA47F, 0xA47F, 0xA47F},
    {0xA480, 0xA480, 0xA480}, {0xA481, 0xA481, 0xA481},
    {0xA482, 0xA482, 0xA482}, {0xA483, 0xA483, 0xA483},
    {0xA484, 0xA484, 0xA484}, {0xA485, 0xA485, 0xA485},
    {0xA486, 0xA486, 0xA486}, {0xA487, 0xA487, 0xA487},
    {0xA488, 0xA488, 0xA488}, {0xA489, 0xA489, 0xA489},
    {0xA48A, 0xA48A, 0xA48A}, {0xA48B, 0xA48B, 0xA48B},
    {0xA48C, 0xA48C, 0xA48C}, {0xA800, 0xA800, 0xA800},
    {0xA801, 0xA801, 0xA801}, {0xA803, 0xA803, 0xA803},
    {0xA804, 0xA804, 0xA804}, {0xA805, 0xA805, 0xA805},
    {0xA806, 0xA806, 0xA806}, {0xA807, 0xA807, 0xA807},
    {0xA808, 0xA808, 0xA808}, {0xA809, 0xA809, 0xA809},
    {0xA80A, 0xA80A, 0xA80A}, {0xA80B, 0xA80B, 0xA80B},
    {0xA80C, 0xA80C, 0xA80C}, {0xA80D, 0xA80D, 0xA80D},
    {0xA80E, 0xA80E, 0xA80E}, {0xA80F, 0xA80F, 0xA80F},
    {0xA810, 0xA810, 0xA810}, {0xA811, 0xA811, 0xA811},
    {0xA812, 0xA812, 0xA812}, {0xA813, 0xA813, 0xA813},
    {0xA814, 0xA814, 0xA814}, {0xA815, 0xA815, 0xA815},
    {0xA816, 0xA816, 0xA816}, {0xA817, 0xA817, 0xA817},
    {0xA818, 0xA818, 0xA818}, {0xA819, 0xA819, 0xA819},
    {0xA81A, 0xA81A, 0xA81A}, {0xA81B, 0xA81B, 0xA81B},
    {0xA81C, 0xA81C, 0xA81C}, {0xA81D, 0xA81D, 0xA81D},
    {0xA81E, 0xA81E, 0xA81E}, {0xA81F, 0xA81F, 0xA81F},
    {0xA820, 0xA820, 0xA820}, {0xA821, 0xA821, 0xA821},
    {0xA822, 0xA822, 0xA822}, {0xA825, 0xA825, 0xA825},
    {0xA826, 0xA826, 0xA826}, {0xAC00, 0xAC00, 0xAC00},
    {0xAC01, 0xAC01, 0xAC01}, {0xAC02, 0xAC02, 0xAC02},
    {0xAC03, 0xAC03, 0xAC03}, {0xAC04, 0xAC04, 0xAC04},
    {0xAC05, 0xAC05, 0xAC05}, {0xAC06, 0xAC06, 0xAC06},
    {0xAC07, 0xAC07, 0xAC07}, {0xAC08, 0xAC08, 0xAC08},
    {0xAC09, 0xAC09, 0xAC09}, {0xAC0A, 0xAC0A, 0xAC0A},
    {0xAC0B, 0xAC0B, 0xAC0B}, {0xAC0C, 0xAC0C, 0xAC0C},
    {0xAC0D, 0xAC0D, 0xAC0D}, {0xAC0E, 0xAC0E, 0xAC0E},
    {0xAC0F, 0xAC0F, 0xAC0F}, {0xAC10, 0xAC10, 0xAC10},
    {0xAC11, 0xAC11, 0xAC11}, {0xAC12, 0xAC12, 0xAC12},
    {0xAC13, 0xAC13, 0xAC13}, {0xAC14, 0xAC14, 0xAC14},
    {0xAC15, 0xAC15, 0xAC15}, {0xAC16, 0xAC16, 0xAC16},
    {0xAC17, 0xAC17, 0xAC17}, {0xAC18, 0xAC18, 0xAC18},
    {0xAC19, 0xAC19, 0xAC19}, {0xAC1A, 0xAC1A, 0xAC1A},
    {0xAC1B, 0xAC1B, 0xAC1B}, {0xAC1C, 0xAC1C, 0xAC1C},
    {0xAC1D, 0xAC1D, 0xAC1D}, {0xAC1E, 0xAC1E, 0xAC1E},
    {0xAC1F, 0xAC1F, 0xAC1F}, {0xAC20, 0xAC20, 0xAC20},
    {0xAC21, 0xAC21, 0xAC21}, {0xAC22, 0xAC22, 0xAC22},
    {0xAC23, 0xAC23, 0xAC23}, {0xAC24, 0xAC24, 0xAC24},
    {0xAC25, 0xAC25, 0xAC25}, {0xAC26, 0xAC26, 0xAC26},
    {0xAC27, 0xAC27, 0xAC27}, {0xAC28, 0xAC28, 0xAC28},
    {0xAC29, 0xAC29, 0xAC29}, {0xAC2A, 0xAC2A, 0xAC2A},
    {0xAC2B, 0xAC2B, 0xAC2B}, {0xAC2C, 0xAC2C, 0xAC2C},
    {0xAC2D, 0xAC2D, 0xAC2D}, {0xAC2E, 0xAC2E, 0xAC2E},
    {0xAC2F, 0xAC2F, 0xAC2F}, {0xAC30, 0xAC30, 0xAC30},
    {0xAC31, 0xAC31, 0xAC31}, {0xAC32, 0xAC32, 0xAC32},
    {0xAC33, 0xAC33, 0xAC33}, {0xAC34, 0xAC34, 0xAC34},
    {0xAC35, 0xAC35, 0xAC35}, {0xAC36, 0xAC36, 0xAC36},
    {0xAC37, 0xAC37, 0xAC37}, {0xAC38, 0xAC38, 0xAC38},
    {0xAC39, 0xAC39, 0xAC39}, {0xAC3A, 0xAC3A, 0xAC3A},
    {0xAC3B, 0xAC3B, 0xAC3B}, {0xAC3C, 0xAC3C, 0xAC3C},
    {0xAC3D, 0xAC3D, 0xAC3D}, {0xAC3E, 0xAC3E, 0xAC3E},
    {0xAC3F, 0xAC3F, 0xAC3F}, {0xAC40, 0xAC40, 0xAC40},
    {0xAC41, 0xAC41, 0xAC41}, {0xAC42, 0xAC42, 0xAC42},
    {0xAC43, 0xAC43, 0xAC43}, {0xAC44, 0xAC44, 0xAC44},
    {0xAC45, 0xAC45, 0xAC45}, {0xAC46, 0xAC46, 0xAC46},
    {0xAC47, 0xAC47, 0xAC47}, {0xAC48, 0xAC48, 0xAC48},
    {0xAC49, 0xAC49, 0xAC49}, {0xAC4A, 0xAC4A, 0xAC4A},
    {0xAC4B, 0xAC4B, 0xAC4B}, {0xAC4C, 0xAC4C, 0xAC4C},
    {0xAC4D, 0xAC4D, 0xAC4D}, {0xAC4E, 0xAC4E, 0xAC4E},
    {0xAC4F, 0xAC4F, 0xAC4F}, {0xAC50, 0xAC50, 0xAC50},
    {0xAC51, 0xAC51, 0xAC51}, {0xAC52, 0xAC52, 0xAC52},
    {0xAC53, 0xAC53, 0xAC53}, {0xAC54, 0xAC54, 0xAC54},
    {0xAC55, 0xAC55, 0xAC55}, {0xAC56, 0xAC56, 0xAC56},
    {0xAC57, 0xAC57, 0xAC57}, {0xAC58, 0xAC58, 0xAC58},
    {0xAC59, 0xAC59, 0xAC59}, {0xAC5A, 0xAC5A, 0xAC5A},
    {0xAC5B, 0xAC5B, 0xAC5B}, {0xAC5C, 0xAC5C, 0xAC5C},
    {0xAC5D, 0xAC5D, 0xAC5D}, {0xAC5E, 0xAC5E, 0xAC5E},
    {0xAC5F, 0xAC5F, 0xAC5F}, {0xAC60, 0xAC60, 0xAC60},
    {0xAC61, 0xAC61, 0xAC61}, {0xAC62, 0xAC62, 0xAC62},
    {0xAC63, 0xAC63, 0xAC63}, {0xAC64, 0xAC64, 0xAC64},
    {0xAC65, 0xAC65, 0xAC65}, {0xAC66, 0xAC66, 0xAC66},
    {0xAC67, 0xAC67, 0xAC67}, {0xAC68, 0xAC68, 0xAC68},
    {0xAC69, 0xAC69, 0xAC69}, {0xAC6A, 0xAC6A, 0xAC6A},
    {0xAC6B, 0xAC6B, 0xAC6B}, {0xAC6C, 0xAC6C, 0xAC6C},
    {0xAC6D, 0xAC6D, 0xAC6D}, {0xAC6E, 0xAC6E, 0xAC6E},
    {0xAC6F, 0xAC6F, 0xAC6F}, {0xAC70, 0xAC70, 0xAC70},
    {0xAC71, 0xAC71, 0xAC71}, {0xAC72, 0xAC72, 0xAC72},
    {0xAC73, 0xAC73, 0xAC73}, {0xAC74, 0xAC74, 0xAC74},
    {0xAC75, 0xAC75, 0xAC75}, {0xAC76, 0xAC76, 0xAC76},
    {0xAC77, 0xAC77, 0xAC77}, {0xAC78, 0xAC78, 0xAC78},
    {0xAC79, 0xAC79, 0xAC79}, {0xAC7A, 0xAC7A, 0xAC7A},
    {0xAC7B, 0xAC7B, 0xAC7B}, {0xAC7C, 0xAC7C, 0xAC7C},
    {0xAC7D, 0xAC7D, 0xAC7D}, {0xAC7E, 0xAC7E, 0xAC7E},
    {0xAC7F, 0xAC7F, 0xAC7F}, {0xAC80, 0xAC80, 0xAC80},
    {0xAC81, 0xAC81, 0xAC81}, {0xAC82, 0xAC82, 0xAC82},
    {0xAC83, 0xAC83, 0xAC83}, {0xAC84, 0xAC84, 0xAC84},
    {0xAC85, 0xAC85, 0xAC85}, {0xAC86, 0xAC86, 0xAC86},
    {0xAC87, 0xAC87, 0xAC87}, {0xAC88, 0xAC88, 0xAC88},
    {0xAC89, 0xAC89, 0xAC89}, {0xAC8A, 0xAC8A, 0xAC8A},
    {0xAC8B, 0xAC8B, 0xAC8B}, {0xAC8C, 0xAC8C, 0xAC8C},
    {0xAC8D, 0xAC8D, 0xAC8D}, {0xAC8E, 0xAC8E, 0xAC8E},
    {0xAC8F, 0xAC8F, 0xAC8F}, {0xAC90, 0xAC90, 0xAC90},
    {0xAC91, 0xAC91, 0xAC91}, {0xAC92, 0xAC92, 0xAC92},
    {0xAC93, 0xAC93, 0xAC93}, {0xAC94, 0xAC94, 0xAC94},
    {0xAC95, 0xAC95, 0xAC95}, {0xAC96, 0xAC96, 0xAC96},
    {0xAC97, 0xAC97, 0xAC97}, {0xAC98, 0xAC98, 0xAC98},
    {0xAC99, 0xAC99, 0xAC99}, {0xAC9A, 0xAC9A, 0xAC9A},
    {0xAC9B, 0xAC9B, 0xAC9B}, {0xAC9C, 0xAC9C, 0xAC9C},
    {0xAC9D, 0xAC9D, 0xAC9D}, {0xAC9E, 0xAC9E, 0xAC9E},
    {0xAC9F, 0xAC9F, 0xAC9F}, {0xACA0, 0xACA0, 0xACA0},
    {0xACA1, 0xACA1, 0xACA1}, {0xACA2, 0xACA2, 0xACA2},
    {0xACA3, 0xACA3, 0xACA3}, {0xACA4, 0xACA4, 0xACA4},
    {0xACA5, 0xACA5, 0xACA5}, {0xACA6, 0xACA6, 0xACA6},
    {0xACA7, 0xACA7, 0xACA7}, {0xACA8, 0xACA8, 0xACA8},
    {0xACA9, 0xACA9, 0xACA9}, {0xACAA, 0xACAA, 0xACAA},
    {0xACAB, 0xACAB, 0xACAB}, {0xACAC, 0xACAC, 0xACAC},
    {0xACAD, 0xACAD, 0xACAD}, {0xACAE, 0xACAE, 0xACAE},
    {0xACAF, 0xACAF, 0xACAF}, {0xACB0, 0xACB0, 0xACB0},
    {0xACB1, 0xACB1, 0xACB1}, {0xACB2, 0xACB2, 0xACB2},
    {0xACB3, 0xACB3, 0xACB3}, {0xACB4, 0xACB4, 0xACB4},
    {0xACB5, 0xACB5, 0xACB5}, {0xACB6, 0xACB6, 0xACB6},
    {0xACB7, 0xACB7, 0xACB7}, {0xACB8, 0xACB8, 0xACB8},
    {0xACB9, 0xACB9, 0xACB9}, {0xACBA, 0xACBA, 0xACBA},
    {0xACBB, 0xACBB, 0xACBB}, {0xACBC, 0xACBC, 0xACBC},
    {0xACBD, 0xACBD, 0xACBD}, {0xACBE, 0xACBE, 0xACBE},
    {0xACBF, 0xACBF, 0xACBF}, {0xACC0, 0xACC0, 0xACC0},
    {0xACC1, 0xACC1, 0xACC1}, {0xACC2, 0xACC2, 0xACC2},
    {0xACC3, 0xACC3, 0xACC3}, {0xACC4, 0xACC4, 0xACC4},
    {0xACC5, 0xACC5, 0xACC5}, {0xACC6, 0xACC6, 0xACC6},
    {0xACC7, 0xACC7, 0xACC7}, {0xACC8, 0xACC8, 0xACC8},
    {0xACC9, 0xACC9, 0xACC9}, {0xACCA, 0xACCA, 0xACCA},
    {0xACCB, 0xACCB, 0xACCB}, {0xACCC, 0xACCC, 0xACCC},
    {0xACCD, 0xACCD, 0xACCD}, {0xACCE, 0xACCE, 0xACCE},
    {0xACCF, 0xACCF, 0xACCF}, {0xACD0, 0xACD0, 0xACD0},
    {0xACD1, 0xACD1, 0xACD1}, {0xACD2, 0xACD2, 0xACD2},
    {0xACD3, 0xACD3, 0xACD3}, {0xACD4, 0xACD4, 0xACD4},
    {0xACD5, 0xACD5, 0xACD5}, {0xACD6, 0xACD6, 0xACD6},
    {0xACD7, 0xACD7, 0xACD7}, {0xACD8, 0xACD8, 0xACD8},
    {0xACD9, 0xACD9, 0xACD9}, {0xACDA, 0xACDA, 0xACDA},
    {0xACDB, 0xACDB, 0xACDB}, {0xACDC, 0xACDC, 0xACDC},
    {0xACDD, 0xACDD, 0xACDD}, {0xACDE, 0xACDE, 0xACDE},
    {0xACDF, 0xACDF, 0xACDF}, {0xACE0, 0xACE0, 0xACE0},
    {0xACE1, 0xACE1, 0xACE1}, {0xACE2, 0xACE2, 0xACE2},
    {0xACE3, 0xACE3, 0xACE3}, {0xACE4, 0xACE4, 0xACE4},
    {0xACE5, 0xACE5, 0xACE5}, {0xACE6, 0xACE6, 0xACE6},
    {0xACE7, 0xACE7, 0xACE7}, {0xACE8, 0xACE8, 0xACE8},
    {0xACE9, 0xACE9, 0xACE9}, {0xACEA, 0xACEA, 0xACEA},
    {0xACEB, 0xACEB, 0xACEB}, {0xACEC, 0xACEC, 0xACEC},
    {0xACED, 0xACED, 0xACED}, {0xACEE, 0xACEE, 0xACEE},
    {0xACEF, 0xACEF, 0xACEF}, {0xACF0, 0xACF0, 0xACF0},
    {0xACF1, 0xACF1, 0xACF1}, {0xACF2, 0xACF2, 0xACF2},
    {0xACF3, 0xACF3, 0xACF3}, {0xACF4, 0xACF4, 0xACF4},
    {0xACF5, 0xACF5, 0xACF5}, {0xACF6, 0xACF6, 0xACF6},
    {0xACF7, 0xACF7, 0xACF7}, {0xACF8, 0xACF8, 0xACF8},
    {0xACF9, 0xACF9, 0xACF9}, {0xACFA, 0xACFA, 0xACFA},
    {0xACFB, 0xACFB, 0xACFB}, {0xACFC, 0xACFC, 0xACFC},
    {0xACFD, 0xACFD, 0xACFD}, {0xACFE, 0xACFE, 0xACFE},
    {0xACFF, 0xACFF, 0xACFF}, {0xAD00, 0xAD00, 0xAD00},
    {0xAD01, 0xAD01, 0xAD01}, {0xAD02, 0xAD02, 0xAD02},
    {0xAD03, 0xAD03, 0xAD03}, {0xAD04, 0xAD04, 0xAD04},
    {0xAD05, 0xAD05, 0xAD05}, {0xAD06, 0xAD06, 0xAD06},
    {0xAD07, 0xAD07, 0xAD07}, {0xAD08, 0xAD08, 0xAD08},
    {0xAD09, 0xAD09, 0xAD09}, {0xAD0A, 0xAD0A, 0xAD0A},
    {0xAD0B, 0xAD0B, 0xAD0B}, {0xAD0C, 0xAD0C, 0xAD0C},
    {0xAD0D, 0xAD0D, 0xAD0D}, {0xAD0E, 0xAD0E, 0xAD0E},
    {0xAD0F, 0xAD0F, 0xAD0F}, {0xAD10, 0xAD10, 0xAD10},
    {0xAD11, 0xAD11, 0xAD11}, {0xAD12, 0xAD12, 0xAD12},
    {0xAD13, 0xAD13, 0xAD13}, {0xAD14, 0xAD14, 0xAD14},
    {0xAD15, 0xAD15, 0xAD15}, {0xAD16, 0xAD16, 0xAD16},
    {0xAD17, 0xAD17, 0xAD17}, {0xAD18, 0xAD18, 0xAD18},
    {0xAD19, 0xAD19, 0xAD19}, {0xAD1A, 0xAD1A, 0xAD1A},
    {0xAD1B, 0xAD1B, 0xAD1B}, {0xAD1C, 0xAD1C, 0xAD1C},
    {0xAD1D, 0xAD1D, 0xAD1D}, {0xAD1E, 0xAD1E, 0xAD1E},
    {0xAD1F, 0xAD1F, 0xAD1F}, {0xAD20, 0xAD20, 0xAD20},
    {0xAD21, 0xAD21, 0xAD21}, {0xAD22, 0xAD22, 0xAD22},
    {0xAD23, 0xAD23, 0xAD23}, {0xAD24, 0xAD24, 0xAD24},
    {0xAD25, 0xAD25, 0xAD25}, {0xAD26, 0xAD26, 0xAD26},
    {0xAD27, 0xAD27, 0xAD27}, {0xAD28, 0xAD28, 0xAD28},
    {0xAD29, 0xAD29, 0xAD29}, {0xAD2A, 0xAD2A, 0xAD2A},
    {0xAD2B, 0xAD2B, 0xAD2B}, {0xAD2C, 0xAD2C, 0xAD2C},
    {0xAD2D, 0xAD2D, 0xAD2D}, {0xAD2E, 0xAD2E, 0xAD2E},
    {0xAD2F, 0xAD2F, 0xAD2F}, {0xAD30, 0xAD30, 0xAD30},
    {0xAD31, 0xAD31, 0xAD31}, {0xAD32, 0xAD32, 0xAD32},
    {0xAD33, 0xAD33, 0xAD33}, {0xAD34, 0xAD34, 0xAD34},
    {0xAD35, 0xAD35, 0xAD35}, {0xAD36, 0xAD36, 0xAD36},
    {0xAD37, 0xAD37, 0xAD37}, {0xAD38, 0xAD38, 0xAD38},
    {0xAD39, 0xAD39, 0xAD39}, {0xAD3A, 0xAD3A, 0xAD3A},
    {0xAD3B, 0xAD3B, 0xAD3B}, {0xAD3C, 0xAD3C, 0xAD3C},
    {0xAD3D, 0xAD3D, 0xAD3D}, {0xAD3E, 0xAD3E, 0xAD3E},
    {0xAD3F, 0xAD3F, 0xAD3F}, {0xAD40, 0xAD40, 0xAD40},
    {0xAD41, 0xAD41, 0xAD41}, {0xAD42, 0xAD42, 0xAD42},
    {0xAD43, 0xAD43, 0xAD43}, {0xAD44, 0xAD44, 0xAD44},
    {0xAD45, 0xAD45, 0xAD45}, {0xAD46, 0xAD46, 0xAD46},
    {0xAD47, 0xAD47, 0xAD47}, {0xAD48, 0xAD48, 0xAD48},
    {0xAD49, 0xAD49, 0xAD49}, {0xAD4A, 0xAD4A, 0xAD4A},
    {0xAD4B, 0xAD4B, 0xAD4B}, {0xAD4C, 0xAD4C, 0xAD4C},
    {0xAD4D, 0xAD4D, 0xAD4D}, {0xAD4E, 0xAD4E, 0xAD4E},
    {0xAD4F, 0xAD4F, 0xAD4F}, {0xAD50, 0xAD50, 0xAD50},
    {0xAD51, 0xAD51, 0xAD51}, {0xAD52, 0xAD52, 0xAD52},
    {0xAD53, 0xAD53, 0xAD53}, {0xAD54, 0xAD54, 0xAD54},
    {0xAD55, 0xAD55, 0xAD55}, {0xAD56, 0xAD56, 0xAD56},
    {0xAD57, 0xAD57, 0xAD57}, {0xAD58, 0xAD58, 0xAD58},
    {0xAD59, 0xAD59, 0xAD59}, {0xAD5A, 0xAD5A, 0xAD5A},
    {0xAD5B, 0xAD5B, 0xAD5B}, {0xAD5C, 0xAD5C, 0xAD5C},
    {0xAD5D, 0xAD5D, 0xAD5D}, {0xAD5E, 0xAD5E, 0xAD5E},
    {0xAD5F, 0xAD5F, 0xAD5F}, {0xAD60, 0xAD60, 0xAD60},
    {0xAD61, 0xAD61, 0xAD61}, {0xAD62, 0xAD62, 0xAD62},
    {0xAD63, 0xAD63, 0xAD63}, {0xAD64, 0xAD64, 0xAD64},
    {0xAD65, 0xAD65, 0xAD65}, {0xAD66, 0xAD66, 0xAD66},
    {0xAD67, 0xAD67, 0xAD67}, {0xAD68, 0xAD68, 0xAD68},
    {0xAD69, 0xAD69, 0xAD69}, {0xAD6A, 0xAD6A, 0xAD6A},
    {0xAD6B, 0xAD6B, 0xAD6B}, {0xAD6C, 0xAD6C, 0xAD6C},
    {0xAD6D, 0xAD6D, 0xAD6D}, {0xAD6E, 0xAD6E, 0xAD6E},
    {0xAD6F, 0xAD6F, 0xAD6F}, {0xAD70, 0xAD70, 0xAD70},
    {0xAD71, 0xAD71, 0xAD71}, {0xAD72, 0xAD72, 0xAD72},
    {0xAD73, 0xAD73, 0xAD73}, {0xAD74, 0xAD74, 0xAD74},
    {0xAD75, 0xAD75, 0xAD75}, {0xAD76, 0xAD76, 0xAD76},
    {0xAD77, 0xAD77, 0xAD77}, {0xAD78, 0xAD78, 0xAD78},
    {0xAD79, 0xAD79, 0xAD79}, {0xAD7A, 0xAD7A, 0xAD7A},
    {0xAD7B, 0xAD7B, 0xAD7B}, {0xAD7C, 0xAD7C, 0xAD7C},
    {0xAD7D, 0xAD7D, 0xAD7D}, {0xAD7E, 0xAD7E, 0xAD7E},
    {0xAD7F, 0xAD7F, 0xAD7F}, {0xAD80, 0xAD80, 0xAD80},
    {0xAD81, 0xAD81, 0xAD81}, {0xAD82, 0xAD82, 0xAD82},
    {0xAD83, 0xAD83, 0xAD83}, {0xAD84, 0xAD84, 0xAD84},
    {0xAD85, 0xAD85, 0xAD85}, {0xAD86, 0xAD86, 0xAD86},
    {0xAD87, 0xAD87, 0xAD87}, {0xAD88, 0xAD88, 0xAD88},
    {0xAD89, 0xAD89, 0xAD89}, {0xAD8A, 0xAD8A, 0xAD8A},
    {0xAD8B, 0xAD8B, 0xAD8B}, {0xAD8C, 0xAD8C, 0xAD8C},
    {0xAD8D, 0xAD8D, 0xAD8D}, {0xAD8E, 0xAD8E, 0xAD8E},
    {0xAD8F, 0xAD8F, 0xAD8F}, {0xAD90, 0xAD90, 0xAD90},
    {0xAD91, 0xAD91, 0xAD91}, {0xAD92, 0xAD92, 0xAD92},
    {0xAD93, 0xAD93, 0xAD93}, {0xAD94, 0xAD94, 0xAD94},
    {0xAD95, 0xAD95, 0xAD95}, {0xAD96, 0xAD96, 0xAD96},
    {0xAD97, 0xAD97, 0xAD97}, {0xAD98, 0xAD98, 0xAD98},
    {0xAD99, 0xAD99, 0xAD99}, {0xAD9A, 0xAD9A, 0xAD9A},
    {0xAD9B, 0xAD9B, 0xAD9B}, {0xAD9C, 0xAD9C, 0xAD9C},
    {0xAD9D, 0xAD9D, 0xAD9D}, {0xAD9E, 0xAD9E, 0xAD9E},
    {0xAD9F, 0xAD9F, 0xAD9F}, {0xADA0, 0xADA0, 0xADA0},
    {0xADA1, 0xADA1, 0xADA1}, {0xADA2, 0xADA2, 0xADA2},
    {0xADA3, 0xADA3, 0xADA3}, {0xADA4, 0xADA4, 0xADA4},
    {0xADA5, 0xADA5, 0xADA5}, {0xADA6, 0xADA6, 0xADA6},
    {0xADA7, 0xADA7, 0xADA7}, {0xADA8, 0xADA8, 0xADA8},
    {0xADA9, 0xADA9, 0xADA9}, {0xADAA, 0xADAA, 0xADAA},
    {0xADAB, 0xADAB, 0xADAB}, {0xADAC, 0xADAC, 0xADAC},
    {0xADAD, 0xADAD, 0xADAD}, {0xADAE, 0xADAE, 0xADAE},
    {0xADAF, 0xADAF, 0xADAF}, {0xADB0, 0xADB0, 0xADB0},
    {0xADB1, 0xADB1, 0xADB1}, {0xADB2, 0xADB2, 0xADB2},
    {0xADB3, 0xADB3, 0xADB3}, {0xADB4, 0xADB4, 0xADB4},
    {0xADB5, 0xADB5, 0xADB5}, {0xADB6, 0xADB6, 0xADB6},
    {0xADB7, 0xADB7, 0xADB7}, {0xADB8, 0xADB8, 0xADB8},
    {0xADB9, 0xADB9, 0xADB9}, {0xADBA, 0xADBA, 0xADBA},
    {0xADBB, 0xADBB, 0xADBB}, {0xADBC, 0xADBC, 0xADBC},
    {0xADBD, 0xADBD, 0xADBD}, {0xADBE, 0xADBE, 0xADBE},
    {0xADBF, 0xADBF, 0xADBF}, {0xADC0, 0xADC0, 0xADC0},
    {0xADC1, 0xADC1, 0xADC1}, {0xADC2, 0xADC2, 0xADC2},
    {0xADC3, 0xADC3, 0xADC3}, {0xADC4, 0xADC4, 0xADC4},
    {0xADC5, 0xADC5, 0xADC5}, {0xADC6, 0xADC6, 0xADC6},
    {0xADC7, 0xADC7, 0xADC7}, {0xADC8, 0xADC8, 0xADC8},
    {0xADC9, 0xADC9, 0xADC9}, {0xADCA, 0xADCA, 0xADCA},
    {0xADCB, 0xADCB, 0xADCB}, {0xADCC, 0xADCC, 0xADCC},
    {0xADCD, 0xADCD, 0xADCD}, {0xADCE, 0xADCE, 0xADCE},
    {0xADCF, 0xADCF, 0xADCF}, {0xADD0, 0xADD0, 0xADD0},
    {0xADD1, 0xADD1, 0xADD1}, {0xADD2, 0xADD2, 0xADD2},
    {0xADD3, 0xADD3, 0xADD3}, {0xADD4, 0xADD4, 0xADD4},
    {0xADD5, 0xADD5, 0xADD5}, {0xADD6, 0xADD6, 0xADD6},
    {0xADD7, 0xADD7, 0xADD7}, {0xADD8, 0xADD8, 0xADD8},
    {0xADD9, 0xADD9, 0xADD9}, {0xADDA, 0xADDA, 0xADDA},
    {0xADDB, 0xADDB, 0xADDB}, {0xADDC, 0xADDC, 0xADDC},
    {0xADDD, 0xADDD, 0xADDD}, {0xADDE, 0xADDE, 0xADDE},
    {0xADDF, 0xADDF, 0xADDF}, {0xADE0, 0xADE0, 0xADE0},
    {0xADE1, 0xADE1, 0xADE1}, {0xADE2, 0xADE2, 0xADE2},
    {0xADE3, 0xADE3, 0xADE3}, {0xADE4, 0xADE4, 0xADE4},
    {0xADE5, 0xADE5, 0xADE5}, {0xADE6, 0xADE6, 0xADE6},
    {0xADE7, 0xADE7, 0xADE7}, {0xADE8, 0xADE8, 0xADE8},
    {0xADE9, 0xADE9, 0xADE9}, {0xADEA, 0xADEA, 0xADEA},
    {0xADEB, 0xADEB, 0xADEB}, {0xADEC, 0xADEC, 0xADEC},
    {0xADED, 0xADED, 0xADED}, {0xADEE, 0xADEE, 0xADEE},
    {0xADEF, 0xADEF, 0xADEF}, {0xADF0, 0xADF0, 0xADF0},
    {0xADF1, 0xADF1, 0xADF1}, {0xADF2, 0xADF2, 0xADF2},
    {0xADF3, 0xADF3, 0xADF3}, {0xADF4, 0xADF4, 0xADF4},
    {0xADF5, 0xADF5, 0xADF5}, {0xADF6, 0xADF6, 0xADF6},
    {0xADF7, 0xADF7, 0xADF7}, {0xADF8, 0xADF8, 0xADF8},
    {0xADF9, 0xADF9, 0xADF9}, {0xADFA, 0xADFA, 0xADFA},
    {0xADFB, 0xADFB, 0xADFB}, {0xADFC, 0xADFC, 0xADFC},
    {0xADFD, 0xADFD, 0xADFD}, {0xADFE, 0xADFE, 0xADFE},
    {0xADFF, 0xADFF, 0xADFF}, {0xAE00, 0xAE00, 0xAE00},
    {0xAE01, 0xAE01, 0xAE01}, {0xAE02, 0xAE02, 0xAE02},
    {0xAE03, 0xAE03, 0xAE03}, {0xAE04, 0xAE04, 0xAE04},
    {0xAE05, 0xAE05, 0xAE05}, {0xAE06, 0xAE06, 0xAE06},
    {0xAE07, 0xAE07, 0xAE07}, {0xAE08, 0xAE08, 0xAE08},
    {0xAE09, 0xAE09, 0xAE09}, {0xAE0A, 0xAE0A, 0xAE0A},
    {0xAE0B, 0xAE0B, 0xAE0B}, {0xAE0C, 0xAE0C, 0xAE0C},
    {0xAE0D, 0xAE0D, 0xAE0D}, {0xAE0E, 0xAE0E, 0xAE0E},
    {0xAE0F, 0xAE0F, 0xAE0F}, {0xAE10, 0xAE10, 0xAE10},
    {0xAE11, 0xAE11, 0xAE11}, {0xAE12, 0xAE12, 0xAE12},
    {0xAE13, 0xAE13, 0xAE13}, {0xAE14, 0xAE14, 0xAE14},
    {0xAE15, 0xAE15, 0xAE15}, {0xAE16, 0xAE16, 0xAE16},
    {0xAE17, 0xAE17, 0xAE17}, {0xAE18, 0xAE18, 0xAE18},
    {0xAE19, 0xAE19, 0xAE19}, {0xAE1A, 0xAE1A, 0xAE1A},
    {0xAE1B, 0xAE1B, 0xAE1B}, {0xAE1C, 0xAE1C, 0xAE1C},
    {0xAE1D, 0xAE1D, 0xAE1D}, {0xAE1E, 0xAE1E, 0xAE1E},
    {0xAE1F, 0xAE1F, 0xAE1F}, {0xAE20, 0xAE20, 0xAE20},
    {0xAE21, 0xAE21, 0xAE21}, {0xAE22, 0xAE22, 0xAE22},
    {0xAE23, 0xAE23, 0xAE23}, {0xAE24, 0xAE24, 0xAE24},
    {0xAE25, 0xAE25, 0xAE25}, {0xAE26, 0xAE26, 0xAE26},
    {0xAE27, 0xAE27, 0xAE27}, {0xAE28, 0xAE28, 0xAE28},
    {0xAE29, 0xAE29, 0xAE29}, {0xAE2A, 0xAE2A, 0xAE2A},
    {0xAE2B, 0xAE2B, 0xAE2B}, {0xAE2C, 0xAE2C, 0xAE2C},
    {0xAE2D, 0xAE2D, 0xAE2D}, {0xAE2E, 0xAE2E, 0xAE2E},
    {0xAE2F, 0xAE2F, 0xAE2F}, {0xAE30, 0xAE30, 0xAE30},
    {0xAE31, 0xAE31, 0xAE31}, {0xAE32, 0xAE32, 0xAE32},
    {0xAE33, 0xAE33, 0xAE33}, {0xAE34, 0xAE34, 0xAE34},
    {0xAE35, 0xAE35, 0xAE35}, {0xAE36, 0xAE36, 0xAE36},
    {0xAE37, 0xAE37, 0xAE37}, {0xAE38, 0xAE38, 0xAE38},
    {0xAE39, 0xAE39, 0xAE39}, {0xAE3A, 0xAE3A, 0xAE3A},
    {0xAE3B, 0xAE3B, 0xAE3B}, {0xAE3C, 0xAE3C, 0xAE3C},
    {0xAE3D, 0xAE3D, 0xAE3D}, {0xAE3E, 0xAE3E, 0xAE3E},
    {0xAE3F, 0xAE3F, 0xAE3F}, {0xAE40, 0xAE40, 0xAE40},
    {0xAE41, 0xAE41, 0xAE41}, {0xAE42, 0xAE42, 0xAE42},
    {0xAE43, 0xAE43, 0xAE43}, {0xAE44, 0xAE44, 0xAE44},
    {0xAE45, 0xAE45, 0xAE45}, {0xAE46, 0xAE46, 0xAE46},
    {0xAE47, 0xAE47, 0xAE47}, {0xAE48, 0xAE48, 0xAE48},
    {0xAE49, 0xAE49, 0xAE49}, {0xAE4A, 0xAE4A, 0xAE4A},
    {0xAE4B, 0xAE4B, 0xAE4B}, {0xAE4C, 0xAE4C, 0xAE4C},
    {0xAE4D, 0xAE4D, 0xAE4D}, {0xAE4E, 0xAE4E, 0xAE4E},
    {0xAE4F, 0xAE4F, 0xAE4F}, {0xAE50, 0xAE50, 0xAE50},
    {0xAE51, 0xAE51, 0xAE51}, {0xAE52, 0xAE52, 0xAE52},
    {0xAE53, 0xAE53, 0xAE53}, {0xAE54, 0xAE54, 0xAE54},
    {0xAE55, 0xAE55, 0xAE55}, {0xAE56, 0xAE56, 0xAE56},
    {0xAE57, 0xAE57, 0xAE57}, {0xAE58, 0xAE58, 0xAE58},
    {0xAE59, 0xAE59, 0xAE59}, {0xAE5A, 0xAE5A, 0xAE5A},
    {0xAE5B, 0xAE5B, 0xAE5B}, {0xAE5C, 0xAE5C, 0xAE5C},
    {0xAE5D, 0xAE5D, 0xAE5D}, {0xAE5E, 0xAE5E, 0xAE5E},
    {0xAE5F, 0xAE5F, 0xAE5F}, {0xAE60, 0xAE60, 0xAE60},
    {0xAE61, 0xAE61, 0xAE61}, {0xAE62, 0xAE62, 0xAE62},
    {0xAE63, 0xAE63, 0xAE63}, {0xAE64, 0xAE64, 0xAE64},
    {0xAE65, 0xAE65, 0xAE65}, {0xAE66, 0xAE66, 0xAE66},
    {0xAE67, 0xAE67, 0xAE67}, {0xAE68, 0xAE68, 0xAE68},
    {0xAE69, 0xAE69, 0xAE69}, {0xAE6A, 0xAE6A, 0xAE6A},
    {0xAE6B, 0xAE6B, 0xAE6B}, {0xAE6C, 0xAE6C, 0xAE6C},
    {0xAE6D, 0xAE6D, 0xAE6D}, {0xAE6E, 0xAE6E, 0xAE6E},
    {0xAE6F, 0xAE6F, 0xAE6F}, {0xAE70, 0xAE70, 0xAE70},
    {0xAE71, 0xAE71, 0xAE71}, {0xAE72, 0xAE72, 0xAE72},
    {0xAE73, 0xAE73, 0xAE73}, {0xAE74, 0xAE74, 0xAE74},
    {0xAE75, 0xAE75, 0xAE75}, {0xAE76, 0xAE76, 0xAE76},
    {0xAE77, 0xAE77, 0xAE77}, {0xAE78, 0xAE78, 0xAE78},
    {0xAE79, 0xAE79, 0xAE79}, {0xAE7A, 0xAE7A, 0xAE7A},
    {0xAE7B, 0xAE7B, 0xAE7B}, {0xAE7C, 0xAE7C, 0xAE7C},
    {0xAE7D, 0xAE7D, 0xAE7D}, {0xAE7E, 0xAE7E, 0xAE7E},
    {0xAE7F, 0xAE7F, 0xAE7F}, {0xAE80, 0xAE80, 0xAE80},
    {0xAE81, 0xAE81, 0xAE81}, {0xAE82, 0xAE82, 0xAE82},
    {0xAE83, 0xAE83, 0xAE83}, {0xAE84, 0xAE84, 0xAE84},
    {0xAE85, 0xAE85, 0xAE85}, {0xAE86, 0xAE86, 0xAE86},
    {0xAE87, 0xAE87, 0xAE87}, {0xAE88, 0xAE88, 0xAE88},
    {0xAE89, 0xAE89, 0xAE89}, {0xAE8A, 0xAE8A, 0xAE8A},
    {0xAE8B, 0xAE8B, 0xAE8B}, {0xAE8C, 0xAE8C, 0xAE8C},
    {0xAE8D, 0xAE8D, 0xAE8D}, {0xAE8E, 0xAE8E, 0xAE8E},
    {0xAE8F, 0xAE8F, 0xAE8F}, {0xAE90, 0xAE90, 0xAE90},
    {0xAE91, 0xAE91, 0xAE91}, {0xAE92, 0xAE92, 0xAE92},
    {0xAE93, 0xAE93, 0xAE93}, {0xAE94, 0xAE94, 0xAE94},
    {0xAE95, 0xAE95, 0xAE95}, {0xAE96, 0xAE96, 0xAE96},
    {0xAE97, 0xAE97, 0xAE97}, {0xAE98, 0xAE98, 0xAE98},
    {0xAE99, 0xAE99, 0xAE99}, {0xAE9A, 0xAE9A, 0xAE9A},
    {0xAE9B, 0xAE9B, 0xAE9B}, {0xAE9C, 0xAE9C, 0xAE9C},
    {0xAE9D, 0xAE9D, 0xAE9D}, {0xAE9E, 0xAE9E, 0xAE9E},
    {0xAE9F, 0xAE9F, 0xAE9F}, {0xAEA0, 0xAEA0, 0xAEA0},
    {0xAEA1, 0xAEA1, 0xAEA1}, {0xAEA2, 0xAEA2, 0xAEA2},
    {0xAEA3, 0xAEA3, 0xAEA3}, {0xAEA4, 0xAEA4, 0xAEA4},
    {0xAEA5, 0xAEA5, 0xAEA5}, {0xAEA6, 0xAEA6, 0xAEA6},
    {0xAEA7, 0xAEA7, 0xAEA7}, {0xAEA8, 0xAEA8, 0xAEA8},
    {0xAEA9, 0xAEA9, 0xAEA9}, {0xAEAA, 0xAEAA, 0xAEAA},
    {0xAEAB, 0xAEAB, 0xAEAB}, {0xAEAC, 0xAEAC, 0xAEAC},
    {0xAEAD, 0xAEAD, 0xAEAD}, {0xAEAE, 0xAEAE, 0xAEAE},
    {0xAEAF, 0xAEAF, 0xAEAF}, {0xAEB0, 0xAEB0, 0xAEB0},
    {0xAEB1, 0xAEB1, 0xAEB1}, {0xAEB2, 0xAEB2, 0xAEB2},
    {0xAEB3, 0xAEB3, 0xAEB3}, {0xAEB4, 0xAEB4, 0xAEB4},
    {0xAEB5, 0xAEB5, 0xAEB5}, {0xAEB6, 0xAEB6, 0xAEB6},
    {0xAEB7, 0xAEB7, 0xAEB7}, {0xAEB8, 0xAEB8, 0xAEB8},
    {0xAEB9, 0xAEB9, 0xAEB9}, {0xAEBA, 0xAEBA, 0xAEBA},
    {0xAEBB, 0xAEBB, 0xAEBB}, {0xAEBC, 0xAEBC, 0xAEBC},
    {0xAEBD, 0xAEBD, 0xAEBD}, {0xAEBE, 0xAEBE, 0xAEBE},
    {0xAEBF, 0xAEBF, 0xAEBF}, {0xAEC0, 0xAEC0, 0xAEC0},
    {0xAEC1, 0xAEC1, 0xAEC1}, {0xAEC2, 0xAEC2, 0xAEC2},
    {0xAEC3, 0xAEC3, 0xAEC3}, {0xAEC4, 0xAEC4, 0xAEC4},
    {0xAEC5, 0xAEC5, 0xAEC5}, {0xAEC6, 0xAEC6, 0xAEC6},
    {0xAEC7, 0xAEC7, 0xAEC7}, {0xAEC8, 0xAEC8, 0xAEC8},
    {0xAEC9, 0xAEC9, 0xAEC9}, {0xAECA, 0xAECA, 0xAECA},
    {0xAECB, 0xAECB, 0xAECB}, {0xAECC, 0xAECC, 0xAECC},
    {0xAECD, 0xAECD, 0xAECD}, {0xAECE, 0xAECE, 0xAECE},
    {0xAECF, 0xAECF, 0xAECF}, {0xAED0, 0xAED0, 0xAED0},
    {0xAED1, 0xAED1, 0xAED1}, {0xAED2, 0xAED2, 0xAED2},
    {0xAED3, 0xAED3, 0xAED3}, {0xAED4, 0xAED4, 0xAED4},
    {0xAED5, 0xAED5, 0xAED5}, {0xAED6, 0xAED6, 0xAED6},
    {0xAED7, 0xAED7, 0xAED7}, {0xAED8, 0xAED8, 0xAED8},
    {0xAED9, 0xAED9, 0xAED9}, {0xAEDA, 0xAEDA, 0xAEDA},
    {0xAEDB, 0xAEDB, 0xAEDB}, {0xAEDC, 0xAEDC, 0xAEDC},
    {0xAEDD, 0xAEDD, 0xAEDD}, {0xAEDE, 0xAEDE, 0xAEDE},
    {0xAEDF, 0xAEDF, 0xAEDF}, {0xAEE0, 0xAEE0, 0xAEE0},
    {0xAEE1, 0xAEE1, 0xAEE1}, {0xAEE2, 0xAEE2, 0xAEE2},
    {0xAEE3, 0xAEE3, 0xAEE3}, {0xAEE4, 0xAEE4, 0xAEE4},
    {0xAEE5, 0xAEE5, 0xAEE5}, {0xAEE6, 0xAEE6, 0xAEE6},
    {0xAEE7, 0xAEE7, 0xAEE7}, {0xAEE8, 0xAEE8, 0xAEE8},
    {0xAEE9, 0xAEE9, 0xAEE9}, {0xAEEA, 0xAEEA, 0xAEEA},
    {0xAEEB, 0xAEEB, 0xAEEB}, {0xAEEC, 0xAEEC, 0xAEEC},
    {0xAEED, 0xAEED, 0xAEED}, {0xAEEE, 0xAEEE, 0xAEEE},
    {0xAEEF, 0xAEEF, 0xAEEF}, {0xAEF0, 0xAEF0, 0xAEF0},
    {0xAEF1, 0xAEF1, 0xAEF1}, {0xAEF2, 0xAEF2, 0xAEF2},
    {0xAEF3, 0xAEF3, 0xAEF3}, {0xAEF4, 0xAEF4, 0xAEF4},
    {0xAEF5, 0xAEF5, 0xAEF5}, {0xAEF6, 0xAEF6, 0xAEF6},
    {0xAEF7, 0xAEF7, 0xAEF7}, {0xAEF8, 0xAEF8, 0xAEF8},
    {0xAEF9, 0xAEF9, 0xAEF9}, {0xAEFA, 0xAEFA, 0xAEFA},
    {0xAEFB, 0xAEFB, 0xAEFB}, {0xAEFC, 0xAEFC, 0xAEFC},
    {0xAEFD, 0xAEFD, 0xAEFD}, {0xAEFE, 0xAEFE, 0xAEFE},
    {0xAEFF, 0xAEFF, 0xAEFF}, {0xAF00, 0xAF00, 0xAF00},
    {0xAF01, 0xAF01, 0xAF01}, {0xAF02, 0xAF02, 0xAF02},
    {0xAF03, 0xAF03, 0xAF03}, {0xAF04, 0xAF04, 0xAF04},
    {0xAF05, 0xAF05, 0xAF05}, {0xAF06, 0xAF06, 0xAF06},
    {0xAF07, 0xAF07, 0xAF07}, {0xAF08, 0xAF08, 0xAF08},
    {0xAF09, 0xAF09, 0xAF09}, {0xAF0A, 0xAF0A, 0xAF0A},
    {0xAF0B, 0xAF0B, 0xAF0B}, {0xAF0C, 0xAF0C, 0xAF0C},
    {0xAF0D, 0xAF0D, 0xAF0D}, {0xAF0E, 0xAF0E, 0xAF0E},
    {0xAF0F, 0xAF0F, 0xAF0F}, {0xAF10, 0xAF10, 0xAF10},
    {0xAF11, 0xAF11, 0xAF11}, {0xAF12, 0xAF12, 0xAF12},
    {0xAF13, 0xAF13, 0xAF13}, {0xAF14, 0xAF14, 0xAF14},
    {0xAF15, 0xAF15, 0xAF15}, {0xAF16, 0xAF16, 0xAF16},
    {0xAF17, 0xAF17, 0xAF17}, {0xAF18, 0xAF18, 0xAF18},
    {0xAF19, 0xAF19, 0xAF19}, {0xAF1A, 0xAF1A, 0xAF1A},
    {0xAF1B, 0xAF1B, 0xAF1B}, {0xAF1C, 0xAF1C, 0xAF1C},
    {0xAF1D, 0xAF1D, 0xAF1D}, {0xAF1E, 0xAF1E, 0xAF1E},
    {0xAF1F, 0xAF1F, 0xAF1F}, {0xAF20, 0xAF20, 0xAF20},
    {0xAF21, 0xAF21, 0xAF21}, {0xAF22, 0xAF22, 0xAF22},
    {0xAF23, 0xAF23, 0xAF23}, {0xAF24, 0xAF24, 0xAF24},
    {0xAF25, 0xAF25, 0xAF25}, {0xAF26, 0xAF26, 0xAF26},
    {0xAF27, 0xAF27, 0xAF27}, {0xAF28, 0xAF28, 0xAF28},
    {0xAF29, 0xAF29, 0xAF29}, {0xAF2A, 0xAF2A, 0xAF2A},
    {0xAF2B, 0xAF2B, 0xAF2B}, {0xAF2C, 0xAF2C, 0xAF2C},
    {0xAF2D, 0xAF2D, 0xAF2D}, {0xAF2E, 0xAF2E, 0xAF2E},
    {0xAF2F, 0xAF2F, 0xAF2F}, {0xAF30, 0xAF30, 0xAF30},
    {0xAF31, 0xAF31, 0xAF31}, {0xAF32, 0xAF32, 0xAF32},
    {0xAF33, 0xAF33, 0xAF33}, {0xAF34, 0xAF34, 0xAF34},
    {0xAF35, 0xAF35, 0xAF35}, {0xAF36, 0xAF36, 0xAF36},
    {0xAF37, 0xAF37, 0xAF37}, {0xAF38, 0xAF38, 0xAF38},
    {0xAF39, 0xAF39, 0xAF39}, {0xAF3A, 0xAF3A, 0xAF3A},
    {0xAF3B, 0xAF3B, 0xAF3B}, {0xAF3C, 0xAF3C, 0xAF3C},
    {0xAF3D, 0xAF3D, 0xAF3D}, {0xAF3E, 0xAF3E, 0xAF3E},
    {0xAF3F, 0xAF3F, 0xAF3F}, {0xAF40, 0xAF40, 0xAF40},
    {0xAF41, 0xAF41, 0xAF41}, {0xAF42, 0xAF42, 0xAF42},
    {0xAF43, 0xAF43, 0xAF43}, {0xAF44, 0xAF44, 0xAF44},
    {0xAF45, 0xAF45, 0xAF45}, {0xAF46, 0xAF46, 0xAF46},
    {0xAF47, 0xAF47, 0xAF47}, {0xAF48, 0xAF48, 0xAF48},
    {0xAF49, 0xAF49, 0xAF49}, {0xAF4A, 0xAF4A, 0xAF4A},
    {0xAF4B, 0xAF4B, 0xAF4B}, {0xAF4C, 0xAF4C, 0xAF4C},
    {0xAF4D, 0xAF4D, 0xAF4D}, {0xAF4E, 0xAF4E, 0xAF4E},
    {0xAF4F, 0xAF4F, 0xAF4F}, {0xAF50, 0xAF50, 0xAF50},
    {0xAF51, 0xAF51, 0xAF51}, {0xAF52, 0xAF52, 0xAF52},
    {0xAF53, 0xAF53, 0xAF53}, {0xAF54, 0xAF54, 0xAF54},
    {0xAF55, 0xAF55, 0xAF55}, {0xAF56, 0xAF56, 0xAF56},
    {0xAF57, 0xAF57, 0xAF57}, {0xAF58, 0xAF58, 0xAF58},
    {0xAF59, 0xAF59, 0xAF59}, {0xAF5A, 0xAF5A, 0xAF5A},
    {0xAF5B, 0xAF5B, 0xAF5B}, {0xAF5C, 0xAF5C, 0xAF5C},
    {0xAF5D, 0xAF5D, 0xAF5D}, {0xAF5E, 0xAF5E, 0xAF5E},
    {0xAF5F, 0xAF5F, 0xAF5F}, {0xAF60, 0xAF60, 0xAF60},
    {0xAF61, 0xAF61, 0xAF61}, {0xAF62, 0xAF62, 0xAF62},
    {0xAF63, 0xAF63, 0xAF63}, {0xAF64, 0xAF64, 0xAF64},
    {0xAF65, 0xAF65, 0xAF65}, {0xAF66, 0xAF66, 0xAF66},
    {0xAF67, 0xAF67, 0xAF67}, {0xAF68, 0xAF68, 0xAF68},
    {0xAF69, 0xAF69, 0xAF69}, {0xAF6A, 0xAF6A, 0xAF6A},
    {0xAF6B, 0xAF6B, 0xAF6B}, {0xAF6C, 0xAF6C, 0xAF6C},
    {0xAF6D, 0xAF6D, 0xAF6D}, {0xAF6E, 0xAF6E, 0xAF6E},
    {0xAF6F, 0xAF6F, 0xAF6F}, {0xAF70, 0xAF70, 0xAF70},
    {0xAF71, 0xAF71, 0xAF71}, {0xAF72, 0xAF72, 0xAF72},
    {0xAF73, 0xAF73, 0xAF73}, {0xAF74, 0xAF74, 0xAF74},
    {0xAF75, 0xAF75, 0xAF75}, {0xAF76, 0xAF76, 0xAF76},
    {0xAF77, 0xAF77, 0xAF77}, {0xAF78, 0xAF78, 0xAF78},
    {0xAF79, 0xAF79, 0xAF79}, {0xAF7A, 0xAF7A, 0xAF7A},
    {0xAF7B, 0xAF7B, 0xAF7B}, {0xAF7C, 0xAF7C, 0xAF7C},
    {0xAF7D, 0xAF7D, 0xAF7D}, {0xAF7E, 0xAF7E, 0xAF7E},
    {0xAF7F, 0xAF7F, 0xAF7F}, {0xAF80, 0xAF80, 0xAF80},
    {0xAF81, 0xAF81, 0xAF81}, {0xAF82, 0xAF82, 0xAF82},
    {0xAF83, 0xAF83, 0xAF83}, {0xAF84, 0xAF84, 0xAF84},
    {0xAF85, 0xAF85, 0xAF85}, {0xAF86, 0xAF86, 0xAF86},
    {0xAF87, 0xAF87, 0xAF87}, {0xAF88, 0xAF88, 0xAF88},
    {0xAF89, 0xAF89, 0xAF89}, {0xAF8A, 0xAF8A, 0xAF8A},
    {0xAF8B, 0xAF8B, 0xAF8B}, {0xAF8C, 0xAF8C, 0xAF8C},
    {0xAF8D, 0xAF8D, 0xAF8D}, {0xAF8E, 0xAF8E, 0xAF8E},
    {0xAF8F, 0xAF8F, 0xAF8F}, {0xAF90, 0xAF90, 0xAF90},
    {0xAF91, 0xAF91, 0xAF91}, {0xAF92, 0xAF92, 0xAF92},
    {0xAF93, 0xAF93, 0xAF93}, {0xAF94, 0xAF94, 0xAF94},
    {0xAF95, 0xAF95, 0xAF95}, {0xAF96, 0xAF96, 0xAF96},
    {0xAF97, 0xAF97, 0xAF97}, {0xAF98, 0xAF98, 0xAF98},
    {0xAF99, 0xAF99, 0xAF99}, {0xAF9A, 0xAF9A, 0xAF9A},
    {0xAF9B, 0xAF9B, 0xAF9B}, {0xAF9C, 0xAF9C, 0xAF9C},
    {0xAF9D, 0xAF9D, 0xAF9D}, {0xAF9E, 0xAF9E, 0xAF9E},
    {0xAF9F, 0xAF9F, 0xAF9F}, {0xAFA0, 0xAFA0, 0xAFA0},
    {0xAFA1, 0xAFA1, 0xAFA1}, {0xAFA2, 0xAFA2, 0xAFA2},
    {0xAFA3, 0xAFA3, 0xAFA3}, {0xAFA4, 0xAFA4, 0xAFA4},
    {0xAFA5, 0xAFA5, 0xAFA5}, {0xAFA6, 0xAFA6, 0xAFA6},
    {0xAFA7, 0xAFA7, 0xAFA7}, {0xAFA8, 0xAFA8, 0xAFA8},
    {0xAFA9, 0xAFA9, 0xAFA9}, {0xAFAA, 0xAFAA, 0xAFAA},
    {0xAFAB, 0xAFAB, 0xAFAB}, {0xAFAC, 0xAFAC, 0xAFAC},
    {0xAFAD, 0xAFAD, 0xAFAD}, {0xAFAE, 0xAFAE, 0xAFAE},
    {0xAFAF, 0xAFAF, 0xAFAF}, {0xAFB0, 0xAFB0, 0xAFB0},
    {0xAFB1, 0xAFB1, 0xAFB1}, {0xAFB2, 0xAFB2, 0xAFB2},
    {0xAFB3, 0xAFB3, 0xAFB3}, {0xAFB4, 0xAFB4, 0xAFB4},
    {0xAFB5, 0xAFB5, 0xAFB5}, {0xAFB6, 0xAFB6, 0xAFB6},
    {0xAFB7, 0xAFB7, 0xAFB7}, {0xAFB8, 0xAFB8, 0xAFB8},
    {0xAFB9, 0xAFB9, 0xAFB9}, {0xAFBA, 0xAFBA, 0xAFBA},
    {0xAFBB, 0xAFBB, 0xAFBB}, {0xAFBC, 0xAFBC, 0xAFBC},
    {0xAFBD, 0xAFBD, 0xAFBD}, {0xAFBE, 0xAFBE, 0xAFBE},
    {0xAFBF, 0xAFBF, 0xAFBF}, {0xAFC0, 0xAFC0, 0xAFC0},
    {0xAFC1, 0xAFC1, 0xAFC1}, {0xAFC2, 0xAFC2, 0xAFC2},
    {0xAFC3, 0xAFC3, 0xAFC3}, {0xAFC4, 0xAFC4, 0xAFC4},
    {0xAFC5, 0xAFC5, 0xAFC5}, {0xAFC6, 0xAFC6, 0xAFC6},
    {0xAFC7, 0xAFC7, 0xAFC7}, {0xAFC8, 0xAFC8, 0xAFC8},
    {0xAFC9, 0xAFC9, 0xAFC9}, {0xAFCA, 0xAFCA, 0xAFCA},
    {0xAFCB, 0xAFCB, 0xAFCB}, {0xAFCC, 0xAFCC, 0xAFCC},
    {0xAFCD, 0xAFCD, 0xAFCD}, {0xAFCE, 0xAFCE, 0xAFCE},
    {0xAFCF, 0xAFCF, 0xAFCF}, {0xAFD0, 0xAFD0, 0xAFD0},
    {0xAFD1, 0xAFD1, 0xAFD1}, {0xAFD2, 0xAFD2, 0xAFD2},
    {0xAFD3, 0xAFD3, 0xAFD3}, {0xAFD4, 0xAFD4, 0xAFD4},
    {0xAFD5, 0xAFD5, 0xAFD5}, {0xAFD6, 0xAFD6, 0xAFD6},
    {0xAFD7, 0xAFD7, 0xAFD7}, {0xAFD8, 0xAFD8, 0xAFD8},
    {0xAFD9, 0xAFD9, 0xAFD9}, {0xAFDA, 0xAFDA, 0xAFDA},
    {0xAFDB, 0xAFDB, 0xAFDB}, {0xAFDC, 0xAFDC, 0xAFDC},
    {0xAFDD, 0xAFDD, 0xAFDD}, {0xAFDE, 0xAFDE, 0xAFDE},
    {0xAFDF, 0xAFDF, 0xAFDF}, {0xAFE0, 0xAFE0, 0xAFE0},
    {0xAFE1, 0xAFE1, 0xAFE1}, {0xAFE2, 0xAFE2, 0xAFE2},
    {0xAFE3, 0xAFE3, 0xAFE3}, {0xAFE4, 0xAFE4, 0xAFE4},
    {0xAFE5, 0xAFE5, 0xAFE5}, {0xAFE6, 0xAFE6, 0xAFE6},
    {0xAFE7, 0xAFE7, 0xAFE7}, {0xAFE8, 0xAFE8, 0xAFE8},
    {0xAFE9, 0xAFE9, 0xAFE9}, {0xAFEA, 0xAFEA, 0xAFEA},
    {0xAFEB, 0xAFEB, 0xAFEB}, {0xAFEC, 0xAFEC, 0xAFEC},
    {0xAFED, 0xAFED, 0xAFED}, {0xAFEE, 0xAFEE, 0xAFEE},
    {0xAFEF, 0xAFEF, 0xAFEF}, {0xAFF0, 0xAFF0, 0xAFF0},
    {0xAFF1, 0xAFF1, 0xAFF1}, {0xAFF2, 0xAFF2, 0xAFF2},
    {0xAFF3, 0xAFF3, 0xAFF3}, {0xAFF4, 0xAFF4, 0xAFF4},
    {0xAFF5, 0xAFF5, 0xAFF5}, {0xAFF6, 0xAFF6, 0xAFF6},
    {0xAFF7, 0xAFF7, 0xAFF7}, {0xAFF8, 0xAFF8, 0xAFF8},
    {0xAFF9, 0xAFF9, 0xAFF9}, {0xAFFA, 0xAFFA, 0xAFFA},
    {0xAFFB, 0xAFFB, 0xAFFB}, {0xAFFC, 0xAFFC, 0xAFFC},
    {0xAFFD, 0xAFFD, 0xAFFD}, {0xAFFE, 0xAFFE, 0xAFFE},
    {0xAFFF, 0xAFFF, 0xAFFF}, {0xB000, 0xB000, 0xB000},
    {0xB001, 0xB001, 0xB001}, {0xB002, 0xB002, 0xB002},
    {0xB003, 0xB003, 0xB003}, {0xB004, 0xB004, 0xB004},
    {0xB005, 0xB005, 0xB005}, {0xB006, 0xB006, 0xB006},
    {0xB007, 0xB007, 0xB007}, {0xB008, 0xB008, 0xB008},
    {0xB009, 0xB009, 0xB009}, {0xB00A, 0xB00A, 0xB00A},
    {0xB00B, 0xB00B, 0xB00B}, {0xB00C, 0xB00C, 0xB00C},
    {0xB00D, 0xB00D, 0xB00D}, {0xB00E, 0xB00E, 0xB00E},
    {0xB00F, 0xB00F, 0xB00F}, {0xB010, 0xB010, 0xB010},
    {0xB011, 0xB011, 0xB011}, {0xB012, 0xB012, 0xB012},
    {0xB013, 0xB013, 0xB013}, {0xB014, 0xB014, 0xB014},
    {0xB015, 0xB015, 0xB015}, {0xB016, 0xB016, 0xB016},
    {0xB017, 0xB017, 0xB017}, {0xB018, 0xB018, 0xB018},
    {0xB019, 0xB019, 0xB019}, {0xB01A, 0xB01A, 0xB01A},
    {0xB01B, 0xB01B, 0xB01B}, {0xB01C, 0xB01C, 0xB01C},
    {0xB01D, 0xB01D, 0xB01D}, {0xB01E, 0xB01E, 0xB01E},
    {0xB01F, 0xB01F, 0xB01F}, {0xB020, 0xB020, 0xB020},
    {0xB021, 0xB021, 0xB021}, {0xB022, 0xB022, 0xB022},
    {0xB023, 0xB023, 0xB023}, {0xB024, 0xB024, 0xB024},
    {0xB025, 0xB025, 0xB025}, {0xB026, 0xB026, 0xB026},
    {0xB027, 0xB027, 0xB027}, {0xB028, 0xB028, 0xB028},
    {0xB029, 0xB029, 0xB029}, {0xB02A, 0xB02A, 0xB02A},
    {0xB02B, 0xB02B, 0xB02B}, {0xB02C, 0xB02C, 0xB02C},
    {0xB02D, 0xB02D, 0xB02D}, {0xB02E, 0xB02E, 0xB02E},
    {0xB02F, 0xB02F, 0xB02F}, {0xB030, 0xB030, 0xB030},
    {0xB031, 0xB031, 0xB031}, {0xB032, 0xB032, 0xB032},
    {0xB033, 0xB033, 0xB033}, {0xB034, 0xB034, 0xB034},
    {0xB035, 0xB035, 0xB035}, {0xB036, 0xB036, 0xB036},
    {0xB037, 0xB037, 0xB037}, {0xB038, 0xB038, 0xB038},
    {0xB039, 0xB039, 0xB039}, {0xB03A, 0xB03A, 0xB03A},
    {0xB03B, 0xB03B, 0xB03B}, {0xB03C, 0xB03C, 0xB03C},
    {0xB03D, 0xB03D, 0xB03D}, {0xB03E, 0xB03E, 0xB03E},
    {0xB03F, 0xB03F, 0xB03F}, {0xB040, 0xB040, 0xB040},
    {0xB041, 0xB041, 0xB041}, {0xB042, 0xB042, 0xB042},
    {0xB043, 0xB043, 0xB043}, {0xB044, 0xB044, 0xB044},
    {0xB045, 0xB045, 0xB045}, {0xB046, 0xB046, 0xB046},
    {0xB047, 0xB047, 0xB047}, {0xB048, 0xB048, 0xB048},
    {0xB049, 0xB049, 0xB049}, {0xB04A, 0xB04A, 0xB04A},
    {0xB04B, 0xB04B, 0xB04B}, {0xB04C, 0xB04C, 0xB04C},
    {0xB04D, 0xB04D, 0xB04D}, {0xB04E, 0xB04E, 0xB04E},
    {0xB04F, 0xB04F, 0xB04F}, {0xB050, 0xB050, 0xB050},
    {0xB051, 0xB051, 0xB051}, {0xB052, 0xB052, 0xB052},
    {0xB053, 0xB053, 0xB053}, {0xB054, 0xB054, 0xB054},
    {0xB055, 0xB055, 0xB055}, {0xB056, 0xB056, 0xB056},
    {0xB057, 0xB057, 0xB057}, {0xB058, 0xB058, 0xB058},
    {0xB059, 0xB059, 0xB059}, {0xB05A, 0xB05A, 0xB05A},
    {0xB05B, 0xB05B, 0xB05B}, {0xB05C, 0xB05C, 0xB05C},
    {0xB05D, 0xB05D, 0xB05D}, {0xB05E, 0xB05E, 0xB05E},
    {0xB05F, 0xB05F, 0xB05F}, {0xB060, 0xB060, 0xB060},
    {0xB061, 0xB061, 0xB061}, {0xB062, 0xB062, 0xB062},
    {0xB063, 0xB063, 0xB063}, {0xB064, 0xB064, 0xB064},
    {0xB065, 0xB065, 0xB065}, {0xB066, 0xB066, 0xB066},
    {0xB067, 0xB067, 0xB067}, {0xB068, 0xB068, 0xB068},
    {0xB069, 0xB069, 0xB069}, {0xB06A, 0xB06A, 0xB06A},
    {0xB06B, 0xB06B, 0xB06B}, {0xB06C, 0xB06C, 0xB06C},
    {0xB06D, 0xB06D, 0xB06D}, {0xB06E, 0xB06E, 0xB06E},
    {0xB06F, 0xB06F, 0xB06F}, {0xB070, 0xB070, 0xB070},
    {0xB071, 0xB071, 0xB071}, {0xB072, 0xB072, 0xB072},
    {0xB073, 0xB073, 0xB073}, {0xB074, 0xB074, 0xB074},
    {0xB075, 0xB075, 0xB075}, {0xB076, 0xB076, 0xB076},
    {0xB077, 0xB077, 0xB077}, {0xB078, 0xB078, 0xB078},
    {0xB079, 0xB079, 0xB079}, {0xB07A, 0xB07A, 0xB07A},
    {0xB07B, 0xB07B, 0xB07B}, {0xB07C, 0xB07C, 0xB07C},
    {0xB07D, 0xB07D, 0xB07D}, {0xB07E, 0xB07E, 0xB07E},
    {0xB07F, 0xB07F, 0xB07F}, {0xB080, 0xB080, 0xB080},
    {0xB081, 0xB081, 0xB081}, {0xB082, 0xB082, 0xB082},
    {0xB083, 0xB083, 0xB083}, {0xB084, 0xB084, 0xB084},
    {0xB085, 0xB085, 0xB085}, {0xB086, 0xB086, 0xB086},
    {0xB087, 0xB087, 0xB087}, {0xB088, 0xB088, 0xB088},
    {0xB089, 0xB089, 0xB089}, {0xB08A, 0xB08A, 0xB08A},
    {0xB08B, 0xB08B, 0xB08B}, {0xB08C, 0xB08C, 0xB08C},
    {0xB08D, 0xB08D, 0xB08D}, {0xB08E, 0xB08E, 0xB08E},
    {0xB08F, 0xB08F, 0xB08F}, {0xB090, 0xB090, 0xB090},
    {0xB091, 0xB091, 0xB091}, {0xB092, 0xB092, 0xB092},
    {0xB093, 0xB093, 0xB093}, {0xB094, 0xB094, 0xB094},
    {0xB095, 0xB095, 0xB095}, {0xB096, 0xB096, 0xB096},
    {0xB097, 0xB097, 0xB097}, {0xB098, 0xB098, 0xB098},
    {0xB099, 0xB099, 0xB099}, {0xB09A, 0xB09A, 0xB09A},
    {0xB09B, 0xB09B, 0xB09B}, {0xB09C, 0xB09C, 0xB09C},
    {0xB09D, 0xB09D, 0xB09D}, {0xB09E, 0xB09E, 0xB09E},
    {0xB09F, 0xB09F, 0xB09F}, {0xB0A0, 0xB0A0, 0xB0A0},
    {0xB0A1, 0xB0A1, 0xB0A1}, {0xB0A2, 0xB0A2, 0xB0A2},
    {0xB0A3, 0xB0A3, 0xB0A3}, {0xB0A4, 0xB0A4, 0xB0A4},
    {0xB0A5, 0xB0A5, 0xB0A5}, {0xB0A6, 0xB0A6, 0xB0A6},
    {0xB0A7, 0xB0A7, 0xB0A7}, {0xB0A8, 0xB0A8, 0xB0A8},
    {0xB0A9, 0xB0A9, 0xB0A9}, {0xB0AA, 0xB0AA, 0xB0AA},
    {0xB0AB, 0xB0AB, 0xB0AB}, {0xB0AC, 0xB0AC, 0xB0AC},
    {0xB0AD, 0xB0AD, 0xB0AD}, {0xB0AE, 0xB0AE, 0xB0AE},
    {0xB0AF, 0xB0AF, 0xB0AF}, {0xB0B0, 0xB0B0, 0xB0B0},
    {0xB0B1, 0xB0B1, 0xB0B1}, {0xB0B2, 0xB0B2, 0xB0B2},
    {0xB0B3, 0xB0B3, 0xB0B3}, {0xB0B4, 0xB0B4, 0xB0B4},
    {0xB0B5, 0xB0B5, 0xB0B5}, {0xB0B6, 0xB0B6, 0xB0B6},
    {0xB0B7, 0xB0B7, 0xB0B7}, {0xB0B8, 0xB0B8, 0xB0B8},
    {0xB0B9, 0xB0B9, 0xB0B9}, {0xB0BA, 0xB0BA, 0xB0BA},
    {0xB0BB, 0xB0BB, 0xB0BB}, {0xB0BC, 0xB0BC, 0xB0BC},
    {0xB0BD, 0xB0BD, 0xB0BD}, {0xB0BE, 0xB0BE, 0xB0BE},
    {0xB0BF, 0xB0BF, 0xB0BF}, {0xB0C0, 0xB0C0, 0xB0C0},
    {0xB0C1, 0xB0C1, 0xB0C1}, {0xB0C2, 0xB0C2, 0xB0C2},
    {0xB0C3, 0xB0C3, 0xB0C3}, {0xB0C4, 0xB0C4, 0xB0C4},
    {0xB0C5, 0xB0C5, 0xB0C5}, {0xB0C6, 0xB0C6, 0xB0C6},
    {0xB0C7, 0xB0C7, 0xB0C7}, {0xB0C8, 0xB0C8, 0xB0C8},
    {0xB0C9, 0xB0C9, 0xB0C9}, {0xB0CA, 0xB0CA, 0xB0CA},
    {0xB0CB, 0xB0CB, 0xB0CB}, {0xB0CC, 0xB0CC, 0xB0CC},
    {0xB0CD, 0xB0CD, 0xB0CD}, {0xB0CE, 0xB0CE, 0xB0CE},
    {0xB0CF, 0xB0CF, 0xB0CF}, {0xB0D0, 0xB0D0, 0xB0D0},
    {0xB0D1, 0xB0D1, 0xB0D1}, {0xB0D2, 0xB0D2, 0xB0D2},
    {0xB0D3, 0xB0D3, 0xB0D3}, {0xB0D4, 0xB0D4, 0xB0D4},
    {0xB0D5, 0xB0D5, 0xB0D5}, {0xB0D6, 0xB0D6, 0xB0D6},
    {0xB0D7, 0xB0D7, 0xB0D7}, {0xB0D8, 0xB0D8, 0xB0D8},
    {0xB0D9, 0xB0D9, 0xB0D9}, {0xB0DA, 0xB0DA, 0xB0DA},
    {0xB0DB, 0xB0DB, 0xB0DB}, {0xB0DC, 0xB0DC, 0xB0DC},
    {0xB0DD, 0xB0DD, 0xB0DD}, {0xB0DE, 0xB0DE, 0xB0DE},
    {0xB0DF, 0xB0DF, 0xB0DF}, {0xB0E0, 0xB0E0, 0xB0E0},
    {0xB0E1, 0xB0E1, 0xB0E1}, {0xB0E2, 0xB0E2, 0xB0E2},
    {0xB0E3, 0xB0E3, 0xB0E3}, {0xB0E4, 0xB0E4, 0xB0E4},
    {0xB0E5, 0xB0E5, 0xB0E5}, {0xB0E6, 0xB0E6, 0xB0E6},
    {0xB0E7, 0xB0E7, 0xB0E7}, {0xB0E8, 0xB0E8, 0xB0E8},
    {0xB0E9, 0xB0E9, 0xB0E9}, {0xB0EA, 0xB0EA, 0xB0EA},
    {0xB0EB, 0xB0EB, 0xB0EB}, {0xB0EC, 0xB0EC, 0xB0EC},
    {0xB0ED, 0xB0ED, 0xB0ED}, {0xB0EE, 0xB0EE, 0xB0EE},
    {0xB0EF, 0xB0EF, 0xB0EF}, {0xB0F0, 0xB0F0, 0xB0F0},
    {0xB0F1, 0xB0F1, 0xB0F1}, {0xB0F2, 0xB0F2, 0xB0F2},
    {0xB0F3, 0xB0F3, 0xB0F3}, {0xB0F4, 0xB0F4, 0xB0F4},
    {0xB0F5, 0xB0F5, 0xB0F5}, {0xB0F6, 0xB0F6, 0xB0F6},
    {0xB0F7, 0xB0F7, 0xB0F7}, {0xB0F8, 0xB0F8, 0xB0F8},
    {0xB0F9, 0xB0F9, 0xB0F9}, {0xB0FA, 0xB0FA, 0xB0FA},
    {0xB0FB, 0xB0FB, 0xB0FB}, {0xB0FC, 0xB0FC, 0xB0FC},
    {0xB0FD, 0xB0FD, 0xB0FD}, {0xB0FE, 0xB0FE, 0xB0FE},
    {0xB0FF, 0xB0FF, 0xB0FF}, {0xB100, 0xB100, 0xB100},
    {0xB101, 0xB101, 0xB101}, {0xB102, 0xB102, 0xB102},
    {0xB103, 0xB103, 0xB103}, {0xB104, 0xB104, 0xB104},
    {0xB105, 0xB105, 0xB105}, {0xB106, 0xB106, 0xB106},
    {0xB107, 0xB107, 0xB107}, {0xB108, 0xB108, 0xB108},
    {0xB109, 0xB109, 0xB109}, {0xB10A, 0xB10A, 0xB10A},
    {0xB10B, 0xB10B, 0xB10B}, {0xB10C, 0xB10C, 0xB10C},
    {0xB10D, 0xB10D, 0xB10D}, {0xB10E, 0xB10E, 0xB10E},
    {0xB10F, 0xB10F, 0xB10F}, {0xB110, 0xB110, 0xB110},
    {0xB111, 0xB111, 0xB111}, {0xB112, 0xB112, 0xB112},
    {0xB113, 0xB113, 0xB113}, {0xB114, 0xB114, 0xB114},
    {0xB115, 0xB115, 0xB115}, {0xB116, 0xB116, 0xB116},
    {0xB117, 0xB117, 0xB117}, {0xB118, 0xB118, 0xB118},
    {0xB119, 0xB119, 0xB119}, {0xB11A, 0xB11A, 0xB11A},
    {0xB11B, 0xB11B, 0xB11B}, {0xB11C, 0xB11C, 0xB11C},
    {0xB11D, 0xB11D, 0xB11D}, {0xB11E, 0xB11E, 0xB11E},
    {0xB11F, 0xB11F, 0xB11F}, {0xB120, 0xB120, 0xB120},
    {0xB121, 0xB121, 0xB121}, {0xB122, 0xB122, 0xB122},
    {0xB123, 0xB123, 0xB123}, {0xB124, 0xB124, 0xB124},
    {0xB125, 0xB125, 0xB125}, {0xB126, 0xB126, 0xB126},
    {0xB127, 0xB127, 0xB127}, {0xB128, 0xB128, 0xB128},
    {0xB129, 0xB129, 0xB129}, {0xB12A, 0xB12A, 0xB12A},
    {0xB12B, 0xB12B, 0xB12B}, {0xB12C, 0xB12C, 0xB12C},
    {0xB12D, 0xB12D, 0xB12D}, {0xB12E, 0xB12E, 0xB12E},
    {0xB12F, 0xB12F, 0xB12F}, {0xB130, 0xB130, 0xB130},
    {0xB131, 0xB131, 0xB131}, {0xB132, 0xB132, 0xB132},
    {0xB133, 0xB133, 0xB133}, {0xB134, 0xB134, 0xB134},
    {0xB135, 0xB135, 0xB135}, {0xB136, 0xB136, 0xB136},
    {0xB137, 0xB137, 0xB137}, {0xB138, 0xB138, 0xB138},
    {0xB139, 0xB139, 0xB139}, {0xB13A, 0xB13A, 0xB13A},
    {0xB13B, 0xB13B, 0xB13B}, {0xB13C, 0xB13C, 0xB13C},
    {0xB13D, 0xB13D, 0xB13D}, {0xB13E, 0xB13E, 0xB13E},
    {0xB13F, 0xB13F, 0xB13F}, {0xB140, 0xB140, 0xB140},
    {0xB141, 0xB141, 0xB141}, {0xB142, 0xB142, 0xB142},
    {0xB143, 0xB143, 0xB143}, {0xB144, 0xB144, 0xB144},
    {0xB145, 0xB145, 0xB145}, {0xB146, 0xB146, 0xB146},
    {0xB147, 0xB147, 0xB147}, {0xB148, 0xB148, 0xB148},
    {0xB149, 0xB149, 0xB149}, {0xB14A, 0xB14A, 0xB14A},
    {0xB14B, 0xB14B, 0xB14B}, {0xB14C, 0xB14C, 0xB14C},
    {0xB14D, 0xB14D, 0xB14D}, {0xB14E, 0xB14E, 0xB14E},
    {0xB14F, 0xB14F, 0xB14F}, {0xB150, 0xB150, 0xB150},
    {0xB151, 0xB151, 0xB151}, {0xB152, 0xB152, 0xB152},
    {0xB153, 0xB153, 0xB153}, {0xB154, 0xB154, 0xB154},
    {0xB155, 0xB155, 0xB155}, {0xB156, 0xB156, 0xB156},
    {0xB157, 0xB157, 0xB157}, {0xB158, 0xB158, 0xB158},
    {0xB159, 0xB159, 0xB159}, {0xB15A, 0xB15A, 0xB15A},
    {0xB15B, 0xB15B, 0xB15B}, {0xB15C, 0xB15C, 0xB15C},
    {0xB15D, 0xB15D, 0xB15D}, {0xB15E, 0xB15E, 0xB15E},
    {0xB15F, 0xB15F, 0xB15F}, {0xB160, 0xB160, 0xB160},
    {0xB161, 0xB161, 0xB161}, {0xB162, 0xB162, 0xB162},
    {0xB163, 0xB163, 0xB163}, {0xB164, 0xB164, 0xB164},
    {0xB165, 0xB165, 0xB165}, {0xB166, 0xB166, 0xB166},
    {0xB167, 0xB167, 0xB167}, {0xB168, 0xB168, 0xB168},
    {0xB169, 0xB169, 0xB169}, {0xB16A, 0xB16A, 0xB16A},
    {0xB16B, 0xB16B, 0xB16B}, {0xB16C, 0xB16C, 0xB16C},
    {0xB16D, 0xB16D, 0xB16D}, {0xB16E, 0xB16E, 0xB16E},
    {0xB16F, 0xB16F, 0xB16F}, {0xB170, 0xB170, 0xB170},
    {0xB171, 0xB171, 0xB171}, {0xB172, 0xB172, 0xB172},
    {0xB173, 0xB173, 0xB173}, {0xB174, 0xB174, 0xB174},
    {0xB175, 0xB175, 0xB175}, {0xB176, 0xB176, 0xB176},
    {0xB177, 0xB177, 0xB177}, {0xB178, 0xB178, 0xB178},
    {0xB179, 0xB179, 0xB179}, {0xB17A, 0xB17A, 0xB17A},
    {0xB17B, 0xB17B, 0xB17B}, {0xB17C, 0xB17C, 0xB17C},
    {0xB17D, 0xB17D, 0xB17D}, {0xB17E, 0xB17E, 0xB17E},
    {0xB17F, 0xB17F, 0xB17F}, {0xB180, 0xB180, 0xB180},
    {0xB181, 0xB181, 0xB181}, {0xB182, 0xB182, 0xB182},
    {0xB183, 0xB183, 0xB183}, {0xB184, 0xB184, 0xB184},
    {0xB185, 0xB185, 0xB185}, {0xB186, 0xB186, 0xB186},
    {0xB187, 0xB187, 0xB187}, {0xB188, 0xB188, 0xB188},
    {0xB189, 0xB189, 0xB189}, {0xB18A, 0xB18A, 0xB18A},
    {0xB18B, 0xB18B, 0xB18B}, {0xB18C, 0xB18C, 0xB18C},
    {0xB18D, 0xB18D, 0xB18D}, {0xB18E, 0xB18E, 0xB18E},
    {0xB18F, 0xB18F, 0xB18F}, {0xB190, 0xB190, 0xB190},
    {0xB191, 0xB191, 0xB191}, {0xB192, 0xB192, 0xB192},
    {0xB193, 0xB193, 0xB193}, {0xB194, 0xB194, 0xB194},
    {0xB195, 0xB195, 0xB195}, {0xB196, 0xB196, 0xB196},
    {0xB197, 0xB197, 0xB197}, {0xB198, 0xB198, 0xB198},
    {0xB199, 0xB199, 0xB199}, {0xB19A, 0xB19A, 0xB19A},
    {0xB19B, 0xB19B, 0xB19B}, {0xB19C, 0xB19C, 0xB19C},
    {0xB19D, 0xB19D, 0xB19D}, {0xB19E, 0xB19E, 0xB19E},
    {0xB19F, 0xB19F, 0xB19F}, {0xB1A0, 0xB1A0, 0xB1A0},
    {0xB1A1, 0xB1A1, 0xB1A1}, {0xB1A2, 0xB1A2, 0xB1A2},
    {0xB1A3, 0xB1A3, 0xB1A3}, {0xB1A4, 0xB1A4, 0xB1A4},
    {0xB1A5, 0xB1A5, 0xB1A5}, {0xB1A6, 0xB1A6, 0xB1A6},
    {0xB1A7, 0xB1A7, 0xB1A7}, {0xB1A8, 0xB1A8, 0xB1A8},
    {0xB1A9, 0xB1A9, 0xB1A9}, {0xB1AA, 0xB1AA, 0xB1AA},
    {0xB1AB, 0xB1AB, 0xB1AB}, {0xB1AC, 0xB1AC, 0xB1AC},
    {0xB1AD, 0xB1AD, 0xB1AD}, {0xB1AE, 0xB1AE, 0xB1AE},
    {0xB1AF, 0xB1AF, 0xB1AF}, {0xB1B0, 0xB1B0, 0xB1B0},
    {0xB1B1, 0xB1B1, 0xB1B1}, {0xB1B2, 0xB1B2, 0xB1B2},
    {0xB1B3, 0xB1B3, 0xB1B3}, {0xB1B4, 0xB1B4, 0xB1B4},
    {0xB1B5, 0xB1B5, 0xB1B5}, {0xB1B6, 0xB1B6, 0xB1B6},
    {0xB1B7, 0xB1B7, 0xB1B7}, {0xB1B8, 0xB1B8, 0xB1B8},
    {0xB1B9, 0xB1B9, 0xB1B9}, {0xB1BA, 0xB1BA, 0xB1BA},
    {0xB1BB, 0xB1BB, 0xB1BB}, {0xB1BC, 0xB1BC, 0xB1BC},
    {0xB1BD, 0xB1BD, 0xB1BD}, {0xB1BE, 0xB1BE, 0xB1BE},
    {0xB1BF, 0xB1BF, 0xB1BF}, {0xB1C0, 0xB1C0, 0xB1C0},
    {0xB1C1, 0xB1C1, 0xB1C1}, {0xB1C2, 0xB1C2, 0xB1C2},
    {0xB1C3, 0xB1C3, 0xB1C3}, {0xB1C4, 0xB1C4, 0xB1C4},
    {0xB1C5, 0xB1C5, 0xB1C5}, {0xB1C6, 0xB1C6, 0xB1C6},
    {0xB1C7, 0xB1C7, 0xB1C7}, {0xB1C8, 0xB1C8, 0xB1C8},
    {0xB1C9, 0xB1C9, 0xB1C9}, {0xB1CA, 0xB1CA, 0xB1CA},
    {0xB1CB, 0xB1CB, 0xB1CB}, {0xB1CC, 0xB1CC, 0xB1CC},
    {0xB1CD, 0xB1CD, 0xB1CD}, {0xB1CE, 0xB1CE, 0xB1CE},
    {0xB1CF, 0xB1CF, 0xB1CF}, {0xB1D0, 0xB1D0, 0xB1D0},
    {0xB1D1, 0xB1D1, 0xB1D1}, {0xB1D2, 0xB1D2, 0xB1D2},
    {0xB1D3, 0xB1D3, 0xB1D3}, {0xB1D4, 0xB1D4, 0xB1D4},
    {0xB1D5, 0xB1D5, 0xB1D5}, {0xB1D6, 0xB1D6, 0xB1D6},
    {0xB1D7, 0xB1D7, 0xB1D7}, {0xB1D8, 0xB1D8, 0xB1D8},
    {0xB1D9, 0xB1D9, 0xB1D9}, {0xB1DA, 0xB1DA, 0xB1DA},
    {0xB1DB, 0xB1DB, 0xB1DB}, {0xB1DC, 0xB1DC, 0xB1DC},
    {0xB1DD, 0xB1DD, 0xB1DD}, {0xB1DE, 0xB1DE, 0xB1DE},
    {0xB1DF, 0xB1DF, 0xB1DF}, {0xB1E0, 0xB1E0, 0xB1E0},
    {0xB1E1, 0xB1E1, 0xB1E1}, {0xB1E2, 0xB1E2, 0xB1E2},
    {0xB1E3, 0xB1E3, 0xB1E3}, {0xB1E4, 0xB1E4, 0xB1E4},
    {0xB1E5, 0xB1E5, 0xB1E5}, {0xB1E6, 0xB1E6, 0xB1E6},
    {0xB1E7, 0xB1E7, 0xB1E7}, {0xB1E8, 0xB1E8, 0xB1E8},
    {0xB1E9, 0xB1E9, 0xB1E9}, {0xB1EA, 0xB1EA, 0xB1EA},
    {0xB1EB, 0xB1EB, 0xB1EB}, {0xB1EC, 0xB1EC, 0xB1EC},
    {0xB1ED, 0xB1ED, 0xB1ED}, {0xB1EE, 0xB1EE, 0xB1EE},
    {0xB1EF, 0xB1EF, 0xB1EF}, {0xB1F0, 0xB1F0, 0xB1F0},
    {0xB1F1, 0xB1F1, 0xB1F1}, {0xB1F2, 0xB1F2, 0xB1F2},
    {0xB1F3, 0xB1F3, 0xB1F3}, {0xB1F4, 0xB1F4, 0xB1F4},
    {0xB1F5, 0xB1F5, 0xB1F5}, {0xB1F6, 0xB1F6, 0xB1F6},
    {0xB1F7, 0xB1F7, 0xB1F7}, {0xB1F8, 0xB1F8, 0xB1F8},
    {0xB1F9, 0xB1F9, 0xB1F9}, {0xB1FA, 0xB1FA, 0xB1FA},
    {0xB1FB, 0xB1FB, 0xB1FB}, {0xB1FC, 0xB1FC, 0xB1FC},
    {0xB1FD, 0xB1FD, 0xB1FD}, {0xB1FE, 0xB1FE, 0xB1FE},
    {0xB1FF, 0xB1FF, 0xB1FF}, {0xB200, 0xB200, 0xB200},
    {0xB201, 0xB201, 0xB201}, {0xB202, 0xB202, 0xB202},
    {0xB203, 0xB203, 0xB203}, {0xB204, 0xB204, 0xB204},
    {0xB205, 0xB205, 0xB205}, {0xB206, 0xB206, 0xB206},
    {0xB207, 0xB207, 0xB207}, {0xB208, 0xB208, 0xB208},
    {0xB209, 0xB209, 0xB209}, {0xB20A, 0xB20A, 0xB20A},
    {0xB20B, 0xB20B, 0xB20B}, {0xB20C, 0xB20C, 0xB20C},
    {0xB20D, 0xB20D, 0xB20D}, {0xB20E, 0xB20E, 0xB20E},
    {0xB20F, 0xB20F, 0xB20F}, {0xB210, 0xB210, 0xB210},
    {0xB211, 0xB211, 0xB211}, {0xB212, 0xB212, 0xB212},
    {0xB213, 0xB213, 0xB213}, {0xB214, 0xB214, 0xB214},
    {0xB215, 0xB215, 0xB215}, {0xB216, 0xB216, 0xB216},
    {0xB217, 0xB217, 0xB217}, {0xB218, 0xB218, 0xB218},
    {0xB219, 0xB219, 0xB219}, {0xB21A, 0xB21A, 0xB21A},
    {0xB21B, 0xB21B, 0xB21B}, {0xB21C, 0xB21C, 0xB21C},
    {0xB21D, 0xB21D, 0xB21D}, {0xB21E, 0xB21E, 0xB21E},
    {0xB21F, 0xB21F, 0xB21F}, {0xB220, 0xB220, 0xB220},
    {0xB221, 0xB221, 0xB221}, {0xB222, 0xB222, 0xB222},
    {0xB223, 0xB223, 0xB223}, {0xB224, 0xB224, 0xB224},
    {0xB225, 0xB225, 0xB225}, {0xB226, 0xB226, 0xB226},
    {0xB227, 0xB227, 0xB227}, {0xB228, 0xB228, 0xB228},
    {0xB229, 0xB229, 0xB229}, {0xB22A, 0xB22A, 0xB22A},
    {0xB22B, 0xB22B, 0xB22B}, {0xB22C, 0xB22C, 0xB22C},
    {0xB22D, 0xB22D, 0xB22D}, {0xB22E, 0xB22E, 0xB22E},
    {0xB22F, 0xB22F, 0xB22F}, {0xB230, 0xB230, 0xB230},
    {0xB231, 0xB231, 0xB231}, {0xB232, 0xB232, 0xB232},
    {0xB233, 0xB233, 0xB233}, {0xB234, 0xB234, 0xB234},
    {0xB235, 0xB235, 0xB235}, {0xB236, 0xB236, 0xB236},
    {0xB237, 0xB237, 0xB237}, {0xB238, 0xB238, 0xB238},
    {0xB239, 0xB239, 0xB239}, {0xB23A, 0xB23A, 0xB23A},
    {0xB23B, 0xB23B, 0xB23B}, {0xB23C, 0xB23C, 0xB23C},
    {0xB23D, 0xB23D, 0xB23D}, {0xB23E, 0xB23E, 0xB23E},
    {0xB23F, 0xB23F, 0xB23F}, {0xB240, 0xB240, 0xB240},
    {0xB241, 0xB241, 0xB241}, {0xB242, 0xB242, 0xB242},
    {0xB243, 0xB243, 0xB243}, {0xB244, 0xB244, 0xB244},
    {0xB245, 0xB245, 0xB245}, {0xB246, 0xB246, 0xB246},
    {0xB247, 0xB247, 0xB247}, {0xB248, 0xB248, 0xB248},
    {0xB249, 0xB249, 0xB249}, {0xB24A, 0xB24A, 0xB24A},
    {0xB24B, 0xB24B, 0xB24B}, {0xB24C, 0xB24C, 0xB24C},
    {0xB24D, 0xB24D, 0xB24D}, {0xB24E, 0xB24E, 0xB24E},
    {0xB24F, 0xB24F, 0xB24F}, {0xB250, 0xB250, 0xB250},
    {0xB251, 0xB251, 0xB251}, {0xB252, 0xB252, 0xB252},
    {0xB253, 0xB253, 0xB253}, {0xB254, 0xB254, 0xB254},
    {0xB255, 0xB255, 0xB255}, {0xB256, 0xB256, 0xB256},
    {0xB257, 0xB257, 0xB257}, {0xB258, 0xB258, 0xB258},
    {0xB259, 0xB259, 0xB259}, {0xB25A, 0xB25A, 0xB25A},
    {0xB25B, 0xB25B, 0xB25B}, {0xB25C, 0xB25C, 0xB25C},
    {0xB25D, 0xB25D, 0xB25D}, {0xB25E, 0xB25E, 0xB25E},
    {0xB25F, 0xB25F, 0xB25F}, {0xB260, 0xB260, 0xB260},
    {0xB261, 0xB261, 0xB261}, {0xB262, 0xB262, 0xB262},
    {0xB263, 0xB263, 0xB263}, {0xB264, 0xB264, 0xB264},
    {0xB265, 0xB265, 0xB265}, {0xB266, 0xB266, 0xB266},
    {0xB267, 0xB267, 0xB267}, {0xB268, 0xB268, 0xB268},
    {0xB269, 0xB269, 0xB269}, {0xB26A, 0xB26A, 0xB26A},
    {0xB26B, 0xB26B, 0xB26B}, {0xB26C, 0xB26C, 0xB26C},
    {0xB26D, 0xB26D, 0xB26D}, {0xB26E, 0xB26E, 0xB26E},
    {0xB26F, 0xB26F, 0xB26F}, {0xB270, 0xB270, 0xB270},
    {0xB271, 0xB271, 0xB271}, {0xB272, 0xB272, 0xB272},
    {0xB273, 0xB273, 0xB273}, {0xB274, 0xB274, 0xB274},
    {0xB275, 0xB275, 0xB275}, {0xB276, 0xB276, 0xB276},
    {0xB277, 0xB277, 0xB277}, {0xB278, 0xB278, 0xB278},
    {0xB279, 0xB279, 0xB279}, {0xB27A, 0xB27A, 0xB27A},
    {0xB27B, 0xB27B, 0xB27B}, {0xB27C, 0xB27C, 0xB27C},
    {0xB27D, 0xB27D, 0xB27D}, {0xB27E, 0xB27E, 0xB27E},
    {0xB27F, 0xB27F, 0xB27F}, {0xB280, 0xB280, 0xB280},
    {0xB281, 0xB281, 0xB281}, {0xB282, 0xB282, 0xB282},
    {0xB283, 0xB283, 0xB283}, {0xB284, 0xB284, 0xB284},
    {0xB285, 0xB285, 0xB285}, {0xB286, 0xB286, 0xB286},
    {0xB287, 0xB287, 0xB287}, {0xB288, 0xB288, 0xB288},
    {0xB289, 0xB289, 0xB289}, {0xB28A, 0xB28A, 0xB28A},
    {0xB28B, 0xB28B, 0xB28B}, {0xB28C, 0xB28C, 0xB28C},
    {0xB28D, 0xB28D, 0xB28D}, {0xB28E, 0xB28E, 0xB28E},
    {0xB28F, 0xB28F, 0xB28F}, {0xB290, 0xB290, 0xB290},
    {0xB291, 0xB291, 0xB291}, {0xB292, 0xB292, 0xB292},
    {0xB293, 0xB293, 0xB293}, {0xB294, 0xB294, 0xB294},
    {0xB295, 0xB295, 0xB295}, {0xB296, 0xB296, 0xB296},
    {0xB297, 0xB297, 0xB297}, {0xB298, 0xB298, 0xB298},
    {0xB299, 0xB299, 0xB299}, {0xB29A, 0xB29A, 0xB29A},
    {0xB29B, 0xB29B, 0xB29B}, {0xB29C, 0xB29C, 0xB29C},
    {0xB29D, 0xB29D, 0xB29D}, {0xB29E, 0xB29E, 0xB29E},
    {0xB29F, 0xB29F, 0xB29F}, {0xB2A0, 0xB2A0, 0xB2A0},
    {0xB2A1, 0xB2A1, 0xB2A1}, {0xB2A2, 0xB2A2, 0xB2A2},
    {0xB2A3, 0xB2A3, 0xB2A3}, {0xB2A4, 0xB2A4, 0xB2A4},
    {0xB2A5, 0xB2A5, 0xB2A5}, {0xB2A6, 0xB2A6, 0xB2A6},
    {0xB2A7, 0xB2A7, 0xB2A7}, {0xB2A8, 0xB2A8, 0xB2A8},
    {0xB2A9, 0xB2A9, 0xB2A9}, {0xB2AA, 0xB2AA, 0xB2AA},
    {0xB2AB, 0xB2AB, 0xB2AB}, {0xB2AC, 0xB2AC, 0xB2AC},
    {0xB2AD, 0xB2AD, 0xB2AD}, {0xB2AE, 0xB2AE, 0xB2AE},
    {0xB2AF, 0xB2AF, 0xB2AF}, {0xB2B0, 0xB2B0, 0xB2B0},
    {0xB2B1, 0xB2B1, 0xB2B1}, {0xB2B2, 0xB2B2, 0xB2B2},
    {0xB2B3, 0xB2B3, 0xB2B3}, {0xB2B4, 0xB2B4, 0xB2B4},
    {0xB2B5, 0xB2B5, 0xB2B5}, {0xB2B6, 0xB2B6, 0xB2B6},
    {0xB2B7, 0xB2B7, 0xB2B7}, {0xB2B8, 0xB2B8, 0xB2B8},
    {0xB2B9, 0xB2B9, 0xB2B9}, {0xB2BA, 0xB2BA, 0xB2BA},
    {0xB2BB, 0xB2BB, 0xB2BB}, {0xB2BC, 0xB2BC, 0xB2BC},
    {0xB2BD, 0xB2BD, 0xB2BD}, {0xB2BE, 0xB2BE, 0xB2BE},
    {0xB2BF, 0xB2BF, 0xB2BF}, {0xB2C0, 0xB2C0, 0xB2C0},
    {0xB2C1, 0xB2C1, 0xB2C1}, {0xB2C2, 0xB2C2, 0xB2C2},
    {0xB2C3, 0xB2C3, 0xB2C3}, {0xB2C4, 0xB2C4, 0xB2C4},
    {0xB2C5, 0xB2C5, 0xB2C5}, {0xB2C6, 0xB2C6, 0xB2C6},
    {0xB2C7, 0xB2C7, 0xB2C7}, {0xB2C8, 0xB2C8, 0xB2C8},
    {0xB2C9, 0xB2C9, 0xB2C9}, {0xB2CA, 0xB2CA, 0xB2CA},
    {0xB2CB, 0xB2CB, 0xB2CB}, {0xB2CC, 0xB2CC, 0xB2CC},
    {0xB2CD, 0xB2CD, 0xB2CD}, {0xB2CE, 0xB2CE, 0xB2CE},
    {0xB2CF, 0xB2CF, 0xB2CF}, {0xB2D0, 0xB2D0, 0xB2D0},
    {0xB2D1, 0xB2D1, 0xB2D1}, {0xB2D2, 0xB2D2, 0xB2D2},
    {0xB2D3, 0xB2D3, 0xB2D3}, {0xB2D4, 0xB2D4, 0xB2D4},
    {0xB2D5, 0xB2D5, 0xB2D5}, {0xB2D6, 0xB2D6, 0xB2D6},
    {0xB2D7, 0xB2D7, 0xB2D7}, {0xB2D8, 0xB2D8, 0xB2D8},
    {0xB2D9, 0xB2D9, 0xB2D9}, {0xB2DA, 0xB2DA, 0xB2DA},
    {0xB2DB, 0xB2DB, 0xB2DB}, {0xB2DC, 0xB2DC, 0xB2DC},
    {0xB2DD, 0xB2DD, 0xB2DD}, {0xB2DE, 0xB2DE, 0xB2DE},
    {0xB2DF, 0xB2DF, 0xB2DF}, {0xB2E0, 0xB2E0, 0xB2E0},
    {0xB2E1, 0xB2E1, 0xB2E1}, {0xB2E2, 0xB2E2, 0xB2E2},
    {0xB2E3, 0xB2E3, 0xB2E3}, {0xB2E4, 0xB2E4, 0xB2E4},
    {0xB2E5, 0xB2E5, 0xB2E5}, {0xB2E6, 0xB2E6, 0xB2E6},
    {0xB2E7, 0xB2E7, 0xB2E7}, {0xB2E8, 0xB2E8, 0xB2E8},
    {0xB2E9, 0xB2E9, 0xB2E9}, {0xB2EA, 0xB2EA, 0xB2EA},
    {0xB2EB, 0xB2EB, 0xB2EB}, {0xB2EC, 0xB2EC, 0xB2EC},
    {0xB2ED, 0xB2ED, 0xB2ED}, {0xB2EE, 0xB2EE, 0xB2EE},
    {0xB2EF, 0xB2EF, 0xB2EF}, {0xB2F0, 0xB2F0, 0xB2F0},
    {0xB2F1, 0xB2F1, 0xB2F1}, {0xB2F2, 0xB2F2, 0xB2F2},
    {0xB2F3, 0xB2F3, 0xB2F3}, {0xB2F4, 0xB2F4, 0xB2F4},
    {0xB2F5, 0xB2F5, 0xB2F5}, {0xB2F6, 0xB2F6, 0xB2F6},
    {0xB2F7, 0xB2F7, 0xB2F7}, {0xB2F8, 0xB2F8, 0xB2F8},
    {0xB2F9, 0xB2F9, 0xB2F9}, {0xB2FA, 0xB2FA, 0xB2FA},
    {0xB2FB, 0xB2FB, 0xB2FB}, {0xB2FC, 0xB2FC, 0xB2FC},
    {0xB2FD, 0xB2FD, 0xB2FD}, {0xB2FE, 0xB2FE, 0xB2FE},
    {0xB2FF, 0xB2FF, 0xB2FF}, {0xB300, 0xB300, 0xB300},
    {0xB301, 0xB301, 0xB301}, {0xB302, 0xB302, 0xB302},
    {0xB303, 0xB303, 0xB303}, {0xB304, 0xB304, 0xB304},
    {0xB305, 0xB305, 0xB305}, {0xB306, 0xB306, 0xB306},
    {0xB307, 0xB307, 0xB307}, {0xB308, 0xB308, 0xB308},
    {0xB309, 0xB309, 0xB309}, {0xB30A, 0xB30A, 0xB30A},
    {0xB30B, 0xB30B, 0xB30B}, {0xB30C, 0xB30C, 0xB30C},
    {0xB30D, 0xB30D, 0xB30D}, {0xB30E, 0xB30E, 0xB30E},
    {0xB30F, 0xB30F, 0xB30F}, {0xB310, 0xB310, 0xB310},
    {0xB311, 0xB311, 0xB311}, {0xB312, 0xB312, 0xB312},
    {0xB313, 0xB313, 0xB313}, {0xB314, 0xB314, 0xB314},
    {0xB315, 0xB315, 0xB315}, {0xB316, 0xB316, 0xB316},
    {0xB317, 0xB317, 0xB317}, {0xB318, 0xB318, 0xB318},
    {0xB319, 0xB319, 0xB319}, {0xB31A, 0xB31A, 0xB31A},
    {0xB31B, 0xB31B, 0xB31B}, {0xB31C, 0xB31C, 0xB31C},
    {0xB31D, 0xB31D, 0xB31D}, {0xB31E, 0xB31E, 0xB31E},
    {0xB31F, 0xB31F, 0xB31F}, {0xB320, 0xB320, 0xB320},
    {0xB321, 0xB321, 0xB321}, {0xB322, 0xB322, 0xB322},
    {0xB323, 0xB323, 0xB323}, {0xB324, 0xB324, 0xB324},
    {0xB325, 0xB325, 0xB325}, {0xB326, 0xB326, 0xB326},
    {0xB327, 0xB327, 0xB327}, {0xB328, 0xB328, 0xB328},
    {0xB329, 0xB329, 0xB329}, {0xB32A, 0xB32A, 0xB32A},
    {0xB32B, 0xB32B, 0xB32B}, {0xB32C, 0xB32C, 0xB32C},
    {0xB32D, 0xB32D, 0xB32D}, {0xB32E, 0xB32E, 0xB32E},
    {0xB32F, 0xB32F, 0xB32F}, {0xB330, 0xB330, 0xB330},
    {0xB331, 0xB331, 0xB331}, {0xB332, 0xB332, 0xB332},
    {0xB333, 0xB333, 0xB333}, {0xB334, 0xB334, 0xB334},
    {0xB335, 0xB335, 0xB335}, {0xB336, 0xB336, 0xB336},
    {0xB337, 0xB337, 0xB337}, {0xB338, 0xB338, 0xB338},
    {0xB339, 0xB339, 0xB339}, {0xB33A, 0xB33A, 0xB33A},
    {0xB33B, 0xB33B, 0xB33B}, {0xB33C, 0xB33C, 0xB33C},
    {0xB33D, 0xB33D, 0xB33D}, {0xB33E, 0xB33E, 0xB33E},
    {0xB33F, 0xB33F, 0xB33F}, {0xB340, 0xB340, 0xB340},
    {0xB341, 0xB341, 0xB341}, {0xB342, 0xB342, 0xB342},
    {0xB343, 0xB343, 0xB343}, {0xB344, 0xB344, 0xB344},
    {0xB345, 0xB345, 0xB345}, {0xB346, 0xB346, 0xB346},
    {0xB347, 0xB347, 0xB347}, {0xB348, 0xB348, 0xB348},
    {0xB349, 0xB349, 0xB349}, {0xB34A, 0xB34A, 0xB34A},
    {0xB34B, 0xB34B, 0xB34B}, {0xB34C, 0xB34C, 0xB34C},
    {0xB34D, 0xB34D, 0xB34D}, {0xB34E, 0xB34E, 0xB34E},
    {0xB34F, 0xB34F, 0xB34F}, {0xB350, 0xB350, 0xB350},
    {0xB351, 0xB351, 0xB351}, {0xB352, 0xB352, 0xB352},
    {0xB353, 0xB353, 0xB353}, {0xB354, 0xB354, 0xB354},
    {0xB355, 0xB355, 0xB355}, {0xB356, 0xB356, 0xB356},
    {0xB357, 0xB357, 0xB357}, {0xB358, 0xB358, 0xB358},
    {0xB359, 0xB359, 0xB359}, {0xB35A, 0xB35A, 0xB35A},
    {0xB35B, 0xB35B, 0xB35B}, {0xB35C, 0xB35C, 0xB35C},
    {0xB35D, 0xB35D, 0xB35D}, {0xB35E, 0xB35E, 0xB35E},
    {0xB35F, 0xB35F, 0xB35F}, {0xB360, 0xB360, 0xB360},
    {0xB361, 0xB361, 0xB361}, {0xB362, 0xB362, 0xB362},
    {0xB363, 0xB363, 0xB363}, {0xB364, 0xB364, 0xB364},
    {0xB365, 0xB365, 0xB365}, {0xB366, 0xB366, 0xB366},
    {0xB367, 0xB367, 0xB367}, {0xB368, 0xB368, 0xB368},
    {0xB369, 0xB369, 0xB369}, {0xB36A, 0xB36A, 0xB36A},
    {0xB36B, 0xB36B, 0xB36B}, {0xB36C, 0xB36C, 0xB36C},
    {0xB36D, 0xB36D, 0xB36D}, {0xB36E, 0xB36E, 0xB36E},
    {0xB36F, 0xB36F, 0xB36F}, {0xB370, 0xB370, 0xB370},
    {0xB371, 0xB371, 0xB371}, {0xB372, 0xB372, 0xB372},
    {0xB373, 0xB373, 0xB373}, {0xB374, 0xB374, 0xB374},
    {0xB375, 0xB375, 0xB375}, {0xB376, 0xB376, 0xB376},
    {0xB377, 0xB377, 0xB377}, {0xB378, 0xB378, 0xB378},
    {0xB379, 0xB379, 0xB379}, {0xB37A, 0xB37A, 0xB37A},
    {0xB37B, 0xB37B, 0xB37B}, {0xB37C, 0xB37C, 0xB37C},
    {0xB37D, 0xB37D, 0xB37D}, {0xB37E, 0xB37E, 0xB37E},
    {0xB37F, 0xB37F, 0xB37F}, {0xB380, 0xB380, 0xB380},
    {0xB381, 0xB381, 0xB381}, {0xB382, 0xB382, 0xB382},
    {0xB383, 0xB383, 0xB383}, {0xB384, 0xB384, 0xB384},
    {0xB385, 0xB385, 0xB385}, {0xB386, 0xB386, 0xB386},
    {0xB387, 0xB387, 0xB387}, {0xB388, 0xB388, 0xB388},
    {0xB389, 0xB389, 0xB389}, {0xB38A, 0xB38A, 0xB38A},
    {0xB38B, 0xB38B, 0xB38B}, {0xB38C, 0xB38C, 0xB38C},
    {0xB38D, 0xB38D, 0xB38D}, {0xB38E, 0xB38E, 0xB38E},
    {0xB38F, 0xB38F, 0xB38F}, {0xB390, 0xB390, 0xB390},
    {0xB391, 0xB391, 0xB391}, {0xB392, 0xB392, 0xB392},
    {0xB393, 0xB393, 0xB393}, {0xB394, 0xB394, 0xB394},
    {0xB395, 0xB395, 0xB395}, {0xB396, 0xB396, 0xB396},
    {0xB397, 0xB397, 0xB397}, {0xB398, 0xB398, 0xB398},
    {0xB399, 0xB399, 0xB399}, {0xB39A, 0xB39A, 0xB39A},
    {0xB39B, 0xB39B, 0xB39B}, {0xB39C, 0xB39C, 0xB39C},
    {0xB39D, 0xB39D, 0xB39D}, {0xB39E, 0xB39E, 0xB39E},
    {0xB39F, 0xB39F, 0xB39F}, {0xB3A0, 0xB3A0, 0xB3A0},
    {0xB3A1, 0xB3A1, 0xB3A1}, {0xB3A2, 0xB3A2, 0xB3A2},
    {0xB3A3, 0xB3A3, 0xB3A3}, {0xB3A4, 0xB3A4, 0xB3A4},
    {0xB3A5, 0xB3A5, 0xB3A5}, {0xB3A6, 0xB3A6, 0xB3A6},
    {0xB3A7, 0xB3A7, 0xB3A7}, {0xB3A8, 0xB3A8, 0xB3A8},
    {0xB3A9, 0xB3A9, 0xB3A9}, {0xB3AA, 0xB3AA, 0xB3AA},
    {0xB3AB, 0xB3AB, 0xB3AB}, {0xB3AC, 0xB3AC, 0xB3AC},
    {0xB3AD, 0xB3AD, 0xB3AD}, {0xB3AE, 0xB3AE, 0xB3AE},
    {0xB3AF, 0xB3AF, 0xB3AF}, {0xB3B0, 0xB3B0, 0xB3B0},
    {0xB3B1, 0xB3B1, 0xB3B1}, {0xB3B2, 0xB3B2, 0xB3B2},
    {0xB3B3, 0xB3B3, 0xB3B3}, {0xB3B4, 0xB3B4, 0xB3B4},
    {0xB3B5, 0xB3B5, 0xB3B5}, {0xB3B6, 0xB3B6, 0xB3B6},
    {0xB3B7, 0xB3B7, 0xB3B7}, {0xB3B8, 0xB3B8, 0xB3B8},
    {0xB3B9, 0xB3B9, 0xB3B9}, {0xB3BA, 0xB3BA, 0xB3BA},
    {0xB3BB, 0xB3BB, 0xB3BB}, {0xB3BC, 0xB3BC, 0xB3BC},
    {0xB3BD, 0xB3BD, 0xB3BD}, {0xB3BE, 0xB3BE, 0xB3BE},
    {0xB3BF, 0xB3BF, 0xB3BF}, {0xB3C0, 0xB3C0, 0xB3C0},
    {0xB3C1, 0xB3C1, 0xB3C1}, {0xB3C2, 0xB3C2, 0xB3C2},
    {0xB3C3, 0xB3C3, 0xB3C3}, {0xB3C4, 0xB3C4, 0xB3C4},
    {0xB3C5, 0xB3C5, 0xB3C5}, {0xB3C6, 0xB3C6, 0xB3C6},
    {0xB3C7, 0xB3C7, 0xB3C7}, {0xB3C8, 0xB3C8, 0xB3C8},
    {0xB3C9, 0xB3C9, 0xB3C9}, {0xB3CA, 0xB3CA, 0xB3CA},
    {0xB3CB, 0xB3CB, 0xB3CB}, {0xB3CC, 0xB3CC, 0xB3CC},
    {0xB3CD, 0xB3CD, 0xB3CD}, {0xB3CE, 0xB3CE, 0xB3CE},
    {0xB3CF, 0xB3CF, 0xB3CF}, {0xB3D0, 0xB3D0, 0xB3D0},
    {0xB3D1, 0xB3D1, 0xB3D1}, {0xB3D2, 0xB3D2, 0xB3D2},
    {0xB3D3, 0xB3D3, 0xB3D3}, {0xB3D4, 0xB3D4, 0xB3D4},
    {0xB3D5, 0xB3D5, 0xB3D5}, {0xB3D6, 0xB3D6, 0xB3D6},
    {0xB3D7, 0xB3D7, 0xB3D7}, {0xB3D8, 0xB3D8, 0xB3D8},
    {0xB3D9, 0xB3D9, 0xB3D9}, {0xB3DA, 0xB3DA, 0xB3DA},
    {0xB3DB, 0xB3DB, 0xB3DB}, {0xB3DC, 0xB3DC, 0xB3DC},
    {0xB3DD, 0xB3DD, 0xB3DD}, {0xB3DE, 0xB3DE, 0xB3DE},
    {0xB3DF, 0xB3DF, 0xB3DF}, {0xB3E0, 0xB3E0, 0xB3E0},
    {0xB3E1, 0xB3E1, 0xB3E1}, {0xB3E2, 0xB3E2, 0xB3E2},
    {0xB3E3, 0xB3E3, 0xB3E3}, {0xB3E4, 0xB3E4, 0xB3E4},
    {0xB3E5, 0xB3E5, 0xB3E5}, {0xB3E6, 0xB3E6, 0xB3E6},
    {0xB3E7, 0xB3E7, 0xB3E7}, {0xB3E8, 0xB3E8, 0xB3E8},
    {0xB3E9, 0xB3E9, 0xB3E9}, {0xB3EA, 0xB3EA, 0xB3EA},
    {0xB3EB, 0xB3EB, 0xB3EB}, {0xB3EC, 0xB3EC, 0xB3EC},
    {0xB3ED, 0xB3ED, 0xB3ED}, {0xB3EE, 0xB3EE, 0xB3EE},
    {0xB3EF, 0xB3EF, 0xB3EF}, {0xB3F0, 0xB3F0, 0xB3F0},
    {0xB3F1, 0xB3F1, 0xB3F1}, {0xB3F2, 0xB3F2, 0xB3F2},
    {0xB3F3, 0xB3F3, 0xB3F3}, {0xB3F4, 0xB3F4, 0xB3F4},
    {0xB3F5, 0xB3F5, 0xB3F5}, {0xB3F6, 0xB3F6, 0xB3F6},
    {0xB3F7, 0xB3F7, 0xB3F7}, {0xB3F8, 0xB3F8, 0xB3F8},
    {0xB3F9, 0xB3F9, 0xB3F9}, {0xB3FA, 0xB3FA, 0xB3FA},
    {0xB3FB, 0xB3FB, 0xB3FB}, {0xB3FC, 0xB3FC, 0xB3FC},
    {0xB3FD, 0xB3FD, 0xB3FD}, {0xB3FE, 0xB3FE, 0xB3FE},
    {0xB3FF, 0xB3FF, 0xB3FF}, {0xB400, 0xB400, 0xB400},
    {0xB401, 0xB401, 0xB401}, {0xB402, 0xB402, 0xB402},
    {0xB403, 0xB403, 0xB403}, {0xB404, 0xB404, 0xB404},
    {0xB405, 0xB405, 0xB405}, {0xB406, 0xB406, 0xB406},
    {0xB407, 0xB407, 0xB407}, {0xB408, 0xB408, 0xB408},
    {0xB409, 0xB409, 0xB409}, {0xB40A, 0xB40A, 0xB40A},
    {0xB40B, 0xB40B, 0xB40B}, {0xB40C, 0xB40C, 0xB40C},
    {0xB40D, 0xB40D, 0xB40D}, {0xB40E, 0xB40E, 0xB40E},
    {0xB40F, 0xB40F, 0xB40F}, {0xB410, 0xB410, 0xB410},
    {0xB411, 0xB411, 0xB411}, {0xB412, 0xB412, 0xB412},
    {0xB413, 0xB413, 0xB413}, {0xB414, 0xB414, 0xB414},
    {0xB415, 0xB415, 0xB415}, {0xB416, 0xB416, 0xB416},
    {0xB417, 0xB417, 0xB417}, {0xB418, 0xB418, 0xB418},
    {0xB419, 0xB419, 0xB419}, {0xB41A, 0xB41A, 0xB41A},
    {0xB41B, 0xB41B, 0xB41B}, {0xB41C, 0xB41C, 0xB41C},
    {0xB41D, 0xB41D, 0xB41D}, {0xB41E, 0xB41E, 0xB41E},
    {0xB41F, 0xB41F, 0xB41F}, {0xB420, 0xB420, 0xB420},
    {0xB421, 0xB421, 0xB421}, {0xB422, 0xB422, 0xB422},
    {0xB423, 0xB423, 0xB423}, {0xB424, 0xB424, 0xB424},
    {0xB425, 0xB425, 0xB425}, {0xB426, 0xB426, 0xB426},
    {0xB427, 0xB427, 0xB427}, {0xB428, 0xB428, 0xB428},
    {0xB429, 0xB429, 0xB429}, {0xB42A, 0xB42A, 0xB42A},
    {0xB42B, 0xB42B, 0xB42B}, {0xB42C, 0xB42C, 0xB42C},
    {0xB42D, 0xB42D, 0xB42D}, {0xB42E, 0xB42E, 0xB42E},
    {0xB42F, 0xB42F, 0xB42F}, {0xB430, 0xB430, 0xB430},
    {0xB431, 0xB431, 0xB431}, {0xB432, 0xB432, 0xB432},
    {0xB433, 0xB433, 0xB433}, {0xB434, 0xB434, 0xB434},
    {0xB435, 0xB435, 0xB435}, {0xB436, 0xB436, 0xB436},
    {0xB437, 0xB437, 0xB437}, {0xB438, 0xB438, 0xB438},
    {0xB439, 0xB439, 0xB439}, {0xB43A, 0xB43A, 0xB43A},
    {0xB43B, 0xB43B, 0xB43B}, {0xB43C, 0xB43C, 0xB43C},
    {0xB43D, 0xB43D, 0xB43D}, {0xB43E, 0xB43E, 0xB43E},
    {0xB43F, 0xB43F, 0xB43F}, {0xB440, 0xB440, 0xB440},
    {0xB441, 0xB441, 0xB441}, {0xB442, 0xB442, 0xB442},
    {0xB443, 0xB443, 0xB443}, {0xB444, 0xB444, 0xB444},
    {0xB445, 0xB445, 0xB445}, {0xB446, 0xB446, 0xB446},
    {0xB447, 0xB447, 0xB447}, {0xB448, 0xB448, 0xB448},
    {0xB449, 0xB449, 0xB449}, {0xB44A, 0xB44A, 0xB44A},
    {0xB44B, 0xB44B, 0xB44B}, {0xB44C, 0xB44C, 0xB44C},
    {0xB44D, 0xB44D, 0xB44D}, {0xB44E, 0xB44E, 0xB44E},
    {0xB44F, 0xB44F, 0xB44F}, {0xB450, 0xB450, 0xB450},
    {0xB451, 0xB451, 0xB451}, {0xB452, 0xB452, 0xB452},
    {0xB453, 0xB453, 0xB453}, {0xB454, 0xB454, 0xB454},
    {0xB455, 0xB455, 0xB455}, {0xB456, 0xB456, 0xB456},
    {0xB457, 0xB457, 0xB457}, {0xB458, 0xB458, 0xB458},
    {0xB459, 0xB459, 0xB459}, {0xB45A, 0xB45A, 0xB45A},
    {0xB45B, 0xB45B, 0xB45B}, {0xB45C, 0xB45C, 0xB45C},
    {0xB45D, 0xB45D, 0xB45D}, {0xB45E, 0xB45E, 0xB45E},
    {0xB45F, 0xB45F, 0xB45F}, {0xB460, 0xB460, 0xB460},
    {0xB461, 0xB461, 0xB461}, {0xB462, 0xB462, 0xB462},
    {0xB463, 0xB463, 0xB463}, {0xB464, 0xB464, 0xB464},
    {0xB465, 0xB465, 0xB465}, {0xB466, 0xB466, 0xB466},
    {0xB467, 0xB467, 0xB467}, {0xB468, 0xB468, 0xB468},
    {0xB469, 0xB469, 0xB469}, {0xB46A, 0xB46A, 0xB46A},
    {0xB46B, 0xB46B, 0xB46B}, {0xB46C, 0xB46C, 0xB46C},
    {0xB46D, 0xB46D, 0xB46D}, {0xB46E, 0xB46E, 0xB46E},
    {0xB46F, 0xB46F, 0xB46F}, {0xB470, 0xB470, 0xB470},
    {0xB471, 0xB471, 0xB471}, {0xB472, 0xB472, 0xB472},
    {0xB473, 0xB473, 0xB473}, {0xB474, 0xB474, 0xB474},
    {0xB475, 0xB475, 0xB475}, {0xB476, 0xB476, 0xB476},
    {0xB477, 0xB477, 0xB477}, {0xB478, 0xB478, 0xB478},
    {0xB479, 0xB479, 0xB479}, {0xB47A, 0xB47A, 0xB47A},
    {0xB47B, 0xB47B, 0xB47B}, {0xB47C, 0xB47C, 0xB47C},
    {0xB47D, 0xB47D, 0xB47D}, {0xB47E, 0xB47E, 0xB47E},
    {0xB47F, 0xB47F, 0xB47F}, {0xB480, 0xB480, 0xB480},
    {0xB481, 0xB481, 0xB481}, {0xB482, 0xB482, 0xB482},
    {0xB483, 0xB483, 0xB483}, {0xB484, 0xB484, 0xB484},
    {0xB485, 0xB485, 0xB485}, {0xB486, 0xB486, 0xB486},
    {0xB487, 0xB487, 0xB487}, {0xB488, 0xB488, 0xB488},
    {0xB489, 0xB489, 0xB489}, {0xB48A, 0xB48A, 0xB48A},
    {0xB48B, 0xB48B, 0xB48B}, {0xB48C, 0xB48C, 0xB48C},
    {0xB48D, 0xB48D, 0xB48D}, {0xB48E, 0xB48E, 0xB48E},
    {0xB48F, 0xB48F, 0xB48F}, {0xB490, 0xB490, 0xB490},
    {0xB491, 0xB491, 0xB491}, {0xB492, 0xB492, 0xB492},
    {0xB493, 0xB493, 0xB493}, {0xB494, 0xB494, 0xB494},
    {0xB495, 0xB495, 0xB495}, {0xB496, 0xB496, 0xB496},
    {0xB497, 0xB497, 0xB497}, {0xB498, 0xB498, 0xB498},
    {0xB499, 0xB499, 0xB499}, {0xB49A, 0xB49A, 0xB49A},
    {0xB49B, 0xB49B, 0xB49B}, {0xB49C, 0xB49C, 0xB49C},
    {0xB49D, 0xB49D, 0xB49D}, {0xB49E, 0xB49E, 0xB49E},
    {0xB49F, 0xB49F, 0xB49F}, {0xB4A0, 0xB4A0, 0xB4A0},
    {0xB4A1, 0xB4A1, 0xB4A1}, {0xB4A2, 0xB4A2, 0xB4A2},
    {0xB4A3, 0xB4A3, 0xB4A3}, {0xB4A4, 0xB4A4, 0xB4A4},
    {0xB4A5, 0xB4A5, 0xB4A5}, {0xB4A6, 0xB4A6, 0xB4A6},
    {0xB4A7, 0xB4A7, 0xB4A7}, {0xB4A8, 0xB4A8, 0xB4A8},
    {0xB4A9, 0xB4A9, 0xB4A9}, {0xB4AA, 0xB4AA, 0xB4AA},
    {0xB4AB, 0xB4AB, 0xB4AB}, {0xB4AC, 0xB4AC, 0xB4AC},
    {0xB4AD, 0xB4AD, 0xB4AD}, {0xB4AE, 0xB4AE, 0xB4AE},
    {0xB4AF, 0xB4AF, 0xB4AF}, {0xB4B0, 0xB4B0, 0xB4B0},
    {0xB4B1, 0xB4B1, 0xB4B1}, {0xB4B2, 0xB4B2, 0xB4B2},
    {0xB4B3, 0xB4B3, 0xB4B3}, {0xB4B4, 0xB4B4, 0xB4B4},
    {0xB4B5, 0xB4B5, 0xB4B5}, {0xB4B6, 0xB4B6, 0xB4B6},
    {0xB4B7, 0xB4B7, 0xB4B7}, {0xB4B8, 0xB4B8, 0xB4B8},
    {0xB4B9, 0xB4B9, 0xB4B9}, {0xB4BA, 0xB4BA, 0xB4BA},
    {0xB4BB, 0xB4BB, 0xB4BB}, {0xB4BC, 0xB4BC, 0xB4BC},
    {0xB4BD, 0xB4BD, 0xB4BD}, {0xB4BE, 0xB4BE, 0xB4BE},
    {0xB4BF, 0xB4BF, 0xB4BF}, {0xB4C0, 0xB4C0, 0xB4C0},
    {0xB4C1, 0xB4C1, 0xB4C1}, {0xB4C2, 0xB4C2, 0xB4C2},
    {0xB4C3, 0xB4C3, 0xB4C3}, {0xB4C4, 0xB4C4, 0xB4C4},
    {0xB4C5, 0xB4C5, 0xB4C5}, {0xB4C6, 0xB4C6, 0xB4C6},
    {0xB4C7, 0xB4C7, 0xB4C7}, {0xB4C8, 0xB4C8, 0xB4C8},
    {0xB4C9, 0xB4C9, 0xB4C9}, {0xB4CA, 0xB4CA, 0xB4CA},
    {0xB4CB, 0xB4CB, 0xB4CB}, {0xB4CC, 0xB4CC, 0xB4CC},
    {0xB4CD, 0xB4CD, 0xB4CD}, {0xB4CE, 0xB4CE, 0xB4CE},
    {0xB4CF, 0xB4CF, 0xB4CF}, {0xB4D0, 0xB4D0, 0xB4D0},
    {0xB4D1, 0xB4D1, 0xB4D1}, {0xB4D2, 0xB4D2, 0xB4D2},
    {0xB4D3, 0xB4D3, 0xB4D3}, {0xB4D4, 0xB4D4, 0xB4D4},
    {0xB4D5, 0xB4D5, 0xB4D5}, {0xB4D6, 0xB4D6, 0xB4D6},
    {0xB4D7, 0xB4D7, 0xB4D7}, {0xB4D8, 0xB4D8, 0xB4D8},
    {0xB4D9, 0xB4D9, 0xB4D9}, {0xB4DA, 0xB4DA, 0xB4DA},
    {0xB4DB, 0xB4DB, 0xB4DB}, {0xB4DC, 0xB4DC, 0xB4DC},
    {0xB4DD, 0xB4DD, 0xB4DD}, {0xB4DE, 0xB4DE, 0xB4DE},
    {0xB4DF, 0xB4DF, 0xB4DF}, {0xB4E0, 0xB4E0, 0xB4E0},
    {0xB4E1, 0xB4E1, 0xB4E1}, {0xB4E2, 0xB4E2, 0xB4E2},
    {0xB4E3, 0xB4E3, 0xB4E3}, {0xB4E4, 0xB4E4, 0xB4E4},
    {0xB4E5, 0xB4E5, 0xB4E5}, {0xB4E6, 0xB4E6, 0xB4E6},
    {0xB4E7, 0xB4E7, 0xB4E7}, {0xB4E8, 0xB4E8, 0xB4E8},
    {0xB4E9, 0xB4E9, 0xB4E9}, {0xB4EA, 0xB4EA, 0xB4EA},
    {0xB4EB, 0xB4EB, 0xB4EB}, {0xB4EC, 0xB4EC, 0xB4EC},
    {0xB4ED, 0xB4ED, 0xB4ED}, {0xB4EE, 0xB4EE, 0xB4EE},
    {0xB4EF, 0xB4EF, 0xB4EF}, {0xB4F0, 0xB4F0, 0xB4F0},
    {0xB4F1, 0xB4F1, 0xB4F1}, {0xB4F2, 0xB4F2, 0xB4F2},
    {0xB4F3, 0xB4F3, 0xB4F3}, {0xB4F4, 0xB4F4, 0xB4F4},
    {0xB4F5, 0xB4F5, 0xB4F5}, {0xB4F6, 0xB4F6, 0xB4F6},
    {0xB4F7, 0xB4F7, 0xB4F7}, {0xB4F8, 0xB4F8, 0xB4F8},
    {0xB4F9, 0xB4F9, 0xB4F9}, {0xB4FA, 0xB4FA, 0xB4FA},
    {0xB4FB, 0xB4FB, 0xB4FB}, {0xB4FC, 0xB4FC, 0xB4FC},
    {0xB4FD, 0xB4FD, 0xB4FD}, {0xB4FE, 0xB4FE, 0xB4FE},
    {0xB4FF, 0xB4FF, 0xB4FF}, {0xB500, 0xB500, 0xB500},
    {0xB501, 0xB501, 0xB501}, {0xB502, 0xB502, 0xB502},
    {0xB503, 0xB503, 0xB503}, {0xB504, 0xB504, 0xB504},
    {0xB505, 0xB505, 0xB505}, {0xB506, 0xB506, 0xB506},
    {0xB507, 0xB507, 0xB507}, {0xB508, 0xB508, 0xB508},
    {0xB509, 0xB509, 0xB509}, {0xB50A, 0xB50A, 0xB50A},
    {0xB50B, 0xB50B, 0xB50B}, {0xB50C, 0xB50C, 0xB50C},
    {0xB50D, 0xB50D, 0xB50D}, {0xB50E, 0xB50E, 0xB50E},
    {0xB50F, 0xB50F, 0xB50F}, {0xB510, 0xB510, 0xB510},
    {0xB511, 0xB511, 0xB511}, {0xB512, 0xB512, 0xB512},
    {0xB513, 0xB513, 0xB513}, {0xB514, 0xB514, 0xB514},
    {0xB515, 0xB515, 0xB515}, {0xB516, 0xB516, 0xB516},
    {0xB517, 0xB517, 0xB517}, {0xB518, 0xB518, 0xB518},
    {0xB519, 0xB519, 0xB519}, {0xB51A, 0xB51A, 0xB51A},
    {0xB51B, 0xB51B, 0xB51B}, {0xB51C, 0xB51C, 0xB51C},
    {0xB51D, 0xB51D, 0xB51D}, {0xB51E, 0xB51E, 0xB51E},
    {0xB51F, 0xB51F, 0xB51F}, {0xB520, 0xB520, 0xB520},
    {0xB521, 0xB521, 0xB521}, {0xB522, 0xB522, 0xB522},
    {0xB523, 0xB523, 0xB523}, {0xB524, 0xB524, 0xB524},
    {0xB525, 0xB525, 0xB525}, {0xB526, 0xB526, 0xB526},
    {0xB527, 0xB527, 0xB527}, {0xB528, 0xB528, 0xB528},
    {0xB529, 0xB529, 0xB529}, {0xB52A, 0xB52A, 0xB52A},
    {0xB52B, 0xB52B, 0xB52B}, {0xB52C, 0xB52C, 0xB52C},
    {0xB52D, 0xB52D, 0xB52D}, {0xB52E, 0xB52E, 0xB52E},
    {0xB52F, 0xB52F, 0xB52F}, {0xB530, 0xB530, 0xB530},
    {0xB531, 0xB531, 0xB531}, {0xB532, 0xB532, 0xB532},
    {0xB533, 0xB533, 0xB533}, {0xB534, 0xB534, 0xB534},
    {0xB535, 0xB535, 0xB535}, {0xB536, 0xB536, 0xB536},
    {0xB537, 0xB537, 0xB537}, {0xB538, 0xB538, 0xB538},
    {0xB539, 0xB539, 0xB539}, {0xB53A, 0xB53A, 0xB53A},
    {0xB53B, 0xB53B, 0xB53B}, {0xB53C, 0xB53C, 0xB53C},
    {0xB53D, 0xB53D, 0xB53D}, {0xB53E, 0xB53E, 0xB53E},
    {0xB53F, 0xB53F, 0xB53F}, {0xB540, 0xB540, 0xB540},
    {0xB541, 0xB541, 0xB541}, {0xB542, 0xB542, 0xB542},
    {0xB543, 0xB543, 0xB543}, {0xB544, 0xB544, 0xB544},
    {0xB545, 0xB545, 0xB545}, {0xB546, 0xB546, 0xB546},
    {0xB547, 0xB547, 0xB547}, {0xB548, 0xB548, 0xB548},
    {0xB549, 0xB549, 0xB549}, {0xB54A, 0xB54A, 0xB54A},
    {0xB54B, 0xB54B, 0xB54B}, {0xB54C, 0xB54C, 0xB54C},
    {0xB54D, 0xB54D, 0xB54D}, {0xB54E, 0xB54E, 0xB54E},
    {0xB54F, 0xB54F, 0xB54F}, {0xB550, 0xB550, 0xB550},
    {0xB551, 0xB551, 0xB551}, {0xB552, 0xB552, 0xB552},
    {0xB553, 0xB553, 0xB553}, {0xB554, 0xB554, 0xB554},
    {0xB555, 0xB555, 0xB555}, {0xB556, 0xB556, 0xB556},
    {0xB557, 0xB557, 0xB557}, {0xB558, 0xB558, 0xB558},
    {0xB559, 0xB559, 0xB559}, {0xB55A, 0xB55A, 0xB55A},
    {0xB55B, 0xB55B, 0xB55B}, {0xB55C, 0xB55C, 0xB55C},
    {0xB55D, 0xB55D, 0xB55D}, {0xB55E, 0xB55E, 0xB55E},
    {0xB55F, 0xB55F, 0xB55F}, {0xB560, 0xB560, 0xB560},
    {0xB561, 0xB561, 0xB561}, {0xB562, 0xB562, 0xB562},
    {0xB563, 0xB563, 0xB563}, {0xB564, 0xB564, 0xB564},
    {0xB565, 0xB565, 0xB565}, {0xB566, 0xB566, 0xB566},
    {0xB567, 0xB567, 0xB567}, {0xB568, 0xB568, 0xB568},
    {0xB569, 0xB569, 0xB569}, {0xB56A, 0xB56A, 0xB56A},
    {0xB56B, 0xB56B, 0xB56B}, {0xB56C, 0xB56C, 0xB56C},
    {0xB56D, 0xB56D, 0xB56D}, {0xB56E, 0xB56E, 0xB56E},
    {0xB56F, 0xB56F, 0xB56F}, {0xB570, 0xB570, 0xB570},
    {0xB571, 0xB571, 0xB571}, {0xB572, 0xB572, 0xB572},
    {0xB573, 0xB573, 0xB573}, {0xB574, 0xB574, 0xB574},
    {0xB575, 0xB575, 0xB575}, {0xB576, 0xB576, 0xB576},
    {0xB577, 0xB577, 0xB577}, {0xB578, 0xB578, 0xB578},
    {0xB579, 0xB579, 0xB579}, {0xB57A, 0xB57A, 0xB57A},
    {0xB57B, 0xB57B, 0xB57B}, {0xB57C, 0xB57C, 0xB57C},
    {0xB57D, 0xB57D, 0xB57D}, {0xB57E, 0xB57E, 0xB57E},
    {0xB57F, 0xB57F, 0xB57F}, {0xB580, 0xB580, 0xB580},
    {0xB581, 0xB581, 0xB581}, {0xB582, 0xB582, 0xB582},
    {0xB583, 0xB583, 0xB583}, {0xB584, 0xB584, 0xB584},
    {0xB585, 0xB585, 0xB585}, {0xB586, 0xB586, 0xB586},
    {0xB587, 0xB587, 0xB587}, {0xB588, 0xB588, 0xB588},
    {0xB589, 0xB589, 0xB589}, {0xB58A, 0xB58A, 0xB58A},
    {0xB58B, 0xB58B, 0xB58B}, {0xB58C, 0xB58C, 0xB58C},
    {0xB58D, 0xB58D, 0xB58D}, {0xB58E, 0xB58E, 0xB58E},
    {0xB58F, 0xB58F, 0xB58F}, {0xB590, 0xB590, 0xB590},
    {0xB591, 0xB591, 0xB591}, {0xB592, 0xB592, 0xB592},
    {0xB593, 0xB593, 0xB593}, {0xB594, 0xB594, 0xB594},
    {0xB595, 0xB595, 0xB595}, {0xB596, 0xB596, 0xB596},
    {0xB597, 0xB597, 0xB597}, {0xB598, 0xB598, 0xB598},
    {0xB599, 0xB599, 0xB599}, {0xB59A, 0xB59A, 0xB59A},
    {0xB59B, 0xB59B, 0xB59B}, {0xB59C, 0xB59C, 0xB59C},
    {0xB59D, 0xB59D, 0xB59D}, {0xB59E, 0xB59E, 0xB59E},
    {0xB59F, 0xB59F, 0xB59F}, {0xB5A0, 0xB5A0, 0xB5A0},
    {0xB5A1, 0xB5A1, 0xB5A1}, {0xB5A2, 0xB5A2, 0xB5A2},
    {0xB5A3, 0xB5A3, 0xB5A3}, {0xB5A4, 0xB5A4, 0xB5A4},
    {0xB5A5, 0xB5A5, 0xB5A5}, {0xB5A6, 0xB5A6, 0xB5A6},
    {0xB5A7, 0xB5A7, 0xB5A7}, {0xB5A8, 0xB5A8, 0xB5A8},
    {0xB5A9, 0xB5A9, 0xB5A9}, {0xB5AA, 0xB5AA, 0xB5AA},
    {0xB5AB, 0xB5AB, 0xB5AB}, {0xB5AC, 0xB5AC, 0xB5AC},
    {0xB5AD, 0xB5AD, 0xB5AD}, {0xB5AE, 0xB5AE, 0xB5AE},
    {0xB5AF, 0xB5AF, 0xB5AF}, {0xB5B0, 0xB5B0, 0xB5B0},
    {0xB5B1, 0xB5B1, 0xB5B1}, {0xB5B2, 0xB5B2, 0xB5B2},
    {0xB5B3, 0xB5B3, 0xB5B3}, {0xB5B4, 0xB5B4, 0xB5B4},
    {0xB5B5, 0xB5B5, 0xB5B5}, {0xB5B6, 0xB5B6, 0xB5B6},
    {0xB5B7, 0xB5B7, 0xB5B7}, {0xB5B8, 0xB5B8, 0xB5B8},
    {0xB5B9, 0xB5B9, 0xB5B9}, {0xB5BA, 0xB5BA, 0xB5BA},
    {0xB5BB, 0xB5BB, 0xB5BB}, {0xB5BC, 0xB5BC, 0xB5BC},
    {0xB5BD, 0xB5BD, 0xB5BD}, {0xB5BE, 0xB5BE, 0xB5BE},
    {0xB5BF, 0xB5BF, 0xB5BF}, {0xB5C0, 0xB5C0, 0xB5C0},
    {0xB5C1, 0xB5C1, 0xB5C1}, {0xB5C2, 0xB5C2, 0xB5C2},
    {0xB5C3, 0xB5C3, 0xB5C3}, {0xB5C4, 0xB5C4, 0xB5C4},
    {0xB5C5, 0xB5C5, 0xB5C5}, {0xB5C6, 0xB5C6, 0xB5C6},
    {0xB5C7, 0xB5C7, 0xB5C7}, {0xB5C8, 0xB5C8, 0xB5C8},
    {0xB5C9, 0xB5C9, 0xB5C9}, {0xB5CA, 0xB5CA, 0xB5CA},
    {0xB5CB, 0xB5CB, 0xB5CB}, {0xB5CC, 0xB5CC, 0xB5CC},
    {0xB5CD, 0xB5CD, 0xB5CD}, {0xB5CE, 0xB5CE, 0xB5CE},
    {0xB5CF, 0xB5CF, 0xB5CF}, {0xB5D0, 0xB5D0, 0xB5D0},
    {0xB5D1, 0xB5D1, 0xB5D1}, {0xB5D2, 0xB5D2, 0xB5D2},
    {0xB5D3, 0xB5D3, 0xB5D3}, {0xB5D4, 0xB5D4, 0xB5D4},
    {0xB5D5, 0xB5D5, 0xB5D5}, {0xB5D6, 0xB5D6, 0xB5D6},
    {0xB5D7, 0xB5D7, 0xB5D7}, {0xB5D8, 0xB5D8, 0xB5D8},
    {0xB5D9, 0xB5D9, 0xB5D9}, {0xB5DA, 0xB5DA, 0xB5DA},
    {0xB5DB, 0xB5DB, 0xB5DB}, {0xB5DC, 0xB5DC, 0xB5DC},
    {0xB5DD, 0xB5DD, 0xB5DD}, {0xB5DE, 0xB5DE, 0xB5DE},
    {0xB5DF, 0xB5DF, 0xB5DF}, {0xB5E0, 0xB5E0, 0xB5E0},
    {0xB5E1, 0xB5E1, 0xB5E1}, {0xB5E2, 0xB5E2, 0xB5E2},
    {0xB5E3, 0xB5E3, 0xB5E3}, {0xB5E4, 0xB5E4, 0xB5E4},
    {0xB5E5, 0xB5E5, 0xB5E5}, {0xB5E6, 0xB5E6, 0xB5E6},
    {0xB5E7, 0xB5E7, 0xB5E7}, {0xB5E8, 0xB5E8, 0xB5E8},
    {0xB5E9, 0xB5E9, 0xB5E9}, {0xB5EA, 0xB5EA, 0xB5EA},
    {0xB5EB, 0xB5EB, 0xB5EB}, {0xB5EC, 0xB5EC, 0xB5EC},
    {0xB5ED, 0xB5ED, 0xB5ED}, {0xB5EE, 0xB5EE, 0xB5EE},
    {0xB5EF, 0xB5EF, 0xB5EF}, {0xB5F0, 0xB5F0, 0xB5F0},
    {0xB5F1, 0xB5F1, 0xB5F1}, {0xB5F2, 0xB5F2, 0xB5F2},
    {0xB5F3, 0xB5F3, 0xB5F3}, {0xB5F4, 0xB5F4, 0xB5F4},
    {0xB5F5, 0xB5F5, 0xB5F5}, {0xB5F6, 0xB5F6, 0xB5F6},
    {0xB5F7, 0xB5F7, 0xB5F7}, {0xB5F8, 0xB5F8, 0xB5F8},
    {0xB5F9, 0xB5F9, 0xB5F9}, {0xB5FA, 0xB5FA, 0xB5FA},
    {0xB5FB, 0xB5FB, 0xB5FB}, {0xB5FC, 0xB5FC, 0xB5FC},
    {0xB5FD, 0xB5FD, 0xB5FD}, {0xB5FE, 0xB5FE, 0xB5FE},
    {0xB5FF, 0xB5FF, 0xB5FF}, {0xB600, 0xB600, 0xB600},
    {0xB601, 0xB601, 0xB601}, {0xB602, 0xB602, 0xB602},
    {0xB603, 0xB603, 0xB603}, {0xB604, 0xB604, 0xB604},
    {0xB605, 0xB605, 0xB605}, {0xB606, 0xB606, 0xB606},
    {0xB607, 0xB607, 0xB607}, {0xB608, 0xB608, 0xB608},
    {0xB609, 0xB609, 0xB609}, {0xB60A, 0xB60A, 0xB60A},
    {0xB60B, 0xB60B, 0xB60B}, {0xB60C, 0xB60C, 0xB60C},
    {0xB60D, 0xB60D, 0xB60D}, {0xB60E, 0xB60E, 0xB60E},
    {0xB60F, 0xB60F, 0xB60F}, {0xB610, 0xB610, 0xB610},
    {0xB611, 0xB611, 0xB611}, {0xB612, 0xB612, 0xB612},
    {0xB613, 0xB613, 0xB613}, {0xB614, 0xB614, 0xB614},
    {0xB615, 0xB615, 0xB615}, {0xB616, 0xB616, 0xB616},
    {0xB617, 0xB617, 0xB617}, {0xB618, 0xB618, 0xB618},
    {0xB619, 0xB619, 0xB619}, {0xB61A, 0xB61A, 0xB61A},
    {0xB61B, 0xB61B, 0xB61B}, {0xB61C, 0xB61C, 0xB61C},
    {0xB61D, 0xB61D, 0xB61D}, {0xB61E, 0xB61E, 0xB61E},
    {0xB61F, 0xB61F, 0xB61F}, {0xB620, 0xB620, 0xB620},
    {0xB621, 0xB621, 0xB621}, {0xB622, 0xB622, 0xB622},
    {0xB623, 0xB623, 0xB623}, {0xB624, 0xB624, 0xB624},
    {0xB625, 0xB625, 0xB625}, {0xB626, 0xB626, 0xB626},
    {0xB627, 0xB627, 0xB627}, {0xB628, 0xB628, 0xB628},
    {0xB629, 0xB629, 0xB629}, {0xB62A, 0xB62A, 0xB62A},
    {0xB62B, 0xB62B, 0xB62B}, {0xB62C, 0xB62C, 0xB62C},
    {0xB62D, 0xB62D, 0xB62D}, {0xB62E, 0xB62E, 0xB62E},
    {0xB62F, 0xB62F, 0xB62F}, {0xB630, 0xB630, 0xB630},
    {0xB631, 0xB631, 0xB631}, {0xB632, 0xB632, 0xB632},
    {0xB633, 0xB633, 0xB633}, {0xB634, 0xB634, 0xB634},
    {0xB635, 0xB635, 0xB635}, {0xB636, 0xB636, 0xB636},
    {0xB637, 0xB637, 0xB637}, {0xB638, 0xB638, 0xB638},
    {0xB639, 0xB639, 0xB639}, {0xB63A, 0xB63A, 0xB63A},
    {0xB63B, 0xB63B, 0xB63B}, {0xB63C, 0xB63C, 0xB63C},
    {0xB63D, 0xB63D, 0xB63D}, {0xB63E, 0xB63E, 0xB63E},
    {0xB63F, 0xB63F, 0xB63F}, {0xB640, 0xB640, 0xB640},
    {0xB641, 0xB641, 0xB641}, {0xB642, 0xB642, 0xB642},
    {0xB643, 0xB643, 0xB643}, {0xB644, 0xB644, 0xB644},
    {0xB645, 0xB645, 0xB645}, {0xB646, 0xB646, 0xB646},
    {0xB647, 0xB647, 0xB647}, {0xB648, 0xB648, 0xB648},
    {0xB649, 0xB649, 0xB649}, {0xB64A, 0xB64A, 0xB64A},
    {0xB64B, 0xB64B, 0xB64B}, {0xB64C, 0xB64C, 0xB64C},
    {0xB64D, 0xB64D, 0xB64D}, {0xB64E, 0xB64E, 0xB64E},
    {0xB64F, 0xB64F, 0xB64F}, {0xB650, 0xB650, 0xB650},
    {0xB651, 0xB651, 0xB651}, {0xB652, 0xB652, 0xB652},
    {0xB653, 0xB653, 0xB653}, {0xB654, 0xB654, 0xB654},
    {0xB655, 0xB655, 0xB655}, {0xB656, 0xB656, 0xB656},
    {0xB657, 0xB657, 0xB657}, {0xB658, 0xB658, 0xB658},
    {0xB659, 0xB659, 0xB659}, {0xB65A, 0xB65A, 0xB65A},
    {0xB65B, 0xB65B, 0xB65B}, {0xB65C, 0xB65C, 0xB65C},
    {0xB65D, 0xB65D, 0xB65D}, {0xB65E, 0xB65E, 0xB65E},
    {0xB65F, 0xB65F, 0xB65F}, {0xB660, 0xB660, 0xB660},
    {0xB661, 0xB661, 0xB661}, {0xB662, 0xB662, 0xB662},
    {0xB663, 0xB663, 0xB663}, {0xB664, 0xB664, 0xB664},
    {0xB665, 0xB665, 0xB665}, {0xB666, 0xB666, 0xB666},
    {0xB667, 0xB667, 0xB667}, {0xB668, 0xB668, 0xB668},
    {0xB669, 0xB669, 0xB669}, {0xB66A, 0xB66A, 0xB66A},
    {0xB66B, 0xB66B, 0xB66B}, {0xB66C, 0xB66C, 0xB66C},
    {0xB66D, 0xB66D, 0xB66D}, {0xB66E, 0xB66E, 0xB66E},
    {0xB66F, 0xB66F, 0xB66F}, {0xB670, 0xB670, 0xB670},
    {0xB671, 0xB671, 0xB671}, {0xB672, 0xB672, 0xB672},
    {0xB673, 0xB673, 0xB673}, {0xB674, 0xB674, 0xB674},
    {0xB675, 0xB675, 0xB675}, {0xB676, 0xB676, 0xB676},
    {0xB677, 0xB677, 0xB677}, {0xB678, 0xB678, 0xB678},
    {0xB679, 0xB679, 0xB679}, {0xB67A, 0xB67A, 0xB67A},
    {0xB67B, 0xB67B, 0xB67B}, {0xB67C, 0xB67C, 0xB67C},
    {0xB67D, 0xB67D, 0xB67D}, {0xB67E, 0xB67E, 0xB67E},
    {0xB67F, 0xB67F, 0xB67F}, {0xB680, 0xB680, 0xB680},
    {0xB681, 0xB681, 0xB681}, {0xB682, 0xB682, 0xB682},
    {0xB683, 0xB683, 0xB683}, {0xB684, 0xB684, 0xB684},
    {0xB685, 0xB685, 0xB685}, {0xB686, 0xB686, 0xB686},
    {0xB687, 0xB687, 0xB687}, {0xB688, 0xB688, 0xB688},
    {0xB689, 0xB689, 0xB689}, {0xB68A, 0xB68A, 0xB68A},
    {0xB68B, 0xB68B, 0xB68B}, {0xB68C, 0xB68C, 0xB68C},
    {0xB68D, 0xB68D, 0xB68D}, {0xB68E, 0xB68E, 0xB68E},
    {0xB68F, 0xB68F, 0xB68F}, {0xB690, 0xB690, 0xB690},
    {0xB691, 0xB691, 0xB691}, {0xB692, 0xB692, 0xB692},
    {0xB693, 0xB693, 0xB693}, {0xB694, 0xB694, 0xB694},
    {0xB695, 0xB695, 0xB695}, {0xB696, 0xB696, 0xB696},
    {0xB697, 0xB697, 0xB697}, {0xB698, 0xB698, 0xB698},
    {0xB699, 0xB699, 0xB699}, {0xB69A, 0xB69A, 0xB69A},
    {0xB69B, 0xB69B, 0xB69B}, {0xB69C, 0xB69C, 0xB69C},
    {0xB69D, 0xB69D, 0xB69D}, {0xB69E, 0xB69E, 0xB69E},
    {0xB69F, 0xB69F, 0xB69F}, {0xB6A0, 0xB6A0, 0xB6A0},
    {0xB6A1, 0xB6A1, 0xB6A1}, {0xB6A2, 0xB6A2, 0xB6A2},
    {0xB6A3, 0xB6A3, 0xB6A3}, {0xB6A4, 0xB6A4, 0xB6A4},
    {0xB6A5, 0xB6A5, 0xB6A5}, {0xB6A6, 0xB6A6, 0xB6A6},
    {0xB6A7, 0xB6A7, 0xB6A7}, {0xB6A8, 0xB6A8, 0xB6A8},
    {0xB6A9, 0xB6A9, 0xB6A9}, {0xB6AA, 0xB6AA, 0xB6AA},
    {0xB6AB, 0xB6AB, 0xB6AB}, {0xB6AC, 0xB6AC, 0xB6AC},
    {0xB6AD, 0xB6AD, 0xB6AD}, {0xB6AE, 0xB6AE, 0xB6AE},
    {0xB6AF, 0xB6AF, 0xB6AF}, {0xB6B0, 0xB6B0, 0xB6B0},
    {0xB6B1, 0xB6B1, 0xB6B1}, {0xB6B2, 0xB6B2, 0xB6B2},
    {0xB6B3, 0xB6B3, 0xB6B3}, {0xB6B4, 0xB6B4, 0xB6B4},
    {0xB6B5, 0xB6B5, 0xB6B5}, {0xB6B6, 0xB6B6, 0xB6B6},
    {0xB6B7, 0xB6B7, 0xB6B7}, {0xB6B8, 0xB6B8, 0xB6B8},
    {0xB6B9, 0xB6B9, 0xB6B9}, {0xB6BA, 0xB6BA, 0xB6BA},
    {0xB6BB, 0xB6BB, 0xB6BB}, {0xB6BC, 0xB6BC, 0xB6BC},
    {0xB6BD, 0xB6BD, 0xB6BD}, {0xB6BE, 0xB6BE, 0xB6BE},
    {0xB6BF, 0xB6BF, 0xB6BF}, {0xB6C0, 0xB6C0, 0xB6C0},
    {0xB6C1, 0xB6C1, 0xB6C1}, {0xB6C2, 0xB6C2, 0xB6C2},
    {0xB6C3, 0xB6C3, 0xB6C3}, {0xB6C4, 0xB6C4, 0xB6C4},
    {0xB6C5, 0xB6C5, 0xB6C5}, {0xB6C6, 0xB6C6, 0xB6C6},
    {0xB6C7, 0xB6C7, 0xB6C7}, {0xB6C8, 0xB6C8, 0xB6C8},
    {0xB6C9, 0xB6C9, 0xB6C9}, {0xB6CA, 0xB6CA, 0xB6CA},
    {0xB6CB, 0xB6CB, 0xB6CB}, {0xB6CC, 0xB6CC, 0xB6CC},
    {0xB6CD, 0xB6CD, 0xB6CD}, {0xB6CE, 0xB6CE, 0xB6CE},
    {0xB6CF, 0xB6CF, 0xB6CF}, {0xB6D0, 0xB6D0, 0xB6D0},
    {0xB6D1, 0xB6D1, 0xB6D1}, {0xB6D2, 0xB6D2, 0xB6D2},
    {0xB6D3, 0xB6D3, 0xB6D3}, {0xB6D4, 0xB6D4, 0xB6D4},
    {0xB6D5, 0xB6D5, 0xB6D5}, {0xB6D6, 0xB6D6, 0xB6D6},
    {0xB6D7, 0xB6D7, 0xB6D7}, {0xB6D8, 0xB6D8, 0xB6D8},
    {0xB6D9, 0xB6D9, 0xB6D9}, {0xB6DA, 0xB6DA, 0xB6DA},
    {0xB6DB, 0xB6DB, 0xB6DB}, {0xB6DC, 0xB6DC, 0xB6DC},
    {0xB6DD, 0xB6DD, 0xB6DD}, {0xB6DE, 0xB6DE, 0xB6DE},
    {0xB6DF, 0xB6DF, 0xB6DF}, {0xB6E0, 0xB6E0, 0xB6E0},
    {0xB6E1, 0xB6E1, 0xB6E1}, {0xB6E2, 0xB6E2, 0xB6E2},
    {0xB6E3, 0xB6E3, 0xB6E3}, {0xB6E4, 0xB6E4, 0xB6E4},
    {0xB6E5, 0xB6E5, 0xB6E5}, {0xB6E6, 0xB6E6, 0xB6E6},
    {0xB6E7, 0xB6E7, 0xB6E7}, {0xB6E8, 0xB6E8, 0xB6E8},
    {0xB6E9, 0xB6E9, 0xB6E9}, {0xB6EA, 0xB6EA, 0xB6EA},
    {0xB6EB, 0xB6EB, 0xB6EB}, {0xB6EC, 0xB6EC, 0xB6EC},
    {0xB6ED, 0xB6ED, 0xB6ED}, {0xB6EE, 0xB6EE, 0xB6EE},
    {0xB6EF, 0xB6EF, 0xB6EF}, {0xB6F0, 0xB6F0, 0xB6F0},
    {0xB6F1, 0xB6F1, 0xB6F1}, {0xB6F2, 0xB6F2, 0xB6F2},
    {0xB6F3, 0xB6F3, 0xB6F3}, {0xB6F4, 0xB6F4, 0xB6F4},
    {0xB6F5, 0xB6F5, 0xB6F5}, {0xB6F6, 0xB6F6, 0xB6F6},
    {0xB6F7, 0xB6F7, 0xB6F7}, {0xB6F8, 0xB6F8, 0xB6F8},
    {0xB6F9, 0xB6F9, 0xB6F9}, {0xB6FA, 0xB6FA, 0xB6FA},
    {0xB6FB, 0xB6FB, 0xB6FB}, {0xB6FC, 0xB6FC, 0xB6FC},
    {0xB6FD, 0xB6FD, 0xB6FD}, {0xB6FE, 0xB6FE, 0xB6FE},
    {0xB6FF, 0xB6FF, 0xB6FF}, {0xB700, 0xB700, 0xB700},
    {0xB701, 0xB701, 0xB701}, {0xB702, 0xB702, 0xB702},
    {0xB703, 0xB703, 0xB703}, {0xB704, 0xB704, 0xB704},
    {0xB705, 0xB705, 0xB705}, {0xB706, 0xB706, 0xB706},
    {0xB707, 0xB707, 0xB707}, {0xB708, 0xB708, 0xB708},
    {0xB709, 0xB709, 0xB709}, {0xB70A, 0xB70A, 0xB70A},
    {0xB70B, 0xB70B, 0xB70B}, {0xB70C, 0xB70C, 0xB70C},
    {0xB70D, 0xB70D, 0xB70D}, {0xB70E, 0xB70E, 0xB70E},
    {0xB70F, 0xB70F, 0xB70F}, {0xB710, 0xB710, 0xB710},
    {0xB711, 0xB711, 0xB711}, {0xB712, 0xB712, 0xB712},
    {0xB713, 0xB713, 0xB713}, {0xB714, 0xB714, 0xB714},
    {0xB715, 0xB715, 0xB715}, {0xB716, 0xB716, 0xB716},
    {0xB717, 0xB717, 0xB717}, {0xB718, 0xB718, 0xB718},
    {0xB719, 0xB719, 0xB719}, {0xB71A, 0xB71A, 0xB71A},
    {0xB71B, 0xB71B, 0xB71B}, {0xB71C, 0xB71C, 0xB71C},
    {0xB71D, 0xB71D, 0xB71D}, {0xB71E, 0xB71E, 0xB71E},
    {0xB71F, 0xB71F, 0xB71F}, {0xB720, 0xB720, 0xB720},
    {0xB721, 0xB721, 0xB721}, {0xB722, 0xB722, 0xB722},
    {0xB723, 0xB723, 0xB723}, {0xB724, 0xB724, 0xB724},
    {0xB725, 0xB725, 0xB725}, {0xB726, 0xB726, 0xB726},
    {0xB727, 0xB727, 0xB727}, {0xB728, 0xB728, 0xB728},
    {0xB729, 0xB729, 0xB729}, {0xB72A, 0xB72A, 0xB72A},
    {0xB72B, 0xB72B, 0xB72B}, {0xB72C, 0xB72C, 0xB72C},
    {0xB72D, 0xB72D, 0xB72D}, {0xB72E, 0xB72E, 0xB72E},
    {0xB72F, 0xB72F, 0xB72F}, {0xB730, 0xB730, 0xB730},
    {0xB731, 0xB731, 0xB731}, {0xB732, 0xB732, 0xB732},
    {0xB733, 0xB733, 0xB733}, {0xB734, 0xB734, 0xB734},
    {0xB735, 0xB735, 0xB735}, {0xB736, 0xB736, 0xB736},
    {0xB737, 0xB737, 0xB737}, {0xB738, 0xB738, 0xB738},
    {0xB739, 0xB739, 0xB739}, {0xB73A, 0xB73A, 0xB73A},
    {0xB73B, 0xB73B, 0xB73B}, {0xB73C, 0xB73C, 0xB73C},
    {0xB73D, 0xB73D, 0xB73D}, {0xB73E, 0xB73E, 0xB73E},
    {0xB73F, 0xB73F, 0xB73F}, {0xB740, 0xB740, 0xB740},
    {0xB741, 0xB741, 0xB741}, {0xB742, 0xB742, 0xB742},
    {0xB743, 0xB743, 0xB743}, {0xB744, 0xB744, 0xB744},
    {0xB745, 0xB745, 0xB745}, {0xB746, 0xB746, 0xB746},
    {0xB747, 0xB747, 0xB747}, {0xB748, 0xB748, 0xB748},
    {0xB749, 0xB749, 0xB749}, {0xB74A, 0xB74A, 0xB74A},
    {0xB74B, 0xB74B, 0xB74B}, {0xB74C, 0xB74C, 0xB74C},
    {0xB74D, 0xB74D, 0xB74D}, {0xB74E, 0xB74E, 0xB74E},
    {0xB74F, 0xB74F, 0xB74F}, {0xB750, 0xB750, 0xB750},
    {0xB751, 0xB751, 0xB751}, {0xB752, 0xB752, 0xB752},
    {0xB753, 0xB753, 0xB753}, {0xB754, 0xB754, 0xB754},
    {0xB755, 0xB755, 0xB755}, {0xB756, 0xB756, 0xB756},
    {0xB757, 0xB757, 0xB757}, {0xB758, 0xB758, 0xB758},
    {0xB759, 0xB759, 0xB759}, {0xB75A, 0xB75A, 0xB75A},
    {0xB75B, 0xB75B, 0xB75B}, {0xB75C, 0xB75C, 0xB75C},
    {0xB75D, 0xB75D, 0xB75D}, {0xB75E, 0xB75E, 0xB75E},
    {0xB75F, 0xB75F, 0xB75F}, {0xB760, 0xB760, 0xB760},
    {0xB761, 0xB761, 0xB761}, {0xB762, 0xB762, 0xB762},
    {0xB763, 0xB763, 0xB763}, {0xB764, 0xB764, 0xB764},
    {0xB765, 0xB765, 0xB765}, {0xB766, 0xB766, 0xB766},
    {0xB767, 0xB767, 0xB767}, {0xB768, 0xB768, 0xB768},
    {0xB769, 0xB769, 0xB769}, {0xB76A, 0xB76A, 0xB76A},
    {0xB76B, 0xB76B, 0xB76B}, {0xB76C, 0xB76C, 0xB76C},
    {0xB76D, 0xB76D, 0xB76D}, {0xB76E, 0xB76E, 0xB76E},
    {0xB76F, 0xB76F, 0xB76F}, {0xB770, 0xB770, 0xB770},
    {0xB771, 0xB771, 0xB771}, {0xB772, 0xB772, 0xB772},
    {0xB773, 0xB773, 0xB773}, {0xB774, 0xB774, 0xB774},
    {0xB775, 0xB775, 0xB775}, {0xB776, 0xB776, 0xB776},
    {0xB777, 0xB777, 0xB777}, {0xB778, 0xB778, 0xB778},
    {0xB779, 0xB779, 0xB779}, {0xB77A, 0xB77A, 0xB77A},
    {0xB77B, 0xB77B, 0xB77B}, {0xB77C, 0xB77C, 0xB77C},
    {0xB77D, 0xB77D, 0xB77D}, {0xB77E, 0xB77E, 0xB77E},
    {0xB77F, 0xB77F, 0xB77F}, {0xB780, 0xB780, 0xB780},
    {0xB781, 0xB781, 0xB781}, {0xB782, 0xB782, 0xB782},
    {0xB783, 0xB783, 0xB783}, {0xB784, 0xB784, 0xB784},
    {0xB785, 0xB785, 0xB785}, {0xB786, 0xB786, 0xB786},
    {0xB787, 0xB787, 0xB787}, {0xB788, 0xB788, 0xB788},
    {0xB789, 0xB789, 0xB789}, {0xB78A, 0xB78A, 0xB78A},
    {0xB78B, 0xB78B, 0xB78B}, {0xB78C, 0xB78C, 0xB78C},
    {0xB78D, 0xB78D, 0xB78D}, {0xB78E, 0xB78E, 0xB78E},
    {0xB78F, 0xB78F, 0xB78F}, {0xB790, 0xB790, 0xB790},
    {0xB791, 0xB791, 0xB791}, {0xB792, 0xB792, 0xB792},
    {0xB793, 0xB793, 0xB793}, {0xB794, 0xB794, 0xB794},
    {0xB795, 0xB795, 0xB795}, {0xB796, 0xB796, 0xB796},
    {0xB797, 0xB797, 0xB797}, {0xB798, 0xB798, 0xB798},
    {0xB799, 0xB799, 0xB799}, {0xB79A, 0xB79A, 0xB79A},
    {0xB79B, 0xB79B, 0xB79B}, {0xB79C, 0xB79C, 0xB79C},
    {0xB79D, 0xB79D, 0xB79D}, {0xB79E, 0xB79E, 0xB79E},
    {0xB79F, 0xB79F, 0xB79F}, {0xB7A0, 0xB7A0, 0xB7A0},
    {0xB7A1, 0xB7A1, 0xB7A1}, {0xB7A2, 0xB7A2, 0xB7A2},
    {0xB7A3, 0xB7A3, 0xB7A3}, {0xB7A4, 0xB7A4, 0xB7A4},
    {0xB7A5, 0xB7A5, 0xB7A5}, {0xB7A6, 0xB7A6, 0xB7A6},
    {0xB7A7, 0xB7A7, 0xB7A7}, {0xB7A8, 0xB7A8, 0xB7A8},
    {0xB7A9, 0xB7A9, 0xB7A9}, {0xB7AA, 0xB7AA, 0xB7AA},
    {0xB7AB, 0xB7AB, 0xB7AB}, {0xB7AC, 0xB7AC, 0xB7AC},
    {0xB7AD, 0xB7AD, 0xB7AD}, {0xB7AE, 0xB7AE, 0xB7AE},
    {0xB7AF, 0xB7AF, 0xB7AF}, {0xB7B0, 0xB7B0, 0xB7B0},
    {0xB7B1, 0xB7B1, 0xB7B1}, {0xB7B2, 0xB7B2, 0xB7B2},
    {0xB7B3, 0xB7B3, 0xB7B3}, {0xB7B4, 0xB7B4, 0xB7B4},
    {0xB7B5, 0xB7B5, 0xB7B5}, {0xB7B6, 0xB7B6, 0xB7B6},
    {0xB7B7, 0xB7B7, 0xB7B7}, {0xB7B8, 0xB7B8, 0xB7B8},
    {0xB7B9, 0xB7B9, 0xB7B9}, {0xB7BA, 0xB7BA, 0xB7BA},
    {0xB7BB, 0xB7BB, 0xB7BB}, {0xB7BC, 0xB7BC, 0xB7BC},
    {0xB7BD, 0xB7BD, 0xB7BD}, {0xB7BE, 0xB7BE, 0xB7BE},
    {0xB7BF, 0xB7BF, 0xB7BF}, {0xB7C0, 0xB7C0, 0xB7C0},
    {0xB7C1, 0xB7C1, 0xB7C1}, {0xB7C2, 0xB7C2, 0xB7C2},
    {0xB7C3, 0xB7C3, 0xB7C3}, {0xB7C4, 0xB7C4, 0xB7C4},
    {0xB7C5, 0xB7C5, 0xB7C5}, {0xB7C6, 0xB7C6, 0xB7C6},
    {0xB7C7, 0xB7C7, 0xB7C7}, {0xB7C8, 0xB7C8, 0xB7C8},
    {0xB7C9, 0xB7C9, 0xB7C9}, {0xB7CA, 0xB7CA, 0xB7CA},
    {0xB7CB, 0xB7CB, 0xB7CB}, {0xB7CC, 0xB7CC, 0xB7CC},
    {0xB7CD, 0xB7CD, 0xB7CD}, {0xB7CE, 0xB7CE, 0xB7CE},
    {0xB7CF, 0xB7CF, 0xB7CF}, {0xB7D0, 0xB7D0, 0xB7D0},
    {0xB7D1, 0xB7D1, 0xB7D1}, {0xB7D2, 0xB7D2, 0xB7D2},
    {0xB7D3, 0xB7D3, 0xB7D3}, {0xB7D4, 0xB7D4, 0xB7D4},
    {0xB7D5, 0xB7D5, 0xB7D5}, {0xB7D6, 0xB7D6, 0xB7D6},
    {0xB7D7, 0xB7D7, 0xB7D7}, {0xB7D8, 0xB7D8, 0xB7D8},
    {0xB7D9, 0xB7D9, 0xB7D9}, {0xB7DA, 0xB7DA, 0xB7DA},
    {0xB7DB, 0xB7DB, 0xB7DB}, {0xB7DC, 0xB7DC, 0xB7DC},
    {0xB7DD, 0xB7DD, 0xB7DD}, {0xB7DE, 0xB7DE, 0xB7DE},
    {0xB7DF, 0xB7DF, 0xB7DF}, {0xB7E0, 0xB7E0, 0xB7E0},
    {0xB7E1, 0xB7E1, 0xB7E1}, {0xB7E2, 0xB7E2, 0xB7E2},
    {0xB7E3, 0xB7E3, 0xB7E3}, {0xB7E4, 0xB7E4, 0xB7E4},
    {0xB7E5, 0xB7E5, 0xB7E5}, {0xB7E6, 0xB7E6, 0xB7E6},
    {0xB7E7, 0xB7E7, 0xB7E7}, {0xB7E8, 0xB7E8, 0xB7E8},
    {0xB7E9, 0xB7E9, 0xB7E9}, {0xB7EA, 0xB7EA, 0xB7EA},
    {0xB7EB, 0xB7EB, 0xB7EB}, {0xB7EC, 0xB7EC, 0xB7EC},
    {0xB7ED, 0xB7ED, 0xB7ED}, {0xB7EE, 0xB7EE, 0xB7EE},
    {0xB7EF, 0xB7EF, 0xB7EF}, {0xB7F0, 0xB7F0, 0xB7F0},
    {0xB7F1, 0xB7F1, 0xB7F1}, {0xB7F2, 0xB7F2, 0xB7F2},
    {0xB7F3, 0xB7F3, 0xB7F3}, {0xB7F4, 0xB7F4, 0xB7F4},
    {0xB7F5, 0xB7F5, 0xB7F5}, {0xB7F6, 0xB7F6, 0xB7F6},
    {0xB7F7, 0xB7F7, 0xB7F7}, {0xB7F8, 0xB7F8, 0xB7F8},
    {0xB7F9, 0xB7F9, 0xB7F9}, {0xB7FA, 0xB7FA, 0xB7FA},
    {0xB7FB, 0xB7FB, 0xB7FB}, {0xB7FC, 0xB7FC, 0xB7FC},
    {0xB7FD, 0xB7FD, 0xB7FD}, {0xB7FE, 0xB7FE, 0xB7FE},
    {0xB7FF, 0xB7FF, 0xB7FF}, {0xB800, 0xB800, 0xB800},
    {0xB801, 0xB801, 0xB801}, {0xB802, 0xB802, 0xB802},
    {0xB803, 0xB803, 0xB803}, {0xB804, 0xB804, 0xB804},
    {0xB805, 0xB805, 0xB805}, {0xB806, 0xB806, 0xB806},
    {0xB807, 0xB807, 0xB807}, {0xB808, 0xB808, 0xB808},
    {0xB809, 0xB809, 0xB809}, {0xB80A, 0xB80A, 0xB80A},
    {0xB80B, 0xB80B, 0xB80B}, {0xB80C, 0xB80C, 0xB80C},
    {0xB80D, 0xB80D, 0xB80D}, {0xB80E, 0xB80E, 0xB80E},
    {0xB80F, 0xB80F, 0xB80F}, {0xB810, 0xB810, 0xB810},
    {0xB811, 0xB811, 0xB811}, {0xB812, 0xB812, 0xB812},
    {0xB813, 0xB813, 0xB813}, {0xB814, 0xB814, 0xB814},
    {0xB815, 0xB815, 0xB815}, {0xB816, 0xB816, 0xB816},
    {0xB817, 0xB817, 0xB817}, {0xB818, 0xB818, 0xB818},
    {0xB819, 0xB819, 0xB819}, {0xB81A, 0xB81A, 0xB81A},
    {0xB81B, 0xB81B, 0xB81B}, {0xB81C, 0xB81C, 0xB81C},
    {0xB81D, 0xB81D, 0xB81D}, {0xB81E, 0xB81E, 0xB81E},
    {0xB81F, 0xB81F, 0xB81F}, {0xB820, 0xB820, 0xB820},
    {0xB821, 0xB821, 0xB821}, {0xB822, 0xB822, 0xB822},
    {0xB823, 0xB823, 0xB823}, {0xB824, 0xB824, 0xB824},
    {0xB825, 0xB825, 0xB825}, {0xB826, 0xB826, 0xB826},
    {0xB827, 0xB827, 0xB827}, {0xB828, 0xB828, 0xB828},
    {0xB829, 0xB829, 0xB829}, {0xB82A, 0xB82A, 0xB82A},
    {0xB82B, 0xB82B, 0xB82B}, {0xB82C, 0xB82C, 0xB82C},
    {0xB82D, 0xB82D, 0xB82D}, {0xB82E, 0xB82E, 0xB82E},
    {0xB82F, 0xB82F, 0xB82F}, {0xB830, 0xB830, 0xB830},
    {0xB831, 0xB831, 0xB831}, {0xB832, 0xB832, 0xB832},
    {0xB833, 0xB833, 0xB833}, {0xB834, 0xB834, 0xB834},
    {0xB835, 0xB835, 0xB835}, {0xB836, 0xB836, 0xB836},
    {0xB837, 0xB837, 0xB837}, {0xB838, 0xB838, 0xB838},
    {0xB839, 0xB839, 0xB839}, {0xB83A, 0xB83A, 0xB83A},
    {0xB83B, 0xB83B, 0xB83B}, {0xB83C, 0xB83C, 0xB83C},
    {0xB83D, 0xB83D, 0xB83D}, {0xB83E, 0xB83E, 0xB83E},
    {0xB83F, 0xB83F, 0xB83F}, {0xB840, 0xB840, 0xB840},
    {0xB841, 0xB841, 0xB841}, {0xB842, 0xB842, 0xB842},
    {0xB843, 0xB843, 0xB843}, {0xB844, 0xB844, 0xB844},
    {0xB845, 0xB845, 0xB845}, {0xB846, 0xB846, 0xB846},
    {0xB847, 0xB847, 0xB847}, {0xB848, 0xB848, 0xB848},
    {0xB849, 0xB849, 0xB849}, {0xB84A, 0xB84A, 0xB84A},
    {0xB84B, 0xB84B, 0xB84B}, {0xB84C, 0xB84C, 0xB84C},
    {0xB84D, 0xB84D, 0xB84D}, {0xB84E, 0xB84E, 0xB84E},
    {0xB84F, 0xB84F, 0xB84F}, {0xB850, 0xB850, 0xB850},
    {0xB851, 0xB851, 0xB851}, {0xB852, 0xB852, 0xB852},
    {0xB853, 0xB853, 0xB853}, {0xB854, 0xB854, 0xB854},
    {0xB855, 0xB855, 0xB855}, {0xB856, 0xB856, 0xB856},
    {0xB857, 0xB857, 0xB857}, {0xB858, 0xB858, 0xB858},
    {0xB859, 0xB859, 0xB859}, {0xB85A, 0xB85A, 0xB85A},
    {0xB85B, 0xB85B, 0xB85B}, {0xB85C, 0xB85C, 0xB85C},
    {0xB85D, 0xB85D, 0xB85D}, {0xB85E, 0xB85E, 0xB85E},
    {0xB85F, 0xB85F, 0xB85F}, {0xB860, 0xB860, 0xB860},
    {0xB861, 0xB861, 0xB861}, {0xB862, 0xB862, 0xB862},
    {0xB863, 0xB863, 0xB863}, {0xB864, 0xB864, 0xB864},
    {0xB865, 0xB865, 0xB865}, {0xB866, 0xB866, 0xB866},
    {0xB867, 0xB867, 0xB867}, {0xB868, 0xB868, 0xB868},
    {0xB869, 0xB869, 0xB869}, {0xB86A, 0xB86A, 0xB86A},
    {0xB86B, 0xB86B, 0xB86B}, {0xB86C, 0xB86C, 0xB86C},
    {0xB86D, 0xB86D, 0xB86D}, {0xB86E, 0xB86E, 0xB86E},
    {0xB86F, 0xB86F, 0xB86F}, {0xB870, 0xB870, 0xB870},
    {0xB871, 0xB871, 0xB871}, {0xB872, 0xB872, 0xB872},
    {0xB873, 0xB873, 0xB873}, {0xB874, 0xB874, 0xB874},
    {0xB875, 0xB875, 0xB875}, {0xB876, 0xB876, 0xB876},
    {0xB877, 0xB877, 0xB877}, {0xB878, 0xB878, 0xB878},
    {0xB879, 0xB879, 0xB879}, {0xB87A, 0xB87A, 0xB87A},
    {0xB87B, 0xB87B, 0xB87B}, {0xB87C, 0xB87C, 0xB87C},
    {0xB87D, 0xB87D, 0xB87D}, {0xB87E, 0xB87E, 0xB87E},
    {0xB87F, 0xB87F, 0xB87F}, {0xB880, 0xB880, 0xB880},
    {0xB881, 0xB881, 0xB881}, {0xB882, 0xB882, 0xB882},
    {0xB883, 0xB883, 0xB883}, {0xB884, 0xB884, 0xB884},
    {0xB885, 0xB885, 0xB885}, {0xB886, 0xB886, 0xB886},
    {0xB887, 0xB887, 0xB887}, {0xB888, 0xB888, 0xB888},
    {0xB889, 0xB889, 0xB889}, {0xB88A, 0xB88A, 0xB88A},
    {0xB88B, 0xB88B, 0xB88B}, {0xB88C, 0xB88C, 0xB88C},
    {0xB88D, 0xB88D, 0xB88D}, {0xB88E, 0xB88E, 0xB88E},
    {0xB88F, 0xB88F, 0xB88F}, {0xB890, 0xB890, 0xB890},
    {0xB891, 0xB891, 0xB891}, {0xB892, 0xB892, 0xB892},
    {0xB893, 0xB893, 0xB893}, {0xB894, 0xB894, 0xB894},
    {0xB895, 0xB895, 0xB895}, {0xB896, 0xB896, 0xB896},
    {0xB897, 0xB897, 0xB897}, {0xB898, 0xB898, 0xB898},
    {0xB899, 0xB899, 0xB899}, {0xB89A, 0xB89A, 0xB89A},
    {0xB89B, 0xB89B, 0xB89B}, {0xB89C, 0xB89C, 0xB89C},
    {0xB89D, 0xB89D, 0xB89D}, {0xB89E, 0xB89E, 0xB89E},
    {0xB89F, 0xB89F, 0xB89F}, {0xB8A0, 0xB8A0, 0xB8A0},
    {0xB8A1, 0xB8A1, 0xB8A1}, {0xB8A2, 0xB8A2, 0xB8A2},
    {0xB8A3, 0xB8A3, 0xB8A3}, {0xB8A4, 0xB8A4, 0xB8A4},
    {0xB8A5, 0xB8A5, 0xB8A5}, {0xB8A6, 0xB8A6, 0xB8A6},
    {0xB8A7, 0xB8A7, 0xB8A7}, {0xB8A8, 0xB8A8, 0xB8A8},
    {0xB8A9, 0xB8A9, 0xB8A9}, {0xB8AA, 0xB8AA, 0xB8AA},
    {0xB8AB, 0xB8AB, 0xB8AB}, {0xB8AC, 0xB8AC, 0xB8AC},
    {0xB8AD, 0xB8AD, 0xB8AD}, {0xB8AE, 0xB8AE, 0xB8AE},
    {0xB8AF, 0xB8AF, 0xB8AF}, {0xB8B0, 0xB8B0, 0xB8B0},
    {0xB8B1, 0xB8B1, 0xB8B1}, {0xB8B2, 0xB8B2, 0xB8B2},
    {0xB8B3, 0xB8B3, 0xB8B3}, {0xB8B4, 0xB8B4, 0xB8B4},
    {0xB8B5, 0xB8B5, 0xB8B5}, {0xB8B6, 0xB8B6, 0xB8B6},
    {0xB8B7, 0xB8B7, 0xB8B7}, {0xB8B8, 0xB8B8, 0xB8B8},
    {0xB8B9, 0xB8B9, 0xB8B9}, {0xB8BA, 0xB8BA, 0xB8BA},
    {0xB8BB, 0xB8BB, 0xB8BB}, {0xB8BC, 0xB8BC, 0xB8BC},
    {0xB8BD, 0xB8BD, 0xB8BD}, {0xB8BE, 0xB8BE, 0xB8BE},
    {0xB8BF, 0xB8BF, 0xB8BF}, {0xB8C0, 0xB8C0, 0xB8C0},
    {0xB8C1, 0xB8C1, 0xB8C1}, {0xB8C2, 0xB8C2, 0xB8C2},
    {0xB8C3, 0xB8C3, 0xB8C3}, {0xB8C4, 0xB8C4, 0xB8C4},
    {0xB8C5, 0xB8C5, 0xB8C5}, {0xB8C6, 0xB8C6, 0xB8C6},
    {0xB8C7, 0xB8C7, 0xB8C7}, {0xB8C8, 0xB8C8, 0xB8C8},
    {0xB8C9, 0xB8C9, 0xB8C9}, {0xB8CA, 0xB8CA, 0xB8CA},
    {0xB8CB, 0xB8CB, 0xB8CB}, {0xB8CC, 0xB8CC, 0xB8CC},
    {0xB8CD, 0xB8CD, 0xB8CD}, {0xB8CE, 0xB8CE, 0xB8CE},
    {0xB8CF, 0xB8CF, 0xB8CF}, {0xB8D0, 0xB8D0, 0xB8D0},
    {0xB8D1, 0xB8D1, 0xB8D1}, {0xB8D2, 0xB8D2, 0xB8D2},
    {0xB8D3, 0xB8D3, 0xB8D3}, {0xB8D4, 0xB8D4, 0xB8D4},
    {0xB8D5, 0xB8D5, 0xB8D5}, {0xB8D6, 0xB8D6, 0xB8D6},
    {0xB8D7, 0xB8D7, 0xB8D7}, {0xB8D8, 0xB8D8, 0xB8D8},
    {0xB8D9, 0xB8D9, 0xB8D9}, {0xB8DA, 0xB8DA, 0xB8DA},
    {0xB8DB, 0xB8DB, 0xB8DB}, {0xB8DC, 0xB8DC, 0xB8DC},
    {0xB8DD, 0xB8DD, 0xB8DD}, {0xB8DE, 0xB8DE, 0xB8DE},
    {0xB8DF, 0xB8DF, 0xB8DF}, {0xB8E0, 0xB8E0, 0xB8E0},
    {0xB8E1, 0xB8E1, 0xB8E1}, {0xB8E2, 0xB8E2, 0xB8E2},
    {0xB8E3, 0xB8E3, 0xB8E3}, {0xB8E4, 0xB8E4, 0xB8E4},
    {0xB8E5, 0xB8E5, 0xB8E5}, {0xB8E6, 0xB8E6, 0xB8E6},
    {0xB8E7, 0xB8E7, 0xB8E7}, {0xB8E8, 0xB8E8, 0xB8E8},
    {0xB8E9, 0xB8E9, 0xB8E9}, {0xB8EA, 0xB8EA, 0xB8EA},
    {0xB8EB, 0xB8EB, 0xB8EB}, {0xB8EC, 0xB8EC, 0xB8EC},
    {0xB8ED, 0xB8ED, 0xB8ED}, {0xB8EE, 0xB8EE, 0xB8EE},
    {0xB8EF, 0xB8EF, 0xB8EF}, {0xB8F0, 0xB8F0, 0xB8F0},
    {0xB8F1, 0xB8F1, 0xB8F1}, {0xB8F2, 0xB8F2, 0xB8F2},
    {0xB8F3, 0xB8F3, 0xB8F3}, {0xB8F4, 0xB8F4, 0xB8F4},
    {0xB8F5, 0xB8F5, 0xB8F5}, {0xB8F6, 0xB8F6, 0xB8F6},
    {0xB8F7, 0xB8F7, 0xB8F7}, {0xB8F8, 0xB8F8, 0xB8F8},
    {0xB8F9, 0xB8F9, 0xB8F9}, {0xB8FA, 0xB8FA, 0xB8FA},
    {0xB8FB, 0xB8FB, 0xB8FB}, {0xB8FC, 0xB8FC, 0xB8FC},
    {0xB8FD, 0xB8FD, 0xB8FD}, {0xB8FE, 0xB8FE, 0xB8FE},
    {0xB8FF, 0xB8FF, 0xB8FF}, {0xB900, 0xB900, 0xB900},
    {0xB901, 0xB901, 0xB901}, {0xB902, 0xB902, 0xB902},
    {0xB903, 0xB903, 0xB903}, {0xB904, 0xB904, 0xB904},
    {0xB905, 0xB905, 0xB905}, {0xB906, 0xB906, 0xB906},
    {0xB907, 0xB907, 0xB907}, {0xB908, 0xB908, 0xB908},
    {0xB909, 0xB909, 0xB909}, {0xB90A, 0xB90A, 0xB90A},
    {0xB90B, 0xB90B, 0xB90B}, {0xB90C, 0xB90C, 0xB90C},
    {0xB90D, 0xB90D, 0xB90D}, {0xB90E, 0xB90E, 0xB90E},
    {0xB90F, 0xB90F, 0xB90F}, {0xB910, 0xB910, 0xB910},
    {0xB911, 0xB911, 0xB911}, {0xB912, 0xB912, 0xB912},
    {0xB913, 0xB913, 0xB913}, {0xB914, 0xB914, 0xB914},
    {0xB915, 0xB915, 0xB915}, {0xB916, 0xB916, 0xB916},
    {0xB917, 0xB917, 0xB917}, {0xB918, 0xB918, 0xB918},
    {0xB919, 0xB919, 0xB919}, {0xB91A, 0xB91A, 0xB91A},
    {0xB91B, 0xB91B, 0xB91B}, {0xB91C, 0xB91C, 0xB91C},
    {0xB91D, 0xB91D, 0xB91D}, {0xB91E, 0xB91E, 0xB91E},
    {0xB91F, 0xB91F, 0xB91F}, {0xB920, 0xB920, 0xB920},
    {0xB921, 0xB921, 0xB921}, {0xB922, 0xB922, 0xB922},
    {0xB923, 0xB923, 0xB923}, {0xB924, 0xB924, 0xB924},
    {0xB925, 0xB925, 0xB925}, {0xB926, 0xB926, 0xB926},
    {0xB927, 0xB927, 0xB927}, {0xB928, 0xB928, 0xB928},
    {0xB929, 0xB929, 0xB929}, {0xB92A, 0xB92A, 0xB92A},
    {0xB92B, 0xB92B, 0xB92B}, {0xB92C, 0xB92C, 0xB92C},
    {0xB92D, 0xB92D, 0xB92D}, {0xB92E, 0xB92E, 0xB92E},
    {0xB92F, 0xB92F, 0xB92F}, {0xB930, 0xB930, 0xB930},
    {0xB931, 0xB931, 0xB931}, {0xB932, 0xB932, 0xB932},
    {0xB933, 0xB933, 0xB933}, {0xB934, 0xB934, 0xB934},
    {0xB935, 0xB935, 0xB935}, {0xB936, 0xB936, 0xB936},
    {0xB937, 0xB937, 0xB937}, {0xB938, 0xB938, 0xB938},
    {0xB939, 0xB939, 0xB939}, {0xB93A, 0xB93A, 0xB93A},
    {0xB93B, 0xB93B, 0xB93B}, {0xB93C, 0xB93C, 0xB93C},
    {0xB93D, 0xB93D, 0xB93D}, {0xB93E, 0xB93E, 0xB93E},
    {0xB93F, 0xB93F, 0xB93F}, {0xB940, 0xB940, 0xB940},
    {0xB941, 0xB941, 0xB941}, {0xB942, 0xB942, 0xB942},
    {0xB943, 0xB943, 0xB943}, {0xB944, 0xB944, 0xB944},
    {0xB945, 0xB945, 0xB945}, {0xB946, 0xB946, 0xB946},
    {0xB947, 0xB947, 0xB947}, {0xB948, 0xB948, 0xB948},
    {0xB949, 0xB949, 0xB949}, {0xB94A, 0xB94A, 0xB94A},
    {0xB94B, 0xB94B, 0xB94B}, {0xB94C, 0xB94C, 0xB94C},
    {0xB94D, 0xB94D, 0xB94D}, {0xB94E, 0xB94E, 0xB94E},
    {0xB94F, 0xB94F, 0xB94F}, {0xB950, 0xB950, 0xB950},
    {0xB951, 0xB951, 0xB951}, {0xB952, 0xB952, 0xB952},
    {0xB953, 0xB953, 0xB953}, {0xB954, 0xB954, 0xB954},
    {0xB955, 0xB955, 0xB955}, {0xB956, 0xB956, 0xB956},
    {0xB957, 0xB957, 0xB957}, {0xB958, 0xB958, 0xB958},
    {0xB959, 0xB959, 0xB959}, {0xB95A, 0xB95A, 0xB95A},
    {0xB95B, 0xB95B, 0xB95B}, {0xB95C, 0xB95C, 0xB95C},
    {0xB95D, 0xB95D, 0xB95D}, {0xB95E, 0xB95E, 0xB95E},
    {0xB95F, 0xB95F, 0xB95F}, {0xB960, 0xB960, 0xB960},
    {0xB961, 0xB961, 0xB961}, {0xB962, 0xB962, 0xB962},
    {0xB963, 0xB963, 0xB963}, {0xB964, 0xB964, 0xB964},
    {0xB965, 0xB965, 0xB965}, {0xB966, 0xB966, 0xB966},
    {0xB967, 0xB967, 0xB967}, {0xB968, 0xB968, 0xB968},
    {0xB969, 0xB969, 0xB969}, {0xB96A, 0xB96A, 0xB96A},
    {0xB96B, 0xB96B, 0xB96B}, {0xB96C, 0xB96C, 0xB96C},
    {0xB96D, 0xB96D, 0xB96D}, {0xB96E, 0xB96E, 0xB96E},
    {0xB96F, 0xB96F, 0xB96F}, {0xB970, 0xB970, 0xB970},
    {0xB971, 0xB971, 0xB971}, {0xB972, 0xB972, 0xB972},
    {0xB973, 0xB973, 0xB973}, {0xB974, 0xB974, 0xB974},
    {0xB975, 0xB975, 0xB975}, {0xB976, 0xB976, 0xB976},
    {0xB977, 0xB977, 0xB977}, {0xB978, 0xB978, 0xB978},
    {0xB979, 0xB979, 0xB979}, {0xB97A, 0xB97A, 0xB97A},
    {0xB97B, 0xB97B, 0xB97B}, {0xB97C, 0xB97C, 0xB97C},
    {0xB97D, 0xB97D, 0xB97D}, {0xB97E, 0xB97E, 0xB97E},
    {0xB97F, 0xB97F, 0xB97F}, {0xB980, 0xB980, 0xB980},
    {0xB981, 0xB981, 0xB981}, {0xB982, 0xB982, 0xB982},
    {0xB983, 0xB983, 0xB983}, {0xB984, 0xB984, 0xB984},
    {0xB985, 0xB985, 0xB985}, {0xB986, 0xB986, 0xB986},
    {0xB987, 0xB987, 0xB987}, {0xB988, 0xB988, 0xB988},
    {0xB989, 0xB989, 0xB989}, {0xB98A, 0xB98A, 0xB98A},
    {0xB98B, 0xB98B, 0xB98B}, {0xB98C, 0xB98C, 0xB98C},
    {0xB98D, 0xB98D, 0xB98D}, {0xB98E, 0xB98E, 0xB98E},
    {0xB98F, 0xB98F, 0xB98F}, {0xB990, 0xB990, 0xB990},
    {0xB991, 0xB991, 0xB991}, {0xB992, 0xB992, 0xB992},
    {0xB993, 0xB993, 0xB993}, {0xB994, 0xB994, 0xB994},
    {0xB995, 0xB995, 0xB995}, {0xB996, 0xB996, 0xB996},
    {0xB997, 0xB997, 0xB997}, {0xB998, 0xB998, 0xB998},
    {0xB999, 0xB999, 0xB999}, {0xB99A, 0xB99A, 0xB99A},
    {0xB99B, 0xB99B, 0xB99B}, {0xB99C, 0xB99C, 0xB99C},
    {0xB99D, 0xB99D, 0xB99D}, {0xB99E, 0xB99E, 0xB99E},
    {0xB99F, 0xB99F, 0xB99F}, {0xB9A0, 0xB9A0, 0xB9A0},
    {0xB9A1, 0xB9A1, 0xB9A1}, {0xB9A2, 0xB9A2, 0xB9A2},
    {0xB9A3, 0xB9A3, 0xB9A3}, {0xB9A4, 0xB9A4, 0xB9A4},
    {0xB9A5, 0xB9A5, 0xB9A5}, {0xB9A6, 0xB9A6, 0xB9A6},
    {0xB9A7, 0xB9A7, 0xB9A7}, {0xB9A8, 0xB9A8, 0xB9A8},
    {0xB9A9, 0xB9A9, 0xB9A9}, {0xB9AA, 0xB9AA, 0xB9AA},
    {0xB9AB, 0xB9AB, 0xB9AB}, {0xB9AC, 0xB9AC, 0xB9AC},
    {0xB9AD, 0xB9AD, 0xB9AD}, {0xB9AE, 0xB9AE, 0xB9AE},
    {0xB9AF, 0xB9AF, 0xB9AF}, {0xB9B0, 0xB9B0, 0xB9B0},
    {0xB9B1, 0xB9B1, 0xB9B1}, {0xB9B2, 0xB9B2, 0xB9B2},
    {0xB9B3, 0xB9B3, 0xB9B3}, {0xB9B4, 0xB9B4, 0xB9B4},
    {0xB9B5, 0xB9B5, 0xB9B5}, {0xB9B6, 0xB9B6, 0xB9B6},
    {0xB9B7, 0xB9B7, 0xB9B7}, {0xB9B8, 0xB9B8, 0xB9B8},
    {0xB9B9, 0xB9B9, 0xB9B9}, {0xB9BA, 0xB9BA, 0xB9BA},
    {0xB9BB, 0xB9BB, 0xB9BB}, {0xB9BC, 0xB9BC, 0xB9BC},
    {0xB9BD, 0xB9BD, 0xB9BD}, {0xB9BE, 0xB9BE, 0xB9BE},
    {0xB9BF, 0xB9BF, 0xB9BF}, {0xB9C0, 0xB9C0, 0xB9C0},
    {0xB9C1, 0xB9C1, 0xB9C1}, {0xB9C2, 0xB9C2, 0xB9C2},
    {0xB9C3, 0xB9C3, 0xB9C3}, {0xB9C4, 0xB9C4, 0xB9C4},
    {0xB9C5, 0xB9C5, 0xB9C5}, {0xB9C6, 0xB9C6, 0xB9C6},
    {0xB9C7, 0xB9C7, 0xB9C7}, {0xB9C8, 0xB9C8, 0xB9C8},
    {0xB9C9, 0xB9C9, 0xB9C9}, {0xB9CA, 0xB9CA, 0xB9CA},
    {0xB9CB, 0xB9CB, 0xB9CB}, {0xB9CC, 0xB9CC, 0xB9CC},
    {0xB9CD, 0xB9CD, 0xB9CD}, {0xB9CE, 0xB9CE, 0xB9CE},
    {0xB9CF, 0xB9CF, 0xB9CF}, {0xB9D0, 0xB9D0, 0xB9D0},
    {0xB9D1, 0xB9D1, 0xB9D1}, {0xB9D2, 0xB9D2, 0xB9D2},
    {0xB9D3, 0xB9D3, 0xB9D3}, {0xB9D4, 0xB9D4, 0xB9D4},
    {0xB9D5, 0xB9D5, 0xB9D5}, {0xB9D6, 0xB9D6, 0xB9D6},
    {0xB9D7, 0xB9D7, 0xB9D7}, {0xB9D8, 0xB9D8, 0xB9D8},
    {0xB9D9, 0xB9D9, 0xB9D9}, {0xB9DA, 0xB9DA, 0xB9DA},
    {0xB9DB, 0xB9DB, 0xB9DB}, {0xB9DC, 0xB9DC, 0xB9DC},
    {0xB9DD, 0xB9DD, 0xB9DD}, {0xB9DE, 0xB9DE, 0xB9DE},
    {0xB9DF, 0xB9DF, 0xB9DF}, {0xB9E0, 0xB9E0, 0xB9E0},
    {0xB9E1, 0xB9E1, 0xB9E1}, {0xB9E2, 0xB9E2, 0xB9E2},
    {0xB9E3, 0xB9E3, 0xB9E3}, {0xB9E4, 0xB9E4, 0xB9E4},
    {0xB9E5, 0xB9E5, 0xB9E5}, {0xB9E6, 0xB9E6, 0xB9E6},
    {0xB9E7, 0xB9E7, 0xB9E7}, {0xB9E8, 0xB9E8, 0xB9E8},
    {0xB9E9, 0xB9E9, 0xB9E9}, {0xB9EA, 0xB9EA, 0xB9EA},
    {0xB9EB, 0xB9EB, 0xB9EB}, {0xB9EC, 0xB9EC, 0xB9EC},
    {0xB9ED, 0xB9ED, 0xB9ED}, {0xB9EE, 0xB9EE, 0xB9EE},
    {0xB9EF, 0xB9EF, 0xB9EF}, {0xB9F0, 0xB9F0, 0xB9F0},
    {0xB9F1, 0xB9F1, 0xB9F1}, {0xB9F2, 0xB9F2, 0xB9F2},
    {0xB9F3, 0xB9F3, 0xB9F3}, {0xB9F4, 0xB9F4, 0xB9F4},
    {0xB9F5, 0xB9F5, 0xB9F5}, {0xB9F6, 0xB9F6, 0xB9F6},
    {0xB9F7, 0xB9F7, 0xB9F7}, {0xB9F8, 0xB9F8, 0xB9F8},
    {0xB9F9, 0xB9F9, 0xB9F9}, {0xB9FA, 0xB9FA, 0xB9FA},
    {0xB9FB, 0xB9FB, 0xB9FB}, {0xB9FC, 0xB9FC, 0xB9FC},
    {0xB9FD, 0xB9FD, 0xB9FD}, {0xB9FE, 0xB9FE, 0xB9FE},
    {0xB9FF, 0xB9FF, 0xB9FF}, {0xBA00, 0xBA00, 0xBA00},
    {0xBA01, 0xBA01, 0xBA01}, {0xBA02, 0xBA02, 0xBA02},
    {0xBA03, 0xBA03, 0xBA03}, {0xBA04, 0xBA04, 0xBA04},
    {0xBA05, 0xBA05, 0xBA05}, {0xBA06, 0xBA06, 0xBA06},
    {0xBA07, 0xBA07, 0xBA07}, {0xBA08, 0xBA08, 0xBA08},
    {0xBA09, 0xBA09, 0xBA09}, {0xBA0A, 0xBA0A, 0xBA0A},
    {0xBA0B, 0xBA0B, 0xBA0B}, {0xBA0C, 0xBA0C, 0xBA0C},
    {0xBA0D, 0xBA0D, 0xBA0D}, {0xBA0E, 0xBA0E, 0xBA0E},
    {0xBA0F, 0xBA0F, 0xBA0F}, {0xBA10, 0xBA10, 0xBA10},
    {0xBA11, 0xBA11, 0xBA11}, {0xBA12, 0xBA12, 0xBA12},
    {0xBA13, 0xBA13, 0xBA13}, {0xBA14, 0xBA14, 0xBA14},
    {0xBA15, 0xBA15, 0xBA15}, {0xBA16, 0xBA16, 0xBA16},
    {0xBA17, 0xBA17, 0xBA17}, {0xBA18, 0xBA18, 0xBA18},
    {0xBA19, 0xBA19, 0xBA19}, {0xBA1A, 0xBA1A, 0xBA1A},
    {0xBA1B, 0xBA1B, 0xBA1B}, {0xBA1C, 0xBA1C, 0xBA1C},
    {0xBA1D, 0xBA1D, 0xBA1D}, {0xBA1E, 0xBA1E, 0xBA1E},
    {0xBA1F, 0xBA1F, 0xBA1F}, {0xBA20, 0xBA20, 0xBA20},
    {0xBA21, 0xBA21, 0xBA21}, {0xBA22, 0xBA22, 0xBA22},
    {0xBA23, 0xBA23, 0xBA23}, {0xBA24, 0xBA24, 0xBA24},
    {0xBA25, 0xBA25, 0xBA25}, {0xBA26, 0xBA26, 0xBA26},
    {0xBA27, 0xBA27, 0xBA27}, {0xBA28, 0xBA28, 0xBA28},
    {0xBA29, 0xBA29, 0xBA29}, {0xBA2A, 0xBA2A, 0xBA2A},
    {0xBA2B, 0xBA2B, 0xBA2B}, {0xBA2C, 0xBA2C, 0xBA2C},
    {0xBA2D, 0xBA2D, 0xBA2D}, {0xBA2E, 0xBA2E, 0xBA2E},
    {0xBA2F, 0xBA2F, 0xBA2F}, {0xBA30, 0xBA30, 0xBA30},
    {0xBA31, 0xBA31, 0xBA31}, {0xBA32, 0xBA32, 0xBA32},
    {0xBA33, 0xBA33, 0xBA33}, {0xBA34, 0xBA34, 0xBA34},
    {0xBA35, 0xBA35, 0xBA35}, {0xBA36, 0xBA36, 0xBA36},
    {0xBA37, 0xBA37, 0xBA37}, {0xBA38, 0xBA38, 0xBA38},
    {0xBA39, 0xBA39, 0xBA39}, {0xBA3A, 0xBA3A, 0xBA3A},
    {0xBA3B, 0xBA3B, 0xBA3B}, {0xBA3C, 0xBA3C, 0xBA3C},
    {0xBA3D, 0xBA3D, 0xBA3D}, {0xBA3E, 0xBA3E, 0xBA3E},
    {0xBA3F, 0xBA3F, 0xBA3F}, {0xBA40, 0xBA40, 0xBA40},
    {0xBA41, 0xBA41, 0xBA41}, {0xBA42, 0xBA42, 0xBA42},
    {0xBA43, 0xBA43, 0xBA43}, {0xBA44, 0xBA44, 0xBA44},
    {0xBA45, 0xBA45, 0xBA45}, {0xBA46, 0xBA46, 0xBA46},
    {0xBA47, 0xBA47, 0xBA47}, {0xBA48, 0xBA48, 0xBA48},
    {0xBA49, 0xBA49, 0xBA49}, {0xBA4A, 0xBA4A, 0xBA4A},
    {0xBA4B, 0xBA4B, 0xBA4B}, {0xBA4C, 0xBA4C, 0xBA4C},
    {0xBA4D, 0xBA4D, 0xBA4D}, {0xBA4E, 0xBA4E, 0xBA4E},
    {0xBA4F, 0xBA4F, 0xBA4F}, {0xBA50, 0xBA50, 0xBA50},
    {0xBA51, 0xBA51, 0xBA51}, {0xBA52, 0xBA52, 0xBA52},
    {0xBA53, 0xBA53, 0xBA53}, {0xBA54, 0xBA54, 0xBA54},
    {0xBA55, 0xBA55, 0xBA55}, {0xBA56, 0xBA56, 0xBA56},
    {0xBA57, 0xBA57, 0xBA57}, {0xBA58, 0xBA58, 0xBA58},
    {0xBA59, 0xBA59, 0xBA59}, {0xBA5A, 0xBA5A, 0xBA5A},
    {0xBA5B, 0xBA5B, 0xBA5B}, {0xBA5C, 0xBA5C, 0xBA5C},
    {0xBA5D, 0xBA5D, 0xBA5D}, {0xBA5E, 0xBA5E, 0xBA5E},
    {0xBA5F, 0xBA5F, 0xBA5F}, {0xBA60, 0xBA60, 0xBA60},
    {0xBA61, 0xBA61, 0xBA61}, {0xBA62, 0xBA62, 0xBA62},
    {0xBA63, 0xBA63, 0xBA63}, {0xBA64, 0xBA64, 0xBA64},
    {0xBA65, 0xBA65, 0xBA65}, {0xBA66, 0xBA66, 0xBA66},
    {0xBA67, 0xBA67, 0xBA67}, {0xBA68, 0xBA68, 0xBA68},
    {0xBA69, 0xBA69, 0xBA69}, {0xBA6A, 0xBA6A, 0xBA6A},
    {0xBA6B, 0xBA6B, 0xBA6B}, {0xBA6C, 0xBA6C, 0xBA6C},
    {0xBA6D, 0xBA6D, 0xBA6D}, {0xBA6E, 0xBA6E, 0xBA6E},
    {0xBA6F, 0xBA6F, 0xBA6F}, {0xBA70, 0xBA70, 0xBA70},
    {0xBA71, 0xBA71, 0xBA71}, {0xBA72, 0xBA72, 0xBA72},
    {0xBA73, 0xBA73, 0xBA73}, {0xBA74, 0xBA74, 0xBA74},
    {0xBA75, 0xBA75, 0xBA75}, {0xBA76, 0xBA76, 0xBA76},
    {0xBA77, 0xBA77, 0xBA77}, {0xBA78, 0xBA78, 0xBA78},
    {0xBA79, 0xBA79, 0xBA79}, {0xBA7A, 0xBA7A, 0xBA7A},
    {0xBA7B, 0xBA7B, 0xBA7B}, {0xBA7C, 0xBA7C, 0xBA7C},
    {0xBA7D, 0xBA7D, 0xBA7D}, {0xBA7E, 0xBA7E, 0xBA7E},
    {0xBA7F, 0xBA7F, 0xBA7F}, {0xBA80, 0xBA80, 0xBA80},
    {0xBA81, 0xBA81, 0xBA81}, {0xBA82, 0xBA82, 0xBA82},
    {0xBA83, 0xBA83, 0xBA83}, {0xBA84, 0xBA84, 0xBA84},
    {0xBA85, 0xBA85, 0xBA85}, {0xBA86, 0xBA86, 0xBA86},
    {0xBA87, 0xBA87, 0xBA87}, {0xBA88, 0xBA88, 0xBA88},
    {0xBA89, 0xBA89, 0xBA89}, {0xBA8A, 0xBA8A, 0xBA8A},
    {0xBA8B, 0xBA8B, 0xBA8B}, {0xBA8C, 0xBA8C, 0xBA8C},
    {0xBA8D, 0xBA8D, 0xBA8D}, {0xBA8E, 0xBA8E, 0xBA8E},
    {0xBA8F, 0xBA8F, 0xBA8F}, {0xBA90, 0xBA90, 0xBA90},
    {0xBA91, 0xBA91, 0xBA91}, {0xBA92, 0xBA92, 0xBA92},
    {0xBA93, 0xBA93, 0xBA93}, {0xBA94, 0xBA94, 0xBA94},
    {0xBA95, 0xBA95, 0xBA95}, {0xBA96, 0xBA96, 0xBA96},
    {0xBA97, 0xBA97, 0xBA97}, {0xBA98, 0xBA98, 0xBA98},
    {0xBA99, 0xBA99, 0xBA99}, {0xBA9A, 0xBA9A, 0xBA9A},
    {0xBA9B, 0xBA9B, 0xBA9B}, {0xBA9C, 0xBA9C, 0xBA9C},
    {0xBA9D, 0xBA9D, 0xBA9D}, {0xBA9E, 0xBA9E, 0xBA9E},
    {0xBA9F, 0xBA9F, 0xBA9F}, {0xBAA0, 0xBAA0, 0xBAA0},
    {0xBAA1, 0xBAA1, 0xBAA1}, {0xBAA2, 0xBAA2, 0xBAA2},
    {0xBAA3, 0xBAA3, 0xBAA3}, {0xBAA4, 0xBAA4, 0xBAA4},
    {0xBAA5, 0xBAA5, 0xBAA5}, {0xBAA6, 0xBAA6, 0xBAA6},
    {0xBAA7, 0xBAA7, 0xBAA7}, {0xBAA8, 0xBAA8, 0xBAA8},
    {0xBAA9, 0xBAA9, 0xBAA9}, {0xBAAA, 0xBAAA, 0xBAAA},
    {0xBAAB, 0xBAAB, 0xBAAB}, {0xBAAC, 0xBAAC, 0xBAAC},
    {0xBAAD, 0xBAAD, 0xBAAD}, {0xBAAE, 0xBAAE, 0xBAAE},
    {0xBAAF, 0xBAAF, 0xBAAF}, {0xBAB0, 0xBAB0, 0xBAB0},
    {0xBAB1, 0xBAB1, 0xBAB1}, {0xBAB2, 0xBAB2, 0xBAB2},
    {0xBAB3, 0xBAB3, 0xBAB3}, {0xBAB4, 0xBAB4, 0xBAB4},
    {0xBAB5, 0xBAB5, 0xBAB5}, {0xBAB6, 0xBAB6, 0xBAB6},
    {0xBAB7, 0xBAB7, 0xBAB7}, {0xBAB8, 0xBAB8, 0xBAB8},
    {0xBAB9, 0xBAB9, 0xBAB9}, {0xBABA, 0xBABA, 0xBABA},
    {0xBABB, 0xBABB, 0xBABB}, {0xBABC, 0xBABC, 0xBABC},
    {0xBABD, 0xBABD, 0xBABD}, {0xBABE, 0xBABE, 0xBABE},
    {0xBABF, 0xBABF, 0xBABF}, {0xBAC0, 0xBAC0, 0xBAC0},
    {0xBAC1, 0xBAC1, 0xBAC1}, {0xBAC2, 0xBAC2, 0xBAC2},
    {0xBAC3, 0xBAC3, 0xBAC3}, {0xBAC4, 0xBAC4, 0xBAC4},
    {0xBAC5, 0xBAC5, 0xBAC5}, {0xBAC6, 0xBAC6, 0xBAC6},
    {0xBAC7, 0xBAC7, 0xBAC7}, {0xBAC8, 0xBAC8, 0xBAC8},
    {0xBAC9, 0xBAC9, 0xBAC9}, {0xBACA, 0xBACA, 0xBACA},
    {0xBACB, 0xBACB, 0xBACB}, {0xBACC, 0xBACC, 0xBACC},
    {0xBACD, 0xBACD, 0xBACD}, {0xBACE, 0xBACE, 0xBACE},
    {0xBACF, 0xBACF, 0xBACF}, {0xBAD0, 0xBAD0, 0xBAD0},
    {0xBAD1, 0xBAD1, 0xBAD1}, {0xBAD2, 0xBAD2, 0xBAD2},
    {0xBAD3, 0xBAD3, 0xBAD3}, {0xBAD4, 0xBAD4, 0xBAD4},
    {0xBAD5, 0xBAD5, 0xBAD5}, {0xBAD6, 0xBAD6, 0xBAD6},
    {0xBAD7, 0xBAD7, 0xBAD7}, {0xBAD8, 0xBAD8, 0xBAD8},
    {0xBAD9, 0xBAD9, 0xBAD9}, {0xBADA, 0xBADA, 0xBADA},
    {0xBADB, 0xBADB, 0xBADB}, {0xBADC, 0xBADC, 0xBADC},
    {0xBADD, 0xBADD, 0xBADD}, {0xBADE, 0xBADE, 0xBADE},
    {0xBADF, 0xBADF, 0xBADF}, {0xBAE0, 0xBAE0, 0xBAE0},
    {0xBAE1, 0xBAE1, 0xBAE1}, {0xBAE2, 0xBAE2, 0xBAE2},
    {0xBAE3, 0xBAE3, 0xBAE3}, {0xBAE4, 0xBAE4, 0xBAE4},
    {0xBAE5, 0xBAE5, 0xBAE5}, {0xBAE6, 0xBAE6, 0xBAE6},
    {0xBAE7, 0xBAE7, 0xBAE7}, {0xBAE8, 0xBAE8, 0xBAE8},
    {0xBAE9, 0xBAE9, 0xBAE9}, {0xBAEA, 0xBAEA, 0xBAEA},
    {0xBAEB, 0xBAEB, 0xBAEB}, {0xBAEC, 0xBAEC, 0xBAEC},
    {0xBAED, 0xBAED, 0xBAED}, {0xBAEE, 0xBAEE, 0xBAEE},
    {0xBAEF, 0xBAEF, 0xBAEF}, {0xBAF0, 0xBAF0, 0xBAF0},
    {0xBAF1, 0xBAF1, 0xBAF1}, {0xBAF2, 0xBAF2, 0xBAF2},
    {0xBAF3, 0xBAF3, 0xBAF3}, {0xBAF4, 0xBAF4, 0xBAF4},
    {0xBAF5, 0xBAF5, 0xBAF5}, {0xBAF6, 0xBAF6, 0xBAF6},
    {0xBAF7, 0xBAF7, 0xBAF7}, {0xBAF8, 0xBAF8, 0xBAF8},
    {0xBAF9, 0xBAF9, 0xBAF9}, {0xBAFA, 0xBAFA, 0xBAFA},
    {0xBAFB, 0xBAFB, 0xBAFB}, {0xBAFC, 0xBAFC, 0xBAFC},
    {0xBAFD, 0xBAFD, 0xBAFD}, {0xBAFE, 0xBAFE, 0xBAFE},
    {0xBAFF, 0xBAFF, 0xBAFF}, {0xBB00, 0xBB00, 0xBB00},
    {0xBB01, 0xBB01, 0xBB01}, {0xBB02, 0xBB02, 0xBB02},
    {0xBB03, 0xBB03, 0xBB03}, {0xBB04, 0xBB04, 0xBB04},
    {0xBB05, 0xBB05, 0xBB05}, {0xBB06, 0xBB06, 0xBB06},
    {0xBB07, 0xBB07, 0xBB07}, {0xBB08, 0xBB08, 0xBB08},
    {0xBB09, 0xBB09, 0xBB09}, {0xBB0A, 0xBB0A, 0xBB0A},
    {0xBB0B, 0xBB0B, 0xBB0B}, {0xBB0C, 0xBB0C, 0xBB0C},
    {0xBB0D, 0xBB0D, 0xBB0D}, {0xBB0E, 0xBB0E, 0xBB0E},
    {0xBB0F, 0xBB0F, 0xBB0F}, {0xBB10, 0xBB10, 0xBB10},
    {0xBB11, 0xBB11, 0xBB11}, {0xBB12, 0xBB12, 0xBB12},
    {0xBB13, 0xBB13, 0xBB13}, {0xBB14, 0xBB14, 0xBB14},
    {0xBB15, 0xBB15, 0xBB15}, {0xBB16, 0xBB16, 0xBB16},
    {0xBB17, 0xBB17, 0xBB17}, {0xBB18, 0xBB18, 0xBB18},
    {0xBB19, 0xBB19, 0xBB19}, {0xBB1A, 0xBB1A, 0xBB1A},
    {0xBB1B, 0xBB1B, 0xBB1B}, {0xBB1C, 0xBB1C, 0xBB1C},
    {0xBB1D, 0xBB1D, 0xBB1D}, {0xBB1E, 0xBB1E, 0xBB1E},
    {0xBB1F, 0xBB1F, 0xBB1F}, {0xBB20, 0xBB20, 0xBB20},
    {0xBB21, 0xBB21, 0xBB21}, {0xBB22, 0xBB22, 0xBB22},
    {0xBB23, 0xBB23, 0xBB23}, {0xBB24, 0xBB24, 0xBB24},
    {0xBB25, 0xBB25, 0xBB25}, {0xBB26, 0xBB26, 0xBB26},
    {0xBB27, 0xBB27, 0xBB27}, {0xBB28, 0xBB28, 0xBB28},
    {0xBB29, 0xBB29, 0xBB29}, {0xBB2A, 0xBB2A, 0xBB2A},
    {0xBB2B, 0xBB2B, 0xBB2B}, {0xBB2C, 0xBB2C, 0xBB2C},
    {0xBB2D, 0xBB2D, 0xBB2D}, {0xBB2E, 0xBB2E, 0xBB2E},
    {0xBB2F, 0xBB2F, 0xBB2F}, {0xBB30, 0xBB30, 0xBB30},
    {0xBB31, 0xBB31, 0xBB31}, {0xBB32, 0xBB32, 0xBB32},
    {0xBB33, 0xBB33, 0xBB33}, {0xBB34, 0xBB34, 0xBB34},
    {0xBB35, 0xBB35, 0xBB35}, {0xBB36, 0xBB36, 0xBB36},
    {0xBB37, 0xBB37, 0xBB37}, {0xBB38, 0xBB38, 0xBB38},
    {0xBB39, 0xBB39, 0xBB39}, {0xBB3A, 0xBB3A, 0xBB3A},
    {0xBB3B, 0xBB3B, 0xBB3B}, {0xBB3C, 0xBB3C, 0xBB3C},
    {0xBB3D, 0xBB3D, 0xBB3D}, {0xBB3E, 0xBB3E, 0xBB3E},
    {0xBB3F, 0xBB3F, 0xBB3F}, {0xBB40, 0xBB40, 0xBB40},
    {0xBB41, 0xBB41, 0xBB41}, {0xBB42, 0xBB42, 0xBB42},
    {0xBB43, 0xBB43, 0xBB43}, {0xBB44, 0xBB44, 0xBB44},
    {0xBB45, 0xBB45, 0xBB45}, {0xBB46, 0xBB46, 0xBB46},
    {0xBB47, 0xBB47, 0xBB47}, {0xBB48, 0xBB48, 0xBB48},
    {0xBB49, 0xBB49, 0xBB49}, {0xBB4A, 0xBB4A, 0xBB4A},
    {0xBB4B, 0xBB4B, 0xBB4B}, {0xBB4C, 0xBB4C, 0xBB4C},
    {0xBB4D, 0xBB4D, 0xBB4D}, {0xBB4E, 0xBB4E, 0xBB4E},
    {0xBB4F, 0xBB4F, 0xBB4F}, {0xBB50, 0xBB50, 0xBB50},
    {0xBB51, 0xBB51, 0xBB51}, {0xBB52, 0xBB52, 0xBB52},
    {0xBB53, 0xBB53, 0xBB53}, {0xBB54, 0xBB54, 0xBB54},
    {0xBB55, 0xBB55, 0xBB55}, {0xBB56, 0xBB56, 0xBB56},
    {0xBB57, 0xBB57, 0xBB57}, {0xBB58, 0xBB58, 0xBB58},
    {0xBB59, 0xBB59, 0xBB59}, {0xBB5A, 0xBB5A, 0xBB5A},
    {0xBB5B, 0xBB5B, 0xBB5B}, {0xBB5C, 0xBB5C, 0xBB5C},
    {0xBB5D, 0xBB5D, 0xBB5D}, {0xBB5E, 0xBB5E, 0xBB5E},
    {0xBB5F, 0xBB5F, 0xBB5F}, {0xBB60, 0xBB60, 0xBB60},
    {0xBB61, 0xBB61, 0xBB61}, {0xBB62, 0xBB62, 0xBB62},
    {0xBB63, 0xBB63, 0xBB63}, {0xBB64, 0xBB64, 0xBB64},
    {0xBB65, 0xBB65, 0xBB65}, {0xBB66, 0xBB66, 0xBB66},
    {0xBB67, 0xBB67, 0xBB67}, {0xBB68, 0xBB68, 0xBB68},
    {0xBB69, 0xBB69, 0xBB69}, {0xBB6A, 0xBB6A, 0xBB6A},
    {0xBB6B, 0xBB6B, 0xBB6B}, {0xBB6C, 0xBB6C, 0xBB6C},
    {0xBB6D, 0xBB6D, 0xBB6D}, {0xBB6E, 0xBB6E, 0xBB6E},
    {0xBB6F, 0xBB6F, 0xBB6F}, {0xBB70, 0xBB70, 0xBB70},
    {0xBB71, 0xBB71, 0xBB71}, {0xBB72, 0xBB72, 0xBB72},
    {0xBB73, 0xBB73, 0xBB73}, {0xBB74, 0xBB74, 0xBB74},
    {0xBB75, 0xBB75, 0xBB75}, {0xBB76, 0xBB76, 0xBB76},
    {0xBB77, 0xBB77, 0xBB77}, {0xBB78, 0xBB78, 0xBB78},
    {0xBB79, 0xBB79, 0xBB79}, {0xBB7A, 0xBB7A, 0xBB7A},
    {0xBB7B, 0xBB7B, 0xBB7B}, {0xBB7C, 0xBB7C, 0xBB7C},
    {0xBB7D, 0xBB7D, 0xBB7D}, {0xBB7E, 0xBB7E, 0xBB7E},
    {0xBB7F, 0xBB7F, 0xBB7F}, {0xBB80, 0xBB80, 0xBB80},
    {0xBB81, 0xBB81, 0xBB81}, {0xBB82, 0xBB82, 0xBB82},
    {0xBB83, 0xBB83, 0xBB83}, {0xBB84, 0xBB84, 0xBB84},
    {0xBB85, 0xBB85, 0xBB85}, {0xBB86, 0xBB86, 0xBB86},
    {0xBB87, 0xBB87, 0xBB87}, {0xBB88, 0xBB88, 0xBB88},
    {0xBB89, 0xBB89, 0xBB89}, {0xBB8A, 0xBB8A, 0xBB8A},
    {0xBB8B, 0xBB8B, 0xBB8B}, {0xBB8C, 0xBB8C, 0xBB8C},
    {0xBB8D, 0xBB8D, 0xBB8D}, {0xBB8E, 0xBB8E, 0xBB8E},
    {0xBB8F, 0xBB8F, 0xBB8F}, {0xBB90, 0xBB90, 0xBB90},
    {0xBB91, 0xBB91, 0xBB91}, {0xBB92, 0xBB92, 0xBB92},
    {0xBB93, 0xBB93, 0xBB93}, {0xBB94, 0xBB94, 0xBB94},
    {0xBB95, 0xBB95, 0xBB95}, {0xBB96, 0xBB96, 0xBB96},
    {0xBB97, 0xBB97, 0xBB97}, {0xBB98, 0xBB98, 0xBB98},
    {0xBB99, 0xBB99, 0xBB99}, {0xBB9A, 0xBB9A, 0xBB9A},
    {0xBB9B, 0xBB9B, 0xBB9B}, {0xBB9C, 0xBB9C, 0xBB9C},
    {0xBB9D, 0xBB9D, 0xBB9D}, {0xBB9E, 0xBB9E, 0xBB9E},
    {0xBB9F, 0xBB9F, 0xBB9F}, {0xBBA0, 0xBBA0, 0xBBA0},
    {0xBBA1, 0xBBA1, 0xBBA1}, {0xBBA2, 0xBBA2, 0xBBA2},
    {0xBBA3, 0xBBA3, 0xBBA3}, {0xBBA4, 0xBBA4, 0xBBA4},
    {0xBBA5, 0xBBA5, 0xBBA5}, {0xBBA6, 0xBBA6, 0xBBA6},
    {0xBBA7, 0xBBA7, 0xBBA7}, {0xBBA8, 0xBBA8, 0xBBA8},
    {0xBBA9, 0xBBA9, 0xBBA9}, {0xBBAA, 0xBBAA, 0xBBAA},
    {0xBBAB, 0xBBAB, 0xBBAB}, {0xBBAC, 0xBBAC, 0xBBAC},
    {0xBBAD, 0xBBAD, 0xBBAD}, {0xBBAE, 0xBBAE, 0xBBAE},
    {0xBBAF, 0xBBAF, 0xBBAF}, {0xBBB0, 0xBBB0, 0xBBB0},
    {0xBBB1, 0xBBB1, 0xBBB1}, {0xBBB2, 0xBBB2, 0xBBB2},
    {0xBBB3, 0xBBB3, 0xBBB3}, {0xBBB4, 0xBBB4, 0xBBB4},
    {0xBBB5, 0xBBB5, 0xBBB5}, {0xBBB6, 0xBBB6, 0xBBB6},
    {0xBBB7, 0xBBB7, 0xBBB7}, {0xBBB8, 0xBBB8, 0xBBB8},
    {0xBBB9, 0xBBB9, 0xBBB9}, {0xBBBA, 0xBBBA, 0xBBBA},
    {0xBBBB, 0xBBBB, 0xBBBB}, {0xBBBC, 0xBBBC, 0xBBBC},
    {0xBBBD, 0xBBBD, 0xBBBD}, {0xBBBE, 0xBBBE, 0xBBBE},
    {0xBBBF, 0xBBBF, 0xBBBF}, {0xBBC0, 0xBBC0, 0xBBC0},
    {0xBBC1, 0xBBC1, 0xBBC1}, {0xBBC2, 0xBBC2, 0xBBC2},
    {0xBBC3, 0xBBC3, 0xBBC3}, {0xBBC4, 0xBBC4, 0xBBC4},
    {0xBBC5, 0xBBC5, 0xBBC5}, {0xBBC6, 0xBBC6, 0xBBC6},
    {0xBBC7, 0xBBC7, 0xBBC7}, {0xBBC8, 0xBBC8, 0xBBC8},
    {0xBBC9, 0xBBC9, 0xBBC9}, {0xBBCA, 0xBBCA, 0xBBCA},
    {0xBBCB, 0xBBCB, 0xBBCB}, {0xBBCC, 0xBBCC, 0xBBCC},
    {0xBBCD, 0xBBCD, 0xBBCD}, {0xBBCE, 0xBBCE, 0xBBCE},
    {0xBBCF, 0xBBCF, 0xBBCF}, {0xBBD0, 0xBBD0, 0xBBD0},
    {0xBBD1, 0xBBD1, 0xBBD1}, {0xBBD2, 0xBBD2, 0xBBD2},
    {0xBBD3, 0xBBD3, 0xBBD3}, {0xBBD4, 0xBBD4, 0xBBD4},
    {0xBBD5, 0xBBD5, 0xBBD5}, {0xBBD6, 0xBBD6, 0xBBD6},
    {0xBBD7, 0xBBD7, 0xBBD7}, {0xBBD8, 0xBBD8, 0xBBD8},
    {0xBBD9, 0xBBD9, 0xBBD9}, {0xBBDA, 0xBBDA, 0xBBDA},
    {0xBBDB, 0xBBDB, 0xBBDB}, {0xBBDC, 0xBBDC, 0xBBDC},
    {0xBBDD, 0xBBDD, 0xBBDD}, {0xBBDE, 0xBBDE, 0xBBDE},
    {0xBBDF, 0xBBDF, 0xBBDF}, {0xBBE0, 0xBBE0, 0xBBE0},
    {0xBBE1, 0xBBE1, 0xBBE1}, {0xBBE2, 0xBBE2, 0xBBE2},
    {0xBBE3, 0xBBE3, 0xBBE3}, {0xBBE4, 0xBBE4, 0xBBE4},
    {0xBBE5, 0xBBE5, 0xBBE5}, {0xBBE6, 0xBBE6, 0xBBE6},
    {0xBBE7, 0xBBE7, 0xBBE7}, {0xBBE8, 0xBBE8, 0xBBE8},
    {0xBBE9, 0xBBE9, 0xBBE9}, {0xBBEA, 0xBBEA, 0xBBEA},
    {0xBBEB, 0xBBEB, 0xBBEB}, {0xBBEC, 0xBBEC, 0xBBEC},
    {0xBBED, 0xBBED, 0xBBED}, {0xBBEE, 0xBBEE, 0xBBEE},
    {0xBBEF, 0xBBEF, 0xBBEF}, {0xBBF0, 0xBBF0, 0xBBF0},
    {0xBBF1, 0xBBF1, 0xBBF1}, {0xBBF2, 0xBBF2, 0xBBF2},
    {0xBBF3, 0xBBF3, 0xBBF3}, {0xBBF4, 0xBBF4, 0xBBF4},
    {0xBBF5, 0xBBF5, 0xBBF5}, {0xBBF6, 0xBBF6, 0xBBF6},
    {0xBBF7, 0xBBF7, 0xBBF7}, {0xBBF8, 0xBBF8, 0xBBF8},
    {0xBBF9, 0xBBF9, 0xBBF9}, {0xBBFA, 0xBBFA, 0xBBFA},
    {0xBBFB, 0xBBFB, 0xBBFB}, {0xBBFC, 0xBBFC, 0xBBFC},
    {0xBBFD, 0xBBFD, 0xBBFD}, {0xBBFE, 0xBBFE, 0xBBFE},
    {0xBBFF, 0xBBFF, 0xBBFF}, {0xBC00, 0xBC00, 0xBC00},
    {0xBC01, 0xBC01, 0xBC01}, {0xBC02, 0xBC02, 0xBC02},
    {0xBC03, 0xBC03, 0xBC03}, {0xBC04, 0xBC04, 0xBC04},
    {0xBC05, 0xBC05, 0xBC05}, {0xBC06, 0xBC06, 0xBC06},
    {0xBC07, 0xBC07, 0xBC07}, {0xBC08, 0xBC08, 0xBC08},
    {0xBC09, 0xBC09, 0xBC09}, {0xBC0A, 0xBC0A, 0xBC0A},
    {0xBC0B, 0xBC0B, 0xBC0B}, {0xBC0C, 0xBC0C, 0xBC0C},
    {0xBC0D, 0xBC0D, 0xBC0D}, {0xBC0E, 0xBC0E, 0xBC0E},
    {0xBC0F, 0xBC0F, 0xBC0F}, {0xBC10, 0xBC10, 0xBC10},
    {0xBC11, 0xBC11, 0xBC11}, {0xBC12, 0xBC12, 0xBC12},
    {0xBC13, 0xBC13, 0xBC13}, {0xBC14, 0xBC14, 0xBC14},
    {0xBC15, 0xBC15, 0xBC15}, {0xBC16, 0xBC16, 0xBC16},
    {0xBC17, 0xBC17, 0xBC17}, {0xBC18, 0xBC18, 0xBC18},
    {0xBC19, 0xBC19, 0xBC19}, {0xBC1A, 0xBC1A, 0xBC1A},
    {0xBC1B, 0xBC1B, 0xBC1B}, {0xBC1C, 0xBC1C, 0xBC1C},
    {0xBC1D, 0xBC1D, 0xBC1D}, {0xBC1E, 0xBC1E, 0xBC1E},
    {0xBC1F, 0xBC1F, 0xBC1F}, {0xBC20, 0xBC20, 0xBC20},
    {0xBC21, 0xBC21, 0xBC21}, {0xBC22, 0xBC22, 0xBC22},
    {0xBC23, 0xBC23, 0xBC23}, {0xBC24, 0xBC24, 0xBC24},
    {0xBC25, 0xBC25, 0xBC25}, {0xBC26, 0xBC26, 0xBC26},
    {0xBC27, 0xBC27, 0xBC27}, {0xBC28, 0xBC28, 0xBC28},
    {0xBC29, 0xBC29, 0xBC29}, {0xBC2A, 0xBC2A, 0xBC2A},
    {0xBC2B, 0xBC2B, 0xBC2B}, {0xBC2C, 0xBC2C, 0xBC2C},
    {0xBC2D, 0xBC2D, 0xBC2D}, {0xBC2E, 0xBC2E, 0xBC2E},
    {0xBC2F, 0xBC2F, 0xBC2F}, {0xBC30, 0xBC30, 0xBC30},
    {0xBC31, 0xBC31, 0xBC31}, {0xBC32, 0xBC32, 0xBC32},
    {0xBC33, 0xBC33, 0xBC33}, {0xBC34, 0xBC34, 0xBC34},
    {0xBC35, 0xBC35, 0xBC35}, {0xBC36, 0xBC36, 0xBC36},
    {0xBC37, 0xBC37, 0xBC37}, {0xBC38, 0xBC38, 0xBC38},
    {0xBC39, 0xBC39, 0xBC39}, {0xBC3A, 0xBC3A, 0xBC3A},
    {0xBC3B, 0xBC3B, 0xBC3B}, {0xBC3C, 0xBC3C, 0xBC3C},
    {0xBC3D, 0xBC3D, 0xBC3D}, {0xBC3E, 0xBC3E, 0xBC3E},
    {0xBC3F, 0xBC3F, 0xBC3F}, {0xBC40, 0xBC40, 0xBC40},
    {0xBC41, 0xBC41, 0xBC41}, {0xBC42, 0xBC42, 0xBC42},
    {0xBC43, 0xBC43, 0xBC43}, {0xBC44, 0xBC44, 0xBC44},
    {0xBC45, 0xBC45, 0xBC45}, {0xBC46, 0xBC46, 0xBC46},
    {0xBC47, 0xBC47, 0xBC47}, {0xBC48, 0xBC48, 0xBC48},
    {0xBC49, 0xBC49, 0xBC49}, {0xBC4A, 0xBC4A, 0xBC4A},
    {0xBC4B, 0xBC4B, 0xBC4B}, {0xBC4C, 0xBC4C, 0xBC4C},
    {0xBC4D, 0xBC4D, 0xBC4D}, {0xBC4E, 0xBC4E, 0xBC4E},
    {0xBC4F, 0xBC4F, 0xBC4F}, {0xBC50, 0xBC50, 0xBC50},
    {0xBC51, 0xBC51, 0xBC51}, {0xBC52, 0xBC52, 0xBC52},
    {0xBC53, 0xBC53, 0xBC53}, {0xBC54, 0xBC54, 0xBC54},
    {0xBC55, 0xBC55, 0xBC55}, {0xBC56, 0xBC56, 0xBC56},
    {0xBC57, 0xBC57, 0xBC57}, {0xBC58, 0xBC58, 0xBC58},
    {0xBC59, 0xBC59, 0xBC59}, {0xBC5A, 0xBC5A, 0xBC5A},
    {0xBC5B, 0xBC5B, 0xBC5B}, {0xBC5C, 0xBC5C, 0xBC5C},
    {0xBC5D, 0xBC5D, 0xBC5D}, {0xBC5E, 0xBC5E, 0xBC5E},
    {0xBC5F, 0xBC5F, 0xBC5F}, {0xBC60, 0xBC60, 0xBC60},
    {0xBC61, 0xBC61, 0xBC61}, {0xBC62, 0xBC62, 0xBC62},
    {0xBC63, 0xBC63, 0xBC63}, {0xBC64, 0xBC64, 0xBC64},
    {0xBC65, 0xBC65, 0xBC65}, {0xBC66, 0xBC66, 0xBC66},
    {0xBC67, 0xBC67, 0xBC67}, {0xBC68, 0xBC68, 0xBC68},
    {0xBC69, 0xBC69, 0xBC69}, {0xBC6A, 0xBC6A, 0xBC6A},
    {0xBC6B, 0xBC6B, 0xBC6B}, {0xBC6C, 0xBC6C, 0xBC6C},
    {0xBC6D, 0xBC6D, 0xBC6D}, {0xBC6E, 0xBC6E, 0xBC6E},
    {0xBC6F, 0xBC6F, 0xBC6F}, {0xBC70, 0xBC70, 0xBC70},
    {0xBC71, 0xBC71, 0xBC71}, {0xBC72, 0xBC72, 0xBC72},
    {0xBC73, 0xBC73, 0xBC73}, {0xBC74, 0xBC74, 0xBC74},
    {0xBC75, 0xBC75, 0xBC75}, {0xBC76, 0xBC76, 0xBC76},
    {0xBC77, 0xBC77, 0xBC77}, {0xBC78, 0xBC78, 0xBC78},
    {0xBC79, 0xBC79, 0xBC79}, {0xBC7A, 0xBC7A, 0xBC7A},
    {0xBC7B, 0xBC7B, 0xBC7B}, {0xBC7C, 0xBC7C, 0xBC7C},
    {0xBC7D, 0xBC7D, 0xBC7D}, {0xBC7E, 0xBC7E, 0xBC7E},
    {0xBC7F, 0xBC7F, 0xBC7F}, {0xBC80, 0xBC80, 0xBC80},
    {0xBC81, 0xBC81, 0xBC81}, {0xBC82, 0xBC82, 0xBC82},
    {0xBC83, 0xBC83, 0xBC83}, {0xBC84, 0xBC84, 0xBC84},
    {0xBC85, 0xBC85, 0xBC85}, {0xBC86, 0xBC86, 0xBC86},
    {0xBC87, 0xBC87, 0xBC87}, {0xBC88, 0xBC88, 0xBC88},
    {0xBC89, 0xBC89, 0xBC89}, {0xBC8A, 0xBC8A, 0xBC8A},
    {0xBC8B, 0xBC8B, 0xBC8B}, {0xBC8C, 0xBC8C, 0xBC8C},
    {0xBC8D, 0xBC8D, 0xBC8D}, {0xBC8E, 0xBC8E, 0xBC8E},
    {0xBC8F, 0xBC8F, 0xBC8F}, {0xBC90, 0xBC90, 0xBC90},
    {0xBC91, 0xBC91, 0xBC91}, {0xBC92, 0xBC92, 0xBC92},
    {0xBC93, 0xBC93, 0xBC93}, {0xBC94, 0xBC94, 0xBC94},
    {0xBC95, 0xBC95, 0xBC95}, {0xBC96, 0xBC96, 0xBC96},
    {0xBC97, 0xBC97, 0xBC97}, {0xBC98, 0xBC98, 0xBC98},
    {0xBC99, 0xBC99, 0xBC99}, {0xBC9A, 0xBC9A, 0xBC9A},
    {0xBC9B, 0xBC9B, 0xBC9B}, {0xBC9C, 0xBC9C, 0xBC9C},
    {0xBC9D, 0xBC9D, 0xBC9D}, {0xBC9E, 0xBC9E, 0xBC9E},
    {0xBC9F, 0xBC9F, 0xBC9F}, {0xBCA0, 0xBCA0, 0xBCA0},
    {0xBCA1, 0xBCA1, 0xBCA1}, {0xBCA2, 0xBCA2, 0xBCA2},
    {0xBCA3, 0xBCA3, 0xBCA3}, {0xBCA4, 0xBCA4, 0xBCA4},
    {0xBCA5, 0xBCA5, 0xBCA5}, {0xBCA6, 0xBCA6, 0xBCA6},
    {0xBCA7, 0xBCA7, 0xBCA7}, {0xBCA8, 0xBCA8, 0xBCA8},
    {0xBCA9, 0xBCA9, 0xBCA9}, {0xBCAA, 0xBCAA, 0xBCAA},
    {0xBCAB, 0xBCAB, 0xBCAB}, {0xBCAC, 0xBCAC, 0xBCAC},
    {0xBCAD, 0xBCAD, 0xBCAD}, {0xBCAE, 0xBCAE, 0xBCAE},
    {0xBCAF, 0xBCAF, 0xBCAF}, {0xBCB0, 0xBCB0, 0xBCB0},
    {0xBCB1, 0xBCB1, 0xBCB1}, {0xBCB2, 0xBCB2, 0xBCB2},
    {0xBCB3, 0xBCB3, 0xBCB3}, {0xBCB4, 0xBCB4, 0xBCB4},
    {0xBCB5, 0xBCB5, 0xBCB5}, {0xBCB6, 0xBCB6, 0xBCB6},
    {0xBCB7, 0xBCB7, 0xBCB7}, {0xBCB8, 0xBCB8, 0xBCB8},
    {0xBCB9, 0xBCB9, 0xBCB9}, {0xBCBA, 0xBCBA, 0xBCBA},
    {0xBCBB, 0xBCBB, 0xBCBB}, {0xBCBC, 0xBCBC, 0xBCBC},
    {0xBCBD, 0xBCBD, 0xBCBD}, {0xBCBE, 0xBCBE, 0xBCBE},
    {0xBCBF, 0xBCBF, 0xBCBF}, {0xBCC0, 0xBCC0, 0xBCC0},
    {0xBCC1, 0xBCC1, 0xBCC1}, {0xBCC2, 0xBCC2, 0xBCC2},
    {0xBCC3, 0xBCC3, 0xBCC3}, {0xBCC4, 0xBCC4, 0xBCC4},
    {0xBCC5, 0xBCC5, 0xBCC5}, {0xBCC6, 0xBCC6, 0xBCC6},
    {0xBCC7, 0xBCC7, 0xBCC7}, {0xBCC8, 0xBCC8, 0xBCC8},
    {0xBCC9, 0xBCC9, 0xBCC9}, {0xBCCA, 0xBCCA, 0xBCCA},
    {0xBCCB, 0xBCCB, 0xBCCB}, {0xBCCC, 0xBCCC, 0xBCCC},
    {0xBCCD, 0xBCCD, 0xBCCD}, {0xBCCE, 0xBCCE, 0xBCCE},
    {0xBCCF, 0xBCCF, 0xBCCF}, {0xBCD0, 0xBCD0, 0xBCD0},
    {0xBCD1, 0xBCD1, 0xBCD1}, {0xBCD2, 0xBCD2, 0xBCD2},
    {0xBCD3, 0xBCD3, 0xBCD3}, {0xBCD4, 0xBCD4, 0xBCD4},
    {0xBCD5, 0xBCD5, 0xBCD5}, {0xBCD6, 0xBCD6, 0xBCD6},
    {0xBCD7, 0xBCD7, 0xBCD7}, {0xBCD8, 0xBCD8, 0xBCD8},
    {0xBCD9, 0xBCD9, 0xBCD9}, {0xBCDA, 0xBCDA, 0xBCDA},
    {0xBCDB, 0xBCDB, 0xBCDB}, {0xBCDC, 0xBCDC, 0xBCDC},
    {0xBCDD, 0xBCDD, 0xBCDD}, {0xBCDE, 0xBCDE, 0xBCDE},
    {0xBCDF, 0xBCDF, 0xBCDF}, {0xBCE0, 0xBCE0, 0xBCE0},
    {0xBCE1, 0xBCE1, 0xBCE1}, {0xBCE2, 0xBCE2, 0xBCE2},
    {0xBCE3, 0xBCE3, 0xBCE3}, {0xBCE4, 0xBCE4, 0xBCE4},
    {0xBCE5, 0xBCE5, 0xBCE5}, {0xBCE6, 0xBCE6, 0xBCE6},
    {0xBCE7, 0xBCE7, 0xBCE7}, {0xBCE8, 0xBCE8, 0xBCE8},
    {0xBCE9, 0xBCE9, 0xBCE9}, {0xBCEA, 0xBCEA, 0xBCEA},
    {0xBCEB, 0xBCEB, 0xBCEB}, {0xBCEC, 0xBCEC, 0xBCEC},
    {0xBCED, 0xBCED, 0xBCED}, {0xBCEE, 0xBCEE, 0xBCEE},
    {0xBCEF, 0xBCEF, 0xBCEF}, {0xBCF0, 0xBCF0, 0xBCF0},
    {0xBCF1, 0xBCF1, 0xBCF1}, {0xBCF2, 0xBCF2, 0xBCF2},
    {0xBCF3, 0xBCF3, 0xBCF3}, {0xBCF4, 0xBCF4, 0xBCF4},
    {0xBCF5, 0xBCF5, 0xBCF5}, {0xBCF6, 0xBCF6, 0xBCF6},
    {0xBCF7, 0xBCF7, 0xBCF7}, {0xBCF8, 0xBCF8, 0xBCF8},
    {0xBCF9, 0xBCF9, 0xBCF9}, {0xBCFA, 0xBCFA, 0xBCFA},
    {0xBCFB, 0xBCFB, 0xBCFB}, {0xBCFC, 0xBCFC, 0xBCFC},
    {0xBCFD, 0xBCFD, 0xBCFD}, {0xBCFE, 0xBCFE, 0xBCFE},
    {0xBCFF, 0xBCFF, 0xBCFF}, {0xBD00, 0xBD00, 0xBD00},
    {0xBD01, 0xBD01, 0xBD01}, {0xBD02, 0xBD02, 0xBD02},
    {0xBD03, 0xBD03, 0xBD03}, {0xBD04, 0xBD04, 0xBD04},
    {0xBD05, 0xBD05, 0xBD05}, {0xBD06, 0xBD06, 0xBD06},
    {0xBD07, 0xBD07, 0xBD07}, {0xBD08, 0xBD08, 0xBD08},
    {0xBD09, 0xBD09, 0xBD09}, {0xBD0A, 0xBD0A, 0xBD0A},
    {0xBD0B, 0xBD0B, 0xBD0B}, {0xBD0C, 0xBD0C, 0xBD0C},
    {0xBD0D, 0xBD0D, 0xBD0D}, {0xBD0E, 0xBD0E, 0xBD0E},
    {0xBD0F, 0xBD0F, 0xBD0F}, {0xBD10, 0xBD10, 0xBD10},
    {0xBD11, 0xBD11, 0xBD11}, {0xBD12, 0xBD12, 0xBD12},
    {0xBD13, 0xBD13, 0xBD13}, {0xBD14, 0xBD14, 0xBD14},
    {0xBD15, 0xBD15, 0xBD15}, {0xBD16, 0xBD16, 0xBD16},
    {0xBD17, 0xBD17, 0xBD17}, {0xBD18, 0xBD18, 0xBD18},
    {0xBD19, 0xBD19, 0xBD19}, {0xBD1A, 0xBD1A, 0xBD1A},
    {0xBD1B, 0xBD1B, 0xBD1B}, {0xBD1C, 0xBD1C, 0xBD1C},
    {0xBD1D, 0xBD1D, 0xBD1D}, {0xBD1E, 0xBD1E, 0xBD1E},
    {0xBD1F, 0xBD1F, 0xBD1F}, {0xBD20, 0xBD20, 0xBD20},
    {0xBD21, 0xBD21, 0xBD21}, {0xBD22, 0xBD22, 0xBD22},
    {0xBD23, 0xBD23, 0xBD23}, {0xBD24, 0xBD24, 0xBD24},
    {0xBD25, 0xBD25, 0xBD25}, {0xBD26, 0xBD26, 0xBD26},
    {0xBD27, 0xBD27, 0xBD27}, {0xBD28, 0xBD28, 0xBD28},
    {0xBD29, 0xBD29, 0xBD29}, {0xBD2A, 0xBD2A, 0xBD2A},
    {0xBD2B, 0xBD2B, 0xBD2B}, {0xBD2C, 0xBD2C, 0xBD2C},
    {0xBD2D, 0xBD2D, 0xBD2D}, {0xBD2E, 0xBD2E, 0xBD2E},
    {0xBD2F, 0xBD2F, 0xBD2F}, {0xBD30, 0xBD30, 0xBD30},
    {0xBD31, 0xBD31, 0xBD31}, {0xBD32, 0xBD32, 0xBD32},
    {0xBD33, 0xBD33, 0xBD33}, {0xBD34, 0xBD34, 0xBD34},
    {0xBD35, 0xBD35, 0xBD35}, {0xBD36, 0xBD36, 0xBD36},
    {0xBD37, 0xBD37, 0xBD37}, {0xBD38, 0xBD38, 0xBD38},
    {0xBD39, 0xBD39, 0xBD39}, {0xBD3A, 0xBD3A, 0xBD3A},
    {0xBD3B, 0xBD3B, 0xBD3B}, {0xBD3C, 0xBD3C, 0xBD3C},
    {0xBD3D, 0xBD3D, 0xBD3D}, {0xBD3E, 0xBD3E, 0xBD3E},
    {0xBD3F, 0xBD3F, 0xBD3F}, {0xBD40, 0xBD40, 0xBD40},
    {0xBD41, 0xBD41, 0xBD41}, {0xBD42, 0xBD42, 0xBD42},
    {0xBD43, 0xBD43, 0xBD43}, {0xBD44, 0xBD44, 0xBD44},
    {0xBD45, 0xBD45, 0xBD45}, {0xBD46, 0xBD46, 0xBD46},
    {0xBD47, 0xBD47, 0xBD47}, {0xBD48, 0xBD48, 0xBD48},
    {0xBD49, 0xBD49, 0xBD49}, {0xBD4A, 0xBD4A, 0xBD4A},
    {0xBD4B, 0xBD4B, 0xBD4B}, {0xBD4C, 0xBD4C, 0xBD4C},
    {0xBD4D, 0xBD4D, 0xBD4D}, {0xBD4E, 0xBD4E, 0xBD4E},
    {0xBD4F, 0xBD4F, 0xBD4F}, {0xBD50, 0xBD50, 0xBD50},
    {0xBD51, 0xBD51, 0xBD51}, {0xBD52, 0xBD52, 0xBD52},
    {0xBD53, 0xBD53, 0xBD53}, {0xBD54, 0xBD54, 0xBD54},
    {0xBD55, 0xBD55, 0xBD55}, {0xBD56, 0xBD56, 0xBD56},
    {0xBD57, 0xBD57, 0xBD57}, {0xBD58, 0xBD58, 0xBD58},
    {0xBD59, 0xBD59, 0xBD59}, {0xBD5A, 0xBD5A, 0xBD5A},
    {0xBD5B, 0xBD5B, 0xBD5B}, {0xBD5C, 0xBD5C, 0xBD5C},
    {0xBD5D, 0xBD5D, 0xBD5D}, {0xBD5E, 0xBD5E, 0xBD5E},
    {0xBD5F, 0xBD5F, 0xBD5F}, {0xBD60, 0xBD60, 0xBD60},
    {0xBD61, 0xBD61, 0xBD61}, {0xBD62, 0xBD62, 0xBD62},
    {0xBD63, 0xBD63, 0xBD63}, {0xBD64, 0xBD64, 0xBD64},
    {0xBD65, 0xBD65, 0xBD65}, {0xBD66, 0xBD66, 0xBD66},
    {0xBD67, 0xBD67, 0xBD67}, {0xBD68, 0xBD68, 0xBD68},
    {0xBD69, 0xBD69, 0xBD69}, {0xBD6A, 0xBD6A, 0xBD6A},
    {0xBD6B, 0xBD6B, 0xBD6B}, {0xBD6C, 0xBD6C, 0xBD6C},
    {0xBD6D, 0xBD6D, 0xBD6D}, {0xBD6E, 0xBD6E, 0xBD6E},
    {0xBD6F, 0xBD6F, 0xBD6F}, {0xBD70, 0xBD70, 0xBD70},
    {0xBD71, 0xBD71, 0xBD71}, {0xBD72, 0xBD72, 0xBD72},
    {0xBD73, 0xBD73, 0xBD73}, {0xBD74, 0xBD74, 0xBD74},
    {0xBD75, 0xBD75, 0xBD75}, {0xBD76, 0xBD76, 0xBD76},
    {0xBD77, 0xBD77, 0xBD77}, {0xBD78, 0xBD78, 0xBD78},
    {0xBD79, 0xBD79, 0xBD79}, {0xBD7A, 0xBD7A, 0xBD7A},
    {0xBD7B, 0xBD7B, 0xBD7B}, {0xBD7C, 0xBD7C, 0xBD7C},
    {0xBD7D, 0xBD7D, 0xBD7D}, {0xBD7E, 0xBD7E, 0xBD7E},
    {0xBD7F, 0xBD7F, 0xBD7F}, {0xBD80, 0xBD80, 0xBD80},
    {0xBD81, 0xBD81, 0xBD81}, {0xBD82, 0xBD82, 0xBD82},
    {0xBD83, 0xBD83, 0xBD83}, {0xBD84, 0xBD84, 0xBD84},
    {0xBD85, 0xBD85, 0xBD85}, {0xBD86, 0xBD86, 0xBD86},
    {0xBD87, 0xBD87, 0xBD87}, {0xBD88, 0xBD88, 0xBD88},
    {0xBD89, 0xBD89, 0xBD89}, {0xBD8A, 0xBD8A, 0xBD8A},
    {0xBD8B, 0xBD8B, 0xBD8B}, {0xBD8C, 0xBD8C, 0xBD8C},
    {0xBD8D, 0xBD8D, 0xBD8D}, {0xBD8E, 0xBD8E, 0xBD8E},
    {0xBD8F, 0xBD8F, 0xBD8F}, {0xBD90, 0xBD90, 0xBD90},
    {0xBD91, 0xBD91, 0xBD91}, {0xBD92, 0xBD92, 0xBD92},
    {0xBD93, 0xBD93, 0xBD93}, {0xBD94, 0xBD94, 0xBD94},
    {0xBD95, 0xBD95, 0xBD95}, {0xBD96, 0xBD96, 0xBD96},
    {0xBD97, 0xBD97, 0xBD97}, {0xBD98, 0xBD98, 0xBD98},
    {0xBD99, 0xBD99, 0xBD99}, {0xBD9A, 0xBD9A, 0xBD9A},
    {0xBD9B, 0xBD9B, 0xBD9B}, {0xBD9C, 0xBD9C, 0xBD9C},
    {0xBD9D, 0xBD9D, 0xBD9D}, {0xBD9E, 0xBD9E, 0xBD9E},
    {0xBD9F, 0xBD9F, 0xBD9F}, {0xBDA0, 0xBDA0, 0xBDA0},
    {0xBDA1, 0xBDA1, 0xBDA1}, {0xBDA2, 0xBDA2, 0xBDA2},
    {0xBDA3, 0xBDA3, 0xBDA3}, {0xBDA4, 0xBDA4, 0xBDA4},
    {0xBDA5, 0xBDA5, 0xBDA5}, {0xBDA6, 0xBDA6, 0xBDA6},
    {0xBDA7, 0xBDA7, 0xBDA7}, {0xBDA8, 0xBDA8, 0xBDA8},
    {0xBDA9, 0xBDA9, 0xBDA9}, {0xBDAA, 0xBDAA, 0xBDAA},
    {0xBDAB, 0xBDAB, 0xBDAB}, {0xBDAC, 0xBDAC, 0xBDAC},
    {0xBDAD, 0xBDAD, 0xBDAD}, {0xBDAE, 0xBDAE, 0xBDAE},
    {0xBDAF, 0xBDAF, 0xBDAF}, {0xBDB0, 0xBDB0, 0xBDB0},
    {0xBDB1, 0xBDB1, 0xBDB1}, {0xBDB2, 0xBDB2, 0xBDB2},
    {0xBDB3, 0xBDB3, 0xBDB3}, {0xBDB4, 0xBDB4, 0xBDB4},
    {0xBDB5, 0xBDB5, 0xBDB5}, {0xBDB6, 0xBDB6, 0xBDB6},
    {0xBDB7, 0xBDB7, 0xBDB7}, {0xBDB8, 0xBDB8, 0xBDB8},
    {0xBDB9, 0xBDB9, 0xBDB9}, {0xBDBA, 0xBDBA, 0xBDBA},
    {0xBDBB, 0xBDBB, 0xBDBB}, {0xBDBC, 0xBDBC, 0xBDBC},
    {0xBDBD, 0xBDBD, 0xBDBD}, {0xBDBE, 0xBDBE, 0xBDBE},
    {0xBDBF, 0xBDBF, 0xBDBF}, {0xBDC0, 0xBDC0, 0xBDC0},
    {0xBDC1, 0xBDC1, 0xBDC1}, {0xBDC2, 0xBDC2, 0xBDC2},
    {0xBDC3, 0xBDC3, 0xBDC3}, {0xBDC4, 0xBDC4, 0xBDC4},
    {0xBDC5, 0xBDC5, 0xBDC5}, {0xBDC6, 0xBDC6, 0xBDC6},
    {0xBDC7, 0xBDC7, 0xBDC7}, {0xBDC8, 0xBDC8, 0xBDC8},
    {0xBDC9, 0xBDC9, 0xBDC9}, {0xBDCA, 0xBDCA, 0xBDCA},
    {0xBDCB, 0xBDCB, 0xBDCB}, {0xBDCC, 0xBDCC, 0xBDCC},
    {0xBDCD, 0xBDCD, 0xBDCD}, {0xBDCE, 0xBDCE, 0xBDCE},
    {0xBDCF, 0xBDCF, 0xBDCF}, {0xBDD0, 0xBDD0, 0xBDD0},
    {0xBDD1, 0xBDD1, 0xBDD1}, {0xBDD2, 0xBDD2, 0xBDD2},
    {0xBDD3, 0xBDD3, 0xBDD3}, {0xBDD4, 0xBDD4, 0xBDD4},
    {0xBDD5, 0xBDD5, 0xBDD5}, {0xBDD6, 0xBDD6, 0xBDD6},
    {0xBDD7, 0xBDD7, 0xBDD7}, {0xBDD8, 0xBDD8, 0xBDD8},
    {0xBDD9, 0xBDD9, 0xBDD9}, {0xBDDA, 0xBDDA, 0xBDDA},
    {0xBDDB, 0xBDDB, 0xBDDB}, {0xBDDC, 0xBDDC, 0xBDDC},
    {0xBDDD, 0xBDDD, 0xBDDD}, {0xBDDE, 0xBDDE, 0xBDDE},
    {0xBDDF, 0xBDDF, 0xBDDF}, {0xBDE0, 0xBDE0, 0xBDE0},
    {0xBDE1, 0xBDE1, 0xBDE1}, {0xBDE2, 0xBDE2, 0xBDE2},
    {0xBDE3, 0xBDE3, 0xBDE3}, {0xBDE4, 0xBDE4, 0xBDE4},
    {0xBDE5, 0xBDE5, 0xBDE5}, {0xBDE6, 0xBDE6, 0xBDE6},
    {0xBDE7, 0xBDE7, 0xBDE7}, {0xBDE8, 0xBDE8, 0xBDE8},
    {0xBDE9, 0xBDE9, 0xBDE9}, {0xBDEA, 0xBDEA, 0xBDEA},
    {0xBDEB, 0xBDEB, 0xBDEB}, {0xBDEC, 0xBDEC, 0xBDEC},
    {0xBDED, 0xBDED, 0xBDED}, {0xBDEE, 0xBDEE, 0xBDEE},
    {0xBDEF, 0xBDEF, 0xBDEF}, {0xBDF0, 0xBDF0, 0xBDF0},
    {0xBDF1, 0xBDF1, 0xBDF1}, {0xBDF2, 0xBDF2, 0xBDF2},
    {0xBDF3, 0xBDF3, 0xBDF3}, {0xBDF4, 0xBDF4, 0xBDF4},
    {0xBDF5, 0xBDF5, 0xBDF5}, {0xBDF6, 0xBDF6, 0xBDF6},
    {0xBDF7, 0xBDF7, 0xBDF7}, {0xBDF8, 0xBDF8, 0xBDF8},
    {0xBDF9, 0xBDF9, 0xBDF9}, {0xBDFA, 0xBDFA, 0xBDFA},
    {0xBDFB, 0xBDFB, 0xBDFB}, {0xBDFC, 0xBDFC, 0xBDFC},
    {0xBDFD, 0xBDFD, 0xBDFD}, {0xBDFE, 0xBDFE, 0xBDFE},
    {0xBDFF, 0xBDFF, 0xBDFF}, {0xBE00, 0xBE00, 0xBE00},
    {0xBE01, 0xBE01, 0xBE01}, {0xBE02, 0xBE02, 0xBE02},
    {0xBE03, 0xBE03, 0xBE03}, {0xBE04, 0xBE04, 0xBE04},
    {0xBE05, 0xBE05, 0xBE05}, {0xBE06, 0xBE06, 0xBE06},
    {0xBE07, 0xBE07, 0xBE07}, {0xBE08, 0xBE08, 0xBE08},
    {0xBE09, 0xBE09, 0xBE09}, {0xBE0A, 0xBE0A, 0xBE0A},
    {0xBE0B, 0xBE0B, 0xBE0B}, {0xBE0C, 0xBE0C, 0xBE0C},
    {0xBE0D, 0xBE0D, 0xBE0D}, {0xBE0E, 0xBE0E, 0xBE0E},
    {0xBE0F, 0xBE0F, 0xBE0F}, {0xBE10, 0xBE10, 0xBE10},
    {0xBE11, 0xBE11, 0xBE11}, {0xBE12, 0xBE12, 0xBE12},
    {0xBE13, 0xBE13, 0xBE13}, {0xBE14, 0xBE14, 0xBE14},
    {0xBE15, 0xBE15, 0xBE15}, {0xBE16, 0xBE16, 0xBE16},
    {0xBE17, 0xBE17, 0xBE17}, {0xBE18, 0xBE18, 0xBE18},
    {0xBE19, 0xBE19, 0xBE19}, {0xBE1A, 0xBE1A, 0xBE1A},
    {0xBE1B, 0xBE1B, 0xBE1B}, {0xBE1C, 0xBE1C, 0xBE1C},
    {0xBE1D, 0xBE1D, 0xBE1D}, {0xBE1E, 0xBE1E, 0xBE1E},
    {0xBE1F, 0xBE1F, 0xBE1F}, {0xBE20, 0xBE20, 0xBE20},
    {0xBE21, 0xBE21, 0xBE21}, {0xBE22, 0xBE22, 0xBE22},
    {0xBE23, 0xBE23, 0xBE23}, {0xBE24, 0xBE24, 0xBE24},
    {0xBE25, 0xBE25, 0xBE25}, {0xBE26, 0xBE26, 0xBE26},
    {0xBE27, 0xBE27, 0xBE27}, {0xBE28, 0xBE28, 0xBE28},
    {0xBE29, 0xBE29, 0xBE29}, {0xBE2A, 0xBE2A, 0xBE2A},
    {0xBE2B, 0xBE2B, 0xBE2B}, {0xBE2C, 0xBE2C, 0xBE2C},
    {0xBE2D, 0xBE2D, 0xBE2D}, {0xBE2E, 0xBE2E, 0xBE2E},
    {0xBE2F, 0xBE2F, 0xBE2F}, {0xBE30, 0xBE30, 0xBE30},
    {0xBE31, 0xBE31, 0xBE31}, {0xBE32, 0xBE32, 0xBE32},
    {0xBE33, 0xBE33, 0xBE33}, {0xBE34, 0xBE34, 0xBE34},
    {0xBE35, 0xBE35, 0xBE35}, {0xBE36, 0xBE36, 0xBE36},
    {0xBE37, 0xBE37, 0xBE37}, {0xBE38, 0xBE38, 0xBE38},
    {0xBE39, 0xBE39, 0xBE39}, {0xBE3A, 0xBE3A, 0xBE3A},
    {0xBE3B, 0xBE3B, 0xBE3B}, {0xBE3C, 0xBE3C, 0xBE3C},
    {0xBE3D, 0xBE3D, 0xBE3D}, {0xBE3E, 0xBE3E, 0xBE3E},
    {0xBE3F, 0xBE3F, 0xBE3F}, {0xBE40, 0xBE40, 0xBE40},
    {0xBE41, 0xBE41, 0xBE41}, {0xBE42, 0xBE42, 0xBE42},
    {0xBE43, 0xBE43, 0xBE43}, {0xBE44, 0xBE44, 0xBE44},
    {0xBE45, 0xBE45, 0xBE45}, {0xBE46, 0xBE46, 0xBE46},
    {0xBE47, 0xBE47, 0xBE47}, {0xBE48, 0xBE48, 0xBE48},
    {0xBE49, 0xBE49, 0xBE49}, {0xBE4A, 0xBE4A, 0xBE4A},
    {0xBE4B, 0xBE4B, 0xBE4B}, {0xBE4C, 0xBE4C, 0xBE4C},
    {0xBE4D, 0xBE4D, 0xBE4D}, {0xBE4E, 0xBE4E, 0xBE4E},
    {0xBE4F, 0xBE4F, 0xBE4F}, {0xBE50, 0xBE50, 0xBE50},
    {0xBE51, 0xBE51, 0xBE51}, {0xBE52, 0xBE52, 0xBE52},
    {0xBE53, 0xBE53, 0xBE53}, {0xBE54, 0xBE54, 0xBE54},
    {0xBE55, 0xBE55, 0xBE55}, {0xBE56, 0xBE56, 0xBE56},
    {0xBE57, 0xBE57, 0xBE57}, {0xBE58, 0xBE58, 0xBE58},
    {0xBE59, 0xBE59, 0xBE59}, {0xBE5A, 0xBE5A, 0xBE5A},
    {0xBE5B, 0xBE5B, 0xBE5B}, {0xBE5C, 0xBE5C, 0xBE5C},
    {0xBE5D, 0xBE5D, 0xBE5D}, {0xBE5E, 0xBE5E, 0xBE5E},
    {0xBE5F, 0xBE5F, 0xBE5F}, {0xBE60, 0xBE60, 0xBE60},
    {0xBE61, 0xBE61, 0xBE61}, {0xBE62, 0xBE62, 0xBE62},
    {0xBE63, 0xBE63, 0xBE63}, {0xBE64, 0xBE64, 0xBE64},
    {0xBE65, 0xBE65, 0xBE65}, {0xBE66, 0xBE66, 0xBE66},
    {0xBE67, 0xBE67, 0xBE67}, {0xBE68, 0xBE68, 0xBE68},
    {0xBE69, 0xBE69, 0xBE69}, {0xBE6A, 0xBE6A, 0xBE6A},
    {0xBE6B, 0xBE6B, 0xBE6B}, {0xBE6C, 0xBE6C, 0xBE6C},
    {0xBE6D, 0xBE6D, 0xBE6D}, {0xBE6E, 0xBE6E, 0xBE6E},
    {0xBE6F, 0xBE6F, 0xBE6F}, {0xBE70, 0xBE70, 0xBE70},
    {0xBE71, 0xBE71, 0xBE71}, {0xBE72, 0xBE72, 0xBE72},
    {0xBE73, 0xBE73, 0xBE73}, {0xBE74, 0xBE74, 0xBE74},
    {0xBE75, 0xBE75, 0xBE75}, {0xBE76, 0xBE76, 0xBE76},
    {0xBE77, 0xBE77, 0xBE77}, {0xBE78, 0xBE78, 0xBE78},
    {0xBE79, 0xBE79, 0xBE79}, {0xBE7A, 0xBE7A, 0xBE7A},
    {0xBE7B, 0xBE7B, 0xBE7B}, {0xBE7C, 0xBE7C, 0xBE7C},
    {0xBE7D, 0xBE7D, 0xBE7D}, {0xBE7E, 0xBE7E, 0xBE7E},
    {0xBE7F, 0xBE7F, 0xBE7F}, {0xBE80, 0xBE80, 0xBE80},
    {0xBE81, 0xBE81, 0xBE81}, {0xBE82, 0xBE82, 0xBE82},
    {0xBE83, 0xBE83, 0xBE83}, {0xBE84, 0xBE84, 0xBE84},
    {0xBE85, 0xBE85, 0xBE85}, {0xBE86, 0xBE86, 0xBE86},
    {0xBE87, 0xBE87, 0xBE87}, {0xBE88, 0xBE88, 0xBE88},
    {0xBE89, 0xBE89, 0xBE89}, {0xBE8A, 0xBE8A, 0xBE8A},
    {0xBE8B, 0xBE8B, 0xBE8B}, {0xBE8C, 0xBE8C, 0xBE8C},
    {0xBE8D, 0xBE8D, 0xBE8D}, {0xBE8E, 0xBE8E, 0xBE8E},
    {0xBE8F, 0xBE8F, 0xBE8F}, {0xBE90, 0xBE90, 0xBE90},
    {0xBE91, 0xBE91, 0xBE91}, {0xBE92, 0xBE92, 0xBE92},
    {0xBE93, 0xBE93, 0xBE93}, {0xBE94, 0xBE94, 0xBE94},
    {0xBE95, 0xBE95, 0xBE95}, {0xBE96, 0xBE96, 0xBE96},
    {0xBE97, 0xBE97, 0xBE97}, {0xBE98, 0xBE98, 0xBE98},
    {0xBE99, 0xBE99, 0xBE99}, {0xBE9A, 0xBE9A, 0xBE9A},
    {0xBE9B, 0xBE9B, 0xBE9B}, {0xBE9C, 0xBE9C, 0xBE9C},
    {0xBE9D, 0xBE9D, 0xBE9D}, {0xBE9E, 0xBE9E, 0xBE9E},
    {0xBE9F, 0xBE9F, 0xBE9F}, {0xBEA0, 0xBEA0, 0xBEA0},
    {0xBEA1, 0xBEA1, 0xBEA1}, {0xBEA2, 0xBEA2, 0xBEA2},
    {0xBEA3, 0xBEA3, 0xBEA3}, {0xBEA4, 0xBEA4, 0xBEA4},
    {0xBEA5, 0xBEA5, 0xBEA5}, {0xBEA6, 0xBEA6, 0xBEA6},
    {0xBEA7, 0xBEA7, 0xBEA7}, {0xBEA8, 0xBEA8, 0xBEA8},
    {0xBEA9, 0xBEA9, 0xBEA9}, {0xBEAA, 0xBEAA, 0xBEAA},
    {0xBEAB, 0xBEAB, 0xBEAB}, {0xBEAC, 0xBEAC, 0xBEAC},
    {0xBEAD, 0xBEAD, 0xBEAD}, {0xBEAE, 0xBEAE, 0xBEAE},
    {0xBEAF, 0xBEAF, 0xBEAF}, {0xBEB0, 0xBEB0, 0xBEB0},
    {0xBEB1, 0xBEB1, 0xBEB1}, {0xBEB2, 0xBEB2, 0xBEB2},
    {0xBEB3, 0xBEB3, 0xBEB3}, {0xBEB4, 0xBEB4, 0xBEB4},
    {0xBEB5, 0xBEB5, 0xBEB5}, {0xBEB6, 0xBEB6, 0xBEB6},
    {0xBEB7, 0xBEB7, 0xBEB7}, {0xBEB8, 0xBEB8, 0xBEB8},
    {0xBEB9, 0xBEB9, 0xBEB9}, {0xBEBA, 0xBEBA, 0xBEBA},
    {0xBEBB, 0xBEBB, 0xBEBB}, {0xBEBC, 0xBEBC, 0xBEBC},
    {0xBEBD, 0xBEBD, 0xBEBD}, {0xBEBE, 0xBEBE, 0xBEBE},
    {0xBEBF, 0xBEBF, 0xBEBF}, {0xBEC0, 0xBEC0, 0xBEC0},
    {0xBEC1, 0xBEC1, 0xBEC1}, {0xBEC2, 0xBEC2, 0xBEC2},
    {0xBEC3, 0xBEC3, 0xBEC3}, {0xBEC4, 0xBEC4, 0xBEC4},
    {0xBEC5, 0xBEC5, 0xBEC5}, {0xBEC6, 0xBEC6, 0xBEC6},
    {0xBEC7, 0xBEC7, 0xBEC7}, {0xBEC8, 0xBEC8, 0xBEC8},
    {0xBEC9, 0xBEC9, 0xBEC9}, {0xBECA, 0xBECA, 0xBECA},
    {0xBECB, 0xBECB, 0xBECB}, {0xBECC, 0xBECC, 0xBECC},
    {0xBECD, 0xBECD, 0xBECD}, {0xBECE, 0xBECE, 0xBECE},
    {0xBECF, 0xBECF, 0xBECF}, {0xBED0, 0xBED0, 0xBED0},
    {0xBED1, 0xBED1, 0xBED1}, {0xBED2, 0xBED2, 0xBED2},
    {0xBED3, 0xBED3, 0xBED3}, {0xBED4, 0xBED4, 0xBED4},
    {0xBED5, 0xBED5, 0xBED5}, {0xBED6, 0xBED6, 0xBED6},
    {0xBED7, 0xBED7, 0xBED7}, {0xBED8, 0xBED8, 0xBED8},
    {0xBED9, 0xBED9, 0xBED9}, {0xBEDA, 0xBEDA, 0xBEDA},
    {0xBEDB, 0xBEDB, 0xBEDB}, {0xBEDC, 0xBEDC, 0xBEDC},
    {0xBEDD, 0xBEDD, 0xBEDD}, {0xBEDE, 0xBEDE, 0xBEDE},
    {0xBEDF, 0xBEDF, 0xBEDF}, {0xBEE0, 0xBEE0, 0xBEE0},
    {0xBEE1, 0xBEE1, 0xBEE1}, {0xBEE2, 0xBEE2, 0xBEE2},
    {0xBEE3, 0xBEE3, 0xBEE3}, {0xBEE4, 0xBEE4, 0xBEE4},
    {0xBEE5, 0xBEE5, 0xBEE5}, {0xBEE6, 0xBEE6, 0xBEE6},
    {0xBEE7, 0xBEE7, 0xBEE7}, {0xBEE8, 0xBEE8, 0xBEE8},
    {0xBEE9, 0xBEE9, 0xBEE9}, {0xBEEA, 0xBEEA, 0xBEEA},
    {0xBEEB, 0xBEEB, 0xBEEB}, {0xBEEC, 0xBEEC, 0xBEEC},
    {0xBEED, 0xBEED, 0xBEED}, {0xBEEE, 0xBEEE, 0xBEEE},
    {0xBEEF, 0xBEEF, 0xBEEF}, {0xBEF0, 0xBEF0, 0xBEF0},
    {0xBEF1, 0xBEF1, 0xBEF1}, {0xBEF2, 0xBEF2, 0xBEF2},
    {0xBEF3, 0xBEF3, 0xBEF3}, {0xBEF4, 0xBEF4, 0xBEF4},
    {0xBEF5, 0xBEF5, 0xBEF5}, {0xBEF6, 0xBEF6, 0xBEF6},
    {0xBEF7, 0xBEF7, 0xBEF7}, {0xBEF8, 0xBEF8, 0xBEF8},
    {0xBEF9, 0xBEF9, 0xBEF9}, {0xBEFA, 0xBEFA, 0xBEFA},
    {0xBEFB, 0xBEFB, 0xBEFB}, {0xBEFC, 0xBEFC, 0xBEFC},
    {0xBEFD, 0xBEFD, 0xBEFD}, {0xBEFE, 0xBEFE, 0xBEFE},
    {0xBEFF, 0xBEFF, 0xBEFF}, {0xBF00, 0xBF00, 0xBF00},
    {0xBF01, 0xBF01, 0xBF01}, {0xBF02, 0xBF02, 0xBF02},
    {0xBF03, 0xBF03, 0xBF03}, {0xBF04, 0xBF04, 0xBF04},
    {0xBF05, 0xBF05, 0xBF05}, {0xBF06, 0xBF06, 0xBF06},
    {0xBF07, 0xBF07, 0xBF07}, {0xBF08, 0xBF08, 0xBF08},
    {0xBF09, 0xBF09, 0xBF09}, {0xBF0A, 0xBF0A, 0xBF0A},
    {0xBF0B, 0xBF0B, 0xBF0B}, {0xBF0C, 0xBF0C, 0xBF0C},
    {0xBF0D, 0xBF0D, 0xBF0D}, {0xBF0E, 0xBF0E, 0xBF0E},
    {0xBF0F, 0xBF0F, 0xBF0F}, {0xBF10, 0xBF10, 0xBF10},
    {0xBF11, 0xBF11, 0xBF11}, {0xBF12, 0xBF12, 0xBF12},
    {0xBF13, 0xBF13, 0xBF13}, {0xBF14, 0xBF14, 0xBF14},
    {0xBF15, 0xBF15, 0xBF15}, {0xBF16, 0xBF16, 0xBF16},
    {0xBF17, 0xBF17, 0xBF17}, {0xBF18, 0xBF18, 0xBF18},
    {0xBF19, 0xBF19, 0xBF19}, {0xBF1A, 0xBF1A, 0xBF1A},
    {0xBF1B, 0xBF1B, 0xBF1B}, {0xBF1C, 0xBF1C, 0xBF1C},
    {0xBF1D, 0xBF1D, 0xBF1D}, {0xBF1E, 0xBF1E, 0xBF1E},
    {0xBF1F, 0xBF1F, 0xBF1F}, {0xBF20, 0xBF20, 0xBF20},
    {0xBF21, 0xBF21, 0xBF21}, {0xBF22, 0xBF22, 0xBF22},
    {0xBF23, 0xBF23, 0xBF23}, {0xBF24, 0xBF24, 0xBF24},
    {0xBF25, 0xBF25, 0xBF25}, {0xBF26, 0xBF26, 0xBF26},
    {0xBF27, 0xBF27, 0xBF27}, {0xBF28, 0xBF28, 0xBF28},
    {0xBF29, 0xBF29, 0xBF29}, {0xBF2A, 0xBF2A, 0xBF2A},
    {0xBF2B, 0xBF2B, 0xBF2B}, {0xBF2C, 0xBF2C, 0xBF2C},
    {0xBF2D, 0xBF2D, 0xBF2D}, {0xBF2E, 0xBF2E, 0xBF2E},
    {0xBF2F, 0xBF2F, 0xBF2F}, {0xBF30, 0xBF30, 0xBF30},
    {0xBF31, 0xBF31, 0xBF31}, {0xBF32, 0xBF32, 0xBF32},
    {0xBF33, 0xBF33, 0xBF33}, {0xBF34, 0xBF34, 0xBF34},
    {0xBF35, 0xBF35, 0xBF35}, {0xBF36, 0xBF36, 0xBF36},
    {0xBF37, 0xBF37, 0xBF37}, {0xBF38, 0xBF38, 0xBF38},
    {0xBF39, 0xBF39, 0xBF39}, {0xBF3A, 0xBF3A, 0xBF3A},
    {0xBF3B, 0xBF3B, 0xBF3B}, {0xBF3C, 0xBF3C, 0xBF3C},
    {0xBF3D, 0xBF3D, 0xBF3D}, {0xBF3E, 0xBF3E, 0xBF3E},
    {0xBF3F, 0xBF3F, 0xBF3F}, {0xBF40, 0xBF40, 0xBF40},
    {0xBF41, 0xBF41, 0xBF41}, {0xBF42, 0xBF42, 0xBF42},
    {0xBF43, 0xBF43, 0xBF43}, {0xBF44, 0xBF44, 0xBF44},
    {0xBF45, 0xBF45, 0xBF45}, {0xBF46, 0xBF46, 0xBF46},
    {0xBF47, 0xBF47, 0xBF47}, {0xBF48, 0xBF48, 0xBF48},
    {0xBF49, 0xBF49, 0xBF49}, {0xBF4A, 0xBF4A, 0xBF4A},
    {0xBF4B, 0xBF4B, 0xBF4B}, {0xBF4C, 0xBF4C, 0xBF4C},
    {0xBF4D, 0xBF4D, 0xBF4D}, {0xBF4E, 0xBF4E, 0xBF4E},
    {0xBF4F, 0xBF4F, 0xBF4F}, {0xBF50, 0xBF50, 0xBF50},
    {0xBF51, 0xBF51, 0xBF51}, {0xBF52, 0xBF52, 0xBF52},
    {0xBF53, 0xBF53, 0xBF53}, {0xBF54, 0xBF54, 0xBF54},
    {0xBF55, 0xBF55, 0xBF55}, {0xBF56, 0xBF56, 0xBF56},
    {0xBF57, 0xBF57, 0xBF57}, {0xBF58, 0xBF58, 0xBF58},
    {0xBF59, 0xBF59, 0xBF59}, {0xBF5A, 0xBF5A, 0xBF5A},
    {0xBF5B, 0xBF5B, 0xBF5B}, {0xBF5C, 0xBF5C, 0xBF5C},
    {0xBF5D, 0xBF5D, 0xBF5D}, {0xBF5E, 0xBF5E, 0xBF5E},
    {0xBF5F, 0xBF5F, 0xBF5F}, {0xBF60, 0xBF60, 0xBF60},
    {0xBF61, 0xBF61, 0xBF61}, {0xBF62, 0xBF62, 0xBF62},
    {0xBF63, 0xBF63, 0xBF63}, {0xBF64, 0xBF64, 0xBF64},
    {0xBF65, 0xBF65, 0xBF65}, {0xBF66, 0xBF66, 0xBF66},
    {0xBF67, 0xBF67, 0xBF67}, {0xBF68, 0xBF68, 0xBF68},
    {0xBF69, 0xBF69, 0xBF69}, {0xBF6A, 0xBF6A, 0xBF6A},
    {0xBF6B, 0xBF6B, 0xBF6B}, {0xBF6C, 0xBF6C, 0xBF6C},
    {0xBF6D, 0xBF6D, 0xBF6D}, {0xBF6E, 0xBF6E, 0xBF6E},
    {0xBF6F, 0xBF6F, 0xBF6F}, {0xBF70, 0xBF70, 0xBF70},
    {0xBF71, 0xBF71, 0xBF71}, {0xBF72, 0xBF72, 0xBF72},
    {0xBF73, 0xBF73, 0xBF73}, {0xBF74, 0xBF74, 0xBF74},
    {0xBF75, 0xBF75, 0xBF75}, {0xBF76, 0xBF76, 0xBF76},
    {0xBF77, 0xBF77, 0xBF77}, {0xBF78, 0xBF78, 0xBF78},
    {0xBF79, 0xBF79, 0xBF79}, {0xBF7A, 0xBF7A, 0xBF7A},
    {0xBF7B, 0xBF7B, 0xBF7B}, {0xBF7C, 0xBF7C, 0xBF7C},
    {0xBF7D, 0xBF7D, 0xBF7D}, {0xBF7E, 0xBF7E, 0xBF7E},
    {0xBF7F, 0xBF7F, 0xBF7F}, {0xBF80, 0xBF80, 0xBF80},
    {0xBF81, 0xBF81, 0xBF81}, {0xBF82, 0xBF82, 0xBF82},
    {0xBF83, 0xBF83, 0xBF83}, {0xBF84, 0xBF84, 0xBF84},
    {0xBF85, 0xBF85, 0xBF85}, {0xBF86, 0xBF86, 0xBF86},
    {0xBF87, 0xBF87, 0xBF87}, {0xBF88, 0xBF88, 0xBF88},
    {0xBF89, 0xBF89, 0xBF89}, {0xBF8A, 0xBF8A, 0xBF8A},
    {0xBF8B, 0xBF8B, 0xBF8B}, {0xBF8C, 0xBF8C, 0xBF8C},
    {0xBF8D, 0xBF8D, 0xBF8D}, {0xBF8E, 0xBF8E, 0xBF8E},
    {0xBF8F, 0xBF8F, 0xBF8F}, {0xBF90, 0xBF90, 0xBF90},
    {0xBF91, 0xBF91, 0xBF91}, {0xBF92, 0xBF92, 0xBF92},
    {0xBF93, 0xBF93, 0xBF93}, {0xBF94, 0xBF94, 0xBF94},
    {0xBF95, 0xBF95, 0xBF95}, {0xBF96, 0xBF96, 0xBF96},
    {0xBF97, 0xBF97, 0xBF97}, {0xBF98, 0xBF98, 0xBF98},
    {0xBF99, 0xBF99, 0xBF99}, {0xBF9A, 0xBF9A, 0xBF9A},
    {0xBF9B, 0xBF9B, 0xBF9B}, {0xBF9C, 0xBF9C, 0xBF9C},
    {0xBF9D, 0xBF9D, 0xBF9D}, {0xBF9E, 0xBF9E, 0xBF9E},
    {0xBF9F, 0xBF9F, 0xBF9F}, {0xBFA0, 0xBFA0, 0xBFA0},
    {0xBFA1, 0xBFA1, 0xBFA1}, {0xBFA2, 0xBFA2, 0xBFA2},
    {0xBFA3, 0xBFA3, 0xBFA3}, {0xBFA4, 0xBFA4, 0xBFA4},
    {0xBFA5, 0xBFA5, 0xBFA5}, {0xBFA6, 0xBFA6, 0xBFA6},
    {0xBFA7, 0xBFA7, 0xBFA7}, {0xBFA8, 0xBFA8, 0xBFA8},
    {0xBFA9, 0xBFA9, 0xBFA9}, {0xBFAA, 0xBFAA, 0xBFAA},
    {0xBFAB, 0xBFAB, 0xBFAB}, {0xBFAC, 0xBFAC, 0xBFAC},
    {0xBFAD, 0xBFAD, 0xBFAD}, {0xBFAE, 0xBFAE, 0xBFAE},
    {0xBFAF, 0xBFAF, 0xBFAF}, {0xBFB0, 0xBFB0, 0xBFB0},
    {0xBFB1, 0xBFB1, 0xBFB1}, {0xBFB2, 0xBFB2, 0xBFB2},
    {0xBFB3, 0xBFB3, 0xBFB3}, {0xBFB4, 0xBFB4, 0xBFB4},
    {0xBFB5, 0xBFB5, 0xBFB5}, {0xBFB6, 0xBFB6, 0xBFB6},
    {0xBFB7, 0xBFB7, 0xBFB7}, {0xBFB8, 0xBFB8, 0xBFB8},
    {0xBFB9, 0xBFB9, 0xBFB9}, {0xBFBA, 0xBFBA, 0xBFBA},
    {0xBFBB, 0xBFBB, 0xBFBB}, {0xBFBC, 0xBFBC, 0xBFBC},
    {0xBFBD, 0xBFBD, 0xBFBD}, {0xBFBE, 0xBFBE, 0xBFBE},
    {0xBFBF, 0xBFBF, 0xBFBF}, {0xBFC0, 0xBFC0, 0xBFC0},
    {0xBFC1, 0xBFC1, 0xBFC1}, {0xBFC2, 0xBFC2, 0xBFC2},
    {0xBFC3, 0xBFC3, 0xBFC3}, {0xBFC4, 0xBFC4, 0xBFC4},
    {0xBFC5, 0xBFC5, 0xBFC5}, {0xBFC6, 0xBFC6, 0xBFC6},
    {0xBFC7, 0xBFC7, 0xBFC7}, {0xBFC8, 0xBFC8, 0xBFC8},
    {0xBFC9, 0xBFC9, 0xBFC9}, {0xBFCA, 0xBFCA, 0xBFCA},
    {0xBFCB, 0xBFCB, 0xBFCB}, {0xBFCC, 0xBFCC, 0xBFCC},
    {0xBFCD, 0xBFCD, 0xBFCD}, {0xBFCE, 0xBFCE, 0xBFCE},
    {0xBFCF, 0xBFCF, 0xBFCF}, {0xBFD0, 0xBFD0, 0xBFD0},
    {0xBFD1, 0xBFD1, 0xBFD1}, {0xBFD2, 0xBFD2, 0xBFD2},
    {0xBFD3, 0xBFD3, 0xBFD3}, {0xBFD4, 0xBFD4, 0xBFD4},
    {0xBFD5, 0xBFD5, 0xBFD5}, {0xBFD6, 0xBFD6, 0xBFD6},
    {0xBFD7, 0xBFD7, 0xBFD7}, {0xBFD8, 0xBFD8, 0xBFD8},
    {0xBFD9, 0xBFD9, 0xBFD9}, {0xBFDA, 0xBFDA, 0xBFDA},
    {0xBFDB, 0xBFDB, 0xBFDB}, {0xBFDC, 0xBFDC, 0xBFDC},
    {0xBFDD, 0xBFDD, 0xBFDD}, {0xBFDE, 0xBFDE, 0xBFDE},
    {0xBFDF, 0xBFDF, 0xBFDF}, {0xBFE0, 0xBFE0, 0xBFE0},
    {0xBFE1, 0xBFE1, 0xBFE1}, {0xBFE2, 0xBFE2, 0xBFE2},
    {0xBFE3, 0xBFE3, 0xBFE3}, {0xBFE4, 0xBFE4, 0xBFE4},
    {0xBFE5, 0xBFE5, 0xBFE5}, {0xBFE6, 0xBFE6, 0xBFE6},
    {0xBFE7, 0xBFE7, 0xBFE7}, {0xBFE8, 0xBFE8, 0xBFE8},
    {0xBFE9, 0xBFE9, 0xBFE9}, {0xBFEA, 0xBFEA, 0xBFEA},
    {0xBFEB, 0xBFEB, 0xBFEB}, {0xBFEC, 0xBFEC, 0xBFEC},
    {0xBFED, 0xBFED, 0xBFED}, {0xBFEE, 0xBFEE, 0xBFEE},
    {0xBFEF, 0xBFEF, 0xBFEF}, {0xBFF0, 0xBFF0, 0xBFF0},
    {0xBFF1, 0xBFF1, 0xBFF1}, {0xBFF2, 0xBFF2, 0xBFF2},
    {0xBFF3, 0xBFF3, 0xBFF3}, {0xBFF4, 0xBFF4, 0xBFF4},
    {0xBFF5, 0xBFF5, 0xBFF5}, {0xBFF6, 0xBFF6, 0xBFF6},
    {0xBFF7, 0xBFF7, 0xBFF7}, {0xBFF8, 0xBFF8, 0xBFF8},
    {0xBFF9, 0xBFF9, 0xBFF9}, {0xBFFA, 0xBFFA, 0xBFFA},
    {0xBFFB, 0xBFFB, 0xBFFB}, {0xBFFC, 0xBFFC, 0xBFFC},
    {0xBFFD, 0xBFFD, 0xBFFD}, {0xBFFE, 0xBFFE, 0xBFFE},
    {0xBFFF, 0xBFFF, 0xBFFF}, {0xC000, 0xC000, 0xC000},
    {0xC001, 0xC001, 0xC001}, {0xC002, 0xC002, 0xC002},
    {0xC003, 0xC003, 0xC003}, {0xC004, 0xC004, 0xC004},
    {0xC005, 0xC005, 0xC005}, {0xC006, 0xC006, 0xC006},
    {0xC007, 0xC007, 0xC007}, {0xC008, 0xC008, 0xC008},
    {0xC009, 0xC009, 0xC009}, {0xC00A, 0xC00A, 0xC00A},
    {0xC00B, 0xC00B, 0xC00B}, {0xC00C, 0xC00C, 0xC00C},
    {0xC00D, 0xC00D, 0xC00D}, {0xC00E, 0xC00E, 0xC00E},
    {0xC00F, 0xC00F, 0xC00F}, {0xC010, 0xC010, 0xC010},
    {0xC011, 0xC011, 0xC011}, {0xC012, 0xC012, 0xC012},
    {0xC013, 0xC013, 0xC013}, {0xC014, 0xC014, 0xC014},
    {0xC015, 0xC015, 0xC015}, {0xC016, 0xC016, 0xC016},
    {0xC017, 0xC017, 0xC017}, {0xC018, 0xC018, 0xC018},
    {0xC019, 0xC019, 0xC019}, {0xC01A, 0xC01A, 0xC01A},
    {0xC01B, 0xC01B, 0xC01B}, {0xC01C, 0xC01C, 0xC01C},
    {0xC01D, 0xC01D, 0xC01D}, {0xC01E, 0xC01E, 0xC01E},
    {0xC01F, 0xC01F, 0xC01F}, {0xC020, 0xC020, 0xC020},
    {0xC021, 0xC021, 0xC021}, {0xC022, 0xC022, 0xC022},
    {0xC023, 0xC023, 0xC023}, {0xC024, 0xC024, 0xC024},
    {0xC025, 0xC025, 0xC025}, {0xC026, 0xC026, 0xC026},
    {0xC027, 0xC027, 0xC027}, {0xC028, 0xC028, 0xC028},
    {0xC029, 0xC029, 0xC029}, {0xC02A, 0xC02A, 0xC02A},
    {0xC02B, 0xC02B, 0xC02B}, {0xC02C, 0xC02C, 0xC02C},
    {0xC02D, 0xC02D, 0xC02D}, {0xC02E, 0xC02E, 0xC02E},
    {0xC02F, 0xC02F, 0xC02F}, {0xC030, 0xC030, 0xC030},
    {0xC031, 0xC031, 0xC031}, {0xC032, 0xC032, 0xC032},
    {0xC033, 0xC033, 0xC033}, {0xC034, 0xC034, 0xC034},
    {0xC035, 0xC035, 0xC035}, {0xC036, 0xC036, 0xC036},
    {0xC037, 0xC037, 0xC037}, {0xC038, 0xC038, 0xC038},
    {0xC039, 0xC039, 0xC039}, {0xC03A, 0xC03A, 0xC03A},
    {0xC03B, 0xC03B, 0xC03B}, {0xC03C, 0xC03C, 0xC03C},
    {0xC03D, 0xC03D, 0xC03D}, {0xC03E, 0xC03E, 0xC03E},
    {0xC03F, 0xC03F, 0xC03F}, {0xC040, 0xC040, 0xC040},
    {0xC041, 0xC041, 0xC041}, {0xC042, 0xC042, 0xC042},
    {0xC043, 0xC043, 0xC043}, {0xC044, 0xC044, 0xC044},
    {0xC045, 0xC045, 0xC045}, {0xC046, 0xC046, 0xC046},
    {0xC047, 0xC047, 0xC047}, {0xC048, 0xC048, 0xC048},
    {0xC049, 0xC049, 0xC049}, {0xC04A, 0xC04A, 0xC04A},
    {0xC04B, 0xC04B, 0xC04B}, {0xC04C, 0xC04C, 0xC04C},
    {0xC04D, 0xC04D, 0xC04D}, {0xC04E, 0xC04E, 0xC04E},
    {0xC04F, 0xC04F, 0xC04F}, {0xC050, 0xC050, 0xC050},
    {0xC051, 0xC051, 0xC051}, {0xC052, 0xC052, 0xC052},
    {0xC053, 0xC053, 0xC053}, {0xC054, 0xC054, 0xC054},
    {0xC055, 0xC055, 0xC055}, {0xC056, 0xC056, 0xC056},
    {0xC057, 0xC057, 0xC057}, {0xC058, 0xC058, 0xC058},
    {0xC059, 0xC059, 0xC059}, {0xC05A, 0xC05A, 0xC05A},
    {0xC05B, 0xC05B, 0xC05B}, {0xC05C, 0xC05C, 0xC05C},
    {0xC05D, 0xC05D, 0xC05D}, {0xC05E, 0xC05E, 0xC05E},
    {0xC05F, 0xC05F, 0xC05F}, {0xC060, 0xC060, 0xC060},
    {0xC061, 0xC061, 0xC061}, {0xC062, 0xC062, 0xC062},
    {0xC063, 0xC063, 0xC063}, {0xC064, 0xC064, 0xC064},
    {0xC065, 0xC065, 0xC065}, {0xC066, 0xC066, 0xC066},
    {0xC067, 0xC067, 0xC067}, {0xC068, 0xC068, 0xC068},
    {0xC069, 0xC069, 0xC069}, {0xC06A, 0xC06A, 0xC06A},
    {0xC06B, 0xC06B, 0xC06B}, {0xC06C, 0xC06C, 0xC06C},
    {0xC06D, 0xC06D, 0xC06D}, {0xC06E, 0xC06E, 0xC06E},
    {0xC06F, 0xC06F, 0xC06F}, {0xC070, 0xC070, 0xC070},
    {0xC071, 0xC071, 0xC071}, {0xC072, 0xC072, 0xC072},
    {0xC073, 0xC073, 0xC073}, {0xC074, 0xC074, 0xC074},
    {0xC075, 0xC075, 0xC075}, {0xC076, 0xC076, 0xC076},
    {0xC077, 0xC077, 0xC077}, {0xC078, 0xC078, 0xC078},
    {0xC079, 0xC079, 0xC079}, {0xC07A, 0xC07A, 0xC07A},
    {0xC07B, 0xC07B, 0xC07B}, {0xC07C, 0xC07C, 0xC07C},
    {0xC07D, 0xC07D, 0xC07D}, {0xC07E, 0xC07E, 0xC07E},
    {0xC07F, 0xC07F, 0xC07F}, {0xC080, 0xC080, 0xC080},
    {0xC081, 0xC081, 0xC081}, {0xC082, 0xC082, 0xC082},
    {0xC083, 0xC083, 0xC083}, {0xC084, 0xC084, 0xC084},
    {0xC085, 0xC085, 0xC085}, {0xC086, 0xC086, 0xC086},
    {0xC087, 0xC087, 0xC087}, {0xC088, 0xC088, 0xC088},
    {0xC089, 0xC089, 0xC089}, {0xC08A, 0xC08A, 0xC08A},
    {0xC08B, 0xC08B, 0xC08B}, {0xC08C, 0xC08C, 0xC08C},
    {0xC08D, 0xC08D, 0xC08D}, {0xC08E, 0xC08E, 0xC08E},
    {0xC08F, 0xC08F, 0xC08F}, {0xC090, 0xC090, 0xC090},
    {0xC091, 0xC091, 0xC091}, {0xC092, 0xC092, 0xC092},
    {0xC093, 0xC093, 0xC093}, {0xC094, 0xC094, 0xC094},
    {0xC095, 0xC095, 0xC095}, {0xC096, 0xC096, 0xC096},
    {0xC097, 0xC097, 0xC097}, {0xC098, 0xC098, 0xC098},
    {0xC099, 0xC099, 0xC099}, {0xC09A, 0xC09A, 0xC09A},
    {0xC09B, 0xC09B, 0xC09B}, {0xC09C, 0xC09C, 0xC09C},
    {0xC09D, 0xC09D, 0xC09D}, {0xC09E, 0xC09E, 0xC09E},
    {0xC09F, 0xC09F, 0xC09F}, {0xC0A0, 0xC0A0, 0xC0A0},
    {0xC0A1, 0xC0A1, 0xC0A1}, {0xC0A2, 0xC0A2, 0xC0A2},
    {0xC0A3, 0xC0A3, 0xC0A3}, {0xC0A4, 0xC0A4, 0xC0A4},
    {0xC0A5, 0xC0A5, 0xC0A5}, {0xC0A6, 0xC0A6, 0xC0A6},
    {0xC0A7, 0xC0A7, 0xC0A7}, {0xC0A8, 0xC0A8, 0xC0A8},
    {0xC0A9, 0xC0A9, 0xC0A9}, {0xC0AA, 0xC0AA, 0xC0AA},
    {0xC0AB, 0xC0AB, 0xC0AB}, {0xC0AC, 0xC0AC, 0xC0AC},
    {0xC0AD, 0xC0AD, 0xC0AD}, {0xC0AE, 0xC0AE, 0xC0AE},
    {0xC0AF, 0xC0AF, 0xC0AF}, {0xC0B0, 0xC0B0, 0xC0B0},
    {0xC0B1, 0xC0B1, 0xC0B1}, {0xC0B2, 0xC0B2, 0xC0B2},
    {0xC0B3, 0xC0B3, 0xC0B3}, {0xC0B4, 0xC0B4, 0xC0B4},
    {0xC0B5, 0xC0B5, 0xC0B5}, {0xC0B6, 0xC0B6, 0xC0B6},
    {0xC0B7, 0xC0B7, 0xC0B7}, {0xC0B8, 0xC0B8, 0xC0B8},
    {0xC0B9, 0xC0B9, 0xC0B9}, {0xC0BA, 0xC0BA, 0xC0BA},
    {0xC0BB, 0xC0BB, 0xC0BB}, {0xC0BC, 0xC0BC, 0xC0BC},
    {0xC0BD, 0xC0BD, 0xC0BD}, {0xC0BE, 0xC0BE, 0xC0BE},
    {0xC0BF, 0xC0BF, 0xC0BF}, {0xC0C0, 0xC0C0, 0xC0C0},
    {0xC0C1, 0xC0C1, 0xC0C1}, {0xC0C2, 0xC0C2, 0xC0C2},
    {0xC0C3, 0xC0C3, 0xC0C3}, {0xC0C4, 0xC0C4, 0xC0C4},
    {0xC0C5, 0xC0C5, 0xC0C5}, {0xC0C6, 0xC0C6, 0xC0C6},
    {0xC0C7, 0xC0C7, 0xC0C7}, {0xC0C8, 0xC0C8, 0xC0C8},
    {0xC0C9, 0xC0C9, 0xC0C9}, {0xC0CA, 0xC0CA, 0xC0CA},
    {0xC0CB, 0xC0CB, 0xC0CB}, {0xC0CC, 0xC0CC, 0xC0CC},
    {0xC0CD, 0xC0CD, 0xC0CD}, {0xC0CE, 0xC0CE, 0xC0CE},
    {0xC0CF, 0xC0CF, 0xC0CF}, {0xC0D0, 0xC0D0, 0xC0D0},
    {0xC0D1, 0xC0D1, 0xC0D1}, {0xC0D2, 0xC0D2, 0xC0D2},
    {0xC0D3, 0xC0D3, 0xC0D3}, {0xC0D4, 0xC0D4, 0xC0D4},
    {0xC0D5, 0xC0D5, 0xC0D5}, {0xC0D6, 0xC0D6, 0xC0D6},
    {0xC0D7, 0xC0D7, 0xC0D7}, {0xC0D8, 0xC0D8, 0xC0D8},
    {0xC0D9, 0xC0D9, 0xC0D9}, {0xC0DA, 0xC0DA, 0xC0DA},
    {0xC0DB, 0xC0DB, 0xC0DB}, {0xC0DC, 0xC0DC, 0xC0DC},
    {0xC0DD, 0xC0DD, 0xC0DD}, {0xC0DE, 0xC0DE, 0xC0DE},
    {0xC0DF, 0xC0DF, 0xC0DF}, {0xC0E0, 0xC0E0, 0xC0E0},
    {0xC0E1, 0xC0E1, 0xC0E1}, {0xC0E2, 0xC0E2, 0xC0E2},
    {0xC0E3, 0xC0E3, 0xC0E3}, {0xC0E4, 0xC0E4, 0xC0E4},
    {0xC0E5, 0xC0E5, 0xC0E5}, {0xC0E6, 0xC0E6, 0xC0E6},
    {0xC0E7, 0xC0E7, 0xC0E7}, {0xC0E8, 0xC0E8, 0xC0E8},
    {0xC0E9, 0xC0E9, 0xC0E9}, {0xC0EA, 0xC0EA, 0xC0EA},
    {0xC0EB, 0xC0EB, 0xC0EB}, {0xC0EC, 0xC0EC, 0xC0EC},
    {0xC0ED, 0xC0ED, 0xC0ED}, {0xC0EE, 0xC0EE, 0xC0EE},
    {0xC0EF, 0xC0EF, 0xC0EF}, {0xC0F0, 0xC0F0, 0xC0F0},
    {0xC0F1, 0xC0F1, 0xC0F1}, {0xC0F2, 0xC0F2, 0xC0F2},
    {0xC0F3, 0xC0F3, 0xC0F3}, {0xC0F4, 0xC0F4, 0xC0F4},
    {0xC0F5, 0xC0F5, 0xC0F5}, {0xC0F6, 0xC0F6, 0xC0F6},
    {0xC0F7, 0xC0F7, 0xC0F7}, {0xC0F8, 0xC0F8, 0xC0F8},
    {0xC0F9, 0xC0F9, 0xC0F9}, {0xC0FA, 0xC0FA, 0xC0FA},
    {0xC0FB, 0xC0FB, 0xC0FB}, {0xC0FC, 0xC0FC, 0xC0FC},
    {0xC0FD, 0xC0FD, 0xC0FD}, {0xC0FE, 0xC0FE, 0xC0FE},
    {0xC0FF, 0xC0FF, 0xC0FF}, {0xC100, 0xC100, 0xC100},
    {0xC101, 0xC101, 0xC101}, {0xC102, 0xC102, 0xC102},
    {0xC103, 0xC103, 0xC103}, {0xC104, 0xC104, 0xC104},
    {0xC105, 0xC105, 0xC105}, {0xC106, 0xC106, 0xC106},
    {0xC107, 0xC107, 0xC107}, {0xC108, 0xC108, 0xC108},
    {0xC109, 0xC109, 0xC109}, {0xC10A, 0xC10A, 0xC10A},
    {0xC10B, 0xC10B, 0xC10B}, {0xC10C, 0xC10C, 0xC10C},
    {0xC10D, 0xC10D, 0xC10D}, {0xC10E, 0xC10E, 0xC10E},
    {0xC10F, 0xC10F, 0xC10F}, {0xC110, 0xC110, 0xC110},
    {0xC111, 0xC111, 0xC111}, {0xC112, 0xC112, 0xC112},
    {0xC113, 0xC113, 0xC113}, {0xC114, 0xC114, 0xC114},
    {0xC115, 0xC115, 0xC115}, {0xC116, 0xC116, 0xC116},
    {0xC117, 0xC117, 0xC117}, {0xC118, 0xC118, 0xC118},
    {0xC119, 0xC119, 0xC119}, {0xC11A, 0xC11A, 0xC11A},
    {0xC11B, 0xC11B, 0xC11B}, {0xC11C, 0xC11C, 0xC11C},
    {0xC11D, 0xC11D, 0xC11D}, {0xC11E, 0xC11E, 0xC11E},
    {0xC11F, 0xC11F, 0xC11F}, {0xC120, 0xC120, 0xC120},
    {0xC121, 0xC121, 0xC121}, {0xC122, 0xC122, 0xC122},
    {0xC123, 0xC123, 0xC123}, {0xC124, 0xC124, 0xC124},
    {0xC125, 0xC125, 0xC125}, {0xC126, 0xC126, 0xC126},
    {0xC127, 0xC127, 0xC127}, {0xC128, 0xC128, 0xC128},
    {0xC129, 0xC129, 0xC129}, {0xC12A, 0xC12A, 0xC12A},
    {0xC12B, 0xC12B, 0xC12B}, {0xC12C, 0xC12C, 0xC12C},
    {0xC12D, 0xC12D, 0xC12D}, {0xC12E, 0xC12E, 0xC12E},
    {0xC12F, 0xC12F, 0xC12F}, {0xC130, 0xC130, 0xC130},
    {0xC131, 0xC131, 0xC131}, {0xC132, 0xC132, 0xC132},
    {0xC133, 0xC133, 0xC133}, {0xC134, 0xC134, 0xC134},
    {0xC135, 0xC135, 0xC135}, {0xC136, 0xC136, 0xC136},
    {0xC137, 0xC137, 0xC137}, {0xC138, 0xC138, 0xC138},
    {0xC139, 0xC139, 0xC139}, {0xC13A, 0xC13A, 0xC13A},
    {0xC13B, 0xC13B, 0xC13B}, {0xC13C, 0xC13C, 0xC13C},
    {0xC13D, 0xC13D, 0xC13D}, {0xC13E, 0xC13E, 0xC13E},
    {0xC13F, 0xC13F, 0xC13F}, {0xC140, 0xC140, 0xC140},
    {0xC141, 0xC141, 0xC141}, {0xC142, 0xC142, 0xC142},
    {0xC143, 0xC143, 0xC143}, {0xC144, 0xC144, 0xC144},
    {0xC145, 0xC145, 0xC145}, {0xC146, 0xC146, 0xC146},
    {0xC147, 0xC147, 0xC147}, {0xC148, 0xC148, 0xC148},
    {0xC149, 0xC149, 0xC149}, {0xC14A, 0xC14A, 0xC14A},
    {0xC14B, 0xC14B, 0xC14B}, {0xC14C, 0xC14C, 0xC14C},
    {0xC14D, 0xC14D, 0xC14D}, {0xC14E, 0xC14E, 0xC14E},
    {0xC14F, 0xC14F, 0xC14F}, {0xC150, 0xC150, 0xC150},
    {0xC151, 0xC151, 0xC151}, {0xC152, 0xC152, 0xC152},
    {0xC153, 0xC153, 0xC153}, {0xC154, 0xC154, 0xC154},
    {0xC155, 0xC155, 0xC155}, {0xC156, 0xC156, 0xC156},
    {0xC157, 0xC157, 0xC157}, {0xC158, 0xC158, 0xC158},
    {0xC159, 0xC159, 0xC159}, {0xC15A, 0xC15A, 0xC15A},
    {0xC15B, 0xC15B, 0xC15B}, {0xC15C, 0xC15C, 0xC15C},
    {0xC15D, 0xC15D, 0xC15D}, {0xC15E, 0xC15E, 0xC15E},
    {0xC15F, 0xC15F, 0xC15F}, {0xC160, 0xC160, 0xC160},
    {0xC161, 0xC161, 0xC161}, {0xC162, 0xC162, 0xC162},
    {0xC163, 0xC163, 0xC163}, {0xC164, 0xC164, 0xC164},
    {0xC165, 0xC165, 0xC165}, {0xC166, 0xC166, 0xC166},
    {0xC167, 0xC167, 0xC167}, {0xC168, 0xC168, 0xC168},
    {0xC169, 0xC169, 0xC169}, {0xC16A, 0xC16A, 0xC16A},
    {0xC16B, 0xC16B, 0xC16B}, {0xC16C, 0xC16C, 0xC16C},
    {0xC16D, 0xC16D, 0xC16D}, {0xC16E, 0xC16E, 0xC16E},
    {0xC16F, 0xC16F, 0xC16F}, {0xC170, 0xC170, 0xC170},
    {0xC171, 0xC171, 0xC171}, {0xC172, 0xC172, 0xC172},
    {0xC173, 0xC173, 0xC173}, {0xC174, 0xC174, 0xC174},
    {0xC175, 0xC175, 0xC175}, {0xC176, 0xC176, 0xC176},
    {0xC177, 0xC177, 0xC177}, {0xC178, 0xC178, 0xC178},
    {0xC179, 0xC179, 0xC179}, {0xC17A, 0xC17A, 0xC17A},
    {0xC17B, 0xC17B, 0xC17B}, {0xC17C, 0xC17C, 0xC17C},
    {0xC17D, 0xC17D, 0xC17D}, {0xC17E, 0xC17E, 0xC17E},
    {0xC17F, 0xC17F, 0xC17F}, {0xC180, 0xC180, 0xC180},
    {0xC181, 0xC181, 0xC181}, {0xC182, 0xC182, 0xC182},
    {0xC183, 0xC183, 0xC183}, {0xC184, 0xC184, 0xC184},
    {0xC185, 0xC185, 0xC185}, {0xC186, 0xC186, 0xC186},
    {0xC187, 0xC187, 0xC187}, {0xC188, 0xC188, 0xC188},
    {0xC189, 0xC189, 0xC189}, {0xC18A, 0xC18A, 0xC18A},
    {0xC18B, 0xC18B, 0xC18B}, {0xC18C, 0xC18C, 0xC18C},
    {0xC18D, 0xC18D, 0xC18D}, {0xC18E, 0xC18E, 0xC18E},
    {0xC18F, 0xC18F, 0xC18F}, {0xC190, 0xC190, 0xC190},
    {0xC191, 0xC191, 0xC191}, {0xC192, 0xC192, 0xC192},
    {0xC193, 0xC193, 0xC193}, {0xC194, 0xC194, 0xC194},
    {0xC195, 0xC195, 0xC195}, {0xC196, 0xC196, 0xC196},
    {0xC197, 0xC197, 0xC197}, {0xC198, 0xC198, 0xC198},
    {0xC199, 0xC199, 0xC199}, {0xC19A, 0xC19A, 0xC19A},
    {0xC19B, 0xC19B, 0xC19B}, {0xC19C, 0xC19C, 0xC19C},
    {0xC19D, 0xC19D, 0xC19D}, {0xC19E, 0xC19E, 0xC19E},
    {0xC19F, 0xC19F, 0xC19F}, {0xC1A0, 0xC1A0, 0xC1A0},
    {0xC1A1, 0xC1A1, 0xC1A1}, {0xC1A2, 0xC1A2, 0xC1A2},
    {0xC1A3, 0xC1A3, 0xC1A3}, {0xC1A4, 0xC1A4, 0xC1A4},
    {0xC1A5, 0xC1A5, 0xC1A5}, {0xC1A6, 0xC1A6, 0xC1A6},
    {0xC1A7, 0xC1A7, 0xC1A7}, {0xC1A8, 0xC1A8, 0xC1A8},
    {0xC1A9, 0xC1A9, 0xC1A9}, {0xC1AA, 0xC1AA, 0xC1AA},
    {0xC1AB, 0xC1AB, 0xC1AB}, {0xC1AC, 0xC1AC, 0xC1AC},
    {0xC1AD, 0xC1AD, 0xC1AD}, {0xC1AE, 0xC1AE, 0xC1AE},
    {0xC1AF, 0xC1AF, 0xC1AF}, {0xC1B0, 0xC1B0, 0xC1B0},
    {0xC1B1, 0xC1B1, 0xC1B1}, {0xC1B2, 0xC1B2, 0xC1B2},
    {0xC1B3, 0xC1B3, 0xC1B3}, {0xC1B4, 0xC1B4, 0xC1B4},
    {0xC1B5, 0xC1B5, 0xC1B5}, {0xC1B6, 0xC1B6, 0xC1B6},
    {0xC1B7, 0xC1B7, 0xC1B7}, {0xC1B8, 0xC1B8, 0xC1B8},
    {0xC1B9, 0xC1B9, 0xC1B9}, {0xC1BA, 0xC1BA, 0xC1BA},
    {0xC1BB, 0xC1BB, 0xC1BB}, {0xC1BC, 0xC1BC, 0xC1BC},
    {0xC1BD, 0xC1BD, 0xC1BD}, {0xC1BE, 0xC1BE, 0xC1BE},
    {0xC1BF, 0xC1BF, 0xC1BF}, {0xC1C0, 0xC1C0, 0xC1C0},
    {0xC1C1, 0xC1C1, 0xC1C1}, {0xC1C2, 0xC1C2, 0xC1C2},
    {0xC1C3, 0xC1C3, 0xC1C3}, {0xC1C4, 0xC1C4, 0xC1C4},
    {0xC1C5, 0xC1C5, 0xC1C5}, {0xC1C6, 0xC1C6, 0xC1C6},
    {0xC1C7, 0xC1C7, 0xC1C7}, {0xC1C8, 0xC1C8, 0xC1C8},
    {0xC1C9, 0xC1C9, 0xC1C9}, {0xC1CA, 0xC1CA, 0xC1CA},
    {0xC1CB, 0xC1CB, 0xC1CB}, {0xC1CC, 0xC1CC, 0xC1CC},
    {0xC1CD, 0xC1CD, 0xC1CD}, {0xC1CE, 0xC1CE, 0xC1CE},
    {0xC1CF, 0xC1CF, 0xC1CF}, {0xC1D0, 0xC1D0, 0xC1D0},
    {0xC1D1, 0xC1D1, 0xC1D1}, {0xC1D2, 0xC1D2, 0xC1D2},
    {0xC1D3, 0xC1D3, 0xC1D3}, {0xC1D4, 0xC1D4, 0xC1D4},
    {0xC1D5, 0xC1D5, 0xC1D5}, {0xC1D6, 0xC1D6, 0xC1D6},
    {0xC1D7, 0xC1D7, 0xC1D7}, {0xC1D8, 0xC1D8, 0xC1D8},
    {0xC1D9, 0xC1D9, 0xC1D9}, {0xC1DA, 0xC1DA, 0xC1DA},
    {0xC1DB, 0xC1DB, 0xC1DB}, {0xC1DC, 0xC1DC, 0xC1DC},
    {0xC1DD, 0xC1DD, 0xC1DD}, {0xC1DE, 0xC1DE, 0xC1DE},
    {0xC1DF, 0xC1DF, 0xC1DF}, {0xC1E0, 0xC1E0, 0xC1E0},
    {0xC1E1, 0xC1E1, 0xC1E1}, {0xC1E2, 0xC1E2, 0xC1E2},
    {0xC1E3, 0xC1E3, 0xC1E3}, {0xC1E4, 0xC1E4, 0xC1E4},
    {0xC1E5, 0xC1E5, 0xC1E5}, {0xC1E6, 0xC1E6, 0xC1E6},
    {0xC1E7, 0xC1E7, 0xC1E7}, {0xC1E8, 0xC1E8, 0xC1E8},
    {0xC1E9, 0xC1E9, 0xC1E9}, {0xC1EA, 0xC1EA, 0xC1EA},
    {0xC1EB, 0xC1EB, 0xC1EB}, {0xC1EC, 0xC1EC, 0xC1EC},
    {0xC1ED, 0xC1ED, 0xC1ED}, {0xC1EE, 0xC1EE, 0xC1EE},
    {0xC1EF, 0xC1EF, 0xC1EF}, {0xC1F0, 0xC1F0, 0xC1F0},
    {0xC1F1, 0xC1F1, 0xC1F1}, {0xC1F2, 0xC1F2, 0xC1F2},
    {0xC1F3, 0xC1F3, 0xC1F3}, {0xC1F4, 0xC1F4, 0xC1F4},
    {0xC1F5, 0xC1F5, 0xC1F5}, {0xC1F6, 0xC1F6, 0xC1F6},
    {0xC1F7, 0xC1F7, 0xC1F7}, {0xC1F8, 0xC1F8, 0xC1F8},
    {0xC1F9, 0xC1F9, 0xC1F9}, {0xC1FA, 0xC1FA, 0xC1FA},
    {0xC1FB, 0xC1FB, 0xC1FB}, {0xC1FC, 0xC1FC, 0xC1FC},
    {0xC1FD, 0xC1FD, 0xC1FD}, {0xC1FE, 0xC1FE, 0xC1FE},
    {0xC1FF, 0xC1FF, 0xC1FF}, {0xC200, 0xC200, 0xC200},
    {0xC201, 0xC201, 0xC201}, {0xC202, 0xC202, 0xC202},
    {0xC203, 0xC203, 0xC203}, {0xC204, 0xC204, 0xC204},
    {0xC205, 0xC205, 0xC205}, {0xC206, 0xC206, 0xC206},
    {0xC207, 0xC207, 0xC207}, {0xC208, 0xC208, 0xC208},
    {0xC209, 0xC209, 0xC209}, {0xC20A, 0xC20A, 0xC20A},
    {0xC20B, 0xC20B, 0xC20B}, {0xC20C, 0xC20C, 0xC20C},
    {0xC20D, 0xC20D, 0xC20D}, {0xC20E, 0xC20E, 0xC20E},
    {0xC20F, 0xC20F, 0xC20F}, {0xC210, 0xC210, 0xC210},
    {0xC211, 0xC211, 0xC211}, {0xC212, 0xC212, 0xC212},
    {0xC213, 0xC213, 0xC213}, {0xC214, 0xC214, 0xC214},
    {0xC215, 0xC215, 0xC215}, {0xC216, 0xC216, 0xC216},
    {0xC217, 0xC217, 0xC217}, {0xC218, 0xC218, 0xC218},
    {0xC219, 0xC219, 0xC219}, {0xC21A, 0xC21A, 0xC21A},
    {0xC21B, 0xC21B, 0xC21B}, {0xC21C, 0xC21C, 0xC21C},
    {0xC21D, 0xC21D, 0xC21D}, {0xC21E, 0xC21E, 0xC21E},
    {0xC21F, 0xC21F, 0xC21F}, {0xC220, 0xC220, 0xC220},
    {0xC221, 0xC221, 0xC221}, {0xC222, 0xC222, 0xC222},
    {0xC223, 0xC223, 0xC223}, {0xC224, 0xC224, 0xC224},
    {0xC225, 0xC225, 0xC225}, {0xC226, 0xC226, 0xC226},
    {0xC227, 0xC227, 0xC227}, {0xC228, 0xC228, 0xC228},
    {0xC229, 0xC229, 0xC229}, {0xC22A, 0xC22A, 0xC22A},
    {0xC22B, 0xC22B, 0xC22B}, {0xC22C, 0xC22C, 0xC22C},
    {0xC22D, 0xC22D, 0xC22D}, {0xC22E, 0xC22E, 0xC22E},
    {0xC22F, 0xC22F, 0xC22F}, {0xC230, 0xC230, 0xC230},
    {0xC231, 0xC231, 0xC231}, {0xC232, 0xC232, 0xC232},
    {0xC233, 0xC233, 0xC233}, {0xC234, 0xC234, 0xC234},
    {0xC235, 0xC235, 0xC235}, {0xC236, 0xC236, 0xC236},
    {0xC237, 0xC237, 0xC237}, {0xC238, 0xC238, 0xC238},
    {0xC239, 0xC239, 0xC239}, {0xC23A, 0xC23A, 0xC23A},
    {0xC23B, 0xC23B, 0xC23B}, {0xC23C, 0xC23C, 0xC23C},
    {0xC23D, 0xC23D, 0xC23D}, {0xC23E, 0xC23E, 0xC23E},
    {0xC23F, 0xC23F, 0xC23F}, {0xC240, 0xC240, 0xC240},
    {0xC241, 0xC241, 0xC241}, {0xC242, 0xC242, 0xC242},
    {0xC243, 0xC243, 0xC243}, {0xC244, 0xC244, 0xC244},
    {0xC245, 0xC245, 0xC245}, {0xC246, 0xC246, 0xC246},
    {0xC247, 0xC247, 0xC247}, {0xC248, 0xC248, 0xC248},
    {0xC249, 0xC249, 0xC249}, {0xC24A, 0xC24A, 0xC24A},
    {0xC24B, 0xC24B, 0xC24B}, {0xC24C, 0xC24C, 0xC24C},
    {0xC24D, 0xC24D, 0xC24D}, {0xC24E, 0xC24E, 0xC24E},
    {0xC24F, 0xC24F, 0xC24F}, {0xC250, 0xC250, 0xC250},
    {0xC251, 0xC251, 0xC251}, {0xC252, 0xC252, 0xC252},
    {0xC253, 0xC253, 0xC253}, {0xC254, 0xC254, 0xC254},
    {0xC255, 0xC255, 0xC255}, {0xC256, 0xC256, 0xC256},
    {0xC257, 0xC257, 0xC257}, {0xC258, 0xC258, 0xC258},
    {0xC259, 0xC259, 0xC259}, {0xC25A, 0xC25A, 0xC25A},
    {0xC25B, 0xC25B, 0xC25B}, {0xC25C, 0xC25C, 0xC25C},
    {0xC25D, 0xC25D, 0xC25D}, {0xC25E, 0xC25E, 0xC25E},
    {0xC25F, 0xC25F, 0xC25F}, {0xC260, 0xC260, 0xC260},
    {0xC261, 0xC261, 0xC261}, {0xC262, 0xC262, 0xC262},
    {0xC263, 0xC263, 0xC263}, {0xC264, 0xC264, 0xC264},
    {0xC265, 0xC265, 0xC265}, {0xC266, 0xC266, 0xC266},
    {0xC267, 0xC267, 0xC267}, {0xC268, 0xC268, 0xC268},
    {0xC269, 0xC269, 0xC269}, {0xC26A, 0xC26A, 0xC26A},
    {0xC26B, 0xC26B, 0xC26B}, {0xC26C, 0xC26C, 0xC26C},
    {0xC26D, 0xC26D, 0xC26D}, {0xC26E, 0xC26E, 0xC26E},
    {0xC26F, 0xC26F, 0xC26F}, {0xC270, 0xC270, 0xC270},
    {0xC271, 0xC271, 0xC271}, {0xC272, 0xC272, 0xC272},
    {0xC273, 0xC273, 0xC273}, {0xC274, 0xC274, 0xC274},
    {0xC275, 0xC275, 0xC275}, {0xC276, 0xC276, 0xC276},
    {0xC277, 0xC277, 0xC277}, {0xC278, 0xC278, 0xC278},
    {0xC279, 0xC279, 0xC279}, {0xC27A, 0xC27A, 0xC27A},
    {0xC27B, 0xC27B, 0xC27B}, {0xC27C, 0xC27C, 0xC27C},
    {0xC27D, 0xC27D, 0xC27D}, {0xC27E, 0xC27E, 0xC27E},
    {0xC27F, 0xC27F, 0xC27F}, {0xC280, 0xC280, 0xC280},
    {0xC281, 0xC281, 0xC281}, {0xC282, 0xC282, 0xC282},
    {0xC283, 0xC283, 0xC283}, {0xC284, 0xC284, 0xC284},
    {0xC285, 0xC285, 0xC285}, {0xC286, 0xC286, 0xC286},
    {0xC287, 0xC287, 0xC287}, {0xC288, 0xC288, 0xC288},
    {0xC289, 0xC289, 0xC289}, {0xC28A, 0xC28A, 0xC28A},
    {0xC28B, 0xC28B, 0xC28B}, {0xC28C, 0xC28C, 0xC28C},
    {0xC28D, 0xC28D, 0xC28D}, {0xC28E, 0xC28E, 0xC28E},
    {0xC28F, 0xC28F, 0xC28F}, {0xC290, 0xC290, 0xC290},
    {0xC291, 0xC291, 0xC291}, {0xC292, 0xC292, 0xC292},
    {0xC293, 0xC293, 0xC293}, {0xC294, 0xC294, 0xC294},
    {0xC295, 0xC295, 0xC295}, {0xC296, 0xC296, 0xC296},
    {0xC297, 0xC297, 0xC297}, {0xC298, 0xC298, 0xC298},
    {0xC299, 0xC299, 0xC299}, {0xC29A, 0xC29A, 0xC29A},
    {0xC29B, 0xC29B, 0xC29B}, {0xC29C, 0xC29C, 0xC29C},
    {0xC29D, 0xC29D, 0xC29D}, {0xC29E, 0xC29E, 0xC29E},
    {0xC29F, 0xC29F, 0xC29F}, {0xC2A0, 0xC2A0, 0xC2A0},
    {0xC2A1, 0xC2A1, 0xC2A1}, {0xC2A2, 0xC2A2, 0xC2A2},
    {0xC2A3, 0xC2A3, 0xC2A3}, {0xC2A4, 0xC2A4, 0xC2A4},
    {0xC2A5, 0xC2A5, 0xC2A5}, {0xC2A6, 0xC2A6, 0xC2A6},
    {0xC2A7, 0xC2A7, 0xC2A7}, {0xC2A8, 0xC2A8, 0xC2A8},
    {0xC2A9, 0xC2A9, 0xC2A9}, {0xC2AA, 0xC2AA, 0xC2AA},
    {0xC2AB, 0xC2AB, 0xC2AB}, {0xC2AC, 0xC2AC, 0xC2AC},
    {0xC2AD, 0xC2AD, 0xC2AD}, {0xC2AE, 0xC2AE, 0xC2AE},
    {0xC2AF, 0xC2AF, 0xC2AF}, {0xC2B0, 0xC2B0, 0xC2B0},
    {0xC2B1, 0xC2B1, 0xC2B1}, {0xC2B2, 0xC2B2, 0xC2B2},
    {0xC2B3, 0xC2B3, 0xC2B3}, {0xC2B4, 0xC2B4, 0xC2B4},
    {0xC2B5, 0xC2B5, 0xC2B5}, {0xC2B6, 0xC2B6, 0xC2B6},
    {0xC2B7, 0xC2B7, 0xC2B7}, {0xC2B8, 0xC2B8, 0xC2B8},
    {0xC2B9, 0xC2B9, 0xC2B9}, {0xC2BA, 0xC2BA, 0xC2BA},
    {0xC2BB, 0xC2BB, 0xC2BB}, {0xC2BC, 0xC2BC, 0xC2BC},
    {0xC2BD, 0xC2BD, 0xC2BD}, {0xC2BE, 0xC2BE, 0xC2BE},
    {0xC2BF, 0xC2BF, 0xC2BF}, {0xC2C0, 0xC2C0, 0xC2C0},
    {0xC2C1, 0xC2C1, 0xC2C1}, {0xC2C2, 0xC2C2, 0xC2C2},
    {0xC2C3, 0xC2C3, 0xC2C3}, {0xC2C4, 0xC2C4, 0xC2C4},
    {0xC2C5, 0xC2C5, 0xC2C5}, {0xC2C6, 0xC2C6, 0xC2C6},
    {0xC2C7, 0xC2C7, 0xC2C7}, {0xC2C8, 0xC2C8, 0xC2C8},
    {0xC2C9, 0xC2C9, 0xC2C9}, {0xC2CA, 0xC2CA, 0xC2CA},
    {0xC2CB, 0xC2CB, 0xC2CB}, {0xC2CC, 0xC2CC, 0xC2CC},
    {0xC2CD, 0xC2CD, 0xC2CD}, {0xC2CE, 0xC2CE, 0xC2CE},
    {0xC2CF, 0xC2CF, 0xC2CF}, {0xC2D0, 0xC2D0, 0xC2D0},
    {0xC2D1, 0xC2D1, 0xC2D1}, {0xC2D2, 0xC2D2, 0xC2D2},
    {0xC2D3, 0xC2D3, 0xC2D3}, {0xC2D4, 0xC2D4, 0xC2D4},
    {0xC2D5, 0xC2D5, 0xC2D5}, {0xC2D6, 0xC2D6, 0xC2D6},
    {0xC2D7, 0xC2D7, 0xC2D7}, {0xC2D8, 0xC2D8, 0xC2D8},
    {0xC2D9, 0xC2D9, 0xC2D9}, {0xC2DA, 0xC2DA, 0xC2DA},
    {0xC2DB, 0xC2DB, 0xC2DB}, {0xC2DC, 0xC2DC, 0xC2DC},
    {0xC2DD, 0xC2DD, 0xC2DD}, {0xC2DE, 0xC2DE, 0xC2DE},
    {0xC2DF, 0xC2DF, 0xC2DF}, {0xC2E0, 0xC2E0, 0xC2E0},
    {0xC2E1, 0xC2E1, 0xC2E1}, {0xC2E2, 0xC2E2, 0xC2E2},
    {0xC2E3, 0xC2E3, 0xC2E3}, {0xC2E4, 0xC2E4, 0xC2E4},
    {0xC2E5, 0xC2E5, 0xC2E5}, {0xC2E6, 0xC2E6, 0xC2E6},
    {0xC2E7, 0xC2E7, 0xC2E7}, {0xC2E8, 0xC2E8, 0xC2E8},
    {0xC2E9, 0xC2E9, 0xC2E9}, {0xC2EA, 0xC2EA, 0xC2EA},
    {0xC2EB, 0xC2EB, 0xC2EB}, {0xC2EC, 0xC2EC, 0xC2EC},
    {0xC2ED, 0xC2ED, 0xC2ED}, {0xC2EE, 0xC2EE, 0xC2EE},
    {0xC2EF, 0xC2EF, 0xC2EF}, {0xC2F0, 0xC2F0, 0xC2F0},
    {0xC2F1, 0xC2F1, 0xC2F1}, {0xC2F2, 0xC2F2, 0xC2F2},
    {0xC2F3, 0xC2F3, 0xC2F3}, {0xC2F4, 0xC2F4, 0xC2F4},
    {0xC2F5, 0xC2F5, 0xC2F5}, {0xC2F6, 0xC2F6, 0xC2F6},
    {0xC2F7, 0xC2F7, 0xC2F7}, {0xC2F8, 0xC2F8, 0xC2F8},
    {0xC2F9, 0xC2F9, 0xC2F9}, {0xC2FA, 0xC2FA, 0xC2FA},
    {0xC2FB, 0xC2FB, 0xC2FB}, {0xC2FC, 0xC2FC, 0xC2FC},
    {0xC2FD, 0xC2FD, 0xC2FD}, {0xC2FE, 0xC2FE, 0xC2FE},
    {0xC2FF, 0xC2FF, 0xC2FF}, {0xC300, 0xC300, 0xC300},
    {0xC301, 0xC301, 0xC301}, {0xC302, 0xC302, 0xC302},
    {0xC303, 0xC303, 0xC303}, {0xC304, 0xC304, 0xC304},
    {0xC305, 0xC305, 0xC305}, {0xC306, 0xC306, 0xC306},
    {0xC307, 0xC307, 0xC307}, {0xC308, 0xC308, 0xC308},
    {0xC309, 0xC309, 0xC309}, {0xC30A, 0xC30A, 0xC30A},
    {0xC30B, 0xC30B, 0xC30B}, {0xC30C, 0xC30C, 0xC30C},
    {0xC30D, 0xC30D, 0xC30D}, {0xC30E, 0xC30E, 0xC30E},
    {0xC30F, 0xC30F, 0xC30F}, {0xC310, 0xC310, 0xC310},
    {0xC311, 0xC311, 0xC311}, {0xC312, 0xC312, 0xC312},
    {0xC313, 0xC313, 0xC313}, {0xC314, 0xC314, 0xC314},
    {0xC315, 0xC315, 0xC315}, {0xC316, 0xC316, 0xC316},
    {0xC317, 0xC317, 0xC317}, {0xC318, 0xC318, 0xC318},
    {0xC319, 0xC319, 0xC319}, {0xC31A, 0xC31A, 0xC31A},
    {0xC31B, 0xC31B, 0xC31B}, {0xC31C, 0xC31C, 0xC31C},
    {0xC31D, 0xC31D, 0xC31D}, {0xC31E, 0xC31E, 0xC31E},
    {0xC31F, 0xC31F, 0xC31F}, {0xC320, 0xC320, 0xC320},
    {0xC321, 0xC321, 0xC321}, {0xC322, 0xC322, 0xC322},
    {0xC323, 0xC323, 0xC323}, {0xC324, 0xC324, 0xC324},
    {0xC325, 0xC325, 0xC325}, {0xC326, 0xC326, 0xC326},
    {0xC327, 0xC327, 0xC327}, {0xC328, 0xC328, 0xC328},
    {0xC329, 0xC329, 0xC329}, {0xC32A, 0xC32A, 0xC32A},
    {0xC32B, 0xC32B, 0xC32B}, {0xC32C, 0xC32C, 0xC32C},
    {0xC32D, 0xC32D, 0xC32D}, {0xC32E, 0xC32E, 0xC32E},
    {0xC32F, 0xC32F, 0xC32F}, {0xC330, 0xC330, 0xC330},
    {0xC331, 0xC331, 0xC331}, {0xC332, 0xC332, 0xC332},
    {0xC333, 0xC333, 0xC333}, {0xC334, 0xC334, 0xC334},
    {0xC335, 0xC335, 0xC335}, {0xC336, 0xC336, 0xC336},
    {0xC337, 0xC337, 0xC337}, {0xC338, 0xC338, 0xC338},
    {0xC339, 0xC339, 0xC339}, {0xC33A, 0xC33A, 0xC33A},
    {0xC33B, 0xC33B, 0xC33B}, {0xC33C, 0xC33C, 0xC33C},
    {0xC33D, 0xC33D, 0xC33D}, {0xC33E, 0xC33E, 0xC33E},
    {0xC33F, 0xC33F, 0xC33F}, {0xC340, 0xC340, 0xC340},
    {0xC341, 0xC341, 0xC341}, {0xC342, 0xC342, 0xC342},
    {0xC343, 0xC343, 0xC343}, {0xC344, 0xC344, 0xC344},
    {0xC345, 0xC345, 0xC345}, {0xC346, 0xC346, 0xC346},
    {0xC347, 0xC347, 0xC347}, {0xC348, 0xC348, 0xC348},
    {0xC349, 0xC349, 0xC349}, {0xC34A, 0xC34A, 0xC34A},
    {0xC34B, 0xC34B, 0xC34B}, {0xC34C, 0xC34C, 0xC34C},
    {0xC34D, 0xC34D, 0xC34D}, {0xC34E, 0xC34E, 0xC34E},
    {0xC34F, 0xC34F, 0xC34F}, {0xC350, 0xC350, 0xC350},
    {0xC351, 0xC351, 0xC351}, {0xC352, 0xC352, 0xC352},
    {0xC353, 0xC353, 0xC353}, {0xC354, 0xC354, 0xC354},
    {0xC355, 0xC355, 0xC355}, {0xC356, 0xC356, 0xC356},
    {0xC357, 0xC357, 0xC357}, {0xC358, 0xC358, 0xC358},
    {0xC359, 0xC359, 0xC359}, {0xC35A, 0xC35A, 0xC35A},
    {0xC35B, 0xC35B, 0xC35B}, {0xC35C, 0xC35C, 0xC35C},
    {0xC35D, 0xC35D, 0xC35D}, {0xC35E, 0xC35E, 0xC35E},
    {0xC35F, 0xC35F, 0xC35F}, {0xC360, 0xC360, 0xC360},
    {0xC361, 0xC361, 0xC361}, {0xC362, 0xC362, 0xC362},
    {0xC363, 0xC363, 0xC363}, {0xC364, 0xC364, 0xC364},
    {0xC365, 0xC365, 0xC365}, {0xC366, 0xC366, 0xC366},
    {0xC367, 0xC367, 0xC367}, {0xC368, 0xC368, 0xC368},
    {0xC369, 0xC369, 0xC369}, {0xC36A, 0xC36A, 0xC36A},
    {0xC36B, 0xC36B, 0xC36B}, {0xC36C, 0xC36C, 0xC36C},
    {0xC36D, 0xC36D, 0xC36D}, {0xC36E, 0xC36E, 0xC36E},
    {0xC36F, 0xC36F, 0xC36F}, {0xC370, 0xC370, 0xC370},
    {0xC371, 0xC371, 0xC371}, {0xC372, 0xC372, 0xC372},
    {0xC373, 0xC373, 0xC373}, {0xC374, 0xC374, 0xC374},
    {0xC375, 0xC375, 0xC375}, {0xC376, 0xC376, 0xC376},
    {0xC377, 0xC377, 0xC377}, {0xC378, 0xC378, 0xC378},
    {0xC379, 0xC379, 0xC379}, {0xC37A, 0xC37A, 0xC37A},
    {0xC37B, 0xC37B, 0xC37B}, {0xC37C, 0xC37C, 0xC37C},
    {0xC37D, 0xC37D, 0xC37D}, {0xC37E, 0xC37E, 0xC37E},
    {0xC37F, 0xC37F, 0xC37F}, {0xC380, 0xC380, 0xC380},
    {0xC381, 0xC381, 0xC381}, {0xC382, 0xC382, 0xC382},
    {0xC383, 0xC383, 0xC383}, {0xC384, 0xC384, 0xC384},
    {0xC385, 0xC385, 0xC385}, {0xC386, 0xC386, 0xC386},
    {0xC387, 0xC387, 0xC387}, {0xC388, 0xC388, 0xC388},
    {0xC389, 0xC389, 0xC389}, {0xC38A, 0xC38A, 0xC38A},
    {0xC38B, 0xC38B, 0xC38B}, {0xC38C, 0xC38C, 0xC38C},
    {0xC38D, 0xC38D, 0xC38D}, {0xC38E, 0xC38E, 0xC38E},
    {0xC38F, 0xC38F, 0xC38F}, {0xC390, 0xC390, 0xC390},
    {0xC391, 0xC391, 0xC391}, {0xC392, 0xC392, 0xC392},
    {0xC393, 0xC393, 0xC393}, {0xC394, 0xC394, 0xC394},
    {0xC395, 0xC395, 0xC395}, {0xC396, 0xC396, 0xC396},
    {0xC397, 0xC397, 0xC397}, {0xC398, 0xC398, 0xC398},
    {0xC399, 0xC399, 0xC399}, {0xC39A, 0xC39A, 0xC39A},
    {0xC39B, 0xC39B, 0xC39B}, {0xC39C, 0xC39C, 0xC39C},
    {0xC39D, 0xC39D, 0xC39D}, {0xC39E, 0xC39E, 0xC39E},
    {0xC39F, 0xC39F, 0xC39F}, {0xC3A0, 0xC3A0, 0xC3A0},
    {0xC3A1, 0xC3A1, 0xC3A1}, {0xC3A2, 0xC3A2, 0xC3A2},
    {0xC3A3, 0xC3A3, 0xC3A3}, {0xC3A4, 0xC3A4, 0xC3A4},
    {0xC3A5, 0xC3A5, 0xC3A5}, {0xC3A6, 0xC3A6, 0xC3A6},
    {0xC3A7, 0xC3A7, 0xC3A7}, {0xC3A8, 0xC3A8, 0xC3A8},
    {0xC3A9, 0xC3A9, 0xC3A9}, {0xC3AA, 0xC3AA, 0xC3AA},
    {0xC3AB, 0xC3AB, 0xC3AB}, {0xC3AC, 0xC3AC, 0xC3AC},
    {0xC3AD, 0xC3AD, 0xC3AD}, {0xC3AE, 0xC3AE, 0xC3AE},
    {0xC3AF, 0xC3AF, 0xC3AF}, {0xC3B0, 0xC3B0, 0xC3B0},
    {0xC3B1, 0xC3B1, 0xC3B1}, {0xC3B2, 0xC3B2, 0xC3B2},
    {0xC3B3, 0xC3B3, 0xC3B3}, {0xC3B4, 0xC3B4, 0xC3B4},
    {0xC3B5, 0xC3B5, 0xC3B5}, {0xC3B6, 0xC3B6, 0xC3B6},
    {0xC3B7, 0xC3B7, 0xC3B7}, {0xC3B8, 0xC3B8, 0xC3B8},
    {0xC3B9, 0xC3B9, 0xC3B9}, {0xC3BA, 0xC3BA, 0xC3BA},
    {0xC3BB, 0xC3BB, 0xC3BB}, {0xC3BC, 0xC3BC, 0xC3BC},
    {0xC3BD, 0xC3BD, 0xC3BD}, {0xC3BE, 0xC3BE, 0xC3BE},
    {0xC3BF, 0xC3BF, 0xC3BF}, {0xC3C0, 0xC3C0, 0xC3C0},
    {0xC3C1, 0xC3C1, 0xC3C1}, {0xC3C2, 0xC3C2, 0xC3C2},
    {0xC3C3, 0xC3C3, 0xC3C3}, {0xC3C4, 0xC3C4, 0xC3C4},
    {0xC3C5, 0xC3C5, 0xC3C5}, {0xC3C6, 0xC3C6, 0xC3C6},
    {0xC3C7, 0xC3C7, 0xC3C7}, {0xC3C8, 0xC3C8, 0xC3C8},
    {0xC3C9, 0xC3C9, 0xC3C9}, {0xC3CA, 0xC3CA, 0xC3CA},
    {0xC3CB, 0xC3CB, 0xC3CB}, {0xC3CC, 0xC3CC, 0xC3CC},
    {0xC3CD, 0xC3CD, 0xC3CD}, {0xC3CE, 0xC3CE, 0xC3CE},
    {0xC3CF, 0xC3CF, 0xC3CF}, {0xC3D0, 0xC3D0, 0xC3D0},
    {0xC3D1, 0xC3D1, 0xC3D1}, {0xC3D2, 0xC3D2, 0xC3D2},
    {0xC3D3, 0xC3D3, 0xC3D3}, {0xC3D4, 0xC3D4, 0xC3D4},
    {0xC3D5, 0xC3D5, 0xC3D5}, {0xC3D6, 0xC3D6, 0xC3D6},
    {0xC3D7, 0xC3D7, 0xC3D7}, {0xC3D8, 0xC3D8, 0xC3D8},
    {0xC3D9, 0xC3D9, 0xC3D9}, {0xC3DA, 0xC3DA, 0xC3DA},
    {0xC3DB, 0xC3DB, 0xC3DB}, {0xC3DC, 0xC3DC, 0xC3DC},
    {0xC3DD, 0xC3DD, 0xC3DD}, {0xC3DE, 0xC3DE, 0xC3DE},
    {0xC3DF, 0xC3DF, 0xC3DF}, {0xC3E0, 0xC3E0, 0xC3E0},
    {0xC3E1, 0xC3E1, 0xC3E1}, {0xC3E2, 0xC3E2, 0xC3E2},
    {0xC3E3, 0xC3E3, 0xC3E3}, {0xC3E4, 0xC3E4, 0xC3E4},
    {0xC3E5, 0xC3E5, 0xC3E5}, {0xC3E6, 0xC3E6, 0xC3E6},
    {0xC3E7, 0xC3E7, 0xC3E7}, {0xC3E8, 0xC3E8, 0xC3E8},
    {0xC3E9, 0xC3E9, 0xC3E9}, {0xC3EA, 0xC3EA, 0xC3EA},
    {0xC3EB, 0xC3EB, 0xC3EB}, {0xC3EC, 0xC3EC, 0xC3EC},
    {0xC3ED, 0xC3ED, 0xC3ED}, {0xC3EE, 0xC3EE, 0xC3EE},
    {0xC3EF, 0xC3EF, 0xC3EF}, {0xC3F0, 0xC3F0, 0xC3F0},
    {0xC3F1, 0xC3F1, 0xC3F1}, {0xC3F2, 0xC3F2, 0xC3F2},
    {0xC3F3, 0xC3F3, 0xC3F3}, {0xC3F4, 0xC3F4, 0xC3F4},
    {0xC3F5, 0xC3F5, 0xC3F5}, {0xC3F6, 0xC3F6, 0xC3F6},
    {0xC3F7, 0xC3F7, 0xC3F7}, {0xC3F8, 0xC3F8, 0xC3F8},
    {0xC3F9, 0xC3F9, 0xC3F9}, {0xC3FA, 0xC3FA, 0xC3FA},
    {0xC3FB, 0xC3FB, 0xC3FB}, {0xC3FC, 0xC3FC, 0xC3FC},
    {0xC3FD, 0xC3FD, 0xC3FD}, {0xC3FE, 0xC3FE, 0xC3FE},
    {0xC3FF, 0xC3FF, 0xC3FF}, {0xC400, 0xC400, 0xC400},
    {0xC401, 0xC401, 0xC401}, {0xC402, 0xC402, 0xC402},
    {0xC403, 0xC403, 0xC403}, {0xC404, 0xC404, 0xC404},
    {0xC405, 0xC405, 0xC405}, {0xC406, 0xC406, 0xC406},
    {0xC407, 0xC407, 0xC407}, {0xC408, 0xC408, 0xC408},
    {0xC409, 0xC409, 0xC409}, {0xC40A, 0xC40A, 0xC40A},
    {0xC40B, 0xC40B, 0xC40B}, {0xC40C, 0xC40C, 0xC40C},
    {0xC40D, 0xC40D, 0xC40D}, {0xC40E, 0xC40E, 0xC40E},
    {0xC40F, 0xC40F, 0xC40F}, {0xC410, 0xC410, 0xC410},
    {0xC411, 0xC411, 0xC411}, {0xC412, 0xC412, 0xC412},
    {0xC413, 0xC413, 0xC413}, {0xC414, 0xC414, 0xC414},
    {0xC415, 0xC415, 0xC415}, {0xC416, 0xC416, 0xC416},
    {0xC417, 0xC417, 0xC417}, {0xC418, 0xC418, 0xC418},
    {0xC419, 0xC419, 0xC419}, {0xC41A, 0xC41A, 0xC41A},
    {0xC41B, 0xC41B, 0xC41B}, {0xC41C, 0xC41C, 0xC41C},
    {0xC41D, 0xC41D, 0xC41D}, {0xC41E, 0xC41E, 0xC41E},
    {0xC41F, 0xC41F, 0xC41F}, {0xC420, 0xC420, 0xC420},
    {0xC421, 0xC421, 0xC421}, {0xC422, 0xC422, 0xC422},
    {0xC423, 0xC423, 0xC423}, {0xC424, 0xC424, 0xC424},
    {0xC425, 0xC425, 0xC425}, {0xC426, 0xC426, 0xC426},
    {0xC427, 0xC427, 0xC427}, {0xC428, 0xC428, 0xC428},
    {0xC429, 0xC429, 0xC429}, {0xC42A, 0xC42A, 0xC42A},
    {0xC42B, 0xC42B, 0xC42B}, {0xC42C, 0xC42C, 0xC42C},
    {0xC42D, 0xC42D, 0xC42D}, {0xC42E, 0xC42E, 0xC42E},
    {0xC42F, 0xC42F, 0xC42F}, {0xC430, 0xC430, 0xC430},
    {0xC431, 0xC431, 0xC431}, {0xC432, 0xC432, 0xC432},
    {0xC433, 0xC433, 0xC433}, {0xC434, 0xC434, 0xC434},
    {0xC435, 0xC435, 0xC435}, {0xC436, 0xC436, 0xC436},
    {0xC437, 0xC437, 0xC437}, {0xC438, 0xC438, 0xC438},
    {0xC439, 0xC439, 0xC439}, {0xC43A, 0xC43A, 0xC43A},
    {0xC43B, 0xC43B, 0xC43B}, {0xC43C, 0xC43C, 0xC43C},
    {0xC43D, 0xC43D, 0xC43D}, {0xC43E, 0xC43E, 0xC43E},
    {0xC43F, 0xC43F, 0xC43F}, {0xC440, 0xC440, 0xC440},
    {0xC441, 0xC441, 0xC441}, {0xC442, 0xC442, 0xC442},
    {0xC443, 0xC443, 0xC443}, {0xC444, 0xC444, 0xC444},
    {0xC445, 0xC445, 0xC445}, {0xC446, 0xC446, 0xC446},
    {0xC447, 0xC447, 0xC447}, {0xC448, 0xC448, 0xC448},
    {0xC449, 0xC449, 0xC449}, {0xC44A, 0xC44A, 0xC44A},
    {0xC44B, 0xC44B, 0xC44B}, {0xC44C, 0xC44C, 0xC44C},
    {0xC44D, 0xC44D, 0xC44D}, {0xC44E, 0xC44E, 0xC44E},
    {0xC44F, 0xC44F, 0xC44F}, {0xC450, 0xC450, 0xC450},
    {0xC451, 0xC451, 0xC451}, {0xC452, 0xC452, 0xC452},
    {0xC453, 0xC453, 0xC453}, {0xC454, 0xC454, 0xC454},
    {0xC455, 0xC455, 0xC455}, {0xC456, 0xC456, 0xC456},
    {0xC457, 0xC457, 0xC457}, {0xC458, 0xC458, 0xC458},
    {0xC459, 0xC459, 0xC459}, {0xC45A, 0xC45A, 0xC45A},
    {0xC45B, 0xC45B, 0xC45B}, {0xC45C, 0xC45C, 0xC45C},
    {0xC45D, 0xC45D, 0xC45D}, {0xC45E, 0xC45E, 0xC45E},
    {0xC45F, 0xC45F, 0xC45F}, {0xC460, 0xC460, 0xC460},
    {0xC461, 0xC461, 0xC461}, {0xC462, 0xC462, 0xC462},
    {0xC463, 0xC463, 0xC463}, {0xC464, 0xC464, 0xC464},
    {0xC465, 0xC465, 0xC465}, {0xC466, 0xC466, 0xC466},
    {0xC467, 0xC467, 0xC467}, {0xC468, 0xC468, 0xC468},
    {0xC469, 0xC469, 0xC469}, {0xC46A, 0xC46A, 0xC46A},
    {0xC46B, 0xC46B, 0xC46B}, {0xC46C, 0xC46C, 0xC46C},
    {0xC46D, 0xC46D, 0xC46D}, {0xC46E, 0xC46E, 0xC46E},
    {0xC46F, 0xC46F, 0xC46F}, {0xC470, 0xC470, 0xC470},
    {0xC471, 0xC471, 0xC471}, {0xC472, 0xC472, 0xC472},
    {0xC473, 0xC473, 0xC473}, {0xC474, 0xC474, 0xC474},
    {0xC475, 0xC475, 0xC475}, {0xC476, 0xC476, 0xC476},
    {0xC477, 0xC477, 0xC477}, {0xC478, 0xC478, 0xC478},
    {0xC479, 0xC479, 0xC479}, {0xC47A, 0xC47A, 0xC47A},
    {0xC47B, 0xC47B, 0xC47B}, {0xC47C, 0xC47C, 0xC47C},
    {0xC47D, 0xC47D, 0xC47D}, {0xC47E, 0xC47E, 0xC47E},
    {0xC47F, 0xC47F, 0xC47F}, {0xC480, 0xC480, 0xC480},
    {0xC481, 0xC481, 0xC481}, {0xC482, 0xC482, 0xC482},
    {0xC483, 0xC483, 0xC483}, {0xC484, 0xC484, 0xC484},
    {0xC485, 0xC485, 0xC485}, {0xC486, 0xC486, 0xC486},
    {0xC487, 0xC487, 0xC487}, {0xC488, 0xC488, 0xC488},
    {0xC489, 0xC489, 0xC489}, {0xC48A, 0xC48A, 0xC48A},
    {0xC48B, 0xC48B, 0xC48B}, {0xC48C, 0xC48C, 0xC48C},
    {0xC48D, 0xC48D, 0xC48D}, {0xC48E, 0xC48E, 0xC48E},
    {0xC48F, 0xC48F, 0xC48F}, {0xC490, 0xC490, 0xC490},
    {0xC491, 0xC491, 0xC491}, {0xC492, 0xC492, 0xC492},
    {0xC493, 0xC493, 0xC493}, {0xC494, 0xC494, 0xC494},
    {0xC495, 0xC495, 0xC495}, {0xC496, 0xC496, 0xC496},
    {0xC497, 0xC497, 0xC497}, {0xC498, 0xC498, 0xC498},
    {0xC499, 0xC499, 0xC499}, {0xC49A, 0xC49A, 0xC49A},
    {0xC49B, 0xC49B, 0xC49B}, {0xC49C, 0xC49C, 0xC49C},
    {0xC49D, 0xC49D, 0xC49D}, {0xC49E, 0xC49E, 0xC49E},
    {0xC49F, 0xC49F, 0xC49F}, {0xC4A0, 0xC4A0, 0xC4A0},
    {0xC4A1, 0xC4A1, 0xC4A1}, {0xC4A2, 0xC4A2, 0xC4A2},
    {0xC4A3, 0xC4A3, 0xC4A3}, {0xC4A4, 0xC4A4, 0xC4A4},
    {0xC4A5, 0xC4A5, 0xC4A5}, {0xC4A6, 0xC4A6, 0xC4A6},
    {0xC4A7, 0xC4A7, 0xC4A7}, {0xC4A8, 0xC4A8, 0xC4A8},
    {0xC4A9, 0xC4A9, 0xC4A9}, {0xC4AA, 0xC4AA, 0xC4AA},
    {0xC4AB, 0xC4AB, 0xC4AB}, {0xC4AC, 0xC4AC, 0xC4AC},
    {0xC4AD, 0xC4AD, 0xC4AD}, {0xC4AE, 0xC4AE, 0xC4AE},
    {0xC4AF, 0xC4AF, 0xC4AF}, {0xC4B0, 0xC4B0, 0xC4B0},
    {0xC4B1, 0xC4B1, 0xC4B1}, {0xC4B2, 0xC4B2, 0xC4B2},
    {0xC4B3, 0xC4B3, 0xC4B3}, {0xC4B4, 0xC4B4, 0xC4B4},
    {0xC4B5, 0xC4B5, 0xC4B5}, {0xC4B6, 0xC4B6, 0xC4B6},
    {0xC4B7, 0xC4B7, 0xC4B7}, {0xC4B8, 0xC4B8, 0xC4B8},
    {0xC4B9, 0xC4B9, 0xC4B9}, {0xC4BA, 0xC4BA, 0xC4BA},
    {0xC4BB, 0xC4BB, 0xC4BB}, {0xC4BC, 0xC4BC, 0xC4BC},
    {0xC4BD, 0xC4BD, 0xC4BD}, {0xC4BE, 0xC4BE, 0xC4BE},
    {0xC4BF, 0xC4BF, 0xC4BF}, {0xC4C0, 0xC4C0, 0xC4C0},
    {0xC4C1, 0xC4C1, 0xC4C1}, {0xC4C2, 0xC4C2, 0xC4C2},
    {0xC4C3, 0xC4C3, 0xC4C3}, {0xC4C4, 0xC4C4, 0xC4C4},
    {0xC4C5, 0xC4C5, 0xC4C5}, {0xC4C6, 0xC4C6, 0xC4C6},
    {0xC4C7, 0xC4C7, 0xC4C7}, {0xC4C8, 0xC4C8, 0xC4C8},
    {0xC4C9, 0xC4C9, 0xC4C9}, {0xC4CA, 0xC4CA, 0xC4CA},
    {0xC4CB, 0xC4CB, 0xC4CB}, {0xC4CC, 0xC4CC, 0xC4CC},
    {0xC4CD, 0xC4CD, 0xC4CD}, {0xC4CE, 0xC4CE, 0xC4CE},
    {0xC4CF, 0xC4CF, 0xC4CF}, {0xC4D0, 0xC4D0, 0xC4D0},
    {0xC4D1, 0xC4D1, 0xC4D1}, {0xC4D2, 0xC4D2, 0xC4D2},
    {0xC4D3, 0xC4D3, 0xC4D3}, {0xC4D4, 0xC4D4, 0xC4D4},
    {0xC4D5, 0xC4D5, 0xC4D5}, {0xC4D6, 0xC4D6, 0xC4D6},
    {0xC4D7, 0xC4D7, 0xC4D7}, {0xC4D8, 0xC4D8, 0xC4D8},
    {0xC4D9, 0xC4D9, 0xC4D9}, {0xC4DA, 0xC4DA, 0xC4DA},
    {0xC4DB, 0xC4DB, 0xC4DB}, {0xC4DC, 0xC4DC, 0xC4DC},
    {0xC4DD, 0xC4DD, 0xC4DD}, {0xC4DE, 0xC4DE, 0xC4DE},
    {0xC4DF, 0xC4DF, 0xC4DF}, {0xC4E0, 0xC4E0, 0xC4E0},
    {0xC4E1, 0xC4E1, 0xC4E1}, {0xC4E2, 0xC4E2, 0xC4E2},
    {0xC4E3, 0xC4E3, 0xC4E3}, {0xC4E4, 0xC4E4, 0xC4E4},
    {0xC4E5, 0xC4E5, 0xC4E5}, {0xC4E6, 0xC4E6, 0xC4E6},
    {0xC4E7, 0xC4E7, 0xC4E7}, {0xC4E8, 0xC4E8, 0xC4E8},
    {0xC4E9, 0xC4E9, 0xC4E9}, {0xC4EA, 0xC4EA, 0xC4EA},
    {0xC4EB, 0xC4EB, 0xC4EB}, {0xC4EC, 0xC4EC, 0xC4EC},
    {0xC4ED, 0xC4ED, 0xC4ED}, {0xC4EE, 0xC4EE, 0xC4EE},
    {0xC4EF, 0xC4EF, 0xC4EF}, {0xC4F0, 0xC4F0, 0xC4F0},
    {0xC4F1, 0xC4F1, 0xC4F1}, {0xC4F2, 0xC4F2, 0xC4F2},
    {0xC4F3, 0xC4F3, 0xC4F3}, {0xC4F4, 0xC4F4, 0xC4F4},
    {0xC4F5, 0xC4F5, 0xC4F5}, {0xC4F6, 0xC4F6, 0xC4F6},
    {0xC4F7, 0xC4F7, 0xC4F7}, {0xC4F8, 0xC4F8, 0xC4F8},
    {0xC4F9, 0xC4F9, 0xC4F9}, {0xC4FA, 0xC4FA, 0xC4FA},
    {0xC4FB, 0xC4FB, 0xC4FB}, {0xC4FC, 0xC4FC, 0xC4FC},
    {0xC4FD, 0xC4FD, 0xC4FD}, {0xC4FE, 0xC4FE, 0xC4FE},
    {0xC4FF, 0xC4FF, 0xC4FF}, {0xC500, 0xC500, 0xC500},
    {0xC501, 0xC501, 0xC501}, {0xC502, 0xC502, 0xC502},
    {0xC503, 0xC503, 0xC503}, {0xC504, 0xC504, 0xC504},
    {0xC505, 0xC505, 0xC505}, {0xC506, 0xC506, 0xC506},
    {0xC507, 0xC507, 0xC507}, {0xC508, 0xC508, 0xC508},
    {0xC509, 0xC509, 0xC509}, {0xC50A, 0xC50A, 0xC50A},
    {0xC50B, 0xC50B, 0xC50B}, {0xC50C, 0xC50C, 0xC50C},
    {0xC50D, 0xC50D, 0xC50D}, {0xC50E, 0xC50E, 0xC50E},
    {0xC50F, 0xC50F, 0xC50F}, {0xC510, 0xC510, 0xC510},
    {0xC511, 0xC511, 0xC511}, {0xC512, 0xC512, 0xC512},
    {0xC513, 0xC513, 0xC513}, {0xC514, 0xC514, 0xC514},
    {0xC515, 0xC515, 0xC515}, {0xC516, 0xC516, 0xC516},
    {0xC517, 0xC517, 0xC517}, {0xC518, 0xC518, 0xC518},
    {0xC519, 0xC519, 0xC519}, {0xC51A, 0xC51A, 0xC51A},
    {0xC51B, 0xC51B, 0xC51B}, {0xC51C, 0xC51C, 0xC51C},
    {0xC51D, 0xC51D, 0xC51D}, {0xC51E, 0xC51E, 0xC51E},
    {0xC51F, 0xC51F, 0xC51F}, {0xC520, 0xC520, 0xC520},
    {0xC521, 0xC521, 0xC521}, {0xC522, 0xC522, 0xC522},
    {0xC523, 0xC523, 0xC523}, {0xC524, 0xC524, 0xC524},
    {0xC525, 0xC525, 0xC525}, {0xC526, 0xC526, 0xC526},
    {0xC527, 0xC527, 0xC527}, {0xC528, 0xC528, 0xC528},
    {0xC529, 0xC529, 0xC529}, {0xC52A, 0xC52A, 0xC52A},
    {0xC52B, 0xC52B, 0xC52B}, {0xC52C, 0xC52C, 0xC52C},
    {0xC52D, 0xC52D, 0xC52D}, {0xC52E, 0xC52E, 0xC52E},
    {0xC52F, 0xC52F, 0xC52F}, {0xC530, 0xC530, 0xC530},
    {0xC531, 0xC531, 0xC531}, {0xC532, 0xC532, 0xC532},
    {0xC533, 0xC533, 0xC533}, {0xC534, 0xC534, 0xC534},
    {0xC535, 0xC535, 0xC535}, {0xC536, 0xC536, 0xC536},
    {0xC537, 0xC537, 0xC537}, {0xC538, 0xC538, 0xC538},
    {0xC539, 0xC539, 0xC539}, {0xC53A, 0xC53A, 0xC53A},
    {0xC53B, 0xC53B, 0xC53B}, {0xC53C, 0xC53C, 0xC53C},
    {0xC53D, 0xC53D, 0xC53D}, {0xC53E, 0xC53E, 0xC53E},
    {0xC53F, 0xC53F, 0xC53F}, {0xC540, 0xC540, 0xC540},
    {0xC541, 0xC541, 0xC541}, {0xC542, 0xC542, 0xC542},
    {0xC543, 0xC543, 0xC543}, {0xC544, 0xC544, 0xC544},
    {0xC545, 0xC545, 0xC545}, {0xC546, 0xC546, 0xC546},
    {0xC547, 0xC547, 0xC547}, {0xC548, 0xC548, 0xC548},
    {0xC549, 0xC549, 0xC549}, {0xC54A, 0xC54A, 0xC54A},
    {0xC54B, 0xC54B, 0xC54B}, {0xC54C, 0xC54C, 0xC54C},
    {0xC54D, 0xC54D, 0xC54D}, {0xC54E, 0xC54E, 0xC54E},
    {0xC54F, 0xC54F, 0xC54F}, {0xC550, 0xC550, 0xC550},
    {0xC551, 0xC551, 0xC551}, {0xC552, 0xC552, 0xC552},
    {0xC553, 0xC553, 0xC553}, {0xC554, 0xC554, 0xC554},
    {0xC555, 0xC555, 0xC555}, {0xC556, 0xC556, 0xC556},
    {0xC557, 0xC557, 0xC557}, {0xC558, 0xC558, 0xC558},
    {0xC559, 0xC559, 0xC559}, {0xC55A, 0xC55A, 0xC55A},
    {0xC55B, 0xC55B, 0xC55B}, {0xC55C, 0xC55C, 0xC55C},
    {0xC55D, 0xC55D, 0xC55D}, {0xC55E, 0xC55E, 0xC55E},
    {0xC55F, 0xC55F, 0xC55F}, {0xC560, 0xC560, 0xC560},
    {0xC561, 0xC561, 0xC561}, {0xC562, 0xC562, 0xC562},
    {0xC563, 0xC563, 0xC563}, {0xC564, 0xC564, 0xC564},
    {0xC565, 0xC565, 0xC565}, {0xC566, 0xC566, 0xC566},
    {0xC567, 0xC567, 0xC567}, {0xC568, 0xC568, 0xC568},
    {0xC569, 0xC569, 0xC569}, {0xC56A, 0xC56A, 0xC56A},
    {0xC56B, 0xC56B, 0xC56B}, {0xC56C, 0xC56C, 0xC56C},
    {0xC56D, 0xC56D, 0xC56D}, {0xC56E, 0xC56E, 0xC56E},
    {0xC56F, 0xC56F, 0xC56F}, {0xC570, 0xC570, 0xC570},
    {0xC571, 0xC571, 0xC571}, {0xC572, 0xC572, 0xC572},
    {0xC573, 0xC573, 0xC573}, {0xC574, 0xC574, 0xC574},
    {0xC575, 0xC575, 0xC575}, {0xC576, 0xC576, 0xC576},
    {0xC577, 0xC577, 0xC577}, {0xC578, 0xC578, 0xC578},
    {0xC579, 0xC579, 0xC579}, {0xC57A, 0xC57A, 0xC57A},
    {0xC57B, 0xC57B, 0xC57B}, {0xC57C, 0xC57C, 0xC57C},
    {0xC57D, 0xC57D, 0xC57D}, {0xC57E, 0xC57E, 0xC57E},
    {0xC57F, 0xC57F, 0xC57F}, {0xC580, 0xC580, 0xC580},
    {0xC581, 0xC581, 0xC581}, {0xC582, 0xC582, 0xC582},
    {0xC583, 0xC583, 0xC583}, {0xC584, 0xC584, 0xC584},
    {0xC585, 0xC585, 0xC585}, {0xC586, 0xC586, 0xC586},
    {0xC587, 0xC587, 0xC587}, {0xC588, 0xC588, 0xC588},
    {0xC589, 0xC589, 0xC589}, {0xC58A, 0xC58A, 0xC58A},
    {0xC58B, 0xC58B, 0xC58B}, {0xC58C, 0xC58C, 0xC58C},
    {0xC58D, 0xC58D, 0xC58D}, {0xC58E, 0xC58E, 0xC58E},
    {0xC58F, 0xC58F, 0xC58F}, {0xC590, 0xC590, 0xC590},
    {0xC591, 0xC591, 0xC591}, {0xC592, 0xC592, 0xC592},
    {0xC593, 0xC593, 0xC593}, {0xC594, 0xC594, 0xC594},
    {0xC595, 0xC595, 0xC595}, {0xC596, 0xC596, 0xC596},
    {0xC597, 0xC597, 0xC597}, {0xC598, 0xC598, 0xC598},
    {0xC599, 0xC599, 0xC599}, {0xC59A, 0xC59A, 0xC59A},
    {0xC59B, 0xC59B, 0xC59B}, {0xC59C, 0xC59C, 0xC59C},
    {0xC59D, 0xC59D, 0xC59D}, {0xC59E, 0xC59E, 0xC59E},
    {0xC59F, 0xC59F, 0xC59F}, {0xC5A0, 0xC5A0, 0xC5A0},
    {0xC5A1, 0xC5A1, 0xC5A1}, {0xC5A2, 0xC5A2, 0xC5A2},
    {0xC5A3, 0xC5A3, 0xC5A3}, {0xC5A4, 0xC5A4, 0xC5A4},
    {0xC5A5, 0xC5A5, 0xC5A5}, {0xC5A6, 0xC5A6, 0xC5A6},
    {0xC5A7, 0xC5A7, 0xC5A7}, {0xC5A8, 0xC5A8, 0xC5A8},
    {0xC5A9, 0xC5A9, 0xC5A9}, {0xC5AA, 0xC5AA, 0xC5AA},
    {0xC5AB, 0xC5AB, 0xC5AB}, {0xC5AC, 0xC5AC, 0xC5AC},
    {0xC5AD, 0xC5AD, 0xC5AD}, {0xC5AE, 0xC5AE, 0xC5AE},
    {0xC5AF, 0xC5AF, 0xC5AF}, {0xC5B0, 0xC5B0, 0xC5B0},
    {0xC5B1, 0xC5B1, 0xC5B1}, {0xC5B2, 0xC5B2, 0xC5B2},
    {0xC5B3, 0xC5B3, 0xC5B3}, {0xC5B4, 0xC5B4, 0xC5B4},
    {0xC5B5, 0xC5B5, 0xC5B5}, {0xC5B6, 0xC5B6, 0xC5B6},
    {0xC5B7, 0xC5B7, 0xC5B7}, {0xC5B8, 0xC5B8, 0xC5B8},
    {0xC5B9, 0xC5B9, 0xC5B9}, {0xC5BA, 0xC5BA, 0xC5BA},
    {0xC5BB, 0xC5BB, 0xC5BB}, {0xC5BC, 0xC5BC, 0xC5BC},
    {0xC5BD, 0xC5BD, 0xC5BD}, {0xC5BE, 0xC5BE, 0xC5BE},
    {0xC5BF, 0xC5BF, 0xC5BF}, {0xC5C0, 0xC5C0, 0xC5C0},
    {0xC5C1, 0xC5C1, 0xC5C1}, {0xC5C2, 0xC5C2, 0xC5C2},
    {0xC5C3, 0xC5C3, 0xC5C3}, {0xC5C4, 0xC5C4, 0xC5C4},
    {0xC5C5, 0xC5C5, 0xC5C5}, {0xC5C6, 0xC5C6, 0xC5C6},
    {0xC5C7, 0xC5C7, 0xC5C7}, {0xC5C8, 0xC5C8, 0xC5C8},
    {0xC5C9, 0xC5C9, 0xC5C9}, {0xC5CA, 0xC5CA, 0xC5CA},
    {0xC5CB, 0xC5CB, 0xC5CB}, {0xC5CC, 0xC5CC, 0xC5CC},
    {0xC5CD, 0xC5CD, 0xC5CD}, {0xC5CE, 0xC5CE, 0xC5CE},
    {0xC5CF, 0xC5CF, 0xC5CF}, {0xC5D0, 0xC5D0, 0xC5D0},
    {0xC5D1, 0xC5D1, 0xC5D1}, {0xC5D2, 0xC5D2, 0xC5D2},
    {0xC5D3, 0xC5D3, 0xC5D3}, {0xC5D4, 0xC5D4, 0xC5D4},
    {0xC5D5, 0xC5D5, 0xC5D5}, {0xC5D6, 0xC5D6, 0xC5D6},
    {0xC5D7, 0xC5D7, 0xC5D7}, {0xC5D8, 0xC5D8, 0xC5D8},
    {0xC5D9, 0xC5D9, 0xC5D9}, {0xC5DA, 0xC5DA, 0xC5DA},
    {0xC5DB, 0xC5DB, 0xC5DB}, {0xC5DC, 0xC5DC, 0xC5DC},
    {0xC5DD, 0xC5DD, 0xC5DD}, {0xC5DE, 0xC5DE, 0xC5DE},
    {0xC5DF, 0xC5DF, 0xC5DF}, {0xC5E0, 0xC5E0, 0xC5E0},
    {0xC5E1, 0xC5E1, 0xC5E1}, {0xC5E2, 0xC5E2, 0xC5E2},
    {0xC5E3, 0xC5E3, 0xC5E3}, {0xC5E4, 0xC5E4, 0xC5E4},
    {0xC5E5, 0xC5E5, 0xC5E5}, {0xC5E6, 0xC5E6, 0xC5E6},
    {0xC5E7, 0xC5E7, 0xC5E7}, {0xC5E8, 0xC5E8, 0xC5E8},
    {0xC5E9, 0xC5E9, 0xC5E9}, {0xC5EA, 0xC5EA, 0xC5EA},
    {0xC5EB, 0xC5EB, 0xC5EB}, {0xC5EC, 0xC5EC, 0xC5EC},
    {0xC5ED, 0xC5ED, 0xC5ED}, {0xC5EE, 0xC5EE, 0xC5EE},
    {0xC5EF, 0xC5EF, 0xC5EF}, {0xC5F0, 0xC5F0, 0xC5F0},
    {0xC5F1, 0xC5F1, 0xC5F1}, {0xC5F2, 0xC5F2, 0xC5F2},
    {0xC5F3, 0xC5F3, 0xC5F3}, {0xC5F4, 0xC5F4, 0xC5F4},
    {0xC5F5, 0xC5F5, 0xC5F5}, {0xC5F6, 0xC5F6, 0xC5F6},
    {0xC5F7, 0xC5F7, 0xC5F7}, {0xC5F8, 0xC5F8, 0xC5F8},
    {0xC5F9, 0xC5F9, 0xC5F9}, {0xC5FA, 0xC5FA, 0xC5FA},
    {0xC5FB, 0xC5FB, 0xC5FB}, {0xC5FC, 0xC5FC, 0xC5FC},
    {0xC5FD, 0xC5FD, 0xC5FD}, {0xC5FE, 0xC5FE, 0xC5FE},
    {0xC5FF, 0xC5FF, 0xC5FF}, {0xC600, 0xC600, 0xC600},
    {0xC601, 0xC601, 0xC601}, {0xC602, 0xC602, 0xC602},
    {0xC603, 0xC603, 0xC603}, {0xC604, 0xC604, 0xC604},
    {0xC605, 0xC605, 0xC605}, {0xC606, 0xC606, 0xC606},
    {0xC607, 0xC607, 0xC607}, {0xC608, 0xC608, 0xC608},
    {0xC609, 0xC609, 0xC609}, {0xC60A, 0xC60A, 0xC60A},
    {0xC60B, 0xC60B, 0xC60B}, {0xC60C, 0xC60C, 0xC60C},
    {0xC60D, 0xC60D, 0xC60D}, {0xC60E, 0xC60E, 0xC60E},
    {0xC60F, 0xC60F, 0xC60F}, {0xC610, 0xC610, 0xC610},
    {0xC611, 0xC611, 0xC611}, {0xC612, 0xC612, 0xC612},
    {0xC613, 0xC613, 0xC613}, {0xC614, 0xC614, 0xC614},
    {0xC615, 0xC615, 0xC615}, {0xC616, 0xC616, 0xC616},
    {0xC617, 0xC617, 0xC617}, {0xC618, 0xC618, 0xC618},
    {0xC619, 0xC619, 0xC619}, {0xC61A, 0xC61A, 0xC61A},
    {0xC61B, 0xC61B, 0xC61B}, {0xC61C, 0xC61C, 0xC61C},
    {0xC61D, 0xC61D, 0xC61D}, {0xC61E, 0xC61E, 0xC61E},
    {0xC61F, 0xC61F, 0xC61F}, {0xC620, 0xC620, 0xC620},
    {0xC621, 0xC621, 0xC621}, {0xC622, 0xC622, 0xC622},
    {0xC623, 0xC623, 0xC623}, {0xC624, 0xC624, 0xC624},
    {0xC625, 0xC625, 0xC625}, {0xC626, 0xC626, 0xC626},
    {0xC627, 0xC627, 0xC627}, {0xC628, 0xC628, 0xC628},
    {0xC629, 0xC629, 0xC629}, {0xC62A, 0xC62A, 0xC62A},
    {0xC62B, 0xC62B, 0xC62B}, {0xC62C, 0xC62C, 0xC62C},
    {0xC62D, 0xC62D, 0xC62D}, {0xC62E, 0xC62E, 0xC62E},
    {0xC62F, 0xC62F, 0xC62F}, {0xC630, 0xC630, 0xC630},
    {0xC631, 0xC631, 0xC631}, {0xC632, 0xC632, 0xC632},
    {0xC633, 0xC633, 0xC633}, {0xC634, 0xC634, 0xC634},
    {0xC635, 0xC635, 0xC635}, {0xC636, 0xC636, 0xC636},
    {0xC637, 0xC637, 0xC637}, {0xC638, 0xC638, 0xC638},
    {0xC639, 0xC639, 0xC639}, {0xC63A, 0xC63A, 0xC63A},
    {0xC63B, 0xC63B, 0xC63B}, {0xC63C, 0xC63C, 0xC63C},
    {0xC63D, 0xC63D, 0xC63D}, {0xC63E, 0xC63E, 0xC63E},
    {0xC63F, 0xC63F, 0xC63F}, {0xC640, 0xC640, 0xC640},
    {0xC641, 0xC641, 0xC641}, {0xC642, 0xC642, 0xC642},
    {0xC643, 0xC643, 0xC643}, {0xC644, 0xC644, 0xC644},
    {0xC645, 0xC645, 0xC645}, {0xC646, 0xC646, 0xC646},
    {0xC647, 0xC647, 0xC647}, {0xC648, 0xC648, 0xC648},
    {0xC649, 0xC649, 0xC649}, {0xC64A, 0xC64A, 0xC64A},
    {0xC64B, 0xC64B, 0xC64B}, {0xC64C, 0xC64C, 0xC64C},
    {0xC64D, 0xC64D, 0xC64D}, {0xC64E, 0xC64E, 0xC64E},
    {0xC64F, 0xC64F, 0xC64F}, {0xC650, 0xC650, 0xC650},
    {0xC651, 0xC651, 0xC651}, {0xC652, 0xC652, 0xC652},
    {0xC653, 0xC653, 0xC653}, {0xC654, 0xC654, 0xC654},
    {0xC655, 0xC655, 0xC655}, {0xC656, 0xC656, 0xC656},
    {0xC657, 0xC657, 0xC657}, {0xC658, 0xC658, 0xC658},
    {0xC659, 0xC659, 0xC659}, {0xC65A, 0xC65A, 0xC65A},
    {0xC65B, 0xC65B, 0xC65B}, {0xC65C, 0xC65C, 0xC65C},
    {0xC65D, 0xC65D, 0xC65D}, {0xC65E, 0xC65E, 0xC65E},
    {0xC65F, 0xC65F, 0xC65F}, {0xC660, 0xC660, 0xC660},
    {0xC661, 0xC661, 0xC661}, {0xC662, 0xC662, 0xC662},
    {0xC663, 0xC663, 0xC663}, {0xC664, 0xC664, 0xC664},
    {0xC665, 0xC665, 0xC665}, {0xC666, 0xC666, 0xC666},
    {0xC667, 0xC667, 0xC667}, {0xC668, 0xC668, 0xC668},
    {0xC669, 0xC669, 0xC669}, {0xC66A, 0xC66A, 0xC66A},
    {0xC66B, 0xC66B, 0xC66B}, {0xC66C, 0xC66C, 0xC66C},
    {0xC66D, 0xC66D, 0xC66D}, {0xC66E, 0xC66E, 0xC66E},
    {0xC66F, 0xC66F, 0xC66F}, {0xC670, 0xC670, 0xC670},
    {0xC671, 0xC671, 0xC671}, {0xC672, 0xC672, 0xC672},
    {0xC673, 0xC673, 0xC673}, {0xC674, 0xC674, 0xC674},
    {0xC675, 0xC675, 0xC675}, {0xC676, 0xC676, 0xC676},
    {0xC677, 0xC677, 0xC677}, {0xC678, 0xC678, 0xC678},
    {0xC679, 0xC679, 0xC679}, {0xC67A, 0xC67A, 0xC67A},
    {0xC67B, 0xC67B, 0xC67B}, {0xC67C, 0xC67C, 0xC67C},
    {0xC67D, 0xC67D, 0xC67D}, {0xC67E, 0xC67E, 0xC67E},
    {0xC67F, 0xC67F, 0xC67F}, {0xC680, 0xC680, 0xC680},
    {0xC681, 0xC681, 0xC681}, {0xC682, 0xC682, 0xC682},
    {0xC683, 0xC683, 0xC683}, {0xC684, 0xC684, 0xC684},
    {0xC685, 0xC685, 0xC685}, {0xC686, 0xC686, 0xC686},
    {0xC687, 0xC687, 0xC687}, {0xC688, 0xC688, 0xC688},
    {0xC689, 0xC689, 0xC689}, {0xC68A, 0xC68A, 0xC68A},
    {0xC68B, 0xC68B, 0xC68B}, {0xC68C, 0xC68C, 0xC68C},
    {0xC68D, 0xC68D, 0xC68D}, {0xC68E, 0xC68E, 0xC68E},
    {0xC68F, 0xC68F, 0xC68F}, {0xC690, 0xC690, 0xC690},
    {0xC691, 0xC691, 0xC691}, {0xC692, 0xC692, 0xC692},
    {0xC693, 0xC693, 0xC693}, {0xC694, 0xC694, 0xC694},
    {0xC695, 0xC695, 0xC695}, {0xC696, 0xC696, 0xC696},
    {0xC697, 0xC697, 0xC697}, {0xC698, 0xC698, 0xC698},
    {0xC699, 0xC699, 0xC699}, {0xC69A, 0xC69A, 0xC69A},
    {0xC69B, 0xC69B, 0xC69B}, {0xC69C, 0xC69C, 0xC69C},
    {0xC69D, 0xC69D, 0xC69D}, {0xC69E, 0xC69E, 0xC69E},
    {0xC69F, 0xC69F, 0xC69F}, {0xC6A0, 0xC6A0, 0xC6A0},
    {0xC6A1, 0xC6A1, 0xC6A1}, {0xC6A2, 0xC6A2, 0xC6A2},
    {0xC6A3, 0xC6A3, 0xC6A3}, {0xC6A4, 0xC6A4, 0xC6A4},
    {0xC6A5, 0xC6A5, 0xC6A5}, {0xC6A6, 0xC6A6, 0xC6A6},
    {0xC6A7, 0xC6A7, 0xC6A7}, {0xC6A8, 0xC6A8, 0xC6A8},
    {0xC6A9, 0xC6A9, 0xC6A9}, {0xC6AA, 0xC6AA, 0xC6AA},
    {0xC6AB, 0xC6AB, 0xC6AB}, {0xC6AC, 0xC6AC, 0xC6AC},
    {0xC6AD, 0xC6AD, 0xC6AD}, {0xC6AE, 0xC6AE, 0xC6AE},
    {0xC6AF, 0xC6AF, 0xC6AF}, {0xC6B0, 0xC6B0, 0xC6B0},
    {0xC6B1, 0xC6B1, 0xC6B1}, {0xC6B2, 0xC6B2, 0xC6B2},
    {0xC6B3, 0xC6B3, 0xC6B3}, {0xC6B4, 0xC6B4, 0xC6B4},
    {0xC6B5, 0xC6B5, 0xC6B5}, {0xC6B6, 0xC6B6, 0xC6B6},
    {0xC6B7, 0xC6B7, 0xC6B7}, {0xC6B8, 0xC6B8, 0xC6B8},
    {0xC6B9, 0xC6B9, 0xC6B9}, {0xC6BA, 0xC6BA, 0xC6BA},
    {0xC6BB, 0xC6BB, 0xC6BB}, {0xC6BC, 0xC6BC, 0xC6BC},
    {0xC6BD, 0xC6BD, 0xC6BD}, {0xC6BE, 0xC6BE, 0xC6BE},
    {0xC6BF, 0xC6BF, 0xC6BF}, {0xC6C0, 0xC6C0, 0xC6C0},
    {0xC6C1, 0xC6C1, 0xC6C1}, {0xC6C2, 0xC6C2, 0xC6C2},
    {0xC6C3, 0xC6C3, 0xC6C3}, {0xC6C4, 0xC6C4, 0xC6C4},
    {0xC6C5, 0xC6C5, 0xC6C5}, {0xC6C6, 0xC6C6, 0xC6C6},
    {0xC6C7, 0xC6C7, 0xC6C7}, {0xC6C8, 0xC6C8, 0xC6C8},
    {0xC6C9, 0xC6C9, 0xC6C9}, {0xC6CA, 0xC6CA, 0xC6CA},
    {0xC6CB, 0xC6CB, 0xC6CB}, {0xC6CC, 0xC6CC, 0xC6CC},
    {0xC6CD, 0xC6CD, 0xC6CD}, {0xC6CE, 0xC6CE, 0xC6CE},
    {0xC6CF, 0xC6CF, 0xC6CF}, {0xC6D0, 0xC6D0, 0xC6D0},
    {0xC6D1, 0xC6D1, 0xC6D1}, {0xC6D2, 0xC6D2, 0xC6D2},
    {0xC6D3, 0xC6D3, 0xC6D3}, {0xC6D4, 0xC6D4, 0xC6D4},
    {0xC6D5, 0xC6D5, 0xC6D5}, {0xC6D6, 0xC6D6, 0xC6D6},
    {0xC6D7, 0xC6D7, 0xC6D7}, {0xC6D8, 0xC6D8, 0xC6D8},
    {0xC6D9, 0xC6D9, 0xC6D9}, {0xC6DA, 0xC6DA, 0xC6DA},
    {0xC6DB, 0xC6DB, 0xC6DB}, {0xC6DC, 0xC6DC, 0xC6DC},
    {0xC6DD, 0xC6DD, 0xC6DD}, {0xC6DE, 0xC6DE, 0xC6DE},
    {0xC6DF, 0xC6DF, 0xC6DF}, {0xC6E0, 0xC6E0, 0xC6E0},
    {0xC6E1, 0xC6E1, 0xC6E1}, {0xC6E2, 0xC6E2, 0xC6E2},
    {0xC6E3, 0xC6E3, 0xC6E3}, {0xC6E4, 0xC6E4, 0xC6E4},
    {0xC6E5, 0xC6E5, 0xC6E5}, {0xC6E6, 0xC6E6, 0xC6E6},
    {0xC6E7, 0xC6E7, 0xC6E7}, {0xC6E8, 0xC6E8, 0xC6E8},
    {0xC6E9, 0xC6E9, 0xC6E9}, {0xC6EA, 0xC6EA, 0xC6EA},
    {0xC6EB, 0xC6EB, 0xC6EB}, {0xC6EC, 0xC6EC, 0xC6EC},
    {0xC6ED, 0xC6ED, 0xC6ED}, {0xC6EE, 0xC6EE, 0xC6EE},
    {0xC6EF, 0xC6EF, 0xC6EF}, {0xC6F0, 0xC6F0, 0xC6F0},
    {0xC6F1, 0xC6F1, 0xC6F1}, {0xC6F2, 0xC6F2, 0xC6F2},
    {0xC6F3, 0xC6F3, 0xC6F3}, {0xC6F4, 0xC6F4, 0xC6F4},
    {0xC6F5, 0xC6F5, 0xC6F5}, {0xC6F6, 0xC6F6, 0xC6F6},
    {0xC6F7, 0xC6F7, 0xC6F7}, {0xC6F8, 0xC6F8, 0xC6F8},
    {0xC6F9, 0xC6F9, 0xC6F9}, {0xC6FA, 0xC6FA, 0xC6FA},
    {0xC6FB, 0xC6FB, 0xC6FB}, {0xC6FC, 0xC6FC, 0xC6FC},
    {0xC6FD, 0xC6FD, 0xC6FD}, {0xC6FE, 0xC6FE, 0xC6FE},
    {0xC6FF, 0xC6FF, 0xC6FF}, {0xC700, 0xC700, 0xC700},
    {0xC701, 0xC701, 0xC701}, {0xC702, 0xC702, 0xC702},
    {0xC703, 0xC703, 0xC703}, {0xC704, 0xC704, 0xC704},
    {0xC705, 0xC705, 0xC705}, {0xC706, 0xC706, 0xC706},
    {0xC707, 0xC707, 0xC707}, {0xC708, 0xC708, 0xC708},
    {0xC709, 0xC709, 0xC709}, {0xC70A, 0xC70A, 0xC70A},
    {0xC70B, 0xC70B, 0xC70B}, {0xC70C, 0xC70C, 0xC70C},
    {0xC70D, 0xC70D, 0xC70D}, {0xC70E, 0xC70E, 0xC70E},
    {0xC70F, 0xC70F, 0xC70F}, {0xC710, 0xC710, 0xC710},
    {0xC711, 0xC711, 0xC711}, {0xC712, 0xC712, 0xC712},
    {0xC713, 0xC713, 0xC713}, {0xC714, 0xC714, 0xC714},
    {0xC715, 0xC715, 0xC715}, {0xC716, 0xC716, 0xC716},
    {0xC717, 0xC717, 0xC717}, {0xC718, 0xC718, 0xC718},
    {0xC719, 0xC719, 0xC719}, {0xC71A, 0xC71A, 0xC71A},
    {0xC71B, 0xC71B, 0xC71B}, {0xC71C, 0xC71C, 0xC71C},
    {0xC71D, 0xC71D, 0xC71D}, {0xC71E, 0xC71E, 0xC71E},
    {0xC71F, 0xC71F, 0xC71F}, {0xC720, 0xC720, 0xC720},
    {0xC721, 0xC721, 0xC721}, {0xC722, 0xC722, 0xC722},
    {0xC723, 0xC723, 0xC723}, {0xC724, 0xC724, 0xC724},
    {0xC725, 0xC725, 0xC725}, {0xC726, 0xC726, 0xC726},
    {0xC727, 0xC727, 0xC727}, {0xC728, 0xC728, 0xC728},
    {0xC729, 0xC729, 0xC729}, {0xC72A, 0xC72A, 0xC72A},
    {0xC72B, 0xC72B, 0xC72B}, {0xC72C, 0xC72C, 0xC72C},
    {0xC72D, 0xC72D, 0xC72D}, {0xC72E, 0xC72E, 0xC72E},
    {0xC72F, 0xC72F, 0xC72F}, {0xC730, 0xC730, 0xC730},
    {0xC731, 0xC731, 0xC731}, {0xC732, 0xC732, 0xC732},
    {0xC733, 0xC733, 0xC733}, {0xC734, 0xC734, 0xC734},
    {0xC735, 0xC735, 0xC735}, {0xC736, 0xC736, 0xC736},
    {0xC737, 0xC737, 0xC737}, {0xC738, 0xC738, 0xC738},
    {0xC739, 0xC739, 0xC739}, {0xC73A, 0xC73A, 0xC73A},
    {0xC73B, 0xC73B, 0xC73B}, {0xC73C, 0xC73C, 0xC73C},
    {0xC73D, 0xC73D, 0xC73D}, {0xC73E, 0xC73E, 0xC73E},
    {0xC73F, 0xC73F, 0xC73F}, {0xC740, 0xC740, 0xC740},
    {0xC741, 0xC741, 0xC741}, {0xC742, 0xC742, 0xC742},
    {0xC743, 0xC743, 0xC743}, {0xC744, 0xC744, 0xC744},
    {0xC745, 0xC745, 0xC745}, {0xC746, 0xC746, 0xC746},
    {0xC747, 0xC747, 0xC747}, {0xC748, 0xC748, 0xC748},
    {0xC749, 0xC749, 0xC749}, {0xC74A, 0xC74A, 0xC74A},
    {0xC74B, 0xC74B, 0xC74B}, {0xC74C, 0xC74C, 0xC74C},
    {0xC74D, 0xC74D, 0xC74D}, {0xC74E, 0xC74E, 0xC74E},
    {0xC74F, 0xC74F, 0xC74F}, {0xC750, 0xC750, 0xC750},
    {0xC751, 0xC751, 0xC751}, {0xC752, 0xC752, 0xC752},
    {0xC753, 0xC753, 0xC753}, {0xC754, 0xC754, 0xC754},
    {0xC755, 0xC755, 0xC755}, {0xC756, 0xC756, 0xC756},
    {0xC757, 0xC757, 0xC757}, {0xC758, 0xC758, 0xC758},
    {0xC759, 0xC759, 0xC759}, {0xC75A, 0xC75A, 0xC75A},
    {0xC75B, 0xC75B, 0xC75B}, {0xC75C, 0xC75C, 0xC75C},
    {0xC75D, 0xC75D, 0xC75D}, {0xC75E, 0xC75E, 0xC75E},
    {0xC75F, 0xC75F, 0xC75F}, {0xC760, 0xC760, 0xC760},
    {0xC761, 0xC761, 0xC761}, {0xC762, 0xC762, 0xC762},
    {0xC763, 0xC763, 0xC763}, {0xC764, 0xC764, 0xC764},
    {0xC765, 0xC765, 0xC765}, {0xC766, 0xC766, 0xC766},
    {0xC767, 0xC767, 0xC767}, {0xC768, 0xC768, 0xC768},
    {0xC769, 0xC769, 0xC769}, {0xC76A, 0xC76A, 0xC76A},
    {0xC76B, 0xC76B, 0xC76B}, {0xC76C, 0xC76C, 0xC76C},
    {0xC76D, 0xC76D, 0xC76D}, {0xC76E, 0xC76E, 0xC76E},
    {0xC76F, 0xC76F, 0xC76F}, {0xC770, 0xC770, 0xC770},
    {0xC771, 0xC771, 0xC771}, {0xC772, 0xC772, 0xC772},
    {0xC773, 0xC773, 0xC773}, {0xC774, 0xC774, 0xC774},
    {0xC775, 0xC775, 0xC775}, {0xC776, 0xC776, 0xC776},
    {0xC777, 0xC777, 0xC777}, {0xC778, 0xC778, 0xC778},
    {0xC779, 0xC779, 0xC779}, {0xC77A, 0xC77A, 0xC77A},
    {0xC77B, 0xC77B, 0xC77B}, {0xC77C, 0xC77C, 0xC77C},
    {0xC77D, 0xC77D, 0xC77D}, {0xC77E, 0xC77E, 0xC77E},
    {0xC77F, 0xC77F, 0xC77F}, {0xC780, 0xC780, 0xC780},
    {0xC781, 0xC781, 0xC781}, {0xC782, 0xC782, 0xC782},
    {0xC783, 0xC783, 0xC783}, {0xC784, 0xC784, 0xC784},
    {0xC785, 0xC785, 0xC785}, {0xC786, 0xC786, 0xC786},
    {0xC787, 0xC787, 0xC787}, {0xC788, 0xC788, 0xC788},
    {0xC789, 0xC789, 0xC789}, {0xC78A, 0xC78A, 0xC78A},
    {0xC78B, 0xC78B, 0xC78B}, {0xC78C, 0xC78C, 0xC78C},
    {0xC78D, 0xC78D, 0xC78D}, {0xC78E, 0xC78E, 0xC78E},
    {0xC78F, 0xC78F, 0xC78F}, {0xC790, 0xC790, 0xC790},
    {0xC791, 0xC791, 0xC791}, {0xC792, 0xC792, 0xC792},
    {0xC793, 0xC793, 0xC793}, {0xC794, 0xC794, 0xC794},
    {0xC795, 0xC795, 0xC795}, {0xC796, 0xC796, 0xC796},
    {0xC797, 0xC797, 0xC797}, {0xC798, 0xC798, 0xC798},
    {0xC799, 0xC799, 0xC799}, {0xC79A, 0xC79A, 0xC79A},
    {0xC79B, 0xC79B, 0xC79B}, {0xC79C, 0xC79C, 0xC79C},
    {0xC79D, 0xC79D, 0xC79D}, {0xC79E, 0xC79E, 0xC79E},
    {0xC79F, 0xC79F, 0xC79F}, {0xC7A0, 0xC7A0, 0xC7A0},
    {0xC7A1, 0xC7A1, 0xC7A1}, {0xC7A2, 0xC7A2, 0xC7A2},
    {0xC7A3, 0xC7A3, 0xC7A3}, {0xC7A4, 0xC7A4, 0xC7A4},
    {0xC7A5, 0xC7A5, 0xC7A5}, {0xC7A6, 0xC7A6, 0xC7A6},
    {0xC7A7, 0xC7A7, 0xC7A7}, {0xC7A8, 0xC7A8, 0xC7A8},
    {0xC7A9, 0xC7A9, 0xC7A9}, {0xC7AA, 0xC7AA, 0xC7AA},
    {0xC7AB, 0xC7AB, 0xC7AB}, {0xC7AC, 0xC7AC, 0xC7AC},
    {0xC7AD, 0xC7AD, 0xC7AD}, {0xC7AE, 0xC7AE, 0xC7AE},
    {0xC7AF, 0xC7AF, 0xC7AF}, {0xC7B0, 0xC7B0, 0xC7B0},
    {0xC7B1, 0xC7B1, 0xC7B1}, {0xC7B2, 0xC7B2, 0xC7B2},
    {0xC7B3, 0xC7B3, 0xC7B3}, {0xC7B4, 0xC7B4, 0xC7B4},
    {0xC7B5, 0xC7B5, 0xC7B5}, {0xC7B6, 0xC7B6, 0xC7B6},
    {0xC7B7, 0xC7B7, 0xC7B7}, {0xC7B8, 0xC7B8, 0xC7B8},
    {0xC7B9, 0xC7B9, 0xC7B9}, {0xC7BA, 0xC7BA, 0xC7BA},
    {0xC7BB, 0xC7BB, 0xC7BB}, {0xC7BC, 0xC7BC, 0xC7BC},
    {0xC7BD, 0xC7BD, 0xC7BD}, {0xC7BE, 0xC7BE, 0xC7BE},
    {0xC7BF, 0xC7BF, 0xC7BF}, {0xC7C0, 0xC7C0, 0xC7C0},
    {0xC7C1, 0xC7C1, 0xC7C1}, {0xC7C2, 0xC7C2, 0xC7C2},
    {0xC7C3, 0xC7C3, 0xC7C3}, {0xC7C4, 0xC7C4, 0xC7C4},
    {0xC7C5, 0xC7C5, 0xC7C5}, {0xC7C6, 0xC7C6, 0xC7C6},
    {0xC7C7, 0xC7C7, 0xC7C7}, {0xC7C8, 0xC7C8, 0xC7C8},
    {0xC7C9, 0xC7C9, 0xC7C9}, {0xC7CA, 0xC7CA, 0xC7CA},
    {0xC7CB, 0xC7CB, 0xC7CB}, {0xC7CC, 0xC7CC, 0xC7CC},
    {0xC7CD, 0xC7CD, 0xC7CD}, {0xC7CE, 0xC7CE, 0xC7CE},
    {0xC7CF, 0xC7CF, 0xC7CF}, {0xC7D0, 0xC7D0, 0xC7D0},
    {0xC7D1, 0xC7D1, 0xC7D1}, {0xC7D2, 0xC7D2, 0xC7D2},
    {0xC7D3, 0xC7D3, 0xC7D3}, {0xC7D4, 0xC7D4, 0xC7D4},
    {0xC7D5, 0xC7D5, 0xC7D5}, {0xC7D6, 0xC7D6, 0xC7D6},
    {0xC7D7, 0xC7D7, 0xC7D7}, {0xC7D8, 0xC7D8, 0xC7D8},
    {0xC7D9, 0xC7D9, 0xC7D9}, {0xC7DA, 0xC7DA, 0xC7DA},
    {0xC7DB, 0xC7DB, 0xC7DB}, {0xC7DC, 0xC7DC, 0xC7DC},
    {0xC7DD, 0xC7DD, 0xC7DD}, {0xC7DE, 0xC7DE, 0xC7DE},
    {0xC7DF, 0xC7DF, 0xC7DF}, {0xC7E0, 0xC7E0, 0xC7E0},
    {0xC7E1, 0xC7E1, 0xC7E1}, {0xC7E2, 0xC7E2, 0xC7E2},
    {0xC7E3, 0xC7E3, 0xC7E3}, {0xC7E4, 0xC7E4, 0xC7E4},
    {0xC7E5, 0xC7E5, 0xC7E5}, {0xC7E6, 0xC7E6, 0xC7E6},
    {0xC7E7, 0xC7E7, 0xC7E7}, {0xC7E8, 0xC7E8, 0xC7E8},
    {0xC7E9, 0xC7E9, 0xC7E9}, {0xC7EA, 0xC7EA, 0xC7EA},
    {0xC7EB, 0xC7EB, 0xC7EB}, {0xC7EC, 0xC7EC, 0xC7EC},
    {0xC7ED, 0xC7ED, 0xC7ED}, {0xC7EE, 0xC7EE, 0xC7EE},
    {0xC7EF, 0xC7EF, 0xC7EF}, {0xC7F0, 0xC7F0, 0xC7F0},
    {0xC7F1, 0xC7F1, 0xC7F1}, {0xC7F2, 0xC7F2, 0xC7F2},
    {0xC7F3, 0xC7F3, 0xC7F3}, {0xC7F4, 0xC7F4, 0xC7F4},
    {0xC7F5, 0xC7F5, 0xC7F5}, {0xC7F6, 0xC7F6, 0xC7F6},
    {0xC7F7, 0xC7F7, 0xC7F7}, {0xC7F8, 0xC7F8, 0xC7F8},
    {0xC7F9, 0xC7F9, 0xC7F9}, {0xC7FA, 0xC7FA, 0xC7FA},
    {0xC7FB, 0xC7FB, 0xC7FB}, {0xC7FC, 0xC7FC, 0xC7FC},
    {0xC7FD, 0xC7FD, 0xC7FD}, {0xC7FE, 0xC7FE, 0xC7FE},
    {0xC7FF, 0xC7FF, 0xC7FF}, {0xC800, 0xC800, 0xC800},
    {0xC801, 0xC801, 0xC801}, {0xC802, 0xC802, 0xC802},
    {0xC803, 0xC803, 0xC803}, {0xC804, 0xC804, 0xC804},
    {0xC805, 0xC805, 0xC805}, {0xC806, 0xC806, 0xC806},
    {0xC807, 0xC807, 0xC807}, {0xC808, 0xC808, 0xC808},
    {0xC809, 0xC809, 0xC809}, {0xC80A, 0xC80A, 0xC80A},
    {0xC80B, 0xC80B, 0xC80B}, {0xC80C, 0xC80C, 0xC80C},
    {0xC80D, 0xC80D, 0xC80D}, {0xC80E, 0xC80E, 0xC80E},
    {0xC80F, 0xC80F, 0xC80F}, {0xC810, 0xC810, 0xC810},
    {0xC811, 0xC811, 0xC811}, {0xC812, 0xC812, 0xC812},
    {0xC813, 0xC813, 0xC813}, {0xC814, 0xC814, 0xC814},
    {0xC815, 0xC815, 0xC815}, {0xC816, 0xC816, 0xC816},
    {0xC817, 0xC817, 0xC817}, {0xC818, 0xC818, 0xC818},
    {0xC819, 0xC819, 0xC819}, {0xC81A, 0xC81A, 0xC81A},
    {0xC81B, 0xC81B, 0xC81B}, {0xC81C, 0xC81C, 0xC81C},
    {0xC81D, 0xC81D, 0xC81D}, {0xC81E, 0xC81E, 0xC81E},
    {0xC81F, 0xC81F, 0xC81F}, {0xC820, 0xC820, 0xC820},
    {0xC821, 0xC821, 0xC821}, {0xC822, 0xC822, 0xC822},
    {0xC823, 0xC823, 0xC823}, {0xC824, 0xC824, 0xC824},
    {0xC825, 0xC825, 0xC825}, {0xC826, 0xC826, 0xC826},
    {0xC827, 0xC827, 0xC827}, {0xC828, 0xC828, 0xC828},
    {0xC829, 0xC829, 0xC829}, {0xC82A, 0xC82A, 0xC82A},
    {0xC82B, 0xC82B, 0xC82B}, {0xC82C, 0xC82C, 0xC82C},
    {0xC82D, 0xC82D, 0xC82D}, {0xC82E, 0xC82E, 0xC82E},
    {0xC82F, 0xC82F, 0xC82F}, {0xC830, 0xC830, 0xC830},
    {0xC831, 0xC831, 0xC831}, {0xC832, 0xC832, 0xC832},
    {0xC833, 0xC833, 0xC833}, {0xC834, 0xC834, 0xC834},
    {0xC835, 0xC835, 0xC835}, {0xC836, 0xC836, 0xC836},
    {0xC837, 0xC837, 0xC837}, {0xC838, 0xC838, 0xC838},
    {0xC839, 0xC839, 0xC839}, {0xC83A, 0xC83A, 0xC83A},
    {0xC83B, 0xC83B, 0xC83B}, {0xC83C, 0xC83C, 0xC83C},
    {0xC83D, 0xC83D, 0xC83D}, {0xC83E, 0xC83E, 0xC83E},
    {0xC83F, 0xC83F, 0xC83F}, {0xC840, 0xC840, 0xC840},
    {0xC841, 0xC841, 0xC841}, {0xC842, 0xC842, 0xC842},
    {0xC843, 0xC843, 0xC843}, {0xC844, 0xC844, 0xC844},
    {0xC845, 0xC845, 0xC845}, {0xC846, 0xC846, 0xC846},
    {0xC847, 0xC847, 0xC847}, {0xC848, 0xC848, 0xC848},
    {0xC849, 0xC849, 0xC849}, {0xC84A, 0xC84A, 0xC84A},
    {0xC84B, 0xC84B, 0xC84B}, {0xC84C, 0xC84C, 0xC84C},
    {0xC84D, 0xC84D, 0xC84D}, {0xC84E, 0xC84E, 0xC84E},
    {0xC84F, 0xC84F, 0xC84F}, {0xC850, 0xC850, 0xC850},
    {0xC851, 0xC851, 0xC851}, {0xC852, 0xC852, 0xC852},
    {0xC853, 0xC853, 0xC853}, {0xC854, 0xC854, 0xC854},
    {0xC855, 0xC855, 0xC855}, {0xC856, 0xC856, 0xC856},
    {0xC857, 0xC857, 0xC857}, {0xC858, 0xC858, 0xC858},
    {0xC859, 0xC859, 0xC859}, {0xC85A, 0xC85A, 0xC85A},
    {0xC85B, 0xC85B, 0xC85B}, {0xC85C, 0xC85C, 0xC85C},
    {0xC85D, 0xC85D, 0xC85D}, {0xC85E, 0xC85E, 0xC85E},
    {0xC85F, 0xC85F, 0xC85F}, {0xC860, 0xC860, 0xC860},
    {0xC861, 0xC861, 0xC861}, {0xC862, 0xC862, 0xC862},
    {0xC863, 0xC863, 0xC863}, {0xC864, 0xC864, 0xC864},
    {0xC865, 0xC865, 0xC865}, {0xC866, 0xC866, 0xC866},
    {0xC867, 0xC867, 0xC867}, {0xC868, 0xC868, 0xC868},
    {0xC869, 0xC869, 0xC869}, {0xC86A, 0xC86A, 0xC86A},
    {0xC86B, 0xC86B, 0xC86B}, {0xC86C, 0xC86C, 0xC86C},
    {0xC86D, 0xC86D, 0xC86D}, {0xC86E, 0xC86E, 0xC86E},
    {0xC86F, 0xC86F, 0xC86F}, {0xC870, 0xC870, 0xC870},
    {0xC871, 0xC871, 0xC871}, {0xC872, 0xC872, 0xC872},
    {0xC873, 0xC873, 0xC873}, {0xC874, 0xC874, 0xC874},
    {0xC875, 0xC875, 0xC875}, {0xC876, 0xC876, 0xC876},
    {0xC877, 0xC877, 0xC877}, {0xC878, 0xC878, 0xC878},
    {0xC879, 0xC879, 0xC879}, {0xC87A, 0xC87A, 0xC87A},
    {0xC87B, 0xC87B, 0xC87B}, {0xC87C, 0xC87C, 0xC87C},
    {0xC87D, 0xC87D, 0xC87D}, {0xC87E, 0xC87E, 0xC87E},
    {0xC87F, 0xC87F, 0xC87F}, {0xC880, 0xC880, 0xC880},
    {0xC881, 0xC881, 0xC881}, {0xC882, 0xC882, 0xC882},
    {0xC883, 0xC883, 0xC883}, {0xC884, 0xC884, 0xC884},
    {0xC885, 0xC885, 0xC885}, {0xC886, 0xC886, 0xC886},
    {0xC887, 0xC887, 0xC887}, {0xC888, 0xC888, 0xC888},
    {0xC889, 0xC889, 0xC889}, {0xC88A, 0xC88A, 0xC88A},
    {0xC88B, 0xC88B, 0xC88B}, {0xC88C, 0xC88C, 0xC88C},
    {0xC88D, 0xC88D, 0xC88D}, {0xC88E, 0xC88E, 0xC88E},
    {0xC88F, 0xC88F, 0xC88F}, {0xC890, 0xC890, 0xC890},
    {0xC891, 0xC891, 0xC891}, {0xC892, 0xC892, 0xC892},
    {0xC893, 0xC893, 0xC893}, {0xC894, 0xC894, 0xC894},
    {0xC895, 0xC895, 0xC895}, {0xC896, 0xC896, 0xC896},
    {0xC897, 0xC897, 0xC897}, {0xC898, 0xC898, 0xC898},
    {0xC899, 0xC899, 0xC899}, {0xC89A, 0xC89A, 0xC89A},
    {0xC89B, 0xC89B, 0xC89B}, {0xC89C, 0xC89C, 0xC89C},
    {0xC89D, 0xC89D, 0xC89D}, {0xC89E, 0xC89E, 0xC89E},
    {0xC89F, 0xC89F, 0xC89F}, {0xC8A0, 0xC8A0, 0xC8A0},
    {0xC8A1, 0xC8A1, 0xC8A1}, {0xC8A2, 0xC8A2, 0xC8A2},
    {0xC8A3, 0xC8A3, 0xC8A3}, {0xC8A4, 0xC8A4, 0xC8A4},
    {0xC8A5, 0xC8A5, 0xC8A5}, {0xC8A6, 0xC8A6, 0xC8A6},
    {0xC8A7, 0xC8A7, 0xC8A7}, {0xC8A8, 0xC8A8, 0xC8A8},
    {0xC8A9, 0xC8A9, 0xC8A9}, {0xC8AA, 0xC8AA, 0xC8AA},
    {0xC8AB, 0xC8AB, 0xC8AB}, {0xC8AC, 0xC8AC, 0xC8AC},
    {0xC8AD, 0xC8AD, 0xC8AD}, {0xC8AE, 0xC8AE, 0xC8AE},
    {0xC8AF, 0xC8AF, 0xC8AF}, {0xC8B0, 0xC8B0, 0xC8B0},
    {0xC8B1, 0xC8B1, 0xC8B1}, {0xC8B2, 0xC8B2, 0xC8B2},
    {0xC8B3, 0xC8B3, 0xC8B3}, {0xC8B4, 0xC8B4, 0xC8B4},
    {0xC8B5, 0xC8B5, 0xC8B5}, {0xC8B6, 0xC8B6, 0xC8B6},
    {0xC8B7, 0xC8B7, 0xC8B7}, {0xC8B8, 0xC8B8, 0xC8B8},
    {0xC8B9, 0xC8B9, 0xC8B9}, {0xC8BA, 0xC8BA, 0xC8BA},
    {0xC8BB, 0xC8BB, 0xC8BB}, {0xC8BC, 0xC8BC, 0xC8BC},
    {0xC8BD, 0xC8BD, 0xC8BD}, {0xC8BE, 0xC8BE, 0xC8BE},
    {0xC8BF, 0xC8BF, 0xC8BF}, {0xC8C0, 0xC8C0, 0xC8C0},
    {0xC8C1, 0xC8C1, 0xC8C1}, {0xC8C2, 0xC8C2, 0xC8C2},
    {0xC8C3, 0xC8C3, 0xC8C3}, {0xC8C4, 0xC8C4, 0xC8C4},
    {0xC8C5, 0xC8C5, 0xC8C5}, {0xC8C6, 0xC8C6, 0xC8C6},
    {0xC8C7, 0xC8C7, 0xC8C7}, {0xC8C8, 0xC8C8, 0xC8C8},
    {0xC8C9, 0xC8C9, 0xC8C9}, {0xC8CA, 0xC8CA, 0xC8CA},
    {0xC8CB, 0xC8CB, 0xC8CB}, {0xC8CC, 0xC8CC, 0xC8CC},
    {0xC8CD, 0xC8CD, 0xC8CD}, {0xC8CE, 0xC8CE, 0xC8CE},
    {0xC8CF, 0xC8CF, 0xC8CF}, {0xC8D0, 0xC8D0, 0xC8D0},
    {0xC8D1, 0xC8D1, 0xC8D1}, {0xC8D2, 0xC8D2, 0xC8D2},
    {0xC8D3, 0xC8D3, 0xC8D3}, {0xC8D4, 0xC8D4, 0xC8D4},
    {0xC8D5, 0xC8D5, 0xC8D5}, {0xC8D6, 0xC8D6, 0xC8D6},
    {0xC8D7, 0xC8D7, 0xC8D7}, {0xC8D8, 0xC8D8, 0xC8D8},
    {0xC8D9, 0xC8D9, 0xC8D9}, {0xC8DA, 0xC8DA, 0xC8DA},
    {0xC8DB, 0xC8DB, 0xC8DB}, {0xC8DC, 0xC8DC, 0xC8DC},
    {0xC8DD, 0xC8DD, 0xC8DD}, {0xC8DE, 0xC8DE, 0xC8DE},
    {0xC8DF, 0xC8DF, 0xC8DF}, {0xC8E0, 0xC8E0, 0xC8E0},
    {0xC8E1, 0xC8E1, 0xC8E1}, {0xC8E2, 0xC8E2, 0xC8E2},
    {0xC8E3, 0xC8E3, 0xC8E3}, {0xC8E4, 0xC8E4, 0xC8E4},
    {0xC8E5, 0xC8E5, 0xC8E5}, {0xC8E6, 0xC8E6, 0xC8E6},
    {0xC8E7, 0xC8E7, 0xC8E7}, {0xC8E8, 0xC8E8, 0xC8E8},
    {0xC8E9, 0xC8E9, 0xC8E9}, {0xC8EA, 0xC8EA, 0xC8EA},
    {0xC8EB, 0xC8EB, 0xC8EB}, {0xC8EC, 0xC8EC, 0xC8EC},
    {0xC8ED, 0xC8ED, 0xC8ED}, {0xC8EE, 0xC8EE, 0xC8EE},
    {0xC8EF, 0xC8EF, 0xC8EF}, {0xC8F0, 0xC8F0, 0xC8F0},
    {0xC8F1, 0xC8F1, 0xC8F1}, {0xC8F2, 0xC8F2, 0xC8F2},
    {0xC8F3, 0xC8F3, 0xC8F3}, {0xC8F4, 0xC8F4, 0xC8F4},
    {0xC8F5, 0xC8F5, 0xC8F5}, {0xC8F6, 0xC8F6, 0xC8F6},
    {0xC8F7, 0xC8F7, 0xC8F7}, {0xC8F8, 0xC8F8, 0xC8F8},
    {0xC8F9, 0xC8F9, 0xC8F9}, {0xC8FA, 0xC8FA, 0xC8FA},
    {0xC8FB, 0xC8FB, 0xC8FB}, {0xC8FC, 0xC8FC, 0xC8FC},
    {0xC8FD, 0xC8FD, 0xC8FD}, {0xC8FE, 0xC8FE, 0xC8FE},
    {0xC8FF, 0xC8FF, 0xC8FF}, {0xC900, 0xC900, 0xC900},
    {0xC901, 0xC901, 0xC901}, {0xC902, 0xC902, 0xC902},
    {0xC903, 0xC903, 0xC903}, {0xC904, 0xC904, 0xC904},
    {0xC905, 0xC905, 0xC905}, {0xC906, 0xC906, 0xC906},
    {0xC907, 0xC907, 0xC907}, {0xC908, 0xC908, 0xC908},
    {0xC909, 0xC909, 0xC909}, {0xC90A, 0xC90A, 0xC90A},
    {0xC90B, 0xC90B, 0xC90B}, {0xC90C, 0xC90C, 0xC90C},
    {0xC90D, 0xC90D, 0xC90D}, {0xC90E, 0xC90E, 0xC90E},
    {0xC90F, 0xC90F, 0xC90F}, {0xC910, 0xC910, 0xC910},
    {0xC911, 0xC911, 0xC911}, {0xC912, 0xC912, 0xC912},
    {0xC913, 0xC913, 0xC913}, {0xC914, 0xC914, 0xC914},
    {0xC915, 0xC915, 0xC915}, {0xC916, 0xC916, 0xC916},
    {0xC917, 0xC917, 0xC917}, {0xC918, 0xC918, 0xC918},
    {0xC919, 0xC919, 0xC919}, {0xC91A, 0xC91A, 0xC91A},
    {0xC91B, 0xC91B, 0xC91B}, {0xC91C, 0xC91C, 0xC91C},
    {0xC91D, 0xC91D, 0xC91D}, {0xC91E, 0xC91E, 0xC91E},
    {0xC91F, 0xC91F, 0xC91F}, {0xC920, 0xC920, 0xC920},
    {0xC921, 0xC921, 0xC921}, {0xC922, 0xC922, 0xC922},
    {0xC923, 0xC923, 0xC923}, {0xC924, 0xC924, 0xC924},
    {0xC925, 0xC925, 0xC925}, {0xC926, 0xC926, 0xC926},
    {0xC927, 0xC927, 0xC927}, {0xC928, 0xC928, 0xC928},
    {0xC929, 0xC929, 0xC929}, {0xC92A, 0xC92A, 0xC92A},
    {0xC92B, 0xC92B, 0xC92B}, {0xC92C, 0xC92C, 0xC92C},
    {0xC92D, 0xC92D, 0xC92D}, {0xC92E, 0xC92E, 0xC92E},
    {0xC92F, 0xC92F, 0xC92F}, {0xC930, 0xC930, 0xC930},
    {0xC931, 0xC931, 0xC931}, {0xC932, 0xC932, 0xC932},
    {0xC933, 0xC933, 0xC933}, {0xC934, 0xC934, 0xC934},
    {0xC935, 0xC935, 0xC935}, {0xC936, 0xC936, 0xC936},
    {0xC937, 0xC937, 0xC937}, {0xC938, 0xC938, 0xC938},
    {0xC939, 0xC939, 0xC939}, {0xC93A, 0xC93A, 0xC93A},
    {0xC93B, 0xC93B, 0xC93B}, {0xC93C, 0xC93C, 0xC93C},
    {0xC93D, 0xC93D, 0xC93D}, {0xC93E, 0xC93E, 0xC93E},
    {0xC93F, 0xC93F, 0xC93F}, {0xC940, 0xC940, 0xC940},
    {0xC941, 0xC941, 0xC941}, {0xC942, 0xC942, 0xC942},
    {0xC943, 0xC943, 0xC943}, {0xC944, 0xC944, 0xC944},
    {0xC945, 0xC945, 0xC945}, {0xC946, 0xC946, 0xC946},
    {0xC947, 0xC947, 0xC947}, {0xC948, 0xC948, 0xC948},
    {0xC949, 0xC949, 0xC949}, {0xC94A, 0xC94A, 0xC94A},
    {0xC94B, 0xC94B, 0xC94B}, {0xC94C, 0xC94C, 0xC94C},
    {0xC94D, 0xC94D, 0xC94D}, {0xC94E, 0xC94E, 0xC94E},
    {0xC94F, 0xC94F, 0xC94F}, {0xC950, 0xC950, 0xC950},
    {0xC951, 0xC951, 0xC951}, {0xC952, 0xC952, 0xC952},
    {0xC953, 0xC953, 0xC953}, {0xC954, 0xC954, 0xC954},
    {0xC955, 0xC955, 0xC955}, {0xC956, 0xC956, 0xC956},
    {0xC957, 0xC957, 0xC957}, {0xC958, 0xC958, 0xC958},
    {0xC959, 0xC959, 0xC959}, {0xC95A, 0xC95A, 0xC95A},
    {0xC95B, 0xC95B, 0xC95B}, {0xC95C, 0xC95C, 0xC95C},
    {0xC95D, 0xC95D, 0xC95D}, {0xC95E, 0xC95E, 0xC95E},
    {0xC95F, 0xC95F, 0xC95F}, {0xC960, 0xC960, 0xC960},
    {0xC961, 0xC961, 0xC961}, {0xC962, 0xC962, 0xC962},
    {0xC963, 0xC963, 0xC963}, {0xC964, 0xC964, 0xC964},
    {0xC965, 0xC965, 0xC965}, {0xC966, 0xC966, 0xC966},
    {0xC967, 0xC967, 0xC967}, {0xC968, 0xC968, 0xC968},
    {0xC969, 0xC969, 0xC969}, {0xC96A, 0xC96A, 0xC96A},
    {0xC96B, 0xC96B, 0xC96B}, {0xC96C, 0xC96C, 0xC96C},
    {0xC96D, 0xC96D, 0xC96D}, {0xC96E, 0xC96E, 0xC96E},
    {0xC96F, 0xC96F, 0xC96F}, {0xC970, 0xC970, 0xC970},
    {0xC971, 0xC971, 0xC971}, {0xC972, 0xC972, 0xC972},
    {0xC973, 0xC973, 0xC973}, {0xC974, 0xC974, 0xC974},
    {0xC975, 0xC975, 0xC975}, {0xC976, 0xC976, 0xC976},
    {0xC977, 0xC977, 0xC977}, {0xC978, 0xC978, 0xC978},
    {0xC979, 0xC979, 0xC979}, {0xC97A, 0xC97A, 0xC97A},
    {0xC97B, 0xC97B, 0xC97B}, {0xC97C, 0xC97C, 0xC97C},
    {0xC97D, 0xC97D, 0xC97D}, {0xC97E, 0xC97E, 0xC97E},
    {0xC97F, 0xC97F, 0xC97F}, {0xC980, 0xC980, 0xC980},
    {0xC981, 0xC981, 0xC981}, {0xC982, 0xC982, 0xC982},
    {0xC983, 0xC983, 0xC983}, {0xC984, 0xC984, 0xC984},
    {0xC985, 0xC985, 0xC985}, {0xC986, 0xC986, 0xC986},
    {0xC987, 0xC987, 0xC987}, {0xC988, 0xC988, 0xC988},
    {0xC989, 0xC989, 0xC989}, {0xC98A, 0xC98A, 0xC98A},
    {0xC98B, 0xC98B, 0xC98B}, {0xC98C, 0xC98C, 0xC98C},
    {0xC98D, 0xC98D, 0xC98D}, {0xC98E, 0xC98E, 0xC98E},
    {0xC98F, 0xC98F, 0xC98F}, {0xC990, 0xC990, 0xC990},
    {0xC991, 0xC991, 0xC991}, {0xC992, 0xC992, 0xC992},
    {0xC993, 0xC993, 0xC993}, {0xC994, 0xC994, 0xC994},
    {0xC995, 0xC995, 0xC995}, {0xC996, 0xC996, 0xC996},
    {0xC997, 0xC997, 0xC997}, {0xC998, 0xC998, 0xC998},
    {0xC999, 0xC999, 0xC999}, {0xC99A, 0xC99A, 0xC99A},
    {0xC99B, 0xC99B, 0xC99B}, {0xC99C, 0xC99C, 0xC99C},
    {0xC99D, 0xC99D, 0xC99D}, {0xC99E, 0xC99E, 0xC99E},
    {0xC99F, 0xC99F, 0xC99F}, {0xC9A0, 0xC9A0, 0xC9A0},
    {0xC9A1, 0xC9A1, 0xC9A1}, {0xC9A2, 0xC9A2, 0xC9A2},
    {0xC9A3, 0xC9A3, 0xC9A3}, {0xC9A4, 0xC9A4, 0xC9A4},
    {0xC9A5, 0xC9A5, 0xC9A5}, {0xC9A6, 0xC9A6, 0xC9A6},
    {0xC9A7, 0xC9A7, 0xC9A7}, {0xC9A8, 0xC9A8, 0xC9A8},
    {0xC9A9, 0xC9A9, 0xC9A9}, {0xC9AA, 0xC9AA, 0xC9AA},
    {0xC9AB, 0xC9AB, 0xC9AB}, {0xC9AC, 0xC9AC, 0xC9AC},
    {0xC9AD, 0xC9AD, 0xC9AD}, {0xC9AE, 0xC9AE, 0xC9AE},
    {0xC9AF, 0xC9AF, 0xC9AF}, {0xC9B0, 0xC9B0, 0xC9B0},
    {0xC9B1, 0xC9B1, 0xC9B1}, {0xC9B2, 0xC9B2, 0xC9B2},
    {0xC9B3, 0xC9B3, 0xC9B3}, {0xC9B4, 0xC9B4, 0xC9B4},
    {0xC9B5, 0xC9B5, 0xC9B5}, {0xC9B6, 0xC9B6, 0xC9B6},
    {0xC9B7, 0xC9B7, 0xC9B7}, {0xC9B8, 0xC9B8, 0xC9B8},
    {0xC9B9, 0xC9B9, 0xC9B9}, {0xC9BA, 0xC9BA, 0xC9BA},
    {0xC9BB, 0xC9BB, 0xC9BB}, {0xC9BC, 0xC9BC, 0xC9BC},
    {0xC9BD, 0xC9BD, 0xC9BD}, {0xC9BE, 0xC9BE, 0xC9BE},
    {0xC9BF, 0xC9BF, 0xC9BF}, {0xC9C0, 0xC9C0, 0xC9C0},
    {0xC9C1, 0xC9C1, 0xC9C1}, {0xC9C2, 0xC9C2, 0xC9C2},
    {0xC9C3, 0xC9C3, 0xC9C3}, {0xC9C4, 0xC9C4, 0xC9C4},
    {0xC9C5, 0xC9C5, 0xC9C5}, {0xC9C6, 0xC9C6, 0xC9C6},
    {0xC9C7, 0xC9C7, 0xC9C7}, {0xC9C8, 0xC9C8, 0xC9C8},
    {0xC9C9, 0xC9C9, 0xC9C9}, {0xC9CA, 0xC9CA, 0xC9CA},
    {0xC9CB, 0xC9CB, 0xC9CB}, {0xC9CC, 0xC9CC, 0xC9CC},
    {0xC9CD, 0xC9CD, 0xC9CD}, {0xC9CE, 0xC9CE, 0xC9CE},
    {0xC9CF, 0xC9CF, 0xC9CF}, {0xC9D0, 0xC9D0, 0xC9D0},
    {0xC9D1, 0xC9D1, 0xC9D1}, {0xC9D2, 0xC9D2, 0xC9D2},
    {0xC9D3, 0xC9D3, 0xC9D3}, {0xC9D4, 0xC9D4, 0xC9D4},
    {0xC9D5, 0xC9D5, 0xC9D5}, {0xC9D6, 0xC9D6, 0xC9D6},
    {0xC9D7, 0xC9D7, 0xC9D7}, {0xC9D8, 0xC9D8, 0xC9D8},
    {0xC9D9, 0xC9D9, 0xC9D9}, {0xC9DA, 0xC9DA, 0xC9DA},
    {0xC9DB, 0xC9DB, 0xC9DB}, {0xC9DC, 0xC9DC, 0xC9DC},
    {0xC9DD, 0xC9DD, 0xC9DD}, {0xC9DE, 0xC9DE, 0xC9DE},
    {0xC9DF, 0xC9DF, 0xC9DF}, {0xC9E0, 0xC9E0, 0xC9E0},
    {0xC9E1, 0xC9E1, 0xC9E1}, {0xC9E2, 0xC9E2, 0xC9E2},
    {0xC9E3, 0xC9E3, 0xC9E3}, {0xC9E4, 0xC9E4, 0xC9E4},
    {0xC9E5, 0xC9E5, 0xC9E5}, {0xC9E6, 0xC9E6, 0xC9E6},
    {0xC9E7, 0xC9E7, 0xC9E7}, {0xC9E8, 0xC9E8, 0xC9E8},
    {0xC9E9, 0xC9E9, 0xC9E9}, {0xC9EA, 0xC9EA, 0xC9EA},
    {0xC9EB, 0xC9EB, 0xC9EB}, {0xC9EC, 0xC9EC, 0xC9EC},
    {0xC9ED, 0xC9ED, 0xC9ED}, {0xC9EE, 0xC9EE, 0xC9EE},
    {0xC9EF, 0xC9EF, 0xC9EF}, {0xC9F0, 0xC9F0, 0xC9F0},
    {0xC9F1, 0xC9F1, 0xC9F1}, {0xC9F2, 0xC9F2, 0xC9F2},
    {0xC9F3, 0xC9F3, 0xC9F3}, {0xC9F4, 0xC9F4, 0xC9F4},
    {0xC9F5, 0xC9F5, 0xC9F5}, {0xC9F6, 0xC9F6, 0xC9F6},
    {0xC9F7, 0xC9F7, 0xC9F7}, {0xC9F8, 0xC9F8, 0xC9F8},
    {0xC9F9, 0xC9F9, 0xC9F9}, {0xC9FA, 0xC9FA, 0xC9FA},
    {0xC9FB, 0xC9FB, 0xC9FB}, {0xC9FC, 0xC9FC, 0xC9FC},
    {0xC9FD, 0xC9FD, 0xC9FD}, {0xC9FE, 0xC9FE, 0xC9FE},
    {0xC9FF, 0xC9FF, 0xC9FF}, {0xCA00, 0xCA00, 0xCA00},
    {0xCA01, 0xCA01, 0xCA01}, {0xCA02, 0xCA02, 0xCA02},
    {0xCA03, 0xCA03, 0xCA03}, {0xCA04, 0xCA04, 0xCA04},
    {0xCA05, 0xCA05, 0xCA05}, {0xCA06, 0xCA06, 0xCA06},
    {0xCA07, 0xCA07, 0xCA07}, {0xCA08, 0xCA08, 0xCA08},
    {0xCA09, 0xCA09, 0xCA09}, {0xCA0A, 0xCA0A, 0xCA0A},
    {0xCA0B, 0xCA0B, 0xCA0B}, {0xCA0C, 0xCA0C, 0xCA0C},
    {0xCA0D, 0xCA0D, 0xCA0D}, {0xCA0E, 0xCA0E, 0xCA0E},
    {0xCA0F, 0xCA0F, 0xCA0F}, {0xCA10, 0xCA10, 0xCA10},
    {0xCA11, 0xCA11, 0xCA11}, {0xCA12, 0xCA12, 0xCA12},
    {0xCA13, 0xCA13, 0xCA13}, {0xCA14, 0xCA14, 0xCA14},
    {0xCA15, 0xCA15, 0xCA15}, {0xCA16, 0xCA16, 0xCA16},
    {0xCA17, 0xCA17, 0xCA17}, {0xCA18, 0xCA18, 0xCA18},
    {0xCA19, 0xCA19, 0xCA19}, {0xCA1A, 0xCA1A, 0xCA1A},
    {0xCA1B, 0xCA1B, 0xCA1B}, {0xCA1C, 0xCA1C, 0xCA1C},
    {0xCA1D, 0xCA1D, 0xCA1D}, {0xCA1E, 0xCA1E, 0xCA1E},
    {0xCA1F, 0xCA1F, 0xCA1F}, {0xCA20, 0xCA20, 0xCA20},
    {0xCA21, 0xCA21, 0xCA21}, {0xCA22, 0xCA22, 0xCA22},
    {0xCA23, 0xCA23, 0xCA23}, {0xCA24, 0xCA24, 0xCA24},
    {0xCA25, 0xCA25, 0xCA25}, {0xCA26, 0xCA26, 0xCA26},
    {0xCA27, 0xCA27, 0xCA27}, {0xCA28, 0xCA28, 0xCA28},
    {0xCA29, 0xCA29, 0xCA29}, {0xCA2A, 0xCA2A, 0xCA2A},
    {0xCA2B, 0xCA2B, 0xCA2B}, {0xCA2C, 0xCA2C, 0xCA2C},
    {0xCA2D, 0xCA2D, 0xCA2D}, {0xCA2E, 0xCA2E, 0xCA2E},
    {0xCA2F, 0xCA2F, 0xCA2F}, {0xCA30, 0xCA30, 0xCA30},
    {0xCA31, 0xCA31, 0xCA31}, {0xCA32, 0xCA32, 0xCA32},
    {0xCA33, 0xCA33, 0xCA33}, {0xCA34, 0xCA34, 0xCA34},
    {0xCA35, 0xCA35, 0xCA35}, {0xCA36, 0xCA36, 0xCA36},
    {0xCA37, 0xCA37, 0xCA37}, {0xCA38, 0xCA38, 0xCA38},
    {0xCA39, 0xCA39, 0xCA39}, {0xCA3A, 0xCA3A, 0xCA3A},
    {0xCA3B, 0xCA3B, 0xCA3B}, {0xCA3C, 0xCA3C, 0xCA3C},
    {0xCA3D, 0xCA3D, 0xCA3D}, {0xCA3E, 0xCA3E, 0xCA3E},
    {0xCA3F, 0xCA3F, 0xCA3F}, {0xCA40, 0xCA40, 0xCA40},
    {0xCA41, 0xCA41, 0xCA41}, {0xCA42, 0xCA42, 0xCA42},
    {0xCA43, 0xCA43, 0xCA43}, {0xCA44, 0xCA44, 0xCA44},
    {0xCA45, 0xCA45, 0xCA45}, {0xCA46, 0xCA46, 0xCA46},
    {0xCA47, 0xCA47, 0xCA47}, {0xCA48, 0xCA48, 0xCA48},
    {0xCA49, 0xCA49, 0xCA49}, {0xCA4A, 0xCA4A, 0xCA4A},
    {0xCA4B, 0xCA4B, 0xCA4B}, {0xCA4C, 0xCA4C, 0xCA4C},
    {0xCA4D, 0xCA4D, 0xCA4D}, {0xCA4E, 0xCA4E, 0xCA4E},
    {0xCA4F, 0xCA4F, 0xCA4F}, {0xCA50, 0xCA50, 0xCA50},
    {0xCA51, 0xCA51, 0xCA51}, {0xCA52, 0xCA52, 0xCA52},
    {0xCA53, 0xCA53, 0xCA53}, {0xCA54, 0xCA54, 0xCA54},
    {0xCA55, 0xCA55, 0xCA55}, {0xCA56, 0xCA56, 0xCA56},
    {0xCA57, 0xCA57, 0xCA57}, {0xCA58, 0xCA58, 0xCA58},
    {0xCA59, 0xCA59, 0xCA59}, {0xCA5A, 0xCA5A, 0xCA5A},
    {0xCA5B, 0xCA5B, 0xCA5B}, {0xCA5C, 0xCA5C, 0xCA5C},
    {0xCA5D, 0xCA5D, 0xCA5D}, {0xCA5E, 0xCA5E, 0xCA5E},
    {0xCA5F, 0xCA5F, 0xCA5F}, {0xCA60, 0xCA60, 0xCA60},
    {0xCA61, 0xCA61, 0xCA61}, {0xCA62, 0xCA62, 0xCA62},
    {0xCA63, 0xCA63, 0xCA63}, {0xCA64, 0xCA64, 0xCA64},
    {0xCA65, 0xCA65, 0xCA65}, {0xCA66, 0xCA66, 0xCA66},
    {0xCA67, 0xCA67, 0xCA67}, {0xCA68, 0xCA68, 0xCA68},
    {0xCA69, 0xCA69, 0xCA69}, {0xCA6A, 0xCA6A, 0xCA6A},
    {0xCA6B, 0xCA6B, 0xCA6B}, {0xCA6C, 0xCA6C, 0xCA6C},
    {0xCA6D, 0xCA6D, 0xCA6D}, {0xCA6E, 0xCA6E, 0xCA6E},
    {0xCA6F, 0xCA6F, 0xCA6F}, {0xCA70, 0xCA70, 0xCA70},
    {0xCA71, 0xCA71, 0xCA71}, {0xCA72, 0xCA72, 0xCA72},
    {0xCA73, 0xCA73, 0xCA73}, {0xCA74, 0xCA74, 0xCA74},
    {0xCA75, 0xCA75, 0xCA75}, {0xCA76, 0xCA76, 0xCA76},
    {0xCA77, 0xCA77, 0xCA77}, {0xCA78, 0xCA78, 0xCA78},
    {0xCA79, 0xCA79, 0xCA79}, {0xCA7A, 0xCA7A, 0xCA7A},
    {0xCA7B, 0xCA7B, 0xCA7B}, {0xCA7C, 0xCA7C, 0xCA7C},
    {0xCA7D, 0xCA7D, 0xCA7D}, {0xCA7E, 0xCA7E, 0xCA7E},
    {0xCA7F, 0xCA7F, 0xCA7F}, {0xCA80, 0xCA80, 0xCA80},
    {0xCA81, 0xCA81, 0xCA81}, {0xCA82, 0xCA82, 0xCA82},
    {0xCA83, 0xCA83, 0xCA83}, {0xCA84, 0xCA84, 0xCA84},
    {0xCA85, 0xCA85, 0xCA85}, {0xCA86, 0xCA86, 0xCA86},
    {0xCA87, 0xCA87, 0xCA87}, {0xCA88, 0xCA88, 0xCA88},
    {0xCA89, 0xCA89, 0xCA89}, {0xCA8A, 0xCA8A, 0xCA8A},
    {0xCA8B, 0xCA8B, 0xCA8B}, {0xCA8C, 0xCA8C, 0xCA8C},
    {0xCA8D, 0xCA8D, 0xCA8D}, {0xCA8E, 0xCA8E, 0xCA8E},
    {0xCA8F, 0xCA8F, 0xCA8F}, {0xCA90, 0xCA90, 0xCA90},
    {0xCA91, 0xCA91, 0xCA91}, {0xCA92, 0xCA92, 0xCA92},
    {0xCA93, 0xCA93, 0xCA93}, {0xCA94, 0xCA94, 0xCA94},
    {0xCA95, 0xCA95, 0xCA95}, {0xCA96, 0xCA96, 0xCA96},
    {0xCA97, 0xCA97, 0xCA97}, {0xCA98, 0xCA98, 0xCA98},
    {0xCA99, 0xCA99, 0xCA99}, {0xCA9A, 0xCA9A, 0xCA9A},
    {0xCA9B, 0xCA9B, 0xCA9B}, {0xCA9C, 0xCA9C, 0xCA9C},
    {0xCA9D, 0xCA9D, 0xCA9D}, {0xCA9E, 0xCA9E, 0xCA9E},
    {0xCA9F, 0xCA9F, 0xCA9F}, {0xCAA0, 0xCAA0, 0xCAA0},
    {0xCAA1, 0xCAA1, 0xCAA1}, {0xCAA2, 0xCAA2, 0xCAA2},
    {0xCAA3, 0xCAA3, 0xCAA3}, {0xCAA4, 0xCAA4, 0xCAA4},
    {0xCAA5, 0xCAA5, 0xCAA5}, {0xCAA6, 0xCAA6, 0xCAA6},
    {0xCAA7, 0xCAA7, 0xCAA7}, {0xCAA8, 0xCAA8, 0xCAA8},
    {0xCAA9, 0xCAA9, 0xCAA9}, {0xCAAA, 0xCAAA, 0xCAAA},
    {0xCAAB, 0xCAAB, 0xCAAB}, {0xCAAC, 0xCAAC, 0xCAAC},
    {0xCAAD, 0xCAAD, 0xCAAD}, {0xCAAE, 0xCAAE, 0xCAAE},
    {0xCAAF, 0xCAAF, 0xCAAF}, {0xCAB0, 0xCAB0, 0xCAB0},
    {0xCAB1, 0xCAB1, 0xCAB1}, {0xCAB2, 0xCAB2, 0xCAB2},
    {0xCAB3, 0xCAB3, 0xCAB3}, {0xCAB4, 0xCAB4, 0xCAB4},
    {0xCAB5, 0xCAB5, 0xCAB5}, {0xCAB6, 0xCAB6, 0xCAB6},
    {0xCAB7, 0xCAB7, 0xCAB7}, {0xCAB8, 0xCAB8, 0xCAB8},
    {0xCAB9, 0xCAB9, 0xCAB9}, {0xCABA, 0xCABA, 0xCABA},
    {0xCABB, 0xCABB, 0xCABB}, {0xCABC, 0xCABC, 0xCABC},
    {0xCABD, 0xCABD, 0xCABD}, {0xCABE, 0xCABE, 0xCABE},
    {0xCABF, 0xCABF, 0xCABF}, {0xCAC0, 0xCAC0, 0xCAC0},
    {0xCAC1, 0xCAC1, 0xCAC1}, {0xCAC2, 0xCAC2, 0xCAC2},
    {0xCAC3, 0xCAC3, 0xCAC3}, {0xCAC4, 0xCAC4, 0xCAC4},
    {0xCAC5, 0xCAC5, 0xCAC5}, {0xCAC6, 0xCAC6, 0xCAC6},
    {0xCAC7, 0xCAC7, 0xCAC7}, {0xCAC8, 0xCAC8, 0xCAC8},
    {0xCAC9, 0xCAC9, 0xCAC9}, {0xCACA, 0xCACA, 0xCACA},
    {0xCACB, 0xCACB, 0xCACB}, {0xCACC, 0xCACC, 0xCACC},
    {0xCACD, 0xCACD, 0xCACD}, {0xCACE, 0xCACE, 0xCACE},
    {0xCACF, 0xCACF, 0xCACF}, {0xCAD0, 0xCAD0, 0xCAD0},
    {0xCAD1, 0xCAD1, 0xCAD1}, {0xCAD2, 0xCAD2, 0xCAD2},
    {0xCAD3, 0xCAD3, 0xCAD3}, {0xCAD4, 0xCAD4, 0xCAD4},
    {0xCAD5, 0xCAD5, 0xCAD5}, {0xCAD6, 0xCAD6, 0xCAD6},
    {0xCAD7, 0xCAD7, 0xCAD7}, {0xCAD8, 0xCAD8, 0xCAD8},
    {0xCAD9, 0xCAD9, 0xCAD9}, {0xCADA, 0xCADA, 0xCADA},
    {0xCADB, 0xCADB, 0xCADB}, {0xCADC, 0xCADC, 0xCADC},
    {0xCADD, 0xCADD, 0xCADD}, {0xCADE, 0xCADE, 0xCADE},
    {0xCADF, 0xCADF, 0xCADF}, {0xCAE0, 0xCAE0, 0xCAE0},
    {0xCAE1, 0xCAE1, 0xCAE1}, {0xCAE2, 0xCAE2, 0xCAE2},
    {0xCAE3, 0xCAE3, 0xCAE3}, {0xCAE4, 0xCAE4, 0xCAE4},
    {0xCAE5, 0xCAE5, 0xCAE5}, {0xCAE6, 0xCAE6, 0xCAE6},
    {0xCAE7, 0xCAE7, 0xCAE7}, {0xCAE8, 0xCAE8, 0xCAE8},
    {0xCAE9, 0xCAE9, 0xCAE9}, {0xCAEA, 0xCAEA, 0xCAEA},
    {0xCAEB, 0xCAEB, 0xCAEB}, {0xCAEC, 0xCAEC, 0xCAEC},
    {0xCAED, 0xCAED, 0xCAED}, {0xCAEE, 0xCAEE, 0xCAEE},
    {0xCAEF, 0xCAEF, 0xCAEF}, {0xCAF0, 0xCAF0, 0xCAF0},
    {0xCAF1, 0xCAF1, 0xCAF1}, {0xCAF2, 0xCAF2, 0xCAF2},
    {0xCAF3, 0xCAF3, 0xCAF3}, {0xCAF4, 0xCAF4, 0xCAF4},
    {0xCAF5, 0xCAF5, 0xCAF5}, {0xCAF6, 0xCAF6, 0xCAF6},
    {0xCAF7, 0xCAF7, 0xCAF7}, {0xCAF8, 0xCAF8, 0xCAF8},
    {0xCAF9, 0xCAF9, 0xCAF9}, {0xCAFA, 0xCAFA, 0xCAFA},
    {0xCAFB, 0xCAFB, 0xCAFB}, {0xCAFC, 0xCAFC, 0xCAFC},
    {0xCAFD, 0xCAFD, 0xCAFD}, {0xCAFE, 0xCAFE, 0xCAFE},
    {0xCAFF, 0xCAFF, 0xCAFF}, {0xCB00, 0xCB00, 0xCB00},
    {0xCB01, 0xCB01, 0xCB01}, {0xCB02, 0xCB02, 0xCB02},
    {0xCB03, 0xCB03, 0xCB03}, {0xCB04, 0xCB04, 0xCB04},
    {0xCB05, 0xCB05, 0xCB05}, {0xCB06, 0xCB06, 0xCB06},
    {0xCB07, 0xCB07, 0xCB07}, {0xCB08, 0xCB08, 0xCB08},
    {0xCB09, 0xCB09, 0xCB09}, {0xCB0A, 0xCB0A, 0xCB0A},
    {0xCB0B, 0xCB0B, 0xCB0B}, {0xCB0C, 0xCB0C, 0xCB0C},
    {0xCB0D, 0xCB0D, 0xCB0D}, {0xCB0E, 0xCB0E, 0xCB0E},
    {0xCB0F, 0xCB0F, 0xCB0F}, {0xCB10, 0xCB10, 0xCB10},
    {0xCB11, 0xCB11, 0xCB11}, {0xCB12, 0xCB12, 0xCB12},
    {0xCB13, 0xCB13, 0xCB13}, {0xCB14, 0xCB14, 0xCB14},
    {0xCB15, 0xCB15, 0xCB15}, {0xCB16, 0xCB16, 0xCB16},
    {0xCB17, 0xCB17, 0xCB17}, {0xCB18, 0xCB18, 0xCB18},
    {0xCB19, 0xCB19, 0xCB19}, {0xCB1A, 0xCB1A, 0xCB1A},
    {0xCB1B, 0xCB1B, 0xCB1B}, {0xCB1C, 0xCB1C, 0xCB1C},
    {0xCB1D, 0xCB1D, 0xCB1D}, {0xCB1E, 0xCB1E, 0xCB1E},
    {0xCB1F, 0xCB1F, 0xCB1F}, {0xCB20, 0xCB20, 0xCB20},
    {0xCB21, 0xCB21, 0xCB21}, {0xCB22, 0xCB22, 0xCB22},
    {0xCB23, 0xCB23, 0xCB23}, {0xCB24, 0xCB24, 0xCB24},
    {0xCB25, 0xCB25, 0xCB25}, {0xCB26, 0xCB26, 0xCB26},
    {0xCB27, 0xCB27, 0xCB27}, {0xCB28, 0xCB28, 0xCB28},
    {0xCB29, 0xCB29, 0xCB29}, {0xCB2A, 0xCB2A, 0xCB2A},
    {0xCB2B, 0xCB2B, 0xCB2B}, {0xCB2C, 0xCB2C, 0xCB2C},
    {0xCB2D, 0xCB2D, 0xCB2D}, {0xCB2E, 0xCB2E, 0xCB2E},
    {0xCB2F, 0xCB2F, 0xCB2F}, {0xCB30, 0xCB30, 0xCB30},
    {0xCB31, 0xCB31, 0xCB31}, {0xCB32, 0xCB32, 0xCB32},
    {0xCB33, 0xCB33, 0xCB33}, {0xCB34, 0xCB34, 0xCB34},
    {0xCB35, 0xCB35, 0xCB35}, {0xCB36, 0xCB36, 0xCB36},
    {0xCB37, 0xCB37, 0xCB37}, {0xCB38, 0xCB38, 0xCB38},
    {0xCB39, 0xCB39, 0xCB39}, {0xCB3A, 0xCB3A, 0xCB3A},
    {0xCB3B, 0xCB3B, 0xCB3B}, {0xCB3C, 0xCB3C, 0xCB3C},
    {0xCB3D, 0xCB3D, 0xCB3D}, {0xCB3E, 0xCB3E, 0xCB3E},
    {0xCB3F, 0xCB3F, 0xCB3F}, {0xCB40, 0xCB40, 0xCB40},
    {0xCB41, 0xCB41, 0xCB41}, {0xCB42, 0xCB42, 0xCB42},
    {0xCB43, 0xCB43, 0xCB43}, {0xCB44, 0xCB44, 0xCB44},
    {0xCB45, 0xCB45, 0xCB45}, {0xCB46, 0xCB46, 0xCB46},
    {0xCB47, 0xCB47, 0xCB47}, {0xCB48, 0xCB48, 0xCB48},
    {0xCB49, 0xCB49, 0xCB49}, {0xCB4A, 0xCB4A, 0xCB4A},
    {0xCB4B, 0xCB4B, 0xCB4B}, {0xCB4C, 0xCB4C, 0xCB4C},
    {0xCB4D, 0xCB4D, 0xCB4D}, {0xCB4E, 0xCB4E, 0xCB4E},
    {0xCB4F, 0xCB4F, 0xCB4F}, {0xCB50, 0xCB50, 0xCB50},
    {0xCB51, 0xCB51, 0xCB51}, {0xCB52, 0xCB52, 0xCB52},
    {0xCB53, 0xCB53, 0xCB53}, {0xCB54, 0xCB54, 0xCB54},
    {0xCB55, 0xCB55, 0xCB55}, {0xCB56, 0xCB56, 0xCB56},
    {0xCB57, 0xCB57, 0xCB57}, {0xCB58, 0xCB58, 0xCB58},
    {0xCB59, 0xCB59, 0xCB59}, {0xCB5A, 0xCB5A, 0xCB5A},
    {0xCB5B, 0xCB5B, 0xCB5B}, {0xCB5C, 0xCB5C, 0xCB5C},
    {0xCB5D, 0xCB5D, 0xCB5D}, {0xCB5E, 0xCB5E, 0xCB5E},
    {0xCB5F, 0xCB5F, 0xCB5F}, {0xCB60, 0xCB60, 0xCB60},
    {0xCB61, 0xCB61, 0xCB61}, {0xCB62, 0xCB62, 0xCB62},
    {0xCB63, 0xCB63, 0xCB63}, {0xCB64, 0xCB64, 0xCB64},
    {0xCB65, 0xCB65, 0xCB65}, {0xCB66, 0xCB66, 0xCB66},
    {0xCB67, 0xCB67, 0xCB67}, {0xCB68, 0xCB68, 0xCB68},
    {0xCB69, 0xCB69, 0xCB69}, {0xCB6A, 0xCB6A, 0xCB6A},
    {0xCB6B, 0xCB6B, 0xCB6B}, {0xCB6C, 0xCB6C, 0xCB6C},
    {0xCB6D, 0xCB6D, 0xCB6D}, {0xCB6E, 0xCB6E, 0xCB6E},
    {0xCB6F, 0xCB6F, 0xCB6F}, {0xCB70, 0xCB70, 0xCB70},
    {0xCB71, 0xCB71, 0xCB71}, {0xCB72, 0xCB72, 0xCB72},
    {0xCB73, 0xCB73, 0xCB73}, {0xCB74, 0xCB74, 0xCB74},
    {0xCB75, 0xCB75, 0xCB75}, {0xCB76, 0xCB76, 0xCB76},
    {0xCB77, 0xCB77, 0xCB77}, {0xCB78, 0xCB78, 0xCB78},
    {0xCB79, 0xCB79, 0xCB79}, {0xCB7A, 0xCB7A, 0xCB7A},
    {0xCB7B, 0xCB7B, 0xCB7B}, {0xCB7C, 0xCB7C, 0xCB7C},
    {0xCB7D, 0xCB7D, 0xCB7D}, {0xCB7E, 0xCB7E, 0xCB7E},
    {0xCB7F, 0xCB7F, 0xCB7F}, {0xCB80, 0xCB80, 0xCB80},
    {0xCB81, 0xCB81, 0xCB81}, {0xCB82, 0xCB82, 0xCB82},
    {0xCB83, 0xCB83, 0xCB83}, {0xCB84, 0xCB84, 0xCB84},
    {0xCB85, 0xCB85, 0xCB85}, {0xCB86, 0xCB86, 0xCB86},
    {0xCB87, 0xCB87, 0xCB87}, {0xCB88, 0xCB88, 0xCB88},
    {0xCB89, 0xCB89, 0xCB89}, {0xCB8A, 0xCB8A, 0xCB8A},
    {0xCB8B, 0xCB8B, 0xCB8B}, {0xCB8C, 0xCB8C, 0xCB8C},
    {0xCB8D, 0xCB8D, 0xCB8D}, {0xCB8E, 0xCB8E, 0xCB8E},
    {0xCB8F, 0xCB8F, 0xCB8F}, {0xCB90, 0xCB90, 0xCB90},
    {0xCB91, 0xCB91, 0xCB91}, {0xCB92, 0xCB92, 0xCB92},
    {0xCB93, 0xCB93, 0xCB93}, {0xCB94, 0xCB94, 0xCB94},
    {0xCB95, 0xCB95, 0xCB95}, {0xCB96, 0xCB96, 0xCB96},
    {0xCB97, 0xCB97, 0xCB97}, {0xCB98, 0xCB98, 0xCB98},
    {0xCB99, 0xCB99, 0xCB99}, {0xCB9A, 0xCB9A, 0xCB9A},
    {0xCB9B, 0xCB9B, 0xCB9B}, {0xCB9C, 0xCB9C, 0xCB9C},
    {0xCB9D, 0xCB9D, 0xCB9D}, {0xCB9E, 0xCB9E, 0xCB9E},
    {0xCB9F, 0xCB9F, 0xCB9F}, {0xCBA0, 0xCBA0, 0xCBA0},
    {0xCBA1, 0xCBA1, 0xCBA1}, {0xCBA2, 0xCBA2, 0xCBA2},
    {0xCBA3, 0xCBA3, 0xCBA3}, {0xCBA4, 0xCBA4, 0xCBA4},
    {0xCBA5, 0xCBA5, 0xCBA5}, {0xCBA6, 0xCBA6, 0xCBA6},
    {0xCBA7, 0xCBA7, 0xCBA7}, {0xCBA8, 0xCBA8, 0xCBA8},
    {0xCBA9, 0xCBA9, 0xCBA9}, {0xCBAA, 0xCBAA, 0xCBAA},
    {0xCBAB, 0xCBAB, 0xCBAB}, {0xCBAC, 0xCBAC, 0xCBAC},
    {0xCBAD, 0xCBAD, 0xCBAD}, {0xCBAE, 0xCBAE, 0xCBAE},
    {0xCBAF, 0xCBAF, 0xCBAF}, {0xCBB0, 0xCBB0, 0xCBB0},
    {0xCBB1, 0xCBB1, 0xCBB1}, {0xCBB2, 0xCBB2, 0xCBB2},
    {0xCBB3, 0xCBB3, 0xCBB3}, {0xCBB4, 0xCBB4, 0xCBB4},
    {0xCBB5, 0xCBB5, 0xCBB5}, {0xCBB6, 0xCBB6, 0xCBB6},
    {0xCBB7, 0xCBB7, 0xCBB7}, {0xCBB8, 0xCBB8, 0xCBB8},
    {0xCBB9, 0xCBB9, 0xCBB9}, {0xCBBA, 0xCBBA, 0xCBBA},
    {0xCBBB, 0xCBBB, 0xCBBB}, {0xCBBC, 0xCBBC, 0xCBBC},
    {0xCBBD, 0xCBBD, 0xCBBD}, {0xCBBE, 0xCBBE, 0xCBBE},
    {0xCBBF, 0xCBBF, 0xCBBF}, {0xCBC0, 0xCBC0, 0xCBC0},
    {0xCBC1, 0xCBC1, 0xCBC1}, {0xCBC2, 0xCBC2, 0xCBC2},
    {0xCBC3, 0xCBC3, 0xCBC3}, {0xCBC4, 0xCBC4, 0xCBC4},
    {0xCBC5, 0xCBC5, 0xCBC5}, {0xCBC6, 0xCBC6, 0xCBC6},
    {0xCBC7, 0xCBC7, 0xCBC7}, {0xCBC8, 0xCBC8, 0xCBC8},
    {0xCBC9, 0xCBC9, 0xCBC9}, {0xCBCA, 0xCBCA, 0xCBCA},
    {0xCBCB, 0xCBCB, 0xCBCB}, {0xCBCC, 0xCBCC, 0xCBCC},
    {0xCBCD, 0xCBCD, 0xCBCD}, {0xCBCE, 0xCBCE, 0xCBCE},
    {0xCBCF, 0xCBCF, 0xCBCF}, {0xCBD0, 0xCBD0, 0xCBD0},
    {0xCBD1, 0xCBD1, 0xCBD1}, {0xCBD2, 0xCBD2, 0xCBD2},
    {0xCBD3, 0xCBD3, 0xCBD3}, {0xCBD4, 0xCBD4, 0xCBD4},
    {0xCBD5, 0xCBD5, 0xCBD5}, {0xCBD6, 0xCBD6, 0xCBD6},
    {0xCBD7, 0xCBD7, 0xCBD7}, {0xCBD8, 0xCBD8, 0xCBD8},
    {0xCBD9, 0xCBD9, 0xCBD9}, {0xCBDA, 0xCBDA, 0xCBDA},
    {0xCBDB, 0xCBDB, 0xCBDB}, {0xCBDC, 0xCBDC, 0xCBDC},
    {0xCBDD, 0xCBDD, 0xCBDD}, {0xCBDE, 0xCBDE, 0xCBDE},
    {0xCBDF, 0xCBDF, 0xCBDF}, {0xCBE0, 0xCBE0, 0xCBE0},
    {0xCBE1, 0xCBE1, 0xCBE1}, {0xCBE2, 0xCBE2, 0xCBE2},
    {0xCBE3, 0xCBE3, 0xCBE3}, {0xCBE4, 0xCBE4, 0xCBE4},
    {0xCBE5, 0xCBE5, 0xCBE5}, {0xCBE6, 0xCBE6, 0xCBE6},
    {0xCBE7, 0xCBE7, 0xCBE7}, {0xCBE8, 0xCBE8, 0xCBE8},
    {0xCBE9, 0xCBE9, 0xCBE9}, {0xCBEA, 0xCBEA, 0xCBEA},
    {0xCBEB, 0xCBEB, 0xCBEB}, {0xCBEC, 0xCBEC, 0xCBEC},
    {0xCBED, 0xCBED, 0xCBED}, {0xCBEE, 0xCBEE, 0xCBEE},
    {0xCBEF, 0xCBEF, 0xCBEF}, {0xCBF0, 0xCBF0, 0xCBF0},
    {0xCBF1, 0xCBF1, 0xCBF1}, {0xCBF2, 0xCBF2, 0xCBF2},
    {0xCBF3, 0xCBF3, 0xCBF3}, {0xCBF4, 0xCBF4, 0xCBF4},
    {0xCBF5, 0xCBF5, 0xCBF5}, {0xCBF6, 0xCBF6, 0xCBF6},
    {0xCBF7, 0xCBF7, 0xCBF7}, {0xCBF8, 0xCBF8, 0xCBF8},
    {0xCBF9, 0xCBF9, 0xCBF9}, {0xCBFA, 0xCBFA, 0xCBFA},
    {0xCBFB, 0xCBFB, 0xCBFB}, {0xCBFC, 0xCBFC, 0xCBFC},
    {0xCBFD, 0xCBFD, 0xCBFD}, {0xCBFE, 0xCBFE, 0xCBFE},
    {0xCBFF, 0xCBFF, 0xCBFF}, {0xCC00, 0xCC00, 0xCC00},
    {0xCC01, 0xCC01, 0xCC01}, {0xCC02, 0xCC02, 0xCC02},
    {0xCC03, 0xCC03, 0xCC03}, {0xCC04, 0xCC04, 0xCC04},
    {0xCC05, 0xCC05, 0xCC05}, {0xCC06, 0xCC06, 0xCC06},
    {0xCC07, 0xCC07, 0xCC07}, {0xCC08, 0xCC08, 0xCC08},
    {0xCC09, 0xCC09, 0xCC09}, {0xCC0A, 0xCC0A, 0xCC0A},
    {0xCC0B, 0xCC0B, 0xCC0B}, {0xCC0C, 0xCC0C, 0xCC0C},
    {0xCC0D, 0xCC0D, 0xCC0D}, {0xCC0E, 0xCC0E, 0xCC0E},
    {0xCC0F, 0xCC0F, 0xCC0F}, {0xCC10, 0xCC10, 0xCC10},
    {0xCC11, 0xCC11, 0xCC11}, {0xCC12, 0xCC12, 0xCC12},
    {0xCC13, 0xCC13, 0xCC13}, {0xCC14, 0xCC14, 0xCC14},
    {0xCC15, 0xCC15, 0xCC15}, {0xCC16, 0xCC16, 0xCC16},
    {0xCC17, 0xCC17, 0xCC17}, {0xCC18, 0xCC18, 0xCC18},
    {0xCC19, 0xCC19, 0xCC19}, {0xCC1A, 0xCC1A, 0xCC1A},
    {0xCC1B, 0xCC1B, 0xCC1B}, {0xCC1C, 0xCC1C, 0xCC1C},
    {0xCC1D, 0xCC1D, 0xCC1D}, {0xCC1E, 0xCC1E, 0xCC1E},
    {0xCC1F, 0xCC1F, 0xCC1F}, {0xCC20, 0xCC20, 0xCC20},
    {0xCC21, 0xCC21, 0xCC21}, {0xCC22, 0xCC22, 0xCC22},
    {0xCC23, 0xCC23, 0xCC23}, {0xCC24, 0xCC24, 0xCC24},
    {0xCC25, 0xCC25, 0xCC25}, {0xCC26, 0xCC26, 0xCC26},
    {0xCC27, 0xCC27, 0xCC27}, {0xCC28, 0xCC28, 0xCC28},
    {0xCC29, 0xCC29, 0xCC29}, {0xCC2A, 0xCC2A, 0xCC2A},
    {0xCC2B, 0xCC2B, 0xCC2B}, {0xCC2C, 0xCC2C, 0xCC2C},
    {0xCC2D, 0xCC2D, 0xCC2D}, {0xCC2E, 0xCC2E, 0xCC2E},
    {0xCC2F, 0xCC2F, 0xCC2F}, {0xCC30, 0xCC30, 0xCC30},
    {0xCC31, 0xCC31, 0xCC31}, {0xCC32, 0xCC32, 0xCC32},
    {0xCC33, 0xCC33, 0xCC33}, {0xCC34, 0xCC34, 0xCC34},
    {0xCC35, 0xCC35, 0xCC35}, {0xCC36, 0xCC36, 0xCC36},
    {0xCC37, 0xCC37, 0xCC37}, {0xCC38, 0xCC38, 0xCC38},
    {0xCC39, 0xCC39, 0xCC39}, {0xCC3A, 0xCC3A, 0xCC3A},
    {0xCC3B, 0xCC3B, 0xCC3B}, {0xCC3C, 0xCC3C, 0xCC3C},
    {0xCC3D, 0xCC3D, 0xCC3D}, {0xCC3E, 0xCC3E, 0xCC3E},
    {0xCC3F, 0xCC3F, 0xCC3F}, {0xCC40, 0xCC40, 0xCC40},
    {0xCC41, 0xCC41, 0xCC41}, {0xCC42, 0xCC42, 0xCC42},
    {0xCC43, 0xCC43, 0xCC43}, {0xCC44, 0xCC44, 0xCC44},
    {0xCC45, 0xCC45, 0xCC45}, {0xCC46, 0xCC46, 0xCC46},
    {0xCC47, 0xCC47, 0xCC47}, {0xCC48, 0xCC48, 0xCC48},
    {0xCC49, 0xCC49, 0xCC49}, {0xCC4A, 0xCC4A, 0xCC4A},
    {0xCC4B, 0xCC4B, 0xCC4B}, {0xCC4C, 0xCC4C, 0xCC4C},
    {0xCC4D, 0xCC4D, 0xCC4D}, {0xCC4E, 0xCC4E, 0xCC4E},
    {0xCC4F, 0xCC4F, 0xCC4F}, {0xCC50, 0xCC50, 0xCC50},
    {0xCC51, 0xCC51, 0xCC51}, {0xCC52, 0xCC52, 0xCC52},
    {0xCC53, 0xCC53, 0xCC53}, {0xCC54, 0xCC54, 0xCC54},
    {0xCC55, 0xCC55, 0xCC55}, {0xCC56, 0xCC56, 0xCC56},
    {0xCC57, 0xCC57, 0xCC57}, {0xCC58, 0xCC58, 0xCC58},
    {0xCC59, 0xCC59, 0xCC59}, {0xCC5A, 0xCC5A, 0xCC5A},
    {0xCC5B, 0xCC5B, 0xCC5B}, {0xCC5C, 0xCC5C, 0xCC5C},
    {0xCC5D, 0xCC5D, 0xCC5D}, {0xCC5E, 0xCC5E, 0xCC5E},
    {0xCC5F, 0xCC5F, 0xCC5F}, {0xCC60, 0xCC60, 0xCC60},
    {0xCC61, 0xCC61, 0xCC61}, {0xCC62, 0xCC62, 0xCC62},
    {0xCC63, 0xCC63, 0xCC63}, {0xCC64, 0xCC64, 0xCC64},
    {0xCC65, 0xCC65, 0xCC65}, {0xCC66, 0xCC66, 0xCC66},
    {0xCC67, 0xCC67, 0xCC67}, {0xCC68, 0xCC68, 0xCC68},
    {0xCC69, 0xCC69, 0xCC69}, {0xCC6A, 0xCC6A, 0xCC6A},
    {0xCC6B, 0xCC6B, 0xCC6B}, {0xCC6C, 0xCC6C, 0xCC6C},
    {0xCC6D, 0xCC6D, 0xCC6D}, {0xCC6E, 0xCC6E, 0xCC6E},
    {0xCC6F, 0xCC6F, 0xCC6F}, {0xCC70, 0xCC70, 0xCC70},
    {0xCC71, 0xCC71, 0xCC71}, {0xCC72, 0xCC72, 0xCC72},
    {0xCC73, 0xCC73, 0xCC73}, {0xCC74, 0xCC74, 0xCC74},
    {0xCC75, 0xCC75, 0xCC75}, {0xCC76, 0xCC76, 0xCC76},
    {0xCC77, 0xCC77, 0xCC77}, {0xCC78, 0xCC78, 0xCC78},
    {0xCC79, 0xCC79, 0xCC79}, {0xCC7A, 0xCC7A, 0xCC7A},
    {0xCC7B, 0xCC7B, 0xCC7B}, {0xCC7C, 0xCC7C, 0xCC7C},
    {0xCC7D, 0xCC7D, 0xCC7D}, {0xCC7E, 0xCC7E, 0xCC7E},
    {0xCC7F, 0xCC7F, 0xCC7F}, {0xCC80, 0xCC80, 0xCC80},
    {0xCC81, 0xCC81, 0xCC81}, {0xCC82, 0xCC82, 0xCC82},
    {0xCC83, 0xCC83, 0xCC83}, {0xCC84, 0xCC84, 0xCC84},
    {0xCC85, 0xCC85, 0xCC85}, {0xCC86, 0xCC86, 0xCC86},
    {0xCC87, 0xCC87, 0xCC87}, {0xCC88, 0xCC88, 0xCC88},
    {0xCC89, 0xCC89, 0xCC89}, {0xCC8A, 0xCC8A, 0xCC8A},
    {0xCC8B, 0xCC8B, 0xCC8B}, {0xCC8C, 0xCC8C, 0xCC8C},
    {0xCC8D, 0xCC8D, 0xCC8D}, {0xCC8E, 0xCC8E, 0xCC8E},
    {0xCC8F, 0xCC8F, 0xCC8F}, {0xCC90, 0xCC90, 0xCC90},
    {0xCC91, 0xCC91, 0xCC91}, {0xCC92, 0xCC92, 0xCC92},
    {0xCC93, 0xCC93, 0xCC93}, {0xCC94, 0xCC94, 0xCC94},
    {0xCC95, 0xCC95, 0xCC95}, {0xCC96, 0xCC96, 0xCC96},
    {0xCC97, 0xCC97, 0xCC97}, {0xCC98, 0xCC98, 0xCC98},
    {0xCC99, 0xCC99, 0xCC99}, {0xCC9A, 0xCC9A, 0xCC9A},
    {0xCC9B, 0xCC9B, 0xCC9B}, {0xCC9C, 0xCC9C, 0xCC9C},
    {0xCC9D, 0xCC9D, 0xCC9D}, {0xCC9E, 0xCC9E, 0xCC9E},
    {0xCC9F, 0xCC9F, 0xCC9F}, {0xCCA0, 0xCCA0, 0xCCA0},
    {0xCCA1, 0xCCA1, 0xCCA1}, {0xCCA2, 0xCCA2, 0xCCA2},
    {0xCCA3, 0xCCA3, 0xCCA3}, {0xCCA4, 0xCCA4, 0xCCA4},
    {0xCCA5, 0xCCA5, 0xCCA5}, {0xCCA6, 0xCCA6, 0xCCA6},
    {0xCCA7, 0xCCA7, 0xCCA7}, {0xCCA8, 0xCCA8, 0xCCA8},
    {0xCCA9, 0xCCA9, 0xCCA9}, {0xCCAA, 0xCCAA, 0xCCAA},
    {0xCCAB, 0xCCAB, 0xCCAB}, {0xCCAC, 0xCCAC, 0xCCAC},
    {0xCCAD, 0xCCAD, 0xCCAD}, {0xCCAE, 0xCCAE, 0xCCAE},
    {0xCCAF, 0xCCAF, 0xCCAF}, {0xCCB0, 0xCCB0, 0xCCB0},
    {0xCCB1, 0xCCB1, 0xCCB1}, {0xCCB2, 0xCCB2, 0xCCB2},
    {0xCCB3, 0xCCB3, 0xCCB3}, {0xCCB4, 0xCCB4, 0xCCB4},
    {0xCCB5, 0xCCB5, 0xCCB5}, {0xCCB6, 0xCCB6, 0xCCB6},
    {0xCCB7, 0xCCB7, 0xCCB7}, {0xCCB8, 0xCCB8, 0xCCB8},
    {0xCCB9, 0xCCB9, 0xCCB9}, {0xCCBA, 0xCCBA, 0xCCBA},
    {0xCCBB, 0xCCBB, 0xCCBB}, {0xCCBC, 0xCCBC, 0xCCBC},
    {0xCCBD, 0xCCBD, 0xCCBD}, {0xCCBE, 0xCCBE, 0xCCBE},
    {0xCCBF, 0xCCBF, 0xCCBF}, {0xCCC0, 0xCCC0, 0xCCC0},
    {0xCCC1, 0xCCC1, 0xCCC1}, {0xCCC2, 0xCCC2, 0xCCC2},
    {0xCCC3, 0xCCC3, 0xCCC3}, {0xCCC4, 0xCCC4, 0xCCC4},
    {0xCCC5, 0xCCC5, 0xCCC5}, {0xCCC6, 0xCCC6, 0xCCC6},
    {0xCCC7, 0xCCC7, 0xCCC7}, {0xCCC8, 0xCCC8, 0xCCC8},
    {0xCCC9, 0xCCC9, 0xCCC9}, {0xCCCA, 0xCCCA, 0xCCCA},
    {0xCCCB, 0xCCCB, 0xCCCB}, {0xCCCC, 0xCCCC, 0xCCCC},
    {0xCCCD, 0xCCCD, 0xCCCD}, {0xCCCE, 0xCCCE, 0xCCCE},
    {0xCCCF, 0xCCCF, 0xCCCF}, {0xCCD0, 0xCCD0, 0xCCD0},
    {0xCCD1, 0xCCD1, 0xCCD1}, {0xCCD2, 0xCCD2, 0xCCD2},
    {0xCCD3, 0xCCD3, 0xCCD3}, {0xCCD4, 0xCCD4, 0xCCD4},
    {0xCCD5, 0xCCD5, 0xCCD5}, {0xCCD6, 0xCCD6, 0xCCD6},
    {0xCCD7, 0xCCD7, 0xCCD7}, {0xCCD8, 0xCCD8, 0xCCD8},
    {0xCCD9, 0xCCD9, 0xCCD9}, {0xCCDA, 0xCCDA, 0xCCDA},
    {0xCCDB, 0xCCDB, 0xCCDB}, {0xCCDC, 0xCCDC, 0xCCDC},
    {0xCCDD, 0xCCDD, 0xCCDD}, {0xCCDE, 0xCCDE, 0xCCDE},
    {0xCCDF, 0xCCDF, 0xCCDF}, {0xCCE0, 0xCCE0, 0xCCE0},
    {0xCCE1, 0xCCE1, 0xCCE1}, {0xCCE2, 0xCCE2, 0xCCE2},
    {0xCCE3, 0xCCE3, 0xCCE3}, {0xCCE4, 0xCCE4, 0xCCE4},
    {0xCCE5, 0xCCE5, 0xCCE5}, {0xCCE6, 0xCCE6, 0xCCE6},
    {0xCCE7, 0xCCE7, 0xCCE7}, {0xCCE8, 0xCCE8, 0xCCE8},
    {0xCCE9, 0xCCE9, 0xCCE9}, {0xCCEA, 0xCCEA, 0xCCEA},
    {0xCCEB, 0xCCEB, 0xCCEB}, {0xCCEC, 0xCCEC, 0xCCEC},
    {0xCCED, 0xCCED, 0xCCED}, {0xCCEE, 0xCCEE, 0xCCEE},
    {0xCCEF, 0xCCEF, 0xCCEF}, {0xCCF0, 0xCCF0, 0xCCF0},
    {0xCCF1, 0xCCF1, 0xCCF1}, {0xCCF2, 0xCCF2, 0xCCF2},
    {0xCCF3, 0xCCF3, 0xCCF3}, {0xCCF4, 0xCCF4, 0xCCF4},
    {0xCCF5, 0xCCF5, 0xCCF5}, {0xCCF6, 0xCCF6, 0xCCF6},
    {0xCCF7, 0xCCF7, 0xCCF7}, {0xCCF8, 0xCCF8, 0xCCF8},
    {0xCCF9, 0xCCF9, 0xCCF9}, {0xCCFA, 0xCCFA, 0xCCFA},
    {0xCCFB, 0xCCFB, 0xCCFB}, {0xCCFC, 0xCCFC, 0xCCFC},
    {0xCCFD, 0xCCFD, 0xCCFD}, {0xCCFE, 0xCCFE, 0xCCFE},
    {0xCCFF, 0xCCFF, 0xCCFF}, {0xCD00, 0xCD00, 0xCD00},
    {0xCD01, 0xCD01, 0xCD01}, {0xCD02, 0xCD02, 0xCD02},
    {0xCD03, 0xCD03, 0xCD03}, {0xCD04, 0xCD04, 0xCD04},
    {0xCD05, 0xCD05, 0xCD05}, {0xCD06, 0xCD06, 0xCD06},
    {0xCD07, 0xCD07, 0xCD07}, {0xCD08, 0xCD08, 0xCD08},
    {0xCD09, 0xCD09, 0xCD09}, {0xCD0A, 0xCD0A, 0xCD0A},
    {0xCD0B, 0xCD0B, 0xCD0B}, {0xCD0C, 0xCD0C, 0xCD0C},
    {0xCD0D, 0xCD0D, 0xCD0D}, {0xCD0E, 0xCD0E, 0xCD0E},
    {0xCD0F, 0xCD0F, 0xCD0F}, {0xCD10, 0xCD10, 0xCD10},
    {0xCD11, 0xCD11, 0xCD11}, {0xCD12, 0xCD12, 0xCD12},
    {0xCD13, 0xCD13, 0xCD13}, {0xCD14, 0xCD14, 0xCD14},
    {0xCD15, 0xCD15, 0xCD15}, {0xCD16, 0xCD16, 0xCD16},
    {0xCD17, 0xCD17, 0xCD17}, {0xCD18, 0xCD18, 0xCD18},
    {0xCD19, 0xCD19, 0xCD19}, {0xCD1A, 0xCD1A, 0xCD1A},
    {0xCD1B, 0xCD1B, 0xCD1B}, {0xCD1C, 0xCD1C, 0xCD1C},
    {0xCD1D, 0xCD1D, 0xCD1D}, {0xCD1E, 0xCD1E, 0xCD1E},
    {0xCD1F, 0xCD1F, 0xCD1F}, {0xCD20, 0xCD20, 0xCD20},
    {0xCD21, 0xCD21, 0xCD21}, {0xCD22, 0xCD22, 0xCD22},
    {0xCD23, 0xCD23, 0xCD23}, {0xCD24, 0xCD24, 0xCD24},
    {0xCD25, 0xCD25, 0xCD25}, {0xCD26, 0xCD26, 0xCD26},
    {0xCD27, 0xCD27, 0xCD27}, {0xCD28, 0xCD28, 0xCD28},
    {0xCD29, 0xCD29, 0xCD29}, {0xCD2A, 0xCD2A, 0xCD2A},
    {0xCD2B, 0xCD2B, 0xCD2B}, {0xCD2C, 0xCD2C, 0xCD2C},
    {0xCD2D, 0xCD2D, 0xCD2D}, {0xCD2E, 0xCD2E, 0xCD2E},
    {0xCD2F, 0xCD2F, 0xCD2F}, {0xCD30, 0xCD30, 0xCD30},
    {0xCD31, 0xCD31, 0xCD31}, {0xCD32, 0xCD32, 0xCD32},
    {0xCD33, 0xCD33, 0xCD33}, {0xCD34, 0xCD34, 0xCD34},
    {0xCD35, 0xCD35, 0xCD35}, {0xCD36, 0xCD36, 0xCD36},
    {0xCD37, 0xCD37, 0xCD37}, {0xCD38, 0xCD38, 0xCD38},
    {0xCD39, 0xCD39, 0xCD39}, {0xCD3A, 0xCD3A, 0xCD3A},
    {0xCD3B, 0xCD3B, 0xCD3B}, {0xCD3C, 0xCD3C, 0xCD3C},
    {0xCD3D, 0xCD3D, 0xCD3D}, {0xCD3E, 0xCD3E, 0xCD3E},
    {0xCD3F, 0xCD3F, 0xCD3F}, {0xCD40, 0xCD40, 0xCD40},
    {0xCD41, 0xCD41, 0xCD41}, {0xCD42, 0xCD42, 0xCD42},
    {0xCD43, 0xCD43, 0xCD43}, {0xCD44, 0xCD44, 0xCD44},
    {0xCD45, 0xCD45, 0xCD45}, {0xCD46, 0xCD46, 0xCD46},
    {0xCD47, 0xCD47, 0xCD47}, {0xCD48, 0xCD48, 0xCD48},
    {0xCD49, 0xCD49, 0xCD49}, {0xCD4A, 0xCD4A, 0xCD4A},
    {0xCD4B, 0xCD4B, 0xCD4B}, {0xCD4C, 0xCD4C, 0xCD4C},
    {0xCD4D, 0xCD4D, 0xCD4D}, {0xCD4E, 0xCD4E, 0xCD4E},
    {0xCD4F, 0xCD4F, 0xCD4F}, {0xCD50, 0xCD50, 0xCD50},
    {0xCD51, 0xCD51, 0xCD51}, {0xCD52, 0xCD52, 0xCD52},
    {0xCD53, 0xCD53, 0xCD53}, {0xCD54, 0xCD54, 0xCD54},
    {0xCD55, 0xCD55, 0xCD55}, {0xCD56, 0xCD56, 0xCD56},
    {0xCD57, 0xCD57, 0xCD57}, {0xCD58, 0xCD58, 0xCD58},
    {0xCD59, 0xCD59, 0xCD59}, {0xCD5A, 0xCD5A, 0xCD5A},
    {0xCD5B, 0xCD5B, 0xCD5B}, {0xCD5C, 0xCD5C, 0xCD5C},
    {0xCD5D, 0xCD5D, 0xCD5D}, {0xCD5E, 0xCD5E, 0xCD5E},
    {0xCD5F, 0xCD5F, 0xCD5F}, {0xCD60, 0xCD60, 0xCD60},
    {0xCD61, 0xCD61, 0xCD61}, {0xCD62, 0xCD62, 0xCD62},
    {0xCD63, 0xCD63, 0xCD63}, {0xCD64, 0xCD64, 0xCD64},
    {0xCD65, 0xCD65, 0xCD65}, {0xCD66, 0xCD66, 0xCD66},
    {0xCD67, 0xCD67, 0xCD67}, {0xCD68, 0xCD68, 0xCD68},
    {0xCD69, 0xCD69, 0xCD69}, {0xCD6A, 0xCD6A, 0xCD6A},
    {0xCD6B, 0xCD6B, 0xCD6B}, {0xCD6C, 0xCD6C, 0xCD6C},
    {0xCD6D, 0xCD6D, 0xCD6D}, {0xCD6E, 0xCD6E, 0xCD6E},
    {0xCD6F, 0xCD6F, 0xCD6F}, {0xCD70, 0xCD70, 0xCD70},
    {0xCD71, 0xCD71, 0xCD71}, {0xCD72, 0xCD72, 0xCD72},
    {0xCD73, 0xCD73, 0xCD73}, {0xCD74, 0xCD74, 0xCD74},
    {0xCD75, 0xCD75, 0xCD75}, {0xCD76, 0xCD76, 0xCD76},
    {0xCD77, 0xCD77, 0xCD77}, {0xCD78, 0xCD78, 0xCD78},
    {0xCD79, 0xCD79, 0xCD79}, {0xCD7A, 0xCD7A, 0xCD7A},
    {0xCD7B, 0xCD7B, 0xCD7B}, {0xCD7C, 0xCD7C, 0xCD7C},
    {0xCD7D, 0xCD7D, 0xCD7D}, {0xCD7E, 0xCD7E, 0xCD7E},
    {0xCD7F, 0xCD7F, 0xCD7F}, {0xCD80, 0xCD80, 0xCD80},
    {0xCD81, 0xCD81, 0xCD81}, {0xCD82, 0xCD82, 0xCD82},
    {0xCD83, 0xCD83, 0xCD83}, {0xCD84, 0xCD84, 0xCD84},
    {0xCD85, 0xCD85, 0xCD85}, {0xCD86, 0xCD86, 0xCD86},
    {0xCD87, 0xCD87, 0xCD87}, {0xCD88, 0xCD88, 0xCD88},
    {0xCD89, 0xCD89, 0xCD89}, {0xCD8A, 0xCD8A, 0xCD8A},
    {0xCD8B, 0xCD8B, 0xCD8B}, {0xCD8C, 0xCD8C, 0xCD8C},
    {0xCD8D, 0xCD8D, 0xCD8D}, {0xCD8E, 0xCD8E, 0xCD8E},
    {0xCD8F, 0xCD8F, 0xCD8F}, {0xCD90, 0xCD90, 0xCD90},
    {0xCD91, 0xCD91, 0xCD91}, {0xCD92, 0xCD92, 0xCD92},
    {0xCD93, 0xCD93, 0xCD93}, {0xCD94, 0xCD94, 0xCD94},
    {0xCD95, 0xCD95, 0xCD95}, {0xCD96, 0xCD96, 0xCD96},
    {0xCD97, 0xCD97, 0xCD97}, {0xCD98, 0xCD98, 0xCD98},
    {0xCD99, 0xCD99, 0xCD99}, {0xCD9A, 0xCD9A, 0xCD9A},
    {0xCD9B, 0xCD9B, 0xCD9B}, {0xCD9C, 0xCD9C, 0xCD9C},
    {0xCD9D, 0xCD9D, 0xCD9D}, {0xCD9E, 0xCD9E, 0xCD9E},
    {0xCD9F, 0xCD9F, 0xCD9F}, {0xCDA0, 0xCDA0, 0xCDA0},
    {0xCDA1, 0xCDA1, 0xCDA1}, {0xCDA2, 0xCDA2, 0xCDA2},
    {0xCDA3, 0xCDA3, 0xCDA3}, {0xCDA4, 0xCDA4, 0xCDA4},
    {0xCDA5, 0xCDA5, 0xCDA5}, {0xCDA6, 0xCDA6, 0xCDA6},
    {0xCDA7, 0xCDA7, 0xCDA7}, {0xCDA8, 0xCDA8, 0xCDA8},
    {0xCDA9, 0xCDA9, 0xCDA9}, {0xCDAA, 0xCDAA, 0xCDAA},
    {0xCDAB, 0xCDAB, 0xCDAB}, {0xCDAC, 0xCDAC, 0xCDAC},
    {0xCDAD, 0xCDAD, 0xCDAD}, {0xCDAE, 0xCDAE, 0xCDAE},
    {0xCDAF, 0xCDAF, 0xCDAF}, {0xCDB0, 0xCDB0, 0xCDB0},
    {0xCDB1, 0xCDB1, 0xCDB1}, {0xCDB2, 0xCDB2, 0xCDB2},
    {0xCDB3, 0xCDB3, 0xCDB3}, {0xCDB4, 0xCDB4, 0xCDB4},
    {0xCDB5, 0xCDB5, 0xCDB5}, {0xCDB6, 0xCDB6, 0xCDB6},
    {0xCDB7, 0xCDB7, 0xCDB7}, {0xCDB8, 0xCDB8, 0xCDB8},
    {0xCDB9, 0xCDB9, 0xCDB9}, {0xCDBA, 0xCDBA, 0xCDBA},
    {0xCDBB, 0xCDBB, 0xCDBB}, {0xCDBC, 0xCDBC, 0xCDBC},
    {0xCDBD, 0xCDBD, 0xCDBD}, {0xCDBE, 0xCDBE, 0xCDBE},
    {0xCDBF, 0xCDBF, 0xCDBF}, {0xCDC0, 0xCDC0, 0xCDC0},
    {0xCDC1, 0xCDC1, 0xCDC1}, {0xCDC2, 0xCDC2, 0xCDC2},
    {0xCDC3, 0xCDC3, 0xCDC3}, {0xCDC4, 0xCDC4, 0xCDC4},
    {0xCDC5, 0xCDC5, 0xCDC5}, {0xCDC6, 0xCDC6, 0xCDC6},
    {0xCDC7, 0xCDC7, 0xCDC7}, {0xCDC8, 0xCDC8, 0xCDC8},
    {0xCDC9, 0xCDC9, 0xCDC9}, {0xCDCA, 0xCDCA, 0xCDCA},
    {0xCDCB, 0xCDCB, 0xCDCB}, {0xCDCC, 0xCDCC, 0xCDCC},
    {0xCDCD, 0xCDCD, 0xCDCD}, {0xCDCE, 0xCDCE, 0xCDCE},
    {0xCDCF, 0xCDCF, 0xCDCF}, {0xCDD0, 0xCDD0, 0xCDD0},
    {0xCDD1, 0xCDD1, 0xCDD1}, {0xCDD2, 0xCDD2, 0xCDD2},
    {0xCDD3, 0xCDD3, 0xCDD3}, {0xCDD4, 0xCDD4, 0xCDD4},
    {0xCDD5, 0xCDD5, 0xCDD5}, {0xCDD6, 0xCDD6, 0xCDD6},
    {0xCDD7, 0xCDD7, 0xCDD7}, {0xCDD8, 0xCDD8, 0xCDD8},
    {0xCDD9, 0xCDD9, 0xCDD9}, {0xCDDA, 0xCDDA, 0xCDDA},
    {0xCDDB, 0xCDDB, 0xCDDB}, {0xCDDC, 0xCDDC, 0xCDDC},
    {0xCDDD, 0xCDDD, 0xCDDD}, {0xCDDE, 0xCDDE, 0xCDDE},
    {0xCDDF, 0xCDDF, 0xCDDF}, {0xCDE0, 0xCDE0, 0xCDE0},
    {0xCDE1, 0xCDE1, 0xCDE1}, {0xCDE2, 0xCDE2, 0xCDE2},
    {0xCDE3, 0xCDE3, 0xCDE3}, {0xCDE4, 0xCDE4, 0xCDE4},
    {0xCDE5, 0xCDE5, 0xCDE5}, {0xCDE6, 0xCDE6, 0xCDE6},
    {0xCDE7, 0xCDE7, 0xCDE7}, {0xCDE8, 0xCDE8, 0xCDE8},
    {0xCDE9, 0xCDE9, 0xCDE9}, {0xCDEA, 0xCDEA, 0xCDEA},
    {0xCDEB, 0xCDEB, 0xCDEB}, {0xCDEC, 0xCDEC, 0xCDEC},
    {0xCDED, 0xCDED, 0xCDED}, {0xCDEE, 0xCDEE, 0xCDEE},
    {0xCDEF, 0xCDEF, 0xCDEF}, {0xCDF0, 0xCDF0, 0xCDF0},
    {0xCDF1, 0xCDF1, 0xCDF1}, {0xCDF2, 0xCDF2, 0xCDF2},
    {0xCDF3, 0xCDF3, 0xCDF3}, {0xCDF4, 0xCDF4, 0xCDF4},
    {0xCDF5, 0xCDF5, 0xCDF5}, {0xCDF6, 0xCDF6, 0xCDF6},
    {0xCDF7, 0xCDF7, 0xCDF7}, {0xCDF8, 0xCDF8, 0xCDF8},
    {0xCDF9, 0xCDF9, 0xCDF9}, {0xCDFA, 0xCDFA, 0xCDFA},
    {0xCDFB, 0xCDFB, 0xCDFB}, {0xCDFC, 0xCDFC, 0xCDFC},
    {0xCDFD, 0xCDFD, 0xCDFD}, {0xCDFE, 0xCDFE, 0xCDFE},
    {0xCDFF, 0xCDFF, 0xCDFF}, {0xCE00, 0xCE00, 0xCE00},
    {0xCE01, 0xCE01, 0xCE01}, {0xCE02, 0xCE02, 0xCE02},
    {0xCE03, 0xCE03, 0xCE03}, {0xCE04, 0xCE04, 0xCE04},
    {0xCE05, 0xCE05, 0xCE05}, {0xCE06, 0xCE06, 0xCE06},
    {0xCE07, 0xCE07, 0xCE07}, {0xCE08, 0xCE08, 0xCE08},
    {0xCE09, 0xCE09, 0xCE09}, {0xCE0A, 0xCE0A, 0xCE0A},
    {0xCE0B, 0xCE0B, 0xCE0B}, {0xCE0C, 0xCE0C, 0xCE0C},
    {0xCE0D, 0xCE0D, 0xCE0D}, {0xCE0E, 0xCE0E, 0xCE0E},
    {0xCE0F, 0xCE0F, 0xCE0F}, {0xCE10, 0xCE10, 0xCE10},
    {0xCE11, 0xCE11, 0xCE11}, {0xCE12, 0xCE12, 0xCE12},
    {0xCE13, 0xCE13, 0xCE13}, {0xCE14, 0xCE14, 0xCE14},
    {0xCE15, 0xCE15, 0xCE15}, {0xCE16, 0xCE16, 0xCE16},
    {0xCE17, 0xCE17, 0xCE17}, {0xCE18, 0xCE18, 0xCE18},
    {0xCE19, 0xCE19, 0xCE19}, {0xCE1A, 0xCE1A, 0xCE1A},
    {0xCE1B, 0xCE1B, 0xCE1B}, {0xCE1C, 0xCE1C, 0xCE1C},
    {0xCE1D, 0xCE1D, 0xCE1D}, {0xCE1E, 0xCE1E, 0xCE1E},
    {0xCE1F, 0xCE1F, 0xCE1F}, {0xCE20, 0xCE20, 0xCE20},
    {0xCE21, 0xCE21, 0xCE21}, {0xCE22, 0xCE22, 0xCE22},
    {0xCE23, 0xCE23, 0xCE23}, {0xCE24, 0xCE24, 0xCE24},
    {0xCE25, 0xCE25, 0xCE25}, {0xCE26, 0xCE26, 0xCE26},
    {0xCE27, 0xCE27, 0xCE27}, {0xCE28, 0xCE28, 0xCE28},
    {0xCE29, 0xCE29, 0xCE29}, {0xCE2A, 0xCE2A, 0xCE2A},
    {0xCE2B, 0xCE2B, 0xCE2B}, {0xCE2C, 0xCE2C, 0xCE2C},
    {0xCE2D, 0xCE2D, 0xCE2D}, {0xCE2E, 0xCE2E, 0xCE2E},
    {0xCE2F, 0xCE2F, 0xCE2F}, {0xCE30, 0xCE30, 0xCE30},
    {0xCE31, 0xCE31, 0xCE31}, {0xCE32, 0xCE32, 0xCE32},
    {0xCE33, 0xCE33, 0xCE33}, {0xCE34, 0xCE34, 0xCE34},
    {0xCE35, 0xCE35, 0xCE35}, {0xCE36, 0xCE36, 0xCE36},
    {0xCE37, 0xCE37, 0xCE37}, {0xCE38, 0xCE38, 0xCE38},
    {0xCE39, 0xCE39, 0xCE39}, {0xCE3A, 0xCE3A, 0xCE3A},
    {0xCE3B, 0xCE3B, 0xCE3B}, {0xCE3C, 0xCE3C, 0xCE3C},
    {0xCE3D, 0xCE3D, 0xCE3D}, {0xCE3E, 0xCE3E, 0xCE3E},
    {0xCE3F, 0xCE3F, 0xCE3F}, {0xCE40, 0xCE40, 0xCE40},
    {0xCE41, 0xCE41, 0xCE41}, {0xCE42, 0xCE42, 0xCE42},
    {0xCE43, 0xCE43, 0xCE43}, {0xCE44, 0xCE44, 0xCE44},
    {0xCE45, 0xCE45, 0xCE45}, {0xCE46, 0xCE46, 0xCE46},
    {0xCE47, 0xCE47, 0xCE47}, {0xCE48, 0xCE48, 0xCE48},
    {0xCE49, 0xCE49, 0xCE49}, {0xCE4A, 0xCE4A, 0xCE4A},
    {0xCE4B, 0xCE4B, 0xCE4B}, {0xCE4C, 0xCE4C, 0xCE4C},
    {0xCE4D, 0xCE4D, 0xCE4D}, {0xCE4E, 0xCE4E, 0xCE4E},
    {0xCE4F, 0xCE4F, 0xCE4F}, {0xCE50, 0xCE50, 0xCE50},
    {0xCE51, 0xCE51, 0xCE51}, {0xCE52, 0xCE52, 0xCE52},
    {0xCE53, 0xCE53, 0xCE53}, {0xCE54, 0xCE54, 0xCE54},
    {0xCE55, 0xCE55, 0xCE55}, {0xCE56, 0xCE56, 0xCE56},
    {0xCE57, 0xCE57, 0xCE57}, {0xCE58, 0xCE58, 0xCE58},
    {0xCE59, 0xCE59, 0xCE59}, {0xCE5A, 0xCE5A, 0xCE5A},
    {0xCE5B, 0xCE5B, 0xCE5B}, {0xCE5C, 0xCE5C, 0xCE5C},
    {0xCE5D, 0xCE5D, 0xCE5D}, {0xCE5E, 0xCE5E, 0xCE5E},
    {0xCE5F, 0xCE5F, 0xCE5F}, {0xCE60, 0xCE60, 0xCE60},
    {0xCE61, 0xCE61, 0xCE61}, {0xCE62, 0xCE62, 0xCE62},
    {0xCE63, 0xCE63, 0xCE63}, {0xCE64, 0xCE64, 0xCE64},
    {0xCE65, 0xCE65, 0xCE65}, {0xCE66, 0xCE66, 0xCE66},
    {0xCE67, 0xCE67, 0xCE67}, {0xCE68, 0xCE68, 0xCE68},
    {0xCE69, 0xCE69, 0xCE69}, {0xCE6A, 0xCE6A, 0xCE6A},
    {0xCE6B, 0xCE6B, 0xCE6B}, {0xCE6C, 0xCE6C, 0xCE6C},
    {0xCE6D, 0xCE6D, 0xCE6D}, {0xCE6E, 0xCE6E, 0xCE6E},
    {0xCE6F, 0xCE6F, 0xCE6F}, {0xCE70, 0xCE70, 0xCE70},
    {0xCE71, 0xCE71, 0xCE71}, {0xCE72, 0xCE72, 0xCE72},
    {0xCE73, 0xCE73, 0xCE73}, {0xCE74, 0xCE74, 0xCE74},
    {0xCE75, 0xCE75, 0xCE75}, {0xCE76, 0xCE76, 0xCE76},
    {0xCE77, 0xCE77, 0xCE77}, {0xCE78, 0xCE78, 0xCE78},
    {0xCE79, 0xCE79, 0xCE79}, {0xCE7A, 0xCE7A, 0xCE7A},
    {0xCE7B, 0xCE7B, 0xCE7B}, {0xCE7C, 0xCE7C, 0xCE7C},
    {0xCE7D, 0xCE7D, 0xCE7D}, {0xCE7E, 0xCE7E, 0xCE7E},
    {0xCE7F, 0xCE7F, 0xCE7F}, {0xCE80, 0xCE80, 0xCE80},
    {0xCE81, 0xCE81, 0xCE81}, {0xCE82, 0xCE82, 0xCE82},
    {0xCE83, 0xCE83, 0xCE83}, {0xCE84, 0xCE84, 0xCE84},
    {0xCE85, 0xCE85, 0xCE85}, {0xCE86, 0xCE86, 0xCE86},
    {0xCE87, 0xCE87, 0xCE87}, {0xCE88, 0xCE88, 0xCE88},
    {0xCE89, 0xCE89, 0xCE89}, {0xCE8A, 0xCE8A, 0xCE8A},
    {0xCE8B, 0xCE8B, 0xCE8B}, {0xCE8C, 0xCE8C, 0xCE8C},
    {0xCE8D, 0xCE8D, 0xCE8D}, {0xCE8E, 0xCE8E, 0xCE8E},
    {0xCE8F, 0xCE8F, 0xCE8F}, {0xCE90, 0xCE90, 0xCE90},
    {0xCE91, 0xCE91, 0xCE91}, {0xCE92, 0xCE92, 0xCE92},
    {0xCE93, 0xCE93, 0xCE93}, {0xCE94, 0xCE94, 0xCE94},
    {0xCE95, 0xCE95, 0xCE95}, {0xCE96, 0xCE96, 0xCE96},
    {0xCE97, 0xCE97, 0xCE97}, {0xCE98, 0xCE98, 0xCE98},
    {0xCE99, 0xCE99, 0xCE99}, {0xCE9A, 0xCE9A, 0xCE9A},
    {0xCE9B, 0xCE9B, 0xCE9B}, {0xCE9C, 0xCE9C, 0xCE9C},
    {0xCE9D, 0xCE9D, 0xCE9D}, {0xCE9E, 0xCE9E, 0xCE9E},
    {0xCE9F, 0xCE9F, 0xCE9F}, {0xCEA0, 0xCEA0, 0xCEA0},
    {0xCEA1, 0xCEA1, 0xCEA1}, {0xCEA2, 0xCEA2, 0xCEA2},
    {0xCEA3, 0xCEA3, 0xCEA3}, {0xCEA4, 0xCEA4, 0xCEA4},
    {0xCEA5, 0xCEA5, 0xCEA5}, {0xCEA6, 0xCEA6, 0xCEA6},
    {0xCEA7, 0xCEA7, 0xCEA7}, {0xCEA8, 0xCEA8, 0xCEA8},
    {0xCEA9, 0xCEA9, 0xCEA9}, {0xCEAA, 0xCEAA, 0xCEAA},
    {0xCEAB, 0xCEAB, 0xCEAB}, {0xCEAC, 0xCEAC, 0xCEAC},
    {0xCEAD, 0xCEAD, 0xCEAD}, {0xCEAE, 0xCEAE, 0xCEAE},
    {0xCEAF, 0xCEAF, 0xCEAF}, {0xCEB0, 0xCEB0, 0xCEB0},
    {0xCEB1, 0xCEB1, 0xCEB1}, {0xCEB2, 0xCEB2, 0xCEB2},
    {0xCEB3, 0xCEB3, 0xCEB3}, {0xCEB4, 0xCEB4, 0xCEB4},
    {0xCEB5, 0xCEB5, 0xCEB5}, {0xCEB6, 0xCEB6, 0xCEB6},
    {0xCEB7, 0xCEB7, 0xCEB7}, {0xCEB8, 0xCEB8, 0xCEB8},
    {0xCEB9, 0xCEB9, 0xCEB9}, {0xCEBA, 0xCEBA, 0xCEBA},
    {0xCEBB, 0xCEBB, 0xCEBB}, {0xCEBC, 0xCEBC, 0xCEBC},
    {0xCEBD, 0xCEBD, 0xCEBD}, {0xCEBE, 0xCEBE, 0xCEBE},
    {0xCEBF, 0xCEBF, 0xCEBF}, {0xCEC0, 0xCEC0, 0xCEC0},
    {0xCEC1, 0xCEC1, 0xCEC1}, {0xCEC2, 0xCEC2, 0xCEC2},
    {0xCEC3, 0xCEC3, 0xCEC3}, {0xCEC4, 0xCEC4, 0xCEC4},
    {0xCEC5, 0xCEC5, 0xCEC5}, {0xCEC6, 0xCEC6, 0xCEC6},
    {0xCEC7, 0xCEC7, 0xCEC7}, {0xCEC8, 0xCEC8, 0xCEC8},
    {0xCEC9, 0xCEC9, 0xCEC9}, {0xCECA, 0xCECA, 0xCECA},
    {0xCECB, 0xCECB, 0xCECB}, {0xCECC, 0xCECC, 0xCECC},
    {0xCECD, 0xCECD, 0xCECD}, {0xCECE, 0xCECE, 0xCECE},
    {0xCECF, 0xCECF, 0xCECF}, {0xCED0, 0xCED0, 0xCED0},
    {0xCED1, 0xCED1, 0xCED1}, {0xCED2, 0xCED2, 0xCED2},
    {0xCED3, 0xCED3, 0xCED3}, {0xCED4, 0xCED4, 0xCED4},
    {0xCED5, 0xCED5, 0xCED5}, {0xCED6, 0xCED6, 0xCED6},
    {0xCED7, 0xCED7, 0xCED7}, {0xCED8, 0xCED8, 0xCED8},
    {0xCED9, 0xCED9, 0xCED9}, {0xCEDA, 0xCEDA, 0xCEDA},
    {0xCEDB, 0xCEDB, 0xCEDB}, {0xCEDC, 0xCEDC, 0xCEDC},
    {0xCEDD, 0xCEDD, 0xCEDD}, {0xCEDE, 0xCEDE, 0xCEDE},
    {0xCEDF, 0xCEDF, 0xCEDF}, {0xCEE0, 0xCEE0, 0xCEE0},
    {0xCEE1, 0xCEE1, 0xCEE1}, {0xCEE2, 0xCEE2, 0xCEE2},
    {0xCEE3, 0xCEE3, 0xCEE3}, {0xCEE4, 0xCEE4, 0xCEE4},
    {0xCEE5, 0xCEE5, 0xCEE5}, {0xCEE6, 0xCEE6, 0xCEE6},
    {0xCEE7, 0xCEE7, 0xCEE7}, {0xCEE8, 0xCEE8, 0xCEE8},
    {0xCEE9, 0xCEE9, 0xCEE9}, {0xCEEA, 0xCEEA, 0xCEEA},
    {0xCEEB, 0xCEEB, 0xCEEB}, {0xCEEC, 0xCEEC, 0xCEEC},
    {0xCEED, 0xCEED, 0xCEED}, {0xCEEE, 0xCEEE, 0xCEEE},
    {0xCEEF, 0xCEEF, 0xCEEF}, {0xCEF0, 0xCEF0, 0xCEF0},
    {0xCEF1, 0xCEF1, 0xCEF1}, {0xCEF2, 0xCEF2, 0xCEF2},
    {0xCEF3, 0xCEF3, 0xCEF3}, {0xCEF4, 0xCEF4, 0xCEF4},
    {0xCEF5, 0xCEF5, 0xCEF5}, {0xCEF6, 0xCEF6, 0xCEF6},
    {0xCEF7, 0xCEF7, 0xCEF7}, {0xCEF8, 0xCEF8, 0xCEF8},
    {0xCEF9, 0xCEF9, 0xCEF9}, {0xCEFA, 0xCEFA, 0xCEFA},
    {0xCEFB, 0xCEFB, 0xCEFB}, {0xCEFC, 0xCEFC, 0xCEFC},
    {0xCEFD, 0xCEFD, 0xCEFD}, {0xCEFE, 0xCEFE, 0xCEFE},
    {0xCEFF, 0xCEFF, 0xCEFF}, {0xCF00, 0xCF00, 0xCF00},
    {0xCF01, 0xCF01, 0xCF01}, {0xCF02, 0xCF02, 0xCF02},
    {0xCF03, 0xCF03, 0xCF03}, {0xCF04, 0xCF04, 0xCF04},
    {0xCF05, 0xCF05, 0xCF05}, {0xCF06, 0xCF06, 0xCF06},
    {0xCF07, 0xCF07, 0xCF07}, {0xCF08, 0xCF08, 0xCF08},
    {0xCF09, 0xCF09, 0xCF09}, {0xCF0A, 0xCF0A, 0xCF0A},
    {0xCF0B, 0xCF0B, 0xCF0B}, {0xCF0C, 0xCF0C, 0xCF0C},
    {0xCF0D, 0xCF0D, 0xCF0D}, {0xCF0E, 0xCF0E, 0xCF0E},
    {0xCF0F, 0xCF0F, 0xCF0F}, {0xCF10, 0xCF10, 0xCF10},
    {0xCF11, 0xCF11, 0xCF11}, {0xCF12, 0xCF12, 0xCF12},
    {0xCF13, 0xCF13, 0xCF13}, {0xCF14, 0xCF14, 0xCF14},
    {0xCF15, 0xCF15, 0xCF15}, {0xCF16, 0xCF16, 0xCF16},
    {0xCF17, 0xCF17, 0xCF17}, {0xCF18, 0xCF18, 0xCF18},
    {0xCF19, 0xCF19, 0xCF19}, {0xCF1A, 0xCF1A, 0xCF1A},
    {0xCF1B, 0xCF1B, 0xCF1B}, {0xCF1C, 0xCF1C, 0xCF1C},
    {0xCF1D, 0xCF1D, 0xCF1D}, {0xCF1E, 0xCF1E, 0xCF1E},
    {0xCF1F, 0xCF1F, 0xCF1F}, {0xCF20, 0xCF20, 0xCF20},
    {0xCF21, 0xCF21, 0xCF21}, {0xCF22, 0xCF22, 0xCF22},
    {0xCF23, 0xCF23, 0xCF23}, {0xCF24, 0xCF24, 0xCF24},
    {0xCF25, 0xCF25, 0xCF25}, {0xCF26, 0xCF26, 0xCF26},
    {0xCF27, 0xCF27, 0xCF27}, {0xCF28, 0xCF28, 0xCF28},
    {0xCF29, 0xCF29, 0xCF29}, {0xCF2A, 0xCF2A, 0xCF2A},
    {0xCF2B, 0xCF2B, 0xCF2B}, {0xCF2C, 0xCF2C, 0xCF2C},
    {0xCF2D, 0xCF2D, 0xCF2D}, {0xCF2E, 0xCF2E, 0xCF2E},
    {0xCF2F, 0xCF2F, 0xCF2F}, {0xCF30, 0xCF30, 0xCF30},
    {0xCF31, 0xCF31, 0xCF31}, {0xCF32, 0xCF32, 0xCF32},
    {0xCF33, 0xCF33, 0xCF33}, {0xCF34, 0xCF34, 0xCF34},
    {0xCF35, 0xCF35, 0xCF35}, {0xCF36, 0xCF36, 0xCF36},
    {0xCF37, 0xCF37, 0xCF37}, {0xCF38, 0xCF38, 0xCF38},
    {0xCF39, 0xCF39, 0xCF39}, {0xCF3A, 0xCF3A, 0xCF3A},
    {0xCF3B, 0xCF3B, 0xCF3B}, {0xCF3C, 0xCF3C, 0xCF3C},
    {0xCF3D, 0xCF3D, 0xCF3D}, {0xCF3E, 0xCF3E, 0xCF3E},
    {0xCF3F, 0xCF3F, 0xCF3F}, {0xCF40, 0xCF40, 0xCF40},
    {0xCF41, 0xCF41, 0xCF41}, {0xCF42, 0xCF42, 0xCF42},
    {0xCF43, 0xCF43, 0xCF43}, {0xCF44, 0xCF44, 0xCF44},
    {0xCF45, 0xCF45, 0xCF45}, {0xCF46, 0xCF46, 0xCF46},
    {0xCF47, 0xCF47, 0xCF47}, {0xCF48, 0xCF48, 0xCF48},
    {0xCF49, 0xCF49, 0xCF49}, {0xCF4A, 0xCF4A, 0xCF4A},
    {0xCF4B, 0xCF4B, 0xCF4B}, {0xCF4C, 0xCF4C, 0xCF4C},
    {0xCF4D, 0xCF4D, 0xCF4D}, {0xCF4E, 0xCF4E, 0xCF4E},
    {0xCF4F, 0xCF4F, 0xCF4F}, {0xCF50, 0xCF50, 0xCF50},
    {0xCF51, 0xCF51, 0xCF51}, {0xCF52, 0xCF52, 0xCF52},
    {0xCF53, 0xCF53, 0xCF53}, {0xCF54, 0xCF54, 0xCF54},
    {0xCF55, 0xCF55, 0xCF55}, {0xCF56, 0xCF56, 0xCF56},
    {0xCF57, 0xCF57, 0xCF57}, {0xCF58, 0xCF58, 0xCF58},
    {0xCF59, 0xCF59, 0xCF59}, {0xCF5A, 0xCF5A, 0xCF5A},
    {0xCF5B, 0xCF5B, 0xCF5B}, {0xCF5C, 0xCF5C, 0xCF5C},
    {0xCF5D, 0xCF5D, 0xCF5D}, {0xCF5E, 0xCF5E, 0xCF5E},
    {0xCF5F, 0xCF5F, 0xCF5F}, {0xCF60, 0xCF60, 0xCF60},
    {0xCF61, 0xCF61, 0xCF61}, {0xCF62, 0xCF62, 0xCF62},
    {0xCF63, 0xCF63, 0xCF63}, {0xCF64, 0xCF64, 0xCF64},
    {0xCF65, 0xCF65, 0xCF65}, {0xCF66, 0xCF66, 0xCF66},
    {0xCF67, 0xCF67, 0xCF67}, {0xCF68, 0xCF68, 0xCF68},
    {0xCF69, 0xCF69, 0xCF69}, {0xCF6A, 0xCF6A, 0xCF6A},
    {0xCF6B, 0xCF6B, 0xCF6B}, {0xCF6C, 0xCF6C, 0xCF6C},
    {0xCF6D, 0xCF6D, 0xCF6D}, {0xCF6E, 0xCF6E, 0xCF6E},
    {0xCF6F, 0xCF6F, 0xCF6F}, {0xCF70, 0xCF70, 0xCF70},
    {0xCF71, 0xCF71, 0xCF71}, {0xCF72, 0xCF72, 0xCF72},
    {0xCF73, 0xCF73, 0xCF73}, {0xCF74, 0xCF74, 0xCF74},
    {0xCF75, 0xCF75, 0xCF75}, {0xCF76, 0xCF76, 0xCF76},
    {0xCF77, 0xCF77, 0xCF77}, {0xCF78, 0xCF78, 0xCF78},
    {0xCF79, 0xCF79, 0xCF79}, {0xCF7A, 0xCF7A, 0xCF7A},
    {0xCF7B, 0xCF7B, 0xCF7B}, {0xCF7C, 0xCF7C, 0xCF7C},
    {0xCF7D, 0xCF7D, 0xCF7D}, {0xCF7E, 0xCF7E, 0xCF7E},
    {0xCF7F, 0xCF7F, 0xCF7F}, {0xCF80, 0xCF80, 0xCF80},
    {0xCF81, 0xCF81, 0xCF81}, {0xCF82, 0xCF82, 0xCF82},
    {0xCF83, 0xCF83, 0xCF83}, {0xCF84, 0xCF84, 0xCF84},
    {0xCF85, 0xCF85, 0xCF85}, {0xCF86, 0xCF86, 0xCF86},
    {0xCF87, 0xCF87, 0xCF87}, {0xCF88, 0xCF88, 0xCF88},
    {0xCF89, 0xCF89, 0xCF89}, {0xCF8A, 0xCF8A, 0xCF8A},
    {0xCF8B, 0xCF8B, 0xCF8B}, {0xCF8C, 0xCF8C, 0xCF8C},
    {0xCF8D, 0xCF8D, 0xCF8D}, {0xCF8E, 0xCF8E, 0xCF8E},
    {0xCF8F, 0xCF8F, 0xCF8F}, {0xCF90, 0xCF90, 0xCF90},
    {0xCF91, 0xCF91, 0xCF91}, {0xCF92, 0xCF92, 0xCF92},
    {0xCF93, 0xCF93, 0xCF93}, {0xCF94, 0xCF94, 0xCF94},
    {0xCF95, 0xCF95, 0xCF95}, {0xCF96, 0xCF96, 0xCF96},
    {0xCF97, 0xCF97, 0xCF97}, {0xCF98, 0xCF98, 0xCF98},
    {0xCF99, 0xCF99, 0xCF99}, {0xCF9A, 0xCF9A, 0xCF9A},
    {0xCF9B, 0xCF9B, 0xCF9B}, {0xCF9C, 0xCF9C, 0xCF9C},
    {0xCF9D, 0xCF9D, 0xCF9D}, {0xCF9E, 0xCF9E, 0xCF9E},
    {0xCF9F, 0xCF9F, 0xCF9F}, {0xCFA0, 0xCFA0, 0xCFA0},
    {0xCFA1, 0xCFA1, 0xCFA1}, {0xCFA2, 0xCFA2, 0xCFA2},
    {0xCFA3, 0xCFA3, 0xCFA3}, {0xCFA4, 0xCFA4, 0xCFA4},
    {0xCFA5, 0xCFA5, 0xCFA5}, {0xCFA6, 0xCFA6, 0xCFA6},
    {0xCFA7, 0xCFA7, 0xCFA7}, {0xCFA8, 0xCFA8, 0xCFA8},
    {0xCFA9, 0xCFA9, 0xCFA9}, {0xCFAA, 0xCFAA, 0xCFAA},
    {0xCFAB, 0xCFAB, 0xCFAB}, {0xCFAC, 0xCFAC, 0xCFAC},
    {0xCFAD, 0xCFAD, 0xCFAD}, {0xCFAE, 0xCFAE, 0xCFAE},
    {0xCFAF, 0xCFAF, 0xCFAF}, {0xCFB0, 0xCFB0, 0xCFB0},
    {0xCFB1, 0xCFB1, 0xCFB1}, {0xCFB2, 0xCFB2, 0xCFB2},
    {0xCFB3, 0xCFB3, 0xCFB3}, {0xCFB4, 0xCFB4, 0xCFB4},
    {0xCFB5, 0xCFB5, 0xCFB5}, {0xCFB6, 0xCFB6, 0xCFB6},
    {0xCFB7, 0xCFB7, 0xCFB7}, {0xCFB8, 0xCFB8, 0xCFB8},
    {0xCFB9, 0xCFB9, 0xCFB9}, {0xCFBA, 0xCFBA, 0xCFBA},
    {0xCFBB, 0xCFBB, 0xCFBB}, {0xCFBC, 0xCFBC, 0xCFBC},
    {0xCFBD, 0xCFBD, 0xCFBD}, {0xCFBE, 0xCFBE, 0xCFBE},
    {0xCFBF, 0xCFBF, 0xCFBF}, {0xCFC0, 0xCFC0, 0xCFC0},
    {0xCFC1, 0xCFC1, 0xCFC1}, {0xCFC2, 0xCFC2, 0xCFC2},
    {0xCFC3, 0xCFC3, 0xCFC3}, {0xCFC4, 0xCFC4, 0xCFC4},
    {0xCFC5, 0xCFC5, 0xCFC5}, {0xCFC6, 0xCFC6, 0xCFC6},
    {0xCFC7, 0xCFC7, 0xCFC7}, {0xCFC8, 0xCFC8, 0xCFC8},
    {0xCFC9, 0xCFC9, 0xCFC9}, {0xCFCA, 0xCFCA, 0xCFCA},
    {0xCFCB, 0xCFCB, 0xCFCB}, {0xCFCC, 0xCFCC, 0xCFCC},
    {0xCFCD, 0xCFCD, 0xCFCD}, {0xCFCE, 0xCFCE, 0xCFCE},
    {0xCFCF, 0xCFCF, 0xCFCF}, {0xCFD0, 0xCFD0, 0xCFD0},
    {0xCFD1, 0xCFD1, 0xCFD1}, {0xCFD2, 0xCFD2, 0xCFD2},
    {0xCFD3, 0xCFD3, 0xCFD3}, {0xCFD4, 0xCFD4, 0xCFD4},
    {0xCFD5, 0xCFD5, 0xCFD5}, {0xCFD6, 0xCFD6, 0xCFD6},
    {0xCFD7, 0xCFD7, 0xCFD7}, {0xCFD8, 0xCFD8, 0xCFD8},
    {0xCFD9, 0xCFD9, 0xCFD9}, {0xCFDA, 0xCFDA, 0xCFDA},
    {0xCFDB, 0xCFDB, 0xCFDB}, {0xCFDC, 0xCFDC, 0xCFDC},
    {0xCFDD, 0xCFDD, 0xCFDD}, {0xCFDE, 0xCFDE, 0xCFDE},
    {0xCFDF, 0xCFDF, 0xCFDF}, {0xCFE0, 0xCFE0, 0xCFE0},
    {0xCFE1, 0xCFE1, 0xCFE1}, {0xCFE2, 0xCFE2, 0xCFE2},
    {0xCFE3, 0xCFE3, 0xCFE3}, {0xCFE4, 0xCFE4, 0xCFE4},
    {0xCFE5, 0xCFE5, 0xCFE5}, {0xCFE6, 0xCFE6, 0xCFE6},
    {0xCFE7, 0xCFE7, 0xCFE7}, {0xCFE8, 0xCFE8, 0xCFE8},
    {0xCFE9, 0xCFE9, 0xCFE9}, {0xCFEA, 0xCFEA, 0xCFEA},
    {0xCFEB, 0xCFEB, 0xCFEB}, {0xCFEC, 0xCFEC, 0xCFEC},
    {0xCFED, 0xCFED, 0xCFED}, {0xCFEE, 0xCFEE, 0xCFEE},
    {0xCFEF, 0xCFEF, 0xCFEF}, {0xCFF0, 0xCFF0, 0xCFF0},
    {0xCFF1, 0xCFF1, 0xCFF1}, {0xCFF2, 0xCFF2, 0xCFF2},
    {0xCFF3, 0xCFF3, 0xCFF3}, {0xCFF4, 0xCFF4, 0xCFF4},
    {0xCFF5, 0xCFF5, 0xCFF5}, {0xCFF6, 0xCFF6, 0xCFF6},
    {0xCFF7, 0xCFF7, 0xCFF7}, {0xCFF8, 0xCFF8, 0xCFF8},
    {0xCFF9, 0xCFF9, 0xCFF9}, {0xCFFA, 0xCFFA, 0xCFFA},
    {0xCFFB, 0xCFFB, 0xCFFB}, {0xCFFC, 0xCFFC, 0xCFFC},
    {0xCFFD, 0xCFFD, 0xCFFD}, {0xCFFE, 0xCFFE, 0xCFFE},
    {0xCFFF, 0xCFFF, 0xCFFF}, {0xD000, 0xD000, 0xD000},
    {0xD001, 0xD001, 0xD001}, {0xD002, 0xD002, 0xD002},
    {0xD003, 0xD003, 0xD003}, {0xD004, 0xD004, 0xD004},
    {0xD005, 0xD005, 0xD005}, {0xD006, 0xD006, 0xD006},
    {0xD007, 0xD007, 0xD007}, {0xD008, 0xD008, 0xD008},
    {0xD009, 0xD009, 0xD009}, {0xD00A, 0xD00A, 0xD00A},
    {0xD00B, 0xD00B, 0xD00B}, {0xD00C, 0xD00C, 0xD00C},
    {0xD00D, 0xD00D, 0xD00D}, {0xD00E, 0xD00E, 0xD00E},
    {0xD00F, 0xD00F, 0xD00F}, {0xD010, 0xD010, 0xD010},
    {0xD011, 0xD011, 0xD011}, {0xD012, 0xD012, 0xD012},
    {0xD013, 0xD013, 0xD013}, {0xD014, 0xD014, 0xD014},
    {0xD015, 0xD015, 0xD015}, {0xD016, 0xD016, 0xD016},
    {0xD017, 0xD017, 0xD017}, {0xD018, 0xD018, 0xD018},
    {0xD019, 0xD019, 0xD019}, {0xD01A, 0xD01A, 0xD01A},
    {0xD01B, 0xD01B, 0xD01B}, {0xD01C, 0xD01C, 0xD01C},
    {0xD01D, 0xD01D, 0xD01D}, {0xD01E, 0xD01E, 0xD01E},
    {0xD01F, 0xD01F, 0xD01F}, {0xD020, 0xD020, 0xD020},
    {0xD021, 0xD021, 0xD021}, {0xD022, 0xD022, 0xD022},
    {0xD023, 0xD023, 0xD023}, {0xD024, 0xD024, 0xD024},
    {0xD025, 0xD025, 0xD025}, {0xD026, 0xD026, 0xD026},
    {0xD027, 0xD027, 0xD027}, {0xD028, 0xD028, 0xD028},
    {0xD029, 0xD029, 0xD029}, {0xD02A, 0xD02A, 0xD02A},
    {0xD02B, 0xD02B, 0xD02B}, {0xD02C, 0xD02C, 0xD02C},
    {0xD02D, 0xD02D, 0xD02D}, {0xD02E, 0xD02E, 0xD02E},
    {0xD02F, 0xD02F, 0xD02F}, {0xD030, 0xD030, 0xD030},
    {0xD031, 0xD031, 0xD031}, {0xD032, 0xD032, 0xD032},
    {0xD033, 0xD033, 0xD033}, {0xD034, 0xD034, 0xD034},
    {0xD035, 0xD035, 0xD035}, {0xD036, 0xD036, 0xD036},
    {0xD037, 0xD037, 0xD037}, {0xD038, 0xD038, 0xD038},
    {0xD039, 0xD039, 0xD039}, {0xD03A, 0xD03A, 0xD03A},
    {0xD03B, 0xD03B, 0xD03B}, {0xD03C, 0xD03C, 0xD03C},
    {0xD03D, 0xD03D, 0xD03D}, {0xD03E, 0xD03E, 0xD03E},
    {0xD03F, 0xD03F, 0xD03F}, {0xD040, 0xD040, 0xD040},
    {0xD041, 0xD041, 0xD041}, {0xD042, 0xD042, 0xD042},
    {0xD043, 0xD043, 0xD043}, {0xD044, 0xD044, 0xD044},
    {0xD045, 0xD045, 0xD045}, {0xD046, 0xD046, 0xD046},
    {0xD047, 0xD047, 0xD047}, {0xD048, 0xD048, 0xD048},
    {0xD049, 0xD049, 0xD049}, {0xD04A, 0xD04A, 0xD04A},
    {0xD04B, 0xD04B, 0xD04B}, {0xD04C, 0xD04C, 0xD04C},
    {0xD04D, 0xD04D, 0xD04D}, {0xD04E, 0xD04E, 0xD04E},
    {0xD04F, 0xD04F, 0xD04F}, {0xD050, 0xD050, 0xD050},
    {0xD051, 0xD051, 0xD051}, {0xD052, 0xD052, 0xD052},
    {0xD053, 0xD053, 0xD053}, {0xD054, 0xD054, 0xD054},
    {0xD055, 0xD055, 0xD055}, {0xD056, 0xD056, 0xD056},
    {0xD057, 0xD057, 0xD057}, {0xD058, 0xD058, 0xD058},
    {0xD059, 0xD059, 0xD059}, {0xD05A, 0xD05A, 0xD05A},
    {0xD05B, 0xD05B, 0xD05B}, {0xD05C, 0xD05C, 0xD05C},
    {0xD05D, 0xD05D, 0xD05D}, {0xD05E, 0xD05E, 0xD05E},
    {0xD05F, 0xD05F, 0xD05F}, {0xD060, 0xD060, 0xD060},
    {0xD061, 0xD061, 0xD061}, {0xD062, 0xD062, 0xD062},
    {0xD063, 0xD063, 0xD063}, {0xD064, 0xD064, 0xD064},
    {0xD065, 0xD065, 0xD065}, {0xD066, 0xD066, 0xD066},
    {0xD067, 0xD067, 0xD067}, {0xD068, 0xD068, 0xD068},
    {0xD069, 0xD069, 0xD069}, {0xD06A, 0xD06A, 0xD06A},
    {0xD06B, 0xD06B, 0xD06B}, {0xD06C, 0xD06C, 0xD06C},
    {0xD06D, 0xD06D, 0xD06D}, {0xD06E, 0xD06E, 0xD06E},
    {0xD06F, 0xD06F, 0xD06F}, {0xD070, 0xD070, 0xD070},
    {0xD071, 0xD071, 0xD071}, {0xD072, 0xD072, 0xD072},
    {0xD073, 0xD073, 0xD073}, {0xD074, 0xD074, 0xD074},
    {0xD075, 0xD075, 0xD075}, {0xD076, 0xD076, 0xD076},
    {0xD077, 0xD077, 0xD077}, {0xD078, 0xD078, 0xD078},
    {0xD079, 0xD079, 0xD079}, {0xD07A, 0xD07A, 0xD07A},
    {0xD07B, 0xD07B, 0xD07B}, {0xD07C, 0xD07C, 0xD07C},
    {0xD07D, 0xD07D, 0xD07D}, {0xD07E, 0xD07E, 0xD07E},
    {0xD07F, 0xD07F, 0xD07F}, {0xD080, 0xD080, 0xD080},
    {0xD081, 0xD081, 0xD081}, {0xD082, 0xD082, 0xD082},
    {0xD083, 0xD083, 0xD083}, {0xD084, 0xD084, 0xD084},
    {0xD085, 0xD085, 0xD085}, {0xD086, 0xD086, 0xD086},
    {0xD087, 0xD087, 0xD087}, {0xD088, 0xD088, 0xD088},
    {0xD089, 0xD089, 0xD089}, {0xD08A, 0xD08A, 0xD08A},
    {0xD08B, 0xD08B, 0xD08B}, {0xD08C, 0xD08C, 0xD08C},
    {0xD08D, 0xD08D, 0xD08D}, {0xD08E, 0xD08E, 0xD08E},
    {0xD08F, 0xD08F, 0xD08F}, {0xD090, 0xD090, 0xD090},
    {0xD091, 0xD091, 0xD091}, {0xD092, 0xD092, 0xD092},
    {0xD093, 0xD093, 0xD093}, {0xD094, 0xD094, 0xD094},
    {0xD095, 0xD095, 0xD095}, {0xD096, 0xD096, 0xD096},
    {0xD097, 0xD097, 0xD097}, {0xD098, 0xD098, 0xD098},
    {0xD099, 0xD099, 0xD099}, {0xD09A, 0xD09A, 0xD09A},
    {0xD09B, 0xD09B, 0xD09B}, {0xD09C, 0xD09C, 0xD09C},
    {0xD09D, 0xD09D, 0xD09D}, {0xD09E, 0xD09E, 0xD09E},
    {0xD09F, 0xD09F, 0xD09F}, {0xD0A0, 0xD0A0, 0xD0A0},
    {0xD0A1, 0xD0A1, 0xD0A1}, {0xD0A2, 0xD0A2, 0xD0A2},
    {0xD0A3, 0xD0A3, 0xD0A3}, {0xD0A4, 0xD0A4, 0xD0A4},
    {0xD0A5, 0xD0A5, 0xD0A5}, {0xD0A6, 0xD0A6, 0xD0A6},
    {0xD0A7, 0xD0A7, 0xD0A7}, {0xD0A8, 0xD0A8, 0xD0A8},
    {0xD0A9, 0xD0A9, 0xD0A9}, {0xD0AA, 0xD0AA, 0xD0AA},
    {0xD0AB, 0xD0AB, 0xD0AB}, {0xD0AC, 0xD0AC, 0xD0AC},
    {0xD0AD, 0xD0AD, 0xD0AD}, {0xD0AE, 0xD0AE, 0xD0AE},
    {0xD0AF, 0xD0AF, 0xD0AF}, {0xD0B0, 0xD0B0, 0xD0B0},
    {0xD0B1, 0xD0B1, 0xD0B1}, {0xD0B2, 0xD0B2, 0xD0B2},
    {0xD0B3, 0xD0B3, 0xD0B3}, {0xD0B4, 0xD0B4, 0xD0B4},
    {0xD0B5, 0xD0B5, 0xD0B5}, {0xD0B6, 0xD0B6, 0xD0B6},
    {0xD0B7, 0xD0B7, 0xD0B7}, {0xD0B8, 0xD0B8, 0xD0B8},
    {0xD0B9, 0xD0B9, 0xD0B9}, {0xD0BA, 0xD0BA, 0xD0BA},
    {0xD0BB, 0xD0BB, 0xD0BB}, {0xD0BC, 0xD0BC, 0xD0BC},
    {0xD0BD, 0xD0BD, 0xD0BD}, {0xD0BE, 0xD0BE, 0xD0BE},
    {0xD0BF, 0xD0BF, 0xD0BF}, {0xD0C0, 0xD0C0, 0xD0C0},
    {0xD0C1, 0xD0C1, 0xD0C1}, {0xD0C2, 0xD0C2, 0xD0C2},
    {0xD0C3, 0xD0C3, 0xD0C3}, {0xD0C4, 0xD0C4, 0xD0C4},
    {0xD0C5, 0xD0C5, 0xD0C5}, {0xD0C6, 0xD0C6, 0xD0C6},
    {0xD0C7, 0xD0C7, 0xD0C7}, {0xD0C8, 0xD0C8, 0xD0C8},
    {0xD0C9, 0xD0C9, 0xD0C9}, {0xD0CA, 0xD0CA, 0xD0CA},
    {0xD0CB, 0xD0CB, 0xD0CB}, {0xD0CC, 0xD0CC, 0xD0CC},
    {0xD0CD, 0xD0CD, 0xD0CD}, {0xD0CE, 0xD0CE, 0xD0CE},
    {0xD0CF, 0xD0CF, 0xD0CF}, {0xD0D0, 0xD0D0, 0xD0D0},
    {0xD0D1, 0xD0D1, 0xD0D1}, {0xD0D2, 0xD0D2, 0xD0D2},
    {0xD0D3, 0xD0D3, 0xD0D3}, {0xD0D4, 0xD0D4, 0xD0D4},
    {0xD0D5, 0xD0D5, 0xD0D5}, {0xD0D6, 0xD0D6, 0xD0D6},
    {0xD0D7, 0xD0D7, 0xD0D7}, {0xD0D8, 0xD0D8, 0xD0D8},
    {0xD0D9, 0xD0D9, 0xD0D9}, {0xD0DA, 0xD0DA, 0xD0DA},
    {0xD0DB, 0xD0DB, 0xD0DB}, {0xD0DC, 0xD0DC, 0xD0DC},
    {0xD0DD, 0xD0DD, 0xD0DD}, {0xD0DE, 0xD0DE, 0xD0DE},
    {0xD0DF, 0xD0DF, 0xD0DF}, {0xD0E0, 0xD0E0, 0xD0E0},
    {0xD0E1, 0xD0E1, 0xD0E1}, {0xD0E2, 0xD0E2, 0xD0E2},
    {0xD0E3, 0xD0E3, 0xD0E3}, {0xD0E4, 0xD0E4, 0xD0E4},
    {0xD0E5, 0xD0E5, 0xD0E5}, {0xD0E6, 0xD0E6, 0xD0E6},
    {0xD0E7, 0xD0E7, 0xD0E7}, {0xD0E8, 0xD0E8, 0xD0E8},
    {0xD0E9, 0xD0E9, 0xD0E9}, {0xD0EA, 0xD0EA, 0xD0EA},
    {0xD0EB, 0xD0EB, 0xD0EB}, {0xD0EC, 0xD0EC, 0xD0EC},
    {0xD0ED, 0xD0ED, 0xD0ED}, {0xD0EE, 0xD0EE, 0xD0EE},
    {0xD0EF, 0xD0EF, 0xD0EF}, {0xD0F0, 0xD0F0, 0xD0F0},
    {0xD0F1, 0xD0F1, 0xD0F1}, {0xD0F2, 0xD0F2, 0xD0F2},
    {0xD0F3, 0xD0F3, 0xD0F3}, {0xD0F4, 0xD0F4, 0xD0F4},
    {0xD0F5, 0xD0F5, 0xD0F5}, {0xD0F6, 0xD0F6, 0xD0F6},
    {0xD0F7, 0xD0F7, 0xD0F7}, {0xD0F8, 0xD0F8, 0xD0F8},
    {0xD0F9, 0xD0F9, 0xD0F9}, {0xD0FA, 0xD0FA, 0xD0FA},
    {0xD0FB, 0xD0FB, 0xD0FB}, {0xD0FC, 0xD0FC, 0xD0FC},
    {0xD0FD, 0xD0FD, 0xD0FD}, {0xD0FE, 0xD0FE, 0xD0FE},
    {0xD0FF, 0xD0FF, 0xD0FF}, {0xD100, 0xD100, 0xD100},
    {0xD101, 0xD101, 0xD101}, {0xD102, 0xD102, 0xD102},
    {0xD103, 0xD103, 0xD103}, {0xD104, 0xD104, 0xD104},
    {0xD105, 0xD105, 0xD105}, {0xD106, 0xD106, 0xD106},
    {0xD107, 0xD107, 0xD107}, {0xD108, 0xD108, 0xD108},
    {0xD109, 0xD109, 0xD109}, {0xD10A, 0xD10A, 0xD10A},
    {0xD10B, 0xD10B, 0xD10B}, {0xD10C, 0xD10C, 0xD10C},
    {0xD10D, 0xD10D, 0xD10D}, {0xD10E, 0xD10E, 0xD10E},
    {0xD10F, 0xD10F, 0xD10F}, {0xD110, 0xD110, 0xD110},
    {0xD111, 0xD111, 0xD111}, {0xD112, 0xD112, 0xD112},
    {0xD113, 0xD113, 0xD113}, {0xD114, 0xD114, 0xD114},
    {0xD115, 0xD115, 0xD115}, {0xD116, 0xD116, 0xD116},
    {0xD117, 0xD117, 0xD117}, {0xD118, 0xD118, 0xD118},
    {0xD119, 0xD119, 0xD119}, {0xD11A, 0xD11A, 0xD11A},
    {0xD11B, 0xD11B, 0xD11B}, {0xD11C, 0xD11C, 0xD11C},
    {0xD11D, 0xD11D, 0xD11D}, {0xD11E, 0xD11E, 0xD11E},
    {0xD11F, 0xD11F, 0xD11F}, {0xD120, 0xD120, 0xD120},
    {0xD121, 0xD121, 0xD121}, {0xD122, 0xD122, 0xD122},
    {0xD123, 0xD123, 0xD123}, {0xD124, 0xD124, 0xD124},
    {0xD125, 0xD125, 0xD125}, {0xD126, 0xD126, 0xD126},
    {0xD127, 0xD127, 0xD127}, {0xD128, 0xD128, 0xD128},
    {0xD129, 0xD129, 0xD129}, {0xD12A, 0xD12A, 0xD12A},
    {0xD12B, 0xD12B, 0xD12B}, {0xD12C, 0xD12C, 0xD12C},
    {0xD12D, 0xD12D, 0xD12D}, {0xD12E, 0xD12E, 0xD12E},
    {0xD12F, 0xD12F, 0xD12F}, {0xD130, 0xD130, 0xD130},
    {0xD131, 0xD131, 0xD131}, {0xD132, 0xD132, 0xD132},
    {0xD133, 0xD133, 0xD133}, {0xD134, 0xD134, 0xD134},
    {0xD135, 0xD135, 0xD135}, {0xD136, 0xD136, 0xD136},
    {0xD137, 0xD137, 0xD137}, {0xD138, 0xD138, 0xD138},
    {0xD139, 0xD139, 0xD139}, {0xD13A, 0xD13A, 0xD13A},
    {0xD13B, 0xD13B, 0xD13B}, {0xD13C, 0xD13C, 0xD13C},
    {0xD13D, 0xD13D, 0xD13D}, {0xD13E, 0xD13E, 0xD13E},
    {0xD13F, 0xD13F, 0xD13F}, {0xD140, 0xD140, 0xD140},
    {0xD141, 0xD141, 0xD141}, {0xD142, 0xD142, 0xD142},
    {0xD143, 0xD143, 0xD143}, {0xD144, 0xD144, 0xD144},
    {0xD145, 0xD145, 0xD145}, {0xD146, 0xD146, 0xD146},
    {0xD147, 0xD147, 0xD147}, {0xD148, 0xD148, 0xD148},
    {0xD149, 0xD149, 0xD149}, {0xD14A, 0xD14A, 0xD14A},
    {0xD14B, 0xD14B, 0xD14B}, {0xD14C, 0xD14C, 0xD14C},
    {0xD14D, 0xD14D, 0xD14D}, {0xD14E, 0xD14E, 0xD14E},
    {0xD14F, 0xD14F, 0xD14F}, {0xD150, 0xD150, 0xD150},
    {0xD151, 0xD151, 0xD151}, {0xD152, 0xD152, 0xD152},
    {0xD153, 0xD153, 0xD153}, {0xD154, 0xD154, 0xD154},
    {0xD155, 0xD155, 0xD155}, {0xD156, 0xD156, 0xD156},
    {0xD157, 0xD157, 0xD157}, {0xD158, 0xD158, 0xD158},
    {0xD159, 0xD159, 0xD159}, {0xD15A, 0xD15A, 0xD15A},
    {0xD15B, 0xD15B, 0xD15B}, {0xD15C, 0xD15C, 0xD15C},
    {0xD15D, 0xD15D, 0xD15D}, {0xD15E, 0xD15E, 0xD15E},
    {0xD15F, 0xD15F, 0xD15F}, {0xD160, 0xD160, 0xD160},
    {0xD161, 0xD161, 0xD161}, {0xD162, 0xD162, 0xD162},
    {0xD163, 0xD163, 0xD163}, {0xD164, 0xD164, 0xD164},
    {0xD165, 0xD165, 0xD165}, {0xD166, 0xD166, 0xD166},
    {0xD167, 0xD167, 0xD167}, {0xD168, 0xD168, 0xD168},
    {0xD169, 0xD169, 0xD169}, {0xD16A, 0xD16A, 0xD16A},
    {0xD16B, 0xD16B, 0xD16B}, {0xD16C, 0xD16C, 0xD16C},
    {0xD16D, 0xD16D, 0xD16D}, {0xD16E, 0xD16E, 0xD16E},
    {0xD16F, 0xD16F, 0xD16F}, {0xD170, 0xD170, 0xD170},
    {0xD171, 0xD171, 0xD171}, {0xD172, 0xD172, 0xD172},
    {0xD173, 0xD173, 0xD173}, {0xD174, 0xD174, 0xD174},
    {0xD175, 0xD175, 0xD175}, {0xD176, 0xD176, 0xD176},
    {0xD177, 0xD177, 0xD177}, {0xD178, 0xD178, 0xD178},
    {0xD179, 0xD179, 0xD179}, {0xD17A, 0xD17A, 0xD17A},
    {0xD17B, 0xD17B, 0xD17B}, {0xD17C, 0xD17C, 0xD17C},
    {0xD17D, 0xD17D, 0xD17D}, {0xD17E, 0xD17E, 0xD17E},
    {0xD17F, 0xD17F, 0xD17F}, {0xD180, 0xD180, 0xD180},
    {0xD181, 0xD181, 0xD181}, {0xD182, 0xD182, 0xD182},
    {0xD183, 0xD183, 0xD183}, {0xD184, 0xD184, 0xD184},
    {0xD185, 0xD185, 0xD185}, {0xD186, 0xD186, 0xD186},
    {0xD187, 0xD187, 0xD187}, {0xD188, 0xD188, 0xD188},
    {0xD189, 0xD189, 0xD189}, {0xD18A, 0xD18A, 0xD18A},
    {0xD18B, 0xD18B, 0xD18B}, {0xD18C, 0xD18C, 0xD18C},
    {0xD18D, 0xD18D, 0xD18D}, {0xD18E, 0xD18E, 0xD18E},
    {0xD18F, 0xD18F, 0xD18F}, {0xD190, 0xD190, 0xD190},
    {0xD191, 0xD191, 0xD191}, {0xD192, 0xD192, 0xD192},
    {0xD193, 0xD193, 0xD193}, {0xD194, 0xD194, 0xD194},
    {0xD195, 0xD195, 0xD195}, {0xD196, 0xD196, 0xD196},
    {0xD197, 0xD197, 0xD197}, {0xD198, 0xD198, 0xD198},
    {0xD199, 0xD199, 0xD199}, {0xD19A, 0xD19A, 0xD19A},
    {0xD19B, 0xD19B, 0xD19B}, {0xD19C, 0xD19C, 0xD19C},
    {0xD19D, 0xD19D, 0xD19D}, {0xD19E, 0xD19E, 0xD19E},
    {0xD19F, 0xD19F, 0xD19F}, {0xD1A0, 0xD1A0, 0xD1A0},
    {0xD1A1, 0xD1A1, 0xD1A1}, {0xD1A2, 0xD1A2, 0xD1A2},
    {0xD1A3, 0xD1A3, 0xD1A3}, {0xD1A4, 0xD1A4, 0xD1A4},
    {0xD1A5, 0xD1A5, 0xD1A5}, {0xD1A6, 0xD1A6, 0xD1A6},
    {0xD1A7, 0xD1A7, 0xD1A7}, {0xD1A8, 0xD1A8, 0xD1A8},
    {0xD1A9, 0xD1A9, 0xD1A9}, {0xD1AA, 0xD1AA, 0xD1AA},
    {0xD1AB, 0xD1AB, 0xD1AB}, {0xD1AC, 0xD1AC, 0xD1AC},
    {0xD1AD, 0xD1AD, 0xD1AD}, {0xD1AE, 0xD1AE, 0xD1AE},
    {0xD1AF, 0xD1AF, 0xD1AF}, {0xD1B0, 0xD1B0, 0xD1B0},
    {0xD1B1, 0xD1B1, 0xD1B1}, {0xD1B2, 0xD1B2, 0xD1B2},
    {0xD1B3, 0xD1B3, 0xD1B3}, {0xD1B4, 0xD1B4, 0xD1B4},
    {0xD1B5, 0xD1B5, 0xD1B5}, {0xD1B6, 0xD1B6, 0xD1B6},
    {0xD1B7, 0xD1B7, 0xD1B7}, {0xD1B8, 0xD1B8, 0xD1B8},
    {0xD1B9, 0xD1B9, 0xD1B9}, {0xD1BA, 0xD1BA, 0xD1BA},
    {0xD1BB, 0xD1BB, 0xD1BB}, {0xD1BC, 0xD1BC, 0xD1BC},
    {0xD1BD, 0xD1BD, 0xD1BD}, {0xD1BE, 0xD1BE, 0xD1BE},
    {0xD1BF, 0xD1BF, 0xD1BF}, {0xD1C0, 0xD1C0, 0xD1C0},
    {0xD1C1, 0xD1C1, 0xD1C1}, {0xD1C2, 0xD1C2, 0xD1C2},
    {0xD1C3, 0xD1C3, 0xD1C3}, {0xD1C4, 0xD1C4, 0xD1C4},
    {0xD1C5, 0xD1C5, 0xD1C5}, {0xD1C6, 0xD1C6, 0xD1C6},
    {0xD1C7, 0xD1C7, 0xD1C7}, {0xD1C8, 0xD1C8, 0xD1C8},
    {0xD1C9, 0xD1C9, 0xD1C9}, {0xD1CA, 0xD1CA, 0xD1CA},
    {0xD1CB, 0xD1CB, 0xD1CB}, {0xD1CC, 0xD1CC, 0xD1CC},
    {0xD1CD, 0xD1CD, 0xD1CD}, {0xD1CE, 0xD1CE, 0xD1CE},
    {0xD1CF, 0xD1CF, 0xD1CF}, {0xD1D0, 0xD1D0, 0xD1D0},
    {0xD1D1, 0xD1D1, 0xD1D1}, {0xD1D2, 0xD1D2, 0xD1D2},
    {0xD1D3, 0xD1D3, 0xD1D3}, {0xD1D4, 0xD1D4, 0xD1D4},
    {0xD1D5, 0xD1D5, 0xD1D5}, {0xD1D6, 0xD1D6, 0xD1D6},
    {0xD1D7, 0xD1D7, 0xD1D7}, {0xD1D8, 0xD1D8, 0xD1D8},
    {0xD1D9, 0xD1D9, 0xD1D9}, {0xD1DA, 0xD1DA, 0xD1DA},
    {0xD1DB, 0xD1DB, 0xD1DB}, {0xD1DC, 0xD1DC, 0xD1DC},
    {0xD1DD, 0xD1DD, 0xD1DD}, {0xD1DE, 0xD1DE, 0xD1DE},
    {0xD1DF, 0xD1DF, 0xD1DF}, {0xD1E0, 0xD1E0, 0xD1E0},
    {0xD1E1, 0xD1E1, 0xD1E1}, {0xD1E2, 0xD1E2, 0xD1E2},
    {0xD1E3, 0xD1E3, 0xD1E3}, {0xD1E4, 0xD1E4, 0xD1E4},
    {0xD1E5, 0xD1E5, 0xD1E5}, {0xD1E6, 0xD1E6, 0xD1E6},
    {0xD1E7, 0xD1E7, 0xD1E7}, {0xD1E8, 0xD1E8, 0xD1E8},
    {0xD1E9, 0xD1E9, 0xD1E9}, {0xD1EA, 0xD1EA, 0xD1EA},
    {0xD1EB, 0xD1EB, 0xD1EB}, {0xD1EC, 0xD1EC, 0xD1EC},
    {0xD1ED, 0xD1ED, 0xD1ED}, {0xD1EE, 0xD1EE, 0xD1EE},
    {0xD1EF, 0xD1EF, 0xD1EF}, {0xD1F0, 0xD1F0, 0xD1F0},
    {0xD1F1, 0xD1F1, 0xD1F1}, {0xD1F2, 0xD1F2, 0xD1F2},
    {0xD1F3, 0xD1F3, 0xD1F3}, {0xD1F4, 0xD1F4, 0xD1F4},
    {0xD1F5, 0xD1F5, 0xD1F5}, {0xD1F6, 0xD1F6, 0xD1F6},
    {0xD1F7, 0xD1F7, 0xD1F7}, {0xD1F8, 0xD1F8, 0xD1F8},
    {0xD1F9, 0xD1F9, 0xD1F9}, {0xD1FA, 0xD1FA, 0xD1FA},
    {0xD1FB, 0xD1FB, 0xD1FB}, {0xD1FC, 0xD1FC, 0xD1FC},
    {0xD1FD, 0xD1FD, 0xD1FD}, {0xD1FE, 0xD1FE, 0xD1FE},
    {0xD1FF, 0xD1FF, 0xD1FF}, {0xD200, 0xD200, 0xD200},
    {0xD201, 0xD201, 0xD201}, {0xD202, 0xD202, 0xD202},
    {0xD203, 0xD203, 0xD203}, {0xD204, 0xD204, 0xD204},
    {0xD205, 0xD205, 0xD205}, {0xD206, 0xD206, 0xD206},
    {0xD207, 0xD207, 0xD207}, {0xD208, 0xD208, 0xD208},
    {0xD209, 0xD209, 0xD209}, {0xD20A, 0xD20A, 0xD20A},
    {0xD20B, 0xD20B, 0xD20B}, {0xD20C, 0xD20C, 0xD20C},
    {0xD20D, 0xD20D, 0xD20D}, {0xD20E, 0xD20E, 0xD20E},
    {0xD20F, 0xD20F, 0xD20F}, {0xD210, 0xD210, 0xD210},
    {0xD211, 0xD211, 0xD211}, {0xD212, 0xD212, 0xD212},
    {0xD213, 0xD213, 0xD213}, {0xD214, 0xD214, 0xD214},
    {0xD215, 0xD215, 0xD215}, {0xD216, 0xD216, 0xD216},
    {0xD217, 0xD217, 0xD217}, {0xD218, 0xD218, 0xD218},
    {0xD219, 0xD219, 0xD219}, {0xD21A, 0xD21A, 0xD21A},
    {0xD21B, 0xD21B, 0xD21B}, {0xD21C, 0xD21C, 0xD21C},
    {0xD21D, 0xD21D, 0xD21D}, {0xD21E, 0xD21E, 0xD21E},
    {0xD21F, 0xD21F, 0xD21F}, {0xD220, 0xD220, 0xD220},
    {0xD221, 0xD221, 0xD221}, {0xD222, 0xD222, 0xD222},
    {0xD223, 0xD223, 0xD223}, {0xD224, 0xD224, 0xD224},
    {0xD225, 0xD225, 0xD225}, {0xD226, 0xD226, 0xD226},
    {0xD227, 0xD227, 0xD227}, {0xD228, 0xD228, 0xD228},
    {0xD229, 0xD229, 0xD229}, {0xD22A, 0xD22A, 0xD22A},
    {0xD22B, 0xD22B, 0xD22B}, {0xD22C, 0xD22C, 0xD22C},
    {0xD22D, 0xD22D, 0xD22D}, {0xD22E, 0xD22E, 0xD22E},
    {0xD22F, 0xD22F, 0xD22F}, {0xD230, 0xD230, 0xD230},
    {0xD231, 0xD231, 0xD231}, {0xD232, 0xD232, 0xD232},
    {0xD233, 0xD233, 0xD233}, {0xD234, 0xD234, 0xD234},
    {0xD235, 0xD235, 0xD235}, {0xD236, 0xD236, 0xD236},
    {0xD237, 0xD237, 0xD237}, {0xD238, 0xD238, 0xD238},
    {0xD239, 0xD239, 0xD239}, {0xD23A, 0xD23A, 0xD23A},
    {0xD23B, 0xD23B, 0xD23B}, {0xD23C, 0xD23C, 0xD23C},
    {0xD23D, 0xD23D, 0xD23D}, {0xD23E, 0xD23E, 0xD23E},
    {0xD23F, 0xD23F, 0xD23F}, {0xD240, 0xD240, 0xD240},
    {0xD241, 0xD241, 0xD241}, {0xD242, 0xD242, 0xD242},
    {0xD243, 0xD243, 0xD243}, {0xD244, 0xD244, 0xD244},
    {0xD245, 0xD245, 0xD245}, {0xD246, 0xD246, 0xD246},
    {0xD247, 0xD247, 0xD247}, {0xD248, 0xD248, 0xD248},
    {0xD249, 0xD249, 0xD249}, {0xD24A, 0xD24A, 0xD24A},
    {0xD24B, 0xD24B, 0xD24B}, {0xD24C, 0xD24C, 0xD24C},
    {0xD24D, 0xD24D, 0xD24D}, {0xD24E, 0xD24E, 0xD24E},
    {0xD24F, 0xD24F, 0xD24F}, {0xD250, 0xD250, 0xD250},
    {0xD251, 0xD251, 0xD251}, {0xD252, 0xD252, 0xD252},
    {0xD253, 0xD253, 0xD253}, {0xD254, 0xD254, 0xD254},
    {0xD255, 0xD255, 0xD255}, {0xD256, 0xD256, 0xD256},
    {0xD257, 0xD257, 0xD257}, {0xD258, 0xD258, 0xD258},
    {0xD259, 0xD259, 0xD259}, {0xD25A, 0xD25A, 0xD25A},
    {0xD25B, 0xD25B, 0xD25B}, {0xD25C, 0xD25C, 0xD25C},
    {0xD25D, 0xD25D, 0xD25D}, {0xD25E, 0xD25E, 0xD25E},
    {0xD25F, 0xD25F, 0xD25F}, {0xD260, 0xD260, 0xD260},
    {0xD261, 0xD261, 0xD261}, {0xD262, 0xD262, 0xD262},
    {0xD263, 0xD263, 0xD263}, {0xD264, 0xD264, 0xD264},
    {0xD265, 0xD265, 0xD265}, {0xD266, 0xD266, 0xD266},
    {0xD267, 0xD267, 0xD267}, {0xD268, 0xD268, 0xD268},
    {0xD269, 0xD269, 0xD269}, {0xD26A, 0xD26A, 0xD26A},
    {0xD26B, 0xD26B, 0xD26B}, {0xD26C, 0xD26C, 0xD26C},
    {0xD26D, 0xD26D, 0xD26D}, {0xD26E, 0xD26E, 0xD26E},
    {0xD26F, 0xD26F, 0xD26F}, {0xD270, 0xD270, 0xD270},
    {0xD271, 0xD271, 0xD271}, {0xD272, 0xD272, 0xD272},
    {0xD273, 0xD273, 0xD273}, {0xD274, 0xD274, 0xD274},
    {0xD275, 0xD275, 0xD275}, {0xD276, 0xD276, 0xD276},
    {0xD277, 0xD277, 0xD277}, {0xD278, 0xD278, 0xD278},
    {0xD279, 0xD279, 0xD279}, {0xD27A, 0xD27A, 0xD27A},
    {0xD27B, 0xD27B, 0xD27B}, {0xD27C, 0xD27C, 0xD27C},
    {0xD27D, 0xD27D, 0xD27D}, {0xD27E, 0xD27E, 0xD27E},
    {0xD27F, 0xD27F, 0xD27F}, {0xD280, 0xD280, 0xD280},
    {0xD281, 0xD281, 0xD281}, {0xD282, 0xD282, 0xD282},
    {0xD283, 0xD283, 0xD283}, {0xD284, 0xD284, 0xD284},
    {0xD285, 0xD285, 0xD285}, {0xD286, 0xD286, 0xD286},
    {0xD287, 0xD287, 0xD287}, {0xD288, 0xD288, 0xD288},
    {0xD289, 0xD289, 0xD289}, {0xD28A, 0xD28A, 0xD28A},
    {0xD28B, 0xD28B, 0xD28B}, {0xD28C, 0xD28C, 0xD28C},
    {0xD28D, 0xD28D, 0xD28D}, {0xD28E, 0xD28E, 0xD28E},
    {0xD28F, 0xD28F, 0xD28F}, {0xD290, 0xD290, 0xD290},
    {0xD291, 0xD291, 0xD291}, {0xD292, 0xD292, 0xD292},
    {0xD293, 0xD293, 0xD293}, {0xD294, 0xD294, 0xD294},
    {0xD295, 0xD295, 0xD295}, {0xD296, 0xD296, 0xD296},
    {0xD297, 0xD297, 0xD297}, {0xD298, 0xD298, 0xD298},
    {0xD299, 0xD299, 0xD299}, {0xD29A, 0xD29A, 0xD29A},
    {0xD29B, 0xD29B, 0xD29B}, {0xD29C, 0xD29C, 0xD29C},
    {0xD29D, 0xD29D, 0xD29D}, {0xD29E, 0xD29E, 0xD29E},
    {0xD29F, 0xD29F, 0xD29F}, {0xD2A0, 0xD2A0, 0xD2A0},
    {0xD2A1, 0xD2A1, 0xD2A1}, {0xD2A2, 0xD2A2, 0xD2A2},
    {0xD2A3, 0xD2A3, 0xD2A3}, {0xD2A4, 0xD2A4, 0xD2A4},
    {0xD2A5, 0xD2A5, 0xD2A5}, {0xD2A6, 0xD2A6, 0xD2A6},
    {0xD2A7, 0xD2A7, 0xD2A7}, {0xD2A8, 0xD2A8, 0xD2A8},
    {0xD2A9, 0xD2A9, 0xD2A9}, {0xD2AA, 0xD2AA, 0xD2AA},
    {0xD2AB, 0xD2AB, 0xD2AB}, {0xD2AC, 0xD2AC, 0xD2AC},
    {0xD2AD, 0xD2AD, 0xD2AD}, {0xD2AE, 0xD2AE, 0xD2AE},
    {0xD2AF, 0xD2AF, 0xD2AF}, {0xD2B0, 0xD2B0, 0xD2B0},
    {0xD2B1, 0xD2B1, 0xD2B1}, {0xD2B2, 0xD2B2, 0xD2B2},
    {0xD2B3, 0xD2B3, 0xD2B3}, {0xD2B4, 0xD2B4, 0xD2B4},
    {0xD2B5, 0xD2B5, 0xD2B5}, {0xD2B6, 0xD2B6, 0xD2B6},
    {0xD2B7, 0xD2B7, 0xD2B7}, {0xD2B8, 0xD2B8, 0xD2B8},
    {0xD2B9, 0xD2B9, 0xD2B9}, {0xD2BA, 0xD2BA, 0xD2BA},
    {0xD2BB, 0xD2BB, 0xD2BB}, {0xD2BC, 0xD2BC, 0xD2BC},
    {0xD2BD, 0xD2BD, 0xD2BD}, {0xD2BE, 0xD2BE, 0xD2BE},
    {0xD2BF, 0xD2BF, 0xD2BF}, {0xD2C0, 0xD2C0, 0xD2C0},
    {0xD2C1, 0xD2C1, 0xD2C1}, {0xD2C2, 0xD2C2, 0xD2C2},
    {0xD2C3, 0xD2C3, 0xD2C3}, {0xD2C4, 0xD2C4, 0xD2C4},
    {0xD2C5, 0xD2C5, 0xD2C5}, {0xD2C6, 0xD2C6, 0xD2C6},
    {0xD2C7, 0xD2C7, 0xD2C7}, {0xD2C8, 0xD2C8, 0xD2C8},
    {0xD2C9, 0xD2C9, 0xD2C9}, {0xD2CA, 0xD2CA, 0xD2CA},
    {0xD2CB, 0xD2CB, 0xD2CB}, {0xD2CC, 0xD2CC, 0xD2CC},
    {0xD2CD, 0xD2CD, 0xD2CD}, {0xD2CE, 0xD2CE, 0xD2CE},
    {0xD2CF, 0xD2CF, 0xD2CF}, {0xD2D0, 0xD2D0, 0xD2D0},
    {0xD2D1, 0xD2D1, 0xD2D1}, {0xD2D2, 0xD2D2, 0xD2D2},
    {0xD2D3, 0xD2D3, 0xD2D3}, {0xD2D4, 0xD2D4, 0xD2D4},
    {0xD2D5, 0xD2D5, 0xD2D5}, {0xD2D6, 0xD2D6, 0xD2D6},
    {0xD2D7, 0xD2D7, 0xD2D7}, {0xD2D8, 0xD2D8, 0xD2D8},
    {0xD2D9, 0xD2D9, 0xD2D9}, {0xD2DA, 0xD2DA, 0xD2DA},
    {0xD2DB, 0xD2DB, 0xD2DB}, {0xD2DC, 0xD2DC, 0xD2DC},
    {0xD2DD, 0xD2DD, 0xD2DD}, {0xD2DE, 0xD2DE, 0xD2DE},
    {0xD2DF, 0xD2DF, 0xD2DF}, {0xD2E0, 0xD2E0, 0xD2E0},
    {0xD2E1, 0xD2E1, 0xD2E1}, {0xD2E2, 0xD2E2, 0xD2E2},
    {0xD2E3, 0xD2E3, 0xD2E3}, {0xD2E4, 0xD2E4, 0xD2E4},
    {0xD2E5, 0xD2E5, 0xD2E5}, {0xD2E6, 0xD2E6, 0xD2E6},
    {0xD2E7, 0xD2E7, 0xD2E7}, {0xD2E8, 0xD2E8, 0xD2E8},
    {0xD2E9, 0xD2E9, 0xD2E9}, {0xD2EA, 0xD2EA, 0xD2EA},
    {0xD2EB, 0xD2EB, 0xD2EB}, {0xD2EC, 0xD2EC, 0xD2EC},
    {0xD2ED, 0xD2ED, 0xD2ED}, {0xD2EE, 0xD2EE, 0xD2EE},
    {0xD2EF, 0xD2EF, 0xD2EF}, {0xD2F0, 0xD2F0, 0xD2F0},
    {0xD2F1, 0xD2F1, 0xD2F1}, {0xD2F2, 0xD2F2, 0xD2F2},
    {0xD2F3, 0xD2F3, 0xD2F3}, {0xD2F4, 0xD2F4, 0xD2F4},
    {0xD2F5, 0xD2F5, 0xD2F5}, {0xD2F6, 0xD2F6, 0xD2F6},
    {0xD2F7, 0xD2F7, 0xD2F7}, {0xD2F8, 0xD2F8, 0xD2F8},
    {0xD2F9, 0xD2F9, 0xD2F9}, {0xD2FA, 0xD2FA, 0xD2FA},
    {0xD2FB, 0xD2FB, 0xD2FB}, {0xD2FC, 0xD2FC, 0xD2FC},
    {0xD2FD, 0xD2FD, 0xD2FD}, {0xD2FE, 0xD2FE, 0xD2FE},
    {0xD2FF, 0xD2FF, 0xD2FF}, {0xD300, 0xD300, 0xD300},
    {0xD301, 0xD301, 0xD301}, {0xD302, 0xD302, 0xD302},
    {0xD303, 0xD303, 0xD303}, {0xD304, 0xD304, 0xD304},
    {0xD305, 0xD305, 0xD305}, {0xD306, 0xD306, 0xD306},
    {0xD307, 0xD307, 0xD307}, {0xD308, 0xD308, 0xD308},
    {0xD309, 0xD309, 0xD309}, {0xD30A, 0xD30A, 0xD30A},
    {0xD30B, 0xD30B, 0xD30B}, {0xD30C, 0xD30C, 0xD30C},
    {0xD30D, 0xD30D, 0xD30D}, {0xD30E, 0xD30E, 0xD30E},
    {0xD30F, 0xD30F, 0xD30F}, {0xD310, 0xD310, 0xD310},
    {0xD311, 0xD311, 0xD311}, {0xD312, 0xD312, 0xD312},
    {0xD313, 0xD313, 0xD313}, {0xD314, 0xD314, 0xD314},
    {0xD315, 0xD315, 0xD315}, {0xD316, 0xD316, 0xD316},
    {0xD317, 0xD317, 0xD317}, {0xD318, 0xD318, 0xD318},
    {0xD319, 0xD319, 0xD319}, {0xD31A, 0xD31A, 0xD31A},
    {0xD31B, 0xD31B, 0xD31B}, {0xD31C, 0xD31C, 0xD31C},
    {0xD31D, 0xD31D, 0xD31D}, {0xD31E, 0xD31E, 0xD31E},
    {0xD31F, 0xD31F, 0xD31F}, {0xD320, 0xD320, 0xD320},
    {0xD321, 0xD321, 0xD321}, {0xD322, 0xD322, 0xD322},
    {0xD323, 0xD323, 0xD323}, {0xD324, 0xD324, 0xD324},
    {0xD325, 0xD325, 0xD325}, {0xD326, 0xD326, 0xD326},
    {0xD327, 0xD327, 0xD327}, {0xD328, 0xD328, 0xD328},
    {0xD329, 0xD329, 0xD329}, {0xD32A, 0xD32A, 0xD32A},
    {0xD32B, 0xD32B, 0xD32B}, {0xD32C, 0xD32C, 0xD32C},
    {0xD32D, 0xD32D, 0xD32D}, {0xD32E, 0xD32E, 0xD32E},
    {0xD32F, 0xD32F, 0xD32F}, {0xD330, 0xD330, 0xD330},
    {0xD331, 0xD331, 0xD331}, {0xD332, 0xD332, 0xD332},
    {0xD333, 0xD333, 0xD333}, {0xD334, 0xD334, 0xD334},
    {0xD335, 0xD335, 0xD335}, {0xD336, 0xD336, 0xD336},
    {0xD337, 0xD337, 0xD337}, {0xD338, 0xD338, 0xD338},
    {0xD339, 0xD339, 0xD339}, {0xD33A, 0xD33A, 0xD33A},
    {0xD33B, 0xD33B, 0xD33B}, {0xD33C, 0xD33C, 0xD33C},
    {0xD33D, 0xD33D, 0xD33D}, {0xD33E, 0xD33E, 0xD33E},
    {0xD33F, 0xD33F, 0xD33F}, {0xD340, 0xD340, 0xD340},
    {0xD341, 0xD341, 0xD341}, {0xD342, 0xD342, 0xD342},
    {0xD343, 0xD343, 0xD343}, {0xD344, 0xD344, 0xD344},
    {0xD345, 0xD345, 0xD345}, {0xD346, 0xD346, 0xD346},
    {0xD347, 0xD347, 0xD347}, {0xD348, 0xD348, 0xD348},
    {0xD349, 0xD349, 0xD349}, {0xD34A, 0xD34A, 0xD34A},
    {0xD34B, 0xD34B, 0xD34B}, {0xD34C, 0xD34C, 0xD34C},
    {0xD34D, 0xD34D, 0xD34D}, {0xD34E, 0xD34E, 0xD34E},
    {0xD34F, 0xD34F, 0xD34F}, {0xD350, 0xD350, 0xD350},
    {0xD351, 0xD351, 0xD351}, {0xD352, 0xD352, 0xD352},
    {0xD353, 0xD353, 0xD353}, {0xD354, 0xD354, 0xD354},
    {0xD355, 0xD355, 0xD355}, {0xD356, 0xD356, 0xD356},
    {0xD357, 0xD357, 0xD357}, {0xD358, 0xD358, 0xD358},
    {0xD359, 0xD359, 0xD359}, {0xD35A, 0xD35A, 0xD35A},
    {0xD35B, 0xD35B, 0xD35B}, {0xD35C, 0xD35C, 0xD35C},
    {0xD35D, 0xD35D, 0xD35D}, {0xD35E, 0xD35E, 0xD35E},
    {0xD35F, 0xD35F, 0xD35F}, {0xD360, 0xD360, 0xD360},
    {0xD361, 0xD361, 0xD361}, {0xD362, 0xD362, 0xD362},
    {0xD363, 0xD363, 0xD363}, {0xD364, 0xD364, 0xD364},
    {0xD365, 0xD365, 0xD365}, {0xD366, 0xD366, 0xD366},
    {0xD367, 0xD367, 0xD367}, {0xD368, 0xD368, 0xD368},
    {0xD369, 0xD369, 0xD369}, {0xD36A, 0xD36A, 0xD36A},
    {0xD36B, 0xD36B, 0xD36B}, {0xD36C, 0xD36C, 0xD36C},
    {0xD36D, 0xD36D, 0xD36D}, {0xD36E, 0xD36E, 0xD36E},
    {0xD36F, 0xD36F, 0xD36F}, {0xD370, 0xD370, 0xD370},
    {0xD371, 0xD371, 0xD371}, {0xD372, 0xD372, 0xD372},
    {0xD373, 0xD373, 0xD373}, {0xD374, 0xD374, 0xD374},
    {0xD375, 0xD375, 0xD375}, {0xD376, 0xD376, 0xD376},
    {0xD377, 0xD377, 0xD377}, {0xD378, 0xD378, 0xD378},
    {0xD379, 0xD379, 0xD379}, {0xD37A, 0xD37A, 0xD37A},
    {0xD37B, 0xD37B, 0xD37B}, {0xD37C, 0xD37C, 0xD37C},
    {0xD37D, 0xD37D, 0xD37D}, {0xD37E, 0xD37E, 0xD37E},
    {0xD37F, 0xD37F, 0xD37F}, {0xD380, 0xD380, 0xD380},
    {0xD381, 0xD381, 0xD381}, {0xD382, 0xD382, 0xD382},
    {0xD383, 0xD383, 0xD383}, {0xD384, 0xD384, 0xD384},
    {0xD385, 0xD385, 0xD385}, {0xD386, 0xD386, 0xD386},
    {0xD387, 0xD387, 0xD387}, {0xD388, 0xD388, 0xD388},
    {0xD389, 0xD389, 0xD389}, {0xD38A, 0xD38A, 0xD38A},
    {0xD38B, 0xD38B, 0xD38B}, {0xD38C, 0xD38C, 0xD38C},
    {0xD38D, 0xD38D, 0xD38D}, {0xD38E, 0xD38E, 0xD38E},
    {0xD38F, 0xD38F, 0xD38F}, {0xD390, 0xD390, 0xD390},
    {0xD391, 0xD391, 0xD391}, {0xD392, 0xD392, 0xD392},
    {0xD393, 0xD393, 0xD393}, {0xD394, 0xD394, 0xD394},
    {0xD395, 0xD395, 0xD395}, {0xD396, 0xD396, 0xD396},
    {0xD397, 0xD397, 0xD397}, {0xD398, 0xD398, 0xD398},
    {0xD399, 0xD399, 0xD399}, {0xD39A, 0xD39A, 0xD39A},
    {0xD39B, 0xD39B, 0xD39B}, {0xD39C, 0xD39C, 0xD39C},
    {0xD39D, 0xD39D, 0xD39D}, {0xD39E, 0xD39E, 0xD39E},
    {0xD39F, 0xD39F, 0xD39F}, {0xD3A0, 0xD3A0, 0xD3A0},
    {0xD3A1, 0xD3A1, 0xD3A1}, {0xD3A2, 0xD3A2, 0xD3A2},
    {0xD3A3, 0xD3A3, 0xD3A3}, {0xD3A4, 0xD3A4, 0xD3A4},
    {0xD3A5, 0xD3A5, 0xD3A5}, {0xD3A6, 0xD3A6, 0xD3A6},
    {0xD3A7, 0xD3A7, 0xD3A7}, {0xD3A8, 0xD3A8, 0xD3A8},
    {0xD3A9, 0xD3A9, 0xD3A9}, {0xD3AA, 0xD3AA, 0xD3AA},
    {0xD3AB, 0xD3AB, 0xD3AB}, {0xD3AC, 0xD3AC, 0xD3AC},
    {0xD3AD, 0xD3AD, 0xD3AD}, {0xD3AE, 0xD3AE, 0xD3AE},
    {0xD3AF, 0xD3AF, 0xD3AF}, {0xD3B0, 0xD3B0, 0xD3B0},
    {0xD3B1, 0xD3B1, 0xD3B1}, {0xD3B2, 0xD3B2, 0xD3B2},
    {0xD3B3, 0xD3B3, 0xD3B3}, {0xD3B4, 0xD3B4, 0xD3B4},
    {0xD3B5, 0xD3B5, 0xD3B5}, {0xD3B6, 0xD3B6, 0xD3B6},
    {0xD3B7, 0xD3B7, 0xD3B7}, {0xD3B8, 0xD3B8, 0xD3B8},
    {0xD3B9, 0xD3B9, 0xD3B9}, {0xD3BA, 0xD3BA, 0xD3BA},
    {0xD3BB, 0xD3BB, 0xD3BB}, {0xD3BC, 0xD3BC, 0xD3BC},
    {0xD3BD, 0xD3BD, 0xD3BD}, {0xD3BE, 0xD3BE, 0xD3BE},
    {0xD3BF, 0xD3BF, 0xD3BF}, {0xD3C0, 0xD3C0, 0xD3C0},
    {0xD3C1, 0xD3C1, 0xD3C1}, {0xD3C2, 0xD3C2, 0xD3C2},
    {0xD3C3, 0xD3C3, 0xD3C3}, {0xD3C4, 0xD3C4, 0xD3C4},
    {0xD3C5, 0xD3C5, 0xD3C5}, {0xD3C6, 0xD3C6, 0xD3C6},
    {0xD3C7, 0xD3C7, 0xD3C7}, {0xD3C8, 0xD3C8, 0xD3C8},
    {0xD3C9, 0xD3C9, 0xD3C9}, {0xD3CA, 0xD3CA, 0xD3CA},
    {0xD3CB, 0xD3CB, 0xD3CB}, {0xD3CC, 0xD3CC, 0xD3CC},
    {0xD3CD, 0xD3CD, 0xD3CD}, {0xD3CE, 0xD3CE, 0xD3CE},
    {0xD3CF, 0xD3CF, 0xD3CF}, {0xD3D0, 0xD3D0, 0xD3D0},
    {0xD3D1, 0xD3D1, 0xD3D1}, {0xD3D2, 0xD3D2, 0xD3D2},
    {0xD3D3, 0xD3D3, 0xD3D3}, {0xD3D4, 0xD3D4, 0xD3D4},
    {0xD3D5, 0xD3D5, 0xD3D5}, {0xD3D6, 0xD3D6, 0xD3D6},
    {0xD3D7, 0xD3D7, 0xD3D7}, {0xD3D8, 0xD3D8, 0xD3D8},
    {0xD3D9, 0xD3D9, 0xD3D9}, {0xD3DA, 0xD3DA, 0xD3DA},
    {0xD3DB, 0xD3DB, 0xD3DB}, {0xD3DC, 0xD3DC, 0xD3DC},
    {0xD3DD, 0xD3DD, 0xD3DD}, {0xD3DE, 0xD3DE, 0xD3DE},
    {0xD3DF, 0xD3DF, 0xD3DF}, {0xD3E0, 0xD3E0, 0xD3E0},
    {0xD3E1, 0xD3E1, 0xD3E1}, {0xD3E2, 0xD3E2, 0xD3E2},
    {0xD3E3, 0xD3E3, 0xD3E3}, {0xD3E4, 0xD3E4, 0xD3E4},
    {0xD3E5, 0xD3E5, 0xD3E5}, {0xD3E6, 0xD3E6, 0xD3E6},
    {0xD3E7, 0xD3E7, 0xD3E7}, {0xD3E8, 0xD3E8, 0xD3E8},
    {0xD3E9, 0xD3E9, 0xD3E9}, {0xD3EA, 0xD3EA, 0xD3EA},
    {0xD3EB, 0xD3EB, 0xD3EB}, {0xD3EC, 0xD3EC, 0xD3EC},
    {0xD3ED, 0xD3ED, 0xD3ED}, {0xD3EE, 0xD3EE, 0xD3EE},
    {0xD3EF, 0xD3EF, 0xD3EF}, {0xD3F0, 0xD3F0, 0xD3F0},
    {0xD3F1, 0xD3F1, 0xD3F1}, {0xD3F2, 0xD3F2, 0xD3F2},
    {0xD3F3, 0xD3F3, 0xD3F3}, {0xD3F4, 0xD3F4, 0xD3F4},
    {0xD3F5, 0xD3F5, 0xD3F5}, {0xD3F6, 0xD3F6, 0xD3F6},
    {0xD3F7, 0xD3F7, 0xD3F7}, {0xD3F8, 0xD3F8, 0xD3F8},
    {0xD3F9, 0xD3F9, 0xD3F9}, {0xD3FA, 0xD3FA, 0xD3FA},
    {0xD3FB, 0xD3FB, 0xD3FB}, {0xD3FC, 0xD3FC, 0xD3FC},
    {0xD3FD, 0xD3FD, 0xD3FD}, {0xD3FE, 0xD3FE, 0xD3FE},
    {0xD3FF, 0xD3FF, 0xD3FF}, {0xD400, 0xD400, 0xD400},
    {0xD401, 0xD401, 0xD401}, {0xD402, 0xD402, 0xD402},
    {0xD403, 0xD403, 0xD403}, {0xD404, 0xD404, 0xD404},
    {0xD405, 0xD405, 0xD405}, {0xD406, 0xD406, 0xD406},
    {0xD407, 0xD407, 0xD407}, {0xD408, 0xD408, 0xD408},
    {0xD409, 0xD409, 0xD409}, {0xD40A, 0xD40A, 0xD40A},
    {0xD40B, 0xD40B, 0xD40B}, {0xD40C, 0xD40C, 0xD40C},
    {0xD40D, 0xD40D, 0xD40D}, {0xD40E, 0xD40E, 0xD40E},
    {0xD40F, 0xD40F, 0xD40F}, {0xD410, 0xD410, 0xD410},
    {0xD411, 0xD411, 0xD411}, {0xD412, 0xD412, 0xD412},
    {0xD413, 0xD413, 0xD413}, {0xD414, 0xD414, 0xD414},
    {0xD415, 0xD415, 0xD415}, {0xD416, 0xD416, 0xD416},
    {0xD417, 0xD417, 0xD417}, {0xD418, 0xD418, 0xD418},
    {0xD419, 0xD419, 0xD419}, {0xD41A, 0xD41A, 0xD41A},
    {0xD41B, 0xD41B, 0xD41B}, {0xD41C, 0xD41C, 0xD41C},
    {0xD41D, 0xD41D, 0xD41D}, {0xD41E, 0xD41E, 0xD41E},
    {0xD41F, 0xD41F, 0xD41F}, {0xD420, 0xD420, 0xD420},
    {0xD421, 0xD421, 0xD421}, {0xD422, 0xD422, 0xD422},
    {0xD423, 0xD423, 0xD423}, {0xD424, 0xD424, 0xD424},
    {0xD425, 0xD425, 0xD425}, {0xD426, 0xD426, 0xD426},
    {0xD427, 0xD427, 0xD427}, {0xD428, 0xD428, 0xD428},
    {0xD429, 0xD429, 0xD429}, {0xD42A, 0xD42A, 0xD42A},
    {0xD42B, 0xD42B, 0xD42B}, {0xD42C, 0xD42C, 0xD42C},
    {0xD42D, 0xD42D, 0xD42D}, {0xD42E, 0xD42E, 0xD42E},
    {0xD42F, 0xD42F, 0xD42F}, {0xD430, 0xD430, 0xD430},
    {0xD431, 0xD431, 0xD431}, {0xD432, 0xD432, 0xD432},
    {0xD433, 0xD433, 0xD433}, {0xD434, 0xD434, 0xD434},
    {0xD435, 0xD435, 0xD435}, {0xD436, 0xD436, 0xD436},
    {0xD437, 0xD437, 0xD437}, {0xD438, 0xD438, 0xD438},
    {0xD439, 0xD439, 0xD439}, {0xD43A, 0xD43A, 0xD43A},
    {0xD43B, 0xD43B, 0xD43B}, {0xD43C, 0xD43C, 0xD43C},
    {0xD43D, 0xD43D, 0xD43D}, {0xD43E, 0xD43E, 0xD43E},
    {0xD43F, 0xD43F, 0xD43F}, {0xD440, 0xD440, 0xD440},
    {0xD441, 0xD441, 0xD441}, {0xD442, 0xD442, 0xD442},
    {0xD443, 0xD443, 0xD443}, {0xD444, 0xD444, 0xD444},
    {0xD445, 0xD445, 0xD445}, {0xD446, 0xD446, 0xD446},
    {0xD447, 0xD447, 0xD447}, {0xD448, 0xD448, 0xD448},
    {0xD449, 0xD449, 0xD449}, {0xD44A, 0xD44A, 0xD44A},
    {0xD44B, 0xD44B, 0xD44B}, {0xD44C, 0xD44C, 0xD44C},
    {0xD44D, 0xD44D, 0xD44D}, {0xD44E, 0xD44E, 0xD44E},
    {0xD44F, 0xD44F, 0xD44F}, {0xD450, 0xD450, 0xD450},
    {0xD451, 0xD451, 0xD451}, {0xD452, 0xD452, 0xD452},
    {0xD453, 0xD453, 0xD453}, {0xD454, 0xD454, 0xD454},
    {0xD455, 0xD455, 0xD455}, {0xD456, 0xD456, 0xD456},
    {0xD457, 0xD457, 0xD457}, {0xD458, 0xD458, 0xD458},
    {0xD459, 0xD459, 0xD459}, {0xD45A, 0xD45A, 0xD45A},
    {0xD45B, 0xD45B, 0xD45B}, {0xD45C, 0xD45C, 0xD45C},
    {0xD45D, 0xD45D, 0xD45D}, {0xD45E, 0xD45E, 0xD45E},
    {0xD45F, 0xD45F, 0xD45F}, {0xD460, 0xD460, 0xD460},
    {0xD461, 0xD461, 0xD461}, {0xD462, 0xD462, 0xD462},
    {0xD463, 0xD463, 0xD463}, {0xD464, 0xD464, 0xD464},
    {0xD465, 0xD465, 0xD465}, {0xD466, 0xD466, 0xD466},
    {0xD467, 0xD467, 0xD467}, {0xD468, 0xD468, 0xD468},
    {0xD469, 0xD469, 0xD469}, {0xD46A, 0xD46A, 0xD46A},
    {0xD46B, 0xD46B, 0xD46B}, {0xD46C, 0xD46C, 0xD46C},
    {0xD46D, 0xD46D, 0xD46D}, {0xD46E, 0xD46E, 0xD46E},
    {0xD46F, 0xD46F, 0xD46F}, {0xD470, 0xD470, 0xD470},
    {0xD471, 0xD471, 0xD471}, {0xD472, 0xD472, 0xD472},
    {0xD473, 0xD473, 0xD473}, {0xD474, 0xD474, 0xD474},
    {0xD475, 0xD475, 0xD475}, {0xD476, 0xD476, 0xD476},
    {0xD477, 0xD477, 0xD477}, {0xD478, 0xD478, 0xD478},
    {0xD479, 0xD479, 0xD479}, {0xD47A, 0xD47A, 0xD47A},
    {0xD47B, 0xD47B, 0xD47B}, {0xD47C, 0xD47C, 0xD47C},
    {0xD47D, 0xD47D, 0xD47D}, {0xD47E, 0xD47E, 0xD47E},
    {0xD47F, 0xD47F, 0xD47F}, {0xD480, 0xD480, 0xD480},
    {0xD481, 0xD481, 0xD481}, {0xD482, 0xD482, 0xD482},
    {0xD483, 0xD483, 0xD483}, {0xD484, 0xD484, 0xD484},
    {0xD485, 0xD485, 0xD485}, {0xD486, 0xD486, 0xD486},
    {0xD487, 0xD487, 0xD487}, {0xD488, 0xD488, 0xD488},
    {0xD489, 0xD489, 0xD489}, {0xD48A, 0xD48A, 0xD48A},
    {0xD48B, 0xD48B, 0xD48B}, {0xD48C, 0xD48C, 0xD48C},
    {0xD48D, 0xD48D, 0xD48D}, {0xD48E, 0xD48E, 0xD48E},
    {0xD48F, 0xD48F, 0xD48F}, {0xD490, 0xD490, 0xD490},
    {0xD491, 0xD491, 0xD491}, {0xD492, 0xD492, 0xD492},
    {0xD493, 0xD493, 0xD493}, {0xD494, 0xD494, 0xD494},
    {0xD495, 0xD495, 0xD495}, {0xD496, 0xD496, 0xD496},
    {0xD497, 0xD497, 0xD497}, {0xD498, 0xD498, 0xD498},
    {0xD499, 0xD499, 0xD499}, {0xD49A, 0xD49A, 0xD49A},
    {0xD49B, 0xD49B, 0xD49B}, {0xD49C, 0xD49C, 0xD49C},
    {0xD49D, 0xD49D, 0xD49D}, {0xD49E, 0xD49E, 0xD49E},
    {0xD49F, 0xD49F, 0xD49F}, {0xD4A0, 0xD4A0, 0xD4A0},
    {0xD4A1, 0xD4A1, 0xD4A1}, {0xD4A2, 0xD4A2, 0xD4A2},
    {0xD4A3, 0xD4A3, 0xD4A3}, {0xD4A4, 0xD4A4, 0xD4A4},
    {0xD4A5, 0xD4A5, 0xD4A5}, {0xD4A6, 0xD4A6, 0xD4A6},
    {0xD4A7, 0xD4A7, 0xD4A7}, {0xD4A8, 0xD4A8, 0xD4A8},
    {0xD4A9, 0xD4A9, 0xD4A9}, {0xD4AA, 0xD4AA, 0xD4AA},
    {0xD4AB, 0xD4AB, 0xD4AB}, {0xD4AC, 0xD4AC, 0xD4AC},
    {0xD4AD, 0xD4AD, 0xD4AD}, {0xD4AE, 0xD4AE, 0xD4AE},
    {0xD4AF, 0xD4AF, 0xD4AF}, {0xD4B0, 0xD4B0, 0xD4B0},
    {0xD4B1, 0xD4B1, 0xD4B1}, {0xD4B2, 0xD4B2, 0xD4B2},
    {0xD4B3, 0xD4B3, 0xD4B3}, {0xD4B4, 0xD4B4, 0xD4B4},
    {0xD4B5, 0xD4B5, 0xD4B5}, {0xD4B6, 0xD4B6, 0xD4B6},
    {0xD4B7, 0xD4B7, 0xD4B7}, {0xD4B8, 0xD4B8, 0xD4B8},
    {0xD4B9, 0xD4B9, 0xD4B9}, {0xD4BA, 0xD4BA, 0xD4BA},
    {0xD4BB, 0xD4BB, 0xD4BB}, {0xD4BC, 0xD4BC, 0xD4BC},
    {0xD4BD, 0xD4BD, 0xD4BD}, {0xD4BE, 0xD4BE, 0xD4BE},
    {0xD4BF, 0xD4BF, 0xD4BF}, {0xD4C0, 0xD4C0, 0xD4C0},
    {0xD4C1, 0xD4C1, 0xD4C1}, {0xD4C2, 0xD4C2, 0xD4C2},
    {0xD4C3, 0xD4C3, 0xD4C3}, {0xD4C4, 0xD4C4, 0xD4C4},
    {0xD4C5, 0xD4C5, 0xD4C5}, {0xD4C6, 0xD4C6, 0xD4C6},
    {0xD4C7, 0xD4C7, 0xD4C7}, {0xD4C8, 0xD4C8, 0xD4C8},
    {0xD4C9, 0xD4C9, 0xD4C9}, {0xD4CA, 0xD4CA, 0xD4CA},
    {0xD4CB, 0xD4CB, 0xD4CB}, {0xD4CC, 0xD4CC, 0xD4CC},
    {0xD4CD, 0xD4CD, 0xD4CD}, {0xD4CE, 0xD4CE, 0xD4CE},
    {0xD4CF, 0xD4CF, 0xD4CF}, {0xD4D0, 0xD4D0, 0xD4D0},
    {0xD4D1, 0xD4D1, 0xD4D1}, {0xD4D2, 0xD4D2, 0xD4D2},
    {0xD4D3, 0xD4D3, 0xD4D3}, {0xD4D4, 0xD4D4, 0xD4D4},
    {0xD4D5, 0xD4D5, 0xD4D5}, {0xD4D6, 0xD4D6, 0xD4D6},
    {0xD4D7, 0xD4D7, 0xD4D7}, {0xD4D8, 0xD4D8, 0xD4D8},
    {0xD4D9, 0xD4D9, 0xD4D9}, {0xD4DA, 0xD4DA, 0xD4DA},
    {0xD4DB, 0xD4DB, 0xD4DB}, {0xD4DC, 0xD4DC, 0xD4DC},
    {0xD4DD, 0xD4DD, 0xD4DD}, {0xD4DE, 0xD4DE, 0xD4DE},
    {0xD4DF, 0xD4DF, 0xD4DF}, {0xD4E0, 0xD4E0, 0xD4E0},
    {0xD4E1, 0xD4E1, 0xD4E1}, {0xD4E2, 0xD4E2, 0xD4E2},
    {0xD4E3, 0xD4E3, 0xD4E3}, {0xD4E4, 0xD4E4, 0xD4E4},
    {0xD4E5, 0xD4E5, 0xD4E5}, {0xD4E6, 0xD4E6, 0xD4E6},
    {0xD4E7, 0xD4E7, 0xD4E7}, {0xD4E8, 0xD4E8, 0xD4E8},
    {0xD4E9, 0xD4E9, 0xD4E9}, {0xD4EA, 0xD4EA, 0xD4EA},
    {0xD4EB, 0xD4EB, 0xD4EB}, {0xD4EC, 0xD4EC, 0xD4EC},
    {0xD4ED, 0xD4ED, 0xD4ED}, {0xD4EE, 0xD4EE, 0xD4EE},
    {0xD4EF, 0xD4EF, 0xD4EF}, {0xD4F0, 0xD4F0, 0xD4F0},
    {0xD4F1, 0xD4F1, 0xD4F1}, {0xD4F2, 0xD4F2, 0xD4F2},
    {0xD4F3, 0xD4F3, 0xD4F3}, {0xD4F4, 0xD4F4, 0xD4F4},
    {0xD4F5, 0xD4F5, 0xD4F5}, {0xD4F6, 0xD4F6, 0xD4F6},
    {0xD4F7, 0xD4F7, 0xD4F7}, {0xD4F8, 0xD4F8, 0xD4F8},
    {0xD4F9, 0xD4F9, 0xD4F9}, {0xD4FA, 0xD4FA, 0xD4FA},
    {0xD4FB, 0xD4FB, 0xD4FB}, {0xD4FC, 0xD4FC, 0xD4FC},
    {0xD4FD, 0xD4FD, 0xD4FD}, {0xD4FE, 0xD4FE, 0xD4FE},
    {0xD4FF, 0xD4FF, 0xD4FF}, {0xD500, 0xD500, 0xD500},
    {0xD501, 0xD501, 0xD501}, {0xD502, 0xD502, 0xD502},
    {0xD503, 0xD503, 0xD503}, {0xD504, 0xD504, 0xD504},
    {0xD505, 0xD505, 0xD505}, {0xD506, 0xD506, 0xD506},
    {0xD507, 0xD507, 0xD507}, {0xD508, 0xD508, 0xD508},
    {0xD509, 0xD509, 0xD509}, {0xD50A, 0xD50A, 0xD50A},
    {0xD50B, 0xD50B, 0xD50B}, {0xD50C, 0xD50C, 0xD50C},
    {0xD50D, 0xD50D, 0xD50D}, {0xD50E, 0xD50E, 0xD50E},
    {0xD50F, 0xD50F, 0xD50F}, {0xD510, 0xD510, 0xD510},
    {0xD511, 0xD511, 0xD511}, {0xD512, 0xD512, 0xD512},
    {0xD513, 0xD513, 0xD513}, {0xD514, 0xD514, 0xD514},
    {0xD515, 0xD515, 0xD515}, {0xD516, 0xD516, 0xD516},
    {0xD517, 0xD517, 0xD517}, {0xD518, 0xD518, 0xD518},
    {0xD519, 0xD519, 0xD519}, {0xD51A, 0xD51A, 0xD51A},
    {0xD51B, 0xD51B, 0xD51B}, {0xD51C, 0xD51C, 0xD51C},
    {0xD51D, 0xD51D, 0xD51D}, {0xD51E, 0xD51E, 0xD51E},
    {0xD51F, 0xD51F, 0xD51F}, {0xD520, 0xD520, 0xD520},
    {0xD521, 0xD521, 0xD521}, {0xD522, 0xD522, 0xD522},
    {0xD523, 0xD523, 0xD523}, {0xD524, 0xD524, 0xD524},
    {0xD525, 0xD525, 0xD525}, {0xD526, 0xD526, 0xD526},
    {0xD527, 0xD527, 0xD527}, {0xD528, 0xD528, 0xD528},
    {0xD529, 0xD529, 0xD529}, {0xD52A, 0xD52A, 0xD52A},
    {0xD52B, 0xD52B, 0xD52B}, {0xD52C, 0xD52C, 0xD52C},
    {0xD52D, 0xD52D, 0xD52D}, {0xD52E, 0xD52E, 0xD52E},
    {0xD52F, 0xD52F, 0xD52F}, {0xD530, 0xD530, 0xD530},
    {0xD531, 0xD531, 0xD531}, {0xD532, 0xD532, 0xD532},
    {0xD533, 0xD533, 0xD533}, {0xD534, 0xD534, 0xD534},
    {0xD535, 0xD535, 0xD535}, {0xD536, 0xD536, 0xD536},
    {0xD537, 0xD537, 0xD537}, {0xD538, 0xD538, 0xD538},
    {0xD539, 0xD539, 0xD539}, {0xD53A, 0xD53A, 0xD53A},
    {0xD53B, 0xD53B, 0xD53B}, {0xD53C, 0xD53C, 0xD53C},
    {0xD53D, 0xD53D, 0xD53D}, {0xD53E, 0xD53E, 0xD53E},
    {0xD53F, 0xD53F, 0xD53F}, {0xD540, 0xD540, 0xD540},
    {0xD541, 0xD541, 0xD541}, {0xD542, 0xD542, 0xD542},
    {0xD543, 0xD543, 0xD543}, {0xD544, 0xD544, 0xD544},
    {0xD545, 0xD545, 0xD545}, {0xD546, 0xD546, 0xD546},
    {0xD547, 0xD547, 0xD547}, {0xD548, 0xD548, 0xD548},
    {0xD549, 0xD549, 0xD549}, {0xD54A, 0xD54A, 0xD54A},
    {0xD54B, 0xD54B, 0xD54B}, {0xD54C, 0xD54C, 0xD54C},
    {0xD54D, 0xD54D, 0xD54D}, {0xD54E, 0xD54E, 0xD54E},
    {0xD54F, 0xD54F, 0xD54F}, {0xD550, 0xD550, 0xD550},
    {0xD551, 0xD551, 0xD551}, {0xD552, 0xD552, 0xD552},
    {0xD553, 0xD553, 0xD553}, {0xD554, 0xD554, 0xD554},
    {0xD555, 0xD555, 0xD555}, {0xD556, 0xD556, 0xD556},
    {0xD557, 0xD557, 0xD557}, {0xD558, 0xD558, 0xD558},
    {0xD559, 0xD559, 0xD559}, {0xD55A, 0xD55A, 0xD55A},
    {0xD55B, 0xD55B, 0xD55B}, {0xD55C, 0xD55C, 0xD55C},
    {0xD55D, 0xD55D, 0xD55D}, {0xD55E, 0xD55E, 0xD55E},
    {0xD55F, 0xD55F, 0xD55F}, {0xD560, 0xD560, 0xD560},
    {0xD561, 0xD561, 0xD561}, {0xD562, 0xD562, 0xD562},
    {0xD563, 0xD563, 0xD563}, {0xD564, 0xD564, 0xD564},
    {0xD565, 0xD565, 0xD565}, {0xD566, 0xD566, 0xD566},
    {0xD567, 0xD567, 0xD567}, {0xD568, 0xD568, 0xD568},
    {0xD569, 0xD569, 0xD569}, {0xD56A, 0xD56A, 0xD56A},
    {0xD56B, 0xD56B, 0xD56B}, {0xD56C, 0xD56C, 0xD56C},
    {0xD56D, 0xD56D, 0xD56D}, {0xD56E, 0xD56E, 0xD56E},
    {0xD56F, 0xD56F, 0xD56F}, {0xD570, 0xD570, 0xD570},
    {0xD571, 0xD571, 0xD571}, {0xD572, 0xD572, 0xD572},
    {0xD573, 0xD573, 0xD573}, {0xD574, 0xD574, 0xD574},
    {0xD575, 0xD575, 0xD575}, {0xD576, 0xD576, 0xD576},
    {0xD577, 0xD577, 0xD577}, {0xD578, 0xD578, 0xD578},
    {0xD579, 0xD579, 0xD579}, {0xD57A, 0xD57A, 0xD57A},
    {0xD57B, 0xD57B, 0xD57B}, {0xD57C, 0xD57C, 0xD57C},
    {0xD57D, 0xD57D, 0xD57D}, {0xD57E, 0xD57E, 0xD57E},
    {0xD57F, 0xD57F, 0xD57F}, {0xD580, 0xD580, 0xD580},
    {0xD581, 0xD581, 0xD581}, {0xD582, 0xD582, 0xD582},
    {0xD583, 0xD583, 0xD583}, {0xD584, 0xD584, 0xD584},
    {0xD585, 0xD585, 0xD585}, {0xD586, 0xD586, 0xD586},
    {0xD587, 0xD587, 0xD587}, {0xD588, 0xD588, 0xD588},
    {0xD589, 0xD589, 0xD589}, {0xD58A, 0xD58A, 0xD58A},
    {0xD58B, 0xD58B, 0xD58B}, {0xD58C, 0xD58C, 0xD58C},
    {0xD58D, 0xD58D, 0xD58D}, {0xD58E, 0xD58E, 0xD58E},
    {0xD58F, 0xD58F, 0xD58F}, {0xD590, 0xD590, 0xD590},
    {0xD591, 0xD591, 0xD591}, {0xD592, 0xD592, 0xD592},
    {0xD593, 0xD593, 0xD593}, {0xD594, 0xD594, 0xD594},
    {0xD595, 0xD595, 0xD595}, {0xD596, 0xD596, 0xD596},
    {0xD597, 0xD597, 0xD597}, {0xD598, 0xD598, 0xD598},
    {0xD599, 0xD599, 0xD599}, {0xD59A, 0xD59A, 0xD59A},
    {0xD59B, 0xD59B, 0xD59B}, {0xD59C, 0xD59C, 0xD59C},
    {0xD59D, 0xD59D, 0xD59D}, {0xD59E, 0xD59E, 0xD59E},
    {0xD59F, 0xD59F, 0xD59F}, {0xD5A0, 0xD5A0, 0xD5A0},
    {0xD5A1, 0xD5A1, 0xD5A1}, {0xD5A2, 0xD5A2, 0xD5A2},
    {0xD5A3, 0xD5A3, 0xD5A3}, {0xD5A4, 0xD5A4, 0xD5A4},
    {0xD5A5, 0xD5A5, 0xD5A5}, {0xD5A6, 0xD5A6, 0xD5A6},
    {0xD5A7, 0xD5A7, 0xD5A7}, {0xD5A8, 0xD5A8, 0xD5A8},
    {0xD5A9, 0xD5A9, 0xD5A9}, {0xD5AA, 0xD5AA, 0xD5AA},
    {0xD5AB, 0xD5AB, 0xD5AB}, {0xD5AC, 0xD5AC, 0xD5AC},
    {0xD5AD, 0xD5AD, 0xD5AD}, {0xD5AE, 0xD5AE, 0xD5AE},
    {0xD5AF, 0xD5AF, 0xD5AF}, {0xD5B0, 0xD5B0, 0xD5B0},
    {0xD5B1, 0xD5B1, 0xD5B1}, {0xD5B2, 0xD5B2, 0xD5B2},
    {0xD5B3, 0xD5B3, 0xD5B3}, {0xD5B4, 0xD5B4, 0xD5B4},
    {0xD5B5, 0xD5B5, 0xD5B5}, {0xD5B6, 0xD5B6, 0xD5B6},
    {0xD5B7, 0xD5B7, 0xD5B7}, {0xD5B8, 0xD5B8, 0xD5B8},
    {0xD5B9, 0xD5B9, 0xD5B9}, {0xD5BA, 0xD5BA, 0xD5BA},
    {0xD5BB, 0xD5BB, 0xD5BB}, {0xD5BC, 0xD5BC, 0xD5BC},
    {0xD5BD, 0xD5BD, 0xD5BD}, {0xD5BE, 0xD5BE, 0xD5BE},
    {0xD5BF, 0xD5BF, 0xD5BF}, {0xD5C0, 0xD5C0, 0xD5C0},
    {0xD5C1, 0xD5C1, 0xD5C1}, {0xD5C2, 0xD5C2, 0xD5C2},
    {0xD5C3, 0xD5C3, 0xD5C3}, {0xD5C4, 0xD5C4, 0xD5C4},
    {0xD5C5, 0xD5C5, 0xD5C5}, {0xD5C6, 0xD5C6, 0xD5C6},
    {0xD5C7, 0xD5C7, 0xD5C7}, {0xD5C8, 0xD5C8, 0xD5C8},
    {0xD5C9, 0xD5C9, 0xD5C9}, {0xD5CA, 0xD5CA, 0xD5CA},
    {0xD5CB, 0xD5CB, 0xD5CB}, {0xD5CC, 0xD5CC, 0xD5CC},
    {0xD5CD, 0xD5CD, 0xD5CD}, {0xD5CE, 0xD5CE, 0xD5CE},
    {0xD5CF, 0xD5CF, 0xD5CF}, {0xD5D0, 0xD5D0, 0xD5D0},
    {0xD5D1, 0xD5D1, 0xD5D1}, {0xD5D2, 0xD5D2, 0xD5D2},
    {0xD5D3, 0xD5D3, 0xD5D3}, {0xD5D4, 0xD5D4, 0xD5D4},
    {0xD5D5, 0xD5D5, 0xD5D5}, {0xD5D6, 0xD5D6, 0xD5D6},
    {0xD5D7, 0xD5D7, 0xD5D7}, {0xD5D8, 0xD5D8, 0xD5D8},
    {0xD5D9, 0xD5D9, 0xD5D9}, {0xD5DA, 0xD5DA, 0xD5DA},
    {0xD5DB, 0xD5DB, 0xD5DB}, {0xD5DC, 0xD5DC, 0xD5DC},
    {0xD5DD, 0xD5DD, 0xD5DD}, {0xD5DE, 0xD5DE, 0xD5DE},
    {0xD5DF, 0xD5DF, 0xD5DF}, {0xD5E0, 0xD5E0, 0xD5E0},
    {0xD5E1, 0xD5E1, 0xD5E1}, {0xD5E2, 0xD5E2, 0xD5E2},
    {0xD5E3, 0xD5E3, 0xD5E3}, {0xD5E4, 0xD5E4, 0xD5E4},
    {0xD5E5, 0xD5E5, 0xD5E5}, {0xD5E6, 0xD5E6, 0xD5E6},
    {0xD5E7, 0xD5E7, 0xD5E7}, {0xD5E8, 0xD5E8, 0xD5E8},
    {0xD5E9, 0xD5E9, 0xD5E9}, {0xD5EA, 0xD5EA, 0xD5EA},
    {0xD5EB, 0xD5EB, 0xD5EB}, {0xD5EC, 0xD5EC, 0xD5EC},
    {0xD5ED, 0xD5ED, 0xD5ED}, {0xD5EE, 0xD5EE, 0xD5EE},
    {0xD5EF, 0xD5EF, 0xD5EF}, {0xD5F0, 0xD5F0, 0xD5F0},
    {0xD5F1, 0xD5F1, 0xD5F1}, {0xD5F2, 0xD5F2, 0xD5F2},
    {0xD5F3, 0xD5F3, 0xD5F3}, {0xD5F4, 0xD5F4, 0xD5F4},
    {0xD5F5, 0xD5F5, 0xD5F5}, {0xD5F6, 0xD5F6, 0xD5F6},
    {0xD5F7, 0xD5F7, 0xD5F7}, {0xD5F8, 0xD5F8, 0xD5F8},
    {0xD5F9, 0xD5F9, 0xD5F9}, {0xD5FA, 0xD5FA, 0xD5FA},
    {0xD5FB, 0xD5FB, 0xD5FB}, {0xD5FC, 0xD5FC, 0xD5FC},
    {0xD5FD, 0xD5FD, 0xD5FD}, {0xD5FE, 0xD5FE, 0xD5FE},
    {0xD5FF, 0xD5FF, 0xD5FF}, {0xD600, 0xD600, 0xD600},
    {0xD601, 0xD601, 0xD601}, {0xD602, 0xD602, 0xD602},
    {0xD603, 0xD603, 0xD603}, {0xD604, 0xD604, 0xD604},
    {0xD605, 0xD605, 0xD605}, {0xD606, 0xD606, 0xD606},
    {0xD607, 0xD607, 0xD607}, {0xD608, 0xD608, 0xD608},
    {0xD609, 0xD609, 0xD609}, {0xD60A, 0xD60A, 0xD60A},
    {0xD60B, 0xD60B, 0xD60B}, {0xD60C, 0xD60C, 0xD60C},
    {0xD60D, 0xD60D, 0xD60D}, {0xD60E, 0xD60E, 0xD60E},
    {0xD60F, 0xD60F, 0xD60F}, {0xD610, 0xD610, 0xD610},
    {0xD611, 0xD611, 0xD611}, {0xD612, 0xD612, 0xD612},
    {0xD613, 0xD613, 0xD613}, {0xD614, 0xD614, 0xD614},
    {0xD615, 0xD615, 0xD615}, {0xD616, 0xD616, 0xD616},
    {0xD617, 0xD617, 0xD617}, {0xD618, 0xD618, 0xD618},
    {0xD619, 0xD619, 0xD619}, {0xD61A, 0xD61A, 0xD61A},
    {0xD61B, 0xD61B, 0xD61B}, {0xD61C, 0xD61C, 0xD61C},
    {0xD61D, 0xD61D, 0xD61D}, {0xD61E, 0xD61E, 0xD61E},
    {0xD61F, 0xD61F, 0xD61F}, {0xD620, 0xD620, 0xD620},
    {0xD621, 0xD621, 0xD621}, {0xD622, 0xD622, 0xD622},
    {0xD623, 0xD623, 0xD623}, {0xD624, 0xD624, 0xD624},
    {0xD625, 0xD625, 0xD625}, {0xD626, 0xD626, 0xD626},
    {0xD627, 0xD627, 0xD627}, {0xD628, 0xD628, 0xD628},
    {0xD629, 0xD629, 0xD629}, {0xD62A, 0xD62A, 0xD62A},
    {0xD62B, 0xD62B, 0xD62B}, {0xD62C, 0xD62C, 0xD62C},
    {0xD62D, 0xD62D, 0xD62D}, {0xD62E, 0xD62E, 0xD62E},
    {0xD62F, 0xD62F, 0xD62F}, {0xD630, 0xD630, 0xD630},
    {0xD631, 0xD631, 0xD631}, {0xD632, 0xD632, 0xD632},
    {0xD633, 0xD633, 0xD633}, {0xD634, 0xD634, 0xD634},
    {0xD635, 0xD635, 0xD635}, {0xD636, 0xD636, 0xD636},
    {0xD637, 0xD637, 0xD637}, {0xD638, 0xD638, 0xD638},
    {0xD639, 0xD639, 0xD639}, {0xD63A, 0xD63A, 0xD63A},
    {0xD63B, 0xD63B, 0xD63B}, {0xD63C, 0xD63C, 0xD63C},
    {0xD63D, 0xD63D, 0xD63D}, {0xD63E, 0xD63E, 0xD63E},
    {0xD63F, 0xD63F, 0xD63F}, {0xD640, 0xD640, 0xD640},
    {0xD641, 0xD641, 0xD641}, {0xD642, 0xD642, 0xD642},
    {0xD643, 0xD643, 0xD643}, {0xD644, 0xD644, 0xD644},
    {0xD645, 0xD645, 0xD645}, {0xD646, 0xD646, 0xD646},
    {0xD647, 0xD647, 0xD647}, {0xD648, 0xD648, 0xD648},
    {0xD649, 0xD649, 0xD649}, {0xD64A, 0xD64A, 0xD64A},
    {0xD64B, 0xD64B, 0xD64B}, {0xD64C, 0xD64C, 0xD64C},
    {0xD64D, 0xD64D, 0xD64D}, {0xD64E, 0xD64E, 0xD64E},
    {0xD64F, 0xD64F, 0xD64F}, {0xD650, 0xD650, 0xD650},
    {0xD651, 0xD651, 0xD651}, {0xD652, 0xD652, 0xD652},
    {0xD653, 0xD653, 0xD653}, {0xD654, 0xD654, 0xD654},
    {0xD655, 0xD655, 0xD655}, {0xD656, 0xD656, 0xD656},
    {0xD657, 0xD657, 0xD657}, {0xD658, 0xD658, 0xD658},
    {0xD659, 0xD659, 0xD659}, {0xD65A, 0xD65A, 0xD65A},
    {0xD65B, 0xD65B, 0xD65B}, {0xD65C, 0xD65C, 0xD65C},
    {0xD65D, 0xD65D, 0xD65D}, {0xD65E, 0xD65E, 0xD65E},
    {0xD65F, 0xD65F, 0xD65F}, {0xD660, 0xD660, 0xD660},
    {0xD661, 0xD661, 0xD661}, {0xD662, 0xD662, 0xD662},
    {0xD663, 0xD663, 0xD663}, {0xD664, 0xD664, 0xD664},
    {0xD665, 0xD665, 0xD665}, {0xD666, 0xD666, 0xD666},
    {0xD667, 0xD667, 0xD667}, {0xD668, 0xD668, 0xD668},
    {0xD669, 0xD669, 0xD669}, {0xD66A, 0xD66A, 0xD66A},
    {0xD66B, 0xD66B, 0xD66B}, {0xD66C, 0xD66C, 0xD66C},
    {0xD66D, 0xD66D, 0xD66D}, {0xD66E, 0xD66E, 0xD66E},
    {0xD66F, 0xD66F, 0xD66F}, {0xD670, 0xD670, 0xD670},
    {0xD671, 0xD671, 0xD671}, {0xD672, 0xD672, 0xD672},
    {0xD673, 0xD673, 0xD673}, {0xD674, 0xD674, 0xD674},
    {0xD675, 0xD675, 0xD675}, {0xD676, 0xD676, 0xD676},
    {0xD677, 0xD677, 0xD677}, {0xD678, 0xD678, 0xD678},
    {0xD679, 0xD679, 0xD679}, {0xD67A, 0xD67A, 0xD67A},
    {0xD67B, 0xD67B, 0xD67B}, {0xD67C, 0xD67C, 0xD67C},
    {0xD67D, 0xD67D, 0xD67D}, {0xD67E, 0xD67E, 0xD67E},
    {0xD67F, 0xD67F, 0xD67F}, {0xD680, 0xD680, 0xD680},
    {0xD681, 0xD681, 0xD681}, {0xD682, 0xD682, 0xD682},
    {0xD683, 0xD683, 0xD683}, {0xD684, 0xD684, 0xD684},
    {0xD685, 0xD685, 0xD685}, {0xD686, 0xD686, 0xD686},
    {0xD687, 0xD687, 0xD687}, {0xD688, 0xD688, 0xD688},
    {0xD689, 0xD689, 0xD689}, {0xD68A, 0xD68A, 0xD68A},
    {0xD68B, 0xD68B, 0xD68B}, {0xD68C, 0xD68C, 0xD68C},
    {0xD68D, 0xD68D, 0xD68D}, {0xD68E, 0xD68E, 0xD68E},
    {0xD68F, 0xD68F, 0xD68F}, {0xD690, 0xD690, 0xD690},
    {0xD691, 0xD691, 0xD691}, {0xD692, 0xD692, 0xD692},
    {0xD693, 0xD693, 0xD693}, {0xD694, 0xD694, 0xD694},
    {0xD695, 0xD695, 0xD695}, {0xD696, 0xD696, 0xD696},
    {0xD697, 0xD697, 0xD697}, {0xD698, 0xD698, 0xD698},
    {0xD699, 0xD699, 0xD699}, {0xD69A, 0xD69A, 0xD69A},
    {0xD69B, 0xD69B, 0xD69B}, {0xD69C, 0xD69C, 0xD69C},
    {0xD69D, 0xD69D, 0xD69D}, {0xD69E, 0xD69E, 0xD69E},
    {0xD69F, 0xD69F, 0xD69F}, {0xD6A0, 0xD6A0, 0xD6A0},
    {0xD6A1, 0xD6A1, 0xD6A1}, {0xD6A2, 0xD6A2, 0xD6A2},
    {0xD6A3, 0xD6A3, 0xD6A3}, {0xD6A4, 0xD6A4, 0xD6A4},
    {0xD6A5, 0xD6A5, 0xD6A5}, {0xD6A6, 0xD6A6, 0xD6A6},
    {0xD6A7, 0xD6A7, 0xD6A7}, {0xD6A8, 0xD6A8, 0xD6A8},
    {0xD6A9, 0xD6A9, 0xD6A9}, {0xD6AA, 0xD6AA, 0xD6AA},
    {0xD6AB, 0xD6AB, 0xD6AB}, {0xD6AC, 0xD6AC, 0xD6AC},
    {0xD6AD, 0xD6AD, 0xD6AD}, {0xD6AE, 0xD6AE, 0xD6AE},
    {0xD6AF, 0xD6AF, 0xD6AF}, {0xD6B0, 0xD6B0, 0xD6B0},
    {0xD6B1, 0xD6B1, 0xD6B1}, {0xD6B2, 0xD6B2, 0xD6B2},
    {0xD6B3, 0xD6B3, 0xD6B3}, {0xD6B4, 0xD6B4, 0xD6B4},
    {0xD6B5, 0xD6B5, 0xD6B5}, {0xD6B6, 0xD6B6, 0xD6B6},
    {0xD6B7, 0xD6B7, 0xD6B7}, {0xD6B8, 0xD6B8, 0xD6B8},
    {0xD6B9, 0xD6B9, 0xD6B9}, {0xD6BA, 0xD6BA, 0xD6BA},
    {0xD6BB, 0xD6BB, 0xD6BB}, {0xD6BC, 0xD6BC, 0xD6BC},
    {0xD6BD, 0xD6BD, 0xD6BD}, {0xD6BE, 0xD6BE, 0xD6BE},
    {0xD6BF, 0xD6BF, 0xD6BF}, {0xD6C0, 0xD6C0, 0xD6C0},
    {0xD6C1, 0xD6C1, 0xD6C1}, {0xD6C2, 0xD6C2, 0xD6C2},
    {0xD6C3, 0xD6C3, 0xD6C3}, {0xD6C4, 0xD6C4, 0xD6C4},
    {0xD6C5, 0xD6C5, 0xD6C5}, {0xD6C6, 0xD6C6, 0xD6C6},
    {0xD6C7, 0xD6C7, 0xD6C7}, {0xD6C8, 0xD6C8, 0xD6C8},
    {0xD6C9, 0xD6C9, 0xD6C9}, {0xD6CA, 0xD6CA, 0xD6CA},
    {0xD6CB, 0xD6CB, 0xD6CB}, {0xD6CC, 0xD6CC, 0xD6CC},
    {0xD6CD, 0xD6CD, 0xD6CD}, {0xD6CE, 0xD6CE, 0xD6CE},
    {0xD6CF, 0xD6CF, 0xD6CF}, {0xD6D0, 0xD6D0, 0xD6D0},
    {0xD6D1, 0xD6D1, 0xD6D1}, {0xD6D2, 0xD6D2, 0xD6D2},
    {0xD6D3, 0xD6D3, 0xD6D3}, {0xD6D4, 0xD6D4, 0xD6D4},
    {0xD6D5, 0xD6D5, 0xD6D5}, {0xD6D6, 0xD6D6, 0xD6D6},
    {0xD6D7, 0xD6D7, 0xD6D7}, {0xD6D8, 0xD6D8, 0xD6D8},
    {0xD6D9, 0xD6D9, 0xD6D9}, {0xD6DA, 0xD6DA, 0xD6DA},
    {0xD6DB, 0xD6DB, 0xD6DB}, {0xD6DC, 0xD6DC, 0xD6DC},
    {0xD6DD, 0xD6DD, 0xD6DD}, {0xD6DE, 0xD6DE, 0xD6DE},
    {0xD6DF, 0xD6DF, 0xD6DF}, {0xD6E0, 0xD6E0, 0xD6E0},
    {0xD6E1, 0xD6E1, 0xD6E1}, {0xD6E2, 0xD6E2, 0xD6E2},
    {0xD6E3, 0xD6E3, 0xD6E3}, {0xD6E4, 0xD6E4, 0xD6E4},
    {0xD6E5, 0xD6E5, 0xD6E5}, {0xD6E6, 0xD6E6, 0xD6E6},
    {0xD6E7, 0xD6E7, 0xD6E7}, {0xD6E8, 0xD6E8, 0xD6E8},
    {0xD6E9, 0xD6E9, 0xD6E9}, {0xD6EA, 0xD6EA, 0xD6EA},
    {0xD6EB, 0xD6EB, 0xD6EB}, {0xD6EC, 0xD6EC, 0xD6EC},
    {0xD6ED, 0xD6ED, 0xD6ED}, {0xD6EE, 0xD6EE, 0xD6EE},
    {0xD6EF, 0xD6EF, 0xD6EF}, {0xD6F0, 0xD6F0, 0xD6F0},
    {0xD6F1, 0xD6F1, 0xD6F1}, {0xD6F2, 0xD6F2, 0xD6F2},
    {0xD6F3, 0xD6F3, 0xD6F3}, {0xD6F4, 0xD6F4, 0xD6F4},
    {0xD6F5, 0xD6F5, 0xD6F5}, {0xD6F6, 0xD6F6, 0xD6F6},
    {0xD6F7, 0xD6F7, 0xD6F7}, {0xD6F8, 0xD6F8, 0xD6F8},
    {0xD6F9, 0xD6F9, 0xD6F9}, {0xD6FA, 0xD6FA, 0xD6FA},
    {0xD6FB, 0xD6FB, 0xD6FB}, {0xD6FC, 0xD6FC, 0xD6FC},
    {0xD6FD, 0xD6FD, 0xD6FD}, {0xD6FE, 0xD6FE, 0xD6FE},
    {0xD6FF, 0xD6FF, 0xD6FF}, {0xD700, 0xD700, 0xD700},
    {0xD701, 0xD701, 0xD701}, {0xD702, 0xD702, 0xD702},
    {0xD703, 0xD703, 0xD703}, {0xD704, 0xD704, 0xD704},
    {0xD705, 0xD705, 0xD705}, {0xD706, 0xD706, 0xD706},
    {0xD707, 0xD707, 0xD707}, {0xD708, 0xD708, 0xD708},
    {0xD709, 0xD709, 0xD709}, {0xD70A, 0xD70A, 0xD70A},
    {0xD70B, 0xD70B, 0xD70B}, {0xD70C, 0xD70C, 0xD70C},
    {0xD70D, 0xD70D, 0xD70D}, {0xD70E, 0xD70E, 0xD70E},
    {0xD70F, 0xD70F, 0xD70F}, {0xD710, 0xD710, 0xD710},
    {0xD711, 0xD711, 0xD711}, {0xD712, 0xD712, 0xD712},
    {0xD713, 0xD713, 0xD713}, {0xD714, 0xD714, 0xD714},
    {0xD715, 0xD715, 0xD715}, {0xD716, 0xD716, 0xD716},
    {0xD717, 0xD717, 0xD717}, {0xD718, 0xD718, 0xD718},
    {0xD719, 0xD719, 0xD719}, {0xD71A, 0xD71A, 0xD71A},
    {0xD71B, 0xD71B, 0xD71B}, {0xD71C, 0xD71C, 0xD71C},
    {0xD71D, 0xD71D, 0xD71D}, {0xD71E, 0xD71E, 0xD71E},
    {0xD71F, 0xD71F, 0xD71F}, {0xD720, 0xD720, 0xD720},
    {0xD721, 0xD721, 0xD721}, {0xD722, 0xD722, 0xD722},
    {0xD723, 0xD723, 0xD723}, {0xD724, 0xD724, 0xD724},
    {0xD725, 0xD725, 0xD725}, {0xD726, 0xD726, 0xD726},
    {0xD727, 0xD727, 0xD727}, {0xD728, 0xD728, 0xD728},
    {0xD729, 0xD729, 0xD729}, {0xD72A, 0xD72A, 0xD72A},
    {0xD72B, 0xD72B, 0xD72B}, {0xD72C, 0xD72C, 0xD72C},
    {0xD72D, 0xD72D, 0xD72D}, {0xD72E, 0xD72E, 0xD72E},
    {0xD72F, 0xD72F, 0xD72F}, {0xD730, 0xD730, 0xD730},
    {0xD731, 0xD731, 0xD731}, {0xD732, 0xD732, 0xD732},
    {0xD733, 0xD733, 0xD733}, {0xD734, 0xD734, 0xD734},
    {0xD735, 0xD735, 0xD735}, {0xD736, 0xD736, 0xD736},
    {0xD737, 0xD737, 0xD737}, {0xD738, 0xD738, 0xD738},
    {0xD739, 0xD739, 0xD739}, {0xD73A, 0xD73A, 0xD73A},
    {0xD73B, 0xD73B, 0xD73B}, {0xD73C, 0xD73C, 0xD73C},
    {0xD73D, 0xD73D, 0xD73D}, {0xD73E, 0xD73E, 0xD73E},
    {0xD73F, 0xD73F, 0xD73F}, {0xD740, 0xD740, 0xD740},
    {0xD741, 0xD741, 0xD741}, {0xD742, 0xD742, 0xD742},
    {0xD743, 0xD743, 0xD743}, {0xD744, 0xD744, 0xD744},
    {0xD745, 0xD745, 0xD745}, {0xD746, 0xD746, 0xD746},
    {0xD747, 0xD747, 0xD747}, {0xD748, 0xD748, 0xD748},
    {0xD749, 0xD749, 0xD749}, {0xD74A, 0xD74A, 0xD74A},
    {0xD74B, 0xD74B, 0xD74B}, {0xD74C, 0xD74C, 0xD74C},
    {0xD74D, 0xD74D, 0xD74D}, {0xD74E, 0xD74E, 0xD74E},
    {0xD74F, 0xD74F, 0xD74F}, {0xD750, 0xD750, 0xD750},
    {0xD751, 0xD751, 0xD751}, {0xD752, 0xD752, 0xD752},
    {0xD753, 0xD753, 0xD753}, {0xD754, 0xD754, 0xD754},
    {0xD755, 0xD755, 0xD755}, {0xD756, 0xD756, 0xD756},
    {0xD757, 0xD757, 0xD757}, {0xD758, 0xD758, 0xD758},
    {0xD759, 0xD759, 0xD759}, {0xD75A, 0xD75A, 0xD75A},
    {0xD75B, 0xD75B, 0xD75B}, {0xD75C, 0xD75C, 0xD75C},
    {0xD75D, 0xD75D, 0xD75D}, {0xD75E, 0xD75E, 0xD75E},
    {0xD75F, 0xD75F, 0xD75F}, {0xD760, 0xD760, 0xD760},
    {0xD761, 0xD761, 0xD761}, {0xD762, 0xD762, 0xD762},
    {0xD763, 0xD763, 0xD763}, {0xD764, 0xD764, 0xD764},
    {0xD765, 0xD765, 0xD765}, {0xD766, 0xD766, 0xD766},
    {0xD767, 0xD767, 0xD767}, {0xD768, 0xD768, 0xD768},
    {0xD769, 0xD769, 0xD769}, {0xD76A, 0xD76A, 0xD76A},
    {0xD76B, 0xD76B, 0xD76B}, {0xD76C, 0xD76C, 0xD76C},
    {0xD76D, 0xD76D, 0xD76D}, {0xD76E, 0xD76E, 0xD76E},
    {0xD76F, 0xD76F, 0xD76F}, {0xD770, 0xD770, 0xD770},
    {0xD771, 0xD771, 0xD771}, {0xD772, 0xD772, 0xD772},
    {0xD773, 0xD773, 0xD773}, {0xD774, 0xD774, 0xD774},
    {0xD775, 0xD775, 0xD775}, {0xD776, 0xD776, 0xD776},
    {0xD777, 0xD777, 0xD777}, {0xD778, 0xD778, 0xD778},
    {0xD779, 0xD779, 0xD779}, {0xD77A, 0xD77A, 0xD77A},
    {0xD77B, 0xD77B, 0xD77B}, {0xD77C, 0xD77C, 0xD77C},
    {0xD77D, 0xD77D, 0xD77D}, {0xD77E, 0xD77E, 0xD77E},
    {0xD77F, 0xD77F, 0xD77F}, {0xD780, 0xD780, 0xD780},
    {0xD781, 0xD781, 0xD781}, {0xD782, 0xD782, 0xD782},
    {0xD783, 0xD783, 0xD783}, {0xD784, 0xD784, 0xD784},
    {0xD785, 0xD785, 0xD785}, {0xD786, 0xD786, 0xD786},
    {0xD787, 0xD787, 0xD787}, {0xD788, 0xD788, 0xD788},
    {0xD789, 0xD789, 0xD789}, {0xD78A, 0xD78A, 0xD78A},
    {0xD78B, 0xD78B, 0xD78B}, {0xD78C, 0xD78C, 0xD78C},
    {0xD78D, 0xD78D, 0xD78D}, {0xD78E, 0xD78E, 0xD78E},
    {0xD78F, 0xD78F, 0xD78F}, {0xD790, 0xD790, 0xD790},
    {0xD791, 0xD791, 0xD791}, {0xD792, 0xD792, 0xD792},
    {0xD793, 0xD793, 0xD793}, {0xD794, 0xD794, 0xD794},
    {0xD795, 0xD795, 0xD795}, {0xD796, 0xD796, 0xD796},
    {0xD797, 0xD797, 0xD797}, {0xD798, 0xD798, 0xD798},
    {0xD799, 0xD799, 0xD799}, {0xD79A, 0xD79A, 0xD79A},
    {0xD79B, 0xD79B, 0xD79B}, {0xD79C, 0xD79C, 0xD79C},
    {0xD79D, 0xD79D, 0xD79D}, {0xD79E, 0xD79E, 0xD79E},
    {0xD79F, 0xD79F, 0xD79F}, {0xD7A0, 0xD7A0, 0xD7A0},
    {0xD7A1, 0xD7A1, 0xD7A1}, {0xD7A2, 0xD7A2, 0xD7A2},
    {0xD7A3, 0xD7A3, 0xD7A3}, {0xF900, 0xF900, 0xF900},
    {0xF901, 0xF901, 0xF901}, {0xF902, 0xF902, 0xF902},
    {0xF903, 0xF903, 0xF903}, {0xF904, 0xF904, 0xF904},
    {0xF905, 0xF905, 0xF905}, {0xF906, 0xF906, 0xF906},
    {0xF907, 0xF907, 0xF907}, {0xF908, 0xF908, 0xF908},
    {0xF909, 0xF909, 0xF909}, {0xF90A, 0xF90A, 0xF90A},
    {0xF90B, 0xF90B, 0xF90B}, {0xF90C, 0xF90C, 0xF90C},
    {0xF90D, 0xF90D, 0xF90D}, {0xF90E, 0xF90E, 0xF90E},
    {0xF90F, 0xF90F, 0xF90F}, {0xF910, 0xF910, 0xF910},
    {0xF911, 0xF911, 0xF911}, {0xF912, 0xF912, 0xF912},
    {0xF913, 0xF913, 0xF913}, {0xF914, 0xF914, 0xF914},
    {0xF915, 0xF915, 0xF915}, {0xF916, 0xF916, 0xF916},
    {0xF917, 0xF917, 0xF917}, {0xF918, 0xF918, 0xF918},
    {0xF919, 0xF919, 0xF919}, {0xF91A, 0xF91A, 0xF91A},
    {0xF91B, 0xF91B, 0xF91B}, {0xF91C, 0xF91C, 0xF91C},
    {0xF91D, 0xF91D, 0xF91D}, {0xF91E, 0xF91E, 0xF91E},
    {0xF91F, 0xF91F, 0xF91F}, {0xF920, 0xF920, 0xF920},
    {0xF921, 0xF921, 0xF921}, {0xF922, 0xF922, 0xF922},
    {0xF923, 0xF923, 0xF923}, {0xF924, 0xF924, 0xF924},
    {0xF925, 0xF925, 0xF925}, {0xF926, 0xF926, 0xF926},
    {0xF927, 0xF927, 0xF927}, {0xF928, 0xF928, 0xF928},
    {0xF929, 0xF929, 0xF929}, {0xF92A, 0xF92A, 0xF92A},
    {0xF92B, 0xF92B, 0xF92B}, {0xF92C, 0xF92C, 0xF92C},
    {0xF92D, 0xF92D, 0xF92D}, {0xF92E, 0xF92E, 0xF92E},
    {0xF92F, 0xF92F, 0xF92F}, {0xF930, 0xF930, 0xF930},
    {0xF931, 0xF931, 0xF931}, {0xF932, 0xF932, 0xF932},
    {0xF933, 0xF933, 0xF933}, {0xF934, 0xF934, 0xF934},
    {0xF935, 0xF935, 0xF935}, {0xF936, 0xF936, 0xF936},
    {0xF937, 0xF937, 0xF937}, {0xF938, 0xF938, 0xF938},
    {0xF939, 0xF939, 0xF939}, {0xF93A, 0xF93A, 0xF93A},
    {0xF93B, 0xF93B, 0xF93B}, {0xF93C, 0xF93C, 0xF93C},
    {0xF93D, 0xF93D, 0xF93D}, {0xF93E, 0xF93E, 0xF93E},
    {0xF93F, 0xF93F, 0xF93F}, {0xF940, 0xF940, 0xF940},
    {0xF941, 0xF941, 0xF941}, {0xF942, 0xF942, 0xF942},
    {0xF943, 0xF943, 0xF943}, {0xF944, 0xF944, 0xF944},
    {0xF945, 0xF945, 0xF945}, {0xF946, 0xF946, 0xF946},
    {0xF947, 0xF947, 0xF947}, {0xF948, 0xF948, 0xF948},
    {0xF949, 0xF949, 0xF949}, {0xF94A, 0xF94A, 0xF94A},
    {0xF94B, 0xF94B, 0xF94B}, {0xF94C, 0xF94C, 0xF94C},
    {0xF94D, 0xF94D, 0xF94D}, {0xF94E, 0xF94E, 0xF94E},
    {0xF94F, 0xF94F, 0xF94F}, {0xF950, 0xF950, 0xF950},
    {0xF951, 0xF951, 0xF951}, {0xF952, 0xF952, 0xF952},
    {0xF953, 0xF953, 0xF953}, {0xF954, 0xF954, 0xF954},
    {0xF955, 0xF955, 0xF955}, {0xF956, 0xF956, 0xF956},
    {0xF957, 0xF957, 0xF957}, {0xF958, 0xF958, 0xF958},
    {0xF959, 0xF959, 0xF959}, {0xF95A, 0xF95A, 0xF95A},
    {0xF95B, 0xF95B, 0xF95B}, {0xF95C, 0xF95C, 0xF95C},
    {0xF95D, 0xF95D, 0xF95D}, {0xF95E, 0xF95E, 0xF95E},
    {0xF95F, 0xF95F, 0xF95F}, {0xF960, 0xF960, 0xF960},
    {0xF961, 0xF961, 0xF961}, {0xF962, 0xF962, 0xF962},
    {0xF963, 0xF963, 0xF963}, {0xF964, 0xF964, 0xF964},
    {0xF965, 0xF965, 0xF965}, {0xF966, 0xF966, 0xF966},
    {0xF967, 0xF967, 0xF967}, {0xF968, 0xF968, 0xF968},
    {0xF969, 0xF969, 0xF969}, {0xF96A, 0xF96A, 0xF96A},
    {0xF96B, 0xF96B, 0xF96B}, {0xF96C, 0xF96C, 0xF96C},
    {0xF96D, 0xF96D, 0xF96D}, {0xF96E, 0xF96E, 0xF96E},
    {0xF96F, 0xF96F, 0xF96F}, {0xF970, 0xF970, 0xF970},
    {0xF971, 0xF971, 0xF971}, {0xF972, 0xF972, 0xF972},
    {0xF973, 0xF973, 0xF973}, {0xF974, 0xF974, 0xF974},
    {0xF975, 0xF975, 0xF975}, {0xF976, 0xF976, 0xF976},
    {0xF977, 0xF977, 0xF977}, {0xF978, 0xF978, 0xF978},
    {0xF979, 0xF979, 0xF979}, {0xF97A, 0xF97A, 0xF97A},
    {0xF97B, 0xF97B, 0xF97B}, {0xF97C, 0xF97C, 0xF97C},
    {0xF97D, 0xF97D, 0xF97D}, {0xF97E, 0xF97E, 0xF97E},
    {0xF97F, 0xF97F, 0xF97F}, {0xF980, 0xF980, 0xF980},
    {0xF981, 0xF981, 0xF981}, {0xF982, 0xF982, 0xF982},
    {0xF983, 0xF983, 0xF983}, {0xF984, 0xF984, 0xF984},
    {0xF985, 0xF985, 0xF985}, {0xF986, 0xF986, 0xF986},
    {0xF987, 0xF987, 0xF987}, {0xF988, 0xF988, 0xF988},
    {0xF989, 0xF989, 0xF989}, {0xF98A, 0xF98A, 0xF98A},
    {0xF98B, 0xF98B, 0xF98B}, {0xF98C, 0xF98C, 0xF98C},
    {0xF98D, 0xF98D, 0xF98D}, {0xF98E, 0xF98E, 0xF98E},
    {0xF98F, 0xF98F, 0xF98F}, {0xF990, 0xF990, 0xF990},
    {0xF991, 0xF991, 0xF991}, {0xF992, 0xF992, 0xF992},
    {0xF993, 0xF993, 0xF993}, {0xF994, 0xF994, 0xF994},
    {0xF995, 0xF995, 0xF995}, {0xF996, 0xF996, 0xF996},
    {0xF997, 0xF997, 0xF997}, {0xF998, 0xF998, 0xF998},
    {0xF999, 0xF999, 0xF999}, {0xF99A, 0xF99A, 0xF99A},
    {0xF99B, 0xF99B, 0xF99B}, {0xF99C, 0xF99C, 0xF99C},
    {0xF99D, 0xF99D, 0xF99D}, {0xF99E, 0xF99E, 0xF99E},
    {0xF99F, 0xF99F, 0xF99F}, {0xF9A0, 0xF9A0, 0xF9A0},
    {0xF9A1, 0xF9A1, 0xF9A1}, {0xF9A2, 0xF9A2, 0xF9A2},
    {0xF9A3, 0xF9A3, 0xF9A3}, {0xF9A4, 0xF9A4, 0xF9A4},
    {0xF9A5, 0xF9A5, 0xF9A5}, {0xF9A6, 0xF9A6, 0xF9A6},
    {0xF9A7, 0xF9A7, 0xF9A7}, {0xF9A8, 0xF9A8, 0xF9A8},
    {0xF9A9, 0xF9A9, 0xF9A9}, {0xF9AA, 0xF9AA, 0xF9AA},
    {0xF9AB, 0xF9AB, 0xF9AB}, {0xF9AC, 0xF9AC, 0xF9AC},
    {0xF9AD, 0xF9AD, 0xF9AD}, {0xF9AE, 0xF9AE, 0xF9AE},
    {0xF9AF, 0xF9AF, 0xF9AF}, {0xF9B0, 0xF9B0, 0xF9B0},
    {0xF9B1, 0xF9B1, 0xF9B1}, {0xF9B2, 0xF9B2, 0xF9B2},
    {0xF9B3, 0xF9B3, 0xF9B3}, {0xF9B4, 0xF9B4, 0xF9B4},
    {0xF9B5, 0xF9B5, 0xF9B5}, {0xF9B6, 0xF9B6, 0xF9B6},
    {0xF9B7, 0xF9B7, 0xF9B7}, {0xF9B8, 0xF9B8, 0xF9B8},
    {0xF9B9, 0xF9B9, 0xF9B9}, {0xF9BA, 0xF9BA, 0xF9BA},
    {0xF9BB, 0xF9BB, 0xF9BB}, {0xF9BC, 0xF9BC, 0xF9BC},
    {0xF9BD, 0xF9BD, 0xF9BD}, {0xF9BE, 0xF9BE, 0xF9BE},
    {0xF9BF, 0xF9BF, 0xF9BF}, {0xF9C0, 0xF9C0, 0xF9C0},
    {0xF9C1, 0xF9C1, 0xF9C1}, {0xF9C2, 0xF9C2, 0xF9C2},
    {0xF9C3, 0xF9C3, 0xF9C3}, {0xF9C4, 0xF9C4, 0xF9C4},
    {0xF9C5, 0xF9C5, 0xF9C5}, {0xF9C6, 0xF9C6, 0xF9C6},
    {0xF9C7, 0xF9C7, 0xF9C7}, {0xF9C8, 0xF9C8, 0xF9C8},
    {0xF9C9, 0xF9C9, 0xF9C9}, {0xF9CA, 0xF9CA, 0xF9CA},
    {0xF9CB, 0xF9CB, 0xF9CB}, {0xF9CC, 0xF9CC, 0xF9CC},
    {0xF9CD, 0xF9CD, 0xF9CD}, {0xF9CE, 0xF9CE, 0xF9CE},
    {0xF9CF, 0xF9CF, 0xF9CF}, {0xF9D0, 0xF9D0, 0xF9D0},
    {0xF9D1, 0xF9D1, 0xF9D1}, {0xF9D2, 0xF9D2, 0xF9D2},
    {0xF9D3, 0xF9D3, 0xF9D3}, {0xF9D4, 0xF9D4, 0xF9D4},
    {0xF9D5, 0xF9D5, 0xF9D5}, {0xF9D6, 0xF9D6, 0xF9D6},
    {0xF9D7, 0xF9D7, 0xF9D7}, {0xF9D8, 0xF9D8, 0xF9D8},
    {0xF9D9, 0xF9D9, 0xF9D9}, {0xF9DA, 0xF9DA, 0xF9DA},
    {0xF9DB, 0xF9DB, 0xF9DB}, {0xF9DC, 0xF9DC, 0xF9DC},
    {0xF9DD, 0xF9DD, 0xF9DD}, {0xF9DE, 0xF9DE, 0xF9DE},
    {0xF9DF, 0xF9DF, 0xF9DF}, {0xF9E0, 0xF9E0, 0xF9E0},
    {0xF9E1, 0xF9E1, 0xF9E1}, {0xF9E2, 0xF9E2, 0xF9E2},
    {0xF9E3, 0xF9E3, 0xF9E3}, {0xF9E4, 0xF9E4, 0xF9E4},
    {0xF9E5, 0xF9E5, 0xF9E5}, {0xF9E6, 0xF9E6, 0xF9E6},
    {0xF9E7, 0xF9E7, 0xF9E7}, {0xF9E8, 0xF9E8, 0xF9E8},
    {0xF9E9, 0xF9E9, 0xF9E9}, {0xF9EA, 0xF9EA, 0xF9EA},
    {0xF9EB, 0xF9EB, 0xF9EB}, {0xF9EC, 0xF9EC, 0xF9EC},
    {0xF9ED, 0xF9ED, 0xF9ED}, {0xF9EE, 0xF9EE, 0xF9EE},
    {0xF9EF, 0xF9EF, 0xF9EF}, {0xF9F0, 0xF9F0, 0xF9F0},
    {0xF9F1, 0xF9F1, 0xF9F1}, {0xF9F2, 0xF9F2, 0xF9F2},
    {0xF9F3, 0xF9F3, 0xF9F3}, {0xF9F4, 0xF9F4, 0xF9F4},
    {0xF9F5, 0xF9F5, 0xF9F5}, {0xF9F6, 0xF9F6, 0xF9F6},
    {0xF9F7, 0xF9F7, 0xF9F7}, {0xF9F8, 0xF9F8, 0xF9F8},
    {0xF9F9, 0xF9F9, 0xF9F9}, {0xF9FA, 0xF9FA, 0xF9FA},
    {0xF9FB, 0xF9FB, 0xF9FB}, {0xF9FC, 0xF9FC, 0xF9FC},
    {0xF9FD, 0xF9FD, 0xF9FD}, {0xF9FE, 0xF9FE, 0xF9FE},
    {0xF9FF, 0xF9FF, 0xF9FF}, {0xFA00, 0xFA00, 0xFA00},
    {0xFA01, 0xFA01, 0xFA01}, {0xFA02, 0xFA02, 0xFA02},
    {0xFA03, 0xFA03, 0xFA03}, {0xFA04, 0xFA04, 0xFA04},
    {0xFA05, 0xFA05, 0xFA05}, {0xFA06, 0xFA06, 0xFA06},
    {0xFA07, 0xFA07, 0xFA07}, {0xFA08, 0xFA08, 0xFA08},
    {0xFA09, 0xFA09, 0xFA09}, {0xFA0A, 0xFA0A, 0xFA0A},
    {0xFA0B, 0xFA0B, 0xFA0B}, {0xFA0C, 0xFA0C, 0xFA0C},
    {0xFA0D, 0xFA0D, 0xFA0D}, {0xFA0E, 0xFA0E, 0xFA0E},
    {0xFA0F, 0xFA0F, 0xFA0F}, {0xFA10, 0xFA10, 0xFA10},
    {0xFA11, 0xFA11, 0xFA11}, {0xFA12, 0xFA12, 0xFA12},
    {0xFA13, 0xFA13, 0xFA13}, {0xFA14, 0xFA14, 0xFA14},
    {0xFA15, 0xFA15, 0xFA15}, {0xFA16, 0xFA16, 0xFA16},
    {0xFA17, 0xFA17, 0xFA17}, {0xFA18, 0xFA18, 0xFA18},
    {0xFA19, 0xFA19, 0xFA19}, {0xFA1A, 0xFA1A, 0xFA1A},
    {0xFA1B, 0xFA1B, 0xFA1B}, {0xFA1C, 0xFA1C, 0xFA1C},
    {0xFA1D, 0xFA1D, 0xFA1D}, {0xFA1E, 0xFA1E, 0xFA1E},
    {0xFA1F, 0xFA1F, 0xFA1F}, {0xFA20, 0xFA20, 0xFA20},
    {0xFA21, 0xFA21, 0xFA21}, {0xFA22, 0xFA22, 0xFA22},
    {0xFA23, 0xFA23, 0xFA23}, {0xFA24, 0xFA24, 0xFA24},
    {0xFA25, 0xFA25, 0xFA25}, {0xFA26, 0xFA26, 0xFA26},
    {0xFA27, 0xFA27, 0xFA27}, {0xFA28, 0xFA28, 0xFA28},
    {0xFA29, 0xFA29, 0xFA29}, {0xFA2A, 0xFA2A, 0xFA2A},
    {0xFA2B, 0xFA2B, 0xFA2B}, {0xFA2C, 0xFA2C, 0xFA2C},
    {0xFA2D, 0xFA2D, 0xFA2D}, {0xFA30, 0xFA30, 0xFA30},
    {0xFA31, 0xFA31, 0xFA31}, {0xFA32, 0xFA32, 0xFA32},
    {0xFA33, 0xFA33, 0xFA33}, {0xFA34, 0xFA34, 0xFA34},
    {0xFA35, 0xFA35, 0xFA35}, {0xFA36, 0xFA36, 0xFA36},
    {0xFA37, 0xFA37, 0xFA37}, {0xFA38, 0xFA38, 0xFA38},
    {0xFA39, 0xFA39, 0xFA39}, {0xFA3A, 0xFA3A, 0xFA3A},
    {0xFA3B, 0xFA3B, 0xFA3B}, {0xFA3C, 0xFA3C, 0xFA3C},
    {0xFA3D, 0xFA3D, 0xFA3D}, {0xFA3E, 0xFA3E, 0xFA3E},
    {0xFA3F, 0xFA3F, 0xFA3F}, {0xFA40, 0xFA40, 0xFA40},
    {0xFA41, 0xFA41, 0xFA41}, {0xFA42, 0xFA42, 0xFA42},
    {0xFA43, 0xFA43, 0xFA43}, {0xFA44, 0xFA44, 0xFA44},
    {0xFA45, 0xFA45, 0xFA45}, {0xFA46, 0xFA46, 0xFA46},
    {0xFA47, 0xFA47, 0xFA47}, {0xFA48, 0xFA48, 0xFA48},
    {0xFA49, 0xFA49, 0xFA49}, {0xFA4A, 0xFA4A, 0xFA4A},
    {0xFA4B, 0xFA4B, 0xFA4B}, {0xFA4C, 0xFA4C, 0xFA4C},
    {0xFA4D, 0xFA4D, 0xFA4D}, {0xFA4E, 0xFA4E, 0xFA4E},
    {0xFA4F, 0xFA4F, 0xFA4F}, {0xFA50, 0xFA50, 0xFA50},
    {0xFA51, 0xFA51, 0xFA51}, {0xFA52, 0xFA52, 0xFA52},
    {0xFA53, 0xFA53, 0xFA53}, {0xFA54, 0xFA54, 0xFA54},
    {0xFA55, 0xFA55, 0xFA55}, {0xFA56, 0xFA56, 0xFA56},
    {0xFA57, 0xFA57, 0xFA57}, {0xFA58, 0xFA58, 0xFA58},
    {0xFA59, 0xFA59, 0xFA59}, {0xFA5A, 0xFA5A, 0xFA5A},
    {0xFA5B, 0xFA5B, 0xFA5B}, {0xFA5C, 0xFA5C, 0xFA5C},
    {0xFA5D, 0xFA5D, 0xFA5D}, {0xFA5E, 0xFA5E, 0xFA5E},
    {0xFA5F, 0xFA5F, 0xFA5F}, {0xFA60, 0xFA60, 0xFA60},
    {0xFA61, 0xFA61, 0xFA61}, {0xFA62, 0xFA62, 0xFA62},
    {0xFA63, 0xFA63, 0xFA63}, {0xFA64, 0xFA64, 0xFA64},
    {0xFA65, 0xFA65, 0xFA65}, {0xFA66, 0xFA66, 0xFA66},
    {0xFA67, 0xFA67, 0xFA67}, {0xFA68, 0xFA68, 0xFA68},
    {0xFA69, 0xFA69, 0xFA69}, {0xFA6A, 0xFA6A, 0xFA6A},
    {0xFA70, 0xFA70, 0xFA70}, {0xFA71, 0xFA71, 0xFA71},
    {0xFA72, 0xFA72, 0xFA72}, {0xFA73, 0xFA73, 0xFA73},
    {0xFA74, 0xFA74, 0xFA74}, {0xFA75, 0xFA75, 0xFA75},
    {0xFA76, 0xFA76, 0xFA76}, {0xFA77, 0xFA77, 0xFA77},
    {0xFA78, 0xFA78, 0xFA78}, {0xFA79, 0xFA79, 0xFA79},
    {0xFA7A, 0xFA7A, 0xFA7A}, {0xFA7B, 0xFA7B, 0xFA7B},
    {0xFA7C, 0xFA7C, 0xFA7C}, {0xFA7D, 0xFA7D, 0xFA7D},
    {0xFA7E, 0xFA7E, 0xFA7E}, {0xFA7F, 0xFA7F, 0xFA7F},
    {0xFA80, 0xFA80, 0xFA80}, {0xFA81, 0xFA81, 0xFA81},
    {0xFA82, 0xFA82, 0xFA82}, {0xFA83, 0xFA83, 0xFA83},
    {0xFA84, 0xFA84, 0xFA84}, {0xFA85, 0xFA85, 0xFA85},
    {0xFA86, 0xFA86, 0xFA86}, {0xFA87, 0xFA87, 0xFA87},
    {0xFA88, 0xFA88, 0xFA88}, {0xFA89, 0xFA89, 0xFA89},
    {0xFA8A, 0xFA8A, 0xFA8A}, {0xFA8B, 0xFA8B, 0xFA8B},
    {0xFA8C, 0xFA8C, 0xFA8C}, {0xFA8D, 0xFA8D, 0xFA8D},
    {0xFA8E, 0xFA8E, 0xFA8E}, {0xFA8F, 0xFA8F, 0xFA8F},
    {0xFA90, 0xFA90, 0xFA90}, {0xFA91, 0xFA91, 0xFA91},
    {0xFA92, 0xFA92, 0xFA92}, {0xFA93, 0xFA93, 0xFA93},
    {0xFA94, 0xFA94, 0xFA94}, {0xFA95, 0xFA95, 0xFA95},
    {0xFA96, 0xFA96, 0xFA96}, {0xFA97, 0xFA97, 0xFA97},
    {0xFA98, 0xFA98, 0xFA98}, {0xFA99, 0xFA99, 0xFA99},
    {0xFA9A, 0xFA9A, 0xFA9A}, {0xFA9B, 0xFA9B, 0xFA9B},
    {0xFA9C, 0xFA9C, 0xFA9C}, {0xFA9D, 0xFA9D, 0xFA9D},
    {0xFA9E, 0xFA9E, 0xFA9E}, {0xFA9F, 0xFA9F, 0xFA9F},
    {0xFAA0, 0xFAA0, 0xFAA0}, {0xFAA1, 0xFAA1, 0xFAA1},
    {0xFAA2, 0xFAA2, 0xFAA2}, {0xFAA3, 0xFAA3, 0xFAA3},
    {0xFAA4, 0xFAA4, 0xFAA4}, {0xFAA5, 0xFAA5, 0xFAA5},
    {0xFAA6, 0xFAA6, 0xFAA6}, {0xFAA7, 0xFAA7, 0xFAA7},
    {0xFAA8, 0xFAA8, 0xFAA8}, {0xFAA9, 0xFAA9, 0xFAA9},
    {0xFAAA, 0xFAAA, 0xFAAA}, {0xFAAB, 0xFAAB, 0xFAAB},
    {0xFAAC, 0xFAAC, 0xFAAC}, {0xFAAD, 0xFAAD, 0xFAAD},
    {0xFAAE, 0xFAAE, 0xFAAE}, {0xFAAF, 0xFAAF, 0xFAAF},
    {0xFAB0, 0xFAB0, 0xFAB0}, {0xFAB1, 0xFAB1, 0xFAB1},
    {0xFAB2, 0xFAB2, 0xFAB2}, {0xFAB3, 0xFAB3, 0xFAB3},
    {0xFAB4, 0xFAB4, 0xFAB4}, {0xFAB5, 0xFAB5, 0xFAB5},
    {0xFAB6, 0xFAB6, 0xFAB6}, {0xFAB7, 0xFAB7, 0xFAB7},
    {0xFAB8, 0xFAB8, 0xFAB8}, {0xFAB9, 0xFAB9, 0xFAB9},
    {0xFABA, 0xFABA, 0xFABA}, {0xFABB, 0xFABB, 0xFABB},
    {0xFABC, 0xFABC, 0xFABC}, {0xFABD, 0xFABD, 0xFABD},
    {0xFABE, 0xFABE, 0xFABE}, {0xFABF, 0xFABF, 0xFABF},
    {0xFAC0, 0xFAC0, 0xFAC0}, {0xFAC1, 0xFAC1, 0xFAC1},
    {0xFAC2, 0xFAC2, 0xFAC2}, {0xFAC3, 0xFAC3, 0xFAC3},
    {0xFAC4, 0xFAC4, 0xFAC4}, {0xFAC5, 0xFAC5, 0xFAC5},
    {0xFAC6, 0xFAC6, 0xFAC6}, {0xFAC7, 0xFAC7, 0xFAC7},
    {0xFAC8, 0xFAC8, 0xFAC8}, {0xFAC9, 0xFAC9, 0xFAC9},
    {0xFACA, 0xFACA, 0xFACA}, {0xFACB, 0xFACB, 0xFACB},
    {0xFACC, 0xFACC, 0xFACC}, {0xFACD, 0xFACD, 0xFACD},
    {0xFACE, 0xFACE, 0xFACE}, {0xFACF, 0xFACF, 0xFACF},
    {0xFAD0, 0xFAD0, 0xFAD0}, {0xFAD1, 0xFAD1, 0xFAD1},
    {0xFAD2, 0xFAD2, 0xFAD2}, {0xFAD3, 0xFAD3, 0xFAD3},
    {0xFAD4, 0xFAD4, 0xFAD4}, {0xFAD5, 0xFAD5, 0xFAD5},
    {0xFAD6, 0xFAD6, 0xFAD6}, {0xFAD7, 0xFAD7, 0xFAD7},
    {0xFAD8, 0xFAD8, 0xFAD8}, {0xFAD9, 0xFAD9, 0xFAD9},
    {0xFB00, 0xFB00, 0xFB00}, {0xFB01, 0xFB01, 0xFB01},
    {0xFB02, 0xFB02, 0xFB02}, {0xFB03, 0xFB03, 0xFB03},
    {0xFB04, 0xFB04, 0xFB04}, {0xFB05, 0xFB05, 0xFB05},
    {0xFB06, 0xFB06, 0xFB06}, {0xFB13, 0xFB13, 0xFB13},
    {0xFB14, 0xFB14, 0xFB14}, {0xFB15, 0xFB15, 0xFB15},
    {0xFB16, 0xFB16, 0xFB16}, {0xFB17, 0xFB17, 0xFB17},
    {0xFB1D, 0xFB1D, 0xFB1D}, {0xFB1E, 0xFB1E, 0xFB1E},
    {0xFB1F, 0xFB1F, 0xFB1F}, {0xFB20, 0xFB20, 0xFB20},
    {0xFB21, 0xFB21, 0xFB21}, {0xFB22, 0xFB22, 0xFB22},
    {0xFB23, 0xFB23, 0xFB23}, {0xFB24, 0xFB24, 0xFB24},
    {0xFB25, 0xFB25, 0xFB25}, {0xFB26, 0xFB26, 0xFB26},
    {0xFB27, 0xFB27, 0xFB27}, {0xFB28, 0xFB28, 0xFB28},
    {0xFB2A, 0xFB2A, 0xFB2A}, {0xFB2B, 0xFB2B, 0xFB2B},
    {0xFB2C, 0xFB2C, 0xFB2C}, {0xFB2D, 0xFB2D, 0xFB2D},
    {0xFB2E, 0xFB2E, 0xFB2E}, {0xFB2F, 0xFB2F, 0xFB2F},
    {0xFB30, 0xFB30, 0xFB30}, {0xFB31, 0xFB31, 0xFB31},
    {0xFB32, 0xFB32, 0xFB32}, {0xFB33, 0xFB33, 0xFB33},
    {0xFB34, 0xFB34, 0xFB34}, {0xFB35, 0xFB35, 0xFB35},
    {0xFB36, 0xFB36, 0xFB36}, {0xFB38, 0xFB38, 0xFB38},
    {0xFB39, 0xFB39, 0xFB39}, {0xFB3A, 0xFB3A, 0xFB3A},
    {0xFB3B, 0xFB3B, 0xFB3B}, {0xFB3C, 0xFB3C, 0xFB3C},
    {0xFB3E, 0xFB3E, 0xFB3E}, {0xFB40, 0xFB40, 0xFB40},
    {0xFB41, 0xFB41, 0xFB41}, {0xFB43, 0xFB43, 0xFB43},
    {0xFB44, 0xFB44, 0xFB44}, {0xFB46, 0xFB46, 0xFB46},
    {0xFB47, 0xFB47, 0xFB47}, {0xFB48, 0xFB48, 0xFB48},
    {0xFB49, 0xFB49, 0xFB49}, {0xFB4A, 0xFB4A, 0xFB4A},
    {0xFB4B, 0xFB4B, 0xFB4B}, {0xFB4C, 0xFB4C, 0xFB4C},
    {0xFB4D, 0xFB4D, 0xFB4D}, {0xFB4E, 0xFB4E, 0xFB4E},
    {0xFB4F, 0xFB4F, 0xFB4F}, {0xFB50, 0xFB50, 0xFB50},
    {0xFB51, 0xFB51, 0xFB51}, {0xFB52, 0xFB52, 0xFB52},
    {0xFB53, 0xFB53, 0xFB53}, {0xFB54, 0xFB54, 0xFB54},
    {0xFB55, 0xFB55, 0xFB55}, {0xFB56, 0xFB56, 0xFB56},
    {0xFB57, 0xFB57, 0xFB57}, {0xFB58, 0xFB58, 0xFB58},
    {0xFB59, 0xFB59, 0xFB59}, {0xFB5A, 0xFB5A, 0xFB5A},
    {0xFB5B, 0xFB5B, 0xFB5B}, {0xFB5C, 0xFB5C, 0xFB5C},
    {0xFB5D, 0xFB5D, 0xFB5D}, {0xFB5E, 0xFB5E, 0xFB5E},
    {0xFB5F, 0xFB5F, 0xFB5F}, {0xFB60, 0xFB60, 0xFB60},
    {0xFB61, 0xFB61, 0xFB61}, {0xFB62, 0xFB62, 0xFB62},
    {0xFB63, 0xFB63, 0xFB63}, {0xFB64, 0xFB64, 0xFB64},
    {0xFB65, 0xFB65, 0xFB65}, {0xFB66, 0xFB66, 0xFB66},
    {0xFB67, 0xFB67, 0xFB67}, {0xFB68, 0xFB68, 0xFB68},
    {0xFB69, 0xFB69, 0xFB69}, {0xFB6A, 0xFB6A, 0xFB6A},
    {0xFB6B, 0xFB6B, 0xFB6B}, {0xFB6C, 0xFB6C, 0xFB6C},
    {0xFB6D, 0xFB6D, 0xFB6D}, {0xFB6E, 0xFB6E, 0xFB6E},
    {0xFB6F, 0xFB6F, 0xFB6F}, {0xFB70, 0xFB70, 0xFB70},
    {0xFB71, 0xFB71, 0xFB71}, {0xFB72, 0xFB72, 0xFB72},
    {0xFB73, 0xFB73, 0xFB73}, {0xFB74, 0xFB74, 0xFB74},
    {0xFB75, 0xFB75, 0xFB75}, {0xFB76, 0xFB76, 0xFB76},
    {0xFB77, 0xFB77, 0xFB77}, {0xFB78, 0xFB78, 0xFB78},
    {0xFB79, 0xFB79, 0xFB79}, {0xFB7A, 0xFB7A, 0xFB7A},
    {0xFB7B, 0xFB7B, 0xFB7B}, {0xFB7C, 0xFB7C, 0xFB7C},
    {0xFB7D, 0xFB7D, 0xFB7D}, {0xFB7E, 0xFB7E, 0xFB7E},
    {0xFB7F, 0xFB7F, 0xFB7F}, {0xFB80, 0xFB80, 0xFB80},
    {0xFB81, 0xFB81, 0xFB81}, {0xFB82, 0xFB82, 0xFB82},
    {0xFB83, 0xFB83, 0xFB83}, {0xFB84, 0xFB84, 0xFB84},
    {0xFB85, 0xFB85, 0xFB85}, {0xFB86, 0xFB86, 0xFB86},
    {0xFB87, 0xFB87, 0xFB87}, {0xFB88, 0xFB88, 0xFB88},
    {0xFB89, 0xFB89, 0xFB89}, {0xFB8A, 0xFB8A, 0xFB8A},
    {0xFB8B, 0xFB8B, 0xFB8B}, {0xFB8C, 0xFB8C, 0xFB8C},
    {0xFB8D, 0xFB8D, 0xFB8D}, {0xFB8E, 0xFB8E, 0xFB8E},
    {0xFB8F, 0xFB8F, 0xFB8F}, {0xFB90, 0xFB90, 0xFB90},
    {0xFB91, 0xFB91, 0xFB91}, {0xFB92, 0xFB92, 0xFB92},
    {0xFB93, 0xFB93, 0xFB93}, {0xFB94, 0xFB94, 0xFB94},
    {0xFB95, 0xFB95, 0xFB95}, {0xFB96, 0xFB96, 0xFB96},
    {0xFB97, 0xFB97, 0xFB97}, {0xFB98, 0xFB98, 0xFB98},
    {0xFB99, 0xFB99, 0xFB99}, {0xFB9A, 0xFB9A, 0xFB9A},
    {0xFB9B, 0xFB9B, 0xFB9B}, {0xFB9C, 0xFB9C, 0xFB9C},
    {0xFB9D, 0xFB9D, 0xFB9D}, {0xFB9E, 0xFB9E, 0xFB9E},
    {0xFB9F, 0xFB9F, 0xFB9F}, {0xFBA0, 0xFBA0, 0xFBA0},
    {0xFBA1, 0xFBA1, 0xFBA1}, {0xFBA2, 0xFBA2, 0xFBA2},
    {0xFBA3, 0xFBA3, 0xFBA3}, {0xFBA4, 0xFBA4, 0xFBA4},
    {0xFBA5, 0xFBA5, 0xFBA5}, {0xFBA6, 0xFBA6, 0xFBA6},
    {0xFBA7, 0xFBA7, 0xFBA7}, {0xFBA8, 0xFBA8, 0xFBA8},
    {0xFBA9, 0xFBA9, 0xFBA9}, {0xFBAA, 0xFBAA, 0xFBAA},
    {0xFBAB, 0xFBAB, 0xFBAB}, {0xFBAC, 0xFBAC, 0xFBAC},
    {0xFBAD, 0xFBAD, 0xFBAD}, {0xFBAE, 0xFBAE, 0xFBAE},
    {0xFBAF, 0xFBAF, 0xFBAF}, {0xFBB0, 0xFBB0, 0xFBB0},
    {0xFBB1, 0xFBB1, 0xFBB1}, {0xFBD3, 0xFBD3, 0xFBD3},
    {0xFBD4, 0xFBD4, 0xFBD4}, {0xFBD5, 0xFBD5, 0xFBD5},
    {0xFBD6, 0xFBD6, 0xFBD6}, {0xFBD7, 0xFBD7, 0xFBD7},
    {0xFBD8, 0xFBD8, 0xFBD8}, {0xFBD9, 0xFBD9, 0xFBD9},
    {0xFBDA, 0xFBDA, 0xFBDA}, {0xFBDB, 0xFBDB, 0xFBDB},
    {0xFBDC, 0xFBDC, 0xFBDC}, {0xFBDD, 0xFBDD, 0xFBDD},
    {0xFBDE, 0xFBDE, 0xFBDE}, {0xFBDF, 0xFBDF, 0xFBDF},
    {0xFBE0, 0xFBE0, 0xFBE0}, {0xFBE1, 0xFBE1, 0xFBE1},
    {0xFBE2, 0xFBE2, 0xFBE2}, {0xFBE3, 0xFBE3, 0xFBE3},
    {0xFBE4, 0xFBE4, 0xFBE4}, {0xFBE5, 0xFBE5, 0xFBE5},
    {0xFBE6, 0xFBE6, 0xFBE6}, {0xFBE7, 0xFBE7, 0xFBE7},
    {0xFBE8, 0xFBE8, 0xFBE8}, {0xFBE9, 0xFBE9, 0xFBE9},
    {0xFBEA, 0xFBEA, 0xFBEA}, {0xFBEB, 0xFBEB, 0xFBEB},
    {0xFBEC, 0xFBEC, 0xFBEC}, {0xFBED, 0xFBED, 0xFBED},
    {0xFBEE, 0xFBEE, 0xFBEE}, {0xFBEF, 0xFBEF, 0xFBEF},
    {0xFBF0, 0xFBF0, 0xFBF0}, {0xFBF1, 0xFBF1, 0xFBF1},
    {0xFBF2, 0xFBF2, 0xFBF2}, {0xFBF3, 0xFBF3, 0xFBF3},
    {0xFBF4, 0xFBF4, 0xFBF4}, {0xFBF5, 0xFBF5, 0xFBF5},
    {0xFBF6, 0xFBF6, 0xFBF6}, {0xFBF7, 0xFBF7, 0xFBF7},
    {0xFBF8, 0xFBF8, 0xFBF8}, {0xFBF9, 0xFBF9, 0xFBF9},
    {0xFBFA, 0xFBFA, 0xFBFA}, {0xFBFB, 0xFBFB, 0xFBFB},
    {0xFBFC, 0xFBFC, 0xFBFC}, {0xFBFD, 0xFBFD, 0xFBFD},
    {0xFBFE, 0xFBFE, 0xFBFE}, {0xFBFF, 0xFBFF, 0xFBFF},
    {0xFC00, 0xFC00, 0xFC00}, {0xFC01, 0xFC01, 0xFC01},
    {0xFC02, 0xFC02, 0xFC02}, {0xFC03, 0xFC03, 0xFC03},
    {0xFC04, 0xFC04, 0xFC04}, {0xFC05, 0xFC05, 0xFC05},
    {0xFC06, 0xFC06, 0xFC06}, {0xFC07, 0xFC07, 0xFC07},
    {0xFC08, 0xFC08, 0xFC08}, {0xFC09, 0xFC09, 0xFC09},
    {0xFC0A, 0xFC0A, 0xFC0A}, {0xFC0B, 0xFC0B, 0xFC0B},
    {0xFC0C, 0xFC0C, 0xFC0C}, {0xFC0D, 0xFC0D, 0xFC0D},
    {0xFC0E, 0xFC0E, 0xFC0E}, {0xFC0F, 0xFC0F, 0xFC0F},
    {0xFC10, 0xFC10, 0xFC10}, {0xFC11, 0xFC11, 0xFC11},
    {0xFC12, 0xFC12, 0xFC12}, {0xFC13, 0xFC13, 0xFC13},
    {0xFC14, 0xFC14, 0xFC14}, {0xFC15, 0xFC15, 0xFC15},
    {0xFC16, 0xFC16, 0xFC16}, {0xFC17, 0xFC17, 0xFC17},
    {0xFC18, 0xFC18, 0xFC18}, {0xFC19, 0xFC19, 0xFC19},
    {0xFC1A, 0xFC1A, 0xFC1A}, {0xFC1B, 0xFC1B, 0xFC1B},
    {0xFC1C, 0xFC1C, 0xFC1C}, {0xFC1D, 0xFC1D, 0xFC1D},
    {0xFC1E, 0xFC1E, 0xFC1E}, {0xFC1F, 0xFC1F, 0xFC1F},
    {0xFC20, 0xFC20, 0xFC20}, {0xFC21, 0xFC21, 0xFC21},
    {0xFC22, 0xFC22, 0xFC22}, {0xFC23, 0xFC23, 0xFC23},
    {0xFC24, 0xFC24, 0xFC24}, {0xFC25, 0xFC25, 0xFC25},
    {0xFC26, 0xFC26, 0xFC26}, {0xFC27, 0xFC27, 0xFC27},
    {0xFC28, 0xFC28, 0xFC28}, {0xFC29, 0xFC29, 0xFC29},
    {0xFC2A, 0xFC2A, 0xFC2A}, {0xFC2B, 0xFC2B, 0xFC2B},
    {0xFC2C, 0xFC2C, 0xFC2C}, {0xFC2D, 0xFC2D, 0xFC2D},
    {0xFC2E, 0xFC2E, 0xFC2E}, {0xFC2F, 0xFC2F, 0xFC2F},
    {0xFC30, 0xFC30, 0xFC30}, {0xFC31, 0xFC31, 0xFC31},
    {0xFC32, 0xFC32, 0xFC32}, {0xFC33, 0xFC33, 0xFC33},
    {0xFC34, 0xFC34, 0xFC34}, {0xFC35, 0xFC35, 0xFC35},
    {0xFC36, 0xFC36, 0xFC36}, {0xFC37, 0xFC37, 0xFC37},
    {0xFC38, 0xFC38, 0xFC38}, {0xFC39, 0xFC39, 0xFC39},
    {0xFC3A, 0xFC3A, 0xFC3A}, {0xFC3B, 0xFC3B, 0xFC3B},
    {0xFC3C, 0xFC3C, 0xFC3C}, {0xFC3D, 0xFC3D, 0xFC3D},
    {0xFC3E, 0xFC3E, 0xFC3E}, {0xFC3F, 0xFC3F, 0xFC3F},
    {0xFC40, 0xFC40, 0xFC40}, {0xFC41, 0xFC41, 0xFC41},
    {0xFC42, 0xFC42, 0xFC42}, {0xFC43, 0xFC43, 0xFC43},
    {0xFC44, 0xFC44, 0xFC44}, {0xFC45, 0xFC45, 0xFC45},
    {0xFC46, 0xFC46, 0xFC46}, {0xFC47, 0xFC47, 0xFC47},
    {0xFC48, 0xFC48, 0xFC48}, {0xFC49, 0xFC49, 0xFC49},
    {0xFC4A, 0xFC4A, 0xFC4A}, {0xFC4B, 0xFC4B, 0xFC4B},
    {0xFC4C, 0xFC4C, 0xFC4C}, {0xFC4D, 0xFC4D, 0xFC4D},
    {0xFC4E, 0xFC4E, 0xFC4E}, {0xFC4F, 0xFC4F, 0xFC4F},
    {0xFC50, 0xFC50, 0xFC50}, {0xFC51, 0xFC51, 0xFC51},
    {0xFC52, 0xFC52, 0xFC52}, {0xFC53, 0xFC53, 0xFC53},
    {0xFC54, 0xFC54, 0xFC54}, {0xFC55, 0xFC55, 0xFC55},
    {0xFC56, 0xFC56, 0xFC56}, {0xFC57, 0xFC57, 0xFC57},
    {0xFC58, 0xFC58, 0xFC58}, {0xFC59, 0xFC59, 0xFC59},
    {0xFC5A, 0xFC5A, 0xFC5A}, {0xFC5B, 0xFC5B, 0xFC5B},
    {0xFC5C, 0xFC5C, 0xFC5C}, {0xFC5D, 0xFC5D, 0xFC5D},
    {0xFC5E, 0xFC5E, 0xFC5E}, {0xFC5F, 0xFC5F, 0xFC5F},
    {0xFC60, 0xFC60, 0xFC60}, {0xFC61, 0xFC61, 0xFC61},
    {0xFC62, 0xFC62, 0xFC62}, {0xFC63, 0xFC63, 0xFC63},
    {0xFC64, 0xFC64, 0xFC64}, {0xFC65, 0xFC65, 0xFC65},
    {0xFC66, 0xFC66, 0xFC66}, {0xFC67, 0xFC67, 0xFC67},
    {0xFC68, 0xFC68, 0xFC68}, {0xFC69, 0xFC69, 0xFC69},
    {0xFC6A, 0xFC6A, 0xFC6A}, {0xFC6B, 0xFC6B, 0xFC6B},
    {0xFC6C, 0xFC6C, 0xFC6C}, {0xFC6D, 0xFC6D, 0xFC6D},
    {0xFC6E, 0xFC6E, 0xFC6E}, {0xFC6F, 0xFC6F, 0xFC6F},
    {0xFC70, 0xFC70, 0xFC70}, {0xFC71, 0xFC71, 0xFC71},
    {0xFC72, 0xFC72, 0xFC72}, {0xFC73, 0xFC73, 0xFC73},
    {0xFC74, 0xFC74, 0xFC74}, {0xFC75, 0xFC75, 0xFC75},
    {0xFC76, 0xFC76, 0xFC76}, {0xFC77, 0xFC77, 0xFC77},
    {0xFC78, 0xFC78, 0xFC78}, {0xFC79, 0xFC79, 0xFC79},
    {0xFC7A, 0xFC7A, 0xFC7A}, {0xFC7B, 0xFC7B, 0xFC7B},
    {0xFC7C, 0xFC7C, 0xFC7C}, {0xFC7D, 0xFC7D, 0xFC7D},
    {0xFC7E, 0xFC7E, 0xFC7E}, {0xFC7F, 0xFC7F, 0xFC7F},
    {0xFC80, 0xFC80, 0xFC80}, {0xFC81, 0xFC81, 0xFC81},
    {0xFC82, 0xFC82, 0xFC82}, {0xFC83, 0xFC83, 0xFC83},
    {0xFC84, 0xFC84, 0xFC84}, {0xFC85, 0xFC85, 0xFC85},
    {0xFC86, 0xFC86, 0xFC86}, {0xFC87, 0xFC87, 0xFC87},
    {0xFC88, 0xFC88, 0xFC88}, {0xFC89, 0xFC89, 0xFC89},
    {0xFC8A, 0xFC8A, 0xFC8A}, {0xFC8B, 0xFC8B, 0xFC8B},
    {0xFC8C, 0xFC8C, 0xFC8C}, {0xFC8D, 0xFC8D, 0xFC8D},
    {0xFC8E, 0xFC8E, 0xFC8E}, {0xFC8F, 0xFC8F, 0xFC8F},
    {0xFC90, 0xFC90, 0xFC90}, {0xFC91, 0xFC91, 0xFC91},
    {0xFC92, 0xFC92, 0xFC92}, {0xFC93, 0xFC93, 0xFC93},
    {0xFC94, 0xFC94, 0xFC94}, {0xFC95, 0xFC95, 0xFC95},
    {0xFC96, 0xFC96, 0xFC96}, {0xFC97, 0xFC97, 0xFC97},
    {0xFC98, 0xFC98, 0xFC98}, {0xFC99, 0xFC99, 0xFC99},
    {0xFC9A, 0xFC9A, 0xFC9A}, {0xFC9B, 0xFC9B, 0xFC9B},
    {0xFC9C, 0xFC9C, 0xFC9C}, {0xFC9D, 0xFC9D, 0xFC9D},
    {0xFC9E, 0xFC9E, 0xFC9E}, {0xFC9F, 0xFC9F, 0xFC9F},
    {0xFCA0, 0xFCA0, 0xFCA0}, {0xFCA1, 0xFCA1, 0xFCA1},
    {0xFCA2, 0xFCA2, 0xFCA2}, {0xFCA3, 0xFCA3, 0xFCA3},
    {0xFCA4, 0xFCA4, 0xFCA4}, {0xFCA5, 0xFCA5, 0xFCA5},
    {0xFCA6, 0xFCA6, 0xFCA6}, {0xFCA7, 0xFCA7, 0xFCA7},
    {0xFCA8, 0xFCA8, 0xFCA8}, {0xFCA9, 0xFCA9, 0xFCA9},
    {0xFCAA, 0xFCAA, 0xFCAA}, {0xFCAB, 0xFCAB, 0xFCAB},
    {0xFCAC, 0xFCAC, 0xFCAC}, {0xFCAD, 0xFCAD, 0xFCAD},
    {0xFCAE, 0xFCAE, 0xFCAE}, {0xFCAF, 0xFCAF, 0xFCAF},
    {0xFCB0, 0xFCB0, 0xFCB0}, {0xFCB1, 0xFCB1, 0xFCB1},
    {0xFCB2, 0xFCB2, 0xFCB2}, {0xFCB3, 0xFCB3, 0xFCB3},
    {0xFCB4, 0xFCB4, 0xFCB4}, {0xFCB5, 0xFCB5, 0xFCB5},
    {0xFCB6, 0xFCB6, 0xFCB6}, {0xFCB7, 0xFCB7, 0xFCB7},
    {0xFCB8, 0xFCB8, 0xFCB8}, {0xFCB9, 0xFCB9, 0xFCB9},
    {0xFCBA, 0xFCBA, 0xFCBA}, {0xFCBB, 0xFCBB, 0xFCBB},
    {0xFCBC, 0xFCBC, 0xFCBC}, {0xFCBD, 0xFCBD, 0xFCBD},
    {0xFCBE, 0xFCBE, 0xFCBE}, {0xFCBF, 0xFCBF, 0xFCBF},
    {0xFCC0, 0xFCC0, 0xFCC0}, {0xFCC1, 0xFCC1, 0xFCC1},
    {0xFCC2, 0xFCC2, 0xFCC2}, {0xFCC3, 0xFCC3, 0xFCC3},
    {0xFCC4, 0xFCC4, 0xFCC4}, {0xFCC5, 0xFCC5, 0xFCC5},
    {0xFCC6, 0xFCC6, 0xFCC6}, {0xFCC7, 0xFCC7, 0xFCC7},
    {0xFCC8, 0xFCC8, 0xFCC8}, {0xFCC9, 0xFCC9, 0xFCC9},
    {0xFCCA, 0xFCCA, 0xFCCA}, {0xFCCB, 0xFCCB, 0xFCCB},
    {0xFCCC, 0xFCCC, 0xFCCC}, {0xFCCD, 0xFCCD, 0xFCCD},
    {0xFCCE, 0xFCCE, 0xFCCE}, {0xFCCF, 0xFCCF, 0xFCCF},
    {0xFCD0, 0xFCD0, 0xFCD0}, {0xFCD1, 0xFCD1, 0xFCD1},
    {0xFCD2, 0xFCD2, 0xFCD2}, {0xFCD3, 0xFCD3, 0xFCD3},
    {0xFCD4, 0xFCD4, 0xFCD4}, {0xFCD5, 0xFCD5, 0xFCD5},
    {0xFCD6, 0xFCD6, 0xFCD6}, {0xFCD7, 0xFCD7, 0xFCD7},
    {0xFCD8, 0xFCD8, 0xFCD8}, {0xFCD9, 0xFCD9, 0xFCD9},
    {0xFCDA, 0xFCDA, 0xFCDA}, {0xFCDB, 0xFCDB, 0xFCDB},
    {0xFCDC, 0xFCDC, 0xFCDC}, {0xFCDD, 0xFCDD, 0xFCDD},
    {0xFCDE, 0xFCDE, 0xFCDE}, {0xFCDF, 0xFCDF, 0xFCDF},
    {0xFCE0, 0xFCE0, 0xFCE0}, {0xFCE1, 0xFCE1, 0xFCE1},
    {0xFCE2, 0xFCE2, 0xFCE2}, {0xFCE3, 0xFCE3, 0xFCE3},
    {0xFCE4, 0xFCE4, 0xFCE4}, {0xFCE5, 0xFCE5, 0xFCE5},
    {0xFCE6, 0xFCE6, 0xFCE6}, {0xFCE7, 0xFCE7, 0xFCE7},
    {0xFCE8, 0xFCE8, 0xFCE8}, {0xFCE9, 0xFCE9, 0xFCE9},
    {0xFCEA, 0xFCEA, 0xFCEA}, {0xFCEB, 0xFCEB, 0xFCEB},
    {0xFCEC, 0xFCEC, 0xFCEC}, {0xFCED, 0xFCED, 0xFCED},
    {0xFCEE, 0xFCEE, 0xFCEE}, {0xFCEF, 0xFCEF, 0xFCEF},
    {0xFCF0, 0xFCF0, 0xFCF0}, {0xFCF1, 0xFCF1, 0xFCF1},
    {0xFCF2, 0xFCF2, 0xFCF2}, {0xFCF3, 0xFCF3, 0xFCF3},
    {0xFCF4, 0xFCF4, 0xFCF4}, {0xFCF5, 0xFCF5, 0xFCF5},
    {0xFCF6, 0xFCF6, 0xFCF6}, {0xFCF7, 0xFCF7, 0xFCF7},
    {0xFCF8, 0xFCF8, 0xFCF8}, {0xFCF9, 0xFCF9, 0xFCF9},
    {0xFCFA, 0xFCFA, 0xFCFA}, {0xFCFB, 0xFCFB, 0xFCFB},
    {0xFCFC, 0xFCFC, 0xFCFC}, {0xFCFD, 0xFCFD, 0xFCFD},
    {0xFCFE, 0xFCFE, 0xFCFE}, {0xFCFF, 0xFCFF, 0xFCFF},
    {0xFD00, 0xFD00, 0xFD00}, {0xFD01, 0xFD01, 0xFD01},
    {0xFD02, 0xFD02, 0xFD02}, {0xFD03, 0xFD03, 0xFD03},
    {0xFD04, 0xFD04, 0xFD04}, {0xFD05, 0xFD05, 0xFD05},
    {0xFD06, 0xFD06, 0xFD06}, {0xFD07, 0xFD07, 0xFD07},
    {0xFD08, 0xFD08, 0xFD08}, {0xFD09, 0xFD09, 0xFD09},
    {0xFD0A, 0xFD0A, 0xFD0A}, {0xFD0B, 0xFD0B, 0xFD0B},
    {0xFD0C, 0xFD0C, 0xFD0C}, {0xFD0D, 0xFD0D, 0xFD0D},
    {0xFD0E, 0xFD0E, 0xFD0E}, {0xFD0F, 0xFD0F, 0xFD0F},
    {0xFD10, 0xFD10, 0xFD10}, {0xFD11, 0xFD11, 0xFD11},
    {0xFD12, 0xFD12, 0xFD12}, {0xFD13, 0xFD13, 0xFD13},
    {0xFD14, 0xFD14, 0xFD14}, {0xFD15, 0xFD15, 0xFD15},
    {0xFD16, 0xFD16, 0xFD16}, {0xFD17, 0xFD17, 0xFD17},
    {0xFD18, 0xFD18, 0xFD18}, {0xFD19, 0xFD19, 0xFD19},
    {0xFD1A, 0xFD1A, 0xFD1A}, {0xFD1B, 0xFD1B, 0xFD1B},
    {0xFD1C, 0xFD1C, 0xFD1C}, {0xFD1D, 0xFD1D, 0xFD1D},
    {0xFD1E, 0xFD1E, 0xFD1E}, {0xFD1F, 0xFD1F, 0xFD1F},
    {0xFD20, 0xFD20, 0xFD20}, {0xFD21, 0xFD21, 0xFD21},
    {0xFD22, 0xFD22, 0xFD22}, {0xFD23, 0xFD23, 0xFD23},
    {0xFD24, 0xFD24, 0xFD24}, {0xFD25, 0xFD25, 0xFD25},
    {0xFD26, 0xFD26, 0xFD26}, {0xFD27, 0xFD27, 0xFD27},
    {0xFD28, 0xFD28, 0xFD28}, {0xFD29, 0xFD29, 0xFD29},
    {0xFD2A, 0xFD2A, 0xFD2A}, {0xFD2B, 0xFD2B, 0xFD2B},
    {0xFD2C, 0xFD2C, 0xFD2C}, {0xFD2D, 0xFD2D, 0xFD2D},
    {0xFD2E, 0xFD2E, 0xFD2E}, {0xFD2F, 0xFD2F, 0xFD2F},
    {0xFD30, 0xFD30, 0xFD30}, {0xFD31, 0xFD31, 0xFD31},
    {0xFD32, 0xFD32, 0xFD32}, {0xFD33, 0xFD33, 0xFD33},
    {0xFD34, 0xFD34, 0xFD34}, {0xFD35, 0xFD35, 0xFD35},
    {0xFD36, 0xFD36, 0xFD36}, {0xFD37, 0xFD37, 0xFD37},
    {0xFD38, 0xFD38, 0xFD38}, {0xFD39, 0xFD39, 0xFD39},
    {0xFD3A, 0xFD3A, 0xFD3A}, {0xFD3B, 0xFD3B, 0xFD3B},
    {0xFD3C, 0xFD3C, 0xFD3C}, {0xFD3D, 0xFD3D, 0xFD3D},
    {0xFD50, 0xFD50, 0xFD50}, {0xFD51, 0xFD51, 0xFD51},
    {0xFD52, 0xFD52, 0xFD52}, {0xFD53, 0xFD53, 0xFD53},
    {0xFD54, 0xFD54, 0xFD54}, {0xFD55, 0xFD55, 0xFD55},
    {0xFD56, 0xFD56, 0xFD56}, {0xFD57, 0xFD57, 0xFD57},
    {0xFD58, 0xFD58, 0xFD58}, {0xFD59, 0xFD59, 0xFD59},
    {0xFD5A, 0xFD5A, 0xFD5A}, {0xFD5B, 0xFD5B, 0xFD5B},
    {0xFD5C, 0xFD5C, 0xFD5C}, {0xFD5D, 0xFD5D, 0xFD5D},
    {0xFD5E, 0xFD5E, 0xFD5E}, {0xFD5F, 0xFD5F, 0xFD5F},
    {0xFD60, 0xFD60, 0xFD60}, {0xFD61, 0xFD61, 0xFD61},
    {0xFD62, 0xFD62, 0xFD62}, {0xFD63, 0xFD63, 0xFD63},
    {0xFD64, 0xFD64, 0xFD64}, {0xFD65, 0xFD65, 0xFD65},
    {0xFD66, 0xFD66, 0xFD66}, {0xFD67, 0xFD67, 0xFD67},
    {0xFD68, 0xFD68, 0xFD68}, {0xFD69, 0xFD69, 0xFD69},
    {0xFD6A, 0xFD6A, 0xFD6A}, {0xFD6B, 0xFD6B, 0xFD6B},
    {0xFD6C, 0xFD6C, 0xFD6C}, {0xFD6D, 0xFD6D, 0xFD6D},
    {0xFD6E, 0xFD6E, 0xFD6E}, {0xFD6F, 0xFD6F, 0xFD6F},
    {0xFD70, 0xFD70, 0xFD70}, {0xFD71, 0xFD71, 0xFD71},
    {0xFD72, 0xFD72, 0xFD72}, {0xFD73, 0xFD73, 0xFD73},
    {0xFD74, 0xFD74, 0xFD74}, {0xFD75, 0xFD75, 0xFD75},
    {0xFD76, 0xFD76, 0xFD76}, {0xFD77, 0xFD77, 0xFD77},
    {0xFD78, 0xFD78, 0xFD78}, {0xFD79, 0xFD79, 0xFD79},
    {0xFD7A, 0xFD7A, 0xFD7A}, {0xFD7B, 0xFD7B, 0xFD7B},
    {0xFD7C, 0xFD7C, 0xFD7C}, {0xFD7D, 0xFD7D, 0xFD7D},
    {0xFD7E, 0xFD7E, 0xFD7E}, {0xFD7F, 0xFD7F, 0xFD7F},
    {0xFD80, 0xFD80, 0xFD80}, {0xFD81, 0xFD81, 0xFD81},
    {0xFD82, 0xFD82, 0xFD82}, {0xFD83, 0xFD83, 0xFD83},
    {0xFD84, 0xFD84, 0xFD84}, {0xFD85, 0xFD85, 0xFD85},
    {0xFD86, 0xFD86, 0xFD86}, {0xFD87, 0xFD87, 0xFD87},
    {0xFD88, 0xFD88, 0xFD88}, {0xFD89, 0xFD89, 0xFD89},
    {0xFD8A, 0xFD8A, 0xFD8A}, {0xFD8B, 0xFD8B, 0xFD8B},
    {0xFD8C, 0xFD8C, 0xFD8C}, {0xFD8D, 0xFD8D, 0xFD8D},
    {0xFD8E, 0xFD8E, 0xFD8E}, {0xFD8F, 0xFD8F, 0xFD8F},
    {0xFD92, 0xFD92, 0xFD92}, {0xFD93, 0xFD93, 0xFD93},
    {0xFD94, 0xFD94, 0xFD94}, {0xFD95, 0xFD95, 0xFD95},
    {0xFD96, 0xFD96, 0xFD96}, {0xFD97, 0xFD97, 0xFD97},
    {0xFD98, 0xFD98, 0xFD98}, {0xFD99, 0xFD99, 0xFD99},
    {0xFD9A, 0xFD9A, 0xFD9A}, {0xFD9B, 0xFD9B, 0xFD9B},
    {0xFD9C, 0xFD9C, 0xFD9C}, {0xFD9D, 0xFD9D, 0xFD9D},
    {0xFD9E, 0xFD9E, 0xFD9E}, {0xFD9F, 0xFD9F, 0xFD9F},
    {0xFDA0, 0xFDA0, 0xFDA0}, {0xFDA1, 0xFDA1, 0xFDA1},
    {0xFDA2, 0xFDA2, 0xFDA2}, {0xFDA3, 0xFDA3, 0xFDA3},
    {0xFDA4, 0xFDA4, 0xFDA4}, {0xFDA5, 0xFDA5, 0xFDA5},
    {0xFDA6, 0xFDA6, 0xFDA6}, {0xFDA7, 0xFDA7, 0xFDA7},
    {0xFDA8, 0xFDA8, 0xFDA8}, {0xFDA9, 0xFDA9, 0xFDA9},
    {0xFDAA, 0xFDAA, 0xFDAA}, {0xFDAB, 0xFDAB, 0xFDAB},
    {0xFDAC, 0xFDAC, 0xFDAC}, {0xFDAD, 0xFDAD, 0xFDAD},
    {0xFDAE, 0xFDAE, 0xFDAE}, {0xFDAF, 0xFDAF, 0xFDAF},
    {0xFDB0, 0xFDB0, 0xFDB0}, {0xFDB1, 0xFDB1, 0xFDB1},
    {0xFDB2, 0xFDB2, 0xFDB2}, {0xFDB3, 0xFDB3, 0xFDB3},
    {0xFDB4, 0xFDB4, 0xFDB4}, {0xFDB5, 0xFDB5, 0xFDB5},
    {0xFDB6, 0xFDB6, 0xFDB6}, {0xFDB7, 0xFDB7, 0xFDB7},
    {0xFDB8, 0xFDB8, 0xFDB8}, {0xFDB9, 0xFDB9, 0xFDB9},
    {0xFDBA, 0xFDBA, 0xFDBA}, {0xFDBB, 0xFDBB, 0xFDBB},
    {0xFDBC, 0xFDBC, 0xFDBC}, {0xFDBD, 0xFDBD, 0xFDBD},
    {0xFDBE, 0xFDBE, 0xFDBE}, {0xFDBF, 0xFDBF, 0xFDBF},
    {0xFDC0, 0xFDC0, 0xFDC0}, {0xFDC1, 0xFDC1, 0xFDC1},
    {0xFDC2, 0xFDC2, 0xFDC2}, {0xFDC3, 0xFDC3, 0xFDC3},
    {0xFDC4, 0xFDC4, 0xFDC4}, {0xFDC5, 0xFDC5, 0xFDC5},
    {0xFDC6, 0xFDC6, 0xFDC6}, {0xFDC7, 0xFDC7, 0xFDC7},
    {0xFDF0, 0xFDF0, 0xFDF0}, {0xFDF1, 0xFDF1, 0xFDF1},
    {0xFDF2, 0xFDF2, 0xFDF2}, {0xFDF3, 0xFDF3, 0xFDF3},
    {0xFDF4, 0xFDF4, 0xFDF4}, {0xFDF5, 0xFDF5, 0xFDF5},
    {0xFDF6, 0xFDF6, 0xFDF6}, {0xFDF7, 0xFDF7, 0xFDF7},
    {0xFDF8, 0xFDF8, 0xFDF8}, {0xFDF9, 0xFDF9, 0xFDF9},
    {0xFDFA, 0xFDFA, 0xFDFA}, {0xFDFB, 0xFDFB, 0xFDFB},
    {0xFE00, 0xFE00, 0xFE00}, {0xFE01, 0xFE01, 0xFE01},
    {0xFE02, 0xFE02, 0xFE02}, {0xFE03, 0xFE03, 0xFE03},
    {0xFE04, 0xFE04, 0xFE04}, {0xFE05, 0xFE05, 0xFE05},
    {0xFE06, 0xFE06, 0xFE06}, {0xFE07, 0xFE07, 0xFE07},
    {0xFE08, 0xFE08, 0xFE08}, {0xFE09, 0xFE09, 0xFE09},
    {0xFE0A, 0xFE0A, 0xFE0A}, {0xFE0B, 0xFE0B, 0xFE0B},
    {0xFE0C, 0xFE0C, 0xFE0C}, {0xFE0D, 0xFE0D, 0xFE0D},
    {0xFE0E, 0xFE0E, 0xFE0E}, {0xFE0F, 0xFE0F, 0xFE0F},
    {0xFE20, 0xFE20, 0xFE20}, {0xFE21, 0xFE21, 0xFE21},
    {0xFE22, 0xFE22, 0xFE22}, {0xFE23, 0xFE23, 0xFE23},
    {0xFE70, 0xFE70, 0xFE70}, {0xFE71, 0xFE71, 0xFE71},
    {0xFE72, 0xFE72, 0xFE72}, {0xFE73, 0xFE73, 0xFE73},
    {0xFE74, 0xFE74, 0xFE74}, {0xFE76, 0xFE76, 0xFE76},
    {0xFE77, 0xFE77, 0xFE77}, {0xFE78, 0xFE78, 0xFE78},
    {0xFE79, 0xFE79, 0xFE79}, {0xFE7A, 0xFE7A, 0xFE7A},
    {0xFE7B, 0xFE7B, 0xFE7B}, {0xFE7C, 0xFE7C, 0xFE7C},
    {0xFE7D, 0xFE7D, 0xFE7D}, {0xFE7E, 0xFE7E, 0xFE7E},
    {0xFE7F, 0xFE7F, 0xFE7F}, {0xFE80, 0xFE80, 0xFE80},
    {0xFE81, 0xFE81, 0xFE81}, {0xFE82, 0xFE82, 0xFE82},
    {0xFE83, 0xFE83, 0xFE83}, {0xFE84, 0xFE84, 0xFE84},
    {0xFE85, 0xFE85, 0xFE85}, {0xFE86, 0xFE86, 0xFE86},
    {0xFE87, 0xFE87, 0xFE87}, {0xFE88, 0xFE88, 0xFE88},
    {0xFE89, 0xFE89, 0xFE89}, {0xFE8A, 0xFE8A, 0xFE8A},
    {0xFE8B, 0xFE8B, 0xFE8B}, {0xFE8C, 0xFE8C, 0xFE8C},
    {0xFE8D, 0xFE8D, 0xFE8D}, {0xFE8E, 0xFE8E, 0xFE8E},
    {0xFE8F, 0xFE8F, 0xFE8F}, {0xFE90, 0xFE90, 0xFE90},
    {0xFE91, 0xFE91, 0xFE91}, {0xFE92, 0xFE92, 0xFE92},
    {0xFE93, 0xFE93, 0xFE93}, {0xFE94, 0xFE94, 0xFE94},
    {0xFE95, 0xFE95, 0xFE95}, {0xFE96, 0xFE96, 0xFE96},
    {0xFE97, 0xFE97, 0xFE97}, {0xFE98, 0xFE98, 0xFE98},
    {0xFE99, 0xFE99, 0xFE99}, {0xFE9A, 0xFE9A, 0xFE9A},
    {0xFE9B, 0xFE9B, 0xFE9B}, {0xFE9C, 0xFE9C, 0xFE9C},
    {0xFE9D, 0xFE9D, 0xFE9D}, {0xFE9E, 0xFE9E, 0xFE9E},
    {0xFE9F, 0xFE9F, 0xFE9F}, {0xFEA0, 0xFEA0, 0xFEA0},
    {0xFEA1, 0xFEA1, 0xFEA1}, {0xFEA2, 0xFEA2, 0xFEA2},
    {0xFEA3, 0xFEA3, 0xFEA3}, {0xFEA4, 0xFEA4, 0xFEA4},
    {0xFEA5, 0xFEA5, 0xFEA5}, {0xFEA6, 0xFEA6, 0xFEA6},
    {0xFEA7, 0xFEA7, 0xFEA7}, {0xFEA8, 0xFEA8, 0xFEA8},
    {0xFEA9, 0xFEA9, 0xFEA9}, {0xFEAA, 0xFEAA, 0xFEAA},
    {0xFEAB, 0xFEAB, 0xFEAB}, {0xFEAC, 0xFEAC, 0xFEAC},
    {0xFEAD, 0xFEAD, 0xFEAD}, {0xFEAE, 0xFEAE, 0xFEAE},
    {0xFEAF, 0xFEAF, 0xFEAF}, {0xFEB0, 0xFEB0, 0xFEB0},
    {0xFEB1, 0xFEB1, 0xFEB1}, {0xFEB2, 0xFEB2, 0xFEB2},
    {0xFEB3, 0xFEB3, 0xFEB3}, {0xFEB4, 0xFEB4, 0xFEB4},
    {0xFEB5, 0xFEB5, 0xFEB5}, {0xFEB6, 0xFEB6, 0xFEB6},
    {0xFEB7, 0xFEB7, 0xFEB7}, {0xFEB8, 0xFEB8, 0xFEB8},
    {0xFEB9, 0xFEB9, 0xFEB9}, {0xFEBA, 0xFEBA, 0xFEBA},
    {0xFEBB, 0xFEBB, 0xFEBB}, {0xFEBC, 0xFEBC, 0xFEBC},
    {0xFEBD, 0xFEBD, 0xFEBD}, {0xFEBE, 0xFEBE, 0xFEBE},
    {0xFEBF, 0xFEBF, 0xFEBF}, {0xFEC0, 0xFEC0, 0xFEC0},
    {0xFEC1, 0xFEC1, 0xFEC1}, {0xFEC2, 0xFEC2, 0xFEC2},
    {0xFEC3, 0xFEC3, 0xFEC3}, {0xFEC4, 0xFEC4, 0xFEC4},
    {0xFEC5, 0xFEC5, 0xFEC5}, {0xFEC6, 0xFEC6, 0xFEC6},
    {0xFEC7, 0xFEC7, 0xFEC7}, {0xFEC8, 0xFEC8, 0xFEC8},
    {0xFEC9, 0xFEC9, 0xFEC9}, {0xFECA, 0xFECA, 0xFECA},
    {0xFECB, 0xFECB, 0xFECB}, {0xFECC, 0xFECC, 0xFECC},
    {0xFECD, 0xFECD, 0xFECD}, {0xFECE, 0xFECE, 0xFECE},
    {0xFECF, 0xFECF, 0xFECF}, {0xFED0, 0xFED0, 0xFED0},
    {0xFED1, 0xFED1, 0xFED1}, {0xFED2, 0xFED2, 0xFED2},
    {0xFED3, 0xFED3, 0xFED3}, {0xFED4, 0xFED4, 0xFED4},
    {0xFED5, 0xFED5, 0xFED5}, {0xFED6, 0xFED6, 0xFED6},
    {0xFED7, 0xFED7, 0xFED7}, {0xFED8, 0xFED8, 0xFED8},
    {0xFED9, 0xFED9, 0xFED9}, {0xFEDA, 0xFEDA, 0xFEDA},
    {0xFEDB, 0xFEDB, 0xFEDB}, {0xFEDC, 0xFEDC, 0xFEDC},
    {0xFEDD, 0xFEDD, 0xFEDD}, {0xFEDE, 0xFEDE, 0xFEDE},
    {0xFEDF, 0xFEDF, 0xFEDF}, {0xFEE0, 0xFEE0, 0xFEE0},
    {0xFEE1, 0xFEE1, 0xFEE1}, {0xFEE2, 0xFEE2, 0xFEE2},
    {0xFEE3, 0xFEE3, 0xFEE3}, {0xFEE4, 0xFEE4, 0xFEE4},
    {0xFEE5, 0xFEE5, 0xFEE5}, {0xFEE6, 0xFEE6, 0xFEE6},
    {0xFEE7, 0xFEE7, 0xFEE7}, {0xFEE8, 0xFEE8, 0xFEE8},
    {0xFEE9, 0xFEE9, 0xFEE9}, {0xFEEA, 0xFEEA, 0xFEEA},
    {0xFEEB, 0xFEEB, 0xFEEB}, {0xFEEC, 0xFEEC, 0xFEEC},
    {0xFEED, 0xFEED, 0xFEED}, {0xFEEE, 0xFEEE, 0xFEEE},
    {0xFEEF, 0xFEEF, 0xFEEF}, {0xFEF0, 0xFEF0, 0xFEF0},
    {0xFEF1, 0xFEF1, 0xFEF1}, {0xFEF2, 0xFEF2, 0xFEF2},
    {0xFEF3, 0xFEF3, 0xFEF3}, {0xFEF4, 0xFEF4, 0xFEF4},
    {0xFEF5, 0xFEF5, 0xFEF5}, {0xFEF6, 0xFEF6, 0xFEF6},
    {0xFEF7, 0xFEF7, 0xFEF7}, {0xFEF8, 0xFEF8, 0xFEF8},
    {0xFEF9, 0xFEF9, 0xFEF9}, {0xFEFA, 0xFEFA, 0xFEFA},
    {0xFEFB, 0xFEFB, 0xFEFB}, {0xFEFC, 0xFEFC, 0xFEFC},
    {0xFF21, 0xFF21, 0xFF41}, {0xFF22, 0xFF22, 0xFF42},
    {0xFF23, 0xFF23, 0xFF43}, {0xFF24, 0xFF24, 0xFF44},
    {0xFF25, 0xFF25, 0xFF45}, {0xFF26, 0xFF26, 0xFF46},
    {0xFF27, 0xFF27, 0xFF47}, {0xFF28, 0xFF28, 0xFF48},
    {0xFF29, 0xFF29, 0xFF49}, {0xFF2A, 0xFF2A, 0xFF4A},
    {0xFF2B, 0xFF2B, 0xFF4B}, {0xFF2C, 0xFF2C, 0xFF4C},
    {0xFF2D, 0xFF2D, 0xFF4D}, {0xFF2E, 0xFF2E, 0xFF4E},
    {0xFF2F, 0xFF2F, 0xFF4F}, {0xFF30, 0xFF30, 0xFF50},
    {0xFF31, 0xFF31, 0xFF51}, {0xFF32, 0xFF32, 0xFF52},
    {0xFF33, 0xFF33, 0xFF53}, {0xFF34, 0xFF34, 0xFF54},
    {0xFF35, 0xFF35, 0xFF55}, {0xFF36, 0xFF36, 0xFF56},
    {0xFF37, 0xFF37, 0xFF57}, {0xFF38, 0xFF38, 0xFF58},
    {0xFF39, 0xFF39, 0xFF59}, {0xFF3A, 0xFF3A, 0xFF5A},
    {0xFF41, 0xFF21, 0xFF41}, {0xFF42, 0xFF22, 0xFF42},
    {0xFF43, 0xFF23, 0xFF43}, {0xFF44, 0xFF24, 0xFF44},
    {0xFF45, 0xFF25, 0xFF45}, {0xFF46, 0xFF26, 0xFF46},
    {0xFF47, 0xFF27, 0xFF47}, {0xFF48, 0xFF28, 0xFF48},
    {0xFF49, 0xFF29, 0xFF49}, {0xFF4A, 0xFF2A, 0xFF4A},
    {0xFF4B, 0xFF2B, 0xFF4B}, {0xFF4C, 0xFF2C, 0xFF4C},
    {0xFF4D, 0xFF2D, 0xFF4D}, {0xFF4E, 0xFF2E, 0xFF4E},
    {0xFF4F, 0xFF2F, 0xFF4F}, {0xFF50, 0xFF30, 0xFF50},
    {0xFF51, 0xFF31, 0xFF51}, {0xFF52, 0xFF32, 0xFF52},
    {0xFF53, 0xFF33, 0xFF53}, {0xFF54, 0xFF34, 0xFF54},
    {0xFF55, 0xFF35, 0xFF55}, {0xFF56, 0xFF36, 0xFF56},
    {0xFF57, 0xFF37, 0xFF57}, {0xFF58, 0xFF38, 0xFF58},
    {0xFF59, 0xFF39, 0xFF59}, {0xFF5A, 0xFF3A, 0xFF5A},
    {0xFF66, 0xFF66, 0xFF66}, {0xFF67, 0xFF67, 0xFF67},
    {0xFF68, 0xFF68, 0xFF68}, {0xFF69, 0xFF69, 0xFF69},
    {0xFF6A, 0xFF6A, 0xFF6A}, {0xFF6B, 0xFF6B, 0xFF6B},
    {0xFF6C, 0xFF6C, 0xFF6C}, {0xFF6D, 0xFF6D, 0xFF6D},
    {0xFF6E, 0xFF6E, 0xFF6E}, {0xFF6F, 0xFF6F, 0xFF6F},
    {0xFF70, 0xFF70, 0xFF70}, {0xFF71, 0xFF71, 0xFF71},
    {0xFF72, 0xFF72, 0xFF72}, {0xFF73, 0xFF73, 0xFF73},
    {0xFF74, 0xFF74, 0xFF74}, {0xFF75, 0xFF75, 0xFF75},
    {0xFF76, 0xFF76, 0xFF76}, {0xFF77, 0xFF77, 0xFF77},
    {0xFF78, 0xFF78, 0xFF78}, {0xFF79, 0xFF79, 0xFF79},
    {0xFF7A, 0xFF7A, 0xFF7A}, {0xFF7B, 0xFF7B, 0xFF7B},
    {0xFF7C, 0xFF7C, 0xFF7C}, {0xFF7D, 0xFF7D, 0xFF7D},
    {0xFF7E, 0xFF7E, 0xFF7E}, {0xFF7F, 0xFF7F, 0xFF7F},
    {0xFF80, 0xFF80, 0xFF80}, {0xFF81, 0xFF81, 0xFF81},
    {0xFF82, 0xFF82, 0xFF82}, {0xFF83, 0xFF83, 0xFF83},
    {0xFF84, 0xFF84, 0xFF84}, {0xFF85, 0xFF85, 0xFF85},
    {0xFF86, 0xFF86, 0xFF86}, {0xFF87, 0xFF87, 0xFF87},
    {0xFF88, 0xFF88, 0xFF88}, {0xFF89, 0xFF89, 0xFF89},
    {0xFF8A, 0xFF8A, 0xFF8A}, {0xFF8B, 0xFF8B, 0xFF8B},
    {0xFF8C, 0xFF8C, 0xFF8C}, {0xFF8D, 0xFF8D, 0xFF8D},
    {0xFF8E, 0xFF8E, 0xFF8E}, {0xFF8F, 0xFF8F, 0xFF8F},
    {0xFF90, 0xFF90, 0xFF90}, {0xFF91, 0xFF91, 0xFF91},
    {0xFF92, 0xFF92, 0xFF92}, {0xFF93, 0xFF93, 0xFF93},
    {0xFF94, 0xFF94, 0xFF94}, {0xFF95, 0xFF95, 0xFF95},
    {0xFF96, 0xFF96, 0xFF96}, {0xFF97, 0xFF97, 0xFF97},
    {0xFF98, 0xFF98, 0xFF98}, {0xFF99, 0xFF99, 0xFF99},
    {0xFF9A, 0xFF9A, 0xFF9A}, {0xFF9B, 0xFF9B, 0xFF9B},
    {0xFF9C, 0xFF9C, 0xFF9C}, {0xFF9D, 0xFF9D, 0xFF9D},
    {0xFF9E, 0xFF9E, 0xFF9E}, {0xFF9F, 0xFF9F, 0xFF9F},
    {0xFFA0, 0xFFA0, 0xFFA0}, {0xFFA1, 0xFFA1, 0xFFA1},
    {0xFFA2, 0xFFA2, 0xFFA2}, {0xFFA3, 0xFFA3, 0xFFA3},
    {0xFFA4, 0xFFA4, 0xFFA4}, {0xFFA5, 0xFFA5, 0xFFA5},
    {0xFFA6, 0xFFA6, 0xFFA6}, {0xFFA7, 0xFFA7, 0xFFA7},
    {0xFFA8, 0xFFA8, 0xFFA8}, {0xFFA9, 0xFFA9, 0xFFA9},
    {0xFFAA, 0xFFAA, 0xFFAA}, {0xFFAB, 0xFFAB, 0xFFAB},
    {0xFFAC, 0xFFAC, 0xFFAC}, {0xFFAD, 0xFFAD, 0xFFAD},
    {0xFFAE, 0xFFAE, 0xFFAE}, {0xFFAF, 0xFFAF, 0xFFAF},
    {0xFFB0, 0xFFB0, 0xFFB0}, {0xFFB1, 0xFFB1, 0xFFB1},
    {0xFFB2, 0xFFB2, 0xFFB2}, {0xFFB3, 0xFFB3, 0xFFB3},
    {0xFFB4, 0xFFB4, 0xFFB4}, {0xFFB5, 0xFFB5, 0xFFB5},
    {0xFFB6, 0xFFB6, 0xFFB6}, {0xFFB7, 0xFFB7, 0xFFB7},
    {0xFFB8, 0xFFB8, 0xFFB8}, {0xFFB9, 0xFFB9, 0xFFB9},
    {0xFFBA, 0xFFBA, 0xFFBA}, {0xFFBB, 0xFFBB, 0xFFBB},
    {0xFFBC, 0xFFBC, 0xFFBC}, {0xFFBD, 0xFFBD, 0xFFBD},
    {0xFFBE, 0xFFBE, 0xFFBE}, {0xFFC2, 0xFFC2, 0xFFC2},
    {0xFFC3, 0xFFC3, 0xFFC3}, {0xFFC4, 0xFFC4, 0xFFC4},
    {0xFFC5, 0xFFC5, 0xFFC5}, {0xFFC6, 0xFFC6, 0xFFC6},
    {0xFFC7, 0xFFC7, 0xFFC7}, {0xFFCA, 0xFFCA, 0xFFCA},
    {0xFFCB, 0xFFCB, 0xFFCB}, {0xFFCC, 0xFFCC, 0xFFCC},
    {0xFFCD, 0xFFCD, 0xFFCD}, {0xFFCE, 0xFFCE, 0xFFCE},
    {0xFFCF, 0xFFCF, 0xFFCF}, {0xFFD2, 0xFFD2, 0xFFD2},
    {0xFFD3, 0xFFD3, 0xFFD3}, {0xFFD4, 0xFFD4, 0xFFD4},
    {0xFFD5, 0xFFD5, 0xFFD5}, {0xFFD6, 0xFFD6, 0xFFD6},
    {0xFFD7, 0xFFD7, 0xFFD7}, {0xFFDA, 0xFFDA, 0xFFDA},
    {0xFFDB, 0xFFDB, 0xFFDB}, {0xFFDC, 0xFFDC, 0xFFDC}};
