% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{makeGRanges}
\alias{makeGRanges}
\title{Wrapper to construct GRanges object from chr,pos or chr,start,end}
\usage{
makeGRanges(chr, pos = NULL, start = NULL, end = NULL, row.names = NULL,
  build = NULL, ...)
}
\arguments{
\item{chr}{character, an optional vector of chromosomes to combine with 'pos' or 'start'+'end'
(enter in ...) to describe positions for the GRanges object}

\item{pos}{integer/numeric, for SNPs, can enter positions just once in 'pos' instead of 
entering the same value for start and end}

\item{start}{integer/numeric, specify the start position of ranges to encode in the new
GRanges object, alongside 'end' (do not use 'pos' if using start+end)}

\item{end}{integer/numeric, specify the end position of ranges to encode in the new
GRanges object, alongside 'start' (do not use 'pos' if using start+end)}

\item{row.names}{character, rownames for the output object, e.g, unique IDs describing the 
ranges}

\item{build}{character, "hg18" or "hg19" (or 36/37) to show which reference to retrieve. The 
default when build is NULL is to use the build from the current ChipInfo annotation}

\item{...}{further arguments to df.to.GRanges, such as 'fill.missing'}
}
\value{
Returns a GRanges object with the ranges, build and rownames specified. Rownames
will be 1:nrow if the 'row.names' parameter is empty. The strand information will default
to '+' for all entries, and the metadata will be empty (this function is only for creation
of a very basic GRanges object).
}
\description{
Slightly simplifies the creation of a GRanges object, allowing flexible input of
chr, pos, or chr,start,end, and specification of rownames and the 'genome' parameter
for specifying the build/coordinate type, e.g, hg18, build 37, etc. Designed for
a simplified GRanges object without metadata, and where the 'strand' data is of
no interest, so if strand/metadata is to be used, use the original GRanges() constructor.
}
\examples{
g1 <- makeGRanges(chr=c(1,4,"X"),pos=c(132432,434342,232222))
g2 <- makeGRanges(chr=c(22,21,21),start=c(1,1,1),end=c(1000,10000,100000),
                                              row.names=c("1K","10K","100K"))
g1 ; g2
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{Chr}}, \code{\link{Pos}}, \code{\link{Pos.gene}}, \code{\link{Band}},
 \code{\link{Band.gene}}, \code{\link{Band.pos}}, \code{\link{Gene.pos}}, \code{zlink{df.to.GRanges}}
}

