% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.GO.for.genes}
\alias{get.GO.for.genes}
\title{Retreive GO terms from biomart for a given gene list}
\usage{
get.GO.for.genes(gene.list, bio = T, cel = F, mol = F,
  host.txt = "may2009.archive.ensembl.org")
}
\arguments{
\item{gene.list}{a list of gene, use HGNC names, like COMT, HLA-C, CTLA4, etc.}

\item{bio}{logical, whether to return biological process GO terms}

\item{cel}{logical, whether to return cellular component GO terms}

\item{mol}{logical, whether to return molecular function GO terms}

\item{host.txt}{character, the argument to pass to biomaRt::useMart(). Default is 
'may2009.archive.ensembl.org', but more recently the recommended link is 'www.ensembl.org'}
}
\value{
data.frame containing the gene name in the first column, chromosome in the
second column, and the GO terms in the third column, where one gene has multiple
GO terms, this will produce multiple rows, so there will usually be more rows
than genes entered. The data.frame can have 3,4 or 5 columns depending on
how many GO terms are selected.
}
\description{
Gene-ontology terms (GO-terms) are commonly used for testing for simple functional
enrichment for pathways, etc. This function can retrieve biological function, 
cellular component, or molecular description, depending on the parameters chosen.
}
\examples{
get.GO.for.genes(c("CTLA4","PTPN2","PTPN22")) # biological terms (default)
get.GO.for.genes(c("CTLA4","PTPN2","PTPN22"),cel=TRUE) # add cellular GO terms
}

