% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{expand.nsnp}
\alias{expand.nsnp}
\title{Expand genomic locations to the ranges covering the 'n' closest SNPs}
\usage{
expand.nsnp(ranged, snp.info = NULL, nsnp = 10, add.chr = FALSE)
}
\arguments{
\item{ranged}{a GRanges or RangedData object describing the locations for
which we want to find regions encompassing 'nsnps' closest SNPs.}

\item{snp.info}{An object of type: ChipInfo, RangedData or GRanges, describing the set of SNPs
you are using (e.g, chip annotation). If left as null the ChipInfo object from chip.support() 
with default options() will be used}

\item{nsnp}{Number of nearest SNPs to return for each location}

\item{add.chr}{logical, whether to add a chromosome column for the output object}
}
\value{
Two regions for each row of a the 'ranged' object describing
the start and end of the left flanking 'nsnp' region, and right flanking 'nsnp' region
respectively. If 'ranged' has rownames these should stay in the same order in the resulting
object. Chromosome will be the final column if you set add.chr=TRUE.
}
\description{
Sometimes for chip data we want to create windows around some locus, and
fixed distance [see flank()], recombination distance [see recomWindow()] or a number of SNPs 
might be used. This function allows expansion of regions according to a set number of SNPs.
The result gives two regions for each row of a GRanges or RangedData object describing
the start and end of the left flanking 'nsnp' region, and right flanking 'nsnp' region
respectively.
}
\examples{
rngs <- rranges()
# not run - slow ~5 seconds # expand.nsnp(rngs)
# not run - slow ~5 seconds # expand.nsnp(rngs,add.chr=TRUE)
}
\seealso{
\code{\link{nearest.snp}}, \code{\link{chip.support}}, \code{\link{recomWindow}}
}

