% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{chrSelect}
\alias{chrSelect}
\title{Select chromosome subset of GRanges or RangedData object}
\usage{
chrSelect(X, chr, index = FALSE)
}
\arguments{
\item{X}{A GRanges or RangedData object}

\item{chr}{Vector, the chromosome(s) (number(s) or name(s)) to select}

\item{index}{logical, if FALSE, will assume 'chr' is a string, indicating the
chromosome name, if TRUE, if 'chr' is numeric, will assume it refers to the
chromosome index, which if there are some chromosomes not represented, may
be different to the name. E.g, an object with data for chromosomes 1,2,4,5
would select chromosome 5 with chr=4, if index=TRUE.}
}
\value{
returns an object of the same type as X, with only the chromosome
subset specified.
}
\description{
One of the main differences between RangedData and GRanges is the way
of selecting the subset for a chromosome. RangedData just uses [n] where
'n' is the chromosome name or number. Whereas GRanges, does not have a
method like this, so need to select using [chr(X)==chr.num,]
This wrapper allows selection of a chromosome or chromosomes regardless of
whether the object is RangedData or GRanges type.
}
\examples{
some.ranges <- rranges(100,chr.range=1:10)
chrSelect(some.ranges,6)
more.ranges <- rranges(10, chr.range=21:25)
chrSelect(more.ranges,1:22) # gives warning
select.autosomes(more.ranges)
}

