% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_temperature.R
\name{get_temperature_stations}
\alias{get_temperature_stations}
\alias{get_temperature_chronique}
\title{Retrieve data from API "Température des cours d'eau"}
\usage{
get_temperature_stations(...)

get_temperature_chronique(...)
}
\arguments{
\item{...}{parameters of the queries and their values in the format
\verb{Param1_Name = "Param1 value", Param2_Name = "Param2 value"}, use the
function \link{list_params} for a list of the available filter parameters
for a given API endpoint and see the API documentation for their description}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row by record and one column by field.
}
\description{
Available endpoints are:
\itemize{
\item \code{get_temperature_stations} retrieves temperature stations
\item \code{get_temperature_chronique} retrieves temperature time series
}

See the API documentation of each endpoint for available filter parameters:
\url{https://hubeau.eaufrance.fr/page/api-temperature-continu}
}
\examples{
\dontrun{
# Retrieve the temperature stations in the department of Loiret
get_temperature_stations(code_departement = "45")

# Retrieve the temperature from 2012-01-01 to 2012-01-05 at site 04051125

get_temperature_chronique(
  code_station = "04051125",
  date_debut_mesure = "2012-01-01",
  date_fin_mesure="2012-01-05",
  fields = paste("code_station,date_mesure_temp,heure_mesure_temp,resultat,symbole_unite")
)

}

}
