% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-json.R
\name{expect_json_equivalent}
\alias{expect_json_equivalent}
\title{Test that objects would generate equivalent JSON}
\usage{
expect_json_equivalent(object, expected, info = NULL, label = "object",
  expected.label = "expected")
}
\arguments{
\item{object}{object to test}

\item{expected}{expected value}

\item{info}{extra information to be included in the message}

\item{label}{character name by which to refer to \code{object} in the test
result. Because the tools for deparsing object names that 'testthat' uses
aren't exported from that package, the default here is just "object".}

\item{expected.label}{character same as \code{label} but for \code{expected}}
}
\value{
Invisibly, returns \code{object} for optionally passing to other
expectations.
}
\description{
Named lists in R are ordered, but they translate to unordered objects in
JSON. This test expectation loosens the equality check of two objects to
ignore the order of elements in a named list.
}
\seealso{
\code{\link[testthat]{expect_equivalent}}
}

