% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{cachedDownload}
\alias{cachedDownload}
\title{Cache the result of a file download}
\usage{
cachedDownload(url, destfile, ...)
}
\arguments{
\item{url}{character URL to download}

\item{destfile}{character file path/name where the download should be saved}

\item{...}{additional arguments, ultimately passed to \code{download.file}}
}
\value{
From \code{\link[utils:download.file]{utils::download.file()}}: "An (invisible) integer
code, \code{0} for success and non-zero for failure.  For the \code{"wget"}
and \code{"curl"} methods this is the status code returned by the
external program.  The \code{"internal"} method can return \code{1}, but will
in most cases throw an error."
}
\description{
This function wraps \code{\link[utils:download.file]{utils::download.file()}}. When
caching is enabled, \code{cachedDownload} will save a copy of the resulting
file to temporary storage and record that location in the query cache.
Subsequent download requests will just copy the cached file to the
destination path and not make a request across the network.
}
