% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monte_carlo.R
\name{monte_carlo}
\alias{monte_carlo}
\title{Monte Carlo for toxicokinetic model parameters}
\usage{
monte_carlo(
  parameters,
  cv.params = NULL,
  censored.params = NULL,
  samples = 1000
)
}
\arguments{
\item{parameters}{These parameters that are also listed in either
cv.params or censored.params are sampled using Monte Carlo.}

\item{cv.params}{The parameters listed in cv.params are sampled from a
normal distribution that is truncated at zero. This argument should be a
list of coefficients of variation (cv) for the normal distribution. Each
entry in the list is named for a parameter in "parameters". New values are
sampled with mean equal to the value in "parameters" and standard deviation
equal to the mean times the cv.}

\item{censored.params}{The parameters listed in censored.params are sampled
from a normal distribution that is censored for values less than the limit
of detection (specified separately for each parameter). This argument should
be a list of sub-lists. Each sublist is named for a parameter in "params"
and contains two elements: "cv" (coefficient of variation) and "LOD" (limit
of detection), below which parameter values are censored. New values are
sampled with mean equal to the value in "params" and standard deviation
equal to the mean times the cv. Censored values are sampled on a uniform
distribution between 0 and the limit of detection.}

\item{samples}{This argument is the number of samples to be generated for
calculating quantiles.}
}
\value{
A data.table with a row for each individual in the sample and a column for
each parater in the model.
}
\description{
This function performs basic, uncorrelated Monte Carlo to simulate
uncertainty and/or variability for parameters of 
toxicokinetic models. Parameters can be varied according to either a
normal distribution that is truncated at zero 
(using argument \code{cv.params}) or from a normal distribution that is 
censored for values less than the limit of detection 
(\code{censored.params}). Coefficient of variation (cv) and limit of
of detectin can be specified separately for each parameter.
}
\examples{

#Example based on Pearce et al. (2017):

# Set up means:
params <- parameterize_pbtk(chem.name="zoxamide")
# Nothing changes:
monte_carlo(params)

vary.params <- NULL
for (this.param in names(params)[!(names(params) \%in\%
  c("Funbound.plasma", "pKa_Donor", "pKa_Accept" )) &
  !is.na(as.numeric(params))]) vary.params[this.param] <- 0.2
# Most everything varies with CV of 0.2:
monte_carlo(
  parameters=params, 
  cv.params = vary.params)

censored.params <- list(Funbound.plasma = list(cv = 0.2, lod = 0.01))
# Fup is censored below 0.01:
monte_carlo(
  parameters=params, 
  cv.params = vary.params,
  censored.params = censored.params)

}
\references{
Pearce, Robert G., et al. "Httk: R package for high-throughput 
toxicokinetics." Journal of statistical software 79.4 (2017): 1.
}
\author{
John Wambaugh
}
\keyword{Monte-Carlo}
