% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_anova_dispersion.R
\name{mc_anova_dispersion}
\alias{mc_anova_dispersion}
\title{ANOVA tables for dispersion components.}
\usage{
mc_anova_dispersion(object, p_var, names, verbose = TRUE)
}
\arguments{
\item{object}{An object of \code{mcglm} class.}

\item{p_var}{A list of indices that indicate how the dispersion
parameters are related. Parameters with the same index are tested
together.}

\item{names}{Names to be shown in the table.}

\item{verbose}{a logical if TRUE print some information about the
tests performed. Default verbose = TRUE.}
}
\value{
Type III ANOVA table for dispersion components of mcglm
objects.
}
\description{
Performs Wald tests to generate analysis-of-variance
tables of the significance for the dispersion components by response
variables for model objects produced by mcglm.
}
\examples{

library(mcglm)
library(Matrix)
library(htmcglm)

data("soya", package = "mcglm")

form.grain <- grain ~ water * pot
form.seed <- seeds ~ water * pot

soya$viablepeasP <- soya$viablepeas / soya$totalpeas
form.peas <- viablepeasP ~ water * pot

Z0 <- mc_id(soya)
Z1 <- mc_mixed(~0 + factor(block), data = soya)

fit_joint <- mcglm(linear_pred = c(form.grain,
                                   form.seed,
                                   form.peas),
                   matrix_pred = list(c(Z0, Z1),
                                      c(Z0, Z1),
                                      c(Z0, Z1)),
                   link = c("identity",
                            "log",
                            "logit"),
                   variance = c("constant",
                                "tweedie",
                                "binomialP"),
                   Ntrial = list(NULL,
                                 NULL,
                                 soya$totalpeas),
                   power_fixed = c(TRUE,TRUE,TRUE),
                   data = soya)

mc_anova_dispersion(fit_joint,
p_var = list(c(0,1), c(0,1), c(0,1)),
names = list(c('tau10', 'tau11'),
             c('tau20', 'tau21'),
             c('tau30', 'tau31')))

}
\seealso{
\code{mc_anova_I}, \code{mc_anova_II} and
\code{mc_anova_III}.
}
\author{
Lineu Alberto Cavazani de Freitas,
\email{lineuacf@gmail.com}
}
