% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimation.R
\name{posterior_performance}
\alias{posterior_performance}
\title{Posterior measures of performance}
\usage{
posterior_performance(
  obj,
  prob = 0.95,
  summary = TRUE,
  cores = getOption("mc.cores", 1)
)
}
\arguments{
\item{obj}{An object of class \code{hsstan} or \code{kfold}.}

\item{prob}{Width of the posterior interval (0.95, by default). It is
ignored if \code{summary=FALSE}.}

\item{summary}{Whether a summary of the distribution of the performance
measure should be returned rather than the pointwise values
(\code{TRUE} by default).}

\item{cores}{Number of cores to use for parallelization (the value of
\code{options("mc.cores")} by default).}
}
\value{
The mean, standard deviation and posterior interval of the performance
measure (R-squared or AUC) if \code{summary=TRUE}, or a vector of values
of the performance measure with length equal to the size of the posterior
sample if \code{summary=FALSE}. Attribute \code{type} reports whether the performance
measures are cross-validated or not.
}
\description{
Compute the log-likelihood and a relevant measure of performance (R-squared
or AUC) from the posterior samples.
}
\examples{
\donttest{
\dontshow{utils::example("hsstan", echo=FALSE)}
# continued from ?hsstan
posterior_performance(hs.biom, cores=1)
}

}
