% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dateToPeriod.R
\name{dateToPeriod}
\alias{dateToPeriod}
\title{Convert dates to a relative period}
\usage{
dateToPeriod(trans_df, date, periodicity = NULL, min_date = NULL,
  max_date = NULL, adj_type = "move", ...)
}
\arguments{
\item{trans_df}{data.frame of raw transactions}

\item{date}{name of field containing the date of the sale in Date or POSIXt format}

\item{periodicity}{type of periodicity to use ('yearly', 'quarterly', 'monthly' or 'weekly)}

\item{min_date}{default = NULL; optional minimum date to use}

\item{max_date}{default = NULL; optional maximum date to use}

\item{adj_type}{default = 'move'; how to handle min and max dates within the range of
transactions.  'move' min and/or max date or 'clip' the data}

\item{...}{Additional arguments}
}
\value{
original data frame (`trans_df` object) with two new fields:
trans_period: integer value counting from the minimum transaction date in the
periodicity selected. Base value is 1. Primarily for modeling trans_date: properly
formatted transaction date
}
\description{
Create a relative period variable from a date variable
}
\section{Further Details}{

  "trans_period" counts from the minimum transaction date provided.  As such the period
  counts are relative, not absolute

  Additionally, this function modifies the data.frame that it is given and return that same
  data.frame that it is given and returns that data.frame with the new fields attached.
}

\examples{

# Load data
  data(ex_sales)

# Convert to period df
  hpi_data <- dateToPeriod(trans_df = ex_sales,
                           date = 'sale_date',
                           periodicity = 'monthly')

}
