% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveymod.R
\name{svy.varcoef_hopit}
\alias{svy.varcoef_hopit}
\title{Calculation of the variance-covariance matrix for a specified survey design (experimental function)}
\usage{
svy.varcoef_hopit(vcovMat, estfun, design)
}
\arguments{
\item{vcovMat}{a variance-covariance matrix.}

\item{estfun}{a gradient function of the log-likelihood function.}

\item{design}{a \code{survey.design} object.}
}
\description{
This function is an equivalent of \code{survey:::svy.varcoef}. In the original approach \code{estfun} is calculated from
glm's working residuals:\cr
\code{estfun <- model.matrix(glm.object) * resid(glm.object, "working") * glm.object$weights}\cr
In the hopit package, estfun is directly calculated as a gradient (vector of partial derivatives) of the log likelihood function.
Depending on detected design an appropriate \code{survey} function is called.
}
\seealso{
\code{\link[survey]{svydesign}}
\code{\link{hopit}}
}
