% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2017-11-14.R
\name{imputationcycle}
\alias{imputationcycle}
\title{Cycling}
\usage{
imputationcycle(data_before, original_data, NA_locator, fe, interaction_names,
  list_of_types, nitt, burnin, thin, mn, heap = 0)
}
\arguments{
\item{data_before}{The data.frame with the variables to impute.}

\item{original_data}{The original data.frame the user passed to \code{hmi}.}

\item{NA_locator}{A n x p matrix localizing the missing values in the original
dataset. The elements are TRUE if the original data are missing and FALSE if the
are observed.}

\item{fe}{A list with the decomposed elements of the \code{model_formula}.}

\item{interaction_names}{A list with the names of the variables
that have been generated as interaction variables}

\item{list_of_types}{a list specifying the types of the variables.
See \code{hmi} for details.}

\item{nitt}{An integer defining number of MCMC iterations (see \code{MCMCglmm}).}

\item{burnin}{burnin A numeric value between 0 and 1 for the desired percentage of
Gibbs samples that shall be regarded as burnin.}

\item{thin}{An integer to set the thinning interval range. If thin = 1,
every iteration of the Gibbs-sampling chain will be kept. For highly autocorrelated
chains, that are only examined by few iterations (say less than 1000),
the \code{geweke.diag} might fail to detect convergence. In such cases it is
essential to look a chain free from autocorelation.}

\item{mn}{An integer defining the minimum number of individuals per cluster.}

\item{heap}{A numeric value saying to which value the data might be heaped.}
}
\value{
A data.frame where the values, that have a missing value in the original
dataset, are imputed.
}
\description{
Function to do one imputation cycle on the given data. The function cycles through
every variable sequentially imputing the values, that are NA in the original data set
in that current variable. The function determines the type of the variable
and calls the suitable imputation function.
}
