% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.hmclearn}
\alias{summary.hmclearn}
\title{Summarizing HMC Model Fits}
\usage{
\method{summary}{hmclearn}(
  object,
  burnin = NULL,
  probs = c(0.025, 0.05, 0.25, 0.5, 0.75, 0.95, 0.975),
  ...
)
}
\arguments{
\item{object}{an object of class \code{hmclearn}, usually a result of a call to \code{mh} or \code{hmc}}

\item{burnin}{optional numeric parameter for the number of initial MCMC samples to omit from the summary}

\item{probs}{quantiles to summarize the posterior distribution}

\item{...}{additional arguments to pass to \code{quantile}}
}
\value{
Returns a matrix with posterior quantiles and the posterior scale reduction factor statistic for each parameter.
}
\description{
summary method for class \code{hmclearn}
}
\examples{
# Linear regression example
set.seed(521)
X <- cbind(1, matrix(rnorm(300), ncol=3))
betavals <- c(0.5, -1, 2, -3)
y <- X\%*\%betavals + rnorm(100, sd=.2)

f1 <- hmc(N = 500,
          theta.init = c(rep(0, 4), 1),
          epsilon = 0.01,
          L = 10,
          logPOSTERIOR = linear_posterior,
          glogPOSTERIOR = g_linear_posterior,
          varnames = c(paste0("beta", 0:3), "log_sigma_sq"),
          param=list(y=y, X=X), parallel=FALSE, chains=1)

summary(f1)
}
\references{
Gelman, A., et. al. (2013) \emph{Bayesian Data Analysis}.  Chapman and Hall/CRC.

Gelman, A. and Rubin, D. (1992) \emph{Inference from Iterative Simulation Using Multiple Sequences}.  Statistical Science 7(4) 457-472.
}
