% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_plot_borrow.R
\name{hb_plot_borrow}
\alias{hb_plot_borrow}
\title{Plot a borrowing model response against the benchmark models.}
\usage{
hb_plot_borrow(borrow, pool, independent, outcome = c("response", "diff"))
}
\arguments{
\item{borrow}{A data frame returned by \code{\link[=hb_summary]{hb_summary()}}
for a borrowing model,
either the hierarchical model or the mixture model.}

\item{pool}{A data frame returned by \code{\link[=hb_summary]{hb_summary()}}
for the pooled model.}

\item{independent}{A data frame returned by \code{\link[=hb_summary]{hb_summary()}}
for the independent model.}

\item{outcome}{Character of length 1, either \code{"response"}
or \code{"diff"}, the quantity to plot on the vertical axis.}
}
\value{
A \code{ggplot} object
}
\description{
Plot the response from a
borrowing model (hierarchical or mixture)
against the independent and pooled benchmark models.
}
\examples{
if (!identical(Sys.getenv("HB_TEST", unset = ""), "")) {
data <- hb_sim_independent(n_continuous = 2)$data
mcmc_borrow <- hb_mcmc_hierarchical(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 100,
  n_iterations = 200
)
mcmc_pool <- hb_mcmc_pool(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 200,
  n_iterations = 200
)
mcmc_independent <- hb_mcmc_independent(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 200,
  n_iterations = 200
)
borrow <- hb_summary(mcmc_borrow, data)
pool <- hb_summary(mcmc_pool, data)
independent <- hb_summary(mcmc_independent, data)
hb_plot_borrow(
  borrow = borrow,
  pool = pool,
  independent = independent
)
}
}
\seealso{
Other plot: 
\code{\link{hb_plot_group}()},
\code{\link{hb_plot_tau}()}
}
\concept{plot}
