% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dethrzbase.R
\name{det_area_hole}
\alias{det_area_hole}
\title{Calculation of the area of the high-risk zone.}
\usage{
det_area_hole(win, intensmatrix, threshold, hole, integratehole = TRUE)
}
\arguments{
\item{win}{observation window}

\item{intensmatrix}{matrix of the estimated intensity of the observed process (\code{as.matrix(intens)})}

\item{threshold}{threshold c: The high-risk zone is the field in which the estimated intensity 
exceeds this value}

\item{hole}{specified hole}

\item{integratehole}{Should the \code{hole} be part of the resulting high-risk zone? Defaults to \code{TRUE}}
}
\value{
A numerical value giving the area of the high-risk zone.
}
\description{
This function is used for the intensity-based method with a hole restriction area. Calculation of the
area of the high-risk zone given the observation window,
the intensity matrix, the threshold c and a hole. Used in function 
det_thresholdfromarea_hole.
}
\seealso{
\code{\link[spatstat]{owin}}, \code{\link[spatstat]{area.owin}}
}
