% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bootcorrect.R
\name{bootcorr}
\alias{bootcorr}
\title{Bootstrap correction to obtain desired failure probability}
\usage{
bootcorr(ppdata, cutoff, numit = 1000, tol = 0.02, nxprob = 0.1,
  intens = NULL, covmatrix = NULL, simulate = "intens",
  radiusClust = NULL, clustering = 5, verbose = TRUE)
}
\arguments{
\item{ppdata}{Observed spatial point process of class ppp.}

\item{cutoff}{Desired failure probability alpha, which is the probability of having
unobserved events outside the high-risk zone.}

\item{numit}{Number of iterations to perform (per tested value for cutoff). Default value is 1000.}

\item{tol}{Tolerance: acceptable difference between the desired failure probability and the fraction of
high-risk zones not covering all events. Default value is 0.02.}

\item{nxprob}{Probability of having unobserved events.
Default value is 0.1.}

\item{intens}{(optional) estimated intensity of the observed process (object of class "im",
see \code{\link[spatstat]{density.ppp}}). If not given,
it will be estimated.}

\item{covmatrix}{(optional) Covariance matrix of the kernel of a normal distribution, only meaningful
if no intensity is given. If not given, it will be estimated.}

\item{simulate}{The type of simulation, can be one of \code{"thinning", "intens"} or \code{"clintens"}}

\item{radiusClust}{(optional) radius of the circles around the parent points in which the cluster
points are located. Only used for \code{simulate = "clintens"}.}

\item{clustering}{a value >= 1 which describes the amount of clustering; the
adjusted estimated intensity of the observed pattern is divided by
this value; it also is the parameter of the Poisson distribution
for the number of points per cluster. Only used for \code{simulate = "clintens"}.}

\item{verbose}{logical. Should information on tested values/progress be printed?}
}
\value{
An object of class bootcorr, which consists of a list of the final value for alpha (\code{alphastar})
        and a data.frame \code{course} containing information on the simulation course, e.g. the tested values.
}
\description{
Simulation-based iterative procedure to correct for possible bias with respect to the
failure probability alpha
}
\details{
For a desired failure probability alpha, the corresponding parameter which is to use
when determining a high-risk zone is found in an iterative procedure. The simulation procedure
is the same as in \code{\link[highriskzone]{eval_method}}. In every iteration,
the number of high-risk zones with at least one unobserved event located outside is
compared with the desired failure probability. If necessary, the value of \code{cutoff} is
increased or decreased. The final value \code{alphastar} can than be used in
\code{\link[highriskzone]{det_hrz}}.

If there are restriction areas in the observation window, use \code{\link[highriskzone]{bootcor_restr}}
instead.
}
\examples{
\dontrun{
data(craterB)
set.seed(4321)

bc <- bootcor(ppdata=craterB, cutoff=0.2, numit=100, tol=0.02, nxprob=0.1)
bc
summary(bc)
plot(bc)


hrzbc <- det_hrz(craterB, type = "intens", criterion = "indirect",
cutoff = bc$alphastar, nxprob = 0.1)
}
}
\references{
Monia Mahling, Michael \enc{H?hle}{Hoehle} & Helmut \enc{K?chenhoff}{Kuechenhoff} (2013),
\emph{Determining high-risk zones for unexploded World War II bombs by using point process methodology.}
Journal of the Royal Statistical Society, Series C 62(2), 181-199.

Monia Mahling (2013),
\emph{Determining high-risk zones by using spatial point process methodology.}
Ph.D. thesis, Cuvillier Verlag \enc{G?ttingen}{Goettingen},
available online: http://edoc.ub.uni-muenchen.de/15886/
Chapter 6
}
\seealso{
\code{\link[highriskzone]{det_hrz}}, \code{\link[highriskzone]{eval_method}}, \code{\link[highriskzone]{bootcor_restr}}
}

