\name{ChenQin.sim}
\alias{ChenQin.sim}
\title{Chen Qin Simulator

}
\description{Performs the test from Chen and Qin (2010) on multiple data sets generated by \code{\link{build2popData}}.

}
\usage{
ChenQin.sim(DATA)
}

\arguments{
  \item{DATA}{an object returned by \code{\link{build2popData}}.
}
}
\value{ A data frame with columns
	\item{ChQvalues}{values of the test statistic.
	}
	\item{pvalues}{the p values.
	}
}
\references{ 
	Chen, X. S. and Qin, Y.L. (2010). A two sample test for high dimensional data with applications to gene-set testing.  		
		\emph{The Annals of Statistics}. \bold{38}(2):808--835
}
\author{
Karl Gregory   \email{kgregory@mail.uni-mannheim.de}, \url{http://www.stat.tamu.edu/~kbgregory}.
}

\seealso{
\code{\link{ChenQin.test}}
}
\examples{
	
\dontrun{

DATA <-build2popData(	
	n = 15,
	m = 20,
	p = 500,
	muX = rep(0,500),
	muY = rep(0,500),
	commoncov = FALSE,
	VarScaleY = 1,
	dep = "ARMA",
	ARMAparms = list(coefs=list(ma=c(.2,.3) , ar=c(.4,-.1))),
	LRparm = .75,
	S = 25,
	innov = function(n,...) rnorm(n,0,1),
	heteroscedastic=TRUE,
	het.diag = diag(.1 + rexp(500,1/2))
	)
	
ChenQin.sim(DATA)

}
}

\keyword{htest}
\keyword{multivariate}
