% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksGRM.R
\name{kinship2grm}
\alias{kinship2grm}
\title{Converts a kinship matrix to a Genetic Relation Matrix (GRM)}
\usage{
kinship2grm(x)
}
\arguments{
\item{x}{a square matrix containing kinship coefficients}
}
\value{
a GRM matrix
}
\description{
Converts a kinship matrix to a Genetic Relation Matrix (GRM)
}
\details{
for off-diagonal elements, \eqn{GRM=2 \times x_{ij}}; for diagonal elements, \eqn{GRM=1+ x_{ii}}
}
\examples{
\dontrun{
dos<-matrix(sample(0:2,replace=TRUE,size=1000),nrow=10) #dosage matrix for 10 inds at 100 loci
ks<-beta.dosage(dos) # kinship matrix
kinship2grm(ks)
}  
}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}
}
