% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hSet.R
\name{outlier_hierarchy}
\alias{outlier_hierarchy}
\title{Create a new hierarchy based on the outlying elements}
\usage{
outlier_hierarchy(set, intersectLimit = 1)
}
\arguments{
\item{set}{A HierarchicalSet object}

\item{intersectLimit}{The proportion of sets an element must be present in to
be considered part of the intersect. Standard intersects require it to be
present in all sets (intersectLimit = 1), which is also the default}
}
\value{
An object of class HierarchicalSet, based on the outliying elements
of \code{set}
}
\description{
This function detects the outlying elements of a HierarchicalSet object and
creates a new clustering of the sets only based on these elements. The
returned HierarchicalSet object will only contain the outlying elements, thus
reducing the universe size. This operation is somewhat similar to principal
component analysis, in that the derived clustering is based on the structure
not captured by the first clustering, thus modeling the second most dominant
feature of the data.
}
\examples{
data('twitter')

twitSet <- create_hierarchy(twitter)
twitSetOut <- outlier_hierarchy(twitSet)
twitSetOut

}
\seealso{
\code{\link{outlying_elements}} for extracting outlying element
information from a HierarchicalSet object
}

