% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hasi_bsa_to_ordinal.R
\name{hasi_bsa_to_ordinal}
\alias{hasi_bsa_to_ordinal}
\title{Converts BSA percentage to the ordinal scale for HASI-R scoring.}
\usage{
hasi_bsa_to_ordinal(
  bsa_percent_within_site = NULL,
  bsa_percent_total_body = NULL,
  bsa_ordinal = NULL,
  bodysite = NULL
)
}
\arguments{
\item{bsa_percent_within_site}{Numeric vector representing BSA percentages
(0-100)}

\item{bsa_percent_total_body}{Numeric vector representing BSA percentages
(0-15, depending on site)}

\item{bsa_ordinal}{Numeric vector representing BSA values. (0-6)}

\item{bodysite}{Optional character vector representing body sites}
}
\value{
Integer vector representing the ordinal scale values
}
\description{
Converts BSA percentage to the ordinal scale for HASI-R scoring.
}
\examples{
hasi_bsa_to_ordinal(c(0, 2, 5, 12, 25, 40, 75))
}
\references{
Goldfarb N, Lowes MA, Butt M, King T, Alavi A, Kirby JS.
Hidradenitis Suppurativa Area and Severity Index Revised (HASI-R):
psychometric property assessment. Br J Dermatol. 2021 May;184(5):905-912.
doi: 10.1111/bjd.19565. Epub 2020 Dec 30. PMID: 32969027; PMCID:
PMC8573730.
}
\seealso{
Other HASI: 
\code{\link{hasi_r_num}()}
}
\concept{HASI}
