% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGroups2WFUN.R
\name{addGroups2WFUN}
\alias{addGroups2WFUN}
\title{Group-Dependent Parametric Weights}
\usage{
addGroups2WFUN(WFUN, groups, initial = rep.int(WFUN$initial, nlevels(groups)))
}
\arguments{
\item{WFUN}{a list specification of parametric weights, e.g.,
as returned by the constructor functions \code{\link{W_powerlaw}} and
\code{\link{W_np}}.}

\item{groups}{a vector of length \code{nUnits} determining to which
group each unit belongs to. The supplied vector is converted to a
factor using \code{\link{as.factor}}.}

\item{initial}{(named) vector of initial parameters.}
}
\value{
a list specifying group-dependent parametric weights for \code{hhh4}.
}
\description{
This function takes a specification of parametric weights and returns
a modified version with group-dependent parameters.
Only single-parameter functions are currently supported.
}
\examples{
data("measlesWeserEms")
WPLgroups <- addGroups2WFUN(
  W_powerlaw(maxlag = 5, normalize = FALSE, log = FALSE),
  groups = factor(sample(2, ncol(measlesWeserEms), replace = TRUE)))
}
\author{
Sebastian Meyer
}
