% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_base_functions.R
\name{prune.control}
\alias{prune.control}
\title{prune.control}
\usage{
prune.control(
  prune_type = "ccp",
  prune_stochastic_max_nodes = 10,
  prune_stochastic_max_depth = 10,
  prune_stochastic_samples = 100,
  ...
)
}
\arguments{
\item{prune_type}{The prune type required, valid values are 'all', 'ccp' and
stochastic'. The default value is 'all'.}

\item{prune_stochastic_max_nodes}{The prune_stochastic_max_nodes parameter specifies
the number of internal nodes to randomly sample on each prune_stochastic_samples. The
value specified must be an even number as an equal number of left and right internal nodes
will form the sample. The prune_stochastic_max_nodes parameter can have a value of any even
integer in the range two to twenty-four. The default value is 10.}

\item{prune_stochastic_max_depth}{When sampling internal nodes, the
prune_stochastic_max_depth parameter specifies the maximum decision tree depth to select
internal nodes from. Internal nodes occurring in the original decision tree at depths
greater than prune_stochastic_max_depth are not eligible for sampling. Any positive integer
in the range two to the maximum depth of the current tree is accepted.
The default value is 12.}

\item{prune_stochastic_samples}{The prune_stochastic_samples parameter specifies the number
of times internal nodes will be sampled from the current decision tree. The number of
internal nodes to be sampled each iteration is determined by the prune_stochastic_max_nodes
parameter, the internal nodes eligible to be sampled is determined by the
prune_stochastic_max_depth parameter. The prune_stochastic_samples parameter can have any
positive integer value greater than zero. The default value is 100.}

\item{...}{parameter catch-all.}
}
\value{
Returns a list of validated parameters.
}
\description{
This internal function is used to validate the parameters specified on the
prune_control parameter.
}
\details{
The following parameters are supported:
}
