% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_export_print.R
\name{print.hhcartr}
\alias{print.hhcartr}
\title{print.hhcartr - Create generic S3method to print results via print.hhcartr. Needs export entry
in the NAMESPACE file.}
\usage{
\method{print}{hhcartr}(x, ...)
}
\arguments{
\item{x}{Unused parameter.}

\item{...}{Unused parameter.}
}
\value{
A ggplot of training accuracy.
}
\description{
This function will generate a ggplot showing test set accuracy for each tree fold/trial. In
future will need to provide support to allow user to customize the plots.
}
\examples{
# source: /man/examples/print.R

# Basic usage of print().

# Note: we need to have a model first.

# load our data.
X <- iris[,1:4]
y <- iris[,5]

# instantiate our model.
clf = HHDecisionTree(n_folds=10,
                     n_trees=1,
                     pruning=FALSE,
                     min_node_impurity=0.0)

# describe what dataset our model is using.
setDataDescription("IRIS Dataset")

# train our model.
model_output <- clf$fit(X, y)

# print fold accuracy distribution from our training data.
print(model_output)
}
