% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.hexagontile.R
\name{grid.hexagontile}
\alias{grid.hexagontile}
\title{Draw hexagon tiles with grid package}
\usage{
grid.hexagontile(
  hexDensity,
  use.count = TRUE,
  cell.at = NULL,
  trans = NULL,
  colorcut = seq(0, 1, length = 1024),
  colramp = colorRampPalette(col.viridis),
  def.unit = "native"
)
}
\arguments{
\item{hexDensity}{\link[hexbin]{hexbin} object returned by hexDensity.}

\item{use.count}{logical specifying if counts from hexbin object should be used.}

\item{cell.at}{numeric vector to be plotted instead of counts, must be same length as the number of cells.}

\item{trans}{a transformation function (or NULL) for the counts, e.g., sqrt.}

\item{colorcut}{An integer for the number of equi-spaced colorcut in [0,1] to assign colors to values. Alternatively, a vector of custom colorcut spacing between [0, 1].}

\item{colramp}{Color function that accept an integer n and return n colors.}

\item{def.unit}{Default \link[grid]{unit} to be used.}
}
\value{
No return value
}
\description{
Adapted from \link[hexbin]{grid.hexagons} by hexbin with speedup specific 
for hexagonal tiling (avoid plotting the most abundance hexagons by setting 
its color as background).
}
\section{SIDE EFFECTS}{
 Adds hexagons to plot
}

\author{
Dan Carr <dcarr@voxel.galaxy.gmu.edu>; ported and extended by 
Nicholas Lewin-Koh nikko@hailmail.net. Modified by Quoc Hoang Nguyen 
<nguyen.q@wehi.edu.au> for hexDensity.
}
