% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_stat_calc.R
\name{SKS.stat.cov.pool}
\alias{SKS.stat.cov.pool}
\alias{SKS.stat.cov}
\title{SKS.stat.cov.pool}
\usage{
SKS.stat.cov.pool(Y, Z, X)

SKS.stat.cov(Y, Z, X)
}
\arguments{
\item{Y}{Observed outcome vector}

\item{Z}{Treatment assigment vector}

\item{X}{Additional pre-treatment covariates to adjust for in estimation, but not to interact with treatment.}
}
\value{
The value of the test.
}
\description{
SKS.stat.cov.pool is the shifted kolmogorov-smirnov statistic with covariates
to increase precision.  This is the test statistic used Ding, Feller, and
Miratrix (2016), JRSS-B.

SKS.stat.cov is the shifted kolmogorov-smirnov statistic with covariates
with model for outcomes calculated on control group only.
This avoids "splitting" the treatment variation between tx 
and co groups.  
We recommend this method over the "pool" method.
}
\examples{
df <- make.randomized.dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
SKS.stat.cov.pool(df$Yobs, df$Z, df$A)

df <- make.randomized.dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
SKS.stat.cov(df$Yobs, df$Z, df$A)

}
