% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetGP.R
\name{logLikH}
\alias{logLikH}
\title{Generic Log-likelihood function
This function can be used to compute loglikelihood for homGP/hetGP models}
\usage{
logLikH(
  X0,
  Z0,
  Z,
  mult,
  theta,
  g,
  Delta = NULL,
  k_theta_g = NULL,
  theta_g = NULL,
  logN = FALSE,
  beta0 = NULL,
  eps = sqrt(.Machine$double.eps),
  covtype = "Gaussian"
)
}
\arguments{
\item{X0}{unique designs}

\item{Z0}{averaged observations}

\item{Z}{replicated observations (sorted with respect to X0)}

\item{mult}{number of replicates at each Xi}

\item{theta}{scale parameter for the mean process, either one value (isotropic) or a vector (anistropic)}

\item{g}{nugget of the nugget process}

\item{Delta}{vector of nuggets corresponding to each X0i or pXi, that are smoothed to give Lambda}

\item{k_theta_g}{constant used for linking nuggets lengthscale to mean process lengthscale, i.e., theta_g[k] = k_theta_g * theta[k], alternatively theta_g can be used}

\item{theta_g}{either one value (isotropic) or a vector (anistropic), alternative to using k_theta_g}

\item{logN}{should exponentiated variance be used}

\item{beta0}{mean, if not provided, the MLE estimator is used}

\item{eps}{minimal value of elements of Lambda}

\item{covtype}{covariance kernel type}
}
\description{
Generic Log-likelihood function
This function can be used to compute loglikelihood for homGP/hetGP models
}
\details{
For hetGP, this is not the joint log-likelihood, only the likelihood of the mean process.
}
\keyword{internal}
