% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpmatrix.R
\name{tpmatrix_id}
\alias{tpmatrix_id}
\title{Transition probability matrix IDs}
\usage{
tpmatrix_id(object, n_samples)
}
\arguments{
\item{object}{An object of class \code{expanded_hesim_data} returned by
\code{expand.hesim_data()}. This dataset must be expanded by treatment
strategies, patients, and optionally time intervals.}

\item{n_samples}{The number of parameters samples used for the probabilistic
sensitivity analysis (PSA).}
}
\value{
Returns a \code{data.table} with the same columns in \code{object} repeated
\code{n_samples} times. That is, to facilitate creation of a \code{tparams_transprobs()}
object,  there is one row for each parameter sample,
treatment strategy, patient, and optionally time interval.
}
\description{
Creates ID variables for each row returned by \code{tpmatrix()}. This function is
most conveniently used along with \code{tpmatrix()} to construct a
\code{tparams_transprobs()} object.
}
\examples{
strategies <- data.frame(strategy_id = c(1, 2))
patients <- data.frame(patient_id = seq(1, 3), age = c(65, 50, 75),
                        gender = c("Female", "Female", "Male"))
hesim_dat <- hesim_data(strategies = strategies,
                        patients = patients)
input_data <- expand(hesim_dat, by = c("strategies", "patients"))    
tpmatrix_id(input_data, n_samples = 2)                   
}
\seealso{
\code{\link[=tpmatrix]{tpmatrix()}}, \code{\link[=tparams_transprobs]{tparams_transprobs()}}, \code{\link[=expand.hesim_data]{expand.hesim_data()}}
}
