% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrier_probabilities.R
\name{carrier_probabilities}
\alias{carrier_probabilities}
\title{Calculate carrier probabilities for the most heritable methylation sites}
\usage{
carrier_probabilities(dat, M_values, top_probes, ncores = 1)
}
\arguments{
\item{dat}{A data frame with rows corresponding to people and columns
corresponding to (at least) the following variables, which will be coerced to
\code{character} type:
\itemize{
\item \code{family} (family ID), an identifier for each person's family, constant
within families
\item \code{indiv} (individual ID), an identifier for each person, with no duplicates
across the dataset
\item \code{mother} (mother ID), the individual ID of each person's mother, or missing
(\code{NA}) for founders
\item \code{father} (father ID), the individual ID of each person's father, or missing
(\code{NA}) for founders
\item \code{typed} (epi-genotyped), equal to \code{1} for people with methylation data and
\code{0} for all others
}}

\item{M_values}{A matrix of M-values, with rows corresponding to
methylation sites and columns corresponding to people.}

\item{top_probes}{A data frame, usually the output of \code{\link{ML_estimates}} restricted to
the most heritable methylation sites (those with the highest values of \eqn{\Delta}l).
See \code{\link{ML_estimates}} and the example below for more details.}

\item{ncores}{The number of cores to be used, with \code{ncores = 1} (the
default) corresponding to non-parallel computing.  When \code{ncores > 1},
the \code{parallel} package is used to parallelize the calculation.}
}
\value{
A data frame containing the carrier probabilities described in (Joo et al., 2018),
with rows of the data frame corresponding to the people in \code{dat} and columns corresponding to
the methylation sites in \code{top_probes}.  This calculation is based on the Mendelian model
of (Joo et al., 2018) with parameter values taken from \code{top_probes}.
}
\description{
For each person in \code{dat} and each methylation site in \code{top_probes},
this function calculates the probability that the person carries a rare
mutation at a hypothetical genetic locus that affects methylation
at the methylation site.
}
\examples{
str(ped)
str(M_values)

# Calculate genotype probabilities
typed_genos <- genotype_combinations(ped)
str(typed_genos)

\donttest{
# Compute Delta l
MLEs <- ML_estimates(typed_genos, M_values, ncores = 4)

# Select top probes
top_probes <- MLEs[MLEs$delta.l > 10, ]

# Calculate carrier probabilities
CP <- carrier_probabilities(ped, M_values, top_probes, ncores = 2)
str(CP)
}

}
\references{
Joo JE, Dowty JG, Milne RL, Wong EM, Dugué PA, English D, Hopper JL,
Goldgar DE, Giles GG, Southey MC, kConFab.  Heritable DNA methylation marks
associated with susceptibility to breast cancer.  Nat Commun. 2018
Feb 28;9(1):867. \url{https://doi.org/10.1038/s41467-018-03058-6}
}
