library(hergm) # Load library: see help(package = "hergm") 
data(example) # Load data: see ?example
name <- "example"
mcmc <- hergm( # See ?hergm
     d ~ edges_i(2), # Formula: network ~ terms: see ?network, ?hergm.terms, ?edges_i; here, the maximum number of blocks is 2
     alpha_shape = 1.0, # Hyperprior: shape parameter of Gamma prior of scaling parameter
     alpha_rate = 1.0, # Hyperprior: rate (inverse scale) parameter of Gamma prior of scaling parameter
     eta_mean_mean = 0.0, # Hyperprior: mean of mean of Gaussian base distribution
     eta_mean_sd = 10.0, # Hyperprior: standard deviation of mean of Gaussian base distribution
     eta_precision_shape = 1.0, # Hyperprior: shape of Gamma prior of precision of Gaussian base distribution
     eta_precision_rate = 0.1, # Hyperprior: rate (inverse scale) of Gamma prior of precision of Gaussian base distribution
     seeds = c(3395,1664482,4095377,1473557,9170474,6344540,3736735,692447,3227407,3237189), # Seed of pseudo-random number generator; if computing is parallel, number of seeds must equal number of processors
     samplesize = 120000, # If simulate == TRUE, number of networks to be sampled, otherwise number of draws from posterior; if computing is parallel, number of draws per processor
     name = name, # If output == TRUE, name of project is used to name output files
     )
processed_mcmc <- hergm.postprocess( # See ?hergm.postprocess
     sample = mcmc, # MCMC sample generated by function hergm
     burnin = 1000, # If simulate == FALSE, number of burn-in iterations; if parallel > 1, number of burn-in iterations per processor
     relabel = TRUE, # Relabel MCMC sample
     name = name # If output == TRUE, name of project is used to name output files
     )
save(mcmc, processed_mcmc, file = paste(name, ".Rdata", sep = ""))
