% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_fisheye.R
\name{import_fisheye}
\alias{import_fisheye}
\alias{list.cameras}
\title{Import a fisheye image as a single channel raster, and apply a circular mask}
\usage{
import_fisheye(
  filename,
  channel = 3,
  circ.mask = NULL,
  circular = TRUE,
  gamma = 2.2,
  stretch = FALSE,
  display = FALSE,
  message = TRUE
)
}
\arguments{
\item{filename}{Character. The input image filename.}

\item{channel}{Character. Either the band number corresponding to an image channel or a mixing channel method (Available options are: 'first','GLA','Luma','2BG','BtoRG','B','GEI','RGB'). Default is 3 (Blue channel).}

\item{circ.mask}{List. The circular mask parameters (xc,yc,rc) to be applied to the image. It can be created from a list of available cameras using the \code{\link[=camera_fisheye]{camera_fisheye()}} function. If omitted, it is created automatically in circular images, and corresponds to half the lower image side.}

\item{circular}{Logical. It indicates if the fisheye image is circular (circular=TRUE) or fullframe (circular=FALSE) type. This influences the way the radius is calculated if circ.mask is not inserted. Default is circular.}

\item{gamma}{Numeric. It indicates the input gamma, which is then back-corrected to unity. Default is 2.2 (typical in jpeg images). If no gamma is required, just set gamma=1.}

\item{stretch}{Logical. It indicates if a linear stretch should be applied to enhance contrast. Default FALSE.}

\item{display}{Logical. If is set to TRUE, it plots the image along with the applied mask and a circle radius. Default to FALSE.}

\item{message}{Logical. If is set to TRUE, it prints the mask used for importing the image. Default to TRUE.}
}
\value{
A single-channel image (SpatRaster).
}
\description{
This function imports fisheye images using \code{\link[terra:rast]{terra::rast()}} functionality, by selecting a single channel, or a combination of channels.
The default option (blue channel) is generally preferred for canopy image analysis as it enables high contrast between canopy and sky pixels, which ease image thresholding.
A circular mask is then applied to mask outside pixel in case of circular fisheye images. It can be manually inserted, or retrieved using the \code{\link[=camera_fisheye]{camera_fisheye()}} function.
Alternatively, it is automatically calculated. Additional functions include a gamma correction and a contrast stretch.
}
\examples{
\donttest{
c.im<-system.file('extdata/circular_coolpix4500+FC-E8_chestnut.jpg',package='hemispheR')

#set the circular mask automatically:
import_fisheye(c.im,circ.mask=list(xc=1136,yc=850,rc=754),channel='B',gamma=2.2,display=TRUE)

#list of cameras for circular mask:
list.cameras

#set the circular mask using camera_fisheye():
import_fisheye(c.im,circ.mask=camera_fisheye('Coolpix4500+FC-E8'), gamma=2.2)

#automatic calculating circular mask:
import_fisheye(c.im,channel='B',gamma=2.2,display=TRUE)

#import a fullframe image:
f.im<-system.file('extdata/fullframe_D90_Nikkor-10.5_beech.jpg',package='hemispheR')
import_fisheye(f.im,circular=FALSE,channel='B',gamma=2.2,display=TRUE)
}
}
