% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hellmer-core.R
\name{process_future}
\alias{process_future}
\title{Process prompts in parallel chunks with error handling and state management}
\usage{
process_future(
  chat_obj,
  prompts,
  type_spec,
  judgements,
  state_path,
  workers,
  chunk_size,
  plan,
  max_chunk_attempts,
  max_retries,
  initial_delay,
  max_delay,
  backoff_factor,
  beep,
  progress,
  echo,
  ...
)
}
\arguments{
\item{chat_obj}{Chat model object for API calls}

\item{prompts}{Vector or list of prompts to process}

\item{type_spec}{Optional type specification for structured data extraction}

\item{judgements}{Number of judgements for structured data extraction resulting in refined data}

\item{state_path}{Path to save intermediate state}

\item{workers}{Number of parallel workers}

\item{chunk_size}{Number of prompts to process in parallel at a time}

\item{plan}{Parallel backend}

\item{max_chunk_attempts}{Maximum retries per failed chunk}

\item{max_retries}{Maximum retries per prompt}

\item{initial_delay}{Initial delay before first retry}

\item{max_delay}{Maximum delay between retries}

\item{backoff_factor}{Delay multiplier after each retry}

\item{beep}{Play sound on completion/error}

\item{progress}{Whether to show progress bars}
}
\value{
Batch results object
}
\description{
Process prompts in parallel chunks with error handling and state management
}
\keyword{internal}
