% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_eval.R
\name{run_sensitivity}
\alias{run_sensitivity}
\title{Run Sensitivity Analysis}
\usage{
run_sensitivity(model, sensitivity)
}
\arguments{
\item{model}{An evaluated Markov model}

\item{sensitivity}{An object returned by 
\code{\link{define_sensitivity}}.}
}
\value{
A \code{data.frame} with one row per model and 
  parameter value.
}
\description{
Run Sensitivity Analysis
}
\examples{
# running a single model

param <- define_parameters(
  p1 = .5,
  p2 = .2
)
mod1 <-
  define_model(
    transition_matrix = define_matrix(
      C, p1,
      p2, C
    ),
    define_state(
      cost = 543,
      ly = 1
    ),
    define_state(
      cost = 432,
      ly = .5
    )
  )

mod2 <-
  define_model(
    transition_matrix = define_matrix(
      C, p1,
      p2, C
    ),
    define_state(
      cost = 789,
      ly = 1
    ),
    define_state(
      cost = 456,
      ly = .8
    )
  )

res2 <- run_models(
  mod1, mod2,
  parameters = param,
  init = c(100, 0),
  cycles = 10,
  cost = cost,
  effect = ly
)

ds <- define_sensitivity(
  p1 = c(.1, .9),
  p2 = c(.1, .3)
)
print(ds)

x <- run_sensitivity(res2, ds)

plot(x, value = "cost")
plot(x, value = "icer", type = "difference", model = 2)
}

