% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newdata.R
\name{eval_model_newdata}
\alias{eval_model_newdata}
\title{Iteratively Evaluate a Markov Model With New Parameter 
Values}
\usage{
eval_model_newdata(model, cycles, init, method, newdata)
}
\arguments{
\item{model}{An \code{uneval_model} object.}

\item{cycles}{positive integer. Number of Markov Cycles 
to compute.}

\item{init}{numeric vector, same length as number of 
model states. Number of individuals in each model state
at the beginning.}

\item{method}{Counting method.}

\item{newdata}{a data.frame whose names match parameters 
names. \code{model} will be evaluated iteratively, 
taking successivel values from each row.}
}
\value{
A data.frame containing the values of 
  \code{newdata} and each Markov Model evaluation in 
  \code{res}.
}
\description{
Given a data.frame with on set of new parameters values 
per row, iteratively evaluate the model over the set of 
new values.
}
\details{
New parameters with a missing value (\code{NA}) do not
replace existing parameters.
}
\examples{

\dontrun{
par1 <- define_parameters(
  a = 1,
  b = 1 / (markov_cycle + a)
)

mat1 <- define_matrix(
  1-b, b,
  0, 1
)
mod1 <- define_model(
  parameters = par1,
  transition_matrix = mat1,
  define_state(var = a),
  define_state(var = a * markov_cycle)
)

new_tab <- data.frame(
  a = 1:10
)

eval_model_newdata(
  mod1,
  cycles = 5,
  init = 1:0,
  newdata = new_tab
)
}

}

