% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-fft.R
\name{tidy_fft}
\alias{tidy_fft}
\title{Tidy Style FFT}
\usage{
tidy_fft(
  .data,
  .date_col,
  .value_col,
  .frequency = 12L,
  .harmonics = 1L,
  .upsampling = 10L
)
}
\arguments{
\item{.data}{The data.frame/tibble you will pass for analysis.}

\item{.date_col}{The column that holds the date.}

\item{.value_col}{The column that holds the data to be analyzed.}

\item{.frequency}{The frequency of the data, 12 = monthly for example.}

\item{.harmonics}{How many harmonic waves do you want to produce.}

\item{.upsampling}{The up sampling of the time series.}
}
\value{
A list object returned invisibly.
}
\description{
Perform an fft using \code{\link[stats:fft]{stats::fft()}} and return a tidier style output list with plots.
}
\details{
This function will perform a few different things, but primarily it will
compute the Fast Discrete Fourier Transform (FFT) using \code{\link[stats:fft]{stats::fft()}}. The
formula is given as:
\deqn{y[h] = sum_{k=1}^n z[k]*exp(-2*pi*1i*(k-1)*(h-1)/n)}

There are many items returned inside of a list invisibly. There are four primary
categories of data returned in the list. Below are the primary categories and
the items inside of them.

\strong{data:}
\enumerate{
\item data
\item error_data
\item input_vector
\item maximum_harmonic_tbl
\item differenced_value_tbl
\item dff_tbl
\item ts_obj
}

\strong{plots:}
\enumerate{
\item harmonic_plot
\item diff_plot
\item max_har_plot
\item harmonic_plotly
\item max_har_plotly
}

\strong{parameters:}
\enumerate{
\item harmonics
\item upsampling
\item start_date
\item end_date
\item freq
}

\strong{model:}
\enumerate{
\item m
\item harmonic_obj
\item harmonic_model
\item model_summary
}
}
\examples{
suppressPackageStartupMessages(library(dplyr))

data_tbl <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

a <- tidy_fft(
  .data = data_tbl,
  .value_col = value,
  .date_col = date_col,
  .harmonics = 3,
  .frequency = 12
)

a$plots$max_har_plot
a$plots$harmonic_plot

}
\author{
Steven P. Sanderson II, MPH
}
