% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-model-extraction.R
\name{model_extraction_helper}
\alias{model_extraction_helper}
\title{Model Method Extraction Helper}
\usage{
model_extraction_helper(.fit_object)
}
\arguments{
\item{.fit_object}{A time-series fitted model}
}
\value{
A model description
}
\description{
This takes in a model fit and returns the method of the fit object.
}
\details{
Currently supports forecasting model of one of the following from the
\code{forecast} package:
\itemize{
\item \code{\link[forecast]{Arima}}
\item \code{\link[forecast]{auto.arima}}
\item \code{\link[forecast]{ets}}
\item \code{\link[forecast]{nnetar}}
}
}
\examples{
# NOT RUN
\dontrun{
suppressPackageStartupMessages(library(forecast))
suppressPackageStartupMessages(library(healthyR.data))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(timetk))

data <- healthyR_data \%>\%
    filter(ip_op_flag == "I") \%>\%
    select(visit_end_date_time) \%>\%
    rename(date_col = visit_end_date_time) \%>\%
    summarise_by_time(
        .date_var = date_col
        , .by     = "month"
        , value   = n()
    ) \%>\%
    filter_by_time(
       .date_var     = date_col
       , .start_date = "2012"
       , .end_date   = "2019"
    )

data_ts <- tk_ts(data = data, frequency = 12)

# Create a model
fit_arima  <- auto.arima(data_ts)

model_extraction_helper(fit_arima)
}

}
\author{
Steven P. Sanderson II, MPH
}
