% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tsls.R
\name{tsls}
\alias{tsls}
\title{Two-Stage Least Squares Estimation (TSLS)}
\usage{
tsls(y, d, x, z, intercept = TRUE, homoscedastic = TRUE)
}
\arguments{
\item{y}{outcome variable}

\item{d}{endogenous variables}

\item{x}{exogenous variables}

\item{z}{instruments}

\item{intercept}{logical, if intercept should be included}

\item{homoscedastic}{logical, if homoscedastic (\code{TRUE}, default) or heteroscedastic erros (\code{FALSE}) should be calculated.}
}
\value{
The function returns a list with the following elements \item{coefficients}{coefficients}
\item{vcov}{variance-covariance matrix} \item{residuals}{outcome minus predicted values} \item{call}{function call} \item{samplesize}{sample size}
\item{se}{standard error}
}
\description{
The function does Two-Stage Least Squares Estimation (TSLS).
}
\details{
The function computes tsls estimate (coefficients) and variance-covariance-matrix assuming homoskedasticity
for outcome variable \code{y} where \code{d} are endogenous variables in structural equation, \code{x} are exogensous variables in
structural equation and z are instruments. It returns an object of class \code{tsls} for which the methods \code{print} and \code{summary}
are provided.
}
\keyword{2SLS}
\keyword{Endogeneity}
\keyword{Instrumental}
\keyword{TSLS}
\keyword{Variables}

