% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rlassoIVselectX.R
\name{rlassoIVselectX}
\alias{rlassoIVselectX}
\title{Instrumental Variable Estimation with Selection on the exogenous Variables by Lasso}
\usage{
rlassoIVselectX(x, d, y, z, post = TRUE, ...)
}
\arguments{
\item{x}{exogenous variables in the structural equation (matrix)}

\item{d}{endogenous variables in the structural equation (vector or matrix)}

\item{y}{outcome or dependent variable in the structural equation (vector or matrix)}

\item{z}{set of potential instruments for the endogenous variables.}

\item{post}{logical. If \code{TRUE}, post-lasso estimation is conducted.}

\item{\dots}{arguments passed to the function \code{rlasso}}
}
\value{
An object of class \code{rlassoIVselectX} containing at least the following
components: \item{coefficients}{estimated parameter vector}
\item{vcov}{variance-covariance matrix} \item{residuals}{
residuals} \item{samplesize}{sample size}
}
\description{
This function estimates the coefficient of an endogenous variable by employing Instrument Variables in a setting where the exogenous variables are high-dimensional and hence
selection on the exogenous variables is required.
The function returns an element of class \code{rlassoIVselectX}
}
\details{
The implementation is a special case of of Chernozhukov et al. (2015).
The option \code{post=TRUE} conducts post-lasso estimation for the Lasso estimations, i.e. a refit of the
model with the selected variables. If variables of the exogenous variables in
\code{x} should be used as instruments, they have to be added to the
instrument set \code{z} explicitly.
}
\references{
Chernozhukov, V., Hansen, C. and M. Spindler (2015). Post-Selection and Post-Regularization Inference in Linear
Models with Many Controls and Instruments
\emph{American Economic Review, Papers and Proceedings} 105(5), 486--490.
}
\keyword{Hig-dimensional}
\keyword{Instrumental}
\keyword{Lasso}
\keyword{Variables}
\keyword{setting}

