% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hawkes.R
\name{plot.inhpois}
\alias{plot.inhpois}
\title{Plot of a simulated inhomogeneous Poisson process}
\usage{
\method{plot}{inhpois}(x, precision = 1000, ...)
}
\arguments{
\item{x}{A simulated inhomogeneous Poisson process.}

\item{precision}{(default = 1e3) Number of points to plot.}

\item{...}{Only there to fit the declaration of S3 method \code{plot}.}
}
\value{
None
}
\description{
Plots a simulated inhomogeneous Poisson process, highlighting the steps used in Ogata's thinning algorithm.
}
\examples{
# Simulate an inhomogeneous Poisson process with function intensity 1 + sin(x)
x <- inhpois(end=10, fun=function(y) {1 + sin(y)}, M=2)
plot(x)
}
