% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lord_vote_record.R
\name{lord_vote_record}
\alias{lord_vote_record}
\alias{hansard_lord_vote_record}
\title{Voting record of members of the House of Lords}
\usage{
lord_vote_record(peer_id = NULL, lobby = "all", start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case", verbose = TRUE)

hansard_lord_vote_record(peer_id = NULL, lobby = "all",
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)
}
\arguments{
\item{peer_id}{The ID number of a member of the House of Lords. A value
must be included for this parameter. Use the \code{\link{lords_members}}
to find IDs for members of the House of Lords. Defaults to \code{NULL}.}

\item{lobby}{Accepts one of \code{'all'}, \code{'content'},
\code{'notcontent'}. \code{'content'} returns votes where the peer voted
'Content', \code{'notcontent'} returns votes where the peer voted
'Not Content' and \code{'all'} returns all available votes by the peer.
This parameter is not case sensitive. Defaults to \code{'all'}.}

\item{start_date}{Only includes divisions on or after this date. Accepts
character values in \code{'YYYY-MM-DD'} format, and objects of class
\code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything
else that can be coerced to a date with \code{as.Date()}.
Defaults to \code{'1900-01-01'}.}

\item{end_date}{Only includes divisions on or before this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to the current system date.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'}
and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, returns data to console on the progress
of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details on the voting record of a
member of the House of Lords.
}
\description{
Accepts an ID number for a member of the House of Commons, and returns a
tibble of their votes.
}
\examples{
\dontrun{
x <- lord_vote_record(530, lobby='all')

x <- lord_vote_record(530, lobby='content')

x <- lord_vote_record(530, lobby='notcontent')

x <- lord_vote_record(530, lobby='not-content')
# This will also work
}
}
