% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_distances.R
\name{graphToPrototype}
\alias{graphToPrototype}
\title{Convert graph to a prototype}
\usage{
graphToPrototype(graph, numPathCuts = 8)
}
\arguments{
\item{graph}{A graph from a handwriting sample}

\item{numPathCuts}{Number of segments to cut the path(s) into}
}
\value{
List of pathEnds, pathQuarters, and pathCenters given as (x,y)
  coordinates with the graph centroid at (0,0). The returned list also
  contains path lengths. pathQuarters gives the (x,y) coordinates of the path
  at the cut points and despite the name, the path might not be cut into
  quarters.
}
\description{
A graph prototype consists of the starting and ending points of each path in
the graph, as well as and evenly spaced points along each path. The prototype
also stores the center point of the graph. All points are represented as
xy-coordinates and the center point is at (0,0).
}
