% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haldensify.R
\name{fit_haldensify}
\alias{fit_haldensify}
\title{Fit conditional density estimation for a sequence of HAL models}
\usage{
fit_haldensify(
  A,
  W,
  wts = rep(1, length(A)),
  grid_type = "equal_range",
  n_bins = 20,
  cv_folds = 5,
  lambda_seq = exp(seq(-1, -13, length = 1000))
)
}
\arguments{
\item{A}{The \code{numeric} vector of observed values.}

\item{W}{A \code{data.frame}, \code{matrix}, or similar giving the values of
baseline covariates (potential confounders) for the observed units. These
make up the conditioning set for the conditional density estimate.}

\item{wts}{A \code{numeric} vector of observation-level weights. The default
is to weight all observations equally.}

\item{grid_type}{A \code{character} indicating the strategy to be used in
creating bins along the observed support of \code{A}. For bins of equal
range, use \code{"equal_range"}; consult the documentation of
\code{\link[ggplot2]{cut_interval}} for more information. To ensure each
bin has the same number of observations, use \code{"equal_mass"}; consult
the documentation of \code{\link[ggplot2]{cut_number}} for details.}

\item{n_bins}{This \code{numeric} value indicates the number(s) of bins into
which the support of \code{A} is to be divided.}

\item{cv_folds}{A \code{numeric} indicating the number of cross-validation
folds to be used in fitting the sequence of HAL conditional density models.}

\item{lambda_seq}{A \code{numeric} sequence of values of the regularization
parameter of Lasso regression; passed to \code{\link[hal9001]{fit_hal}}.}
}
\value{
A \code{list}, containing density predictions for the sequence of
 fitted HAL models; the index and value of the L1 regularization parameter
 minimizing the density loss; and the sequence of empirical risks for the
 sequence of fitted HAL models.
}
\description{
Fit conditional density estimation for a sequence of HAL models
}
\details{
Estimation of the conditional density A|W via a cross-validated
 highly adaptive lasso, used to estimate the conditional hazard of failure
 in a given bin over the support of A.
}
\examples{
# simulate data: W ~ U[-4, 4] and A|W ~ N(mu = W, sd = 0.5)
n_train <- 50
w <- runif(n_train, -4, 4)
a <- rnorm(n_train, w, 0.5)
# fit cross-validated HAL-based density estimator of A|W
fit_cv_haldensify <- fit_haldensify(
  A = a, W = w, n_bins = 3,
  lambda_seq = exp(seq(-1, -10, length = 50))
)
}
