% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{get_children}
\alias{get_children}
\title{get child H3 cell indices}
\usage{
get_children(h3_address = NULL, res = NULL, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character index generated by H3.}

\item{res}{Integer; Desired H3 resolution. See
\url{https://h3geo.org/docs/core-library/restable/} for allowable values and related dimensions.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, a list of \code{length(h3_address)}. Each list element contains
  a vector of H3 cell indexes.
}
\description{
This function returns the children of a particular H3 cell at the
requested resolution.
}
\note{
The number of cells returned for each request is \code{7 ^ (parent_res -
  child_res)}, so jumping three levels will return 343 indexes per request.
  This can cause memory issues with larger requests.
}
\examples{
# What are the children of this resolution 6 cell index at resolution 8?
get_children(h3_address = '86be8d12fffffff', res = 8)
}
