% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predict.h2o4gpu_model}
\alias{predict.h2o4gpu_model}
\title{Make Predictions using Trained H2O4GPU Estimator}
\usage{
\method{predict}{h2o4gpu_model}(object, x, type = "raw", ...)
}
\arguments{
\item{object}{The h2o4gpu model object}

\item{x}{The new data where each column represents a different predictor variable to
be used in generating predictions.}

\item{type}{One of "raw" or "prob", indicating the type of output: predicted values or probabilities}

\item{...}{Additional arguments (unused for now).}
}
\description{
This function makes predictions from new data using a trained H2O4GPU model and returns class predictions
for classification and predicted values for regression.
}
\examples{
\dontrun{

library(h2o4gpu)

# Setup dataset
x <- iris[1:4]
y <- as.integer(iris$Species) - 1

# Initialize and train the classifier
model <- h2o4gpu.random_forest_classifier() \%>\% fit(x, y)

# Make predictions
predictions <- model \%>\% predict(x)

}

}
